% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBorders.R
\name{getBorders}
\alias{getBorders}
\title{Extract SpatialPolygonsDataFrame Borders}
\usage{
getBorders(spdf, spdfid = NULL)
}
\arguments{
\item{spdf}{a SpatialPolygonsDataFrame. This SpatialPolygonsDataFrame
has to be projected (planar coordinates).}

\item{spdfid}{identifier field in spdf, default to the first column 
of the spdf data frame. (optional)}
}
\value{
A SpatialLinesDataFrame of borders is returned. This object has three 
id fields: id, id1 and id2.
id1 and id2 are ids of units that neighbour a border; id is the concatenation 
of id1 and id2 (with "_" as separator).
}
\description{
Extract borders between SpatialPolygonsDataFrame units.
}
\note{
getBorders and getOuterBorders can be combined with rbind.
}
\examples{
data(nuts2006)
# Get units borders
nuts0.contig.spdf <- getBorders(nuts0.spdf)
# Plot Countries
plot(nuts0.spdf, border = NA, col = "grey60")
# Plot borders
plot(nuts0.contig.spdf, 
     col = sample(x = rainbow(nrow(nuts0.contig.spdf))), 
     lwd = 3, add = TRUE)
}
\seealso{
\link{discLayer}, \link{getOuterBorders}
}

