% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caretStack.R
\name{dotplot.caretStack}
\alias{dotplot.caretStack}
\title{Comparison dotplot for a caretStack object}
\usage{
\method{dotplot}{caretStack}(x, ...)
}
\arguments{
\item{x}{An object of class caretStack}

\item{...}{passed to dotplot}
}
\description{
This is a function to make a dotplot from a caretStack. It uses dotplot from the
caret package on all the models in the ensemble, excluding the final ensemble model.At the moment,
this function only works if the ensembling model has the same number of resamples as the component models.
}
\examples{
set.seed(42)
models <- caretList(
  x = iris[1:100, 1:2],
  y = iris[1:100, 3],
  methodList = c("rpart", "glm")
)
meta_model <- caretStack(models, method = "lm")
lattice::dotplot(meta_model)
}
