% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shuffle_ard.R
\name{shuffle_ard}
\alias{shuffle_ard}
\title{Shuffle ARD}
\usage{
shuffle_ard(x, trim = TRUE)
}
\arguments{
\item{x}{(\code{data.frame})\cr
an ARD data frame of class 'card'}

\item{trim}{(\code{logical})\cr
logical representing whether or not to trim away statistic-level metadata and filter
only on numeric statistic values.}
}
\value{
a tibble
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr

This function ingests an ARD object and shuffles the information to prepare for analysis.
Helpful for streamlining across multiple ARDs. Combines each group/group_level into 1
column, back fills missing grouping values from the variable levels where possible, and
optionally trims statistics-level metadata.
}
\examples{
bind_ard(
  ard_tabulate(ADSL, by = "ARM", variables = "AGEGR1"),
  ard_tabulate(ADSL, variables = "ARM")
) |>
  shuffle_ard()
}
