% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_capture_conditions.R
\name{eval_capture_conditions}
\alias{eval_capture_conditions}
\alias{captured_condition_as_message}
\alias{captured_condition_as_error}
\title{Evaluate and Capture Conditions}
\usage{
eval_capture_conditions(expr, data = NULL, env = caller_env())

captured_condition_as_message(
  x,
  message = c("The following {type} occured:", x = "{condition}"),
  type = c("error", "warning"),
  envir = rlang::current_env()
)

captured_condition_as_error(
  x,
  message = c("The following {type} occured:", x = "{condition}"),
  type = c("error", "warning"),
  call = get_cli_abort_call(),
  envir = rlang::current_env()
)
}
\arguments{
\item{expr}{An \link[rlang:topic-defuse]{expression} or
\link[rlang:topic-quosure]{quosure} to evaluate.}

\item{data}{A data frame, or named list or vector. Alternatively, a
data mask created with \code{\link[rlang:as_data_mask]{as_data_mask()}} or
\code{\link[rlang:new_data_mask]{new_data_mask()}}. Objects in \code{data} have priority over those in
\code{env}. See the section about data masking.}

\item{env}{The environment in which to evaluate \code{expr}. This
environment is not applicable for quosures because they have
their own environments.}

\item{x}{(\code{captured_condition})\cr
a captured condition created by \code{eval_capture_conditions()}.}

\item{message}{(\code{character})\cr
message passed to \code{cli::cli_inform()} or \code{cli::cli_abort()}. The condition
being printed is saved in an object named \code{condition}, which should be
included in this message surrounded by curly brackets.}

\item{type}{(\code{string})\cr
the type of condition to return. Must be one of \code{'error'} or \code{'warning'}.}

\item{envir}{Environment to evaluate the glue expressions in.}

\item{call}{(\code{environment})\cr
Execution environment of currently running function. Default is
\code{get_cli_abort_call()}.}
}
\value{
a named list
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}\cr
\strong{\code{eval_capture_conditions()}}

Evaluates an expression while also capturing error and warning conditions.
Function always returns a named list \code{list(result=, warning=, error=)}.
If there are no errors or warnings, those elements will be \code{NULL}.
If there is an error, the result element will be \code{NULL}.

Messages are neither saved nor printed to the console.

Evaluation is done via \code{\link[rlang:eval_tidy]{rlang::eval_tidy()}}. If errors and warnings are produced
using the \code{{cli}} package, the messages are processed with \code{cli::ansi_strip()}
to remove styling from the message.

\strong{\code{captured_condition_as_message()}/\code{captured_condition_as_error()}}

These functions take the result from \code{eval_capture_conditions()} and return
errors or warnings as either messages (via \code{cli::cli_inform()}) or
errors (via \code{cli::cli_abort()}). These functions handle cases where the
condition messages may include curly brackets, which would typically cause
issues when processed with the \verb{cli::cli_*()} functions.

Functions return the \code{"result"} from \code{eval_capture_conditions()}.
}
\examples{
# function executes without error or warning
eval_capture_conditions(letters[1:2])

# an error is thrown
res <- eval_capture_conditions(stop("Example Error!"))
res
captured_condition_as_message(res)

# if more than one warning is returned, all are saved
eval_capture_conditions({
  warning("Warning 1")
  warning("Warning 2")
  letters[1:2]
})

# messages are not printed to the console
eval_capture_conditions({
  message("A message!")
  letters[1:2]
})
}
