% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_dichotomous.R
\name{ard_dichotomous}
\alias{ard_dichotomous}
\title{Dichotomous ARD Statistics}
\usage{
ard_dichotomous(
  data,
  variables,
  by = dplyr::group_vars(data),
  strata = NULL,
  value = maximum_variable_value(data[variables]),
  statistic = everything() ~ categorical_summary_fns(),
  denominator = NULL,
  fmt_fn = NULL,
  stat_label = everything() ~ default_stat_labels()
)
}
\arguments{
\item{data}{(\code{data.frame})\cr
a data frame}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries. Default is \code{everything()}.}

\item{by, strata}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to tabulate by/stratify by for tabulation.
Arguments are similar, but with an important distinction:

\code{by}: results are tabulated by \strong{all combinations} of the columns specified,
including unobserved combinations and unobserved factor levels.

\code{strata}: results are tabulated by \strong{all \emph{observed} combinations} of the
columns specified.

Arguments may be used in conjunction with one another.}

\item{value}{(named \code{list})\cr
named list of dichotomous values to tabulate. Default is \code{maximum_variable_value(data)},
which returns the largest/last value after a sort.}

\item{statistic}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \code{list(mpg = categorical_summary_fns())}.}

\item{denominator}{(\code{data.frame}, \code{integer})\cr
Specify this \emph{optional} argument to change the denominator,
e.g. the \code{"N"} statistic. Default is \code{NULL}. See below for details.}

\item{fmt_fn}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) round(x, digits = 2) |> as.character))}.}

\item{stat_label}{(\code{\link[=syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where
the list element is either a named list or a list of formulas defining the
statistic labels, e.g. \code{everything() ~ list(n = "n", p = "pct")} or
\code{everything() ~ list(n ~ "n", p ~ "pct")}.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Compute Analysis Results Data (ARD) for dichotomous summary statistics.
}
\examples{
ard_dichotomous(mtcars, by = vs, variables = c(cyl, am), value = list(cyl = 4))

mtcars |>
  dplyr::group_by(vs) |>
  ard_dichotomous(
    variables = c(cyl, am),
    value = list(cyl = 4),
    statistic = ~ categorical_summary_fns("p")
  )
}
