% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{get_missing_capl_variables}
\alias{get_missing_capl_variables}
\title{Add required CAPL-2 variables to a data frame of raw data if they are missing.}
\usage{
get_missing_capl_variables(raw_data = NULL)
}
\arguments{
\item{raw_data}{a data frame of raw CAPL-2 data.}
}
\value{
returns a merged data frame of raw data and missing required CAPL-2 variables (values are set to NA).
}
\description{
This function adds required CAPL-2 variables (see Details for a full list) to a data frame of raw data if they are missing. When missing
variables are added, the values for a given missing variable are set to NA. This function is called within \code{\link[=get_capl]{get_capl()}} so that CAPL-2 score and
interpretation computations will run without errors in the presence of missing variables.
}
\details{
The required CAPL-2 variables include:
\itemize{
\item age
\item gender
\item pacer_lap_distance
\item pacer_laps
\item plank_time
\item camsa_skill_score1
\item camsa_time1
\item camsa_skill_score2
\item camsa_time2
\item steps1
\item time_on1
\item time_off1
\item non_wear_time1
\item steps2
\item time_on2
\item time_off2
\item non_wear_time2
\item steps3
\item time_on3
\item time_off3
\item non_wear_time3
\item steps4
\item time_on4
\item time_off4
\item non_wear_time4
\item steps5
\item time_on5
\item time_off5
\item non_wear_time5
\item steps6
\item time_on6
\item time_off6
\item non_wear_time6
\item steps7
\item time_on7
\item time_off7
\item non_wear_time7
\item self_report_pa
\item csappa1
\item csappa2
\item csappa3
\item csappa4
\item csappa5
\item csappa6
\item why_active1
\item why_active2
\item why_active3
\item feelings_about_pa1
\item feelings_about_pa2
\item feelings_about_pa3
\item pa_guideline
\item crt_means
\item ms_means
\item sports_skill
\item pa_is
\item pa_is_also
\item improve
\item increase
\item when_cooling_down
\item heart_rate
}

Examining the structure (see \code{\link[=str]{str()}}) of some CAPL-2 demo data (see \code{\link[=get_capl_demo_data]{get_capl_demo_data()}}) provides additional information about these variables.
}
\examples{
raw_data <- get_missing_capl_variables(raw_data)

}
