% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/capl.R
\name{get_capl_interpretation}
\alias{get_capl_interpretation}
\title{Compute a CAPL-2 interpretation for a given CAPL-2 protocol or domain score.}
\usage{
get_capl_interpretation(age = NA, gender = NA, score = NA, protocol = NA)
}
\arguments{
\item{age}{A numeric vector (valid values are between 8 and 12).}

\item{gender}{A character vector (valid values currently include "girl", "g", "female", "f", "boy", "b", "male", "m").}

\item{score}{A numeric vector. If the \code{protocol} argument is set to "pacer" or "steps", this argument must contain integers.}

\item{protocol}{A character vector representing a CAPL protocol (valid values include "pacer", "plank", "camsa", "pc", "steps",
"self_report_pa", "db", "mc", "ku", "capl"; valid values are not case-sensitive).}
}
\value{
Returns a character vector with values of "beginning", "progressing", "achieving" or "excelling" (if valid) or NA (if not valid).
}
\description{
This function computes an age- and gender-specific CAPL-2 interpretation for a given CAPL-2 protocol or domain score (e.g., \code{pc_interpretation}).
}
\details{
Other \code{capl} functions called by this function include: \code{\link[=validate_age]{validate_age()}}, \code{\link[=validate_gender]{validate_gender()}}, \code{\link[=validate_character]{validate_character()}}, \code{\link[=validate_number]{validate_number()}} and
\code{\link[=validate_scale]{validate_scale()}}. This function will check whether a score for a given protocol is within a valid range; if not, NA will be returned.
}
\examples{
get_capl_interpretation(
  age = 7:13, 
  gender = c("g", "g", "b", "Boy", "m", "f", "Female"), 
  score = c(50, 25, 100, 5, 150, 23, 78), 
  protocol = "pacer"
)

# [1] NA            "achieving"   "excelling"   "beginning"   "excelling"   "progressing"
# [7] NA

}
