% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_eigentraits.R
\name{select_eigentraits}
\alias{select_eigentraits}
\title{Assign selected eigentraits in the Cape object}
\usage{
select_eigentraits(data_obj, traits_which = c(1, 2))
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{traits_which}{A vector of integers, of at least length two
specifying which eigentraits should be analyzed.}
}
\value{
updated \code{\link{Cape}} object
}
\description{
This function is used to identify which eigentraits
will be analyzed in the Cape run. After eigentrait 
decomposition of n traits, there will be n eigentraits.
If there are more than two eigentraits, the user may
wish to analyze a subset of them. This function specifies
which of the eigentraits will be analyzed by Cape. It does
this by subsetting the ET matrix to only those eigentraits
specified. The traits not selected are deleted from the object.
}
\examples{
\dontrun{
data_obj <- selecct_eigentraits(data_obj, traits_which = 1:3)
}

}
\seealso{
\code{\link{plot_svd}}
}
