% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinship.R
\name{kinship}
\alias{kinship}
\title{Calculate the kinship matrix}
\usage{
kinship(
  data_obj,
  geno_obj,
  type = c("overall"),
  n_cores = 4,
  pop = c("MPP", "2PP", "RIL"),
  results_path = NULL
)
}
\arguments{
\item{data_obj}{a \code{\link{Cape}} object}

\item{geno_obj}{a genotype object}

\item{type}{type of  kinship correction. Default is overall.}

\item{n_cores}{The number of cores. Defaults to 4.}

\item{pop}{population type, "MPP" (multi-parental population), 
"2PP" (2 parents), "RIL" (recombinant inbred line)}

\item{results_path}{Optional path to where temporary files will be saved. 
If NULL, the path is taken from data_obj$results_path.}
}
\value{
This function returns an n by n matrix, where 
n is the number of individuals in the test population. 
The entries of the matrix represent the level of relatedness
between pairs of individuals. For more information see
Kang, H. M. et al. Efficient control of population 
structure in model organism association mapping. Genetics 
178, 1709–1723 (2008).
}
\description{
This function produces a realized relationship matrix 
(kinship matrix) for use in adjusting for the effect 
of inbred relatedness. We use the R/qtl2 function
calc_kinship.
}
\details{
Broman KW, Gatti DM, Simecek P, Furlotte NA, Prins P, 
Sen Ś, Yandell BS, Churchill GA (2018) R/qtl2: software
for mapping quantitative trait loci with high-dimensional 
data and multi-parent populations. Genetics
211:495-502 doi:10.1534/genetics.118.301595

This uses the function probs_doqtl_to_qtl2 
from qtl2convert:
Karl W Broman (2019). qtl2convert: Convert Data 
among R/qtl2, R/qtl, and DOQTL. 
\url{https://kbroman.org/qtl2/},
\url{https://github.com/rqtl/qtl2convert/}.
And genoprob_to_alleleprob from qtl2.
}
