% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kin_adjust.R
\name{kin_adjust}
\alias{kin_adjust}
\title{Corrects genotypes, phenotypes, and covariates
for kinship.}
\usage{
kin_adjust(
  kin_obj,
  geno,
  chr1 = NULL,
  chr2 = NULL,
  phenoV = NULL,
  covarV = NULL,
  verbose = FALSE
)
}
\arguments{
\item{kin_obj}{The kinship object calculated by \code{\link{kinship}}}

\item{geno}{a genotype object.}

\item{chr1}{The first of two chromosomes to leave out of the calculation, if any.}

\item{chr2}{The second of two chromosomes to leave out of the calculation, if any.}

\item{phenoV}{The phenotype vector}

\item{covarV}{The covariate vector or matrix}

\item{verbose}{A logical value indicating whether to print progress to the screen}
}
\value{
This function returns a list with the corrected phenotype,
genotypes, and covariates. These are used in \code{\link{singlescan}}
and \code{\link{pairscan_kin}}.
}
\description{
This function uses linear mixed models to adjust the
genotype matrix, phenotype matrix, and covariate matrix
for kinship based on the kinship matrix calculated 
by \code{\link{kinship}}.
}
\details{
If using leave-one-chromosome-out (LOCO), chr1 and chr2 should have the same value.
If chr1 and chr2 are different, both specified, leave-two-chromosomes-out (LTCO) will be
used. After testing LTCO, we do not recommend using this method. We instead recommend 
always using the overall kinship correction. In this case, both chr1 and chr2 should
be NULL, their default values.
}
\keyword{internal}
