\name{marker2covar}
\alias{marker2covar}
%- Also NEED an \alias for EACH other topic documented here.
\title{ 
	Create a covariate from a genetic marker.
	}
\description{
Covariates can be derived from either genetic markers or phenotypic values. This function generates covariates from genetic markers. These covariates are treated distinctly from those generated from phenotypic values. For example, they are used in kinship calculations. The are also plotted in their original positions, rather than placed at the end as the phenotypic covariates are.
}
\usage{
marker2covar(data.obj, geno.obj = NULL, 
singlescan.obj = NULL, covar.thresh = NULL, 
markers = NULL)
}

\arguments{
  \item{data.obj}{
	The object in which all results are stored. See \code{\link{read.population}}.
	}
\item{geno.obj}{
	The object in which the genotype matrix and marker information are stored. See \code{\link{read.geno}}.
	}
\item{singlescan.obj}{
	The results of the singlescan generated by \code{\link{singlescan}}
	}
\item{covar.thresh}{
	Genetic markers can be selected as covariates based on their standardized effect sizes in the singlescan. covar.thresh indicates the standardized effect size threshold for generating covariates. All markers with standardized effect sizes above this value will be converted to covariates.
	}
\item{markers}{
	A vector of names or numbers indicating which genetic markers should be converted to covariates.
	}
}
\value{
Returns the data object with two additional elements.
\item{g.covar.table}{A table of the covariates and their values.}
\item{g.covar}{A table with positional information for each covariate. The table contains three rows indicating each covariate's name, chromosome, and chromosomal position.}
}
% Add one or more standard keywords, see file KEYWORDS in the
% R documentation directory.
\keyword{manip}
\seealso{
\code{\link{pheno2covar}}
}
