/**
 * CanvasXpress 18.8 - JavaScript Canvas Library
 * 
 * Copyright (c) 2009-2018 Isaac Neuhaus
 * 
 * imnphd@gmail.com
 * 
 * 
 * Redistributions of this source code must retain this copyright notice and the following disclaimer.
 * 
 * CanvasXpress is licensed under the terms of the Open Source GPL version 3.0 license.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * Please see a copy of the GNU General Public License at http://www.gnu.org/licenses.
 * 
 * Commercial use may be granted to the extent that this source code does NOT become part of any other Open Source or Commercially licensed development library or toolkit without explicit permission.
 * Please contact me for additional information.
 * 
 * Thanks to Mingyi Liu for his contributions with the Ext-JS panel and network graphs and Charles Tilford for his input to the Genome Browser.
 * 
 */
/**
 * 
 * canvas.text.js
 * @projectDescription An cross-browser implementation of the HTML5 <canvas> text methods 
 * @author Fabien M�nager 
 * @version $Revision: 1.4 $ 
 * @license MIT License <http://www.opensource.org/licenses/mit-license.php> 
 * 
 * Known issues: 
 * - The 'light' font weight is not supported, neither is the 'oblique' font style. 
 * - Optimize the different hacks (for Opera9) 
 * 
 ****
 *
 * HeyGraph by Tom Martin
 * 
 * Copyright (c) 2010 Tom Martin
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 * 
 * sprintf() for JavaScript v.0.4
 *
 * Copyright (c) 2007 Alexandru Marasteanu <http://alexei.417.ro/>
 * Thanks to David Baird (unit test and patch).
 *
 * This program is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 59 Temple
 * Place, Suite 330, Boston, MA 02111-1307 USA
 *
 ***
 * 
 * Date Format 1.2.3
 * (c) 2007-2009 Steven Levithan <stevenlevithan.com>
 * MIT license
 *
 * Includes enhancements by Scott Trenda <scott.trenda.net>
 * and Kris Kowal <cixar.com/~kris.kowal/>
 *
 * Accepts a date, a mask, or a date and a mask.
 * Returns a formatted version of the given date.
 * The date defaults to the current date/time.
 * The mask defaults to dateFormat.masks.default.
 *
 ****
 *
 * canvas_wrapper.js
 * Canvas doesn't support getCoords() which I really need....
 * So I made a wrapper, code mostly taken from excanvas.js by Google - http://code.google.com/p/explorercanvas/
 * alias some functions to make (compiled) code shorter
 *
 ****
 *
 * conrec.js
 * Copyright (c) 2010, Jason Davies.
 *
 * All rights reserved.  This code is based on Bradley White's Java version,
 * which is in turn based on Nicholas Yue's C++ version, which in turn is based
 * on Paul D. Bourke's original Fortran version.  See below for the respective
 * copyright notices.
 *
 * See http://paulbourke.net/papers/conrec for the original
 * paper by Paul D. Bourke.
 *
 * The vector conversion code is based on http://apptree.net/conrec.htm by
 * Graham Cox.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of the <organization> nor the
 *       names of its contributors may be used to endorse or promote products
 *       derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * conrec.js
 * Copyright (c) 1996-1997 Nicholas Yue
 *
 * This software is copyrighted by Nicholas Yue. This code is based on Paul D.
 * Bourke's CONREC.F routine.
 *
 * The authors hereby grant permission to use, copy, and distribute this
 * software and its documentation for any purpose, provided that existing
 * copyright notices are retained in all copies and that this notice is
 * included verbatim in any distributions. Additionally, the authors grant
 * permission to modify this software and its documentation for any purpose,
 * provided that such modifications are not distributed without the explicit
 * consent of the authors and that existing copyright notices are retained in
 * all copies. Some of the algorithms implemented by this software are
 * patented, observe all applicable patent law.
 *
 * IN NO EVENT SHALL THE AUTHORS OR DISTRIBUTORS BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE, ITS DOCUMENTATION, OR ANY DERIVATIVES THEREOF,
 * EVEN IF THE AUTHORS HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE AUTHORS AND DISTRIBUTORS SPECIFICALLY DISCLAIM ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.  THIS SOFTWARE IS
 * PROVIDED ON AN "AS IS" BASIS, AND THE AUTHORS AND DISTRIBUTORS HAVE NO
 * OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR
 * MODIFICATIONS.
 * 
 **** 
 *
 * jLouvain.js
 * Author: Corneliu S. (github.com/upphiminn)
 * This is a javascript implementation of the Louvain
 * community detection algorithm (http://arxiv.org/abs/0803.0476)
 * Based on https://bitbucket.org/taynaud/python-louvain/overview
 * 
 ****
 * 
 * science.js
 * Copyright (c) 2011, Jason Davies
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * Redistributions of source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * The name Jason Davies may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL JASON DAVIES BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 ****
 *
 * Apache-Style Software License for ColorBrewer software and ColorBrewer Color
 * Schemes
 * 
 * Copyright (c) 2002 Cynthia Brewer, Mark Harrower, and The Pennsylvania State
 * University.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions as source code must retain the above copyright notice, this
 * list of conditions and the following disclaimer.
 * 
 * 2. The end-user documentation included with the redistribution, if any, must
 * include the following acknowledgment: "This product includes color
 * specifications and designs developed by Cynthia Brewer
 * (http://colorbrewer.org/)." Alternately, this acknowledgment may appear in the
 * software itself, if and wherever such third-party acknowledgments normally
 * appear.
 * 
 * 4. The name "ColorBrewer" must not be used to endorse or promote products
 * derived from this software without prior written permission. For written
 * permission, please contact Cynthia Brewer at cbrewer@psu.edu.
 * 
 * 5. Products derived from this software may not be called "ColorBrewer", nor
 * may "ColorBrewer" appear in their name, without prior written permission of
 * Cynthia Brewer.
 *
 ****
 * 
 * FileSaver.js
 * Copyright © 2015 [Eli Grey][1].
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 **** 
 * 
 * canvas-toBlob.js
 * Copyright © 2011 Eli Grey and Devin Samarin.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * Blob.js
 * Copyright © 2014 Eli Grey.
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is furnished
 * to do so, subject to the following conditions:
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE
 * OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 ****
 *
 * jstat.js
 * Copyright (c) 2013 jStat
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * numeric.js
 * Numeric Javascript
 * Copyright (C) 2011 by Sébastien Loisel
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * 
 ****
 *
 * spark-md5.js
 * Copyright (c) 2015 André Cruz <amdfcruz@gmail.com>
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the 'Software'), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED 'AS IS', WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 ****
 *
 * Sankey.js
 * Copyright (c) 2012, Michael Bostock
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * * Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 *
 * * Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 *
 * * The name Michael Bostock may not be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL MICHAEL BOSTOCK BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 ****
 *
 * canvas2svg
 * The MIT License (MIT)
 *
 * Copyright (c) 2014 Gliffy Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 */
function str_repeat(b,a){for(var c=[];a>0;c[--a]=b){}return(c.join(""))}function sprintf(){var g=0,e,h=arguments[g++],k=[],d,j,l,b;while(h){if(d=/^[^\x25]+/.exec(h)){k.push(d[0])}else{if(d=/^\x25{2}/.exec(h)){k.push("%")}else{if(d=/^\x25(?:(\d+)\$)?(\+)?(0|'[^$])?(-)?(\d+)?(?:\.(\d+))?([b-fosuxX])/.exec(h)){if(((e=arguments[d[1]||g++])==null)||(e==undefined)){throw ("Too few arguments.")}if(/[^s]/.test(d[7])&&(typeof(e)!="number")){throw ("Expecting number but found "+typeof(e))}switch(d[7]){case"b":e=e.toString(2);break;case"c":e=String.fromCharCode(e);break;case"d":e=parseInt(e);break;case"e":e=d[6]?e.toExponential(d[6]):e.toExponential();break;case"f":e=d[6]?parseFloat(e).toFixed(d[6]):parseFloat(e);break;case"o":e=e.toString(8);break;case"s":e=((e=String(e))&&d[6]?e.substring(0,d[6]):e);break;case"u":e=Math.abs(e);break;case"x":e=e.toString(16);break;case"X":e=e.toString(16).toUpperCase();break}e=(/[def]/.test(d[7])&&d[2]&&e>0?"+"+e:e);l=d[3]?d[3]=="0"?"0":d[3].charAt(1):" ";b=d[5]-String(e).length;j=d[5]?str_repeat(l,b):"";k.push(d[4]?e+j:j+e)}else{throw ("Huh ?!")}}}h=h.substring(d[0].length)}return k.join("")};var dateFormat=function(){var a=/d{1,4}|m{1,4}|yy(?:yy)?|([HhMsTt])\1?|[LloSZ]|"[^"]*"|'[^']*'/g,b=/\b(?:[PMCEA][SDP]T|(?:Pacific|Mountain|Central|Eastern|Atlantic) (?:Standard|Daylight|Prevailing) Time|(?:GMT|UTC)(?:[-+]\d{4})?)\b/g,d=/[^-+\dA-Z]/g,c=function(f,e){f=String(f);e=e||2;while(f.length<e){f="0"+f}return f};return function(i,v,q){var g=dateFormat;if(arguments.length==1&&Object.prototype.toString.call(i)=="[object String]"&&!/\d/.test(i)){v=i;i=undefined}i=i?new Date(i):new Date;if(isNaN(i)){throw SyntaxError("invalid date")}v=String(g.masks[v]||v||g.masks["default"]);if(v.slice(0,4)=="UTC:"){v=v.slice(4);q=true}var t=q?"getUTC":"get",l=i[t+"Date"](),e=i[t+"Day"](),j=i[t+"Month"](),p=i[t+"FullYear"](),r=i[t+"Hours"](),k=i[t+"Minutes"](),u=i[t+"Seconds"](),n=i[t+"Milliseconds"](),f=q?0:i.getTimezoneOffset(),h={d:l,dd:c(l),ddd:g.i18n.dayNames[e],dddd:g.i18n.dayNames[e+7],m:j+1,mm:c(j+1),mmm:g.i18n.monthNames[j],mmmm:g.i18n.monthNames[j+12],yy:String(p).slice(2),yyyy:p,h:r%12||12,hh:c(r%12||12),H:r,HH:c(r),M:k,MM:c(k),s:u,ss:c(u),l:c(n,3),L:c(n>99?Math.round(n/10):n),t:r<12?"a":"p",tt:r<12?"am":"pm",T:r<12?"A":"P",TT:r<12?"AM":"PM",Z:q?"UTC":(String(i).match(b)||[""]).pop().replace(d,""),o:(f>0?"-":"+")+c(Math.floor(Math.abs(f)/60)*100+Math.abs(f)%60,4),S:["th","st","nd","rd"][l%10>3?0:(l%100-l%10!=10)*l%10]};return v.replace(a,function(m){return m in h?h[m]:m.slice(1,m.length-1)})}}();dateFormat.masks={"default":"ddd mmm dd yyyy HH:MM:ss",shortDate:"m/d/yy",mediumDate:"mmm d, yyyy",longDate:"mmmm d, yyyy",fullDate:"dddd, mmmm d, yyyy",shortTime:"h:MM TT",mediumTime:"h:MM:ss TT",longTime:"h:MM:ss TT Z",isoDate:"yyyy-mm-dd",isoTime:"HH:MM:ss",isoDateTime:"yyyy-mm-dd'T'HH:MM:ss",isoUtcDateTime:"UTC:yyyy-mm-dd'T'HH:MM:ss'Z'"};dateFormat.i18n={dayNames:["Sun","Mon","Tue","Wed","Thu","Fri","Sat","Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],monthNames:["Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec","January","February","March","April","May","June","July","August","September","October","November","December"]};Date.prototype.format=function(a,b){return dateFormat(this,a,b)};var Conrec=(function(){var d=1e-20;var c=function(h,g){var f=h.x-g.x,i=h.y-g.y;return f*f+i*i<d};var e=function(h){var f=h.head;while(f){var g=f.next;f.next=f.prev;f.prev=g;f=g}var g=h.head;h.head=h.tail;h.tail=g};var b=function(f){this.level=f;this.s=null;this.count=0};b.prototype.remove_seq=function(f){if(f.prev){f.prev.next=f.next}else{this.s=f.next}if(f.next){f.next.prev=f.prev}--this.count};b.prototype.addSegment=function(k,j){var p=this.s;var m=null;var l=null;var o=false;var n=false;while(p){if(m==null){if(c(k,p.head.p)){m=p;o=true}else{if(c(k,p.tail.p)){m=p}}}if(l==null){if(c(j,p.head.p)){l=p;n=true}else{if(c(j,p.tail.p)){l=p}}}if(l!=null&&m!=null){break}else{p=p.next}}var i=((m!=null)?1:0)|((l!=null)?2:0);switch(i){case 0:var f={p:k,prev:null};var h={p:j,next:null};f.next=h;h.prev=f;m={head:f,tail:h,next:this.s,prev:null,closed:false};if(this.s){this.s.prev=m}this.s=m;++this.count;break;case 1:var g={p:j};if(o){g.next=m.head;g.prev=null;m.head.prev=g;m.head=g}else{g.next=null;g.prev=m.tail;m.tail.next=g;m.tail=g}break;case 2:var g={p:k};if(n){g.next=l.head;g.prev=null;l.head.prev=g;l.head=g}else{g.next=null;g.prev=l.tail;l.tail.next=g;l.tail=g}break;case 3:if(m===l){var g={p:m.tail.p,next:m.head,prev:null};m.head.prev=g;m.head=g;m.closed=true;break}switch((o?1:0)|(n?2:0)){case 0:e(m);case 1:l.tail.next=m.head;m.head.prev=l.tail;l.tail=m.tail;this.remove_seq(m);break;case 3:e(m);case 2:m.tail.next=l.head;l.head.prev=m.tail;m.tail=l.tail;this.remove_seq(l);break}}};var a=function(f){if(!f){var g=this;g.contours={};this.drawContour=function(j,i,o,n,m,l){var h=g.contours[l];if(!h){h=g.contours[l]=new b(m)}h.addSegment({x:j,y:i},{x:o,y:n})};this.contourList=function(){var m=[];var j=g.contours;for(var n in j){var p=j[n].s;var q=j[n].level;while(p){var o=p.head;var i=[];i.level=q;i.k=n;while(o&&o.p){i.push(o.p);o=o.next}m.push(i);p=p.next}}m.sort(function(k,h){return h.k-k.k});return m}}else{this.drawContour=f}this.h=new Array(5);this.sh=new Array(5);this.xh=new Array(5);this.yh=new Array(5)};a.prototype.contour=function(Q,L,P,r,u,B,A,t,v){var N=this.h,S=this.sh,D=this.xh,U=this.yh;var H=this.drawContour;this.contours={};var q=function(i,h){return(N[h]*D[i]-N[i]*D[h])/(N[h]-N[i])};var R=function(i,h){return(N[h]*U[i]-N[i]*U[h])/(N[h]-N[i])};var l;var g;var f;var s;var C;var E;var O=0;var M=0;var o=0;var n=0;var w=[0,1,1,0];var K=[0,0,1,1];var p=[[[0,0,8],[0,2,5],[7,6,9]],[[0,3,4],[1,3,1],[4,3,0]],[[9,6,7],[5,2,0],[8,0,0]]];for(var I=(u-1);I>=r;I--){for(var J=L;J<=P-1;J++){var V,T;V=Math.min(Q[J][I],Q[J][I+1]);T=Math.min(Q[J+1][I],Q[J+1][I+1]);C=Math.min(V,T);V=Math.max(Q[J][I],Q[J][I+1]);T=Math.max(Q[J+1][I],Q[J+1][I+1]);E=Math.max(V,T);if(E>=v[0]&&C<=v[t-1]){for(var G=0;G<t;G++){if(v[G]>=C&&v[G]<=E){for(var F=4;F>=0;F--){if(F>0){N[F]=Q[J+w[F-1]][I+K[F-1]]-v[G];D[F]=B[J+w[F-1]];U[F]=A[I+K[F-1]]}else{N[0]=0.25*(N[1]+N[2]+N[3]+N[4]);D[0]=0.5*(B[J]+B[J+1]);U[0]=0.5*(A[I]+A[I+1])}if(N[F]>0){S[F]=1}else{if(N[F]<0){S[F]=-1}else{S[F]=0}}}for(F=1;F<=4;F++){l=F;g=0;if(F!=4){f=F+1}else{f=1}s=p[S[l]+1][S[g]+1][S[f]+1];if(s!=0){switch(s){case 1:O=D[l];o=U[l];M=D[g];n=U[g];break;case 2:O=D[g];o=U[g];M=D[f];n=U[f];break;case 3:O=D[f];o=U[f];M=D[l];n=U[l];break;case 4:O=D[l];o=U[l];M=q(g,f);n=R(g,f);break;case 5:O=D[g];o=U[g];M=q(f,l);n=R(f,l);break;case 6:O=D[f];o=U[f];M=q(l,g);n=R(l,g);break;case 7:O=q(l,g);o=R(l,g);M=q(g,f);n=R(g,f);break;case 8:O=q(g,f);o=R(g,f);M=q(f,l);n=R(f,l);break;case 9:O=q(f,l);o=R(f,l);M=q(l,g);n=R(l,g);break;default:break}H(O,o,M,n,v[G],G)}}}}}}}};return a})();if(typeof exports!=="undefined"){exports.Conrec=Conrec};(function(){jLouvain=function(){var l=-1;var k=1e-7;var i;var y;var s={};var a;function d(C){var B={};C.forEach(function(E,D){B[E]=true});return Object.keys(B)}function x(D){var C=[];for(var B in D){if(D.hasOwnProperty(B)){C.push(D[B])}}return C}function v(E,C){var B=E._assoc_mat[C]?Object.keys(E._assoc_mat[C]):[];var D=0;B.forEach(function(F,G){var H=E._assoc_mat[C][F]||1;if(C==F){H*=2}D+=H});return D}function f(D,C){if(typeof D._assoc_mat[C]=="undefined"){return[]}var B=Object.keys(D._assoc_mat[C]);return B}function g(D,C,B){return D._assoc_mat[C]?D._assoc_mat[C][B]:undefined}function A(C){var B=0;C.edges.forEach(function(D){B+=D.weight});return B}function c(D,C){e(D,C);var B=D.edges.map(function(E){return E.id1+"_"+E.id2}).indexOf(C.id1+"_"+C.id2);if(B!=-1){D.edges[B].weight=C.weight}else{D.edges.push(C)}}function z(B){var C={};B.forEach(function(E,D){E.weight=E.weight||1;C[E.id1]=C[E.id1]||{};C[E.id1][E.id2]=E.weight;C[E.id2]=C[E.id2]||{};C[E.id2][E.id1]=E.weight});return C}function e(C,B){C._assoc_mat[B.id1]=C._assoc_mat[B.id1]||{};C._assoc_mat[B.id1][B.id2]=B.weight;C._assoc_mat[B.id2]=C._assoc_mat[B.id2]||{};C._assoc_mat[B.id2][B.id1]=B.weight}function t(D){if(D==null||typeof(D)!="object"){return D}var B=D.constructor();for(var C in D){B[C]=t(D[C])}return B}function p(D,B,C){B.nodes_to_com={};B.total_weight=0;B.internals={};B.degrees={};B.gdegrees={};B.loops={};B.total_weight=A(D);if(typeof C=="undefined"){D.nodes.forEach(function(G,E){B.nodes_to_com[G]=E;var F=v(D,G);if(F<0){throw"Bad graph type, use positive weights!"}B.degrees[E]=F;B.gdegrees[G]=F;B.loops[G]=g(D,G,G)||0;B.internals[E]=B.loops[G]})}else{D.nodes.forEach(function(I,G){var E=C[I];B.nodes_to_com[I]=E;var H=v(D,I);B.degrees[E]=(B.degrees[E]||0)+H;B.gdegrees[I]=H;var J=0;var F=f(D,I);F.forEach(function(K,L){var M=D._assoc_mat[I][K];if(M<=0){throw"Bad graph type, use positive weights"}if(C[K]==E){if(K==I){J+=M}else{J+=M/2}}});B.internals[E]=(B.internals[E]||0)+J})}}function o(C){var E=C.total_weight;var B=0;var D=d(x(C.nodes_to_com));D.forEach(function(F,G){var I=C.internals[F]||0;var H=C.degrees[F]||0;if(E>0){B=B+I/E-Math.pow((H/(2*E)),2)}});return B}function m(D,E,B){var C={};var F=f(E,D);F.forEach(function(G,H){if(G!=D){var I=E._assoc_mat[D][G]||1;var J=B.nodes_to_com[G];C[J]=(C[J]||0)+I}});return C}function u(D,C,E,B){B.nodes_to_com[D]=+C;B.degrees[C]=(B.degrees[C]||0)+(B.gdegrees[D]||0);B.internals[C]=(B.internals[C]||0)+E+(B.loops[D]||0)}function r(D,C,E,B){B.degrees[C]=((B.degrees[C]||0)-(B.gdegrees[D]||0));B.internals[C]=((B.internals[C]||0)-E-(B.loops[D]||0));B.nodes_to_com[D]=-1}function j(F){var D=0;var B=t(F);var C={};var E=Object.keys(F);E.forEach(function(H){var I=F[H];var G=typeof C[I]=="undefined"?-1:C[I];if(G==-1){C[I]=D;G=D;D=D+1}B[H]=G});return B}function b(F,B){var D=true,G=0,E=o(B),C=E;while(D&&G!=l){E=C;D=false;G+=1;F.nodes.forEach(function(J,I){var M=B.nodes_to_com[J];var O=(B.gdegrees[J]||0)/(B.total_weight*2);var L=m(J,F,B);r(J,M,(L[M]||0),B);var N=M;var H=0;var K=Object.keys(L);K.forEach(function(P,Q){var R=L[P]-(B.degrees[P]||0)*O;if(R>H){H=R;N=P}});u(J,N,L[N]||0,B);if(N!=M){D=true}});C=o(B);if(C-E<k){break}}}function h(C,G){var B={nodes:[],edges:[],_assoc_mat:{}};var D,F;var E=x(C);B.nodes=B.nodes.concat(d(E));G.edges.forEach(function(I,H){F=I.weight||1;var L=C[I.id1];var J=C[I.id2];D=(g(B,L,J)||0);var K=(D+F);c(B,{source:L,target:J,weight:K})});return B}function w(C,E){var B=t(C[0]);for(var D=1;D<E+1;D++){Object.keys(B).forEach(function(H,G){var I=H;var F=B[H];B[I]=C[D][F]})}return B}function n(J,D){if(J.edges.length==0){var C={};J.nodes.forEach(function(L,K){C[L]=L});return C}var F={};p(s,F,D);var H=o(F);var I=[];b(s,F);var B=o(F);var G=j(F.nodes_to_com);I.push(G);H=B;var E=h(G,s);p(E,F);while(true){b(E,F);B=o(F);if(B-H<k){break}G=j(F.nodes_to_com);I.push(G);H=B;E=h(G,E);p(E,F)}return I}var q=function(){var B={};var C=n(s,a);return w(C,C.length-1)};q.nodes=function(B){if(arguments.length>0){i=B}return q};q.edges=function(C){if(typeof i=="undefined"){throw"Please provide the graph nodes first!"}if(arguments.length>0){y=C;var B=z(C);s={nodes:i,edges:y,_assoc_mat:B}}return q};q.partition_init=function(B){if(arguments.length>0){a=B}return q};return q}})();/*! @source http://purl.eligrey.com/github/Blob.js/blob/master/Blob.js */
(function(a){a.URL=a.URL||a.webkitURL;if(a.Blob&&a.URL){try{new Blob;return}catch(d){}}var c=a.BlobBuilder||a.WebKitBlobBuilder||a.MozBlobBuilder||(function(p){var g=function(z){return Object.prototype.toString.call(z).match(/^\[object\s(.*)\]$/)[1]},y=function m(){this.data=[]},w=function i(B,z,A){this.data=B;this.size=B.length;this.type=z;this.encoding=A},q=y.prototype,v=w.prototype,s=p.FileReaderSync,e=function(z){this.code=this[this.name=z]},r=("NOT_FOUND_ERR SECURITY_ERR ABORT_ERR NOT_READABLE_ERR ENCODING_ERR NO_MODIFICATION_ALLOWED_ERR INVALID_STATE_ERR SYNTAX_ERR").split(" "),u=r.length,l=p.URL||p.webkitURL||p,t=l.createObjectURL,f=l.revokeObjectURL,k=l,o=p.btoa,j=p.atob,h=p.ArrayBuffer,n=p.Uint8Array,x=/^[\w-]+:\/*\[?[\w\.:-]+\]?(?::[0-9]+)?/;w.fake=v.fake=true;while(u--){e.prototype[r[u]]=u+1}if(!l.createObjectURL){k=p.URL=function(A){var z=document.createElementNS("http://www.w3.org/1999/xhtml","a"),B;z.href=A;if(!("origin" in z)){if(z.protocol.toLowerCase()==="data:"){z.origin=null}else{B=A.match(x);z.origin=B&&B[1]}}return z}}k.createObjectURL=function(A){var B=A.type,z;if(B===null){B="application/octet-stream"}if(A instanceof w){z="data:"+B;if(A.encoding==="base64"){return z+";base64,"+A.data}else{if(A.encoding==="URI"){return z+","+decodeURIComponent(A.data)}}if(o){return z+";base64,"+o(A.data)}else{return z+","+encodeURIComponent(A.data)}}else{if(t){return t.call(l,A)}}};k.revokeObjectURL=function(z){if(z.substring(0,5)!=="data:"&&f){f.call(l,z)}};q.append=function(D){var F=this.data;if(n&&(D instanceof h||D instanceof n)){var E="",A=new n(D),B=0,C=A.length;for(;B<C;B++){E+=String.fromCharCode(A[B])}F.push(E)}else{if(g(D)==="Blob"||g(D)==="File"){if(s){var z=new s;F.push(z.readAsBinaryString(D))}else{throw new e("NOT_READABLE_ERR")}}else{if(D instanceof w){if(D.encoding==="base64"&&j){F.push(j(D.data))}else{if(D.encoding==="URI"){F.push(decodeURIComponent(D.data))}else{if(D.encoding==="raw"){F.push(D.data)}}}}else{if(typeof D!=="string"){D+=""}F.push(unescape(encodeURIComponent(D)))}}}};q.getBlob=function(z){if(!arguments.length){z=null}return new w(this.data.join(""),z,"raw")};q.toString=function(){return"[object BlobBuilder]"};v.slice=function(C,z,B){var A=arguments.length;if(A<3){B=null}return new w(this.data.slice(C,A>1?z:this.data.length),B,this.encoding)};v.toString=function(){return"[object Blob]"};v.close=function(){this.size=0;delete this.data};return y}(a));a.Blob=function(j,h){var l=h?(h.type||""):"";var g=new c();if(j){for(var k=0,e=j.length;k<e;k++){if(Uint8Array&&j[k] instanceof Uint8Array){g.append(j[k].buffer)}else{g.append(j[k])}}}var f=g.getBlob(l);if(!f.slice&&f.webkitSlice){f.slice=f.webkitSlice}return f};var b=Object.getPrototypeOf||function(e){return e.__proto__};a.Blob.prototype=b(new a.Blob())}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/canvas-toBlob.js/blob/master/canvas-toBlob.js */
(function(a){var b=a.Uint8Array,d=a.HTMLCanvasElement,c=d&&d.prototype,e=/\s*;\s*base64\s*(?:;|$)/i,f="toDataURL",h,g=function(p){var q=p.length,m=new b(q/4*3|0),o=0,s=0,t=[0,0],j=0,r=0,n,k,l;while(q--){k=p.charCodeAt(o++);n=h[k-43];if(n!==255&&n!==l){t[1]=t[0];t[0]=k;r=(r<<6)|n;j++;if(j===4){m[s++]=r>>>16;if(t[1]!==61){m[s++]=r>>>8}if(t[0]!==61){m[s++]=r}j=0}}}return m};if(b){h=new b([62,-1,-1,-1,63,52,53,54,55,56,57,58,59,60,61,-1,-1,-1,0,-1,-1,-1,0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,-1,-1,-1,-1,-1,-1,26,27,28,29,30,31,32,33,34,35,36,37,38,39,40,41,42,43,44,45,46,47,48,49,50,51])}if(d&&!c.toBlob){c.toBlob=function(p,n){if(!n){n="image/png"}if(this.mozGetAsFile){p(this.mozGetAsFile("canvas",n));return}if(this.msToBlob&&/^\s*image\/png\s*(?:$|;)/i.test(n)){p(this.msToBlob());return}var m=Array.prototype.slice.call(arguments,1),k=this[f].apply(this,m),j=k.indexOf(","),o=k.substring(j+1),i=e.test(k.substring(0,j)),l;if(Blob.fake){l=new Blob;if(i){l.encoding="base64"}else{l.encoding="URI"}l.data=o;l.size=o.length}else{if(b){if(i){l=new Blob([g(o)],{type:n})}else{l=new Blob([decodeURIComponent(o)],{type:n})}}}p(l)};if(c.toDataURLHD){c.toBlobHD=function(){f="toDataURLHD";var i=this.toBlob();f="toDataURL";return i}}else{c.toBlobHD=c.toBlob}}}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content||this));
/*! @source http://purl.eligrey.com/github/FileSaver.js/blob/master/FileSaver.js */
;var saveAs=saveAs||(function(g){if(typeof navigator!=="undefined"&&/MSIE [1-9]\./.test(navigator.userAgent)){return}var r=g.document,l=function(){return g.URL||g.webkitURL||g},n=r.createElementNS("http://www.w3.org/1999/xhtml","a"),e="download" in n,j=function(t){var s=r.createEvent("MouseEvents");s.initMouseEvent("click",true,false,g,0,0,0,0,0,false,false,false,false,0,null);t.dispatchEvent(s)},o=g.webkitRequestFileSystem,p=g.requestFileSystem||o||g.mozRequestFileSystem,m=function(s){(g.setImmediate||g.setTimeout)(function(){throw s},0)},b="application/octet-stream",k=0,h=500,i=function(t){var s=function(){if(typeof t==="string"){l().revokeObjectURL(t)}else{t.remove()}};if(g.chrome){s()}else{setTimeout(s,h)}},q=function(t,s,w){s=[].concat(s);var v=s.length;while(v--){var x=t["on"+s[v]];if(typeof x==="function"){try{x.call(t,w||t)}catch(u){m(u)}}}},f=function(s){if(/^\s*(?:text\/\S*|application\/xml|\S*\/\S*\+xml)\s*;.*charset\s*=\s*utf-8/i.test(s.type)){return new Blob(["\ufeff",s],{type:s.type})}return s},d=function(s,t){s=f(s);var u=this,A=s.type,D=false,w,v,z=function(){q(u,"writestart progress write writeend".split(" "))},C=function(){if(D||!w){w=l().createObjectURL(s)}if(v){v.location.href=w}else{var E=g.open(w,"_blank");if(E==undefined&&typeof safari!=="undefined"){g.location.href=w}}u.readyState=u.DONE;z();i(w)},y=function(E){return function(){if(u.readyState!==u.DONE){return E.apply(this,arguments)}}},x={create:true,exclusive:false},B;u.readyState=u.INIT;if(!t){t="download"}if(e){w=l().createObjectURL(s);n.href=w;n.download=t;j(n);u.readyState=u.DONE;z();i(w);return}if(g.chrome&&A&&A!==b){B=s.slice||s.webkitSlice;s=B.call(s,0,s.size,b);D=true}if(o&&t!=="download"){t+=".download"}if(A===b||o){v=g}if(!p){C();return}k+=s.size;p(g.TEMPORARY,k,y(function(E){E.root.getDirectory("saved",x,y(function(F){var G=function(){F.getFile(t,x,y(function(H){H.createWriter(y(function(I){I.onwriteend=function(J){v.location.href=H.toURL();u.readyState=u.DONE;q(u,"writeend",J);i(H)};I.onerror=function(){var J=I.error;if(J.code!==J.ABORT_ERR){C()}};"writestart progress write abort".split(" ").forEach(function(J){I["on"+J]=u["on"+J]});I.write(s);u.abort=function(){I.abort();u.readyState=u.DONE};u.readyState=u.WRITING}),C)}),C)};F.getFile(t,{create:false},y(function(H){H.remove();G()}),y(function(H){if(H.code===H.NOT_FOUND_ERR){G()}else{C()}}))}),C)}),C)},c=d.prototype,a=function(s,t){return new d(s,t)};if(typeof navigator!=="undefined"&&navigator.msSaveOrOpenBlob){return function(s,t){return navigator.msSaveOrOpenBlob(f(s),t)}}c.abort=function(){var s=this;s.readyState=s.DONE;q(s,"abort")};c.readyState=c.INIT=0;c.WRITING=1;c.DONE=2;c.error=c.onwritestart=c.onprogress=c.onwrite=c.onabort=c.onerror=c.onwriteend=null;return a}(typeof self!=="undefined"&&self||typeof window!=="undefined"&&window||this.content));if(typeof module!=="undefined"&&module.exports){module.exports.saveAs=saveAs}else{if((typeof define!=="undefined"&&define!==null)&&(define.amd!=null)){define([],function(){return saveAs})}};"use strict";var numeric=(typeof exports==="undefined")?(function numeric(){}):(exports);if(typeof global!=="undefined"){global.numeric=numeric}numeric.version="1.2.6";numeric._myIndexOf=(function _myIndexOf(a){var c=this.length,b;for(b=0;b<c;++b){if(this[b]===a){return b}}return -1});numeric.myIndexOf=(Array.prototype.indexOf)?Array.prototype.indexOf:numeric._myIndexOf;numeric.Function=Function;numeric.precision=4;numeric.largeArray=50;numeric._dim=function _dim(a){var b=[];while(typeof a==="object"){b.push(a.length);a=a[0]}return b};numeric.dim=function dim(a){var c,b;if(typeof a==="object"){c=a[0];if(typeof c==="object"){b=c[0];if(typeof b==="object"){return numeric._dim(a)}return[a.length,c.length]}return[a.length]}return[]};numeric.mapreduce=function mapreduce(a,b){return Function("x","accum","_s","_k",'if(typeof accum === "undefined") accum = '+b+';\nif(typeof x === "number") { var xi = x; '+a+'; return accum; }\nif(typeof _s === "undefined") _s = numeric.dim(x);\nif(typeof _k === "undefined") _k = 0;\nvar _n = _s[_k];\nvar i,xi;\nif(_k < _s.length-1) {\n    for(i=_n-1;i>=0;i--) {\n        accum = arguments.callee(x[i],accum,_s,_k+1);\n    }    return accum;\n}\nfor(i=_n-1;i>=1;i-=2) { \n    xi = x[i];\n    '+a+";\n    xi = x[i-1];\n    "+a+";\n}\nif(i === 0) {\n    xi = x[i];\n    "+a+"\n}\nreturn accum;")};numeric.mapreduce2=function mapreduce2(b,a){return Function("x","var n = x.length;\nvar i,xi;\n"+a+";\nfor(i=n-1;i!==-1;--i) { \n    xi = x[i];\n    "+b+";\n}\nreturn accum;")};numeric.same=function same(a,d){var b,c;if(!(a instanceof Array)||!(d instanceof Array)){return false}c=a.length;if(c!==d.length){return false}for(b=0;b<c;b++){if(a[b]===d[b]){continue}if(typeof a[b]==="object"){if(!same(a[b],d[b])){return false}}else{return false}}return true};numeric.rep=function rep(e,b,a){if(typeof a==="undefined"){a=0}var f=e[a],c=Array(f),d;if(a===e.length-1){for(d=f-2;d>=0;d-=2){c[d+1]=b;c[d]=b}if(d===-1){c[0]=b}return c}for(d=f-1;d>=0;d--){c[d]=numeric.rep(e,b,a+1)}return c};numeric.dotMMsmall=function dotMMsmall(v,u){var l,g,e,c,b,a,n,s,m,h,f,o,w,d;c=v.length;b=u.length;a=u[0].length;n=Array(c);for(l=c-1;l>=0;l--){s=Array(a);m=v[l];for(e=a-1;e>=0;e--){h=m[b-1]*u[b-1][e];for(g=b-2;g>=1;g-=2){f=g-1;h+=m[g]*u[g][e]+m[f]*u[f][e]}if(g===0){h+=m[0]*u[0][e]}s[e]=h}n[l]=s}return n};numeric._getCol=function _getCol(b,c,a){var e=b.length,d;for(d=e-1;d>0;--d){a[d]=b[d][c];--d;a[d]=b[d][c]}if(d===0){a[0]=b[0][c]}};numeric.dotMMbig=function dotMMbig(r,q){var s=numeric._getCol,a=q.length,u=Array(a);var d=r.length,c=q[0].length,b=new Array(d),l;var f=numeric.dotVV;var h,g,e,o;--a;--d;for(h=d;h!==-1;--h){b[h]=Array(c)}--c;for(h=c;h!==-1;--h){s(q,h,u);for(g=d;g!==-1;--g){o=0;l=r[g];b[g][h]=f(l,u)}}return b};numeric.dotMV=function dotMV(a,g){var e=a.length,d=g.length,c;var b=Array(e),f=numeric.dotVV;for(c=e-1;c>=0;c--){b[c]=f(a[c],g)}return b};numeric.dotVM=function dotVM(h,g){var w,v,u,n,m,l,D,B,A,e,s,f,c,z,d,b,a,o,C;n=h.length;m=g[0].length;D=Array(m);for(u=m-1;u>=0;u--){e=h[n-1]*g[n-1][u];for(v=n-2;v>=1;v-=2){s=v-1;e+=h[v]*g[v][u]+h[s]*g[s][u]}if(v===0){e+=h[0]*g[0][u]}D[u]=e}return D};numeric.dotVV=function dotVV(a,f){var c,e=a.length,d,b=a[e-1]*f[e-1];for(c=e-2;c>=1;c-=2){d=c-1;b+=a[c]*f[c]+a[d]*f[d]}if(c===0){b+=a[0]*f[0]}return b};numeric.dot=function dot(a,c){var b=numeric.dim;switch(b(a).length*1000+b(c).length){case 2002:if(c.length<10){return numeric.dotMMsmall(a,c)}else{return numeric.dotMMbig(a,c)}case 2001:return numeric.dotMV(a,c);case 1002:return numeric.dotVM(a,c);case 1001:return numeric.dotVV(a,c);case 1000:return numeric.mulVS(a,c);case 1:return numeric.mulSV(a,c);case 0:return a*c;default:throw new Error("numeric.dot only works on vectors and matrices")}};numeric.diag=function diag(g){var e,f,c,h=g.length,a=Array(h),b;for(e=h-1;e>=0;e--){b=Array(h);f=e+2;for(c=h-1;c>=f;c-=2){b[c]=0;b[c-1]=0}if(c>e){b[c]=0}b[e]=g[e];for(c=e-1;c>=1;c-=2){b[c]=0;b[c-1]=0}if(c===0){b[0]=0}a[e]=b}return a};numeric.getDiag=function(a){var d=Math.min(a.length,a[0].length),c,b=Array(d);for(c=d-1;c>=1;--c){b[c]=a[c][c];--c;b[c]=a[c][c]}if(c===0){b[0]=a[0][0]}return b};numeric.identity=function identity(a){return numeric.diag(numeric.rep([a],1))};numeric.pointwise2=function pointwise2(d,g,c){if(typeof c==="undefined"){c=""}var h=[];var e;var i=/\[i\]$/,a,f="";var b=false;for(e=0;e<d.length;e++){if(i.test(d[e])){a=d[e].substring(0,d[e].length-3);f=a}else{a=d[e]}if(a==="ret"){b=true}h.push(a)}h[d.length]=("var _n = "+f+".length;\nvar i"+(b?"":", ret = Array(_n)")+";\n"+c+"\nfor(i=_n-1;i!==-1;--i) {\n"+g+"\n}\nreturn ret;");return Function.apply(null,h)};numeric._biforeach=(function _biforeach(a,h,d,b,e){if(b===d.length-1){e(a,h);return}var c,g=d[b];for(c=g-1;c>=0;c--){_biforeach(typeof a==="object"?a[c]:a,typeof h==="object"?h[c]:h,d,b+1,e)}});numeric._biforeach2=(function _biforeach2(a,j,e,b,g){if(b===e.length-1){return g(a,j)}var d,h=e[b],c=Array(h);for(d=h-1;d>=0;--d){c[d]=_biforeach2(typeof a==="object"?a[d]:a,typeof j==="object"?j[d]:j,e,b+1,g)}return c});numeric._foreach=(function _foreach(a,d,b,e){if(b===d.length-1){e(a);return}var c,g=d[b];for(c=g-1;c>=0;c--){_foreach(a[c],d,b+1,e)}});numeric._foreach2=(function _foreach2(a,e,b,g){if(b===e.length-1){return g(a)}var d,h=e[b],c=Array(h);for(d=h-1;d>=0;d--){c[d]=_foreach2(a[d],e,b+1,g)}return c});numeric.ops2={add:"+",sub:"-",mul:"*",div:"/",mod:"%",and:"&&",or:"||",eq:"===",neq:"!==",lt:"<",gt:">",leq:"<=",geq:">=",band:"&",bor:"|",bxor:"^",lshift:"<<",rshift:">>",rrshift:">>>"};numeric.opseq={addeq:"+=",subeq:"-=",muleq:"*=",diveq:"/=",modeq:"%=",lshifteq:"<<=",rshifteq:">>=",rrshifteq:">>>=",bandeq:"&=",boreq:"|=",bxoreq:"^="};numeric.mathfuns=["abs","acos","asin","atan","ceil","cos","exp","floor","log","round","sin","sqrt","tan","isNaN","isFinite"];numeric.mathfuns2=["atan2","pow","max","min"];numeric.ops1={neg:"-",not:"!",bnot:"~",clone:""};numeric.mapreducers={any:["if(xi) return true;","var accum = false;"],all:["if(!xi) return false;","var accum = true;"],sum:["accum += xi;","var accum = 0;"],prod:["accum *= xi;","var accum = 1;"],norm2Squared:["accum += xi*xi;","var accum = 0;"],norminf:["accum = max(accum,abs(xi));","var accum = 0, max = Math.max, abs = Math.abs;"],norm1:["accum += abs(xi)","var accum = 0, abs = Math.abs;"],sup:["accum = max(accum,xi);","var accum = -Infinity, max = Math.max;"],inf:["accum = min(accum,xi);","var accum = Infinity, min = Math.min;"]};(function(){var b,e;for(b=0;b<numeric.mathfuns2.length;++b){e=numeric.mathfuns2[b];numeric.ops2[e]=e}for(b in numeric.ops2){if(numeric.ops2.hasOwnProperty(b)){e=numeric.ops2[b];var c,d,a="";if(numeric.myIndexOf.call(numeric.mathfuns2,b)!==-1){a="var "+e+" = Math."+e+";\n";c=function(g,f,h){return g+" = "+e+"("+f+","+h+")"};d=function(f,g){return f+" = "+e+"("+f+","+g+")"}}else{c=function(g,f,h){return g+" = "+f+" "+e+" "+h};if(numeric.opseq.hasOwnProperty(b+"eq")){d=function(f,g){return f+" "+e+"= "+g}}else{d=function(f,g){return f+" = "+f+" "+e+" "+g}}}numeric[b+"VV"]=numeric.pointwise2(["x[i]","y[i]"],c("ret[i]","x[i]","y[i]"),a);numeric[b+"SV"]=numeric.pointwise2(["x","y[i]"],c("ret[i]","x","y[i]"),a);numeric[b+"VS"]=numeric.pointwise2(["x[i]","y"],c("ret[i]","x[i]","y"),a);numeric[b]=Function("var n = arguments.length, i, x = arguments[0], y;\nvar VV = numeric."+b+"VV, VS = numeric."+b+"VS, SV = numeric."+b+'SV;\nvar dim = numeric.dim;\nfor(i=1;i!==n;++i) { \n  y = arguments[i];\n  if(typeof x === "object") {\n      if(typeof y === "object") x = numeric._biforeach2(x,y,dim(x),0,VV);\n      else x = numeric._biforeach2(x,y,dim(x),0,VS);\n  } else if(typeof y === "object") x = numeric._biforeach2(x,y,dim(y),0,SV);\n  else '+d("x","y")+"\n}\nreturn x;\n");numeric[e]=numeric[b];numeric[b+"eqV"]=numeric.pointwise2(["ret[i]","x[i]"],d("ret[i]","x[i]"),a);numeric[b+"eqS"]=numeric.pointwise2(["ret[i]","x"],d("ret[i]","x"),a);numeric[b+"eq"]=Function("var n = arguments.length, i, x = arguments[0], y;\nvar V = numeric."+b+"eqV, S = numeric."+b+'eqS\nvar s = numeric.dim(x);\nfor(i=1;i!==n;++i) { \n  y = arguments[i];\n  if(typeof y === "object") numeric._biforeach(x,y,s,0,V);\n  else numeric._biforeach(x,y,s,0,S);\n}\nreturn x;\n')}}for(b=0;b<numeric.mathfuns2.length;++b){e=numeric.mathfuns2[b];delete numeric.ops2[e]}for(b=0;b<numeric.mathfuns.length;++b){e=numeric.mathfuns[b];numeric.ops1[e]=e}for(b in numeric.ops1){if(numeric.ops1.hasOwnProperty(b)){a="";e=numeric.ops1[b];if(numeric.myIndexOf.call(numeric.mathfuns,b)!==-1){if(Math.hasOwnProperty(e)){a="var "+e+" = Math."+e+";\n"}}numeric[b+"eqV"]=numeric.pointwise2(["ret[i]"],"ret[i] = "+e+"(ret[i]);",a);numeric[b+"eq"]=Function("x",'if(typeof x !== "object") return '+e+"x\nvar i;\nvar V = numeric."+b+"eqV;\nvar s = numeric.dim(x);\nnumeric._foreach(x,s,0,V);\nreturn x;\n");numeric[b+"V"]=numeric.pointwise2(["x[i]"],"ret[i] = "+e+"(x[i]);",a);numeric[b]=Function("x",'if(typeof x !== "object") return '+e+"(x)\nvar i;\nvar V = numeric."+b+"V;\nvar s = numeric.dim(x);\nreturn numeric._foreach2(x,s,0,V);\n")}}for(b=0;b<numeric.mathfuns.length;++b){e=numeric.mathfuns[b];delete numeric.ops1[e]}for(b in numeric.mapreducers){if(numeric.mapreducers.hasOwnProperty(b)){e=numeric.mapreducers[b];numeric[b+"V"]=numeric.mapreduce2(e[0],e[1]);numeric[b]=Function("x","s","k",e[1]+'if(typeof x !== "object") {    xi = x;\n'+e[0]+';\n    return accum;\n}if(typeof s === "undefined") s = numeric.dim(x);\nif(typeof k === "undefined") k = 0;\nif(k === s.length-1) return numeric.'+b+"V(x);\nvar xi;\nvar n = x.length, i;\nfor(i=n-1;i!==-1;--i) {\n   xi = arguments.callee(x[i]);\n"+e[0]+";\n}\nreturn accum;\n")}}}());numeric.inv=function inv(o){var v=numeric.dim(o),w=Math.abs,d=v[0],c=v[1];var b=numeric.clone(o),q,l;var p=numeric.identity(d),a,u;var h,g,e,o;for(g=0;g<c;++g){var f=-1;var r=-1;for(h=g;h!==d;++h){e=w(b[h][g]);if(e>r){f=h;r=e}}l=b[f];b[f]=b[g];b[g]=l;u=p[f];p[f]=p[g];p[g]=u;o=l[g];for(e=g;e!==c;++e){l[e]/=o}for(e=c-1;e!==-1;--e){u[e]/=o}for(h=d-1;h!==-1;--h){if(h!==g){q=b[h];a=p[h];o=q[g];for(e=g+1;e!==c;++e){q[e]-=l[e]*o}for(e=c-1;e>0;--e){a[e]-=u[e]*o;--e;a[e]-=u[e]*o}if(e===0){a[0]-=u[0]*o}}}}return p};numeric.det=function det(p){var u=numeric.dim(p);if(u.length!==2||u[0]!==u[1]){throw new Error("numeric: det() only works on square matrices")}var b=u[0],l=1,f,e,d,a=numeric.clone(p),o,q,c,r,m,h,g;for(e=0;e<b-1;e++){d=e;for(f=e+1;f<b;f++){if(Math.abs(a[f][e])>Math.abs(a[d][e])){d=f}}if(d!==e){r=a[d];a[d]=a[e];a[e]=r;l*=-1}o=a[e];for(f=e+1;f<b;f++){q=a[f];c=q[e]/o[e];for(d=e+1;d<b-1;d+=2){m=d+1;q[d]-=o[d]*c;q[m]-=o[m]*c}if(d!==b){q[d]-=o[d]*c}}if(o[e]===0){return 0}l*=o[e]}return l*a[e][e]};numeric.transpose=function transpose(k){var g,e,c=k.length,a=k[0].length,h=Array(a),d,b,f;for(e=0;e<a;e++){h[e]=Array(c)}for(g=c-1;g>=1;g-=2){b=k[g];d=k[g-1];for(e=a-1;e>=1;--e){f=h[e];f[g]=b[e];f[g-1]=d[e];--e;f=h[e];f[g]=b[e];f[g-1]=d[e]}if(e===0){f=h[0];f[g]=b[0];f[g-1]=d[0]}}if(g===0){d=k[0];for(e=a-1;e>=1;--e){h[e][0]=d[e];--e;h[e][0]=d[e]}if(e===0){h[0][0]=d[0]}}return h};numeric.negtranspose=function negtranspose(k){var g,e,c=k.length,a=k[0].length,h=Array(a),d,b,f;for(e=0;e<a;e++){h[e]=Array(c)}for(g=c-1;g>=1;g-=2){b=k[g];d=k[g-1];for(e=a-1;e>=1;--e){f=h[e];f[g]=-b[e];f[g-1]=-d[e];--e;f=h[e];f[g]=-b[e];f[g-1]=-d[e]}if(e===0){f=h[0];f[g]=-b[0];f[g-1]=-d[0]}}if(g===0){d=k[0];for(e=a-1;e>=1;--e){h[e][0]=-d[e];--e;h[e][0]=-d[e]}if(e===0){h[0][0]=-d[0]}}return h};numeric.norm2=function norm2(a){return Math.sqrt(numeric.norm2Squared(a))};numeric.getBlock=function getBlock(a,e,d){var b=numeric.dim(a);function c(f,h){var l,g=e[h],m=d[h]-g,j=Array(m);if(h===b.length-1){for(l=m;l>=0;l--){j[l]=f[l+g]}return j}for(l=m;l>=0;l--){j[l]=c(f[l+g],h+1)}return j}return c(a,0)};numeric.setBlock=function setBlock(a,f,e,d){var b=numeric.dim(a);function c(g,o,j){var l,h=f[j],m=e[j]-h;if(j===b.length-1){for(l=m;l>=0;l--){g[l+h]=o[l]}}for(l=m;l>=0;l--){c(g[l+h],o[l],j+1)}}c(a,d,0);return a};numeric.getRange=function getRange(b,l,k){var e=l.length,d=k.length;var g,f;var a=Array(e),h,c;for(g=e-1;g!==-1;--g){a[g]=Array(d);h=a[g];c=b[l[g]];for(f=d-1;f!==-1;--f){h[f]=c[k[f]]}}return a};numeric.tensor=function tensor(h,g){if(typeof h==="number"||typeof g==="number"){return numeric.mul(h,g)}var o=numeric.dim(h),k=numeric.dim(g);if(o.length!==1||k.length!==1){throw new Error("numeric: tensor product is only defined for vectors")}var c=o[0],b=k[0],a=Array(c),l,e,d,f;for(e=c-1;e>=0;e--){l=Array(b);f=h[e];for(d=b-1;d>=3;--d){l[d]=f*g[d];--d;l[d]=f*g[d];--d;l[d]=f*g[d];--d;l[d]=f*g[d]}while(d>=0){l[d]=f*g[d];--d}a[e]=l}return a};numeric.T=function T(a,b){this.x=a;this.y=b};numeric.t=function t(a,b){return new numeric.T(a,b)};numeric.Tbinop=function Tbinop(c,e,d,g,a){var f=numeric.indexOf;if(typeof a!=="string"){var b;a="";for(b in numeric){if(numeric.hasOwnProperty(b)&&(c.indexOf(b)>=0||e.indexOf(b)>=0||d.indexOf(b)>=0||g.indexOf(b)>=0)&&b.length>1){a+="var "+b+" = numeric."+b+";\n"}}}return Function(["y"],"var x = this;\nif(!(y instanceof numeric.T)) { y = new numeric.T(y); }\n"+a+"\nif(x.y) {  if(y.y) {    return new numeric.T("+g+");\n  }\n  return new numeric.T("+d+");\n}\nif(y.y) {\n  return new numeric.T("+e+");\n}\nreturn new numeric.T("+c+");\n")};numeric.T.prototype.add=numeric.Tbinop("add(x.x,y.x)","add(x.x,y.x),y.y","add(x.x,y.x),x.y","add(x.x,y.x),add(x.y,y.y)");numeric.T.prototype.sub=numeric.Tbinop("sub(x.x,y.x)","sub(x.x,y.x),neg(y.y)","sub(x.x,y.x),x.y","sub(x.x,y.x),sub(x.y,y.y)");numeric.T.prototype.mul=numeric.Tbinop("mul(x.x,y.x)","mul(x.x,y.x),mul(x.x,y.y)","mul(x.x,y.x),mul(x.y,y.x)","sub(mul(x.x,y.x),mul(x.y,y.y)),add(mul(x.x,y.y),mul(x.y,y.x))");numeric.T.prototype.reciprocal=function reciprocal(){var a=numeric.mul,c=numeric.div;if(this.y){var b=numeric.add(a(this.x,this.x),a(this.y,this.y));return new numeric.T(c(this.x,b),c(numeric.neg(this.y),b))}return new T(c(1,this.x))};numeric.T.prototype.div=function div(b){if(!(b instanceof numeric.T)){b=new numeric.T(b)}if(b.y){return this.mul(b.reciprocal())}var a=numeric.div;if(this.y){return new numeric.T(a(this.x,b.x),a(this.y,b.x))}return new numeric.T(a(this.x,b.x))};numeric.T.prototype.dot=numeric.Tbinop("dot(x.x,y.x)","dot(x.x,y.x),dot(x.x,y.y)","dot(x.x,y.x),dot(x.y,y.x)","sub(dot(x.x,y.x),dot(x.y,y.y)),add(dot(x.x,y.y),dot(x.y,y.x))");numeric.T.prototype.transpose=function transpose(){var b=numeric.transpose,a=this.x,c=this.y;if(c){return new numeric.T(b(a),b(c))}return new numeric.T(b(a))};numeric.T.prototype.transjugate=function transjugate(){var b=numeric.transpose,a=this.x,c=this.y;if(c){return new numeric.T(b(a),numeric.negtranspose(c))}return new numeric.T(b(a))};numeric.Tunop=function Tunop(b,d,a){if(typeof a!=="string"){a=""}return Function("var x = this;\n"+a+"\nif(x.y) {  "+d+";\n}\n"+b+";\n")};numeric.T.prototype.exp=numeric.Tunop("return new numeric.T(ex)","return new numeric.T(mul(cos(x.y),ex),mul(sin(x.y),ex))","var ex = numeric.exp(x.x), cos = numeric.cos, sin = numeric.sin, mul = numeric.mul;");numeric.T.prototype.conj=numeric.Tunop("return new numeric.T(x.x);","return new numeric.T(x.x,numeric.neg(x.y));");numeric.T.prototype.neg=numeric.Tunop("return new numeric.T(neg(x.x));","return new numeric.T(neg(x.x),neg(x.y));","var neg = numeric.neg;");numeric.T.prototype.sin=numeric.Tunop("return new numeric.T(numeric.sin(x.x))","return x.exp().sub(x.neg().exp()).div(new numeric.T(0,2));");numeric.T.prototype.cos=numeric.Tunop("return new numeric.T(numeric.cos(x.x))","return x.exp().add(x.neg().exp()).div(2);");numeric.T.prototype.abs=numeric.Tunop("return new numeric.T(numeric.abs(x.x));","return new numeric.T(numeric.sqrt(numeric.add(mul(x.x,x.x),mul(x.y,x.y))));","var mul = numeric.mul;");numeric.T.prototype.log=numeric.Tunop("return new numeric.T(numeric.log(x.x));","var theta = new numeric.T(numeric.atan2(x.y,x.x)), r = x.abs();\nreturn new numeric.T(numeric.log(r.x),theta.x);");numeric.T.prototype.norm2=numeric.Tunop("return numeric.norm2(x.x);","var f = numeric.norm2Squared;\nreturn Math.sqrt(f(x.x)+f(x.y));");numeric.T.prototype.get=function get(d){var a=this.x,f=this.y,b=0,c,e=d.length;if(f){while(b<e){c=d[b];a=a[c];f=f[c];b++}return new numeric.T(a,f)}while(b<e){c=d[b];a=a[c];b++}return new numeric.T(a)};numeric.T.prototype.set=function set(c,j){var g=this.x,e=this.y,b=0,h,a=c.length,f=j.x,d=j.y;if(a===0){if(d){this.y=d}else{if(e){this.y=undefined}}this.x=g;return this}if(d){if(e){}else{e=numeric.rep(numeric.dim(g),0);this.y=e}while(b<a-1){h=c[b];g=g[h];e=e[h];b++}h=c[b];g[h]=f;e[h]=d;return this}if(e){while(b<a-1){h=c[b];g=g[h];e=e[h];b++}h=c[b];g[h]=f;if(f instanceof Array){e[h]=numeric.rep(numeric.dim(f),0)}else{e[h]=0}return this}while(b<a-1){h=c[b];g=g[h];b++}h=c[b];g[h]=f;return this};numeric.T.prototype.getRows=function getRows(e,c){var h=c-e+1,b;var f=Array(h),d,a=this.x,g=this.y;for(b=e;b<=c;b++){f[b-e]=a[b]}if(g){d=Array(h);for(b=e;b<=c;b++){d[b-e]=g[b]}return new numeric.T(f,d)}return new numeric.T(f)};numeric.T.prototype.setRows=function setRows(f,d,b){var c;var g=this.x,e=this.y,a=b.x,h=b.y;for(c=f;c<=d;c++){g[c]=a[c-f]}if(h){if(!e){e=numeric.rep(numeric.dim(g),0);this.y=e}for(c=f;c<=d;c++){e[c]=h[c-f]}}else{if(e){for(c=f;c<=d;c++){e[c]=numeric.rep([a[c-f].length],0)}}}return this};numeric.T.prototype.getRow=function getRow(b){var a=this.x,c=this.y;if(c){return new numeric.T(a[b],c[b])}return new numeric.T(a[b])};numeric.T.prototype.setRow=function setRow(c,b){var e=this.x,d=this.y,a=b.x,f=b.y;e[c]=a;if(f){if(!d){d=numeric.rep(numeric.dim(e),0);this.y=d}d[c]=f}else{if(d){d=numeric.rep([a.length],0)}}return this};numeric.T.prototype.getBlock=function getBlock(f,e){var c=this.x,d=this.y,a=numeric.getBlock;if(d){return new numeric.T(a(c,f,e),a(d,f,e))}return new numeric.T(a(c,f,e))};numeric.T.prototype.setBlock=function setBlock(i,h,d){if(!(d instanceof numeric.T)){d=new numeric.T(d)}var c=this.x,g=this.y,a=numeric.setBlock,f=d.x,e=d.y;if(e){if(!g){this.y=numeric.rep(numeric.dim(this),0);g=this.y}a(c,i,h,f);a(g,i,h,e);return this}a(c,i,h,f);if(g){a(g,i,h,numeric.rep(numeric.dim(f),0))}};numeric.T.rep=function rep(d,b){var c=numeric.T;if(!(b instanceof c)){b=new c(b)}var a=b.x,f=b.y,e=numeric.rep;if(f){return new c(e(d,a),e(d,f))}return new c(e(d,a))};numeric.T.diag=function diag(c){if(!(c instanceof numeric.T)){c=new numeric.T(c)}var a=c.x,e=c.y,b=numeric.diag;if(e){return new numeric.T(b(a),b(e))}return new numeric.T(b(a))};numeric.T.eig=function eig(){if(this.y){throw new Error("eig: not implemented for complex matrices.")}return numeric.eig(this.x)};numeric.T.identity=function identity(a){return new numeric.T(numeric.identity(a))};numeric.T.prototype.getDiag=function getDiag(){var c=numeric;var a=this.x,b=this.y;if(b){return new c.T(c.getDiag(a),c.getDiag(b))}return new c.T(c.getDiag(a))};numeric.house=function house(a){var b=numeric.clone(a);var c=a[0]>=0?1:-1;var d=c*numeric.norm2(a);b[0]+=d;var e=numeric.norm2(b);if(e===0){throw new Error("eig: internal error")}return numeric.div(b,e)};numeric.toUpperHessenberg=function toUpperHessenberg(o){var u=numeric.dim(o);if(u.length!==2||u[0]!==u[1]){throw new Error("numeric: toUpperHessenberg() only works on square matrices")}var f=u[0],l,h,g,p,r,d=numeric.clone(o),c,a,q,b,n=numeric.identity(f),e;for(h=0;h<f-2;h++){p=Array(f-h-1);for(l=h+1;l<f;l++){p[l-h-1]=d[l][h]}if(numeric.norm2(p)>0){r=numeric.house(p);c=numeric.getBlock(d,[h+1,h],[f-1,f-1]);a=numeric.tensor(r,numeric.dot(r,c));for(l=h+1;l<f;l++){q=d[l];b=a[l-h-1];for(g=h;g<f;g++){q[g]-=2*b[g-h]}}c=numeric.getBlock(d,[0,h+1],[f-1,f-1]);a=numeric.tensor(numeric.dot(c,r),r);for(l=0;l<f;l++){q=d[l];b=a[l];for(g=h+1;g<f;g++){q[g]-=2*b[g-h-1]}}c=Array(f-h-1);for(l=h+1;l<f;l++){c[l-h-1]=n[l]}a=numeric.tensor(r,numeric.dot(r,c));for(l=h+1;l<f;l++){e=n[l];b=a[l-h-1];for(g=0;g<f;g++){e[g]-=2*b[g]}}}}return{H:d,Q:n}};numeric.epsilon=2.220446049250313e-16;numeric.QRFrancis=function(z,h){if(typeof h==="undefined"){h=10000}z=numeric.clone(z);var D=numeric.clone(z);var E=numeric.dim(z),K=E[0],y,A,U,S,R,P,n,e,l,q=numeric.identity(K),u,r,I,G,F,O,M,L,N;if(K<3){return{Q:q,B:[[0,K-1]]}}var V=numeric.epsilon;for(N=0;N<h;N++){for(M=0;M<K-1;M++){if(Math.abs(z[M+1][M])<V*(Math.abs(z[M][M])+Math.abs(z[M+1][M+1]))){var p=numeric.QRFrancis(numeric.getBlock(z,[0,0],[M,M]),h);var o=numeric.QRFrancis(numeric.getBlock(z,[M+1,M+1],[K-1,K-1]),h);I=Array(M+1);for(O=0;O<=M;O++){I[O]=q[O]}G=numeric.dot(p.Q,I);for(O=0;O<=M;O++){q[O]=G[O]}I=Array(K-M-1);for(O=M+1;O<K;O++){I[O-M-1]=q[O]}G=numeric.dot(o.Q,I);for(O=M+1;O<K;O++){q[O]=G[O-M-1]}return{Q:q,B:p.B.concat(numeric.add(o.B,M+1))}}}U=z[K-2][K-2];S=z[K-2][K-1];R=z[K-1][K-2];P=z[K-1][K-1];e=U+P;n=(U*P-S*R);l=numeric.getBlock(z,[0,0],[2,2]);if(e*e>=4*n){var g,f;g=0.5*(e+Math.sqrt(e*e-4*n));f=0.5*(e-Math.sqrt(e*e-4*n));l=numeric.add(numeric.sub(numeric.dot(l,l),numeric.mul(l,g+f)),numeric.diag(numeric.rep([3],g*f)))}else{l=numeric.add(numeric.sub(numeric.dot(l,l),numeric.mul(l,e)),numeric.diag(numeric.rep([3],n)))}y=[l[0][0],l[1][0],l[2][0]];A=numeric.house(y);I=[z[0],z[1],z[2]];G=numeric.tensor(A,numeric.dot(A,I));for(O=0;O<3;O++){r=z[O];F=G[O];for(L=0;L<K;L++){r[L]-=2*F[L]}}I=numeric.getBlock(z,[0,0],[K-1,2]);G=numeric.tensor(numeric.dot(I,A),A);for(O=0;O<K;O++){r=z[O];F=G[O];for(L=0;L<3;L++){r[L]-=2*F[L]}}I=[q[0],q[1],q[2]];G=numeric.tensor(A,numeric.dot(A,I));for(O=0;O<3;O++){u=q[O];F=G[O];for(L=0;L<K;L++){u[L]-=2*F[L]}}var w;for(M=0;M<K-2;M++){for(L=M;L<=M+1;L++){if(Math.abs(z[L+1][L])<V*(Math.abs(z[L][L])+Math.abs(z[L+1][L+1]))){var p=numeric.QRFrancis(numeric.getBlock(z,[0,0],[L,L]),h);var o=numeric.QRFrancis(numeric.getBlock(z,[L+1,L+1],[K-1,K-1]),h);I=Array(L+1);for(O=0;O<=L;O++){I[O]=q[O]}G=numeric.dot(p.Q,I);for(O=0;O<=L;O++){q[O]=G[O]}I=Array(K-L-1);for(O=L+1;O<K;O++){I[O-L-1]=q[O]}G=numeric.dot(o.Q,I);for(O=L+1;O<K;O++){q[O]=G[O-L-1]}return{Q:q,B:p.B.concat(numeric.add(o.B,L+1))}}}w=Math.min(K-1,M+3);y=Array(w-M);for(O=M+1;O<=w;O++){y[O-M-1]=z[O][M]}A=numeric.house(y);I=numeric.getBlock(z,[M+1,M],[w,K-1]);G=numeric.tensor(A,numeric.dot(A,I));for(O=M+1;O<=w;O++){r=z[O];F=G[O-M-1];for(L=M;L<K;L++){r[L]-=2*F[L-M]}}I=numeric.getBlock(z,[0,M+1],[K-1,w]);G=numeric.tensor(numeric.dot(I,A),A);for(O=0;O<K;O++){r=z[O];F=G[O];for(L=M+1;L<=w;L++){r[L]-=2*F[L-M-1]}}I=Array(w-M);for(O=M+1;O<=w;O++){I[O-M-1]=q[O]}G=numeric.tensor(A,numeric.dot(A,I));for(O=M+1;O<=w;O++){u=q[O];F=G[O-M-1];for(L=0;L<K;L++){u[L]-=2*F[L]}}}}throw new Error("numeric: eigenvalue iteration does not converge -- increase maxiter?")};numeric.eig=function eig(L,l){var f=numeric.toUpperHessenberg(L);var o=numeric.QRFrancis(f.H,l);var r=numeric.T;var O=L.length,W,S,V=false,J=o.B,D=numeric.dot(o.Q,numeric.dot(f.H,numeric.transpose(o.Q)));var u=new r(numeric.dot(o.Q,f.Q)),G;var P=J.length,U;var aa,Z,Y,X,h,g,e,C,z,K,I,w,v;var ab=Math.sqrt;for(S=0;S<P;S++){W=J[S][0];if(W===J[S][1]){}else{U=W+1;aa=D[W][W];Z=D[W][U];Y=D[U][W];X=D[U][U];if(Z===0&&Y===0){continue}h=-aa-X;g=aa*X-Z*Y;e=h*h-4*g;if(e>=0){if(h<0){C=-0.5*(h-ab(e))}else{C=-0.5*(h+ab(e))}w=(aa-C)*(aa-C)+Z*Z;v=Y*Y+(X-C)*(X-C);if(w>v){w=ab(w);K=(aa-C)/w;I=Z/w}else{v=ab(v);K=Y/v;I=(X-C)/v}G=new r([[I,-K],[K,I]]);u.setRows(W,U,G.dot(u.getRows(W,U)))}else{C=-0.5*h;z=0.5*ab(-e);w=(aa-C)*(aa-C)+Z*Z;v=Y*Y+(X-C)*(X-C);if(w>v){w=ab(w+z*z);K=(aa-C)/w;I=Z/w;C=0;z/=w}else{v=ab(v+z*z);K=Y/v;I=(X-C)/v;C=z/v;z=0}G=new r([[I,-K],[K,I]],[[C,z],[z,-C]]);u.setRows(W,U,G.dot(u.getRows(W,U)))}}}var s=u.dot(L).dot(u.transjugate()),O=L.length,F=numeric.T.identity(O);for(U=0;U<O;U++){if(U>0){for(S=U-1;S>=0;S--){var M=s.get([S,S]),N=s.get([U,U]);if(numeric.neq(M.x,N.x)||numeric.neq(M.y,N.y)){C=s.getRow(S).getBlock([S],[U-1]);z=F.getRow(U).getBlock([S],[U-1]);F.set([U,S],(s.get([S,U]).neg().sub(C.dot(z))).div(M.sub(N)))}else{F.setRow(U,F.getRow(S));continue}}}}for(U=0;U<O;U++){C=F.getRow(U);F.setRow(U,C.div(C.norm2()))}F=F.transpose();F=u.transjugate().dot(F);return{lambda:s.getDiag(),E:F}};/*!!
 *  Canvas 2 Svg v1.0.19
 *  A low level canvas to SVG converter. Uses a mock canvas context to build an SVG document.
 *
 *  Licensed under the MIT license:
 *  http://www.opensource.org/licenses/mit-license.php
 *
 *  Author:
 *  Kerry Liu
 *
 *  Copyright (c) 2014 Gliffy Inc.
 */
;(function(){var j,k,i,e,a;function g(o,l){var n=Object.keys(l),m;for(m=0;m<n.length;m++){o=o.replace(new RegExp("\\{"+n[m]+"\\}","gi"),l[n[m]])}return o}function h(m){var o,n,l;if(!m){throw new Error("cannot create a random attribute name for an undefined object")}o="ABCDEFGHIJKLMNOPQRSTUVWXTZabcdefghiklmnopqrstuvwxyz";n="";do{n="";for(l=0;l<12;l++){n+=o[Math.floor(Math.random()*o.length)]}}while(m[n]);return n}function d(n,p){var o,m,r={},q,l;n=n.split(",");p=p||10;for(o=0;o<n.length;o+=2){m="&"+n[o+1]+";";q=parseInt(n[o],p);r[m]="&#"+q+";"}r["\\xa0"]="&#160;";return r}function f(m){var l={left:"start",right:"end",center:"middle",start:"start",end:"end"};return l[m]||l.start}function c(m){var l={alphabetic:"alphabetic",hanging:"hanging",top:"text-before-edge",bottom:"text-after-edge",middle:"central"};return l[m]||l.alphabetic}a=d("50,nbsp,51,iexcl,52,cent,53,pound,54,curren,55,yen,56,brvbar,57,sect,58,uml,59,copy,5a,ordf,5b,laquo,5c,not,5d,shy,5e,reg,5f,macr,5g,deg,5h,plusmn,5i,sup2,5j,sup3,5k,acute,5l,micro,5m,para,5n,middot,5o,cedil,5p,sup1,5q,ordm,5r,raquo,5s,frac14,5t,frac12,5u,frac34,5v,iquest,60,Agrave,61,Aacute,62,Acirc,63,Atilde,64,Auml,65,Aring,66,AElig,67,Ccedil,68,Egrave,69,Eacute,6a,Ecirc,6b,Euml,6c,Igrave,6d,Iacute,6e,Icirc,6f,Iuml,6g,ETH,6h,Ntilde,6i,Ograve,6j,Oacute,6k,Ocirc,6l,Otilde,6m,Ouml,6n,times,6o,Oslash,6p,Ugrave,6q,Uacute,6r,Ucirc,6s,Uuml,6t,Yacute,6u,THORN,6v,szlig,70,agrave,71,aacute,72,acirc,73,atilde,74,auml,75,aring,76,aelig,77,ccedil,78,egrave,79,eacute,7a,ecirc,7b,euml,7c,igrave,7d,iacute,7e,icirc,7f,iuml,7g,eth,7h,ntilde,7i,ograve,7j,oacute,7k,ocirc,7l,otilde,7m,ouml,7n,divide,7o,oslash,7p,ugrave,7q,uacute,7r,ucirc,7s,uuml,7t,yacute,7u,thorn,7v,yuml,ci,fnof,sh,Alpha,si,Beta,sj,Gamma,sk,Delta,sl,Epsilon,sm,Zeta,sn,Eta,so,Theta,sp,Iota,sq,Kappa,sr,Lambda,ss,Mu,st,Nu,su,Xi,sv,Omicron,t0,Pi,t1,Rho,t3,Sigma,t4,Tau,t5,Upsilon,t6,Phi,t7,Chi,t8,Psi,t9,Omega,th,alpha,ti,beta,tj,gamma,tk,delta,tl,epsilon,tm,zeta,tn,eta,to,theta,tp,iota,tq,kappa,tr,lambda,ts,mu,tt,nu,tu,xi,tv,omicron,u0,pi,u1,rho,u2,sigmaf,u3,sigma,u4,tau,u5,upsilon,u6,phi,u7,chi,u8,psi,u9,omega,uh,thetasym,ui,upsih,um,piv,812,bull,816,hellip,81i,prime,81j,Prime,81u,oline,824,frasl,88o,weierp,88h,image,88s,real,892,trade,89l,alefsym,8cg,larr,8ch,uarr,8ci,rarr,8cj,darr,8ck,harr,8dl,crarr,8eg,lArr,8eh,uArr,8ei,rArr,8ej,dArr,8ek,hArr,8g0,forall,8g2,part,8g3,exist,8g5,empty,8g7,nabla,8g8,isin,8g9,notin,8gb,ni,8gf,prod,8gh,sum,8gi,minus,8gn,lowast,8gq,radic,8gt,prop,8gu,infin,8h0,ang,8h7,and,8h8,or,8h9,cap,8ha,cup,8hb,int,8hk,there4,8hs,sim,8i5,cong,8i8,asymp,8j0,ne,8j1,equiv,8j4,le,8j5,ge,8k2,sub,8k3,sup,8k4,nsub,8k6,sube,8k7,supe,8kl,oplus,8kn,otimes,8l5,perp,8m5,sdot,8o8,lceil,8o9,rceil,8oa,lfloor,8ob,rfloor,8p9,lang,8pa,rang,9ea,loz,9j0,spades,9j3,clubs,9j5,hearts,9j6,diams,ai,OElig,aj,oelig,b0,Scaron,b1,scaron,bo,Yuml,m6,circ,ms,tilde,802,ensp,803,emsp,809,thinsp,80c,zwnj,80d,zwj,80e,lrm,80f,rlm,80j,ndash,80k,mdash,80o,lsquo,80p,rsquo,80q,sbquo,80s,ldquo,80t,rdquo,80u,bdquo,810,dagger,811,Dagger,81g,permil,81p,lsaquo,81q,rsaquo,85c,euro",32);j={strokeStyle:{svgAttr:"stroke",canvas:"#000000",svg:"none",apply:"stroke"},fillStyle:{svgAttr:"fill",canvas:"#000000",svg:null,apply:"fill"},lineCap:{svgAttr:"stroke-linecap",canvas:"butt",svg:"butt",apply:"stroke"},lineJoin:{svgAttr:"stroke-linejoin",canvas:"miter",svg:"miter",apply:"stroke"},miterLimit:{svgAttr:"stroke-miterlimit",canvas:10,svg:4,apply:"stroke"},lineWidth:{svgAttr:"stroke-width",canvas:1,svg:1,apply:"stroke"},globalAlpha:{svgAttr:"opacity",canvas:1,svg:1,apply:"fill stroke"},font:{canvas:"10px sans-serif"},shadowColor:{canvas:"#000000"},shadowOffsetX:{canvas:0},shadowOffsetY:{canvas:0},shadowBlur:{canvas:0},textAlign:{canvas:"start"},textBaseline:{canvas:"alphabetic"},lineDash:{svgAttr:"stroke-dasharray",canvas:[],svg:null,apply:"stroke"}};i=function(m,l){this.__root=m;this.__ctx=l};i.prototype.addColorStop=function(p,l){var m=this.__ctx.__createElement("stop"),n,o;m.setAttribute("offset",p);if(l.indexOf("rgba")!==-1){n=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;o=n.exec(l);m.setAttribute("stop-color",g("rgb({r},{g},{b})",{r:o[1],g:o[2],b:o[3]}));m.setAttribute("stop-opacity",o[4])}else{m.setAttribute("stop-color",l)}this.__root.appendChild(m)};e=function(m,l){this.__root=m;this.__ctx=l};k=function(n){var l={width:500,height:500,enableMirroring:false},m;if(arguments.length>1){m=l;m.width=arguments[0];m.height=arguments[1]}else{if(!n){m=l}else{m=n}}if(!(this instanceof k)){return new k(m)}this.width=m.width||l.width;this.height=m.height||l.height;this.enableMirroring=m.enableMirroring!==undefined?m.enableMirroring:l.enableMirroring;this.canvas=this;this.__document=m.document||document;if(m.ctx){this.__ctx=m.ctx}else{this.__canvas=this.__document.createElement("canvas");this.__ctx=this.__canvas.getContext("2d")}this.__setDefaultStyles();this.__stack=[this.__getStyleState()];this.__groupStack=[];this.__root=this.__document.createElementNS("http://www.w3.org/2000/svg","svg");this.__root.setAttribute("version",1.1);this.__root.setAttribute("xmlns","http://www.w3.org/2000/svg");this.__root.setAttributeNS("http://www.w3.org/2000/xmlns/","xmlns:xlink","http://www.w3.org/1999/xlink");this.__root.setAttribute("width",this.width);this.__root.setAttribute("height",this.height);this.__ids={};this.__defs=this.__document.createElementNS("http://www.w3.org/2000/svg","defs");this.__root.appendChild(this.__defs);this.__currentElement=this.__document.createElementNS("http://www.w3.org/2000/svg","g");this.__root.appendChild(this.__currentElement)};k.prototype.__createElement=function(l,p,r){if(typeof p==="undefined"){p={}}var o=this.__document.createElementNS("http://www.w3.org/2000/svg",l),q=Object.keys(p),n,m;if(r){o.setAttribute("fill","none");o.setAttribute("stroke","none")}for(n=0;n<q.length;n++){m=q[n];o.setAttribute(m,p[m])}return o};k.prototype.__setDefaultStyles=function(){var n=Object.keys(j),m,l;for(m=0;m<n.length;m++){l=n[m];this[l]=j[l].canvas}};k.prototype.__applyStyleState=function(l){var o=Object.keys(l),n,m;for(n=0;n<o.length;n++){m=o[n];this[m]=l[m]}};k.prototype.__getStyleState=function(){var n,l={},o=Object.keys(j),m;for(n=0;n<o.length;n++){m=o[n];l[m]=this[m]}return l};k.prototype.__applyStyleToCurrentElement=function(u){var q=this.__currentElement;var n=this.__currentElementsToStyle;if(n){q.setAttribute(u,"");q=n.element;n.children.forEach(function(y){y.setAttribute(u,"")})}var x=Object.keys(j),o,l,w,m,v,p;for(o=0;o<x.length;o++){l=j[x[o]];w=this[x[o]];if(l.apply){if(w instanceof e){if(w.__ctx){while(w.__ctx.__defs.childNodes.length){m=w.__ctx.__defs.childNodes[0].getAttribute("id");this.__ids[m]=m;this.__defs.appendChild(w.__ctx.__defs.childNodes[0])}}q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(w instanceof i){q.setAttribute(l.apply,g("url(#{id})",{id:w.__root.getAttribute("id")}))}else{if(l.apply.indexOf(u)!==-1&&l.svg!==w){if((l.svgAttr==="stroke"||l.svgAttr==="fill")&&w.indexOf("rgba")!==-1){v=/rgba\(\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*,\s*(\d?\.?\d*)\s*\)/gi;p=v.exec(w);q.setAttribute(l.svgAttr,g("rgb({r},{g},{b})",{r:p[1],g:p[2],b:p[3]}));var r=p[4];var t=this.globalAlpha;if(t!=null){r*=t}q.setAttribute(l.svgAttr+"-opacity",r)}else{var s=l.svgAttr;if(x[o]==="globalAlpha"){s=u+"-"+l.svgAttr;if(q.getAttribute(s)){continue}}q.setAttribute(s,w)}}}}}}};k.prototype.__closestGroupOrSvg=function(l){l=l||this.__currentElement;if(l.nodeName==="g"||l.nodeName==="svg"){return l}else{return this.__closestGroupOrSvg(l.parentNode)}};k.prototype.getSerializedSvg=function(s){var q=new XMLSerializer().serializeToString(this.__root),n,m,l,p,o,r;r=/xmlns="http:\/\/www\.w3\.org\/2000\/svg".+xmlns="http:\/\/www\.w3\.org\/2000\/svg/gi;if(r.test(q)){q=q.replace('xmlns="http://www.w3.org/2000/svg','xmlns:xlink="http://www.w3.org/1999/xlink')}if(s){n=Object.keys(a);for(m=0;m<n.length;m++){l=n[m];p=a[l];o=new RegExp(l,"gi");if(o.test(q)){q=q.replace(o,p)}}}return q};k.prototype.getSvg=function(){return this.__root};k.prototype.save=function(){var m=this.__createElement("g");var l=this.__closestGroupOrSvg();this.__groupStack.push(l);l.appendChild(m);this.__currentElement=m;this.__stack.push(this.__getStyleState())};k.prototype.restore=function(){this.__currentElement=this.__groupStack.pop();this.__currentElementsToStyle=null;if(!this.__currentElement){this.__currentElement=this.__root.childNodes[1]}var l=this.__stack.pop();this.__applyStyleState(l)};k.prototype.__addTransform=function(m){var n=this.__closestGroupOrSvg();if(n.childNodes.length>0){if(this.__currentElement.nodeName==="path"){if(!this.__currentElementsToStyle){this.__currentElementsToStyle={element:n,children:[]}}this.__currentElementsToStyle.children.push(this.__currentElement);this.__applyCurrentDefaultPath()}var o=this.__createElement("g");n.appendChild(o);this.__currentElement=o}var l=this.__currentElement.getAttribute("transform");if(l){l+=" "}else{l=""}l+=m;this.__currentElement.setAttribute("transform",l)};k.prototype.scale=function(l,m){if(m===undefined){m=l}this.__addTransform(g("scale({x},{y})",{x:l,y:m}))};k.prototype.rotate=function(m){var l=(m*180/Math.PI);this.__addTransform(g("rotate({angle},{cx},{cy})",{angle:l,cx:0,cy:0}))};k.prototype.translate=function(l,m){this.__addTransform(g("translate({x},{y})",{x:l,y:m}))};k.prototype.transform=function(m,l,q,p,o,n){this.__addTransform(g("matrix({a},{b},{c},{d},{e},{f})",{a:m,b:l,c:q,d:p,e:o,f:n}))};k.prototype.beginPath=function(){var m,l;this.__currentDefaultPath="";this.__currentPosition={};m=this.__createElement("path",{},true);l=this.__closestGroupOrSvg();l.appendChild(m);this.__currentElement=m};k.prototype.__applyCurrentDefaultPath=function(){var l=this.__currentElement;if(l.nodeName==="path"){l.setAttribute("d",this.__currentDefaultPath)}else{console.error("Attempted to apply path command to node",l.nodeName)}};k.prototype.__addPathCommand=function(l){this.__currentDefaultPath+=" ";this.__currentDefaultPath+=l};k.prototype.moveTo=function(l,m){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.__currentPosition={x:l,y:m};this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))};k.prototype.closePath=function(){if(this.__currentDefaultPath){this.__addPathCommand("Z")}};k.prototype.lineTo=function(l,m){this.__currentPosition={x:l,y:m};if(this.__currentDefaultPath.indexOf("M")>-1){this.__addPathCommand(g("L {x} {y}",{x:l,y:m}))}else{this.__addPathCommand(g("M {x} {y}",{x:l,y:m}))}};k.prototype.bezierCurveTo=function(n,m,p,o,l,q){this.__currentPosition={x:l,y:q};this.__addPathCommand(g("C {cp1x} {cp1y} {cp2x} {cp2y} {x} {y}",{cp1x:n,cp1y:m,cp2x:p,cp2y:o,x:l,y:q}))};k.prototype.quadraticCurveTo=function(n,m,l,o){this.__currentPosition={x:l,y:o};this.__addPathCommand(g("Q {cpx} {cpy} {x} {y}",{cpx:n,cpy:m,x:l,y:o}))};var b=function(m){var l=Math.sqrt(m[0]*m[0]+m[1]*m[1]);return[m[0]/l,m[1]/l]};k.prototype.arcTo=function(F,o,E,n,q){var G=this.__currentPosition&&this.__currentPosition.x;var p=this.__currentPosition&&this.__currentPosition.y;if(typeof G=="undefined"||typeof p=="undefined"){return}if(q<0){throw new Error("IndexSizeError: The radius provided ("+q+") is negative.")}if(((G===F)&&(p===o))||((F===E)&&(o===n))||(q===0)){this.lineTo(F,o);return}var u=b([G-F,p-o]);var t=b([E-F,n-o]);if(u[0]*t[1]===u[1]*t[0]){this.lineTo(F,o);return}var m=(u[0]*t[0]+u[1]*t[1]);var v=Math.acos(Math.abs(m));var B=b([u[0]+t[0],u[1]+t[1]]);var r=q/Math.sin(v/2);var A=F+r*B[0];var z=o+r*B[1];var l=[-u[1],u[0]];var w=[t[1],-t[0]];var s=function(I){var H=I[0];var J=I[1];if(J>=0){return Math.acos(H)}else{return -Math.acos(H)}};var D=s(l);var C=s(w);this.lineTo(A+l[0]*q,z+l[1]*q);this.arc(A,z,q,D,C)};k.prototype.stroke=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","fill stroke markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("stroke")};k.prototype.fill=function(){if(this.__currentElement.nodeName==="path"){this.__currentElement.setAttribute("paint-order","stroke fill markers")}this.__applyCurrentDefaultPath();this.__applyStyleToCurrentElement("fill")};k.prototype.rect=function(m,o,n,l){if(this.__currentElement.nodeName!=="path"){this.beginPath()}this.moveTo(m,o);this.lineTo(m+n,o);this.lineTo(m+n,o+l);this.lineTo(m,o+l);this.lineTo(m,o);this.closePath()};k.prototype.fillRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("fill")};k.prototype.strokeRect=function(m,q,o,l){var p,n;p=this.__createElement("rect",{x:m,y:q,width:o,height:l},true);n=this.__closestGroupOrSvg();n.appendChild(p);this.__currentElement=p;this.__applyStyleToCurrentElement("stroke")};k.prototype.__clearCanvas=function(){var o=this.__closestGroupOrSvg(),l=o.getAttribute("transform");var n=this.__root.childNodes[1];var p=n.childNodes;for(var m=p.length-1;m>=0;m--){if(p[m]){n.removeChild(p[m])}}this.__currentElement=n;this.__groupStack=[];if(l){this.__addTransform(l)}};k.prototype.clearRect=function(m,q,o,l){if(m===0&&q===0&&o===this.width&&l===this.height){this.__clearCanvas();return}var p,n=this.__closestGroupOrSvg();p=this.__createElement("rect",{x:m,y:q,width:o,height:l,fill:"#FFFFFF"},true);n.appendChild(p)};k.prototype.createLinearGradient=function(m,o,l,n){var p=this.__createElement("linearGradient",{id:h(this.__ids),x1:m+"px",x2:l+"px",y1:o+"px",y2:n+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(p);return new i(p,this)};k.prototype.createRadialGradient=function(o,q,n,m,p,l){var r=this.__createElement("radialGradient",{id:h(this.__ids),cx:m+"px",cy:p+"px",r:l+"px",fx:o+"px",fy:q+"px",gradientUnits:"userSpaceOnUse"},false);this.__defs.appendChild(r);return new i(r,this)};k.prototype.__parseFont=function(){var m=/^\s*(?=(?:(?:[-a-z]+\s*){0,2}(italic|oblique))?)(?=(?:(?:[-a-z]+\s*){0,2}(small-caps))?)(?=(?:(?:[-a-z]+\s*){0,2}(bold(?:er)?|lighter|[1-9]00))?)(?:(?:normal|\1|\2|\3)\s*){0,3}((?:xx?-)?(?:small|large)|medium|smaller|larger|[.\d]+(?:\%|in|[cem]m|ex|p[ctx]))(?:\s*\/\s*(normal|[.\d]+(?:\%|in|[cem]m|ex|p[ctx])))?\s*([-,\'\"\sa-z0-9]+?)\s*$/i;var l=m.exec(this.font);var n={style:l[1]||"normal",size:l[4]||"10px",family:l[6]||"sans-serif",weight:l[3]||"normal",decoration:l[2]||"normal",href:null};if(this.__fontUnderline==="underline"){n.decoration="underline"}if(this.__fontHref){n.href=this.__fontHref}return n};k.prototype.__wrapTextLink=function(m,n){if(m.href){var l=this.__createElement("a");l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",m.href);l.appendChild(n);return l}return n};k.prototype.__applyText=function(q,l,r,p){var n=this.__parseFont(),o=this.__closestGroupOrSvg(),m=this.__createElement("text",{"font-family":n.family,"font-size":n.size,"font-style":n.style,"font-weight":n.weight,"text-decoration":n.decoration,x:l,y:r,"text-anchor":f(this.textAlign),"dominant-baseline":c(this.textBaseline)},true);m.appendChild(this.__document.createTextNode(q));this.__currentElement=m;this.__applyStyleToCurrentElement(p);o.appendChild(this.__wrapTextLink(n,m))};k.prototype.fillText=function(m,l,n){this.__applyText(m,l,n,"fill")};k.prototype.strokeText=function(m,l,n){this.__applyText(m,l,n,"stroke")};k.prototype.measureText=function(l){this.__ctx.font=this.font;return this.__ctx.measureText(l)};k.prototype.arc=function(t,s,q,r,m,v){if(r===m){return}r=r%(2*Math.PI);m=m%(2*Math.PI);if(r===m){m=((m+(2*Math.PI))-0.001*(v?-1:1))%(2*Math.PI)}var z=t+q*Math.cos(m),w=s+q*Math.sin(m),p=t+q*Math.cos(r),o=s+q*Math.sin(r),n=v?0:1,l=0,u=m-r;if(u<0){u+=2*Math.PI}if(v){l=u>Math.PI?0:1}else{l=u>Math.PI?1:0}this.lineTo(p,o);this.__addPathCommand(g("A {rx} {ry} {xAxisRotation} {largeArcFlag} {sweepFlag} {endX} {endY}",{rx:q,ry:q,xAxisRotation:0,largeArcFlag:l,sweepFlag:n,endX:z,endY:w}));this.__currentPosition={x:z,y:w}};k.prototype.clip=function(){var m=this.__closestGroupOrSvg(),l=this.__createElement("clipPath"),o=h(this.__ids),n=this.__createElement("g");this.__applyCurrentDefaultPath();m.removeChild(this.__currentElement);l.setAttribute("id",o);l.appendChild(this.__currentElement);this.__defs.appendChild(l);m.setAttribute("clip-path",g("url(#{id})",{id:o}));m.appendChild(n);this.__currentElement=n};k.prototype.drawImage=function(){var n=Array.prototype.slice.call(arguments),z=n[0],u,t,v,F,x=0,w=0,C,G,s,y,l,q,o,D,p,m,B;if(n.length===3){u=n[1];t=n[2];C=z.width;G=z.height;v=C;F=G}else{if(n.length===5){u=n[1];t=n[2];v=n[3];F=n[4];C=z.width;G=z.height}else{if(n.length===9){x=n[1];w=n[2];C=n[3];G=n[4];u=n[5];t=n[6];v=n[7];F=n[8]}else{throw new Error("Inavlid number of arguments passed to drawImage: "+arguments.length)}}}s=this.__closestGroupOrSvg();o=this.__currentElement;var r="translate("+u+", "+t+")";if(z instanceof k){y=z.getSvg().cloneNode(true);if(y.childNodes&&y.childNodes.length>1){l=y.childNodes[0];while(l.childNodes.length){B=l.childNodes[0].getAttribute("id");this.__ids[B]=B;this.__defs.appendChild(l.childNodes[0])}q=y.childNodes[1];if(q){var E=q.getAttribute("transform");var A;if(E){A=E+" "+r}else{A=r}q.setAttribute("transform",A);s.appendChild(q)}}}else{if(z.nodeName==="CANVAS"||z.nodeName==="IMG"){D=this.__createElement("image");D.setAttribute("width",v);D.setAttribute("height",F);D.setAttribute("preserveAspectRatio","none");if(x||w||C!==z.width||G!==z.height){p=this.__document.createElement("canvas");p.width=v;p.height=F;m=p.getContext("2d");m.drawImage(z,x,w,C,G,0,0,v,F);z=p}D.setAttribute("transform",r);D.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",z.nodeName==="CANVAS"?z.toDataURL():z.getAttribute("src"));s.appendChild(D)}}};k.prototype.createPattern=function(o,m){var n=this.__document.createElementNS("http://www.w3.org/2000/svg","pattern"),p=h(this.__ids),l;n.setAttribute("id",p);n.setAttribute("width",o.width);n.setAttribute("height",o.height);if(o.nodeName==="CANVAS"||o.nodeName==="IMG"){l=this.__document.createElementNS("http://www.w3.org/2000/svg","image");l.setAttribute("width",o.width);l.setAttribute("height",o.height);l.setAttributeNS("http://www.w3.org/1999/xlink","xlink:href",o.nodeName==="CANVAS"?o.toDataURL():o.getAttribute("src"));n.appendChild(l);this.__defs.appendChild(n)}else{if(o instanceof k){n.appendChild(o.__root.childNodes[1]);this.__defs.appendChild(n)}}return new e(n,this)};k.prototype.setLineDash=function(l){if(l&&l.length>0){this.lineDash=l.join(",")}else{this.lineDash=null}};k.prototype.drawFocusRing=function(){};k.prototype.createImageData=function(){};k.prototype.getImageData=function(){};k.prototype.putImageData=function(){};k.prototype.globalCompositeOperation=function(){};k.prototype.setTransform=function(){};if(typeof window==="object"){window.C2S=k}if(typeof module==="object"&&typeof module.exports==="object"){module.exports=k}}());if(typeof(CanvasXpress)=="undefined"){CanvasXpress={}}(function(){if(navigator.onLine){var b=document.createElement("link");b.type="text/css";b.rel="stylesheet";b.href="https://fonts.googleapis.com/css?family=Indie+Flower|Ubuntu|Architects+Daughter|Roboto:400,700,700italic";var a=document.getElementsByTagName("head")[0];a.appendChild(b);var c=new Image;c.onerror=function(){var f=document.createElement("canvas");var e=f.getContext("2d",{willReadFrequently:true});var d="10px Ubuntu";e.font=d;e.fillText("css loaded",100,100);d="10px Indie Flower";e.font=d;e.fillText("css loaded",100,100);d="10px Architects Daughter";e.font=d;e.fillText("css loaded",100,100);d="10px Roboto";e.font=d;e.fillText("css loaded",100,100)};c.src="https://fonts.googleapis.com/css?family=Indie+Flower|Ubuntu|Architects+Daughter|Roboto:400,700,700italic"}}());var CanvasXpress=function(f,d,a,b,e,g,c){this.setInit=function(){this.target=f;this.events=b;this.info=e;this.userId=2;this.href=location.href;this.protocol=this.href.split(":")[0];this.meta={ids:{},time:{start:new Date().getTime(),elapsed:null,end:null},data:false,canvas:{},config:{user:a,orig:{},vals:{}},vals:{},render:{objects:[],groups:{},types:{},order:[],map:{},origin:[],transition:false},events:{},state:{save:0,clip:false,translate:[0,0],rotate:[0],scale:[1,1]},def:{}}};this.validateParameters=function(){this.validateData();this.validateConfig();this.validateEvents();this.validateInfo();this.validateAfterRender()};this.validateData=function(){this.dataURL=false;if(typeof(d)=="string"){if(!this.isValidURL(d)){alert("Not a valid url\n")}else{this.dataURL=d;d=false}}else{try{JSON.stringify(d)}catch(h){alert("Data object malformed:\n"+h)}}};this.validateConfig=function(){if(!a){a={}}else{try{JSON.stringify(a)}catch(h){alert("Config object malformed:\n"+h)}}};this.validateEvents=function(){};this.validateInfo=function(){if(!e){e=""}};this.validateAfterRender=function(){if(g){try{JSON.stringify(g)}catch(h){alert("AfterRender object malformed:\n"+h)}}};this.afterRender=function(){if(g){if(this.graphType!="Map"){for(var j=0;j<g.length;j++){var h=g[j];var k=h.shift();var n=h.length>0?h.shift():[];var m=h.length>0?h.shift():{};this.flashInfoSpan(20,20,k);for(var l in m){this[l]=m[l]}this[k].apply(this,n)}}else{this.deferedAfterRender=g}}};if(!f){f=this.createNewTarget()}else{if(typeof(f)=="object"){d=f.data||false;a=f.config||false;b=f.events||false;e=f.info||false;g=f.afterRender||false;c=f.hidden||false;f=f.renderTo||this.createNewTarget()}}this.initialize=function(){CanvasXpress.instances.push(this);this.setInit();this.initDOM();this.initInterface();this.validateParameters();this.initConfig(a);this.initViewport(c);this.initPrimitives();this.initUtils();this.initMathUtils();this.initLegendUtils();this.initFilterUtils();this.initClusterUtils();this.initSortUtils();this.initExample();this.initVocabulary();this.initDataUtils();this.initRandom();this.initData(d);this.initValidity();this.initLayout();this.initEvents();this.initTooltip();this.initToolbar();this.initMenus();this.initLinks();this.initConfigurator();this.initDataFilter();this.initDataTable();this.initCodeInfo();this.initBin();this.initDataExplorer();this.initAnimation();this.initRemote();this.initStack(d,a,b,e);this.initTransitions();this.initGraph();this.afterRender();this.getDataFromURL();this.showToolbar(2000);this.teaseMobileControls(2000);CanvasXpress.stack[this.target].state.push(this.getConfigState());CanvasXpress.current=this.target;this.meta.time.end=new Date().getTime();this.meta.time.elapsed=this.meta.time.end-this.meta.time.start;this.hideMask()};this.initialize()};CanvasXpress.instances=[];CanvasXpress.config=[];CanvasXpress.transitions={};CanvasXpress.cacheImages={};CanvasXpress.cacheImagesReady=false;CanvasXpress.cachePatterns={};CanvasXpress.cacheText={};CanvasXpress.vocabulary={};CanvasXpress.stack={};CanvasXpress.current=false;CanvasXpress.resizing=false;CanvasXpress.loading=false;CanvasXpress.geo=false;CanvasXpress.system={};CanvasXpress.factory={version:18.8,buildDate:"03-14-2018",client:"",siteSrc:false,valid:null};CanvasXpress.loadScripts=function(){var i=0;CanvasXpress.loading=true;return function(files,callback,scope){var head=document.getElementsByTagName("head")[0];var loadScript=function(s,c){var t=s.type;if(t.match(/javascript/i)){s.onreadystatechange=function(){if(s.readyState==="loaded"||s.readyState==="complete"){s.onreadystatechange=null;c()}};s.onload=function(){c()};head.appendChild(s)}else{head.appendChild(s);c()}};var count=function(){if(i===files.length){i=0;if(callback){CanvasXpress.loading=false;if(typeof(callback)=="function"){callback.call(scope)}else{if(typeof(callback)=="string"){eval("var fn = "+callback);fn()}}}}else{CanvasXpress.loadScripts(files,callback,scope)}};i++;loadScript(files[i-1],count)}}();CanvasXpress.getObject=function(c,b){for(var a=0;a<CanvasXpress.instances.length;a++){if(CanvasXpress.instances[a].target==c){return CanvasXpress.instances[a]}}if(b){return CanvasXpress.injectObject(c)}};CanvasXpress.$=function(b,a){return CanvasXpress.getObject(b,a)};CanvasXpress.destroy=function(a){if(CanvasXpress.instances.length>0){CanvasXpress.instances[0].destroy(a)}};CanvasXpress.injectObject=function(d){var a=document.getElementById(d);if(!a){var b=document.createElement("canvas");b.id=d;b.width=100;b.height=100;document.body.appendChild(b);a=new CanvasXpress({renderTo:d,hidden:true})}return a};CanvasXpress.setExampleContainer=function(a){if(!a){a="Show-All"}var j=CanvasXpress.getObject("CanvasXpress-Silent",true);var d=j.getWindowSize();var e=j.getWindowScroll();var c=Math.max(0,((d[0]-500)/2)+e[0]);var h=Math.max(0,((d[1]-500)/2)+e[1]);var g=j.$cX("div",{id:a+"-cX-API-Example",className:"CanvasXpressConfiguratorExample draggable"},{width:"513px",maxHeight:"505px",cursor:"move",display:"block",padding:"10px",position:"absolute",overflow:"hidden",paddingBottom:"25px",paddingRight:"5px",left:c+"px",top:h+"px"});var b=j.$cX("span",{id:a+"-cX-API-ExampleSpan",className:"CanvasXpressConfiguratorExample",innerHTML:""});var f=j.$cX("img",{id:a+"-cX-API-ExampleClose",className:"CanvasXpressConfigurator",property:a,src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"},{marginTop:"-5px"});var i=j.$cX("div",{id:a+"-cX-API-ExampleContent",className:"CanvasXpressConfiguratorExampleContent"},{width:"513px",maxHeight:"505px",overflow:"auto",padding:"1px"});g.appendChild(b);g.appendChild(f);g.appendChild(j.$cX("br"));g.appendChild(i);document.body.appendChild(g);f.onclick=function(){var k=j.$(this.property+"-cX-API-Example");if(k){j.destroyInDOM(k.getElementsByTagName("canvas"));k.parentNode.removeChild(k)}};return j};CanvasXpress.showExample=function(c,b){if(b){var a=CanvasXpress.setExampleContainer(b);a.stopEvent(c);a.cancelEvent(c);a.clickExamplePropertyDescription(c,b,true);return false}};CanvasXpress.showAllExamples=function(B,C){var o=CanvasXpress.setExampleContainer(C);o.stopEvent(B);o.cancelEvent(B);o.resetPropertyExample();var w=function(){var v={};var p=C?[C]:o.getKeys(CanvasXpress.doc.M).sort();for(var t=0;t<p.length;t++){var c=p[t];for(var e=0;e<CanvasXpress.doc.M[c]["P"].length;e++){var F=CanvasXpress.doc.M[c]["P"][e];var E=CanvasXpress.doc.P[F];if(E.H){v[F]=o.getExamplesDocObject(F)}}}return v};var l=function(j,c){var p=["sankey","tree","bubble"];for(var e=0;e<p.length;e++){delete (j[p[e]]);delete (c[p[e]])}return j?j:c};var d=function(){if(o.graphType!=n){n=o.graphType;D=o.getDataSet()}return D};var A=o.$(C+"-cX-API-Example");var f=o.$(C+"-cX-API-ExampleSpan");var r=o.$(C+"-cX-API-ExampleContent");var n=o.graphType;var D=o.getDataSet();if(A&&f&&r){A.style.display="block";f.innerHTML=C;var b=w();for(var s in b){var g=b[s];for(var y=0;y<g.length;y++){var u=g[y][0];var z=g[y][2];o.graphType=z.graphType;var q=l(o.cloneObject(g[y][1]),d());var k=g[y][3];var h=o.$cX("canvas",{id:u,width:500,height:500});r.appendChild(h);if(!z.title){if(z[s]!=null){if(o.isArray(z[s])){z.title=s+" : "+z[s].join(",")}else{if(o.isObject(z[s])){z.title=s+" : Object"}else{z.title=s+" : "+z[s]}}}else{z.title=s+" : null"}}var m=new CanvasXpress(u,q,z);if(k){for(var x=0;x<k.length;x++){if(k[x].match(/:/)){var a=k[x].split(":");m[a.shift()].apply(m,a)}else{m[k[x]]()}}}}}}return false};CanvasXpress.letters=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];CanvasXpress.countries={AFG:["Afghanistan","Asia","South Asia"],ALA:["Aland Islands","Europe","North Europe"],ALB:["Albania","Europe","South Europe"],DZA:["Algeria","Africa","North Africa"],ASM:["American Samoa","Oceania","Polynesia"],AND:["Andorra","Europe","South Europe"],AGO:["Angola","Africa","Middle Africa"],AIA:["Anguilla","America","Caribbean"],ATA:["Antarctica","",""],ATG:["Antigua and Barbuda","America","Caribbean"],ARG:["Argentina","America","South America"],ARM:["Armenia","Asia","West Asia"],ABW:["Aruba","America","Caribbean"],AUS:["Australia","Oceania","Australia and New Zealand"],AUT:["Austria","Europe","West Europe"],AZE:["Azerbaijan","Asia","West Asia"],BHS:["Bahamas","America","Caribbean"],BHR:["Bahrain","Asia","West Asia"],BGD:["Bangladesh","Asia","South Asia"],BRB:["Barbados","America","Caribbean"],BLR:["Belarus","Europe","East Europe"],BEL:["Belgium","Europe","West Europe"],BLZ:["Belize","America","Central America"],BEN:["Benin","Africa","West Africa"],BMU:["Bermuda","America","North America"],BTN:["Bhutan","Asia","South Asia"],BOL:["Bolivia","America","South America"],BES:["Bonaire","America","Caribbean"],BIH:["Bosnia and Herzegovina","Europe","South Europe"],BWA:["Botswana","Africa","South Africa"],BVT:["Bouvet Island","",""],BRA:["Brazil","America","South America"],IOT:["British Indian Ocean Territory","",""],BRN:["Brunei Darussalam","Asia","South-East Asia"],BGR:["Bulgaria","Europe","East Europe"],BFA:["Burkina Faso","Africa","West Africa"],BDI:["Burundi","Africa","East Africa"],KHM:["Cambodia","Asia","South-East Asia"],CMR:["Cameroon","Africa","Middle Africa"],CAN:["Canada","America","North America"],CPV:["Cabo Verde","Africa","West Africa"],CYM:["Cayman Islands","America","Caribbean"],CAF:["Central African Republic","Africa","Middle Africa"],TCD:["Chad","Africa","Middle Africa"],CHL:["Chile","America","South America"],CHN:["China","Asia","East Asia"],CXR:["Christmas Island","",""],CCK:["Cocos (Keeling) Islands","",""],COL:["Colombia","America","South America"],COM:["Comoros","Africa","East Africa"],COG:["Congo","Africa","Middle Africa"],COD:["Congo (Democratic Republic of the)","Africa","Middle Africa"],COK:["Cook Islands","Oceania","Polynesia"],CRI:["Costa Rica","America","Central America"],CIV:["Cote d'Ivoire","Africa","West Africa"],HRV:["Croatia","Europe","South Europe"],CUB:["Cuba","America","Caribbean"],CUW:["Curaçao","America","Caribbean"],CYP:["Cyprus","Asia","West Asia"],CZE:["Czech Republic","Europe","East Europe"],DNK:["Denmark","Europe","North Europe"],DJI:["Djibouti","Africa","East Africa"],DMA:["Dominica","America","Caribbean"],DOM:["Dominican Republic","America","Caribbean"],ECU:["Ecuador","America","South America"],EGY:["Egypt","Africa","North Africa"],SLV:["El Salvador","America","Central America"],GNQ:["Equatorial Guinea","Africa","Middle Africa"],ERI:["Eritrea","Africa","East Africa"],EST:["Estonia","Europe","North Europe"],ETH:["Ethiopia","Africa","East Africa"],FLK:["Falkland Islands","America","South America"],FRO:["Faroe Islands","Europe","North Europe"],FJI:["Fiji","Oceania","Melanesia"],FIN:["Finland","Europe","North Europe"],FRA:["France","Europe","West Europe"],GUF:["French Guiana","America","South America"],PYF:["French Polynesia","Oceania","Polynesia"],ATF:["French Southern Territories","",""],GAB:["Gabon","Africa","Middle Africa"],GMB:["Gambia","Africa","West Africa"],GEO:["Georgia","Asia","West Asia"],DEU:["Germany","Europe","West Europe"],GHA:["Ghana","Africa","West Africa"],GIB:["Gibraltar","Europe","South Europe"],GRC:["Greece","Europe","South Europe"],GRL:["Greenland","America","North America"],GRD:["Grenada","America","Caribbean"],GLP:["Guadeloupe","America","Caribbean"],GUM:["Guam","Oceania","Micronesia"],GTM:["Guatemala","America","Central America"],GGY:["Guernsey","Europe","North Europe"],GIN:["Guinea","Africa","West Africa"],GNB:["Guinea-Bissau","Africa","West Africa"],GUY:["Guyana","America","South America"],HTI:["Haiti","America","Caribbean"],HMD:["Heard Island and McDonald Islands","",""],VAT:["Holy See","Europe","South Europe"],HND:["Honduras","America","Central America"],HKG:["Hong Kong","Asia","East Asia"],HUN:["Hungary","Europe","East Europe"],ISL:["Iceland","Europe","North Europe"],IND:["India","Asia","South Asia"],IDN:["Indonesia","Asia","South-East Asia"],IRN:["Iran","Asia","South Asia"],IRQ:["Iraq","Asia","West Asia"],IRL:["Ireland","Europe","North Europe"],IMN:["Isle of Man","Europe","North Europe"],ISR:["Israel","Asia","West Asia"],ITA:["Italy","Europe","South Europe"],JAM:["Jamaica","America","Caribbean"],JPN:["Japan","Asia","East Asia"],JEY:["Jersey","Europe","North Europe"],JOR:["Jordan","Asia","West Asia"],KAZ:["Kazakhstan","Asia","Central Asia"],KEN:["Kenya","Africa","East Africa"],KIR:["Kiribati","Oceania","Micronesia"],PRK:["Korea (Democratic People's Republic of)","Asia","East Asia"],KOR:["Korea (Republic of)","Asia","East Asia"],KWT:["Kuwait","Asia","West Asia"],KGZ:["Kyrgyzstan","Asia","Central Asia"],LAO:["Lao People's Democratic Republic","Asia","South-East Asia"],LVA:["Latvia","Europe","North Europe"],LBN:["Lebanon","Asia","West Asia"],LSO:["Lesotho","Africa","South Africa"],LBR:["Liberia","Africa","West Africa"],LBY:["Libya","Africa","North Africa"],LIE:["Liechtenstein","Europe","West Europe"],LTU:["Lithuania","Europe","North Europe"],LUX:["Luxembourg","Europe","West Europe"],MAC:["Macao","Asia","East Asia"],MKD:["Macedonia","Europe","South Europe"],MDG:["Madagascar","Africa","East Africa"],MWI:["Malawi","Africa","East Africa"],MYS:["Malaysia","Asia","South-East Asia"],MDV:["Maldives","Asia","South Asia"],MLI:["Mali","Africa","West Africa"],MLT:["Malta","Europe","South Europe"],MHL:["Marshall Islands","Oceania","Micronesia"],MTQ:["Martinique","America","Caribbean"],MRT:["Mauritania","Africa","West Africa"],MUS:["Mauritius","Africa","East Africa"],MYT:["Mayotte","Africa","East Africa"],MEX:["Mexico","America","Central America"],FSM:["Micronesia","Oceania","Micronesia"],MDA:["Moldova","Europe","East Europe"],MCO:["Monaco","Europe","West Europe"],MNG:["Mongolia","Asia","East Asia"],MNE:["Montenegro","Europe","South Europe"],MSR:["Montserrat","America","Caribbean"],MAR:["Morocco","Africa","North Africa"],MOZ:["Mozambique","Africa","East Africa"],MMR:["Myanmar","Asia","South-East Asia"],NAM:["Namibia","Africa","South Africa"],NRU:["Nauru","Oceania","Micronesia"],NPL:["Nepal","Asia","South Asia"],NLD:["Netherlands","Europe","West Europe"],NCL:["New Caledonia","Oceania","Melanesia"],NZL:["New Zealand","Oceania","Australia and New Zealand"],NIC:["Nicaragua","America","Central America"],NER:["Niger","Africa","West Africa"],NGA:["Nigeria","Africa","West Africa"],NIU:["Niue","Oceania","Polynesia"],NFK:["Norfolk Island","Oceania","Australia and New Zealand"],MNP:["West Mariana Islands","Oceania","Micronesia"],NOR:["Norway","Europe","North Europe"],OMN:["Oman","Asia","West Asia"],PAK:["Pakistan","Asia","South Asia"],PLW:["Palau","Oceania","Micronesia"],PSE:["Palestine","Asia","West Asia"],PAN:["Panama","America","Central America"],PNG:["Papua New Guinea","Oceania","Melanesia"],PRY:["Paraguay","America","South America"],PER:["Peru","America","South America"],PHL:["Philippines","Asia","South-East Asia"],PCN:["Pitcairn","Oceania","Polynesia"],POL:["Poland","Europe","East Europe"],PRT:["Portugal","Europe","South Europe"],PRI:["Puerto Rico","America","Caribbean"],QAT:["Qatar","Asia","West Asia"],REU:["Réunion","Africa","East Africa"],ROU:["Romania","Europe","East Europe"],RUS:["Russian Federation","Europe","East Europe"],RWA:["Rwanda","Africa","East Africa"],BLM:["Saint Barthelemy","America","Caribbean"],SHN:["Saint Helena","Africa","West Africa"],KNA:["Saint Kitts and Nevis","America","Caribbean"],LCA:["Saint Lucia","America","Caribbean"],MAF:["Saint Martin","America","Caribbean"],SPM:["Saint Pierre and Miquelon","America","North America"],VCT:["Saint Vincent and the Grenadines","America","Caribbean"],WSM:["Samoa","Oceania","Polynesia"],SMR:["San Marino","Europe","South Europe"],STP:["Sao Tome and Principe","Africa","Middle Africa"],SAU:["Saudi Arabia","Asia","West Asia"],SEN:["Senegal","Africa","West Africa"],SRB:["Serbia","Europe","South Europe"],SYC:["Seychelles","Africa","East Africa"],SLE:["Sierra Leone","Africa","West Africa"],SGP:["Singapore","Asia","South-East Asia"],SXM:["Sint Maarten","America","Caribbean"],SVK:["Slovakia","Europe","East Europe"],SVN:["Slovenia","Europe","South Europe"],SLB:["Solomon Islands","Oceania","Melanesia"],SOM:["Somalia","Africa","East Africa"],ZAF:["South Africa","Africa","South Africa"],SGS:["South Georgia and the South Sandwich Islands","",""],SSD:["South Sudan","Africa","East Africa"],ESP:["Spain","Europe","South Europe"],LKA:["Sri Lanka","Asia","South Asia"],SDN:["Sudan","Africa","North Africa"],SUR:["Suriname","America","South America"],SJM:["Svalbard and Jan Mayen","Europe","North Europe"],SWZ:["Swaziland","Africa","South Africa"],SWE:["Sweden","Europe","North Europe"],CHE:["Switzerland","Europe","West Europe"],SYR:["Syrian Arab Republic","Asia","West Asia"],TWN:["Taiwan","Asia","East Asia"],TJK:["Tajikistan","Asia","Central Asia"],TZA:["Tanzania","Africa","East Africa"],THA:["Thailand","Asia","South-East Asia"],TLS:["Timor-Leste","Asia","South-East Asia"],TGO:["Togo","Africa","West Africa"],TKL:["Tokelau","Oceania","Polynesia"],TON:["Tonga","Oceania","Polynesia"],TTO:["Trinidad and Tobago","America","Caribbean"],TUN:["Tunisia","Africa","North Africa"],TUR:["Turkey","Asia","West Asia"],TKM:["Turkmenistan","Asia","Central Asia"],TCA:["Turks and Caicos Islands","America","Caribbean"],TUV:["Tuvalu","Oceania","Polynesia"],UGA:["Uganda","Africa","East Africa"],UKR:["Ukraine","Europe","East Europe"],ARE:["United Arab Emirates","Asia","West Asia"],GBR:["United Kingdom of Great Britain and Northern Ireland","Europe","North Europe"],USA:["United States of America","America","North America"],UMI:["United States Minor Outlying Islands","",""],URY:["Uruguay","America","South America"],UZB:["Uzbekistan","Asia","Central Asia"],VUT:["Vanuatu","Oceania","Melanesia"],VEN:["Venezuela","America","South America"],VNM:["Vietnam","Asia","South-East Asia"],VGB:["Virgin Islands (British)","America","Caribbean"],VIR:["Virgin Islands (U.S.)","America","Caribbean"],WLF:["Wallis and Futuna","Oceania","Polynesia"],ESH:["Western Sahara","Africa","North Africa"],YEM:["Yemen","Asia","West Asia"],ZMB:["Zambia","Africa","East Africa"],ZWE:["Zimbabwe","Africa","East Africa"]};CanvasXpress.chromosomes={hg19:{columns:["start","end","name","stain"],order:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,"X","Y"],data:{1:[[0,2300000,"p36.33","gneg"],[2300000,5300000,"p36.32","gpos25"],[5300000,7100000,"p36.31","gneg"],[7100000,9200000,"p36.23","gpos25"],[9200000,12600000,"p36.22","gneg"],[12600000,16100000,"p36.21","gpos50"],[16100000,20300000,"p36.13","gneg"],[20300000,23800000,"p36.12","gpos25"],[23800000,27800000,"p36.11","gneg"],[27800000,30000000,"p35.3","gpos25"],[30000000,32200000,"p35.2","gneg"],[32200000,34400000,"p35.1","gpos25"],[34400000,39600000,"p34.3","gneg"],[39600000,43900000,"p34.2","gpos25"],[43900000,46500000,"p34.1","gneg"],[46500000,51300000,"p33","gpos75"],[51300000,56200000,"p32.3","gneg"],[56200000,58700000,"p32.2","gpos50"],[58700000,60900000,"p32.1","gneg"],[60900000,68700000,"p31.3","gpos50"],[68700000,69500000,"p31.2","gneg"],[69500000,84700000,"p31.1","gpos100"],[84700000,88100000,"p22.3","gneg"],[88100000,92000000,"p22.2","gpos75"],[92000000,94500000,"p22.1","gneg"],[94500000,99400000,"p21.3","gpos75"],[99400000,102000000,"p21.2","gneg"],[102000000,107000000,"p21.1","gpos100"],[107000000,111600000,"p13.3","gneg"],[111600000,115900000,"p13.2","gpos50"],[115900000,117600000,"p13.1","gneg"],[117600000,120700000,"p12","gpos50"],[120700000,121100000,"p11.2","gneg"],[121100000,124300000,"p11.1","acen"],[124300000,128000000,"q11","acen"],[128000000,142400000,"q12","gvar"],[142400000,148000000,"q21.1","gneg"],[148000000,149600000,"q21.2","gpos50"],[149600000,153300000,"q21.3","gneg"],[153300000,154800000,"q22","gpos50"],[154800000,157300000,"q23.1","gneg"],[157300000,158800000,"q23.2","gpos50"],[158800000,163800000,"q23.3","gneg"],[163800000,165500000,"q24.1","gpos50"],[165500000,169100000,"q24.2","gneg"],[169100000,171200000,"q24.3","gpos75"],[171200000,174300000,"q25.1","gneg"],[174300000,178600000,"q25.2","gpos50"],[178600000,184000000,"q25.3","gneg"],[184000000,189000000,"q31.1","gpos100"],[189000000,192100000,"q31.2","gneg"],[192100000,197500000,"q31.3","gpos100"],[197500000,205300000,"q32.1","gneg"],[205300000,209500000,"q32.2","gpos25"],[209500000,212100000,"q32.3","gneg"],[212100000,222100000,"q41","gpos100"],[222100000,222700000,"q42.11","gneg"],[222700000,225100000,"q42.12","gpos25"],[225100000,228800000,"q42.13","gneg"],[228800000,232700000,"q42.2","gpos50"],[232700000,234600000,"q42.3","gneg"],[234600000,241700000,"q43","gpos75"],[241700000,247249719,"q44","gneg"]],2:[[0,4300000,"p25.3","gneg"],[4300000,7000000,"p25.2","gpos50"],[7000000,12800000,"p25.1","gneg"],[12800000,17000000,"p24.3","gpos75"],[17000000,19100000,"p24.2","gneg"],[19100000,23900000,"p24.1","gpos75"],[23900000,27700000,"p23.3","gneg"],[27700000,29800000,"p23.2","gpos25"],[29800000,31900000,"p23.1","gneg"],[31900000,36400000,"p22.3","gpos75"],[36400000,38400000,"p22.2","gneg"],[38400000,41600000,"p22.1","gpos50"],[41600000,47600000,"p21","gneg"],[47600000,52700000,"p16.3","gpos100"],[52700000,54800000,"p16.2","gneg"],[54800000,61100000,"p16.1","gpos100"],[61100000,64000000,"p15","gneg"],[64000000,70500000,"p14","gpos50"],[70500000,72600000,"p13.3","gneg"],[72600000,73900000,"p13.2","gpos50"],[73900000,75400000,"p13.1","gneg"],[75400000,83700000,"p12","gpos100"],[83700000,91000000,"p11.2","gneg"],[91000000,93300000,"p11.1","acen"],[93300000,95700000,"q11.1","acen"],[95700000,102100000,"q11.2","gneg"],[102100000,105300000,"q12.1","gpos50"],[105300000,106700000,"q12.2","gneg"],[106700000,108600000,"q12.3","gpos25"],[108600000,113800000,"q13","gneg"],[113800000,118600000,"q14.1","gpos50"],[118600000,122100000,"q14.2","gneg"],[122100000,129600000,"q14.3","gpos50"],[129600000,132200000,"q21.1","gneg"],[132200000,134800000,"q21.2","gpos25"],[134800000,136600000,"q21.3","gneg"],[136600000,142400000,"q22.1","gpos100"],[142400000,144700000,"q22.2","gneg"],[144700000,148400000,"q22.3","gpos100"],[148400000,149600000,"q23.1","gneg"],[149600000,150300000,"q23.2","gpos25"],[150300000,154600000,"q23.3","gneg"],[154600000,159600000,"q24.1","gpos75"],[159600000,163500000,"q24.2","gneg"],[163500000,169500000,"q24.3","gpos75"],[169500000,177700000,"q31.1","gneg"],[177700000,180400000,"q31.2","gpos50"],[180400000,182700000,"q31.3","gneg"],[182700000,189100000,"q32.1","gpos75"],[189100000,191600000,"q32.2","gneg"],[191600000,197100000,"q32.3","gpos75"],[197100000,203500000,"q33.1","gneg"],[203500000,205600000,"q33.2","gpos50"],[205600000,209100000,"q33.3","gneg"],[209100000,215100000,"q34","gpos100"],[215100000,221300000,"q35","gneg"],[221300000,224900000,"q36.1","gpos75"],[224900000,225800000,"q36.2","gneg"],[225800000,230700000,"q36.3","gpos100"],[230700000,235300000,"q37.1","gneg"],[235300000,237000000,"q37.2","gpos50"],[237000000,242951149,"q37.3","gneg"]],3:[[0,3500000,"p26.3","gpos50"],[3500000,5500000,"p26.2","gneg"],[5500000,8700000,"p26.1","gpos50"],[8700000,11500000,"p25.3","gneg"],[11500000,12400000,"p25.2","gpos25"],[12400000,14700000,"p25.1","gneg"],[14700000,23800000,"p24.3","gpos100"],[23800000,26400000,"p24.2","gneg"],[26400000,30800000,"p24.1","gpos75"],[30800000,32100000,"p23","gneg"],[32100000,36500000,"p22.3","gpos50"],[36500000,39300000,"p22.2","gneg"],[39300000,43600000,"p22.1","gpos75"],[43600000,44400000,"p21.33","gneg"],[44400000,44700000,"p21.32","gpos50"],[44700000,51400000,"p21.31","gneg"],[51400000,51700000,"p21.2","gpos25"],[51700000,54400000,"p21.1","gneg"],[54400000,58500000,"p14.3","gpos50"],[58500000,63700000,"p14.2","gneg"],[63700000,71800000,"p14.1","gpos50"],[71800000,74200000,"p13","gneg"],[74200000,81800000,"p12.3","gpos75"],[81800000,83700000,"p12.2","gneg"],[83700000,87200000,"p12.1","gpos75"],[87200000,89400000,"p11.2","gneg"],[89400000,91700000,"p11.1","acen"],[91700000,93200000,"q11.1","acen"],[93200000,99800000,"q11.2","gvar"],[99800000,101500000,"q12.1","gneg"],[101500000,102500000,"q12.2","gpos25"],[102500000,104400000,"q12.3","gneg"],[104400000,107800000,"q13.11","gpos75"],[107800000,109500000,"q13.12","gneg"],[109500000,112800000,"q13.13","gpos50"],[112800000,115000000,"q13.2","gneg"],[115000000,118800000,"q13.31","gpos75"],[118800000,120500000,"q13.32","gneg"],[120500000,123400000,"q13.33","gpos75"],[123400000,125400000,"q21.1","gneg"],[125400000,127700000,"q21.2","gpos25"],[127700000,131500000,"q21.3","gneg"],[131500000,135700000,"q22.1","gpos25"],[135700000,137400000,"q22.2","gneg"],[137400000,140400000,"q22.3","gpos25"],[140400000,144400000,"q23","gneg"],[144400000,150400000,"q24","gpos100"],[150400000,153500000,"q25.1","gneg"],[153500000,156300000,"q25.2","gpos50"],[156300000,158100000,"q25.31","gneg"],[158100000,159900000,"q25.32","gpos50"],[159900000,161200000,"q25.33","gneg"],[161200000,169200000,"q26.1","gpos100"],[169200000,172500000,"q26.2","gneg"],[172500000,177300000,"q26.31","gpos75"],[177300000,180600000,"q26.32","gneg"],[180600000,184200000,"q26.33","gpos75"],[184200000,186000000,"q27.1","gneg"],[186000000,187500000,"q27.2","gpos25"],[187500000,189400000,"q27.3","gneg"],[189400000,193800000,"q28","gpos75"],[193800000,199501827,"q29","gneg"]],4:[[0,3100000,"p16.3","gneg"],[3100000,5200000,"p16.2","gpos25"],[5200000,10900000,"p16.1","gneg"],[10900000,15300000,"p15.33","gpos50"],[15300000,18500000,"p15.32","gneg"],[18500000,23100000,"p15.31","gpos75"],[23100000,27900000,"p15.2","gneg"],[27900000,35500000,"p15.1","gpos100"],[35500000,40900000,"p14","gneg"],[40900000,45600000,"p13","gpos50"],[45600000,48700000,"p12","gneg"],[48700000,50700000,"p11","acen"],[50700000,52400000,"q11","acen"],[52400000,59200000,"q12","gneg"],[59200000,66300000,"q13.1","gpos100"],[66300000,70400000,"q13.2","gneg"],[70400000,76500000,"q13.3","gpos75"],[76500000,79200000,"q21.1","gneg"],[79200000,82600000,"q21.21","gpos50"],[82600000,84300000,"q21.22","gneg"],[84300000,87100000,"q21.23","gpos25"],[87100000,88200000,"q21.3","gneg"],[88200000,94000000,"q22.1","gpos75"],[94000000,95400000,"q22.2","gneg"],[95400000,99100000,"q22.3","gpos75"],[99100000,102500000,"q23","gneg"],[102500000,107900000,"q24","gpos50"],[107900000,114100000,"q25","gneg"],[114100000,120600000,"q26","gpos75"],[120600000,124000000,"q27","gneg"],[124000000,129100000,"q28.1","gpos50"],[129100000,131300000,"q28.2","gneg"],[131300000,139500000,"q28.3","gpos100"],[139500000,141700000,"q31.1","gneg"],[141700000,145000000,"q31.21","gpos25"],[145000000,147700000,"q31.22","gneg"],[147700000,151000000,"q31.23","gpos25"],[151000000,155100000,"q31.3","gneg"],[155100000,161500000,"q32.1","gpos100"],[161500000,164500000,"q32.2","gneg"],[164500000,170400000,"q32.3","gpos100"],[170400000,172200000,"q33","gneg"],[172200000,176600000,"q34.1","gpos75"],[176600000,177800000,"q34.2","gneg"],[177800000,182600000,"q34.3","gpos100"],[182600000,187300000,"q35.1","gneg"],[187300000,191273063,"q35.2","gpos25"]],5:[[0,4400000,"p15.33","gneg"],[4400000,6000000,"p15.32","gpos25"],[6000000,8200000,"p15.31","gneg"],[8200000,15100000,"p15.2","gpos50"],[15100000,18500000,"p15.1","gneg"],[18500000,23300000,"p14.3","gpos100"],[23300000,24700000,"p14.2","gneg"],[24700000,29300000,"p14.1","gpos100"],[29300000,34400000,"p13.3","gneg"],[34400000,38500000,"p13.2","gpos25"],[38500000,42400000,"p13.1","gneg"],[42400000,45800000,"p12","gpos50"],[45800000,47700000,"p11","acen"],[47700000,50500000,"q11.1","acen"],[50500000,58900000,"q11.2","gneg"],[58900000,63000000,"q12.1","gpos75"],[63000000,63700000,"q12.2","gneg"],[63700000,66500000,"q12.3","gpos75"],[66500000,68400000,"q13.1","gneg"],[68400000,73300000,"q13.2","gpos50"],[73300000,76400000,"q13.3","gneg"],[76400000,81300000,"q14.1","gpos50"],[81300000,82800000,"q14.2","gneg"],[82800000,91900000,"q14.3","gpos100"],[91900000,97300000,"q15","gneg"],[97300000,102800000,"q21.1","gpos100"],[102800000,104500000,"q21.2","gneg"],[104500000,109600000,"q21.3","gpos100"],[109600000,111500000,"q22.1","gneg"],[111500000,113100000,"q22.2","gpos50"],[113100000,115200000,"q22.3","gneg"],[115200000,121500000,"q23.1","gpos100"],[121500000,127300000,"q23.2","gneg"],[127300000,130400000,"q23.3","gpos100"],[130400000,135400000,"q31.1","gneg"],[135400000,139000000,"q31.2","gpos25"],[139000000,143100000,"q31.3","gneg"],[143100000,147200000,"q32","gpos75"],[147200000,152100000,"q33.1","gneg"],[152100000,155600000,"q33.2","gpos50"],[155600000,159900000,"q33.3","gneg"],[159900000,167400000,"q34","gpos100"],[167400000,172200000,"q35.1","gneg"],[172200000,176500000,"q35.2","gpos25"],[176500000,180857866,"q35.3","gneg"]],6:[[0,2300000,"p25.3","gneg"],[2300000,4100000,"p25.2","gpos25"],[4100000,7000000,"p25.1","gneg"],[7000000,10600000,"p24.3","gpos50"],[10600000,11200000,"p24.2","gneg"],[11200000,13500000,"p24.1","gpos25"],[13500000,15500000,"p23","gneg"],[15500000,23500000,"p22.3","gpos75"],[23500000,26100000,"p22.2","gneg"],[26100000,29900000,"p22.1","gpos50"],[29900000,31900000,"p21.33","gneg"],[31900000,33600000,"p21.32","gpos25"],[33600000,36800000,"p21.31","gneg"],[36800000,40600000,"p21.2","gpos25"],[40600000,45200000,"p21.1","gneg"],[45200000,51100000,"p12.3","gpos100"],[51100000,52600000,"p12.2","gneg"],[52600000,57200000,"p12.1","gpos100"],[57200000,58400000,"p11.2","gneg"],[58400000,60500000,"p11.1","acen"],[60500000,63400000,"q11.1","acen"],[63400000,63500000,"q11.2","gneg"],[63500000,70000000,"q12","gpos100"],[70000000,75900000,"q13","gneg"],[75900000,83900000,"q14.1","gpos50"],[83900000,84700000,"q14.2","gneg"],[84700000,87500000,"q14.3","gpos50"],[87500000,92100000,"q15","gneg"],[92100000,98700000,"q16.1","gpos100"],[98700000,99900000,"q16.2","gneg"],[99900000,104800000,"q16.3","gpos100"],[104800000,113900000,"q21","gneg"],[113900000,117100000,"q22.1","gpos75"],[117100000,118600000,"q22.2","gneg"],[118600000,126200000,"q22.31","gpos100"],[126200000,127300000,"q22.32","gneg"],[127300000,130400000,"q22.33","gpos75"],[130400000,131300000,"q23.1","gneg"],[131300000,135200000,"q23.2","gpos50"],[135200000,139100000,"q23.3","gneg"],[139100000,142900000,"q24.1","gpos75"],[142900000,145700000,"q24.2","gneg"],[145700000,149100000,"q24.3","gpos75"],[149100000,152600000,"q25.1","gneg"],[152600000,155600000,"q25.2","gpos50"],[155600000,160900000,"q25.3","gneg"],[160900000,164400000,"q26","gpos50"],[164400000,170899992,"q27","gneg"]],7:[[0,2100000,"p22.3","gneg"],[2100000,4500000,"p22.2","gpos25"],[4500000,7200000,"p22.1","gneg"],[7200000,13300000,"p21.3","gpos100"],[13300000,15200000,"p21.2","gneg"],[15200000,19500000,"p21.1","gpos100"],[19500000,24900000,"p15.3","gneg"],[24900000,28000000,"p15.2","gpos50"],[28000000,31800000,"p15.1","gneg"],[31800000,35600000,"p14.3","gpos75"],[35600000,37500000,"p14.2","gneg"],[37500000,43300000,"p14.1","gpos75"],[43300000,46600000,"p13","gneg"],[46600000,49800000,"p12.3","gpos75"],[49800000,50900000,"p12.2","gneg"],[50900000,53900000,"p12.1","gpos75"],[53900000,57400000,"p11.2","gneg"],[57400000,59100000,"p11.1","acen"],[59100000,61100000,"q11.1","acen"],[61100000,66100000,"q11.21","gneg"],[66100000,71800000,"q11.22","gpos50"],[71800000,77400000,"q11.23","gneg"],[77400000,86200000,"q21.11","gpos100"],[86200000,88000000,"q21.12","gneg"],[88000000,90900000,"q21.13","gpos75"],[90900000,92600000,"q21.2","gneg"],[92600000,97900000,"q21.3","gpos75"],[97900000,104400000,"q22.1","gneg"],[104400000,105900000,"q22.2","gpos50"],[105900000,107200000,"q22.3","gneg"],[107200000,114400000,"q31.1","gpos75"],[114400000,117200000,"q31.2","gneg"],[117200000,120900000,"q31.31","gpos75"],[120900000,123600000,"q31.32","gneg"],[123600000,126900000,"q31.33","gpos75"],[126900000,129000000,"q32.1","gneg"],[129000000,130100000,"q32.2","gpos25"],[130100000,132400000,"q32.3","gneg"],[132400000,137300000,"q33","gpos50"],[137300000,142800000,"q34","gneg"],[142800000,147500000,"q35","gpos75"],[147500000,152200000,"q36.1","gneg"],[152200000,154700000,"q36.2","gpos25"],[154700000,158821424,"q36.3","gneg"]],8:[[0,2200000,"p23.3","gneg"],[2200000,6200000,"p23.2","gpos75"],[6200000,12700000,"p23.1","gneg"],[12700000,19100000,"p22","gpos100"],[19100000,23400000,"p21.3","gneg"],[23400000,27400000,"p21.2","gpos50"],[27400000,29700000,"p21.1","gneg"],[29700000,38500000,"p12","gpos75"],[38500000,39500000,"p11.23","gneg"],[39500000,39900000,"p11.22","gpos25"],[39900000,43200000,"p11.21","gneg"],[43200000,45200000,"p11.1","acen"],[45200000,48100000,"q11.1","acen"],[48100000,50400000,"q11.21","gneg"],[50400000,52800000,"q11.22","gpos75"],[52800000,55600000,"q11.23","gneg"],[55600000,61700000,"q12.1","gpos50"],[61700000,62400000,"q12.2","gneg"],[62400000,66100000,"q12.3","gpos50"],[66100000,68100000,"q13.1","gneg"],[68100000,70600000,"q13.2","gpos50"],[70600000,74000000,"q13.3","gneg"],[74000000,78500000,"q21.11","gpos100"],[78500000,80300000,"q21.12","gneg"],[80300000,84900000,"q21.13","gpos75"],[84900000,87200000,"q21.2","gneg"],[87200000,93500000,"q21.3","gpos100"],[93500000,99100000,"q22.1","gneg"],[99100000,101600000,"q22.2","gpos25"],[101600000,106100000,"q22.3","gneg"],[106100000,110600000,"q23.1","gpos75"],[110600000,112200000,"q23.2","gneg"],[112200000,117700000,"q23.3","gpos100"],[117700000,119200000,"q24.11","gneg"],[119200000,122500000,"q24.12","gpos50"],[122500000,127300000,"q24.13","gneg"],[127300000,131500000,"q24.21","gpos50"],[131500000,136500000,"q24.22","gneg"],[136500000,140000000,"q24.23","gpos75"],[140000000,146274826,"q24.3","gneg"]],9:[[0,2200000,"p24.3","gneg"],[2200000,4600000,"p24.2","gpos25"],[4600000,9000000,"p24.1","gneg"],[9000000,14100000,"p23","gpos75"],[14100000,16600000,"p22.3","gneg"],[16600000,18500000,"p22.2","gpos25"],[18500000,19900000,"p22.1","gneg"],[19900000,25500000,"p21.3","gpos100"],[25500000,28100000,"p21.2","gneg"],[28100000,32800000,"p21.1","gpos100"],[32800000,36300000,"p13.3","gneg"],[36300000,38000000,"p13.2","gpos25"],[38000000,40200000,"p13.1","gneg"],[40200000,42400000,"p12","gpos50"],[42400000,46700000,"p11.2","gneg"],[46700000,51800000,"p11.1","acen"],[51800000,60300000,"q11","acen"],[60300000,70000000,"q12","gvar"],[70000000,70500000,"q13","gneg"],[70500000,72700000,"q21.11","gpos25"],[72700000,73100000,"q21.12","gneg"],[73100000,79300000,"q21.13","gpos50"],[79300000,80300000,"q21.2","gneg"],[80300000,83400000,"q21.31","gpos50"],[83400000,86100000,"q21.32","gneg"],[86100000,89600000,"q21.33","gpos50"],[89600000,91000000,"q22.1","gneg"],[91000000,93000000,"q22.2","gpos25"],[93000000,95600000,"q22.31","gneg"],[95600000,98200000,"q22.32","gpos25"],[98200000,101600000,"q22.33","gneg"],[101600000,107200000,"q31.1","gpos100"],[107200000,110300000,"q31.2","gneg"],[110300000,113900000,"q31.3","gpos25"],[113900000,116700000,"q32","gneg"],[116700000,122000000,"q33.1","gpos75"],[122000000,125800000,"q33.2","gneg"],[125800000,129300000,"q33.3","gpos25"],[129300000,132500000,"q34.11","gneg"],[132500000,132800000,"q34.12","gpos25"],[132800000,134900000,"q34.13","gneg"],[134900000,136600000,"q34.2","gpos25"],[136600000,140273252,"q34.3","gneg"]],10:[[0,3000000,"p15.3","gneg"],[3000000,3800000,"p15.2","gpos25"],[3800000,6700000,"p15.1","gneg"],[6700000,12300000,"p14","gpos75"],[12300000,17300000,"p13","gneg"],[17300000,19900000,"p12.33","gpos75"],[19900000,20500000,"p12.32","gneg"],[20500000,22800000,"p12.31","gpos75"],[22800000,24100000,"p12.2","gneg"],[24100000,28300000,"p12.1","gpos50"],[28300000,31400000,"p11.23","gneg"],[31400000,34500000,"p11.22","gpos25"],[34500000,38800000,"p11.21","gneg"],[38800000,40300000,"p11.1","acen"],[40300000,42100000,"q11.1","acen"],[42100000,46100000,"q11.21","gneg"],[46100000,50100000,"q11.22","gpos25"],[50100000,53300000,"q11.23","gneg"],[53300000,61200000,"q21.1","gpos100"],[61200000,64800000,"q21.2","gneg"],[64800000,71300000,"q21.3","gpos100"],[71300000,74600000,"q22.1","gneg"],[74600000,77400000,"q22.2","gpos50"],[77400000,82000000,"q22.3","gneg"],[82000000,87900000,"q23.1","gpos100"],[87900000,89600000,"q23.2","gneg"],[89600000,92900000,"q23.31","gpos75"],[92900000,94200000,"q23.32","gneg"],[94200000,98000000,"q23.33","gpos50"],[98000000,99400000,"q24.1","gneg"],[99400000,102000000,"q24.2","gpos50"],[102000000,103000000,"q24.31","gneg"],[103000000,104900000,"q24.32","gpos25"],[104900000,105700000,"q24.33","gneg"],[105700000,111800000,"q25.1","gpos100"],[111800000,114900000,"q25.2","gneg"],[114900000,119100000,"q25.3","gpos75"],[119100000,121700000,"q26.11","gneg"],[121700000,123100000,"q26.12","gpos50"],[123100000,127400000,"q26.13","gneg"],[127400000,130500000,"q26.2","gpos50"],[130500000,135374737,"q26.3","gneg"]],11:[[0,2800000,"p15.5","gneg"],[2800000,10700000,"p15.4","gpos50"],[10700000,12600000,"p15.3","gneg"],[12600000,16100000,"p15.2","gpos50"],[16100000,21600000,"p15.1","gneg"],[21600000,26000000,"p14.3","gpos100"],[26000000,27200000,"p14.2","gneg"],[27200000,31000000,"p14.1","gpos75"],[31000000,36400000,"p13","gneg"],[36400000,43400000,"p12","gpos100"],[43400000,48800000,"p11.2","gneg"],[48800000,51400000,"p11.12","gpos75"],[51400000,52900000,"p11.11","acen"],[52900000,56400000,"q11","acen"],[56400000,59700000,"q12.1","gpos75"],[59700000,61400000,"q12.2","gneg"],[61400000,63100000,"q12.3","gpos25"],[63100000,67100000,"q13.1","gneg"],[67100000,69200000,"q13.2","gpos25"],[69200000,70700000,"q13.3","gneg"],[70700000,74900000,"q13.4","gpos50"],[74900000,76700000,"q13.5","gneg"],[76700000,85300000,"q14.1","gpos100"],[85300000,87900000,"q14.2","gneg"],[87900000,92300000,"q14.3","gpos100"],[92300000,96700000,"q21","gneg"],[96700000,101600000,"q22.1","gpos100"],[101600000,102400000,"q22.2","gneg"],[102400000,110000000,"q22.3","gpos100"],[110000000,112800000,"q23.1","gneg"],[112800000,115400000,"q23.2","gpos50"],[115400000,120700000,"q23.3","gneg"],[120700000,123500000,"q24.1","gpos50"],[123500000,127400000,"q24.2","gneg"],[127400000,130300000,"q24.3","gpos50"],[130300000,134452384,"q25","gneg"]],12:[[0,3100000,"p13.33","gneg"],[3100000,5300000,"p13.32","gpos25"],[5300000,10000000,"p13.31","gneg"],[10000000,12600000,"p13.2","gpos75"],[12600000,14800000,"p13.1","gneg"],[14800000,19900000,"p12.3","gpos100"],[19900000,21200000,"p12.2","gneg"],[21200000,26300000,"p12.1","gpos100"],[26300000,27700000,"p11.23","gneg"],[27700000,30600000,"p11.22","gpos50"],[30600000,33200000,"p11.21","gneg"],[33200000,35400000,"p11.1","acen"],[35400000,36500000,"q11","acen"],[36500000,44600000,"q12","gpos100"],[44600000,47400000,"q13.11","gneg"],[47400000,48400000,"q13.12","gpos25"],[48400000,53100000,"q13.13","gneg"],[53100000,55200000,"q13.2","gpos25"],[55200000,56300000,"q13.3","gneg"],[56300000,61400000,"q14.1","gpos75"],[61400000,63400000,"q14.2","gneg"],[63400000,66000000,"q14.3","gpos50"],[66000000,69800000,"q15","gneg"],[69800000,74100000,"q21.1","gpos75"],[74100000,78700000,"q21.2","gneg"],[78700000,85100000,"q21.31","gpos100"],[85100000,87500000,"q21.32","gneg"],[87500000,91200000,"q21.33","gpos100"],[91200000,94800000,"q22","gneg"],[94800000,100000000,"q23.1","gpos75"],[100000000,102400000,"q23.2","gneg"],[102400000,107500000,"q23.3","gpos50"],[107500000,110200000,"q24.11","gneg"],[110200000,110800000,"q24.12","gpos25"],[110800000,112800000,"q24.13","gneg"],[112800000,115300000,"q24.21","gpos50"],[115300000,116700000,"q24.22","gneg"],[116700000,119100000,"q24.23","gpos50"],[119100000,124500000,"q24.31","gneg"],[124500000,128700000,"q24.32","gpos50"],[128700000,132349534,"q24.33","gneg"]],13:[[0,3800000,"p13","gvar"],[3800000,8300000,"p12","stalk"],[8300000,13500000,"p11.2","gvar"],[13500000,16000000,"p11.1","acen"],[16000000,18400000,"q11","acen"],[18400000,22200000,"q12.11","gneg"],[22200000,24400000,"q12.12","gpos25"],[24400000,26700000,"q12.13","gneg"],[26700000,27800000,"q12.2","gpos25"],[27800000,31100000,"q12.3","gneg"],[31100000,32900000,"q13.1","gpos50"],[32900000,34700000,"q13.2","gneg"],[34700000,39500000,"q13.3","gpos75"],[39500000,44300000,"q14.11","gneg"],[44300000,45900000,"q14.12","gpos25"],[45900000,46200000,"q14.13","gneg"],[46200000,48900000,"q14.2","gpos50"],[48900000,52200000,"q14.3","gneg"],[52200000,57600000,"q21.1","gpos100"],[57600000,60500000,"q21.2","gneg"],[60500000,64100000,"q21.31","gpos75"],[64100000,67200000,"q21.32","gneg"],[67200000,72100000,"q21.33","gpos100"],[72100000,74200000,"q22.1","gneg"],[74200000,76000000,"q22.2","gpos50"],[76000000,77800000,"q22.3","gneg"],[77800000,86500000,"q31.1","gpos100"],[86500000,88800000,"q31.2","gneg"],[88800000,93800000,"q31.3","gpos100"],[93800000,97000000,"q32.1","gneg"],[97000000,98100000,"q32.2","gpos25"],[98100000,100500000,"q32.3","gneg"],[100500000,103700000,"q33.1","gpos100"],[103700000,105800000,"q33.2","gneg"],[105800000,109100000,"q33.3","gpos100"],[109100000,114142980,"q34","gneg"]],14:[[0,3100000,"p13","gvar"],[3100000,6700000,"p12","stalk"],[6700000,13600000,"p11.2","gvar"],[13600000,15600000,"p11.1","acen"],[15600000,19100000,"q11.1","acen"],[19100000,23600000,"q11.2","gneg"],[23600000,31800000,"q12","gpos100"],[31800000,34100000,"q13.1","gneg"],[34100000,35600000,"q13.2","gpos50"],[35600000,36900000,"q13.3","gneg"],[36900000,41000000,"q21.1","gpos100"],[41000000,43200000,"q21.2","gneg"],[43200000,48300000,"q21.3","gpos100"],[48300000,52300000,"q22.1","gneg"],[52300000,54400000,"q22.2","gpos25"],[54400000,55800000,"q22.3","gneg"],[55800000,61200000,"q23.1","gpos75"],[61200000,64000000,"q23.2","gneg"],[64000000,67000000,"q23.3","gpos50"],[67000000,69300000,"q24.1","gneg"],[69300000,72900000,"q24.2","gpos50"],[72900000,78400000,"q24.3","gneg"],[78400000,82600000,"q31.1","gpos100"],[82600000,84000000,"q31.2","gneg"],[84000000,88900000,"q31.3","gpos100"],[88900000,90500000,"q32.11","gneg"],[90500000,92800000,"q32.12","gpos25"],[92800000,95400000,"q32.13","gneg"],[95400000,100400000,"q32.2","gpos50"],[100400000,102200000,"q32.31","gneg"],[102200000,103000000,"q32.32","gpos50"],[103000000,106368585,"q32.33","gneg"]],15:[[0,3500000,"p13","gvar"],[3500000,7900000,"p12","stalk"],[7900000,14100000,"p11.2","gvar"],[14100000,17000000,"p11.1","acen"],[17000000,18400000,"q11.1","acen"],[18400000,23300000,"q11.2","gneg"],[23300000,25700000,"q12","gpos50"],[25700000,28000000,"q13.1","gneg"],[28000000,29000000,"q13.2","gpos50"],[29000000,31400000,"q13.3","gneg"],[31400000,37900000,"q14","gpos75"],[37900000,40700000,"q15.1","gneg"],[40700000,41400000,"q15.2","gpos25"],[41400000,42700000,"q15.3","gneg"],[42700000,47600000,"q21.1","gpos75"],[47600000,51100000,"q21.2","gneg"],[51100000,55800000,"q21.3","gpos75"],[55800000,57100000,"q22.1","gneg"],[57100000,61500000,"q22.2","gpos25"],[61500000,64900000,"q22.31","gneg"],[64900000,65000000,"q22.32","gpos25"],[65000000,65300000,"q22.33","gneg"],[65300000,70400000,"q23","gpos25"],[70400000,73100000,"q24.1","gneg"],[73100000,74400000,"q24.2","gpos25"],[74400000,76100000,"q24.3","gneg"],[76100000,79500000,"q25.1","gpos50"],[79500000,83000000,"q25.2","gneg"],[83000000,86900000,"q25.3","gpos50"],[86900000,92100000,"q26.1","gneg"],[92100000,96300000,"q26.2","gpos50"],[96300000,100338915,"q26.3","gneg"]],16:[[0,6300000,"p13.3","gneg"],[6300000,10300000,"p13.2","gpos50"],[10300000,12500000,"p13.13","gneg"],[12500000,14700000,"p13.12","gpos50"],[14700000,16700000,"p13.11","gneg"],[16700000,20500000,"p12.3","gpos50"],[20500000,21700000,"p12.2","gneg"],[21700000,27600000,"p12.1","gpos50"],[27600000,34400000,"p11.2","gneg"],[34400000,38200000,"p11.1","acen"],[38200000,40700000,"q11.1","acen"],[40700000,45500000,"q11.2","gvar"],[45500000,51200000,"q12.1","gneg"],[51200000,54500000,"q12.2","gpos50"],[54500000,56700000,"q13","gneg"],[56700000,65200000,"q21","gpos100"],[65200000,69400000,"q22.1","gneg"],[69400000,69800000,"q22.2","gpos50"],[69800000,73300000,"q22.3","gneg"],[73300000,78200000,"q23.1","gpos75"],[78200000,80500000,"q23.2","gneg"],[80500000,82700000,"q23.3","gpos50"],[82700000,85600000,"q24.1","gneg"],[85600000,87200000,"q24.2","gpos25"],[87200000,88827254,"q24.3","gneg"]],17:[[0,3600000,"p13.3","gneg"],[3600000,6800000,"p13.2","gpos50"],[6800000,11200000,"p13.1","gneg"],[11200000,15900000,"p12","gpos75"],[15900000,22100000,"p11.2","gneg"],[22100000,22200000,"p11.1","acen"],[22200000,23200000,"q11.1","acen"],[23200000,28800000,"q11.2","gneg"],[28800000,35400000,"q12","gpos50"],[35400000,35600000,"q21.1","gneg"],[35600000,37800000,"q21.2","gpos25"],[37800000,41900000,"q21.31","gneg"],[41900000,44800000,"q21.32","gpos25"],[44800000,47600000,"q21.33","gneg"],[47600000,54900000,"q22","gpos75"],[54900000,55600000,"q23.1","gneg"],[55600000,58400000,"q23.2","gpos75"],[58400000,59900000,"q23.3","gneg"],[59900000,61600000,"q24.1","gpos50"],[61600000,64600000,"q24.2","gneg"],[64600000,68400000,"q24.3","gpos75"],[68400000,72200000,"q25.1","gneg"],[72200000,72900000,"q25.2","gpos25"],[72900000,78774742,"q25.3","gneg"]],18:[[0,2900000,"p11.32","gneg"],[2900000,7200000,"p11.31","gpos50"],[7200000,8500000,"p11.23","gneg"],[8500000,10900000,"p11.22","gpos25"],[10900000,15400000,"p11.21","gneg"],[15400000,16100000,"p11.1","acen"],[16100000,17300000,"q11.1","acen"],[17300000,23300000,"q11.2","gneg"],[23300000,31000000,"q12.1","gpos100"],[31000000,35500000,"q12.2","gneg"],[35500000,41800000,"q12.3","gpos75"],[41800000,46400000,"q21.1","gneg"],[46400000,52000000,"q21.2","gpos75"],[52000000,54400000,"q21.31","gneg"],[54400000,57100000,"q21.32","gpos50"],[57100000,59800000,"q21.33","gneg"],[59800000,64900000,"q22.1","gpos100"],[64900000,66900000,"q22.2","gneg"],[66900000,71300000,"q22.3","gpos25"],[71300000,76117153,"q23","gneg"]],19:[[0,6900000,"p13.3","gneg"],[6900000,12600000,"p13.2","gpos25"],[12600000,13800000,"p13.13","gneg"],[13800000,16100000,"p13.12","gpos25"],[16100000,19800000,"p13.11","gneg"],[19800000,26700000,"p12","gvar"],[26700000,28500000,"p11","acen"],[28500000,30200000,"q11","acen"],[30200000,37100000,"q12","gvar"],[37100000,40300000,"q13.11","gneg"],[40300000,43000000,"q13.12","gpos25"],[43000000,43400000,"q13.13","gneg"],[43400000,47800000,"q13.2","gpos25"],[47800000,50000000,"q13.31","gneg"],[50000000,53800000,"q13.32","gpos25"],[53800000,57600000,"q13.33","gneg"],[57600000,59100000,"q13.41","gpos25"],[59100000,61400000,"q13.42","gneg"],[61400000,63811651,"q13.43","gpos25"]],20:[[0,5000000,"p13","gneg"],[5000000,9000000,"p12.3","gpos75"],[9000000,11900000,"p12.2","gneg"],[11900000,17800000,"p12.1","gpos75"],[17800000,21200000,"p11.23","gneg"],[21200000,22300000,"p11.22","gpos25"],[22300000,25700000,"p11.21","gneg"],[25700000,27100000,"p11.1","acen"],[27100000,28400000,"q11.1","acen"],[28400000,31500000,"q11.21","gneg"],[31500000,33900000,"q11.22","gpos25"],[33900000,37100000,"q11.23","gneg"],[37100000,41100000,"q12","gpos75"],[41100000,41600000,"q13.11","gneg"],[41600000,45800000,"q13.12","gpos25"],[45800000,49200000,"q13.13","gneg"],[49200000,54400000,"q13.2","gpos75"],[54400000,55900000,"q13.31","gneg"],[55900000,57900000,"q13.32","gpos50"],[57900000,62435964,"q13.33","gneg"]],21:[[0,2900000,"p13","gvar"],[2900000,6300000,"p12","stalk"],[6300000,10000000,"p11.2","gvar"],[10000000,12300000,"p11.1","acen"],[12300000,13200000,"q11.1","acen"],[13200000,15300000,"q11.2","gneg"],[15300000,22900000,"q21.1","gpos100"],[22900000,25800000,"q21.2","gneg"],[25800000,30500000,"q21.3","gpos75"],[30500000,34700000,"q22.11","gneg"],[34700000,36700000,"q22.12","gpos50"],[36700000,38600000,"q22.13","gneg"],[38600000,41400000,"q22.2","gpos50"],[41400000,46944323,"q22.3","gneg"]],22:[[0,3000000,"p13","gvar"],[3000000,6600000,"p12","stalk"],[6600000,9600000,"p11.2","gvar"],[9600000,11800000,"p11.1","acen"],[11800000,16300000,"q11.1","acen"],[16300000,20500000,"q11.21","gneg"],[20500000,21800000,"q11.22","gpos25"],[21800000,24300000,"q11.23","gneg"],[24300000,27900000,"q12.1","gpos50"],[27900000,30500000,"q12.2","gneg"],[30500000,35900000,"q12.3","gpos50"],[35900000,39300000,"q13.1","gneg"],[39300000,42600000,"q13.2","gpos50"],[42600000,47000000,"q13.31","gneg"],[47000000,48200000,"q13.32","gpos50"],[48200000,49691432,"q13.33","gneg"]],X:[[0,4300000,"p22.33","gneg"],[4300000,6000000,"p22.32","gpos50"],[6000000,9500000,"p22.31","gneg"],[9500000,17100000,"p22.2","gpos50"],[17100000,19200000,"p22.13","gneg"],[19200000,21800000,"p22.12","gpos50"],[21800000,24900000,"p22.11","gneg"],[24900000,29400000,"p21.3","gpos100"],[29400000,31500000,"p21.2","gneg"],[31500000,37500000,"p21.1","gpos100"],[37500000,42300000,"p11.4","gneg"],[42300000,47300000,"p11.3","gpos75"],[47300000,49700000,"p11.23","gneg"],[49700000,54700000,"p11.22","gpos25"],[54700000,56600000,"p11.21","gneg"],[56600000,59500000,"p11.1","acen"],[59500000,65000000,"q11.1","acen"],[65000000,65100000,"q11.2","gneg"],[65100000,67700000,"q12","gpos50"],[67700000,72200000,"q13.1","gneg"],[72200000,73800000,"q13.2","gpos50"],[73800000,76000000,"q13.3","gneg"],[76000000,84500000,"q21.1","gpos100"],[84500000,86200000,"q21.2","gneg"],[86200000,91900000,"q21.31","gpos100"],[91900000,93500000,"q21.32","gneg"],[93500000,98200000,"q21.33","gpos75"],[98200000,102500000,"q22.1","gneg"],[102500000,103600000,"q22.2","gpos50"],[103600000,110500000,"q22.3","gneg"],[110500000,116800000,"q23","gpos75"],[116800000,120700000,"q24","gneg"],[120700000,129800000,"q25","gpos100"],[129800000,130300000,"q26.1","gneg"],[130300000,133500000,"q26.2","gpos25"],[133500000,137800000,"q26.3","gneg"],[137800000,140100000,"q27.1","gpos75"],[140100000,141900000,"q27.2","gneg"],[141900000,146900000,"q27.3","gpos100"],[146900000,154913754,"q28","gneg"]],Y:[[0,1700000,"p11.32","gneg"],[1700000,3300000,"p11.31","gpos50"],[3300000,11200000,"p11.2","gneg"],[11200000,11300000,"p11.1","acen"],[11300000,12500000,"q11.1","acen"],[12500000,14300000,"q11.21","gneg"],[14300000,19000000,"q11.221","gpos50"],[19000000,21300000,"q11.222","gneg"],[21300000,25400000,"q11.223","gpos50"],[25400000,27200000,"q11.23","gneg"],[27200000,57772954,"q12","gvar"]]}}};CanvasXpress.graphTypes={Area:["Area"],AreaLine:["AreaLine"],Bar:["Bar"],BarLine:["BarLine"],Boxplot:["Boxplot"],Candlestick:["Candlestick"],Circular:["Circular"],Correlation:["Correlation"],DotLine:["DotLine"],Dotplot:["Dotplot"],Genome:["Genome"],Heatmap:["Heatmap"],Line:["Line"],Map:["Map"],Network:["Network"],ParallelCoordinates:["ParallelCoordinates"],Pie:["Pie"],Sankey:["Sankey"],Scatter2D:["Scatter2D"],ScatterBubble2D:["ScatterBubble2D"],Scatter3D:["Scatter3D"],Stacked:["Stacked"],StackedLine:["StackedLine"],StackedPercent:["StackedPercent"],StackedPercentLine:["StackedPercentLine"],TagCloud:["TagCloud"],Tree:["Tree"],Treemap:["Treemap"],Venn:["Venn"],Video:["Video"],DotGraphs:["Boxplot","DotLine","Dotplot"],LineGraphs:["AreaLine","BarLine","DotLine","Line","ParallelCoordinates","StackedLine","StackedPercentLine"],ScatterGraphs:["Scatter2D","ScatterBubble2D","Scatter3D"],StackedGraphs:["Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneDPlots:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Sankey","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],OneDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Stacked","StackedLine","StackedPercent","StackedPercentLine"],OneTwoThreeeDGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","Circular","DotLine","Dotplot","Heatmap","Line","ParallelCoordinates","Pie","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine"],AllGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","Circular","Correlation","DotLine","Dotplot","Genome","Heatmap","Line","Map","Network","ParallelCoordinates","Pie","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap","Venn","Video"],AGraphs:["Area","AreaLine","Bar","BarLine","Boxplot","Candlestick","Circular","Correlation","DotLine","Dotplot","Heatmap","Line","Map","ParallelCoordinates","Sankey","Scatter2D","ScatterBubble2D","Scatter3D","Stacked","StackedLine","StackedPercent","StackedPercentLine","TagCloud","Tree","Treemap"],NoneDGraphs:["Genome","Map","Network","Sankey","TagCloud","Tree","Treemap","Venn","Video"]};CanvasXpress.colorNames={aliceblue:"F0F8FF",antiquewhite1:"FFEFDB",antiquewhite2:"EEDFCC",antiquewhite3:"CDC0B0",antiquewhite4:"8B8378",antiquewhite:"FAEBD7",aqua:"00FFFF",aquamarine1:"7FFFD4",aquamarine2:"76EEC6",aquamarine4:"458B74",aquamarine:"7FFFD4",azure1:"F0FFFF",azure2:"E0EEEE",azure3:"C1CDCD",azure4:"838B8B",azure:"F0FFFF",beige:"F5F5DC",bisque1:"FFE4C4",bisque2:"EED5B7",bisque3:"CDB79E",bisque4:"8B7D6B",bisque:"FFE4C4",black:"000000",blanchedalmond:"FFEBCD",blue:"0000FF",blue1:"0000FF",blue2:"0000EE",blue3:"1874CD",blue4:"00008B",blueviolet:"8A2BE2",brown1:"FF4040",brown2:"EE3B3B",brown3:"CD3333",brown4:"8B2323",brown:"A52A2A",burlywood1:"FFD39B",burlywood2:"EEC591",burlywood3:"CDAA7D",burlywood4:"8B7355",burlywood:"DEB887",cadetblue1:"98F5FF",cadetblue2:"8EE5EE",cadetblue3:"7AC5CD",cadetblue4:"53868B",cadetblue:"5F9EA0",chartreuse1:"7FFF00",chartreuse2:"76EE00",chartreuse3:"66CD00",chartreuse4:"458B00",chartreuse:"7FFF00",chocolate1:"FF7F24",chocolate2:"EE7621",chocolate3:"CD661D",chocolate:"D2691E",coral1:"FF7256",coral2:"EE6A50",coral3:"CD5B45",coral4:"8B3E2F",coral:"FF7F50",cornflowerblue:"6495ED",cornsilk1:"FFF8DC",cornsilk2:"EEE8CD",cornsilk3:"CDC8B1",cornsilk4:"8B8878",cornsilk:"FFF8DC",crimson:"DC143C",cyan:"00FFFF",cyan1:"00FFFF",cyan2:"00EEEE",cyan3:"00CDCD",cyan4:"008B8B",darkblue:"00008B",darkcyan:"008B8B",darkgoldenrod1:"FFB90F",darkgoldenrod2:"EEAD0E",darkgoldenrod3:"CD950C",darkgoldenrod4:"8B6508",darkgoldenrod4:"8B6508",darkgoldenrod:"B8860B",darkgray:"A9A9A9",darkgreen:"006400",darkgrey:"A9A9A9",darkkhaki:"BDB76B",darkmagenta:"8B008B",darkolivegreen1:"CAFF70",darkolivegreen2:"BCEE68",darkolivegreen3:"A2CD5A",darkolivegreen4:"6E8B3D",darkolivegreen:"556B2F",darkorange1:"FF7F00",darkorange2:"EE7600",darkorange3:"CD6600",darkorange4:"8B4500",darkorange:"FF8C00",darkorchid1:"BF3EFF",darkorchid2:"B23AEE",darkorchid3:"9A32CD",darkorchid4:"68228B",darkorchid:"9932CC",darkred:"8B0000",darksalmon:"E9967A",darkseagreen1:"C1FFC1",darkseagreen2:"B4EEB4",darkseagreen3:"9BCD9B",darkseagreen4:"698B69",darkseagreen:"8FBC8F",darkslateblue:"483D8B",darkslategray1:"97FFFF",darkslategray2:"8DEEEE",darkslategray:"2F4F4F",darkslategray3:"79CDCD",darkslategray4:"528B8B",darkslategrey:"2F4F4F",darkturquoise:"00CED1",darkviolet:"9400D3",deeppink1:"FF1493",deeppink2:"EE1289",deeppink3:"CD1076",deeppink4:"8B0A50",deeppink:"FF1493",deepskyblue:"00BFFF",deepskyblue1:"00BFFF",deepskyblue2:"00B2EE",deepskyblue3:"009ACD",deepskyblue4:"00688B",dimgray:"696969",dimgrey:"696969",dodgerblue1:"1E90FF",dodgerblue:"1E90FF",dodgerblue2:"1C86EE",dodgerblue3:"1874CD",dodgerblue4:"104E8B",firebrick1:"FF3030",firebrick2:"EE2C2C",firebrick3:"CD2626",firebrick4:"8B1A1A",firebrick:"B22222",floralwhite:"FFFAF0",forestgreen:"228B22",fuchsia:"FF00FF",gainsboro:"DCDCDC",ghostwhite:"F8F8FF",gold1:"FFD700",gold2:"EEC900",gold3:"CDAD00",gold4:"8B7500",goldenrod1:"FFC125",goldenrod2:"EEB422",goldenrod3:"CD9B1D",goldenrod4:"8B6914",goldenrod:"DAA520",goldenrod:"DAA520",gold:"FFD700",gray10:"1A1A1A",gray1:"030303",gray11:"1C1C1C",gray12:"1F1F1F",gray13:"212121",gray14:"242424",gray15:"262626",gray16:"292929",gray17:"2B2B2B",gray18:"2E2E2E",gray19:"303030",gray20:"333333",gray2:"050505",gray21:"363636",gray22:"383838",gray23:"3B3B3B",gray24:"3D3D3D",gray25:"404040",gray26:"424242",gray27:"454545",gray28:"474747",gray29:"4A4A4A",gray30:"4D4D4D",gray3:"080808",gray31:"4F4F4F",gray32:"525252",gray33:"545454",gray34:"575757",gray35:"595959",gray36:"5C5C5C",gray37:"5E5E5E",gray38:"616161",gray39:"636363",gray40:"666666",gray4:"0A0A0A",gray41:"696969",gray42:"6B6B6B",gray43:"6E6E6E",gray44:"707070",gray45:"737373",gray46:"757575",gray47:"787878",gray48:"7A7A7A",gray49:"7D7D7D",gray50:"7F7F7F",gray5:"0D0D0D",gray51:"828282",gray52:"858585",gray53:"878787",gray54:"8A8A8A",gray55:"8C8C8C",gray56:"8F8F8F",gray57:"919191",gray58:"949494",gray59:"969696",gray60:"999999",gray6:"0F0F0F",gray61:"9C9C9C",gray62:"9E9E9E",gray63:"A1A1A1",gray64:"A3A3A3",gray65:"A6A6A6",gray66:"A8A8A8",gray67:"ABABAB",gray68:"ADADAD",gray69:"B0B0B0",gray70:"B3B3B3",gray7:"121212",gray71:"B5B5B5",gray72:"B8B8B8",gray73:"BABABA",gray74:"BDBDBD",gray75:"BFBFBF",gray76:"C2C2C2",gray77:"C4C4C4",gray78:"C7C7C7",gray79:"C9C9C9",gray:"808080",gray80:"CCCCCC",gray8:"141414",gray81:"CFCFCF",gray82:"D1D1D1",gray83:"D4D4D4",gray84:"D6D6D6",gray85:"D9D9D9",gray86:"DBDBDB",gray87:"DEDEDE",gray88:"E0E0E0",gray89:"E3E3E3",gray90:"E5E5E5",gray9:"171717",gray91:"E8E8E8",gray92:"EBEBEB",gray93:"EDEDED",gray94:"F0F0F0",gray95:"F2F2F2",gray97:"F7F7F7",gray98:"FAFAFA",gray99:"FCFCFC",gray:"BEBEBE",green:"008000",green1:"00FF00",green2:"00EE00",green3:"00CD00",green4:"008B00",greenyellow:"ADFF2F",grey:"808080",honeydew1:"F0FFF0",honeydew2:"E0EEE0",honeydew3:"C1CDC1",honeydew4:"838B83",honeydew:"F0FFF0",hotpink1:"FF6EB4",hotpink2:"EE6AA7",hotpink3:"CD6090",hotpink4:"8B3A62",hotpink:"FF69B4",indianred1:"FF6A6A",indianred2:"EE6363",indianred3:"CD5555",indianred4:"8B3A3A",indianred:"CD5C5C",indigo:"4B0082",ivory1:"FFFFF0",ivory2:"EEEEE0",ivory3:"CDCDC1",ivory4:"8B8B83",ivory:"FFFFF0",khaki1:"FFF68F",khaki2:"EEE685",khaki3:"CDC673",khaki4:"8B864E",khaki:"F0E68C",lavenderblush1:"FFF0F5",lavenderblush2:"EEE0E5",lavenderblush3:"CDC1C5",lavenderblush4:"8B8386",lavenderblush:"FFF0F5",lavender:"E6E6FA",lawngreen:"7CFC00",lemonchiffon1:"FFFACD",lemonchiffon2:"EEE9BF",lemonchiffon3:"CDC9A5",lemonchiffon4:"8B8970",lemonchiffon:"FFFACD",lightblue1:"BFEFFF",lightblue2:"B2DFEE",lightblue3:"9AC0CD",lightblue4:"68838B",lightblue:"ADD8E6",lightcoral:"F08080",lightcyan1:"E0FFFF",lightcyan2:"D1EEEE",lightcyan3:"B4CDCD",lightcyan4:"7A8B8B",lightcyan:"E0FFFF",light:"EEDD82",lightgoldenrod1:"FFEC8B",lightgoldenrod2:"EEDC82",lightgoldenrod3:"CDBE70",lightgoldenrod4:"8B814C",lightgoldenrodyellow:"FAFAD2",lightgray:"D3D3D3",lightgreen:"90EE90",lightgrey:"D3D3D3",lightpink1:"FFAEB9",lightpink2:"EEA2AD",lightpink3:"CD8C95",lightpink4:"8B5F65",lightpink:"FFB6C1",lightsalmon1:"FFA07A",lightsalmon2:"EE9572",lightsalmon3:"CD8162",lightsalmon4:"8B5742",lightsalmon:"FFA07A",lightseagreen:"20B2AA",lightskyblue1:"B0E2FF",lightskyblue2:"A4D3EE",lightskyblue3:"8DB6CD",lightskyblue4:"607B8B",lightskyblue:"87CEFA",lightslateblue:"8470FF",lightslategray:"778899",lightslategrey:"778899",lightsteelblue1:"CAE1FF",lightsteelblue2:"BCD2EE",lightsteelblue3:"A2B5CD",lightsteelblue4:"6E7B8B",lightsteelblue:"B0C4DE",lightyellow1:"FFFFE0",lightyellow2:"EEEED1",lightyellow3:"CDCDB4",lightyellow4:"8B8B7A",lightyellow:"FFFFE0",lime:"00FF00",limegreen:"32CD32",linen:"FAF0E6",magenta2:"EE00EE",magenta3:"CD00CD",magenta4:"8B008B",magenta:"FF00FF",maroon1:"FF34B3",maroon2:"EE30A7",maroon3:"CD2990",maroon4:"8B1C62",maroon:"800000",maroon:"B03060",medium:"66CDAA",mediumaquamarine:"66CDAA",mediumblue:"0000CD",mediumorchid1:"E066FF",mediumorchid2:"D15FEE",mediumorchid3:"B452CD",mediumorchid4:"7A378B",mediumorchid:"BA55D3",mediumpurple1:"AB82FF",mediumpurple2:"9F79EE",mediumpurple3:"8968CD",mediumpurple4:"5D478B",mediumpurple:"9370DB",mediumseagreen:"3CB371",mediumslateblue:"7B68EE",mediumspringgreen:"00FA9A",mediumturquoise:"48D1CC",mediumvioletred:"C71585",midnightblue:"191970",mintcream:"F5FFFA",mistyrose1:"FFE4E1",mistyrose2:"EED5D2",mistyrose3:"CDB7B5",mistyrose4:"8B7D7B",mistyrose:"FFE4E1",moccasin:"FFE4B5",navajowhite1:"FFDEAD",navajowhite2:"EECFA1",navajowhite3:"CDB38B",navajowhite4:"8B795E",navajowhite:"FFDEAD",navy:"000080",navyblue:"000080",oldlace:"FDF5E6",olive:"808000",olivedrab1:"C0FF3E",olivedrab2:"B3EE3A",olivedrab4:"698B22",olivedrab:"6B8E23",orange1:"FFA500",orange2:"EE9A00",orange3:"CD8500",orange4:"8B5A00",orange:"FFA500",orangered1:"FF4500",orangered2:"EE4000",orangered3:"CD3700",orangered4:"8B2500",orangered:"FF4500",orchid1:"FF83FA",orchid2:"EE7AE9",orchid3:"CD69C9",orchid4:"8B4789",orchid:"DA70D6",pale:"DB7093",palegoldenrod:"EEE8AA",palegreen1:"9AFF9A",palegreen2:"90EE90",palegreen3:"7CCD7C",palegreen4:"548B54",palegreen:"98FB98",paleturquoise1:"BBFFFF",paleturquoise2:"AEEEEE",paleturquoise3:"96CDCD",paleturquoise4:"668B8B",paleturquoise:"AFEEEE",palevioletred1:"FF82AB",palevioletred2:"EE799F",palevioletred3:"CD6889",palevioletred4:"8B475D",palevioletred:"DB7093",papayawhip:"FFEFD5",peachpuff1:"FFDAB9",peachpuff2:"EECBAD",peachpuff3:"CDAF95",peachpuff4:"8B7765",peachpuff:"FFDAB9",peru:"CD853F",pink1:"FFB5C5",pink2:"EEA9B8",pink3:"CD919E",pink4:"8B636C",pink:"FFC0CB",plum1:"FFBBFF",plum2:"EEAEEE",plum3:"CD96CD",plum4:"8B668B",plum:"DDA0DD",powderblue:"B0E0E6",purple1:"9B30FF",purple2:"912CEE",purple3:"7D26CD",purple4:"551A8B",purple:"800080",purple:"A020F0",rebeccapurple:"663399",red1:"FF0000",red2:"EE0000",red3:"CD0000",red4:"8B0000",red:"FF0000",rosybrown1:"FFC1C1",rosybrown2:"EEB4B4",rosybrown3:"CD9B9B",rosybrown4:"8B6969",rosybrown:"BC8F8F",royalblue1:"4876FF",royalblue2:"436EEE",royalblue3:"3A5FCD",royalblue:"4169E1",royalblue4:"27408B",saddlebrown:"8B4513",salmon1:"FF8C69",salmon2:"EE8262",salmon3:"CD7054",salmon4:"8B4C39",salmon:"FA8072",sandybrown:"F4A460",seagreen1:"54FF9F",seagreen2:"4EEE94",seagreen:"2E8B57",seagreen3:"43CD80",seagreen4:"2E8B57",seashell1:"FFF5EE",seashell2:"EEE5DE",seashell3:"CDC5BF",seashell4:"8B8682",seashell:"FFF5EE",sienna1:"FF8247",sienna2:"EE7942",sienna3:"CD6839",sienna4:"8B4726",sienna:"A0522D",silver:"C0C0C0",skyblue1:"87CEFF",skyblue2:"7EC0EE",skyblue3:"6CA6CD",skyblue4:"4A708B",skyblue:"87CEEB",slateblue1:"836FFF",slateblue2:"7A67EE",slateblue3:"6959CD",slateblue4:"473C8B",slateblue:"6A5ACD",slategray1:"C6E2FF",slategray2:"B9D3EE",slategray3:"9FB6CD",slategray4:"6C7B8B",slategray:"708090",slategrey:"708090",snow1:"FFFAFA",snow2:"EEE9E9",snow3:"CDC9C9",snow4:"8B8989",snow:"FFFAFA",springgreen:"00FF7F",springgreen1:"00FF7F",springgreen2:"00EE76",springgreen3:"00CD66",springgreen4:"008B45",steelblue1:"63B8FF",steelblue2:"5CACEE",steelblue3:"4F94CD",steelblue4:"36648B",steelblue:"4682B4",tan1:"FFA54F",tan2:"EE9A49",tan3:"CD853F",tan4:"8B5A2B",tan:"D2B48C",teal:"008080",thistle1:"FFE1FF",thistle2:"EED2EE",thistle3:"CDB5CD",thistle4:"8B7B8B",thistle:"D8BFD8",tomato1:"FF6347",tomato2:"EE5C42",tomato3:"CD4F39",tomato4:"8B3626",tomato:"FF6347",turquoise1:"00F5FF",turquoise2:"00E5EE",turquoise3:"00C5CD",turquoise4:"00868B",turquoise:"40E0D0",violet:"EE82EE",violetred1:"FF3E96",violetred2:"EE3A8C",violetred3:"CD3278",violetred4:"8B2252",violetred:"D02090",wheat1:"FFE7BA",wheat2:"EED8AE",wheat3:"CDBA96",wheat4:"8B7E66",wheat:"F5DEB3",white:"FFFFFF",whitesmoke:"F5F5F5",yellow1:"FFFF00",yellow2:"EEEE00",yellow3:"CDCD00",yellow4:"8B8B00",yellow:"FFFF00",yellowgreen:"9ACD32"};CanvasXpress.colorSchemes={YlGn:{3:["#f7fcb9","#addd8e","#31a354"],4:["#ffffcc","#c2e699","#78c679","#238443"],5:["#ffffcc","#c2e699","#78c679","#31a354","#006837"],6:["#ffffcc","#d9f0a3","#addd8e","#78c679","#31a354","#006837"],7:["#ffffcc","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],8:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#005a32"],9:["#ffffe5","#f7fcb9","#d9f0a3","#addd8e","#78c679","#41ab5d","#238443","#006837","#004529"]},YlGnBu:{3:["#edf8b1","#7fcdbb","#2c7fb8"],4:["#ffffcc","#a1dab4","#41b6c4","#225ea8"],5:["#ffffcc","#a1dab4","#41b6c4","#2c7fb8","#253494"],6:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#2c7fb8","#253494"],7:["#ffffcc","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],8:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#0c2c84"],9:["#ffffd9","#edf8b1","#c7e9b4","#7fcdbb","#41b6c4","#1d91c0","#225ea8","#253494","#081d58"]},GnBu:{3:["#e0f3db","#a8ddb5","#43a2ca"],4:["#f0f9e8","#bae4bc","#7bccc4","#2b8cbe"],5:["#f0f9e8","#bae4bc","#7bccc4","#43a2ca","#0868ac"],6:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#43a2ca","#0868ac"],7:["#f0f9e8","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],8:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#08589e"],9:["#f7fcf0","#e0f3db","#ccebc5","#a8ddb5","#7bccc4","#4eb3d3","#2b8cbe","#0868ac","#084081"]},BuGn:{3:["#e5f5f9","#99d8c9","#2ca25f"],4:["#edf8fb","#b2e2e2","#66c2a4","#238b45"],5:["#edf8fb","#b2e2e2","#66c2a4","#2ca25f","#006d2c"],6:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#2ca25f","#006d2c"],7:["#edf8fb","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],8:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#005824"],9:["#f7fcfd","#e5f5f9","#ccece6","#99d8c9","#66c2a4","#41ae76","#238b45","#006d2c","#00441b"]},PuBuGn:{3:["#ece2f0","#a6bddb","#1c9099"],4:["#f6eff7","#bdc9e1","#67a9cf","#02818a"],5:["#f6eff7","#bdc9e1","#67a9cf","#1c9099","#016c59"],6:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#1c9099","#016c59"],7:["#f6eff7","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],8:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016450"],9:["#fff7fb","#ece2f0","#d0d1e6","#a6bddb","#67a9cf","#3690c0","#02818a","#016c59","#014636"]},PuBu:{3:["#ece7f2","#a6bddb","#2b8cbe"],4:["#f1eef6","#bdc9e1","#74a9cf","#0570b0"],5:["#f1eef6","#bdc9e1","#74a9cf","#2b8cbe","#045a8d"],6:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#2b8cbe","#045a8d"],7:["#f1eef6","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],8:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#034e7b"],9:["#fff7fb","#ece7f2","#d0d1e6","#a6bddb","#74a9cf","#3690c0","#0570b0","#045a8d","#023858"]},BuPu:{3:["#e0ecf4","#9ebcda","#8856a7"],4:["#edf8fb","#b3cde3","#8c96c6","#88419d"],5:["#edf8fb","#b3cde3","#8c96c6","#8856a7","#810f7c"],6:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8856a7","#810f7c"],7:["#edf8fb","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],8:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#6e016b"],9:["#f7fcfd","#e0ecf4","#bfd3e6","#9ebcda","#8c96c6","#8c6bb1","#88419d","#810f7c","#4d004b"]},RdPu:{3:["#fde0dd","#fa9fb5","#c51b8a"],4:["#feebe2","#fbb4b9","#f768a1","#ae017e"],5:["#feebe2","#fbb4b9","#f768a1","#c51b8a","#7a0177"],6:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#c51b8a","#7a0177"],7:["#feebe2","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],8:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177"],9:["#fff7f3","#fde0dd","#fcc5c0","#fa9fb5","#f768a1","#dd3497","#ae017e","#7a0177","#49006a"]},PuRd:{3:["#e7e1ef","#c994c7","#dd1c77"],4:["#f1eef6","#d7b5d8","#df65b0","#ce1256"],5:["#f1eef6","#d7b5d8","#df65b0","#dd1c77","#980043"],6:["#f1eef6","#d4b9da","#c994c7","#df65b0","#dd1c77","#980043"],7:["#f1eef6","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],8:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#91003f"],9:["#f7f4f9","#e7e1ef","#d4b9da","#c994c7","#df65b0","#e7298a","#ce1256","#980043","#67001f"]},OrRd:{3:["#fee8c8","#fdbb84","#e34a33"],4:["#fef0d9","#fdcc8a","#fc8d59","#d7301f"],5:["#fef0d9","#fdcc8a","#fc8d59","#e34a33","#b30000"],6:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#e34a33","#b30000"],7:["#fef0d9","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],8:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#990000"],9:["#fff7ec","#fee8c8","#fdd49e","#fdbb84","#fc8d59","#ef6548","#d7301f","#b30000","#7f0000"]},YlOrRd:{3:["#ffeda0","#feb24c","#f03b20"],4:["#ffffb2","#fecc5c","#fd8d3c","#e31a1c"],5:["#ffffb2","#fecc5c","#fd8d3c","#f03b20","#bd0026"],6:["#ffffb2","#fed976","#feb24c","#fd8d3c","#f03b20","#bd0026"],7:["#ffffb2","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],8:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#b10026"],9:["#ffffcc","#ffeda0","#fed976","#feb24c","#fd8d3c","#fc4e2a","#e31a1c","#bd0026","#800026"]},YlOrBr:{3:["#fff7bc","#fec44f","#d95f0e"],4:["#ffffd4","#fed98e","#fe9929","#cc4c02"],5:["#ffffd4","#fed98e","#fe9929","#d95f0e","#993404"],6:["#ffffd4","#fee391","#fec44f","#fe9929","#d95f0e","#993404"],7:["#ffffd4","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],8:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#8c2d04"],9:["#ffffe5","#fff7bc","#fee391","#fec44f","#fe9929","#ec7014","#cc4c02","#993404","#662506"]},Purples:{3:["#efedf5","#bcbddc","#756bb1"],4:["#f2f0f7","#cbc9e2","#9e9ac8","#6a51a3"],5:["#f2f0f7","#cbc9e2","#9e9ac8","#756bb1","#54278f"],6:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#756bb1","#54278f"],7:["#f2f0f7","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],8:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#4a1486"],9:["#fcfbfd","#efedf5","#dadaeb","#bcbddc","#9e9ac8","#807dba","#6a51a3","#54278f","#3f007d"]},Blues:{3:["#deebf7","#9ecae1","#3182bd"],4:["#eff3ff","#bdd7e7","#6baed6","#2171b5"],5:["#eff3ff","#bdd7e7","#6baed6","#3182bd","#08519c"],6:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#3182bd","#08519c"],7:["#eff3ff","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],8:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#084594"],9:["#f7fbff","#deebf7","#c6dbef","#9ecae1","#6baed6","#4292c6","#2171b5","#08519c","#08306b"]},Greens:{3:["#e5f5e0","#a1d99b","#31a354"],4:["#edf8e9","#bae4b3","#74c476","#238b45"],5:["#edf8e9","#bae4b3","#74c476","#31a354","#006d2c"],6:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#31a354","#006d2c"],7:["#edf8e9","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],8:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#005a32"],9:["#f7fcf5","#e5f5e0","#c7e9c0","#a1d99b","#74c476","#41ab5d","#238b45","#006d2c","#00441b"]},Oranges:{3:["#fee6ce","#fdae6b","#e6550d"],4:["#feedde","#fdbe85","#fd8d3c","#d94701"],5:["#feedde","#fdbe85","#fd8d3c","#e6550d","#a63603"],6:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#e6550d","#a63603"],7:["#feedde","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],8:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#8c2d04"],9:["#fff5eb","#fee6ce","#fdd0a2","#fdae6b","#fd8d3c","#f16913","#d94801","#a63603","#7f2704"]},Reds:{3:["#fee0d2","#fc9272","#de2d26"],4:["#fee5d9","#fcae91","#fb6a4a","#cb181d"],5:["#fee5d9","#fcae91","#fb6a4a","#de2d26","#a50f15"],6:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#de2d26","#a50f15"],7:["#fee5d9","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],8:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#99000d"],9:["#fff5f0","#fee0d2","#fcbba1","#fc9272","#fb6a4a","#ef3b2c","#cb181d","#a50f15","#67000d"]},Greys:{3:["#f0f0f0","#bdbdbd","#636363"],4:["#f7f7f7","#cccccc","#969696","#525252"],5:["#f7f7f7","#cccccc","#969696","#636363","#252525"],6:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#636363","#252525"],7:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],8:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],9:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"]},PuOr:{3:["#f1a340","#f7f7f7","#998ec3"],4:["#e66101","#fdb863","#b2abd2","#5e3c99"],5:["#e66101","#fdb863","#f7f7f7","#b2abd2","#5e3c99"],6:["#b35806","#f1a340","#fee0b6","#d8daeb","#998ec3","#542788"],7:["#b35806","#f1a340","#fee0b6","#f7f7f7","#d8daeb","#998ec3","#542788"],8:["#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788"],9:["#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788"],10:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"],11:["#7f3b08","#b35806","#e08214","#fdb863","#fee0b6","#f7f7f7","#d8daeb","#b2abd2","#8073ac","#542788","#2d004b"]},BrBG:{3:["#d8b365","#f5f5f5","#5ab4ac"],4:["#a6611a","#dfc27d","#80cdc1","#018571"],5:["#a6611a","#dfc27d","#f5f5f5","#80cdc1","#018571"],6:["#8c510a","#d8b365","#f6e8c3","#c7eae5","#5ab4ac","#01665e"],7:["#8c510a","#d8b365","#f6e8c3","#f5f5f5","#c7eae5","#5ab4ac","#01665e"],8:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e"],9:["#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e"],10:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"],11:["#543005","#8c510a","#bf812d","#dfc27d","#f6e8c3","#f5f5f5","#c7eae5","#80cdc1","#35978f","#01665e","#003c30"]},PRGn:{3:["#af8dc3","#f7f7f7","#7fbf7b"],4:["#7b3294","#c2a5cf","#a6dba0","#008837"],5:["#7b3294","#c2a5cf","#f7f7f7","#a6dba0","#008837"],6:["#762a83","#af8dc3","#e7d4e8","#d9f0d3","#7fbf7b","#1b7837"],7:["#762a83","#af8dc3","#e7d4e8","#f7f7f7","#d9f0d3","#7fbf7b","#1b7837"],8:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837"],9:["#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837"],10:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"],11:["#40004b","#762a83","#9970ab","#c2a5cf","#e7d4e8","#f7f7f7","#d9f0d3","#a6dba0","#5aae61","#1b7837","#00441b"]},PiYG:{3:["#e9a3c9","#f7f7f7","#a1d76a"],4:["#d01c8b","#f1b6da","#b8e186","#4dac26"],5:["#d01c8b","#f1b6da","#f7f7f7","#b8e186","#4dac26"],6:["#c51b7d","#e9a3c9","#fde0ef","#e6f5d0","#a1d76a","#4d9221"],7:["#c51b7d","#e9a3c9","#fde0ef","#f7f7f7","#e6f5d0","#a1d76a","#4d9221"],8:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221"],9:["#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221"],10:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"],11:["#8e0152","#c51b7d","#de77ae","#f1b6da","#fde0ef","#f7f7f7","#e6f5d0","#b8e186","#7fbc41","#4d9221","#276419"]},RdBu:{3:["#ef8a62","#f7f7f7","#67a9cf"],4:["#ca0020","#f4a582","#92c5de","#0571b0"],5:["#ca0020","#f4a582","#f7f7f7","#92c5de","#0571b0"],6:["#b2182b","#ef8a62","#fddbc7","#d1e5f0","#67a9cf","#2166ac"],7:["#b2182b","#ef8a62","#fddbc7","#f7f7f7","#d1e5f0","#67a9cf","#2166ac"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#f7f7f7","#d1e5f0","#92c5de","#4393c3","#2166ac","#053061"]},RdGy:{3:["#ef8a62","#ffffff","#999999"],4:["#ca0020","#f4a582","#bababa","#404040"],5:["#ca0020","#f4a582","#ffffff","#bababa","#404040"],6:["#b2182b","#ef8a62","#fddbc7","#e0e0e0","#999999","#4d4d4d"],7:["#b2182b","#ef8a62","#fddbc7","#ffffff","#e0e0e0","#999999","#4d4d4d"],8:["#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d"],9:["#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d"],10:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"],11:["#67001f","#b2182b","#d6604d","#f4a582","#fddbc7","#ffffff","#e0e0e0","#bababa","#878787","#4d4d4d","#1a1a1a"]},RdYlBu:{3:["#fc8d59","#ffffbf","#91bfdb"],4:["#d7191c","#fdae61","#abd9e9","#2c7bb6"],5:["#d7191c","#fdae61","#ffffbf","#abd9e9","#2c7bb6"],6:["#d73027","#fc8d59","#fee090","#e0f3f8","#91bfdb","#4575b4"],7:["#d73027","#fc8d59","#fee090","#ffffbf","#e0f3f8","#91bfdb","#4575b4"],8:["#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4"],9:["#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee090","#ffffbf","#e0f3f8","#abd9e9","#74add1","#4575b4","#313695"]},Spectral:{3:["#fc8d59","#ffffbf","#99d594"],4:["#d7191c","#fdae61","#abdda4","#2b83ba"],5:["#d7191c","#fdae61","#ffffbf","#abdda4","#2b83ba"],6:["#d53e4f","#fc8d59","#fee08b","#e6f598","#99d594","#3288bd"],7:["#d53e4f","#fc8d59","#fee08b","#ffffbf","#e6f598","#99d594","#3288bd"],8:["#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd"],9:["#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd"],10:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"],11:["#9e0142","#d53e4f","#f46d43","#fdae61","#fee08b","#ffffbf","#e6f598","#abdda4","#66c2a5","#3288bd","#5e4fa2"]},RdYlGn:{3:["#fc8d59","#ffffbf","#91cf60"],4:["#d7191c","#fdae61","#a6d96a","#1a9641"],5:["#d7191c","#fdae61","#ffffbf","#a6d96a","#1a9641"],6:["#d73027","#fc8d59","#fee08b","#d9ef8b","#91cf60","#1a9850"],7:["#d73027","#fc8d59","#fee08b","#ffffbf","#d9ef8b","#91cf60","#1a9850"],8:["#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850"],9:["#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850"],10:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"],11:["#a50026","#d73027","#f46d43","#fdae61","#fee08b","#ffffbf","#d9ef8b","#a6d96a","#66bd63","#1a9850","#006837"]},Accent:{3:["#7fc97f","#beaed4","#fdc086"],4:["#7fc97f","#beaed4","#fdc086","#ffff99"],5:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0"],6:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f"],7:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17"],8:["#7fc97f","#beaed4","#fdc086","#ffff99","#386cb0","#f0027f","#bf5b17","#666666"]},Dark2:{3:["#1b9e77","#d95f02","#7570b3"],4:["#1b9e77","#d95f02","#7570b3","#e7298a"],5:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e"],6:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02"],7:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d"],8:["#1b9e77","#d95f02","#7570b3","#e7298a","#66a61e","#e6ab02","#a6761d","#666666"]},Paired:{3:["#a6cee3","#1f78b4","#b2df8a"],4:["#a6cee3","#1f78b4","#b2df8a","#33a02c"],5:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99"],6:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c"],7:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f"],8:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00"],9:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6"],10:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a"],11:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99"],12:["#a6cee3","#1f78b4","#b2df8a","#33a02c","#fb9a99","#e31a1c","#fdbf6f","#ff7f00","#cab2d6","#6a3d9a","#ffff99","#b15928"]},Pastel1:{3:["#fbb4ae","#b3cde3","#ccebc5"],4:["#fbb4ae","#b3cde3","#ccebc5","#decbe4"],5:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6"],6:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc"],7:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd"],8:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec"],9:["#fbb4ae","#b3cde3","#ccebc5","#decbe4","#fed9a6","#ffffcc","#e5d8bd","#fddaec","#f2f2f2"]},Pastel2:{3:["#b3e2cd","#fdcdac","#cbd5e8"],4:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4"],5:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9"],6:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae"],7:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc"],8:["#b3e2cd","#fdcdac","#cbd5e8","#f4cae4","#e6f5c9","#fff2ae","#f1e2cc","#cccccc"]},Set1:{3:["#e41a1c","#377eb8","#4daf4a"],4:["#e41a1c","#377eb8","#4daf4a","#984ea3"],5:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00"],6:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33"],7:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628"],8:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf"],9:["#e41a1c","#377eb8","#4daf4a","#984ea3","#ff7f00","#ffff33","#a65628","#f781bf","#999999"]},Set2:{3:["#66c2a5","#fc8d62","#8da0cb"],4:["#66c2a5","#fc8d62","#8da0cb","#e78ac3"],5:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854"],6:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f"],7:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494"],8:["#66c2a5","#fc8d62","#8da0cb","#e78ac3","#a6d854","#ffd92f","#e5c494","#b3b3b3"]},Set3:{3:["#8dd3c7","#ffffb3","#bebada"],4:["#8dd3c7","#ffffb3","#bebada","#fb8072"],5:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3"],6:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462"],7:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69"],8:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5"],9:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9"],10:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd"],11:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5"],12:["#8dd3c7","#ffffb3","#bebada","#fb8072","#80b1d3","#fdb462","#b3de69","#fccde5","#d9d9d9","#bc80bd","#ccebc5","#ffed6f"]},Default:{36:["#ff0000","#0000ff","#00ff00","#ffff00","#00ffff","#ff00ff","#993300","#000080","#808000","#ff6600","#008080","#660066","#ff99cc","#666699","#333300","#ffcc99","#ccffff","#9999ff","#ff8080","#3366ff","#339966","#ffcc00","#00ccff","#d02090","#993366","#0066cc","#99cc00","#ff9900","#33cccc","#cc99ff","#800000","#333399","#008000","#ffffcc","#99ccff","#800080"]},Basic:{24:["#0000ff","#ff004d","#ffbf00","#74ff00","#a400ff","#ff7400","#ffff00","#00ffff","#ff0000","#ffd300","#3d00ff","#00ff00","#ff00ff","#ff9200","#d3ff00","#0090ff","#6d00ff","#ff4900","#ffe800","#00ff92","#ff0090","#ffaa00","#aaff00","#004dff"]},Light:{24:["#6565ff","#ff6593","#ffd865","#abff65","#c865ff","#ffab65","#ffff65","#65ffff","#ff6565","#ffe565","#8965ff","#65ff65","#ff65ff","#ffbd65","#e5ff65","#65bcff","#a765ff","#ff9165","#fff165","#65ffbd","#ff65bc","#ffcc65","#ccff65","#6593ff"]},Favorite:{1:["#ff0000"],2:["#ff0000","#00ffff"],3:["#ff0000","#00ff00","#0000ff"],4:["#ff0000","#80ff00","#00ffff","#8000ff"],5:["#ff0000","#bfff00","#00ff80","#0040ff","#ff00ff"],6:["#ff0000","#ffff00","#00ff00","#00ffff","#0000ff","#ff00ff"],8:["#ff0000","#ffbf00","#80ff00","#00ff40","#00ffff","#0040ff","#8000ff","#ff00bf"],10:["#ff0000","#ff8000","#ffff00","#80ff00","#00ff00","#00ff80","#00ffff","#0080ff","#0000ff","#8000ff"],12:["#ff0000","#ff8000","#ffff00","#80ff00","#00ff00","#00ff80","#00ffff","#0080ff","#0000ff","#8000ff","#ff00ff","#ff0080"],24:["#ff0000","#ff4000","#ff8000","#ffbf00","#ffff00","#bfff00","#80ff00","#40ff00","#00ff00","#00ff40","#00ff80","#00ffbf","#00ffff","#00bfff","#0080ff","#0040ff","#0000ff","#4000ff","#8000ff","#bf00ff","#ff00ff","#ff00bf","#ff0080","#ff0040"]},Pastel:{24:["#b5b5ff","#ffb5cb","#ffedb5","#d7ffb5","#e5b5ff","#ffd7b5","#ffffb5","#b5ffff","#ffb5b5","#fff2b5","#c7b5ff","#b5ffb5","#ffb5ff","#ffdfb5","#f2ffb5","#b5dfff","#d5b5ff","#ffcab5","#fff8b5","#b5ffdf","#ffb5df","#ffe6b5","#e6ffb5","#b5cbff"]},Balanced:{20:["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"]},Rpalette:{8:["#000000","#ff0000","#00cd00","#0000ff","#00ffff","#ff00ff","#ffff00","#bebebe"]},RlatticeBackground:{7:["#ffe5cc","#ccffcc","#ccffff","#cce6ff","#ffccff","#ffcccc","#ffffcc"]},RlatticeShingle:{7:["#ff7f00","#00ff00","#00ffff","#0080ff","#ff00ff","#ff0000","#ffff00"]},RlatticeLine:{7:["#0080ff","#ff00ff","#006400","#ff0000","#ffa500","#00ff00","#a52a2a"]},RlatticePolygon:{7:["#ccffff","#ffccff","#ccffcc","#ffe5cc","#cce6ff","#ffffcc","#ffcccc"]},Bootstrap:{1:["#337ab7"],2:["#337ab7","#d9534f"],3:["#337ab7","#5cb85c","#d9534f"],4:["#337ab7","#5cb85c","#f0ad4e","#d9534f"],5:["#337ab7","#5cb85c","#5bc0de","#f0ad4e","#d9534f"],6:["#337ab7","#5cb85c","#9370db","#5bc0de","#f0ad4e","#d9534f"],7:["#337ab7","#5cb85c","#d9534f","#f0ad4e","#5bc0de","#84fe83","#ff9976"],8:["#337ab7","#5cb85c","#d9534f","#f0ad4e","#5bc0de","#84fe83","#ff9976","#c86727"]},ColorSpectrum:{1:[]},White:{1:["#ffffff"]},Black:{1:["#000000"]},Economist:{12:["#6794A7","#014D64","#76C0C1","#01A2D9","#7AD2F6","#00887D","#ADADAD","#7BD3F6","#7C260B","#EE8F71","#76C0C1","#A18376"]},EconomistBG:{5:["#D5E4EB","#C3D6DF","#ED111A","#EBEBEB","#C9C9C9"]},Excel:{7:["#FF00FF","#FFFF00","#00FFFF","#800080","#800000","#008080","#0000FF"]},Excel2:{7:["#993366","#FFFFCC","#CCFFFF","#660066","#FF8080","#0066CC","#CCCCFF"]},Excel3:{10:["#365E96","#983334","#77973D","#5D437C","#36869F","#D1702F","#8197C5","#C47F80","#ACC484","#9887B0"]},GGPlot:{1:["#F8766D"],2:["#F8766D","#00BFC4"],3:["#F8766D","#00BA38","#619CFF"],4:["#F8766D","#7CAE00","#00BFC4","#C77CFF"],5:["#F8766D","#A3A500","#00BF7D","#00B0F6","#E76BF3"],6:["#F8766D","#B79F00","#00BA38","#00BFC4","#619CFF","#F564E3"],7:["#F8766D","#C49A00","#53B400","#00C094","#00B6EB","#A58AFF","#FB61D7"],8:["#F8766D","#CD9600","#7CAE00","#00BE67","#00BFC4","#00A9FF","#C77CFF","#FF61CC"],9:["#F8766D","#D39200","#93AA00","#00BA38","#00C19F","#00B9E3","#619CFF","#DB72FB","#FF61C3"],10:["#F8766D","#D89000","#A3A500","#39B600","#00BF7D","#00BFC4","#00B0F6","#9590FF","#E76BF3","#FF62BC"],11:["#F8766D","#DB8E00","#AEA200","#64B200","#00BD5C","#00C1A7","#00BADE","#00A6FF","#B385FF","#EF67EB","#FF63B6"],12:["#F8766D","#DE8C00","#B79F00","#7CAE00","#00BA38","#00C08B","#00BFC4","#00B4F0","#619CFF","#C77CFF","#F564E3","#FF64B0"],13:["#F8766D","#E18A00","#BE9C00","#8CAB00","#24B700","#00BE70","#00C1AB","#00BBDA","#00ACFC","#8B93FF","#D575FE","#F962DD","#FF65AC"],14:["#F8766D","#E38900","#C49A00","#99A800","#53B400","#00BC56","#00C094","#00BFC4","#00B6EB","#06A4FF","#A58AFF","#DF70F8","#FB61D7","#FF66A8"],15:["#F8766D","#E58700","#C99800","#A3A500","#6BB100","#00BA38","#00BF7D","#00C0AF","#00BCD8","#00B0F6","#619CFF","#B983FF","#E76BF3","#FD61D1","#FF67A4"],16:["#F8766D","#E68613","#CD9600","#ABA300","#7CAE00","#0CB702","#00BE67","#00C19A","#00BFC4","#00B8E7","#00A9FF","#8494FF","#C77CFF","#ED68ED","#FF61CC","#FF68A1"],17:["#F8766D","#E7851E","#D09400","#B2A100","#89AC00","#45B500","#00BC51","#00C087","#00C0B2","#00BCD6","#00B3F2","#29A3FF","#9C8DFF","#D277FF","#F166E8","#FF61C7","#FF689E"],18:["#F8766D","#E88526","#D39200","#B79F00","#93AA00","#5EB300","#00BA38","#00BF74","#00C19F","#00BFC4","#00B9E3","#00ADFA","#619CFF","#AE87FF","#DB72FB","#F564E3","#FF61C3","#FF699C"]},Solarized:{1:["#B58900"],2:["#B58900","#859900"],3:["#B58900","#C671C4","#859900"],4:["#B58900","#DC322F","#268BD2","#859900"],5:["#B58900","#DC322F","#6C71C4","#268BD2","#859900"],6:["#B58900","#CB4B16","#D33682","#6C71C4","#2AA198","#859900"],7:["#B58900","#CB4B16","#DC322F","#6C71C4","#268BD2","#2AA198","#859900"],8:["#B58900","#CB4B16","#DC322F","#D33682","#6C71C4","#268BD2","#2AA198",,"#859900"]},SolarizedBase:{7:["#002B36","#073642","#586E75","#839496","#93A1A1","#EEE8D5","#FDF6E3"],8:["#002B36","#073642","#586E75","#657B83","#839496","#93A1A1","#EEE8D5","#FDF6E3"]},PaulTol:{1:["#4477AA"],2:["#4477AA","#CC6677"],3:["#4477AA","#DDCC77","#CC6677"],4:["#4477AA","#117733","#DDCC77","#CC6677"],5:["#4477AA","#88CCEE","#117733","#DDCC77","#CC6677"],6:["#4477AA","#88CCEE","#117733","#DDCC77","#CC6677","#AA4499"],7:["#332288","#88CCEE","#44AA99","#117733","#DDCC77","#CC6677","#AA4499"],8:["#332288","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#CC6677","#AA4499"],9:["#332288","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#CC6677","#882255","#AA4499"],10:["#332288","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#661100","#CC6677","#882255","#AA4499"],11:["#332288","#6699CC","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#661100","#CC6677","#882255","#AA4499"],12:["#332288","#6699CC","#88CCEE","#44AA99","#117733","#999933","#DDCC77","#661100","#CC6677","#AA4466","#882255","#AA4499"]},ColorBlind:{8:["#000000","#E69F00","#56B4E9","#009E73","#F0E442","#0072B2","#D55E00","#CC79A7"]},Tableau:{20:["#1F77B4","#AEC7E8","#FF7F0E","#FFBB78","#2CA02C","#98DF8A","#D62728","#FF9896","#9467BD","#C5B0D5","#8C564B","#C49C94","#E377C2","#F7B6D2","#7F7F7F","#C7C7C7","#BCBD22","#DBDB8D","#17BECF","#9EDAE5"],10:["#1F77B4","#FF7F0E","#2CA02C","#D62728","#9467BD","#8C564B","#E377C2","#7F7F7F","#BCBD22","#17BECF"]},TableauMedium:{10:["#729ECE","#FF9E4A","#67BF5C","#ED665D","#AD8BC9","#A8786E","#ED97CA","#A2A2A2","#CDCC5D","#6DCCDA"]},TableauLight:{10:["#AEC7E8","#FFBB78","#98DF8A","#FF9896","#C5B0D5","#C49C94","#F7B6D2","#C7C7C7","#DBDB8D","#9EDAE5"]},TableauGrey:{5:["#60636A","#A5ACAF","#414451","#8F8782","#CFCFCF"]},TableauColorBlind:{10:["#006BA4","#FF800E","#ABABAB","#595959","#5F9ED1","#C85200","#898989","#A2C8EC","#FFBC79","#CFCFCF"]},TableauTrafficLight:{9:["#B10318","#DBA13A","#309343","#D82526","#FFC156","#69B764","#F26C64","#FFDD71","#9FCD99"]},TableauPurpleGrey:{12:["#7B66D2","#A699E8","#DC5FBD","#FFC0DA","#5F5A41","#B4B19B","#995688","#D898BA","#AB6AD5","#D098EE","#8B7C6E","#DBD4C5"]},TableauBlueRed:{12:["#2C69B0","#B5C8E2","#F02720","#FFB6B0","#AC613C","#E9C39B","#6BA3D6","#B5DFFD","#AC8763","#DDC9B4","#BD0A36","#F4737A"]},TableauGreenOrange:{12:["#32A251","#ACD98D","#FF7F0F","#FFB977","#3CB7CC","#98D9E4","#B85A0D","#FFD94A","#39737C","#86B4A9","#82853B","#CCC94D"]},TableauCyclic:{20:["#1F83B4","#1696AC","#18A188","#29A03C","#54A338","#82A93F","#ADB828","#D8BD35","#FFBD4C","#FFB022","#FF9C0E","#FF810E","#E75727","#D23E4E","#C94D8C","#C04AA7","#B446B3","#9658B1","#8061B4","#6F63BB"]},TableauPairSequential:{32:["#BCCFB4","#9C0824","#BCCFB4","#09622A","#B4D4DA","#26456E","#F0C294","#7B3014","#C3C3C3","#1E1E1E","#E5E5E5","#FFB2B6","#E5E5E5","#B7E6A7","#E5E5E5","#C4D8F3","#E5E5E5","#FFCC9E","#F5CAC7","#BD1100","#DBE8B4","#3C8200","#F3E0C2","#BB5137","#FEFFD9","#41B7C4","#F7E4C6","#BB5137","#EFEDF5","#807DBA","#F0F0F0","#737373"]},TableauTripleDiverging:{48:["#9C0824","#CACACA","#26456E","#9C0824","#CACACA","#09622A","#9C0824","#FFFFFF","#09622A","#9C0824","#CACACA","#1E1E1E","#9C0824","#FFFFFF","#1E1E1E","#09622A","#CACACA","#26456E","#7B3014","#CACACA","#26456E","#7B3014","#FFFFFF","#26456E","#FFB2B6","#E5E5E5","#B7E6A7","#FFB2B6","#FFFFFF","#B7E6A7","#FFB2B6","#FFFFFF","#C6C6C6","#FFCC9E","#E5E5E5","#C4D8F3","#FFCC9E","#FFFFFF","#C4D8F3","#E0AD30","#E4E4E2","#7492AA","#EDA389","#CDE1D3","#5C8B70","#529985","#DBCF47","#C26B51"]},WallStreetJournal:{4:["#EFEFEF","#E9F3EA","#D4DEE7","#F8F2E4"]},WallStreetJournal2:{4:["#D3BA68","#D5695D","#5D8CA8","#65A479"]},WallStreetJournalRedGreen:{2:["#088158","#BA2F2A"]},WallStreetJournalBlackGreen:{4:["#000000","#595959","#59A77F","#008856"]},WallStreetJournalDemRep:{3:["#006A8E","#B1283A","#A8A6A7"]},WallStreetJournal3:{6:["#C72E29","#016392","#BE9C2E","#098154","#FB832D","#000000"]},Stata:{15:["#1A476F","#90353B","#55752F","#E37E00","#6E8E84","#C10534","#938DD2","#CAC27E","#A0522D","#7B92A8","#2D6D66","#9C8847","#BFA19C","#FFD200","#D9E6EB"]},Stata2:{15:["#FFFF00","#00FF00","#0080FF","#FF00FF","#FF7F00","#FF0000","#ADD8E6","#FFE474","#00FF80","#C0DCC0","#FF4500","#0000FF","#FF0080","#6E8E84","#A0522D"]},Stata3:{15:["#006000","#ff4500","#1a476f","#90353b","#6e8e84","#a0522d","#ff7f00","#ff00ff","#00ffff","#ff0000","#00ff00","#9c8847","#800080","#c0dcc0","#add8e6"]},StataMono:{15:["#606060","#A0A0A0","#808080","#404040","#000000","#E0E0E0","#202020","#707070","#909090","#B0B0B0","#D0D0D0","#F0F0F0","#303030","#C0C0C0","#505050"]},BlackAndWhite:{3:["#f0f0f0","#bdbdbd","#636363"],4:["#f7f7f7","#cccccc","#969696","#525252"],5:["#f7f7f7","#cccccc","#969696","#636363","#252525"],6:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#636363","#252525"],7:["#f7f7f7","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],8:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525"],9:["#ffffff","#f0f0f0","#d9d9d9","#bdbdbd","#969696","#737373","#525252","#252525","#000000"]},CanvasXpress:{1:["#f2000d"],2:["#f2000d","#000df2"],3:["#f2000d","#000df2","#0df200"],4:["#f2000d","#000df2","#0df200","#f2f20d"],5:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2"],6:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2"],7:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2"],8:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3"],9:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe"],10:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b"],11:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016"],12:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d"],13:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00"],14:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808"],15:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808","#fed38b"],16:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808","#fed38b","#d38bfe"],17:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808","#fed38b","#d38bfe","#8bfed3"],18:["#f2000d","#000df2","#0df200","#f2f20d","#f20df2","#0df2f2","#f2f2f2","#fe8bd3","#8bd3fe","#d3fe8b","#5d0016","#00165d","#165d00","#080808","#fed38b","#d38bfe","#8bfed3","#404040"]},CanvasXpressT:{1:["rgba(242,0,13,0.5)"],2:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)"],3:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)"],4:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)"],5:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)"],6:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)"],7:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)"],8:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)"],9:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)"],10:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)"],11:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)"],12:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)"],13:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)"],14:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)"],15:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)","rgba(254,211,139,0.5)"],16:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)","rgba(254,211,139,0.5)","rgba(211,139,254,0.5)"],17:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)","rgba(254,211,139,0.5)","rgba(211,139,254,0.5)","rgba(139,254,211,0.5)"],18:["rgba(242,0,13,0.5)","rgba(0,13,242,0.5)","rgba(13,242,0,0.5)","rgba(242,242,13,0.5)","rgba(242,13,242,0.5)","rgba(13,242,242,0.5)","rgba(242,242,242,0.5)","rgba(254,139,211,0.5)","rgba(139,211,254,0.5)","rgba(211,254,139,0.5)","rgba(93,0,22,0.5)","rgba(0,22,93,0.5)","rgba(22,93,0,0.5)","rgba(8,8,8,0.5)","rgba(254,211,139,0.5)","rgba(211,139,254,0.5)","rgba(139,254,211,0.5)","rgba(64,64,64,0.5)"]}};CanvasXpress.ambiguityCodes={"-":["-"],A:["A"],C:["C"],G:["G"],T:["T"],M:["A","C"],R:["A","G"],W:["A","T"],S:["C","G"],Y:["C","T"],K:["G","T"],V:["A","C","G"],H:["A","C","T"],D:["A","G","T"],B:["C","G","T"],N:["A","C","G","T"],X:["A","C","G","T"]};CanvasXpress.codon={TTT:["F","Phe","Phenylalanine"],TCT:["S","Ser","Serine"],TAT:["Y","Tyr","Tyrosine"],TGT:["C","Cys","Cysteine"],TTC:["F","Phe","Phenylalanine"],TCC:["S","Ser","Serine"],TAC:["Y","Tyr","Tyrosine"],TGC:["C","Cys","Cysteine"],TTA:["L","Leu","Leucine"],TCA:["S","Ser","Serine"],TAA:["*","Stop","Ochre"],TGA:["*","Stop","Opal"],TTG:["L","Leu","Leucine"],TCG:["S","Ser","Serine"],TAG:["*","Stop","Amber"],TGG:["W","Trp","Tryptophan"],CTT:["L","Leu","Leucine"],CCT:["P","Pro","Proline"],CAT:["H","His","Histidine"],CGT:["R","Arg","Arginine"],CTC:["L","Leu","Leucine"],CCC:["P","Pro","Proline"],CAC:["H","His","Histidine"],CGC:["R","Arg","Arginine"],CTA:["L","Leu","Leucine"],CCA:["P","Pro","Proline"],CAA:["Q","Gln","Glutamine"],CGA:["R","Arg","Arginine"],CTG:["L","Leu","Leucine"],CCG:["P","Pro","Proline"],CAG:["Q","Gln","Glutamine"],CGG:["R","Arg","Arginine"],ATT:["I","Ile","Isoleucine"],ACT:["T","Thr","Threonine"],AAT:["N","Asn","Asparagine"],AGT:["S","Ser","Serine"],ATC:["I","Ile","Isoleucine"],ACC:["T","Thr","Threonine"],AAC:["N","Asn","Asparagine"],AGC:["S","Ser","Serine"],ATA:["I","Ile","Isoleucine"],ACA:["T","Thr","Threonine"],AAA:["K","Lys","Lysine"],AGA:["R","Arg","Arginine"],ATG:["M","Met","Methionine"],ACG:["T","Thr","Threonine"],AAG:["K","Lys","Lysine"],AGG:["R","Arg","Arginine"],GTT:["V","Val","Valine"],GCT:["A","Ala","Alanine"],GAT:["D","Asp","Aspartic acid"],GGT:["G","Gly","Glycine"],GTC:["V","Val","Valine"],GCC:["A","Ala","Alanine"],GAC:["D","Asp","Aspartic acid"],GGC:["G","Gly","Glycine"],GTA:["V","Val","Valine"],GCA:["A","Ala","Alanine"],GAA:["E","Glu","Glutamic acid"],GGA:["G","Gly","Glycine"],GTG:["V","Val","Valine"],GCG:["A","Ala","Alanine"],GAG:["E","Glu","Glutamic acid"],GGG:["G","Gly","Glycine"]};CanvasXpress.reverseComplement={A:"T",C:"G",G:"C",T:"A",U:"A",Y:"R",R:"Y",W:"W",S:"S",K:"M",M:"K",B:"V",V:"B",D:"H",H:"D",X:"X",N:"N",a:"t",c:"g",g:"c",t:"a",u:"a",y:"r",r:"y",w:"w",s:"s",k:"m",m:"k",b:"v",v:"b",d:"h",h:"d",x:"x",n:"n"," ":" ","-":"-","/":"/","[":"[","]":"]"};CanvasXpress.themes={economist:{backgroundType:"solid",backgroundWindow:"#D5E4EB",background:"#D5E4EB",colorScheme:"Economist",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#D5E4EB",legendColumns:4,legendInside:true,legendPosition:"top",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:2,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickColor:"#000000",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisTickStyle:"line",xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:false,yAxis2Show:true,yAxisTickStyle:"line",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},excel:{backgroundType:"window",backgroundWindow:"#C0C0C0",background:"#FFFFFF",colorScheme:"Excel",legendColor:"#000000",legendBox:true,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickColor:"#000000",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisTickStyle:"line",xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#000000",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},tableau:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#E5E5E5",colorScheme:"TableauMedium",legendColor:"#000000",legendBox:true,legendBoxColor:"#E5E5E5",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"#E5E5E5",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#E5E5E5",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000"},stata:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#EAF2F3",colorScheme:"Stata",legendColor:"#000000",legendBox:true,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:4,legendInside:false,legendPosition:"bottom",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:2,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickStyle:"line",xAxisTickColor:"#000000",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#EAF2F3",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},igray:{backgroundType:"window",backgroundWindow:"#FFFFFF",background:"#E5E5E5",colorScheme:"GGPlot",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:false,yAxisBottomMajorTick:false,yAxisTopBottomTickColor:"#000000",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000"},solarized:{backgroundType:"solid",backgroundWindow:"#FDF6E3",background:"#FDF6E3",colorScheme:"Solarized",legendColor:"#93A1A1",legendBox:true,legendBoxColor:"#93A1A1",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#93A1A1",axisTitleColor:"#93A1A1",axisTickThickness:1,axisMinMaxTickThickness:2,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#93A1A1",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#93A1A1",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#93A1A1",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#93A1A1",titleAlign:"left",titleColor:"#93A1A1",subtitleAlign:"left",subtitleColor:"#93A1A1"},paulTol:{backgroundType:"solid",backgroundWindow:"#FFFFFF",background:"#FFFFFF",colorScheme:"PaulTol",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#FFFFFF",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#E5E5E5",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#E5E5E5",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#E5E5E5",yAxisTopMajorTick:false,yAxisBottomMajorTick:false,yAxisTopBottomTickColor:"#E5E5E5",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000"},ggplot:{backgroundType:"window",backgroundWindow:"#E5E5E5",background:"#FFFFFF",colorScheme:"GGPlot",legendColor:"#000000",legendBox:true,legendBoxColor:"#FFFFFF",legendBackgroundColor:"#E5E5E5",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#FFFFFF",xAxisLeftMajorTick:true,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#FFFFFF",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#FFFFFF",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000"},wallStreetJournal:{backgroundType:"solid",backgroundWindow:"#F8F2E4",background:"#F8F2E4",colorScheme:"WallStreetJournal3",legendColor:"#000000",legendBox:false,legendBoxColor:"#000000",legendBackgroundColor:"#F8F2E4",legendColumns:4,legendInside:true,legendPosition:"top",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:2,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:false,xAxisTickStyle:"dotted",xAxisTickColor:"#000000",xAxisLeftMajorTick:false,xAxisRightMajorTick:false,xAxisLeftRightTickColor:"#000000",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"dotted",yAxisTickColor:"#000000",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#000000",titleAlign:"left",titleColor:"#000000",subtitleAlign:"left",subtitleColor:"#000000",conditional:{OneDPlots:{xAxisMajorTicks:true}}},cx:{backgroundType:"window",backgroundWindow:"#E8E8E8",background:"#FFFFFF",colorScheme:"CanvasXpressT",legendColor:"#000000",legendBox:true,legendBoxColor:"#FFFFFF",legendBackgroundColor:"#E8E8E8",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"#000000",axisTitleColor:"#000000",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:false,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"#FFFFFF",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"#337AB7",yAxisMajorTicks:true,yAxisMinorTicks:false,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"#FFFFFF",yAxisTopMajorTick:true,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"#337AB7",titleAlign:"center",titleColor:"#000000",subtitleAlign:"center",subtitleColor:"#000000"},none:{backgroundType:"solid",backgroundWindow:"rgb(244,244,244)",background:"rgb(255,255,255)",colorScheme:"User",legendColor:"rgb(0,0,0)",legendBox:true,legendBoxColor:"rgb(204,204,204)",legendBackgroundColor:"rgb(255,255,255)",legendColumns:1,legendInside:false,legendPosition:"right",legendScaleFontFactor:1,axisTickScaleFontFactor:1,axisTitleScaleFontFactor:1,axisTickColor:"rgb(0,0,0)",axisTitleColor:"rgb(0,0,0)",axisTickThickness:1,axisMinMaxTickThickness:1,xAxisMinorTicks:true,xAxisMajorTicks:true,xAxisTickStyle:"line",xAxisTickColor:"rgb(204,204,204)",xAxisLeftMajorTick:true,xAxisRightMajorTick:true,xAxisLeftRightTickColor:"rgb(204,204,204)",yAxisMajorTicks:true,yAxisMinorTicks:true,yAxisShow:true,yAxis2Show:false,yAxisTickStyle:"line",yAxisTickColor:"rgb(204,204,204)",yAxisTopMajorTick:false,yAxisBottomMajorTick:true,yAxisTopBottomTickColor:"rgb(204,204,204)",titleAlign:"center",titleColor:"rgb(0,0,0)",subtitleAlign:"center",subtitleColor:"rgb(0,0,0)"}};CanvasXpress.R={lty:[[0,0],[],[8,6],[1,3],[1,3,5,3],[14,6],[4,3,8,3]],ltyNames:["blank","solid","dashed","dotted","dotdash","longdash","twodash"]};CanvasXpress.prototype.initDOM=function(){this.$=function(a){return document.getElementById(a)};this.$cX=function(b,f,c){var d=document.createElement(b);if(f){for(var a in f){d[a]=f[a]}}if(c){for(var a in c){d.style[a]=c[a]}}return d};this.setPixelImage=function(){this.beaconImage=this.$cX("img",{id:this.target+"-cX-Beacon-Image",src:navigator.onLine&&this.protocol!="file"?"https://canvasxpress.org/cgi-bin/services.pl?beacon="+CanvasXpress.factory.client:CanvasXpress.images.canvasXpress})};this.createNewTarget=function(){var a=this.$cX("canvas",{id:this.newId("canvasXpress")});document.body.appendChild(a);return a.id};this.newId=function(b){var c=0;var a=this.target+b+c;while(this.meta.ids[a]){c++;a=this.target+b+c}this.meta.ids[a]=true;return a};this.insertTarget=function(e,g,d,f,b){if(e&&g){var i=this.$(e);if(i){return}else{i=this.$cX("canvas",{id:e,width:d,height:f})}if(b){g.parentNode.insertBefore(i,g.nextSibling)}else{g.parentNode.insertBefore(i,g)}}};this.removeTarget=function(a){var b=this.$(a);if(b){b.parentNode.removeChild(b)}};this.getWindowSize=function(){var a=window.innerWidth||document.documentElement.clientWidth||document.body.clientWidth;var b=window.innerHeight||document.documentElement.clientHeight||document.body.clientHeight;return[a,b]};this.getWindowScroll=function(){var c=document.documentElement;var a=(window.pageXOffset||c.scrollLeft)-(c.clientLeft||0);var b=(window.pageYOffset||c.scrollTop)-(c.clientTop||0);return[a,b]};this.hasClass=function(a,b){return new RegExp("(\\s|^)"+b+"(\\s|$)").test(a.className)};this.addClass=function(a,b){if(!this.hasClass(a,b)){a.className+=(a.className?" ":"")+b}};this.removeClass=function(a,b){if(this.hasClass(a,b)){a.className=a.className.replace(new RegExp("(\\s|^)"+b+"(\\s|$)")," ").replace(/^\s+|\s+$/g,"")}};this.getComputedCSS=function(c){var b="";var d=getComputedStyle(c);for(var a=0;a<d.length;a++){b+=d[a]+":"+d.getPropertyValue(d[a])+";"}return b};this.cancelEvent=function(a){if(!a){a=window.event}if(!a){return}if(CanvasXpress.system.browser.match(/safari/i)){return false}else{if(a.preventDefault){a.preventDefault()}else{a.returnValue=false}}};this.stopEvent=function(a){if(!a){a=window.event}if(!a){return}if(a.stopPropagation){a.stopPropagation()}else{a.cancelBubble=true}};this.normalizeEvtName=function(a){return CanvasXpress.system.isIE?"on"+a:a};this.copyEvent=function(c){var b={};for(var a in c){b[a]=c[a]}return b};this.addEvtListener=function(g,d,h,b){if(g&&d&&h){var a=this.meta.events;if(g.id){if(!a[g.id]){a[g.id]={}}a[g.id][d]=[h,b]}else{if(!a[g]){a[g]={}}a[g][d]=[h,b]}if(CanvasXpress.system.isIE){g.attachEvent(this.normalizeEvtName(d),h)}else{if(d=="touchstart"){g.addEventListener(d,h,b)}else{if(d=="mousewheel"){g.addEventListener(d,h,b);g.addEventListener("DOMMouseScroll",h,b)}else{g.addEventListener(d,h,b)}}}}};this.removeEvtListener=function(i,h,j,g){if(i&&h&&j){var a=this.meta.events;var d=a[i.id||i];if(d&&d.hasOwnProperty(h)){delete (d[h]);if(CanvasXpress.system.isIE){i.detachEvent(this.normalizeEvtName(h),j)}else{i.removeEventListener(h,j,g);if(h=="mousewheel"){i.removeEventListener("DOMMouseScroll",j,g)}}var b=this.getKeys(a[i.id||i]);if(b&&b.length<1){delete (a[i.id||i])}}}};this.addRemoveEvtListener=function(a,g,d,h,b){if(a&&g&&d&&h){this[a](g,d,h,b)}};this.purgeEventListeners=function(){var a=this.meta.events;for(var b in a){var d=this.$(b)||b;for(var c in a[b]){this.removeEvtListener(d,c,a[b][0],a[b][1])}}};this.preventSelection=function(){if(document.selection){document.selection.empty()}else{if(window.getSelection){window.getSelection().removeAllRanges()}}};this.getTargetEvent=function(b){var a=b.target||b.srcElement;if(typeof(a)!="object"){a=this.$(a)}return a};this.setTimeout=function(d,c){var a=this;var b=function(e){return new Promise(function(g,f){if(e){setTimeout(g,e)}else{setTimeout(g,1000)}})};b(c).then(function(){d.apply(a)})};this.setInterval=function(i,f){return setInterval(i,f);var e=Date.now;var a=window.requestAnimationFrame;var h=e();var b;var g=function(){e()-h<f||(h+=f,i());b||a(g)};a(g);return{clear:function(){b=1}}};if(!Array.from){Array.from=(function(){var d=Object.prototype.toString;var e=function(g){return typeof g==="function"||d.call(g)==="[object Function]"};var c=function(h){var g=Number(h);if(isNaN(g)){return 0}if(g===0||!isFinite(g)){return g}return(g>0?1:-1)*Math.floor(Math.abs(g))};var b=Math.pow(2,53)-1;var a=function(h){var g=c(h);return Math.min(Math.max(g,0),b)};return function f(p){var g=this;var o=Object(p);if(p==null){throw new TypeError("Array.from requires an array-like object - not null or undefined")}var m=arguments.length>1?arguments[1]:void undefined;var i;if(typeof m!=="undefined"){if(!e(m)){throw new TypeError("Array.from: when provided, the second argument must be a function")}if(arguments.length>2){i=arguments[2]}}var n=a(o.length);var h=e(g)?Object(new g(n)):new Array(n);var j=0;var l;while(j<n){l=o[j];if(m){h[j]=typeof i==="undefined"?m(l,j):m.call(i,l,j)}else{h[j]=l}j+=1}h.length=n;return h}}())}this.initializeBrowser=function(){var b=function(){var e=navigator.userAgent;var d;var c=e.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(c[1])){d=/\brv[ :]+(\d+)/g.exec(e)||[];return"IE "+(d[1]||"")}if(c[1]==="Chrome"){d=e.match(/\b(OPR|Edge)\/(\d+)/);if(d!=null){return d.slice(1).join(" ").replace("OPR","Opera")}}c=c[2]?[c[1],c[2]]:[navigator.appName,navigator.appVersion,"-?"];if((d=e.match(/version\/(\d+)/i))!=null){c.splice(1,1,d[1])}return c.join(" ")};var a=b().split(" ");CanvasXpress.system={browser:a[0],browserVersion:a[1],isjQuery:typeof $==="function"?true:false,isIE:this.browser=="IE"?true:false,isTouchScreen:"ontouchstart" in window||"onmsgesturechange" in window||navigator.maxTouchPoints}};this.initializeBrowser()};CanvasXpress.prototype.initInterface=function(){this.isValidURL=function(b){var a=new RegExp("^(https?:\\/\\/)?((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.?)+[a-z]{2,}|((\\d{1,3}\\.){3}\\d{1,3}))(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*(\\?[;,\\s\\(\\)\\[\\]&a-z\\d%_.~+=-]*)?(\\#[-a-z\\d_]*)?$","i");return a.test(b)};this.loadParamsFile=function(a){return function(h){a.removeMenus();a.resetConfigurator();var d=h.target.files[0];var g=d.type;var c=d.name.split(".");var b=new FileReader();var f=c.pop();if(f=="json"){b.onload=function(){try{var m=JSON.parse(b.result);a.setConfigDefaults();a.layoutValid=false;for(var o in m.config){a[o]=m.config[o]}for(var k=0;k<m.afterRender.length;k++){var j=m.afterRender[k];var l=j[0];var q=j[1]||[];a[l].apply(a,q)}}catch(n){alert("Oooops! Not a CanvasXpress json parameter file")}};b.readAsText(d)}else{alert("Oooops! Not a CanvasXpress json  parameter file")}}}(this);this.parseDataFromPNG=function(c){var e=function(o,m){var p="";for(var n=0;n<4;n++){p+=String.fromCharCode(o.getUint8(m+n))}return p=="tEXt"};var d=function(p,n,m){var q="";for(var o=0;o<m;o++){q+=String.fromCharCode(p.getUint8(n+o))}return q.match(/CanvasXpress/)};var b=function(p,n,m){var q="";for(var o=0;o<m;o++){console.log(n+o+" = "+p.getUint8(n+o)+":"+String.fromCharCode(p.getUint8(n+o)))}return q};var a=new DataView(c);var g=a.getUint32(8);var j=a.getUint32(8+4+4+g+4);if(e(a,8+4+4+g+4+4)&&d(a,8+4+4+g+4+4+4,j)){var l=a.getUint32(8+4+4+g+4+4+4+j+4);var h=8+4+4+g+4+4+4+j+4+4+4;var k="";for(var f=0;f<l;f++){k+=String.fromCharCode(a.getUint8(h+f))}k=k.replace("ReproducibleResearch\0","");return JSON.parse(k)}else{alert("Oooops! Not a CanvasXpress Image")}};this.loadFile=function(a){return function(l,c,n,k){a.removeMenus();a.resetConfigurator();a.showMask();var h=k?k:l.target?l.target.files[0]:l.files[0];var m=h.type;var d=h.name.split(".");var j=new FileReader();if(m=="image/png"){var i=function(o,e){var p="";for(var f=0;f<4;f++){p+=String.fromCharCode(o.getUint8(e+f))}return p=="tEXt"};var g=function(p,f,e){var q="";for(var o=0;o<e;o++){q+=String.fromCharCode(p.getUint8(f+o))}return q.match(/CanvasXpress/)};j.onload=function(){var r=new DataView(this.result);var f=r.getUint32(8);var e=r.getUint32(8+4+4+f+4);if(i(r,8+4+4+f+4+4)&&g(r,8+4+4+f+4+4+4,e)){var q=r.getUint32(8+4+4+f+4+4+4+e+4);var s=8+4+4+f+4+4+4+e+4+4+4;var p="";for(var o=0;o<q;o++){p+=String.fromCharCode(r.getUint8(s+o))}p=p.replace("ReproducibleResearch\0","");var t=JSON.parse(p);if(c){return t}t.uploadFile=true;a.remoteServiceType="file";a.updateRemoteData(t,n);a.hideMask()}else{a.hideMask();alert("Oooops! Not a CanvasXpress Image")}};j.readAsArrayBuffer(h)}else{var b=d.pop();if(b=="json"){j.onload=function(){try{var f=JSON.parse(j.result);f.uploadFile=true;a.remoteServiceType="file";a.updateRemoteData(f,n);a.hideMask()}catch(o){a.hideMask();alert("Oooops! Not a CanvasXpress json file")}}}else{if(b=="svg"){j.onload=function(){try{var f=a.SVGtoCX(j.result);f.uploadFile=true;a.remoteServiceType="file";a.updateRemoteData(f,n);a.hideMask()}catch(o){a.hideMask();alert("Oooops! Not a CanvasXpress json file")}}}else{if(b=="txt"||b=="csv"||b=="tsv"||b=="tab"){j.onload=function(){try{var t=j.result;var f=0;var q=0;if(t.match(/,/g)){f=t.match(/,/g).length}if(t.match(/\t/g)){q=t.match(/\t/g).length}var p=b=="csv"&&f>q?",":"\t";var r;if(a.graphType=="Network"){r=a.delimitedToArray(t,p,false,true);if(r&&!a.isArray(r)){var o="";if(r.fail>0){o=r.fail+" records couldn't be mapped to network data"}alert(r.rows+" "+r.type+" records added to network data\n"+o);if(r.type=="node"){a.appendNodeData(r.data)}else{a.appendEdgeData(r.data)}a.hideMask();return}else{r=a.delimitedToCanvasXpress(r)}}else{r=a.delimitedToArray(t,p,true)}r.renderTo=d[0];r.uploadFile=true;a.remoteServiceType="file";a.updateRemoteData(r,n);a.hideMask()}catch(s){a.hideMask();alert("Oooops! Not a CanvasXpress delimited file")}}}else{if(b=="gml"){j.onload=function(){try{var f=a.parseGML(j.result);f.renderTo=d[0];f.uploadFile=true;a.remoteServiceType="file";a.updateRemoteData(f,n);a.hideMask()}catch(o){a.hideMask();alert("Oooops! Not a gml file for CanvasXpress")}}}else{if(b=="gpml"){j.onload=function(){try{var f=a.parseXML(j.result);var o=a.gpmlToCX(f);o.renderTo=d[0];o.uploadFile=true;a.remoteServiceType="file";a.updateRemoteData(o,n);a.hideMask()}catch(p){a.hideMask();alert("Oooops! Not a "+b+" file for CanvasXpress")}}}else{if(b=="xml"){j.onload=function(){try{var f=a.parseXML(j.result);a.kgmlToCX(f,d[0])}catch(o){a.hideMask();alert("Oooops! Not a "+b+" file for CanvasXpress")}}}}}}}}j.readAsText(h)}}}(this);this.save=function(a){return function(g,d){var c=function(f,e){if(f=="state"||f=="stateIndex"){return undefined}return e};a.removeMenus();a.resetConfigurator();CanvasXpress.stack[a.target].client=CanvasXpress.factory.client;CanvasXpress.stack[a.target].clientIP=CanvasXpress.geo;var h=d?d+".json":"cX-"+a.target+".json";h=h.replace(/.json.json$/,".json");var b=new Blob([a.prettyJSON(CanvasXpress.stack[a.target],c)],{type:"text/plain;charset="+document.characterSet});saveAs(b,h)}}(this);this.saveSVG=function(a){return function(h,g){a.removeMenus();a.resetConfigurator();CanvasXpress.stack[a.target].client=CanvasXpress.factory.client;CanvasXpress.stack[a.target].clientIP=CanvasXpress.geo;a.isSVG=true;var d=a.showTransition;a.showTransition=false;a.meta.canvas.ctx5=new C2S({width:a.width,height:a.height,desc:a.isReproducibleResearch?JSON.stringify(CanvasXpress.stack[a.target]):""});a.renderGraph(true);var c=a.meta.canvas.ctx5.getSerializedSvg();if(a.isReproducibleResearch){a.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}var i=g?g+".svg":"cX-"+a.target+".svg";i=i.replace(/.svg.svg$/,".svg");var b=new Blob([c],{type:"image/svg+xml;charset="+document.characterSet});saveAs(b,i);a.showTransition=d;delete (a.meta.canvas.ctx5);a.isSVG=false}}(this);this.parseXML=function(a){var c=null;if(window.DOMParser){try{c=(new DOMParser()).parseFromString(a,"text/xml")}catch(b){c=null}}else{if(window.ActiveXObject){try{c=new ActiveXObject("Microsoft.XMLDOM");c.async=false;if(!c.loadXML(a)){window.alert(c.parseError.reason+c.parseError.srcText)}}catch(b){c=null}}else{alert("cannot parse xml string!")}}return c};this.SVGtoCX=function(b){var d=this.parseXML(b);var a=d.childNodes[0];if(a.tagName.match(/svg/i)){var c=a.getAttribute("desc");if(c){return JSON.parse(c)}}};this.print=function(a){return function(u,t){var i=a.width;var j=a.height;var s=a.printMagnification;var k=a.autoScaleFont;var m=a.showTransition;var p=a.skipStack;var q=["outlineWidth","lineThickness","axisTickThickness","axisMinMaxTickThickness","guidesWidth","boxplotMedianWidth","boxplotConnectWidth","treeLinkWidth","connectByWidth","histogramBarWidth","heatmapCellBoxWidth","heatmapCellBoxHighlightWidth","edgeThickness","maxTextSize"];var n=function(f){if(f){for(var e=0;e<q.length;e++){a[q[e]]/=s}a.autoScaleFont=k;a.showTransition=m;a.setDimensions(i,j,true);a.skipStack=p}else{a.skipStack=true;a.showTransition=false;for(var e=0;e<q.length;e++){a[q[e]]*=s}a.autoScaleFont=true;a.setDimensions(i*s,j*s,true)}};var c=function(){var w;var e=[];for(var v=0;v<256;v++){w=v;for(var f=0;f<8;f++){w=((w&1)?(3988292384^(w>>>1)):(w>>>1))}e[v]=w}return e};var d=function(w){var e=window.crcTable||(window.crcTable=c());var v=0^(-1);for(var f=0;f<w.length;f++){v=(v>>>8)^e[(v^w.charCodeAt(f))&255]}return(v^(-1))>>>0};var h=function(f,e){var v=new Uint8Array(f.byteLength+e.byteLength);v.set(new Uint8Array(f),0);v.set(new Uint8Array(e),f.byteLength);return v.buffer};var l=function(v){var z="tEXt";var f=v.length;var y=d(z+v);var e=new ArrayBuffer(12+f);var x=new DataView(e);x.setUint32(0,f);for(var w=0;w<z.length;w++){x.setUint8(4+w,z.charCodeAt(w))}for(var w=0;w<v.length;w++){x.setUint8(8+w,v.charCodeAt(w))}x.setUint32(4+4+f,y);return e};var g=function(){if(a.isReproducibleResearch){if(a.printManification!=1){delete (CanvasXpress.stack[a.target].config.showTransition)}return JSON.stringify(CanvasXpress.stack[a.target])}else{var e=JSON.parse(JSON.stringify(CanvasXpress.stack[a.target]));e.afterRender=[e.afterRender[0]];return JSON.stringify(e)}};var b=function(x,w,e,f){var v=h(x,w);v=h(v,e);v=h(v,f);return v};var r=function(e){var v=new FileReader();var f="";if(a.isReproducibleResearch){f+="<h2>Please be aware that the actual data is stored inside the image! Right click to save!</h2>"}else{f+="<h2>Right click to save image</h2>"}v.onload=function(w){f+="<img width="+a.width+" height="+a.height+" src= '"+w.target.result+"'/>";a.showTooltipDiv(u,f,a.getTargetEvent(u),{maxWidth:a.width+"px",whiteSpace:"normal"},40,40)};v.readAsDataURL(e)};n();a.removeMenus();a.resetConfigurator();CanvasXpress.stack[a.target].client=CanvasXpress.factory.client;CanvasXpress.stack[a.target].clientIP=CanvasXpress.geo;var o=a.isMap?a.getLeafletCanvas():a.meta.canvas.ctx.canvas;o.toBlob(function(f){var e=new FileReader();var v=t?t+".png":"cX-"+a.target+".png";v=v.replace(/.png.png$/,".png");e.onloadend=function(){var w=new DataView(this.result);var y=w.getUint32(8);var z=8+4+4+y+4;var A=this.result.slice(0,z);var B=this.result.slice(z);var E=l("Software\0CanvasXpress Version: "+CanvasXpress.factory.version);var C=l("ReproducibleResearch\0"+g());var D=b(A,E,C,B);var x=new Blob([D],{type:"image/png"});if(a.printType=="download"){if(a.isReproducibleResearch){a.flashInfoSpan(100,100,"<h2>Please be aware <br>the actual data is stored<br>inside the downloaded image</h2>",5000)}saveAs(x,v)}else{r(x)}n(true)};e.readAsArrayBuffer(f)},"image/png");if(a.maximized){a.clickGraphMaxMin(u)}}}(this);this.exportToSVG=function(a){return function(){var b=a.meta.canvas.ctx;a.meta.canvas.ctx=new C2S({width:a.width,height:a.height});a.draw();var c=a.prettyXML(a.meta.canvas.ctx.getSerializedSvg());var d=window.open("",a.target+"-SVG");d.document.write(c);a.meta.canvas.ctx=b;a.draw();return false}}(this);this.exportToExcel=function(i){return this.exportToTabDelimited(i);var g=this.exportToHTML(i,true);var f="data:application/vnd.ms-excel;base64,";var c='<html xmlns:o="urn:schemas-microsoft-com:office:office" xmlns:x="urn:schemas-microsoft-com:office:excel" xmlns="https://www.w3.org/TR/REC-html40"><head><!--[if gte mso 9]><xml><x:ExcelWorkbook><x:ExcelWorksheets><x:ExcelWorksheet><x:Name>{worksheet}</x:Name><x:WorksheetOptions><x:DisplayGridlines/></x:WorksheetOptions></x:ExcelWorksheet></x:ExcelWorksheets></x:ExcelWorkbook></xml><![endif]--></head><body><table>{table}</table></body></html>';var b=function(d){return window.btoa(unescape(encodeURIComponent(d)))};var h=function(d,j){return d.replace(/{(\w+)}/g,function(k,l){return j[l]})};var a={worksheet:"Worksheet",table:g};var e=this.$(this.target+"-cX-linkExcel");if(!e){e=this.$cX("a",{id:this.target+"-cX-linkExcel"},{display:"none"});document.body.appendChild(e)}e.href=f+b(h(c,a));e.download=this.target+".xls";e.click()};this.exportToHTML=function(e,b){var c="<table>";for(var a=0;a<e.length;a++){c+="<tr><td>";c+=e[a].join("</td><td>");c+="</td></tr>"}c+="</table>";return b?c:window.open().document.write(c)};this.exportToTabDelimited=function(e){var c="";for(var a=0;a<e.length;a++){c+=e[a].join("\t")+"\n"}var b=this.$(this.target+"-cX-linkTab");if(!b){b=this.$cX("a",{id:this.target+"-cX-linkTab"},{display:"none"});document.body.appendChild(b)}b.download=this.target+".tsv";b.href="data:text/tab-separated-values;charset=UTF-8,"+encodeURIComponent(c);b.click()};this.arrayToHTML=function(e){var c="";c+='<div class="CanvasXpressDataTableContainer" style="overflow:scroll;max-height:400px;max-width:600px;position:inherit;padding-left:18px;">';c+='<table class="CanvasXpressDataTable" style="position:inherit;">';c+="<tbody>";c+="<tr>";for(var b=0;b<e[0][0].length;b++){c+='<th class="CanvasXpressTableCellHead" style="height:18px">';c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][0][b];c+="</div>";c+="</th>"}c+="</tr>";for(var b=1;b<e[0].length;b++){c+="<tr>";for(var a=0;a<e[0][b].length;a++){if(a==0){c+='<th class="CanvasXpressTableCellHead" style="height:18px">';c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][b][a];c+="</div>";c+="</th>"}else{c+='<td class="CanvasXpressTableCell" style="height:18px">';c+='<div class="CanvasXpressTableCell" style="height:18px">';c+=e[0][b][a];c+="</div>";c+="</td>"}}c+="</tr>"}c+="</tbody>";c+="</table>";c+="</div>";return c};this.prettyJSON=function(b,a){return JSON.stringify(b,a?a:null,2)};this.prettyXML=function(n){var f=/(>)\s*(<)(\/*)/g;var t=/ *(.*) +\n/g;var e=/(<.+>)(.+\n)/g;var d=n.replace(f,"$1\n$2$3").replace(t,"$1\n").replace(e,"$1\n$2");var r=0;var b="";var a=d.split("\n");var k=0;var q="other";var v={"single->single":0,"single->closing":-1,"single->opening":0,"single->other":0,"closing->single":0,"closing->closing":-1,"closing->opening":0,"closing->other":0,"opening->single":1,"opening->closing":0,"opening->opening":1,"opening->other":1,"other->single":0,"other->closing":-1,"other->opening":0,"other->other":0};for(var p=0;p<a.length;p++){var h=a[p];var u=Boolean(h.match(/<.+\/>/));var g=Boolean(h.match(/<\/.+>/));var m=Boolean(h.match(/<[^!].*>/));var c=u?"single":g?"closing":m?"opening":"other";var s=q+"->"+c;q=c;var l="";k+=v[s];for(var o=0;o<k;o++){l+="  "}b+=l+h+"\n"}return b};this.delimitedToArrayOrig=function(h,g,b){g=g||",";var e=new RegExp(("(\\"+g+'|\\r?\\n|\\r|^)(?:"([^"]*(?:""[^"]*)*)"|([^"\\'+g+"\\r\\n]*))"),"gi");var a=[[]];var f=null;while(f=e.exec(h)){var c=f[1];if(c.length&&c!==g){a.push([])}var d;if(f[2]){d=f[2].replace(new RegExp('""',"g"),'"')}else{d=f[3]}a[a.length-1].push(this.isNumber(d)?Number(d):d!=this.missingDataValue?d:null)}return b?this.delimitedToCanvasXpress(a):a};this.delimitedToArray=function(k,b,d,l){var a=/\r\n|\r|\n/g;var c=k.split(a);for(var g=0;g<c.length;g++){if(c[g].match(/^#/)){c.splice(g,1);g--;continue}var h=c[g].split(b);for(var m=h.length-1;m>=0;m--){if(h[m].replace(/"\s+$/,'"').charAt(h[m].length-1)=='"'){var n=h[m].replace(/^\s+"/,'"');if(n.length>1&&n.charAt(0)=='"'){h[m]=h[m].replace(/^\s*"|"\s*$/g,"").replace(/""/g,'"')}else{if(m){h.splice(m-1,2,[h[m-1],h[m]].join(b))}else{h=h.shift().split(b).concat(h)}}}else{h[m].replace(/""/g,'"')}}for(var e=0;e<h.length;e++){if(this.isNumber(h[e])){h[e]=Number(h[e])}else{if(h[e]==this.missingDataValue){h[e]=null}}}if(h.length==1&&h[0]==""){c.splice(g,1);g--;continue}c[g]=h}return d?this.delimitedToCanvasXpress(c):l?this.isNetworkFile(c):c};this.isNetworkFile=function(k){var g={};var o=k[0];var a=0;var f=0;var d=0;var l=false;for(var h=1;h<k.length;h++){var b=k[h][0];var c=k[h][1];if(this.data.nodeIndices.hasOwnProperty(b)&&this.data.nodeIndices.hasOwnProperty(c)){f++}else{if(this.data.nodeIndices.hasOwnProperty(b)){a++}else{d++}}}if(f>a){a=0;f=0;d=0;l="edge";for(var h=1;h<k.length;h++){var b=k[h][0];var c=k[h][1];if(this.data.nodeIndices.hasOwnProperty(b)&&this.data.nodeIndices.hasOwnProperty(c)){f++;g[b+":"+c]={};for(var e=2;e<o.length;e++){g[b+":"+c][o[e]]=k[h][e]}}else{d++}}}else{if(a>d){a=0;f=0;d=0;l="node";for(var h=1;h<k.length;h++){var b=k[h][0];if(this.data.nodeIndices.hasOwnProperty(b)){a++;g[b]={};for(var e=1;e<o.length;e++){g[b][o[e]]=k[h][e]}}else{d++}}}else{return k}}if((l=="edge"&&(f>5||f>=k.length-1))||(l=="node"&&(a>5||a>=k.length-1))){return{data:g,rows:Math.max(a,f),fail:d,type:l}}else{return k}};this.kgmlToCX=function(e,F){var j=this;var s=e.childNodes[2];var v=[];var c=[];var G,t,g,u,q;var d=function(I,M,h,L){var x={};var J=new RegExp(/(?!xmlns)^.*:/);var w=new RegExp(/^\s+|\s+$/g);if(!M){M={}}if(h&&!M[h]){M[h]=[]}if(I.attributes&&I.attributes.length>0){for(var y=0;y<I.attributes.length;y++){var K=I.attributes.item(y);var r=K.name.replace(J,"").toLowerCase();if(h){x[r]=K.value.replace(w,"")}else{M[r]=K.value.replace(w,"")}}if(h){M[h].push(x)}}if(I.hasChildNodes()&&!L){for(var y=0;y<I.childNodes.length;y++){var r=I.childNodes.item(y);var h;if(r.nodeType==4){}else{if(r.nodeType==3){}else{if(r.nodeType==1){h=r.nodeName.replace(J,"").toLowerCase();d(r,M,h)}}}}}return M};var E=function(){v.push({id:"__zero__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:0,y:0,hideLabel:true},{id:"__max__",type:"anchor",shape:"circle",color:"rgba(0,0,0,0)",outline:"rgb(0,0,0)",width:1,height:1,x:u,y:q,hideLabel:true})};if(s.tagName.toLowerCase()=="pathway"){var A=d(s,false,false,true);G=A.title;t=A.image;g=A.link;var H=new Image();H.onload=function(){u=this.width;q=this.height;var h="Number of Nodes: "+v.length+"\n";h+="Number of Edges: "+c.length+"\n";E();j.remoteServiceType="file";alert(h);j.updateRemoteData({data:{nodes:v,edges:c},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:true,preScaleNetwork:false,title:G,backgroundType:"image",backgroundImage:t},renderTo:F,uploadFile:true});j.hideMask()};H.src=A.image;for(var C=0;C<s.childNodes.length;C++){var a=s.childNodes[C];if(a.nodeName){var b=a.nodeName.toLowerCase();switch(b){case"entry":var A=d(a);if(A.graphics[0].type=="roundrectangle"){A.graphics[0].type="roundrect";A.graphics[0].fgcolor="rgba(0,0,0,0)"}if(A.graphics&&A.graphics.length==1&&A.graphics[0].type!="line"){var f=A.type=="group"?5:0;var z={id:A.id,type:A.type,link:A.link,name:A.graphics[0].name,shape:A.graphics[0].type,color:"rgba(0,0,0,0)",outline:j.validateColor(A.graphics[0].fgcolor)||"rgb(0,0,0)",width:parseInt(A.graphics[0].width)+f,height:parseInt(A.graphics[0].height)+f,x:parseInt(A.graphics[0].x),y:parseInt(A.graphics[0].y),hideLabel:true,fixed:true};if(A.type=="group"){v.unshift(z)}else{v.push(z)}}else{if(A.graphics&&A.graphics.length==1&&A.graphics[0].type=="line"){var B=A.graphics[0].coords.split(",");if(B.length==4){var l=[];var k=[];var m,D,p;while(B.length>1){l.push(parseInt(B.shift()));k.push(parseInt(B.shift()))}var o=parseInt(this.mean(l));var n=parseInt(this.mean(k));if(l[0]==l[1]){o+=1;m=2;D=k[1]-k[0];p=0}else{if(k[0]==k[1]){n+=1;m=l[1]-l[0];D=2;p=0}else{D=this.lineLength(l[0],k[0],l[1],k[1]);m=2;p=this.getAngle(l[0],k[0],l[1],k[1])}}var z={id:A.id,type:A.type,link:A.link,name:A.graphics[0].name,shape:"rect",color:"rgba(0,0,0,0)",outline:"rgba(0,0,0,0)",x:o,y:n,width:m,height:D,rotate:p,hideLabel:true,fixed:true};v.push(z)}}}break;case"relation":case"reaction":break}}}}else{alert("Ooops! Not a kgml file!")}};this.gpmlToCX=function(u){var h=u.childNodes[0];var D={};var r=[];var aa={};var k={};var t={};var C={};var M=1;var R=0;var e=[];var d={};var E={};var U={};var K="\nWarnings:\n";var P=false;var z,w;var O={Line:false,Arrow:"arrow",TBar:"square","mim-necessary-stimulation":false,"mim-binding":false,"mim-conversion":"arrow","mim-stimulation":false,"mim-catalysis":"round","mim-modification":false,"mim-inhibition":"square","mim-covalent-bond":false,"mim-transcription-translation":false};var b=function(ai,j){var ab=Number.MAX_VALUE;var s=Number.MAX_VALUE;var ag=-Number.MAX_VALUE;var af=-Number.MAX_VALUE;var c=[];var p=[];var ae=false;for(var ac=0;ac<ai.length;ac++){ab=Math.min(ab,ai[ac][1]-(ai[ac][3]/2));s=Math.min(s,ai[ac][2]-(ai[ac][4]/2));ag=Math.max(ag,ai[ac][1]+(ai[ac][3]/2));af=Math.max(af,ai[ac][2]+(ai[ac][4]/2));c.push(ai[ac][0]);D[ai[ac][0]].parentNode=j;p.push(D[ai[ac][0]].zorder);if(D[ai[ac][0]].nodeName!="label"){ae=true}p.sort(function(aj,i){return aj-i})}var ah=ag-ab;var ad=af-s;var g={id:j,x:(ab+ag)/2,y:(s+af)/2,width:ah+(ai.length>1&&ah>10?5:0),height:ad+(ai.length>1&&ad>10?5:0),group:c,hideLabel:true,hideTooltip:P,type:"Group",color:(ae?"rgba(245,245,245,0.5)":"rgba(0,0,0,0)"),outline:(ae?"rgb(0,0,0)":"rgba(0,0,0,0)"),shape:"rectangle",zorder:p[0]};C[j]=R--;D[j]=g;e.push(j)};var q=function(g,i){var c={id:i,x:Math.round(g.x*10)/10,y:Math.round(g.y*10)/10,width:g.width?Math.round(g.width):1,height:g.height?Math.round(g.height):1,hideLabel:g.show?false:true,hideTooltip:!P?false:g.show?false:true,eventless:g.show?false:true,type:g.type||"Anchor",color:g.color||"rgba(0,0,0,0)",outline:g.outline||"rgba(0,0,0,0)",shape:g.shape||"circle",label:g.label||"",labelSize:g.labelSize||0.5,zorder:g.zorder||0};C[i]=M++;D[i]=c;e.push(i)};var o=function(c){switch(c){case"r":case"l":return"rl";case"b":case"t":case"c":return"tb"}};var J=function(c){if(parseInt(c.relx)==1){return"r"}else{if(parseInt(c.relx)==-1){return"l"}else{if(parseInt(c.rely)==1){return"b"}else{if(parseInt(c.rely)==-1){return"t"}else{if(Math.abs(c.relx)>Math.abs(c.rely)){if(parseFloat(c.relx)>0){return"r"}else{return"l"}}else{if(parseFloat(c.rely)>0){return"b"}else{if(parseFloat(c.rely)<0){return"t"}else{return"c"}}}}}}}};var f=function(p,j){var c=function(ac,ad,s){switch(ac){case"r":if(parseFloat(ad.x)>=parseFloat(s.x)){return 2}break;case"l":if(parseFloat(ad.x)<=parseFloat(s.x)){return 2}break;case"t":case"c":if(parseFloat(ad.y)<=parseFloat(s.y)){return 2}break;case"b":if(parseFloat(ad.y)>=parseFloat(s.y)){return 2}break}return 0};var i=J(p);var ab=J(j);var g=2;if(o(i)==o(ab)){g++}if(i!=ab){g+=c(i,p,j);g+=c(ab,j,p)}return g};var x=function(g,c,i){if(i){switch(g){case"r":return[c[0]+20,c[1]];case"l":return[c[0]-20,c[1]];case"t":case"c":return[c[0],c[1]-20];case"b":return[c[0],c[1]+20]}}else{switch(g){case"r":case"l":return[c[0][0],c[1][1]];case"t":case"b":case"c":return[c[1][0],c[0][1]]}}};var H=function(ab,j){var s=[j[0]];var g=j[0];for(var p=1;p<j.length;p++){var ac=j[p];switch(ab){case"rl":s.push([ac[0],g[1]]);break;case"tb":s.push([g[0],ac[1]]);break}g=s[p];ab=ab=="rl"?"tb":"rl"}s.push(j[j.length-1]);return s};var l=function(c){var p=c.point;var g=[];for(var j=0;j<p.length;j++){g.push([Math.round(p[j].x*10)/10,Math.round(p[j].y*10)/10])}return g};var V=function(ae){var c=ae.point;var ac=c.length-1;var ab=f(c[0],c[ac]);var ai=J(c[0]);var ah=J(c[ac]);var ad=o(ai);var ag=l(ae);if(ab==c.length){ag=H(ad,ag)}else{if(c.length==2){ag.splice(1,0,x(ai,ag[0],true));if(ab>3){if(ab>3){ag.splice(2,0,x(ah,ag[2],true))}if(ab>4){if(ab>4){ag.splice(3,0,[(ag[1][0]+ag[2][0])/2,(ag[1][1]+ag[2][1])/2])}if(ab>5){ag=l(ae);ag=H(ad,ag)}}else{ag.splice(2,0,x(ai,[ag[1],ag[2]]))}}else{if((ag[0][0]==ag[1][0]&&ag[1][0]==ag[2][0])||(ag[0][1]==ag[1][1]&&ag[1][1]==ag[2][1])){ag.splice(1,1)}else{ag.splice(2,0,x(ai,[ag[1],ag[2]]))}}}else{if(c.length>ab){ag=H(ad,ag)}else{for(var p=0;p<ac;p++){var g=p*2;if(ad=="tb"){ad="rl";ag.splice(g+1,0,[ag[g][0],ag[g+1][1]])}else{ad="tb";ag.splice(g+1,0,[ag[g+1][0],ag[g][1]])}}}}}var af=[[ag[0][0],ag[0][1]]];for(var p=1;p<ag.length;p++){if(ag[p][0]==ag[p-1][0]&&ag[p][1]==ag[p-1][1]){continue}af.push([ag[p][0],ag[p][1]])}return af};getBezierPoints=function(ae){var c=ae.point;var ad=c.length-1;var ak=J(c[0]);var aj=J(c[ad]);var p=o(ak);var j=o(aj);var ab=l(ae);var g=[];var ai,ah,ag,af;if(ad==1){ai=ab[0];ah=ab[1];if(p==j){ag=(ai[0]+ah[0])/2;af=(ai[1]+ah[1])/2;if(p=="tb"){g.push([ai[0],ai[1],ai[0],af,ag,af]);g.push([ag,af,ah[0],af,ah[0],ah[1]])}else{g.push([ai[0],ai[1],ag,ai[1],ag,af]);g.push([ag,af,ag,ah[1],ah[0],ah[1]])}}else{if(ak=="t"||ak=="b"){g.push([ai[0],ai[1],ai[0],ah[1],ah[0],ah[1]])}else{g.push([ai[0],ai[1],ah[0],ai[1],ah[0],ah[1]])}}}else{ai=ab[0];if(ak=="t"||ak=="b"){for(var ac=1;ac<ad;ac++){ah=ab[ac];if(ac%2){g.push([ai[0],ai[1],ai[0],ah[1],ah[0],ah[1]])}else{g.push([ai[0],ai[1],ah[0],ai[1],ah[0],ah[1]])}ai=ah}ah=ab[ad];if(ad%2){g.push([ai[0],ai[1],ai[0],ah[1],ah[0],ah[1]])}else{g.push([ai[0],ai[1],ah[0],ai[1],ah[0],ah[1]])}}else{for(var ac=1;ac<ad;ac++){ah=ab[ac];if(ac%2){g.push([ai[0],ai[1],ah[0],ai[1],ah[0],ah[1]])}else{g.push([ai[0],ai[1],ai[0],ah[1],ah[0],ah[1]])}ai=ah}ah=ab[ad];if(ad%2){g.push([ai[0],ai[1],ah[0],ai[1],ah[0],ah[1]])}else{g.push([ai[0],ai[1],ai[0],ah[1],ah[0],ah[1]])}}}return g};getStatePosition=function(ab,j){var c=parseFloat(j.relx);var p=parseFloat(j.rely);var g=ab.width/2;var i=ab.height/2;return[ab.x+(c*g),ab.y+(p*i)]};var L=function(ad,ah,c,ag){var ab={};var ae=new RegExp(/(?!xmlns)^.*:/);var s=new RegExp(/^\s+|\s+$/g);if(!ah){ah={}}if(c&&(c=="point"||c=="anchor")&&!ah[c]){ah[c]=[]}if(ad.attributes&&ad.attributes.length>0){for(var ac=0;ac<ad.attributes.length;ac++){var af=ad.attributes.item(ac);var g=af.name.replace(ae,"").toLowerCase();if(c&&(c=="point"||c=="anchor")){ab[g]=af.value.replace(s,"")}else{ah[g]=af.value.replace(s,"")}}if(c&&(c=="point"||c=="anchor")){ah[c].push(ab)}}if(ad.hasChildNodes()&&!ag){for(var ac=0;ac<ad.childNodes.length;ac++){var g=ad.childNodes.item(ac);var c;if(g.nodeType==4){}else{if(g.nodeType==3){}else{if(g.nodeType==1){c=g.nodeName.replace(ae,"").toLowerCase();L(g,ah,c)}}}}}return ah};if(h.tagName.toLowerCase()=="pathway"){var F=L(h,false,false,true);z=F.name;w=F.organism;for(var Q=0;Q<h.childNodes.length;Q++){var S=h.childNodes[Q];if(S.nodeName){var W=S.nodeName.toLowerCase();switch(W){case"comment":break;case"graphics":break;case"state":var F=L(S);F.nodeName=W;aa[F.graphid]=F;break;case"datanode":case"label":case"shape":var F=L(S);F.nodeName=W;if(F.centerx){F.x=Math.round(F.centerx*10)/10;delete (F.centerx)}if(F.centery){F.y=Math.round(F.centery*10)/10;delete (F.centery)}if(F.width){F.width=parseInt(F.width)}if(F.height){F.height=parseInt(F.height)}if(F.textlabel){F.label=F.textlabel;delete (F.textlabel)}if(F.database&&F.id){F.database+=" : "+F.id}if(F.graphid){F.id=F.graphid}if(F.fontsize){F.labelSize=parseInt((F.fontsize/20)*10)/10}if(F.rotation){F.rotate=(parseFloat(F.rotation)*180/Math.PI)+180}if(F.shapetype){if(F.shapetype=="RoundedRectangle"){F.shapetype="roundrect"}if(F.shapetype=="Arc"){F.shapetype="arc3"}if(F.shapetype=="Mitochondria"){F.shapetype="image";F.imagePath="https://canvasxpress.org/images/mit.png"}if(this.isValidShape(F.shapetype.toLowerCase())){F.shape=F.shapetype.toLowerCase()}else{K+=F.id+" has an unkown shape: "+F.shapetype+"\n";F.shape=F.shapetype}delete (F.shapetype)}if(!F.shape){F.shape="rectangle"}if(W=="shape"){F.labelColor=F.color?this.validateColor(F.color):"rgb(0,0,0)"}else{if(F.color){F.labelColor=this.validateColor(F.color)}else{F.labelColor="rgb(0,0,0)"}}if(F.fillcolor){F.color=this.validateColor(F.fillcolor);delete (F.fillcolor)}else{F.color="rgba(0,0,0,0)"}if(F.color=="rgb(0,0,0)"){F.color="rgba(0,0,0,0)"}if(F.color=="rgb(255,255,255)"){F.color="rgba(255,255,255,0)"}if(W=="label"){if(!F.label||F.label==""){F.hideLabel=true;F.hideTooltip=P;F.eventless=true}F.outline="rgba(0,0,0,0)";F.color="rgba(0,0,0,0)"}else{F.outline=F.labelColor}if(W=="shape"&&(!F.label||F.label=="")){F.hideLabel=true;F.hideTooltip=P;F.outline=F.labelColor}if(F.groupref){if(!d.hasOwnProperty(F.groupref)){d[F.groupref]=[]}d[F.groupref].push([F.id,F.x,F.y,F.width,F.height]);F.parentNode=F.groupref}C[F.id]=M++;D[F.id]=F;e.push(F.id);break;case"interaction":var F=L(S);F.nodeName=W;if(F.anchor){for(var N=0;N<F.anchor.length;N++){t[F.anchor[N].graphid]=true}delete (F.anchor)}var y=F.point.length-1;if(F.point[0].graphref&&F.point[y].graphref){F.id1=F.point[0].graphref;F.id2=F.point[y].graphref}var Z="solid";if(F.linestyle&&F.linestyle=="Broken"){Z="dashed"}if(F.connectortype&&F.connectortype=="Curved"){Z+="Bezier"}F.type=Z;if(F.point[0].arrowhead){if(O[F.point[0].arrowhead]){F.startArrow=O[F.point[0].arrowhead]}}if(F.point[y].arrowhead){if(O[F.point[y].arrowhead]){F.endArrow=O[F.point[y].arrowhead]}}if(F.linethickness){F.thickness=parseInt(F.linethickness*10)/10;delete (F.linethickness)}if(F.point[0].relx&&F.point[0].rely){F.startX=parseFloat(F.point[0].relx);F.startY=parseFloat(F.point[0].rely)}if(F.point[y].relx&&F.point[y].rely){F.endX=parseFloat(F.point[y].relx);F.endY=parseFloat(F.point[y].rely)}delete (F.id);r.push(F);break;case"group":var F=L(S);F.nodeName=W;if(F.groupref&&F.groupid){if(!k.hasOwnProperty(F.groupref)){k[F.groupref]=[]}k[F.groupref].push(F.groupid);E[F.graphid]=F.groupref}else{U[F.graphid]=F.groupid}break;case"infobox":break;case"legend":break;case"biopax":break}}}}else{alert("Ooops! Not a gpml file!")}for(var G in aa){var T=aa[G].graphref;if(D[T]){var X=getStatePosition(D[T],aa[G]);var I={id:T,x:X[0],y:X[1],width:aa[G].width,height:aa[G].height,label:aa[G].textlabel==""?" ":aa[G].textlabel,type:"State",color:aa[G].textlabel==""?"rgb(255,255,255)":this.validateColor(aa[G].fillcolor),outline:"rgb(0,0,0)",shape:"oval",show:true,labelSize:0.5};q(I,G)}}for(var T in d){b(d[T],T)}for(var T in k){if(d.hasOwnProperty(T)){for(var Q=0;Q<k[T].length;Q++){var F=D[k[T][Q]];d[T].push([F.id,F.x,F.y,F.width,F.height])}b(d[T],T)}}var a=[];var n=[];for(var Q=0;Q<r.length;Q++){var F=r[Q];var y=F.point.length-1;if(!F.point[0].graphref&&!F.point[y].graphref){F.exact=true}for(var N=0;N<F.point.length;N++){var m=F.point[N];if(m.graphref){if(!D.hasOwnProperty(m.graphref)){if(N==0){if(U[m.graphref]){F.id1=U[m.graphref]}else{q(m,m.graphref);F.hideTooltip=P;F.exactStart=t[m.graphref]?true:false;F.id1=m.graphref}}else{if(N==F.point.length-1){if(U[m.graphref]){F.id2=U[m.graphref]}else{q(m,m.graphref);F.hideTooltip=P;F.exactEnd=t[m.graphref]?true:false;F.id2=m.graphref}}}}}else{if(N==0||N==F.point.length-1){var B=N==0?F.graphid+".1":F.graphid+".2";var Y=N==0?F.point.length-1:0;q(m,B);if(N==0){F.id1=B;F.exactStart=true}else{F.id2=B;F.exactEnd=true}F.hideTooltip=P;if(F.point[Y].graphref){if(!D.hasOwnProperty(F.point[Y].graphref)&&U[F.point[Y].graphref]){if(N==0){F.id2=U[F.point[Y].graphref]}else{F.id1=U[F.point[Y].graphref]}}else{if(N==0){F.id2=F.point[Y].graphref}else{F.id1=F.point[Y].graphref}}}}}}if(F.connectortype){if(F.connectortype=="Elbow"){F.elbows=V(F)}else{if(F.connectortype=="Curved"){F.elbows=getBezierPoints(F)}else{if(F.connectortype=="Segmented"){F.elbows=l(F)}}}}if(D[F.id1]&&D[F.id2]){a.push(F)}else{n.push(F)}}e.sort(function(g,c){if(D[g].zorder&&D[c].zorder){if(parseInt(D[g].zorder)-parseInt(D[c].zorder)==0){return C[g]-C[c]}else{return parseInt(D[g].zorder)-parseInt(D[c].zorder)}}else{return C[g]-C[c]}});var v=[];for(var Q=0;Q<e.length;Q++){v.push(D[e[Q]])}var A="Number of Nodes: "+v.length+"\n";A+="Number of Edges: "+a.length+"\n";if(n.length>0){A+="Number of Failed Edges: "+n.length+"\n";for(var Q=0;Q<n.length;Q++){A+="\t"+(Q+1)+". "+n[Q].graphid+"\n"}}if(K!="\nWarnings:\n"){A+=K}alert(A);return{data:{nodes:v,edges:a},config:{adjustBezier:false,graphType:"Network",calculateLayout:false,showAnimation:false,networkNodesOnTop:false,showNodeNameThreshold:20000,networkFreeze:true,preScaleNetwork:false,title:z}}};this.parseGML=function(f){var a=function(i,j){Object.keys(i).forEach(function(k){j(k,i[k])})};var e=("{\n"+f+"\n}").replace(/^(\s*)(\w+)\s*\[/gm,'$1"$2": {').replace(/^(\s*)\]/gm,"$1},").replace(/^(\s*)(\w+)\s+(.+)$/gm,'$1"$2": $3,').replace(/,(\s*)\}/g,"$1}");var h={};var c=[];var b=[];var d=0;e=e.replace(/^(\s*)"node"/gm,function(j,i){return(i+'"node['+(d++)+']"')});d=0;e=e.replace(/^(\s*)"edge"/gm,function(j,i){return(i+'"edge['+(d++)+']"')});try{e=JSON.parse(e)}catch(g){throw new SyntaxError("bad format")}if(!this.isObject(e.graph)){throw new SyntaxError("no graph tag")}a(e.graph,function(l,n){var m=l.match(/^(\w+)\[(\d+)\]$/);var j;var k;if(m){j=m[1];k=parseInt(m[2],10);if(j==="node"){c[k]=n}else{if(j==="edge"){b[k]=n;b[k].id1=b[k].source;b[k].id2=b[k].target;delete (b[k].source);delete (b[k].target)}else{h[l]=n}}}else{h[l]=n}});h.nodes=c;h.edges=b;return{data:h,config:{graphType:"Network"}}};this.delimitedToCanvasXpress=function(h){var c=function(g){return g.filter(function(j,n){return g.indexOf(j)===n})};var d={y:{vars:[],smps:[],data:[]}};var k="Scatter2D";var m=h[0].filter(Number);if(m.length==0){m=h.shift()}else{m=[];for(var e=0;e<h[0].length;e++){m.push("C"+(e+1))}}var o=[];for(var e=0;e<h.length;e++){o.push(h[e][0].toString())}var f=c(o);if(f.length==o.length){for(var e=0;e<h.length;e++){h[e].shift(h[e][0])}}else{o=[];for(var e=0;e<h.length;e++){o.push("R"+(e+1))}}if(m.length>h[0].length){m.shift();if(!m.length==h[0].length){return false}}if(h[0].length!=h[h.length-1].length){h.pop();o.pop();if(h[0].length!=h[h.length-1].length){return false}}var l=[];for(var e=0;e<m.length;e++){l[e]=false;for(var b=0;b<o.length;b++){if(isNaN(h[b][e])){l[e]=true;break}}if(!l[e]){for(var b=0;b<o.length;b++){h[b][e]=Number(h[b][e])}}else{d.z={}}}for(var e=0;e<o.length;e++){d.y.data[e]=[];d.y.vars.push(o[e])}for(var e=0;e<m.length;e++){if(l[e]){d.z[m[e]]=[];for(var b=0;b<o.length;b++){d.z[m[e]].push(h[b][e])}}else{d.y.smps.push(m[e]);for(var b=0;b<o.length;b++){d.y.data[b].push(h[b][e])}}}if(d.y.smps.length==0){var a=d.y.data.length;d.y.data=[[]];for(var e=0;e<a;e++){d.y.data[0].push(1)}d.y.smps=d.y.vars;d.y.vars=["counts"];d.x=d.z;delete (d.z);k="Bar"}else{if(d.y.smps.length==1){d.y.data=this.transposeMatrix(d.y.data);d.y.vars=d.y.smps;d.y.smps=o;d.x=d.z;delete (d.z);k="Bar"}}return{data:d,config:{graphType:k}}};this.getRDatasets=function(){var b=function(c){return function(d){c.Rdatasets=JSON.parse(d)}}(this);var a=this.RdatasetsURL+"datasets.json";this.ajaxRequest(a,false,b)};this.getRLibraryDataSets=function(a){this.getDataSetListFromURL(this.RdatasetsURL+"json/"+a+"/datasets.json")};this.getDataFromURL=function(){if(this.dataURL){var a=function(b){return function(c){var d=JSON.parse(c);b.remoteService=b.dataURL;b.remoteServiceType="file";if(Array.isArray(d)){b.setDataSetsFromURL(c)}else{d.renderTo=d.renderTo||b.newId("cX-data-url-");d.records=0;b.updateRemoteData(d)}}}(this);this.ajaxRequest(this.dataURL,false,a)}};this.getDataSetListFromURL=function(a){this.remoteService=a;this.ajaxRequest(a,false,this.setDataSetsFromURL)};this.setDataSetsFromURL=function(a){return function(b){var g=function(i){return function(n){var p=JSON.parse(n);f.updateRemoteData({data:p,ids:f.remoteIds,records:f.remoteIds.length})}}(f);var o=function(){var i=a.$("container-"+a.target).parentNode;while(i.id.match("canvasXpressRemoteWindow")){i=i.parentNode}if(!i.id){i.id=a.newId("-cX-data-sets-url-container-")}return i.id};var h=JSON.parse(b);var d=h[0][1];var c=[];for(var j=0;j<h.length;j++){c.push(h[j][0])}var k=o();var m=a.$("container-"+a.target).parentNode;var l=a.newId("cX-data-sets-");var e=a.$cX("canvas",{id:l,width:a.originalWidth,height:a.originalHeight});m.appendChild(e);var f=new CanvasXpress(l,false,{remoteService:a.remoteService});a.remoteIds=c;a.destroy(a.target);f.remoteData=h;f.remoteParentId=k;f.remoteIds=c;f.remoteServiceType="file";f.ajaxRequest(d,false,g)}}(this);this.dumpToConsole=function(a){console.log(this.target);console.log(this.prettyJSON(a))};this.initVocabulary=function(){if(!CanvasXpress.vocabulary){CanvasXpress.vocabulary={}}if(!CanvasXpress.vocabulary.n){CanvasXpress.vocabulary.n=0;CanvasXpress.vocabulary.byId=[];CanvasXpress.vocabulary.byStr={}}};this.getLeafletCanvas=function(){if(this.isMap){var i=this.meta.leaflet.ctx;var k=this.width;var g=this.height;var e=i.canvas.width;var a=i.canvas.height;var b=parseInt((e-k)/2);var j=parseInt((a-g)/2);var f=i.getImageData(b,j,k,g);var d=document.createElement("canvas");d.width=k;d.height=g;var l=d.getContext("2d");l.putImageData(f,0,0);return d}};this.initStack=function(d,b,c,e){if(!CanvasXpress.stack){CanvasXpress.stack={}}if(navigator.onLine&&!CanvasXpress.geo){this.setClientGeo()}var a=this.$(this.target);if(a){if(this.graphType=="Map"&&b.leafletInit){b.leafletInitString=b.leafletInit.toString()}CanvasXpress.stack[this.target]={version:CanvasXpress.factory.version,renderTo:this.target,data:d?JSON.parse(JSON.stringify(d)):false,config:b?JSON.parse(JSON.stringify(b)):false,events:c||false,info:e||false,afterRender:[["setDimensions",[a.originalWidth,a.originalHeight,true]]],state:[],stateIndex:0}}};this.getStack=function(){return CanvasXpress.stack[this.target].afterRender};this.diffConfigState=function(b,a){var g={};var h={idx1:{},idx2:{}};var f=CanvasXpress.stack[this.target].state[b];var e=CanvasXpress.stack[this.target].state[a];for(var i in f){if(e.hasOwnProperty(i)){if(!this.isSameObject(f[i],e[i])){h.idx1[i]=f[i]}else{g[i]=true}}else{h.idx1[i]=f[i]}}for(var i in e){if(!g.hasOwnProperty(i)){if(f.hasOwnProperty(i)){if(!this.isSameObject(f[i],e[i])){h.idx2[i]=e[i]}}else{h.idx2[i]=e[i]}}}return h};this.getConfigState=function(){var b={meta:true,animationOn:true,arrows:true,beaconImage:true,bubble:true,changingColorItemOn:true,changingColorOn:true,changingSliderItemOn:true,currentCanvasContext:true,draggingOn:true,doubleClick:true,edgeConfigurableProperties:true,events:true,featureConfigurableProperties:true,functionCaller:true,functionCallerDraw:true,functions:true,images:true,info:true,infoStartTime:true,isHighlightCanvas:true,isTransitionCanvas:true,isTransitionOn:true,keyOn:true,lastCanvasEvent:true,lastMousemove:true,lines:true,moveSankey:true,movingOn:true,nodeConfigurableProperties:true,nodes:true,panningOn:true,patterns:true,resetOn:true,resizeCanvasCursorShow:true,shapes:true,sizes:true,skipClick:true,skipTransition:true,times:true,touchEvent:true,touches:true,trackConfigurableProperties:true,transitionIter:true,userId:true,validGraphTypes:true,vennCompartments:true,xMouseDown:true,yMouseDown:true};if(this.graphType!="Network"){b.data=true}var a={};for(var d in this){if(!this.isFunction(this[d])&&!b.hasOwnProperty(d)){a[d]=this.isObject(this[d])?this.cloneObject(this[d]):this[d]}}return a};this.setConfigState=function(a){if(!a){a=0}var b=CanvasXpress.stack[this.target].state[a];for(var e in b){this[e]=b[e]}var d={calculateLayout:this.calculateLayout};this.calculateLayout=false;this.skipStack=true;this.draw();this.skipStack=false;for(var e in d){this[e]=d[e]}};this.stack=function(){if(!this.skipStack){var h=arguments.callee.caller.caller;var g=this.getFunctionCallerName(h);var m=this.getConfigState();var k=new Date().getTime();if(h&&g){var i=this.cleanEventInArguments(Array.from(h.arguments));var c=CanvasXpress.stack[this.target].afterRender.length;switch(g){case"setDimensions":if(i&&i[0]==this.width&&i[1]==this.height){return}CanvasXpress.stack[this.target].afterRender.push([g,i,{},k]);break;case"sortSamples":case"sortSamplesByCategory":case"sortSamplesByVariable":case"sortVariables":case"sortVariablesByCategory":case"sortVariablesBySample":CanvasXpress.stack[this.target].afterRender.push([g,i,{sortDir:this.sortDir},k]);break;case"desegregate":CanvasXpress.stack[this.target].afterRender.push([g,i,{segregateSamplesBy:this.segregateSamplesBy,segregateVariablesBy:this.segregateVariablesBy},k]);break;case"broadcastDraw":case"segregateSamplesVariables":h=h.caller;g=this.getFunctionCallerName(h);i=this.cleanEventInArguments(Array.from(h.arguments));CanvasXpress.stack[this.target].afterRender.push([g,i,{},k]);break;case"updateDataFilter":CanvasXpress.stack[this.target].afterRender.push([g,[true],{toDoFilter:this.toDoFilter},k]);break;case"endCanvasResizer":CanvasXpress.stack[this.target].afterRender.push(["setDimensions",Array.from(arguments.callee.caller.arguments),{},k]);break;case"drawIndicesAfterWheelEvent":var j=CanvasXpress.stack[this.target].afterRender;var b=CanvasXpress.stack[this.target].state;if(c>1&&j[c-1][0]=="drawIndicesAfterWheelEvent"){var e=k-j[c-1][3];if(e<1000){j.pop();b.pop()}}CanvasXpress.stack[this.target].afterRender.push([g,i,{varIndicesStart:this.varIndicesStart,smpIndicesStart:this.smpIndicesStart},k]);break;case"drawRangesAfterWheelEvent":var j=CanvasXpress.stack[this.target].afterRender;var b=CanvasXpress.stack[this.target].state;if(c>1&&j[c-1][0]=="drawRangesAfterWheelEvent"){var e=k-j[c-1][3];if(e<1000){j.pop();b.pop()}}CanvasXpress.stack[this.target].afterRender.push([g,i,{},k]);break;case"drawIndicesAfterPannEvent":var j=CanvasXpress.stack[this.target].afterRender;var b=CanvasXpress.stack[this.target].state;if(c>1&&j[c-1][0]=="drawIndicesAfterPannEvent"){var e=k-j[c-1][3];if(e<1000){j.pop();b.pop()}}CanvasXpress.stack[this.target].afterRender.push([g,i,{varIndicesStart:this.varIndicesStart,smpIndicesStart:this.smpIndicesStart},k]);break;case"updateDragScatter":var j=CanvasXpress.stack[this.target].afterRender;var b=CanvasXpress.stack[this.target].state;if(c>1&&j[c-1][0]=="updateDragScatter"&&!i[0].shiftKey){var e=k-j[c-1][3];if(e<1000){j.pop();b.pop()}}CanvasXpress.stack[this.target].afterRender.push([g,i,{moveLegend:this.moveLegend,moveLegendX:this.moveLegendX,moveLegendY:this.moveLegendY,moveLegendCurX:this.moveLegendCurX,moveLegendCurY:this.moveLegendCurY},k]);break;case"updateDragGenome":var j=CanvasXpress.stack[this.target].afterRender;var b=CanvasXpress.stack[this.target].state;if(c>1&&j[c-1][0]=="updateDragGenome"&&!i[0].shiftKey){var e=k-j[c-1][3];if(e<1000){j.pop();b.pop()}}CanvasXpress.stack[this.target].afterRender.push([g,i,{moveGenome:this.moveGenome,setMinX:this.setMinX,setMaxX:this.setMaxX,xMouseDown:this.xMouseDown},k]);break;case"updateDragNetwork":var j=CanvasXpress.stack[this.target].afterRender;var b=CanvasXpress.stack[this.target].state;if(c>1&&j[c-1][0]=="updateDragNetwork"&&!i[0].shiftKey){var e=k-j[c-1][3];if(e<1000){j.pop();b.pop()}}CanvasXpress.stack[this.target].afterRender.push([g,i,{moveLegend:this.moveLegend,moveLegendX:this.moveLegendX,moveLegendY:this.moveLegendY,moveEdge:this.moveEdge,moveEdgeIndex:this.moveEdgeIndex,moveEdgeElbow:this.moveEdgeElbow,moveNode:this.moveNode,moveNodeIndex:this.moveNodeIndex,moveNodeLab:this.moveNodeLab,moveNodeDec:this.moveNodeDec,moveNodeW:this.moveNodeW,moveNodeH:this.moveNodeH,moveNodeX:this.moveNodeX,moveNodeY:this.moveNodeY,xMouseDown:this.xMouseDown,yMouseDown:this.yMouseDown},k]);break;case"handleDragEventOneDimension":CanvasXpress.stack[this.target].afterRender.push([g,i,{moveDendrogram:this.moveDendrogram,moveVarOverlay:this.moveVarOverlay,moveVar:this.moveVar,moveSmpOverlay:this.moveSmpOverlay,moveSmp:this.moveSmp},k]);break;case"updateDragCircular":var j=CanvasXpress.stack[this.target].afterRender;var b=CanvasXpress.stack[this.target].state;if(c>1&&j[c-1][0]=="updateDragCircular"&&!i[0].shiftKey){var e=k-j[c-1][3];if(e<1000){j.pop();b.pop()}}CanvasXpress.stack[this.target].afterRender.push([g,i,{circularRotate:this.circularRotate,moveCircular:this.moveCircular,panningX:this.panningX,panningY:this.panningY,xMouseDown:this.xMouseDown,yMouseDown:this.yMouseDown},k]);break;case"resortSankey":var j=CanvasXpress.stack[this.target].afterRender;var b=CanvasXpress.stack[this.target].state;if(c>1&&j[c-1][0]=="resortSankey"){var e=k-j[c-1][3];if(e<1000){j.pop();b.pop()}}CanvasXpress.stack[this.target].afterRender.push([g,i,{moveSankey:this.moveSankey,moveSankeyY:this.moveSankeyY,moveSankeyMin:this.moveSankeyMin,moveSankeyOrder:this.moveSankeyOrder},k]);break;default:CanvasXpress.stack[this.target].afterRender.push([g,i,{},k]);break}if(CanvasXpress.stack[this.target].stateIndex<CanvasXpress.stack[this.target].state.length-1){CanvasXpress.stack[this.target].state.splice(CanvasXpress.stack[this.target].stateIndex,CanvasXpress.stack[this.target].state.length-1)}CanvasXpress.stack[this.target].state.push(m);CanvasXpress.stack[this.target].stateIndex=CanvasXpress.stack[this.target].state.length-1}}};this.getDragDivDimensions=function(E,y,A){var w,k,m,i,x,n,r,j,B,s,z,q;var F=y[0];var G=null;var D=this.graphType;switch(E){case"handleDragEventGenome":case"handleDragEventHeatmap":case"handleDragEventOneDimension":case"handleDragEventScatter":case"handlePanning":case"showHideSelectedDataPoint":G=y[1];break;case"updateDragNetwork":G=y[5];break}var H=G!=null?this.getBoundsXY(G):false;if(H!=false){var C=F.xMouseDown;var v=F.yMouseDown;var u=F.ac.x;var a=F.ac.y;if(C>=H[0]&&C<=H[1]&&v>=H[2]&&v<=H[3]){if((!D.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation=="vertical"&&!F.shiftKey)||(!D.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation!="vertical"&&F.shiftKey)){w=x=H[0];m=r=H[1]-H[0]}else{w=x=Math.min(C,u);m=0;r=u>C?u-C:C-u}B=x;z=x+r;if((!D.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation!="vertical"&&!F.shiftKey)||(!D.match(/Scatter|Heatmap|Network|Genome|Circular/)&&this.graphOrientation=="vertical"&&F.shiftKey)||D=="Genome"){k=n=H[2];i=j=H[3]-H[2]}else{k=n=Math.min(v,a);i=0;j=a>v?a-v:v-a}s=n;q=n+j}else{if(A&&C>=H[4]&&C<=H[5]&&v>=H[6]&&v<=H[7]){var h=function(){w=x=H[4];k=v;n=a;m=r=H[5]-H[4];i=j=3;B=C;s=v;z=C;q=n};var d=function(){w=C;x=u;k=n=H[6];m=r=3;i=j=H[7]-H[6];B=C;s=v;z=x;q=v};if(A.moveDendrogram){if(A.moveDendrogram=="varDendrogram"||(A.moveDendrogram=="smpDendrogram"&&this.graphOrientation=="vertical")){h()}else{d()}}else{if(A.moveSmpOverlay){if(D.match(/Heatmap/)||this.graphOrientation=="horizontal"){d()}else{h()}}else{if(A.moveSmp){if(D.match(/Heatmap/)||this.graphOrientation=="horizontal"){h()}else{d()}}else{if(A.moveVarOverlay){h()}else{if(A.moveVar){d()}else{alert("Ooop! Something went wrong")}}}}}}else{alert("Ooop! Something went really wrong")}}}return[w,k,m,i,x,n,r,j,B,s,z,q]};this.demonstrate=function(a){return function(b){if(!b){b=window.event}a.skipStack=true;a.reproducing=true;a.resetMenus();a.resetLinks();a.addMotionDiv();a.updateMotion();return false}}(this);this.reproduce=function(a){return function(l){if(!l){l=window.event}a.skipStack=true;a.resetMenus();a.resetLinks();var k=document.body;var s=a.$(a.target);var g=s.parentNode.getClientRects();var j=a.$(a.target+"-cX-Drag");var p=a.$(a.target+"-cX-Icon-Reproduce");if(!p){p=a.$cX("img",{id:this.target+"-cX-Icon-Reproduce"},{display:"none",position:"absolute",zIndex:239010});document.body.appendChild(p)}var h=JSON.parse(JSON.stringify(CanvasXpress.stack[a.target].data));var d=JSON.parse(JSON.stringify(CanvasXpress.stack[a.target].config));var r=CanvasXpress.stack[a.target].afterRender;var b=r.length;a.setConfigDefaults();for(var o in d){a[o]=d[o]}a.layoutValid=false;a.initializeData(h,true);a.resetLegendPosition();a.resetDendrograms();a.initializeGraph(true);a.flashInfoSpan(0,0,"<b>Initial Graph</b>",a.reproduceTime);a[r[0][0]].apply(a,r[0][1]);var f=1;var q=r.length;(function m(){setTimeout(function(){if(f<b){var A=function(c){if(z=="updateClickConfigurator"){return'<img src="'+CanvasXpress.images.mouseLeft2+'"/>'}else{if(c.type.match(/wheel/)){return'<img src="'+CanvasXpress.images.mouseScroll+'"/>'}else{if(c.type.match(/key/)){return'<img src="'+CanvasXpress.images.keyEscape+'"/>'}else{if(c.type.match(/mouse/)){return'<img src="'+CanvasXpress.images.mouseLeft+'"/>'+x(c)}else{return'<img src="'+CanvasXpress.images.mouseRight+'"/>'}}}}};var x=function(E){var c="";if(E.shiftKey){c+='<img src="'+CanvasXpress.images.keyShiftIcon+'"/>'}if(E.ctrlKey){c+='<img src="'+CanvasXpress.images.keyCtrlIcon+'"/>'}if(E.altKey){c+='<img src="'+CanvasXpress.images.keyAltIcon+'"/>'}return c};var n=r[f];var z=n[0];var e=n[1]||[];var C=n[2]||{};var u="<b>Next modification...</b><br><br><b>Function:</b> "+z+"<br><br>";var i="";var D=false;if(e[0]&&e[0].type){i=A(e[0]);D=e[0].type.match(/wheel/)?true:false}else{if(z=="updateDragScatter"||z=="setDimensions"){i='<img src="'+CanvasXpress.images.mouseLeft+'"/>'}}var B=a.prettyJSON(e);if(B.length>200){B=B.substring(0,250)+"..."}u+="<b>Parameters:</b> "+i+'<pre class="CanvasXpressCode">'+B+"</pre><br>";var t=a.prettyJSON(C);if(t.length>200){t=B.substring(0,250)+"..."}u+='<b>Config:</b> <pre class="CanvasXpressCode">'+t+"</pre><br>";for(var w in C){a[w]=C[w]}a.flashInfoSpan(0,0,u,a.reproduceTime*2);if(D&&p){var y=e[0];p.src=CanvasXpress.images.mouseScroll;p.style.left=k.scrollLeft+g[0].left+e[0].ac.x-8+"px";p.style.top=k.scrollTop+g[0].top+e[0].ac.y-8+"px";p.style.width="16px";p.style.height="16px";p.style.display="block"}else{if(i!=""&&z!="updateDragScatter"&&j&&p){var y=e[0];var v=a.getDragDivDimensions(z,e,C);p.src=CanvasXpress.images.mouseLeft;p.style.left=k.scrollLeft+g[0].left+v[8]-8+"px";p.style.top=k.scrollTop+g[0].top+v[9]-8+"px";p.style.width="16px";p.style.height="16px";p.style.display="block";j.style.left=v[0]+"px";j.style.top=v[1]+"px";j.style.width=v[2]+"px";j.style.height=v[3]+"px";j.style.display="block";a.resizeMove(j,v[4],v[5],v[6],v[7],a.reproduceTime);a.resizeMove(p,k.scrollLeft+g[0].left+v[10]-8,k.scrollTop+g[0].top+v[11]-8,16,16,a.reproduceTime)}}setTimeout(function(){if(j&&p){a.resetDrag();if(D==""){p.style.display="none"}}a[z].apply(a,e);f++;m()},z=="updateDragScatter"||z=="updateDragNetwork"?a.reproduceTime/5000:a.reproduceTime+100)}else{if(p){p.style.display="none"}a.flashInfoSpan(0,0,"<b>That's All Folks</b>",a.reproduceTime);a.skipStack=false;return}},a.reproduceTime)})()}}(this)};CanvasXpress.prototype.initConfig=function(a){this.setConfigDefaults=function(){var b=CanvasXpress.config;this.graphType="Bar";b.push("graphType");this.graphOrientation="horizontal";b.push("graphOrientation");this.transparency=null;b.push("transparency");this.canvasBox=false;b.push("canvasBox");this.canvasBoxColor="rgb(204,204,204)";b.push("canvasBoxColor");this.plotBox=false;b.push("plotBox");this.plotBoxColor="rgb(204,204,204)";b.push("plotBoxColor");this.invertGraph=false;b.push("invertGraph");this.loadImagesTimeOut=100;b.push("loadImagesTimeOut");this.isR=false;b.push("isR");this.isReproducibleResearch=true;b.push("isReproducibleResearch");this.reproduceTime=1000;b.push("reproduceTime");this.printType="download";b.push("printType");this.printMagnification=1;b.push("printMagnification");this.higlightGreyOut=false;b.push("higlightGreyOut");this.higlightGreyOutTransparency=0.67;b.push("higlightGreyOutTransparency");this.theme="none";b.push("theme");this.useVocabulary=false;b.push("useVocabulary");this.functions=[];this.gradient=false;b.push("gradient");this.gradientType="radial";b.push("gradientType");this.gradientOrientation="vertical";b.push("gradientOrientation");this.gradientRatio=1.3;b.push("gradientRatio");this.adjustAspectRatio=true;b.push("adjustAspectRatio");this.percentAspectRatioPlotArea=0.5;b.push("percentAspectRatioPlotArea");this.variableSpaceFactor=2;b.push("variableSpaceFactor");this.sampleSpaceFactor=1;b.push("sampleSpaceFactor");this.widthFactor=1;b.push("widthFactor");this.dataPointSize=28;b.push("dataPointSize");this.adjustAspectRatioMax=3;this.adjustAspectRatioYTries=0;this.adjustAspectRatioXTries=0;this.foreground="rgb(0,0,0)";b.push("foreground");this.background="rgb(255,255,255)";b.push("background");this.backgroundWindow="rgb(244,244,244)";b.push("backgroundWindow");this.backgroundType="solid";b.push("backgroundType");this.backgroundImage=false;b.push("backgroundImage");this.backgroundVideo=false;b.push("backgroundVideo");this.backgroundGradient1Color="rgb(0,0,200)";b.push("backgroundGradient1Color");this.backgroundGradient2Color="rgb(0,0,36)";b.push("backgroundGradient2Color");this.margin=5;b.push("margin");this.marginLeft=5;b.push("marginLeft");this.marginTop=5;b.push("marginTop");this.marginBottom=5;b.push("marginBottom");this.marginRight=5;b.push("marginRight");this.showShadow=false;b.push("showShadow");this.showTextShadow=false;b.push("showTextShadow");this.shadowOffsetX=1;b.push("shadowOffsetX");this.shadowOffsetY=1;b.push("shadowOffsetY");this.shadowBlur=2;b.push("shadowBlur");this.shadowColor="rgba(0,0,0,0.5)";b.push("shadowColor");this.topoJSON=false;b.push("topoJSON");this.leafletLayer=true;b.push("leafletLayer");this.leafletJS=["https://canvasxpress.org/js/topojson.v2.js","https://canvasxpress.org/js/leaflet.js"];b.push("leafletJS");this.leafletCSS=["https://canvasxpress.org/css/leaflet.css"];b.push("leafletCSS");this.leafletInit=false;b.push("leafletInit");this.leafletInitString=false;b.push("leafletInitString");this.leafletId=false;b.push("leafletId");this.leafletConfig=false;b.push("leafletConfig");this.isMap=false;this.videoControls=true;b.push("videoControls");this.videoAutoplay=true;b.push("videoAutoplay");this.videoLoop=false;b.push("videoLoop");this.videoPreload="none";b.push("videoPreload");this.videoData="{}";b.push("videoData");this.videoPoster="";b.push("videoPoster");this.videoClassName="video-js vjs-default-skin";b.push("videoClassName");this.videoPlaybackRate=1;b.push("videoPlaybackRate");this.videoCurrentTime=false;b.push("videoCurrentTime");this.videoGrid=false;b.push("videoGrid");this.videoGridStep=10;b.push("videoGridStep");this.videoColor="rgb(255,0,0)";b.push("videoColor");this.fontName="Arial";b.push("fontName");this.fontStyle="";b.push("fontStyle");this.fontSize=12;b.push("fontSize");this.fontScaleFontFactor=1;b.push("fontScaleFontFactor");this.align="center";b.push("align");this.baseline="middle";b.push("baseline");this.maxTextSize=40;b.push("maxTextSize");this.minTextSize=4;b.push("minTextSize");this.autoScaleFont=true;b.push("autoScaleFont");this.scaleTextConstantMult=30;this.scaleTextConstantAdd=2;this.title=false;b.push("title");this.titleAlign="center";b.push("titleAlign");this.titleFontSize=16;b.push("titleFontSize");this.titleColor="rgb(0,0,0)";b.push("titleColor");this.titleScaleFontFactor=1;b.push("titleScaleFontFactor");this.titleFontStyle="";b.push("titleFontStyle");this.subtitle=false;b.push("subtitle");this.subtitleAlign="center";b.push("subtitleAlign");this.subtitleFontSize=14;b.push("subtitleFontSize");this.subtitleColor="rgb(0,0,0)";b.push("subtitleColor");this.subtitleScaleFontFactor=1;b.push("subtitleScaleFontFactor");this.subtitleFontStyle="";b.push("subtitleFontStyle");this.citation=false;b.push("citation");this.citationColor="rgb(0,0,0)";b.push("citationColor");this.citationFontStyle="";b.push("citationFontStyle");this.citationFontSize=7;b.push("citationFontSize");this.citationScaleFontFactor=1;b.push("citationScaleFontFactor");this.dashLength=8;b.push("dashLength");this.dotLength=1;b.push("dotLength");this.arrowPointSize=8;b.push("arrowPointSize");this.capType="butt";b.push("capType");this.joinType="mitter";b.push("joinType");this.lineWidthEvent=2;this.outlineWidth=1;b.push("outlineWidth");this.lineThickness=1;b.push("lineThickness");this.adjustBezier=false;b.push("adjustBezier");this.lines=["line","solid","straight","bezier","curved","curvedCC","dashedLine","dashedBezier","dashedCurved","dashedCurvedCC","dottedLine","dottedBezier","dottedCurved","dottedCurvedCC","blank","dashed","dotted","dotdash","longdash","twodash"];this.arrows=["arrow","square","round"];this.colorScheme="User";b.push("colorScheme");this.colors=["#fe296c","#487eb6","#a7ce31","#f8cc03","#ff8c02","#699696","#b77844","#83acd0","#c2e076","#fadc5a","#ff549f","#ffaf54","#9ab8b7","#d2a683","#3d699b","#87ac22","#cda908","#d02158","#d07300","#567676"];b.push("colors");this.colorHSV=[0,0,1];this.colorRGB=[1,1,1];this.colorSpectrum=["#4575b4","#91bfdb","#e0f3f8","#ffffbf","#fee090","#fc8d59","#d73027"];b.push("colorSpectrum");this.colorSpectrumBreaks=[];b.push("colorSpectrumBreaks");this.colorSpectrumZeroValue=null;b.push("colorSpectrumZeroValue");this.colorSpectrumNumber=100;b.push("colorSpectrumNumber");this.oddColor=this.background;b.push("oddColor");this.evenColor="rgb(245,245,245)";b.push("evenColor");this.shapes=["sphere","square","triangle","star","rhombus","octagon","oval","plus","minus","pacman","pacman2","mdavid","rect2","rect3","arc","rectangle","image"];b.push("shapes");this.sizes=[16,18,20,22,24,26,28,30,32,34,36,38,40,42,44,46];b.push("sizes");this.images=[];b.push("images");this.patterns=["solid","hatchForward","hatchReverse","stripeHorizontal","stripeVertical","polkaDot","crossHatch","crossStripe","squares","circles","plus","minus","bars","squiglesVertical","squiglesHorizontal","brickForward","brickReverse","art","pcx","hatchForward3","hatchReverse3"];b.push("patterns");this.maxSmpStringLen=30;b.push("maxSmpStringLen");this.smpLabelDescription=false;b.push("smpLabelDescription");this.smpTitle=false;b.push("smpTitle");this.smpTitleFontStyle="";b.push("smpTitleFontStyle");this.smpTitleFontSize=12;b.push("smpTitleFontSize");this.smpTitleFontColor=this.foreground;b.push("smpTitleFontColor");this.smpTitleScaleFontFactor=1;b.push("smpTitleScaleFontFactor");this.smpLabelFontStyle="";b.push("smpLabelFontStyle");this.smpLabelFontSize=12;b.push("smpLabelFontSize");this.smpLabelFontColor=this.foreground;b.push("smpLabelFontColor");this.smpLabelScaleFontFactor=1;b.push("smpLabelScaleFontFactor");this.smpLabelRotate=0;b.push("smpLabelRotate");this.smpLabelInterval=1;b.push("smpLabelInterval");this.showSampleNames=true;b.push("showSampleNames");this.highlightSmp=[];b.push("highlightSmp");this.smpHighlightColor="rgb(255,0,0)";b.push("smpHighlightColor");this.maxVarStringLen=30;b.push("maxVarStringLen");this.varLabelDescription=false;b.push("varLabelDescription");this.varTitle=false;b.push("varTitle");this.varTitleFontStyle="";b.push("varTitleFontStyle");this.varTitleFontSize=12;b.push("varTitleFontSize");this.varTitleFontColor=this.foreground;b.push("varTitleFontColor");this.varTitleScaleFontFactor=1;b.push("varTitleScaleFontFactor");this.varLabelFontStyle="";b.push("varLabelFontStyle");this.varLabelFontSize=12;b.push("varLabelFontSize");this.varLabelFontColor=this.foreground;b.push("varLabelFontColor");this.varLabelScaleFontFactor=1;b.push("varLabelScaleFontFactor");this.varLabelRotate=0;b.push("varLabelRotate");this.varLabelInterval=1;b.push("varLabelInterval");this.showVariableNames=true;b.push("showVariableNames");this.highlightVar=[];b.push("highlightVar");this.varHighlightColor="rgb(255,0,0)";b.push("varHighlightColor");this.binConfigurations={};b.push("binConfigurations");this.maxOverlayStringLen=30;b.push("maxOverlayStringLen");this.overlaysThickness=18;b.push("overlaysThickness");this.smpOverlays=[];b.push("smpOverlays");this.smpOverlayProperties={};b.push("smpOverlayProperties");this.smpOverlaysLegendColumns=1;b.push("smpOverlaysLegendColumns");this.showSmpOverlaysLegend=false;b.push("showSmpOverlaysLegend");this.varOverlays=[];b.push("varOverlays");this.varOverlayProperties={};b.push("varOverlayProperties");this.varOverlaysLegendColumns=1;b.push("varOverlaysLegendColumns");this.showVarOverlaysLegend=false;b.push("showVarOverlaysLegend");this.overlaysLegendPosition="topRight";b.push("overlaysLegendPosition");this.showOverlays=true;b.push("showOverlays");this.showLevelOverlays=true;b.push("showLevelOverlays");this.overlayFontStyle="";b.push("overlayFontStyle");this.overlayFontSize=12;b.push("overlayFontSize");this.overlayFontColor=this.foreground;b.push("overlayFontColor");this.overlayScaleFontFactor=1;b.push("overlayScaleFontFactor");this.showLegend=true;b.push("showLegend");this.legendColumns=1;b.push("legendColumns");this.legendPosition="right";b.push("legendPosition");this.legendInside=false;b.push("legendInside");this.legendColor=this.foreground;b.push("legendColor");this.legendBox=true;b.push("legendBox");this.legendBoxColor="rgb(204,204,204)";b.push("legendBoxColor");this.legendBackgroundColor=this.background;b.push("legendBackgroundColor");this.legendFontStyle="";b.push("legendFontStyle");this.legendFontSize=12;b.push("legendFontSize");this.legendScaleFontFactor=1;b.push("legendScaleFontFactor");this.legendOrder=false;b.push("legendOrder");this.legend=[];b.push("legend");this.showDecorations=true;b.push("showDecorations");this.showDecorationsLegend=true;b.push("showDecorationsLegend");this.decorationsPosition="bottom";b.push("decorationsPosition");this.decorationsColor=this.foreground;b.push("decorationsColor");this.decorationsBox=true;b.push("decorationsBox");this.decorationsBoxColor="rgb(204,204,204)";b.push("decorationsBoxColor");this.decorationsBackgroundColor=this.background;b.push("decorationsBackgroundColor");this.decorationFontStyle="";b.push("decorationFontStyle");this.decorationFontSize=12;b.push("decorationFontSize");this.decorationScaleFontFactor=1;b.push("decorationScaleFontFactor");this.decorationsWidth=20;b.push("decorationsWidth");this.decorationsHeight=40;b.push("decorationsHeight");this.decorationsType="bar";b.push("decorationsType");this.decorations=false;b.push("decorations");this.decorationsColors=[];b.push("decorationsColors");this.decorationsProperties={};b.push("decorationsProperties");this.isGroupedData=false;this.isBoxPlotCalc=false;this.isMarketDataFormated=false;this.isMarketSwitched=false;this.groupingFactors=[];b.push("groupingFactors");this.segregateSamplesBy=[];b.push("segregateSamplesBy");this.segregateVariablesBy=[];b.push("segregateVariablesBy");this.summaryType=false;b.push("summaryType");this.isTransformedData=false;this.transformBase=10;this.transformedData=false;b.push("transformedData");this.transformType=false;b.push("transformType");this.transformAxis="samples";b.push("transformAxis");this.ratioReference=0;b.push("ratioReference");this.ratioSampleReference=false;b.push("ratioSampleReference");this.ratioGroupReference=false;b.push("ratioGroupReference");this.ratioLevelReference="";b.push("ratioLevelReference");this.timeFormat="isoDate";b.push("timeFormat");this.isGraphTime=false;b.push("isGraphTime");this.timeValues=[];this.timeValueIndices=[];this.timeTicksFirst=false;b.push("timeTicksFirst");this.sortDir="ascending";b.push("sortDir");this.sortCaseSensitive=false;b.push("sortCaseSensitive");this.smpSort=-1;this.varSort=-1;this.tmpAsciiArray=[];this.missingDataColor="rgba(204,204,204,0.33)";b.push("missingDataColor");this.missingDataValue="NA";b.push("missingDataValue");this.showErrorBars=true;b.push("showErrorBars");this.errorBarsType="confidenceInterval95";b.push("errorBarsType");this.errorBarsWidth=2;b.push("errorBarsWidth");this.standardDeviationType="unbiased";b.push("standardDeviationType");this.errorEllipseConfidence=0.99;b.push("errorEllipseConfidence");this.showRegressionConfidence=true;b.push("showRegressionConfidence");this.showKaplanMeierConfidence=false;b.push("showKaplanMeierConfidence");this.randomSeed=8;b.push("randomSeed");this.pseudoRandom=true;b.push("pseudoRandom");this.randomData=false;this.randomDataDistribution="biased";b.push("randomDataDistribution");this.randomDataTime=false;b.push("randomDataTime");this.randomDataMin=1;b.push("randomDataMin");this.randomDataMax=100;b.push("randomDataMax");this.randomDataMean=0;b.push("randomDataMean");this.randomDataSigma=1;b.push("randomDataSigma");this.randomDataVariables=3;b.push("randomDataVariables");this.randomDataSamples=36;b.push("randomDataSamples");this.randomDataVariableAnnotations=2;b.push("randomDataVariableAnnotations");this.randomDataSampleAnnotations=2;b.push("randomDataSampleAnnotations");this.randomMissingDataPercentage=0;b.push("randomMissingDataPercentage");this.randomNetworkReduce=true;b.push("randomNetworkReduce");this.randomNetworkNodes=40;b.push("randomNetworkNodes");this.randomNetworkNodeEdgesMax=5;b.push("randomNetworkNodeEdgesMax");this.randomNetworkAll=true;b.push("randomNetworkAll");this.randomNetworkLayout;b.push("randomNetworkLayout");this.zoom=1;b.push("zoom");this.zoomGlobal=1;this.zoomStep=0.2;b.push("zoomStep");this.zoomScale=true;b.push("zoomScale");this.zoomVariablesDisable=false;b.push("zoomVariablesDisable");this.zoomSamplesDisable=false;b.push("zoomSamplesDisable");this.panningX=0;b.push("panningX");this.panningY=0;b.push("panningY");this.panningGlobalX=0;this.panningGlobalY=0;this.panningStep=0.2;b.push("panningStep");this.resizerBackgroundColor=CanvasXpress.system.isIE?"rgb(204,204,204)":"rgba(204,204,204,0.7)";b.push("resizerBackgroundColor");this.xAxisAbsMax=null;this.xAxisAbsMin=null;this.xAxisMaxStrLength=false;this.setMaxX=null;b.push("setMaxX");this.setMinX=null;b.push("setMinX");this.xAxisCurrent=0;b.push("xAxisCurrent");this.xAxisTitle=false;b.push("xAxisTitle");this.xAxis=[];b.push("xAxis");this.xAxisTickStyle="solid";b.push("xAxisTickStyle");this.xAxisTickFormat=false;b.push("xAxisTickFormat");this.xAxisTickColor="rgb(204,204,204)";b.push("xAxisTickColor");this.xAxisExact=false;b.push("xAxisExact");this.xAxisValues=[];this.xAxisValuesRaw=[];this.xAxisMinorValues=[];this.xAxisTransform=false;b.push("xAxisTransform");this.xAxisCeilValue=null;b.push("xAxisCeilValue");this.xAxisFloorValue=null;b.push("xAxisFloorValue");this.xAxisTransformTicks=true;b.push("xAxisTransformTicks");this.xAxisShow=true;b.push("xAxisShow");this.xAxisS2Show=false;b.push("xAxisS2Show");this.xAxisTicks=5;b.push("xAxisTicks");this.xAxisMinorTicks=true;b.push("xAxisMinorTicks");this.xAxisMajorTicks=true;b.push("xAxisMajorTicks");this.xAxisLeftMajorTick=true;b.push("xAxisLeftMajorTick");this.xAxisRightMajorTick=true;b.push("xAxisRightMajorTick");this.xAxisLeftRightTickColor="rgb(204,204,204)";b.push("xAxisLeftRightTickColor");this.xAxisHistogramShow=false;b.push("xAxisHistogramShow");this.xAxisHistogramHeight=50;b.push("xAxisHistogramHeight");this.xAxis2AbsMax=null;this.xAxis2AbsMin=null;this.xAxis2MaxStrLength=false;this.setMaxX2=null;b.push("setMaxX2");this.setMinX2=null;b.push("setMinX2");this.xAxis2Title=false;b.push("xAxis2Title");this.xAxis2=[];b.push("xAxis2");this.xAxis2TickFormat=false;b.push("xAxis2TickFormat");this.xAxis2Values=[];this.xAxis2ValuesRaw=[];this.xAxis2MinorValues=[];this.xAxis2Show=true;b.push("xAxis2Show");this.xAxis2Ticks=null;this.yAxisAbsMax=null;this.yAxisAbsMin=null;this.yAxisMaxStrLength=false;this.setMaxY=null;b.push("setMaxY");this.setMinY=null;b.push("setMinY");this.yAxisCurrent=0;b.push("yAxisCurrent");this.yAxisTitle=false;b.push("yAxisTitle");this.yAxis2Title=false;b.push("yAxis2Title");this.yAxis=[];b.push("yAxis");this.yAxisTickStyle="solid";b.push("yAxisTickStyle");this.yAxisTickFormat=false;b.push("yAxisTickFormat");this.yAxisTickColor="rgb(204,204,204)";b.push("yAxisTickColor");this.yAxisExact=false;b.push("yAxisExact");this.yAxisValues=[];this.yAxisValuesRaw=[];this.yAxisMinorValues=[];this.yAxisTransform=false;b.push("yAxisTransform");this.yAxisCeilValue=null;b.push("yAxisCeilValue");this.yAxisFloorValue=null;b.push("yAxisFloorValue");this.yAxisTransformTicks=true;b.push("yAxisTransformTicks");this.yAxisShow=true;b.push("yAxisShow");this.yAxis2Show=false;b.push("yAxis2Show");this.yAxisTicks=5;b.push("yAxisTicks");this.yAxisMinorTicks=true;b.push("yAxisMinorTicks");this.yAxisMajorTicks=true;b.push("yAxisMajorTicks");this.yAxisTopMajorTick=true;b.push("yAxisTopMajorTick");this.yAxisBottomMajorTick=true;b.push("yAxisBottomMajorTick");this.yAxisTopBottomTickColor="rgb(204,204,204)";b.push("yAxisTopBottomTickColor");this.yAxisHistogramShow=false;b.push("yAxisHistogramShow");this.yAxisHistogramHeight=50;b.push("yAxisHistogramHeight");this.zAxisAbsMax=null;this.zAxisAbsMin=null;this.zAxisMaxStrLength=false;this.setMaxZ=null;b.push("setMaxZ");this.setMinZ=null;b.push("setMinZ");this.zAxisCurrent=0;b.push("zAxisCurrent");this.zAxisTitle=false;b.push("zAxisTitle");this.zAxis=[];b.push("zAxis");this.zAxisTickStyle="solid";b.push("zAxisTickStyle");this.zAxisTickFormat=false;b.push("zAxisTickFormat");this.zAxisTickColor="rgb(204,204,204)";b.push("zAxisTickColor");this.zAxisExact=false;b.push("zAxisExact");this.zAxisValues=[];this.zAxisValuesRaw=[];this.zAxisMinorValues=[];this.zAxisTransform=false;b.push("zAxisTransform");this.zAxisCeilValue=null;b.push("zAxisCeilValue");this.zAxisFloorValue=null;b.push("zAxisFloorValue");this.zAxisTransformTicks=true;b.push("zAxisTransformTicks");this.zAxisShow=true;b.push("zAxisShow");this.zAxisTicks=10;this.rAxisAbsMax=null;this.rAxisAbsMin=null;this.rAxisMaxStrLength=false;this.rAxisTickFormat=false;b.push("rAxisTickFormat");this.rAxisTickColor=this.foreground;b.push("rAxisTickColor");this.rAxisValues=[];b.push("rAxisValues");this.rAxisValuesRaw=[];this.rAxisMinorValues=[];b.push("rAxisMinorValues");this.rAxisPercentShow=true;b.push("rAxisPercentShow");this.rAxisShow=true;b.push("rAxisShow");this.rAxisLabelOrientation="perpendicular";b.push("rAxisLabelOrientation");this.rAxisTicks=5;b.push("rAxisTicks");this.rAxisMinorTicks=true;b.push("rAxisMinorTicks");this.rAxisMajorTicks=true;b.push("rAxisMajorTicks");this.axisTickColor=this.foreground;b.push("axisTickColor");this.axisTickThickness=1;b.push("axisTickThickness");this.axisMinMaxTickThickness=1;b.push("axisMinMaxTickThickness");this.axisTickFontStyle="";b.push("axisTickFontStyle");this.axisTickFontSize=12;b.push("axisTickFontSize");this.axisTickScaleFontFactor=1;b.push("axisTickScaleFontFactor");this.axisTitleColor=this.foreground;b.push("axisTitleColor");this.axisTitleFontStyle="";b.push("axisTitleFontStyle");this.axisTitleFontSize=12;b.push("axisTitleFontSize");this.axisTitleScaleFontFactor=1;b.push("axisTitleScaleFontFactor");this.axisExtension=0.1;b.push("axisExtension");this.axisAlgorithm="wilkinson";b.push("axisAlgorithm");this.axisWilkinsonLoose=false;b.push("axisWilkinsonLoose");this.setMax=null;this.setMin=null;this.guides=false;b.push("guides");this.guidesWidth=0.3;b.push("guidesWidth");this.guidesColor="rgb(204,204,204)";b.push("guidesColor");this.blockContrast=false;b.push("blockContrast");this.plotByVariable=false;b.push("plotByVariable");this.is3DPlot=false;b.push("is3DPlot");this.showDataValues=false;b.push("showDataValues");this.jitter=true;b.push("jitter");this.jitterColumns=7;b.push("jitterColumns");this.objectBorderColor="rgb(0,0,0)";b.push("objectBorderColor");this.lineDecoration="symbol";b.push("lineDecoration");this.lineErrorType="bar";b.push("lineErrorType");this.coordinateLineColor=false;b.push("coordinateLineColor");this.lineType="rect";b.push("lineType");this.tension=0.3;b.push("tension");this.tensionSegments=16;b.push("tensionSegments");this.parallelCoordinates=[];this.boxPlotOutliersRatio=8;b.push("boxPlotOutliersRatio");this.showBoxplotOriginalData=false;b.push("showBoxplotOriginalData");this.showViolinBoxplot=false;b.push("showViolinBoxplot");this.boxplotDataPointTransparency=0.5;b.push("boxplotDataPointTransparency");this.boxplotMedianColor="rgb(0,0,0)";b.push("boxplotMedianColor");this.boxplotMedianWidth=1;b.push("boxplotMedianWidth");this.boxplotMean=false;b.push("boxplotMean");this.boxplotMeanColor="rgb(255,215,0)";b.push("boxplotMeanColor");this.boxplotMeanColorBorder="rgb(255,0,0)";b.push("boxplotMeanColorBorder");this.boxplotConnect=false;b.push("boxplotConnect");this.boxplotConnectWidth=2;b.push("boxplotConnectWidth");this.areaType="normal";b.push("areaType");this.dotplotType="normal";b.push("dotplotType");this.barType="normal";b.push("barType");this.barLollipopFactor=3;b.push("barLollipopFactor");this.sankeyNodeWidth=20;b.push("sankeyNodeWidth");this.sankeyIterations=32;this.sankeySource=false;b.push("sankeySource");this.sankeyTarget=false;b.push("sankeyTarget");this.sankeyColor="rgba(150,150,150,0.5)";b.push("sankeyColor");this.sankeyCoordinateColor=false;b.push("sankeyCoordinateColor");this.hierarchy=[];b.push("hierarchy");this.hierarchyVar=false;b.push("hierarchyVar");this.hierarchyVarIndex=0;this.treeNodeSize=20;b.push("treeNodeSize");this.treeLinkColor="rgb(150,150,150)";b.push("treeLinkColor");this.treeLinkWidth=1;b.push("treeLinkWidth");this.treeCircular=false;b.push("treeCircular");this.treeInverted=false;b.push("treeInverted");this.treeVarIndex=0;b.push("treeVarIndex");this.treeNodeId=0;this.colorBy=false;b.push("colorBy");this.colorByShowLegend=true;b.push("colorByShowLegend");this.colorKey=false;b.push("colorKey");this.shapeBy=false;b.push("shapeBy");this.shapeByShowLegend=true;b.push("shapeByShowLegend");this.shapeKey=false;b.push("shapeKey");this.shapeByData=false;b.push("shapeByData");this.shapeByShape=false;b.push("shapeByShape");this.sizeBy=false;b.push("sizeBy");this.sizeByContinuous=false;b.push("sizeByContinuous");this.sizeByShowLegend=true;b.push("sizeByShowLegend");this.sizeKey=false;b.push("sizeKey");this.sizeByData=false;b.push("sizeByData");this.outlineBy=false;b.push("outlineBy");this.outlineByShowLegend=true;b.push("outlineByShowLegend");this.outlineByData=false;b.push("outlineByData");this.patternBy=false;b.push("patternBy");this.patternByShowLegend=true;b.push("patternByShowLegend");this.patternKey=false;b.push("patternKey");this.patternByData=false;b.push("patternByData");this.connectBy=false;b.push("connectBy");this.connectByColor="rgb(204,204,204)";b.push("connectByColor");this.connectByWidth=2;b.push("coonnectByWidth");this.connectByData={};this.treemapBy=[];b.push("treemapBy");this.motionBy=false;b.push("motionBy");this.ellipseBy=false;b.push("ellipseBy");this.motionCurrentColor="rgba(0,0,0,0.3)";b.push("motionCurrentColor");this.motionCurrentFontStyle="";b.push("motionCurrentFontStyle");this.motionCurrentFontSize=60;b.push("motionCurrentFontSize");this.motionCurrentScaleFontFactor=1;b.push("motionCurrentScaleFontFactor");this.scatterType=false;b.push("scatterType");this.scatterAxesEqual=false;b.push("scatterAxesEqual");this.scatterOutlineThreshold=50000;b.push("scatterOutlineThreshold");this.functionIntervals=25;b.push("functionIntervals");this.selectDataMode="area";b.push("selectDataMode");this.selectDataModeDescription=false;b.push("selectDataModeDescription");this.selectDataPoint=[];this.hideDataPoint=[];this.isSelectDataPoints=0;this.contourType="overlay";b.push("contourType");this.contourXBinSize=false;b.push("contourXBinSize");this.contourYBinSize=false;b.push("contourYBinSize");this.contourZBinSize=false;b.push("contourZBinSize");this.isHistogram=false;b.push("isHistogram");this.histogramBarWidth=false;this.histogramBins=false;b.push("histogramBins");this.histogramStagger=false;b.push("histogramStagger");this.showHistogramDensity=false;b.push("showHistogramDensity");this.histogramDensityKernel="epanechnikovKernel";b.push("histogramDensityKernel");this.isCreateHistogram=false;this.loessDegree=2;b.push("loessDegree");this.loessSteps=30;b.push("loessSteps");this.loessSurfaceSteps=30;b.push("loessSurfaceSteps");this.loessBandwidth=0.8;b.push("loessBandwidth");this.loessSpan=0.8;b.push("loessSpan");this.loessIterations=1;this.loessAccuracy=1e-12;this.showLoessFit=false;b.push("showLoessFit");this.loessColor="rgb(255,215,0)";b.push("loessColor");this.showLoessConfidence=false;b.push("showLoessConfidence");this.loessConfidenceColor="rgba(255,215,0,0.3)";b.push("loessConfidenceColor");this.maxDOENumber=8;b.push("maxDOENumber");this.includeDOE=[];b.push("includeDOE");this.showDOEData=true;b.push("showDOEData");this.scatterPlotMatrix=false;b.push("scatterPlotMatrix");this.scatterPlotMatrixType="completeBoth";b.push("scatterPlotMatrixType");this.xRotate=45;b.push("xRotate");this.yRotate=0;b.push("yRotate");this.zRotate=0;b.push("zRotate");this.x3DRatio=1;b.push("x3DRatio");this.y3DRatio=1;b.push("y3DRatio");this.z3DRatio=1;b.push("z3DRatio");this.show3DGrid=true;b.push("show3DGrid");this.rotationSensitivity=450;b.push("rotationSensitivity");this.rotationStep=2;b.push("rotationStep");this.perspectiveFactor=2.2;b.push("perspectiveFactor");this.varIndicesStart=-1;this.smpIndicesStart=-1;this.isMultidimensionalData=false;this.heatmapAutoAdjust=false;b.push("heatmapAutoAdjust");this.heatmapCellBox=true;b.push("heatmapCellBox");this.heatmapCellBoxColor="rgb(220,220,220)";b.push("heatmapCellBoxColor");this.heatmapCellBoxWidth=0.5;b.push("heatmapCellBoxWidth");this.heatmapCellBoxColorHighlight="rgb(255,215,0)";b.push("heatmapCellBoxColorHighlight");this.heatmapCellBoxHighlightWidth=1;b.push("heatmapCellBoxHighlightWidth");this.heatmapSmpSeparateBy=false;b.push("heatmapSmpSeparateBy");this.heatmapVarSeparateBy=false;b.push("heatmapVarSeparateBy");this.heatmapSeparatorThickness=2.5;b.push("heatmapSeparatorThickness");this.varTitleLabelPosition="bottom";b.push("varTitleLabelPosition");this.showHeatmapIndicator=true;b.push("showHeatmapIndicator");this.heatmapIndicatorHeight=20;b.push("heatmapIndicatorHeight");this.heatmapIndicatorWidth=160;b.push("heatmapIndicatorWidth");this.adjustAspectRatioHeatmapIndicator=true;b.push("adjustAspectRatioHeatmapIndicator");this.heatmapIndicatorPosition="top";b.push("heatmapIndicatorPosition");this.heatmapIndicatorHistogram=false;b.push("heatmapIndicatorHistogram");this.heatmapIndicatorHistogramColor="rgb(0,255,255)";b.push("heatmapIndicatorHistogramColor");this.isOncoprint=false;b.push("isOncoprint");this.oncoprintCode=false;b.push("oncoprintCode");this.oncoprintAmplification=3;b.push("oncoprintAmplification");this.oncoprintDeletion=1;b.push("oncoprintDeletion");this.treemapBorderWidth=3;b.push("treemapBorderWidth");this.treemapBorderColor="rgb(204,204,204)";b.push("treemapBorderColor");this.correlationAxis="samples";b.push("correlationAxis");this.correlationAnchorLegend=false;b.push("correlationAnchorLegend");this.correlationAnchorLegendAlignWidth=40;b.push("correlationAnchorLegendAlignWidth");this.correlationLabelInterval=1;b.push("correlationLabelInterval");this.showVarDendrogram=true;b.push("showVarDendrogram");this.varDendrogramNewick=false;b.push("varDendrogramNewick");this.varDendrogramPosition="top";b.push("varDendrogramPosition");this.colorVarDendrogramBy=false;b.push("colorVarDendrogramBy");this.showSmpDendrogram=true;b.push("showSmpDendrogram");this.smpDendrogramNewick=false;b.push("smpDendrogramNewick");this.smpDendrogramPosition="left";b.push("smpDendrogramPosition");this.colorSmpDendrogramBy=false;b.push("colorSmpDendrogramBy");this.dendrogramHeight=50;b.push("dendrogramHeight");this.dendrogramColor="rgb(0,0,0)";b.push("dendrogramColor");this.distance="euclidian";b.push("distance");this.linkage="complete";b.push("linkage");this.clusterAxis="samples";this.kmeansVarClusters=3;b.push("kmeansVarClusters");this.kmeansSmpClusters=3;b.push("kmeansSmpClusters");this.maxIterations=100;b.push("maxIterations");this.imputeMethod="mean";b.push("imputeMethod");this.samplesClustered=false;b.push("samplesClustered");this.variablesClustered=false;b.push("variablesClustered");this.samplesKmeaned=false;b.push("samplesKmeaned");this.variablesKmeaned=false;b.push("variablesKmeaned");this.vennLegendColors=false;b.push("vennLegendColors");this.vennGroups=4;b.push("vennGroups");this.vennCompartments=["A","B","AB","C","AC","BC","ABC","D","AD","BD","CD","ABD","ACD","BCD","ABCD"];b.push("vennCompartments");this.vennColors=[];b.push("vennColors");this.pieType="separated";b.push("pieType");this.pieSegmentPrecision=0;b.push("pieSegmentPrecision");this.pieSegmentSeparation=1;b.push("pieSegmentSeparation");this.pieSegmentLabels="inside";b.push("pieSegmentLabels");this.pieLabelType="percentage";b.push("pieLabelType");this.maxPieSectors=20;b.push("maxPieSectors");this.showPieGrid=true;b.push("showPieGrid");this.showPieValues=true;b.push("showPieValues");this.showPieSampleLabel=true;b.push("showPieSampleLabel");this.startPieSectors=0;b.push("startPieSectors");this.pieInnerRadius=0;b.push("pieInnerRadius");this.pieColors=[];b.push("pieColors");this.circularType="normal";b.push("circularType");this.chordThickness=28;b.push("chordThickness");this.chordColor="source";b.push("chordColor");this.bubbleColor="rgba(150,150,150,0.33)";b.push("bubbleColor");this.circularCenterProportion=0.3;b.push("circularCenterProportion");this.arcSegmentsSeparation=8;b.push("arcSegmentsSeparation");this.circularRotate=0;b.push("circularRotate");this.circularArc=360;b.push("circularArc");this.ringSeparation=5;b.push("ringSeparation");this.ringGraphType=[];b.push("ringGraphType");this.ringGraphWeight=[];b.push("ringGraphWeight");this.arcSegmentsRadius=[];b.push("arcSegmentsRadius");this.ringsOrder=[];b.push("ringsOrder");this.rAxis=false;b.push("rAxis");this.rAxisZero=false;b.push("rAxisZero");this.showRingLegend=true;b.push("showRingLegend");this.showCircularConnections=true;b.push("showCircularConnections");this.connections=[];b.push("connections");this.circularLetterSeparationFactor=1.5;b.push("circularLetterSeparationFactor");this.circularConnectionsTransparency=0.5;b.push("circularConnectionsTransparency");this.smpLabelOrientation="perpendicular";b.push("smpLabelOrientation");this.circularLabelsAlign="outside";b.push("circularLabelsAlign");this.circularScalesAlign="inside";b.push("circularScalesAlign");this.circularAnchorsAlign="inside";b.push("circularAnchorsAlign");this.circularAnchors2Align="outside";b.push("circularAnchors2Align");this.circularDataPosition="distributed";b.push("circularDataPosition");this.circularAnchorLength=15;b.push("circularAnchorLength");this.circularAnchorColor="rgb(0,0,255)";b.push("circularAnchorColor");this.showIdeogram=false;b.push("showIdeogram");this.ideogram="hg19";b.push("ideogram");this.ideogramChromosome="chr";b.push("ideogramChromosome");this.ideogramChromosomePosition="pos";b.push("ideogramChromosomePosition");this.tagCloudTextWeightFactor=1;b.push("tagCloudTextWeightFactor");this.tagCloudTextGridSize=8;b.push("tagCloudTextGridSize");this.tagCloudTextEllipticity=0.65;b.push("tagCloudTextEllipticity");this.tagCloudTextRotateRatio=0.1;b.push("tagCloudTextRotateRatio");this.tagCloudGridPoints=[];this.showVolume=true;b.push("showVolume");this.stockIndicators=["Sma5","Sma10","Sma25"];b.push("stockIndicators");this.sma5Color="rgb(255,0,0)";b.push("sma5Color");this.sma10Color="rgb(0,255,0)";b.push("sma10Color");this.sma20Color="rgb(0,0,255)";b.push("sma20Color");this.sma25Color="rgb(255,0,255)";b.push("sma25Color");this.sma50Color="rgb(0,0,0)";b.push("sma50Color");this.calculateLayout=true;b.push("calculateLayout");this.networkFreeze=false;b.push("networkFreeze");this.networkFreezeOnLoad=false;b.push("networkFreezeOnLoad");this.preScaleNetwork=false;b.push("preScaleNetwork");this.subNetworks=false;this.networkLayoutType="forceDirected";b.push("networkLayoutType");this.networkRoot=false;b.push("networkRoot");this.showNetworkRadialLayout=false;b.push("showNetworkRadialLayout");this.networkDepth=0;this.networkDivisions=0;this.is3DNetwork=false;b.push("is3DNetwork");this.network2DRotate=0;this.networkNodesOnTop=true;b.push("networkNodesOnTop");this.moveParentsWithChildren=false;b.push("moveParentsWithChildren");this.highlightNode=[];b.push("highlightNode");this.nodeHighlightColor="rgb(255,0,0)";b.push("nodeHighlightColor");this.selectNode={};this.isSelectNodes=0;this.showNodeNameThreshold=50;b.push("showNodeNameThreshold");this.nodeSize=30;this.edgeThickness=1;b.push("edgeThickness");this.labelNodePosition="auto";b.push("labelNodePosition");this.nodeFontStyle="";b.push("nodeFontStyle");this.nodeFontSize=20;b.push("nodeFontSize");this.nodeFontColor=this.foreground;b.push("nodeFontColor");this.nodeScaleFontFactor=1;b.push("nodeScaleFontFactor");this.layoutTime=1500;this.networkForceConstant=null;this.initialTemperature=0;this.temperature=0;this.networkNodeMinDistance=4;b.push("networkNodeMinDistance");this.attractiveForceFunction="FruchtermanReingold";b.push("attractiveForceFunction");this.repulsiveForceFunction="square";b.push("repulsiveForceFunction");this.colorNodeBy=false;b.push("colorNodeBy");this.shapeNodeBy=false;b.push("shapeNodeBy");this.sizeNodeBy=false;b.push("sizeNodeBy");this.patternNodeBy=false;b.push("patternNodeBy");this.colorEdgeBy=false;b.push("colorEdgeBy");this.sizeEdgeBy=false;b.push("sizeEdgeBy");this.showNetworkCommunities=false;b.push("showNetworkCommunities");this.calculateNetworkCommunities=true;b.push("calculateNetworkCommunities");this.coordinateNetworkConvexHullCommunityColor=false;b.push("coordinateNetworkConvexHullCommunityColor");this.hullScale=1.25;b.push("hullScale");this.networkCommunities=null;this.networkConvexHulls=[];this.genomeTicks=50;b.push("genomeTicks");this.trackNameFontStyle="";b.push("trackNameFontStyle");this.trackNameFontSize=10;b.push("trackNameFontSize");this.trackNameFontColor=this.foreground;b.push("trackNameFontColor");this.trackFillColor=this.background;b.push("trackFillColor");this.trackDirColor=this.foreground;b.push("trackDirColor");this.subtracksMaxDefault=8;b.push("subtracksMaxDefault");this.showFeatureNameThereshold=20;b.push("showFeatureNameThereshold");this.featureNameFontStyle="";b.push("featureNameFontStyle");this.featureNameFontSize=10;b.push("featureNameFontSize");this.featureNameFontColor=this.foreground;b.push("featureNameFontColor");this.featureFillColor=this.background;b.push("featureFillColor");this.featureDirColor=this.foreground;b.push("featureDirColor");this.maxFeatureStringLen=30;b.push("maxFeatureStringLen");this.featureWidthDefault=3;b.push("featureWidthDefault");this.featureHeightDefault=14;b.push("featureHeightDefault");this.featureTraceHeight=40;b.push("featureTraceHeight");this.featureTraceTrim=1;b.push("featureTraceTrim");this.featureTracesShow=true;b.push("featureTracesShow");this.featureQualityHeight=12;b.push("featureQualityHeight");this.featureQualityValues=false;b.push("featureQualityValues");this.featureQualityShow=true;b.push("featureQualityShow");this.featureSignalToNoiseHeight=12;b.push("featureSignalToNoiseHeight");this.featureSignalToNoiseValues=false;b.push("featureSignalToNoiseValues");this.featureSignalToNoiseShow=true;b.push("featureSignalToNoiseShow");this.featureCoordinateHeight=12;b.push("featureCoordinateHeight");this.featureCoordinateShow=true;b.push("featureCoordinateShow");this.featureTranslateHeight=12;b.push("featureTranslateHeight");this.featureTranslateShow=true;b.push("featureTranslateShow");this.featureTypeDefault="line";b.push("featureTypeDefault");this.featureStaggered=false;b.push("featureStaggered");this.sequenceFontStyle="";b.push("sequenceFontStyle");this.sequenceFontSize=10;b.push("sequenceFontSize");this.sequenceFill=false;b.push("sequenceFill");this.sequenceGAPColor="rgb(255,0,255)";b.push("sequenceGAPColor");this.sequenceAColor="rgb(0,103,0)";b.push("sequenceAColor");this.sequenceBColor="rgb(0,0,0)";b.push("sequenceBColor");this.sequenceCColor="rgb(0,0,255)";b.push("sequenceCColor");this.sequenceDColor="rgb(0,0,0)";b.push("sequenceDColor");this.sequenceEColor="rgb(0,0,0)";b.push("sequenceEColor");this.sequenceFColor="rgb(0,0,255)";b.push("sequenceFColor");this.sequenceGColor="rgb(0,0,0)";b.push("sequenceGColor");this.sequenceHColor="rgb(255,0,0)";b.push("sequenceHColor");this.sequenceIColor="rgb(0,103,0)";b.push("sequenceIColor");this.sequenceKColor="rgb(255,0,0)";b.push("sequenceKColor");this.sequenceLColor="rgb(0,103,0)";b.push("sequenceLColor");this.sequenceMColor="rgb(0,103,0)";b.push("sequenceMColor");this.sequenceNColor="rgb(0,0,0)";b.push("sequenceNColor");this.sequencePColor="rgb(255,165,0)";b.push("sequencePColor");this.sequenceQColor="rgb(0,0,0)";b.push("sequenceQColor");this.sequenceRColor="rgb(255,0,0)";b.push("sequenceRColor");this.sequenceSColor="rgb(255,165,0)";b.push("sequenceSColor");this.sequenceTColor="rgb(255,0,0)";b.push("sequenceTColor");this.sequenceUColor="rgb(255,0,0)";b.push("sequenceUColor");this.sequenceVColor="rgb(0,103,0)";b.push("sequenceVColor");this.sequenceWColor="rgb(0,0,255)";b.push("sequenceWColor");this.sequenceXColor="rgb(0,0,0)";b.push("sequenceXColor");this.sequenceYColor="rgb(0,0,255)";b.push("sequenceYColor");this.sequenceZColor="rgb(0,0,0)";b.push("sequenceZColor");this.sequenceStartColor="rgb(0,204,0)";b.push("sequenceStartColor");this.sequenceEndColor="rgb(255,0,0)";b.push("sequenceEndColor");this.wireColor="rgba(204,204,204,0.1)";b.push("wireColor");this.periodTicksLabels=5;b.push("periodTicksLabels");this.genomeResolution="low";this.trackConfigurableProperties=["name","hideName","hideFeatureNames","type","height","fill","outline","hide","connect","subtracksMax","highlight"];b.push("trackConfigurableProperties");this.featureConfigurableProperties=["id","name","label","hideName","fill","outline","dir","showDir","connect","offset","data","subtype","quality","signalToNoise","coordinate","sequence","trace","gaps","translate","hide","counter"];b.push("featureConfigurableProperties");this.errors=[];this.debug=false;b.push("debug");this.showVersion=true;b.push("showVersion");this.showCode=false;b.push("showCode");this.codeType="params";b.push("codeType");this.disableMenu=false;b.push("disableMenu");this.disableToolbar=false;b.push("disableToolbar");this.disableTouchToolbar=false;b.push("disableTouchToolbar");this.disableDataTable=false;b.push("disableDataTable");this.disableDataFilters=false;b.push("disableDataFilters");this.disableConfigurator=false;b.push("disableConfigurator");this.resizable=true;b.push("resizable");this.resizableX=true;b.push("resizableX");this.resizableY=true;b.push("resizableY");this.movable=true;b.push("movable");this.maxSubMenus=20;b.push("maxSubMenus");this.maxItemMenuCheckbox=10;b.push("maxItemMenuCheckbox");this.showAdvancedConfiguration=false;b.push("showAdvancedConfiguration");this.showFadeResizeMoveAnimation=true;b.push("showFadeResizeMoveAnimation");this.configuratorWidth=250;b.push("configuratorWidth");this.configuratorExamplesSize=400;b.push("configuratorExamplesSize");this.alignConfiguratorExamples=false;b.push("alignConfiguratorExamples");this.showConfiguratorExamplesOnSelect=false;b.push("showConfiguratorExamplesOnSelect");this.dataFilterWidth=180;b.push("dataFilterWidth");this.resizeWidthOnLayout=true;b.push("resizeWidthOnLayout");this.resizeHeightOnLayout=true;b.push("resizeHeightOnLayout");this.disableEvents=false;b.push("disableEvents");this.eventKeys=true;b.push("eventKeys");this.eventArrowKeys=true;b.push("eventArrowKeys");this.eventPlusMinusKeys=false;b.push("eventPlusMinusKeys");this.helpKeyEvents=false;b.push("helpKeyEvents");this.skipClick=false;this.infoTimeOut=3000;b.push("infoTimeOut");this.infoStartTime=new Date().getTime();this.infoTimeIn=50;b.push("infoTimeIn");this.broadcast=true;b.push("broadcast");this.broadcastType="var";b.push("broadcastType");this.showAnimation=false;b.push("showAnimation");this.showTransition=false;b.push("showTransition");this.transitionTime=1000;b.push("transitionTime");this.transitionStep=10;b.push("transitionStep");this.transitionStaggering=10;b.push("transitionStaggering");this.transitionFunction="easeInOutQuad";b.push("transitionFunction");this.weight=1;this.scaleX=1;this.scaleY=1;this.translateX=0;this.translateY=0;this.offsetX=0;this.offsetY=0;this.layoutWidth=0;this.layoutHeight=0;this.layout="1X1";this.layoutTopology=false;b.push("layoutTopology");this.layoutComb=false;this.layoutAdjust=false;b.push("layoutAdjust");this.layoutCollapse=false;b.push("layoutCollapse");this.layoutRemoveEmpty=true;b.push("layoutRemoveEmpty");this.layoutCanvasCompartments=false;b.push("layoutCanvasCompartments");this.layoutBoxLabelColors=[];b.push("layoutBoxLabelColors");this.layoutBoxShow=true;b.push("layoutBoxShow");this.layoutCurrent=0;this.layoutAxis=3;this.imageDir="";b.push("imageDir");this.loadingImage="loading1";b.push("loadingImage");this.remoteService=false;b.push("remoteService");this.remoteServiceType="webService";b.push("remoteServiceType");this.remoteParams={};b.push("remoteParams");this.remoteDirection="next";b.push("remoteDirection");this.remoteAutoPlay=false;b.push("remoteAutoPlay");this.remoteAutoPlayDelay=3000;b.push("remoteAutoPlayDelay");this.remoteParamOverride=true;b.push("remoteParamOverride");this.remoteUpdate=false;b.push("remoteUpdate");this.remoteUpdateDelay=10000;b.push("remoteUpdateDelay");this.remoteParentId="";this.remoteDataIndex=0;this.remoteIds=[];this.remoteData=[];this.remoteUpdating=false;this.RdatasetsURL="https://raw.githubusercontent.com/neuhausi/Rdatasets/master/";this.loadRDatasets=false;b.push("loadRDatasets");this.skipConfigurableProperties=true;b.push("skipConfigurableProperties");this.nodesProperties=[];b.push("nodesProperties");this.edgesProperties=[];b.push("edgesProperties");this.featuresProperties=[];b.push("featuresProperties");this.filterType="and";b.push("filterType");this.filterSkipNullKeys=false;b.push("filterSkipNullKeys");this.filterSkipNullValues=false;b.push("filterSkipNullValues");this.filterVarBy=[];b.push("filterVarBy");this.filterVarByOp=[];b.push("filterVarByOp");this.filterVarByValue=[];b.push("filterVarByValue");this.filterVarByCase=[];b.push("filterVarByCase");this.filteredVarIndices=[];b.push("filteredVarIndices");this.filterSmpBy=[];b.push("filterSmpBy");this.filterSmpByOp=[];b.push("filterSmpByOp");this.filterSmpByValue=[];b.push("filterSmpByValue");this.filterSmpByCase=[];b.push("filterSmpByCase");this.filteredSmpIndices=[];b.push("filteredSmpIndices");this.filterNodeBy=[];b.push("filterNodeBy");this.filterNodeByOp=[];b.push("filterNodeByOp");this.filterNodeByValue=[];b.push("filterNodeByValue");this.filterNodeByCase=[];b.push("filterNodeByCase");this.filterEdgeBy=[];b.push("filterEdgeBy");this.filterEdgeByOp=[];b.push("filterEdgeByOp");this.filterEdgeByValue=[];b.push("filterEdgeByValue");this.filterEdgeByCase=[];b.push("filterEdgeByCase");this.filterFeatureBy=[];b.push("filterFeatureBy");this.filterFeatureByOp=[];b.push("filterFeatureByOp");this.filterFeatureByValue=[];b.push("filterFeatureByValue");this.filterFeatureByCase=[];b.push("filterFeatureByCase");this.showDataTable=false;b.push("showDataTable");this.dataTableTransposed=true;b.push("dataTableTransposed");this.maxRows=10;b.push("maxRows");this.maxCols=6;b.push("maxCols");this.colWidth=100;b.push("colWidth");this.rowHeight=18;b.push("rowHeight");this.freezeColLeft=0;b.push("freezeColLeft");this.freezeColRight=0;b.push("freezeColRight");this.freezeRowTop=0;b.push("freezeRowTop");this.freezeRowBottom=0;b.push("freezeRowBottom");this.refresehDataTableOnDraw=false;b.push("refresehDataTableOnDraw");this.showDataTableOnSelect=false;b.push("showDataTableOnSelect");this.networkShowDataTable="nodes";b.push("networkShowDataTable");this.colorDataTable=true;b.push("colorDataTable");this.colorDataTableTransparency=0.5;b.push("colorDataTableTransparency");this.startCol=0;this.startRow=0;this.dataTableColumnWidth=[];this.dataTableRowHeight=[]};this.updateTheme=function(b){for(var e in b){if(e=="conditional"){for(var f in b[e]){if(this.isInArray(this.graphType,CanvasXpress.graphTypes[f])){for(var d in b[e][f]){this[d]=b[e][f][d]}}}}else{this[e]=b[e]}}};this.setTheme=function(){if(a&&a.hasOwnProperty("theme")&&a.theme&&CanvasXpress.themes.hasOwnProperty(a.theme)){this.updateTheme(CanvasXpress.themes[theme])}};this.resetInitialFontSize=function(){var b=["fontSize","titleFontSize","subtitleFontSize","citationFontSize","smpTitleFontSize","smpLabelFontSize","varTitleFontSize","varLabelFontSize","overlayFontSize","legendFontSize","decorationFontSize","axisTickFontSize","axisTitleFontSize","nodeFontSize","trackNameFontSize","featureNameFontSize","sequenceFontSize"];for(var c=0;c<b.length;c++){this[b[c]]=Number(CanvasXpress.doc.P[b[c]].D)}this.setInitialFonts()};this.setInitialFonts=function(){this.font=this.fontStyle+" "+this.fontSize+"px "+this.fontName;this.titleFont=this.titleFontStyle+" "+this.titleFontSize+"px "+this.fontName;this.subtitleFont=this.subtitleFontStyle+" "+this.subtitleFontSize+"px "+this.fontName;this.citationFont=this.citationFontStyle+" "+this.citationFontSize+"px "+this.fontName;this.smpTitleFont=this.smpTitleFontStyle+" "+this.smpTitleFontSize+"px "+this.fontName;this.smpLabelFont=this.smpLabelFontStyle+" "+this.smpLabelFontSize+"px "+this.fontName;this.varTitleFont=this.varTitleFontStyle+" "+this.varTitleFontSize+"px "+this.fontName;this.varLabelFont=this.varLabelFontStyle+" "+this.varLabelFontSize+"px "+this.fontName;this.overlayFont=this.overlayFontStyle+" "+this.overlayFontSize+"px "+this.fontName;this.legendFont=this.legendFontStyle+" "+this.legendFontSize+"px "+this.fontName;this.decorationFont=this.decorationFontStyle+" "+this.decorationFontSize+"px "+this.fontName;this.axisTickFont=this.axisTickFontStyle+" "+this.axisTickFontSize+"px "+this.fontName;this.axisTitleFont=this.axisTitleFontStyle+" "+this.axisTitleFontSize+"px "+this.fontName;this.motionCurrentFont=this.motionCurrentFontStyle+" "+this.motionCurrentFontSize+"px "+this.fontName;this.nodeFont=this.nodeFontStyle+" "+this.nodeFontSize+"px "+this.fontName;this.trackNameFont=this.trackNameFontStyle+" "+this.trackNameFontSize+"px "+this.fontName;this.featureNameFont=this.featureNameFontStyle+" "+this.featureNameFontSize+"px "+this.fontName;this.sequenceFont=this.sequenceFontStyle+" "+this.sequenceFontSize+"px "+this.fontName};this.setInitialConfig=function(){if(this.meta.config.user){for(var b in this.meta.config.user){if(CanvasXpress.doc.P[b]&&CanvasXpress.doc.P[b].hasOwnProperty("T")){if(CanvasXpress.doc.P[b].T=="integer"||CanvasXpress.doc.P[b].T=="float"){this.meta.config.user[b]=Number(this.meta.config.user[b])}this[b]=this.meta.config.user[b]}else{this[b]=this.meta.config.user[b]}}}};this.resetConfig=function(b){var d={};if(b){for(var c=0;c<b.length;c++){d[b[c]]=this[b[c]]}}this.setConfigDefaults();for(var c in d){this[c]=d[c]}};this.updateConfig=function(c){if(c){this.meta.config.user=c;for(var b in c){this[b]=c[b]}}};this.getConfig=function(){var l={};var c=CanvasXpress.config.sort();var g={colors:true,images:true,xAxisValues:true,xAxisValuesRaw:true,xAxisMinorValues:true,yAxisValues:true,yAxisValuesRaw:true,yAxisMinorValues:true,zAxisValues:true,zAxisValuesRaw:true,zAxisMinorValues:true,nodeConfigurableProperties:true,edgeConfigurableProperties:true,trackConfigurableProperties:true,featureConfigurableProperties:true};if(this.isTransformedData){l.isTransformedData=this.isTransformedData}for(var f=0;f<c.length;f++){var e=c[f];if(CanvasXpress.doc.P[e]&&CanvasXpress.doc.P[e].hasOwnProperty("D")){var h=CanvasXpress.doc.P[e].D;if(g[e]){continue}var b=this[e]===undefined?false:this[e];if(typeof(b)=="object"){if(h=="[]"){h=[]}if(h=="{}"){h={}}if(b===null){if(h!="null"){l[e]=b}}else{if(!this.isSameObject(b,h)){l[e]=b}}}else{if(h.match(/false|true|null/)){if(b.toString()!=h){l[e]=b}}else{if(b!=h){l[e]=b}}}}}return l};this.getUserConfig=function(){return this.meta.config.user};this.getNewCanvasContext=function(d){var b=this.$(d);if(!b||b.tagName.toLowerCase()!="canvas"){b=this.$cX("canvas",{id:d});document.body.appendChild(b)}return b.getContext("2d")};this.setCanvasPixelRatio=function(){var b=document.createElement("canvas").getContext("2d");var c=window.devicePixelRatio||1;var d=b.webkitBackingStorePixelRatio||b.mozBackingStorePixelRatio||b.msBackingStorePixelRatio||b.oBackingStorePixelRatio||b.backingStorePixelRatio||1;this.meta.canvas.canvasPixelRatio=c/d};this.setDPI=function(c,d){c.style.width=c.style.width||c.width+"px";c.style.height=c.style.height||c.height+"px";var h=d/96;var b=parseFloat(c.style.width);var i=parseFloat(c.style.height);var e=c.width/b;var g=h/e;var f=c.cloneNode(false);f.getContext("2d").drawImage(c,0,0);var j=c.getContext("2d");c.width=Math.ceil(b*h);c.height=Math.ceil(i*h);j.setTransform(g,0,0,g,0,0);j.drawImage(f,0,0);j.setTransform(h,0,0,h,0,0)};this.setCanvas=function(){var g=this.$(this.target);if(g){this.setCanvasPixelRatio();this.checkCanvasXpressOrgSite();this.meta.canvas.ctx=g.getContext("2d");this.meta.canvas.ctx.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);if((this.backgroundType=="video"||this.graphType=="Video")&&this.backgroundVideo){if(this.graphType=="Video"){this.backgroundType="video"}this.isVideo=true;var f=this.$cX("script",{type:"text/javascript",src:"../js/video.js"});var e=this.$cX("link",{type:"text/css",rel:"stylesheet",href:"../css/video-js.css"});var d=document.getElementsByTagName("head")[0];d.appendChild(e);d.appendChild(f);this.background="rgba(255,255,255,0)";this.legendBackgroundColor="rgba(255,255,255,0)";this.disableToolbar=true}else{if(this.graphType=="Map"){this.isMap=true;var d=[];if(this.topoJSON){for(var b in this.topoJSON){this.leafletJS.unshift(this.topoJSON[b])}}for(var b=0;b<this.leafletJS.length;b++){d.push(this.$cX("script",{type:"text/javascript",src:this.leafletJS[b]}))}for(var b=0;b<this.leafletCSS.length;b++){d.push(this.$cX("link",{type:"text/css",rel:"stylesheet",href:this.leafletCSS[b]}))}this.initLeaflet();CanvasXpress.loadScripts(d,this.leafletInit||this.leafletInitString||this.initializeLeaflet,this)}else{this.isVideo=false;this.isMap=false}}}};this.getCanvasContext=function(){var b;if(this.isSVG){b=this.meta.canvas.ctx5}else{if(this.isTransitionCanvas){b=this.transitionIter%2?this.meta.canvas.ctx3:this.meta.canvas.ctx4}else{b=this.isHighlightCanvas?this.meta.canvas.ctx2:this.isMapCanvas?this.meta.leaflet.ctx:this.meta.canvas.ctx}}this.currentCanvasContext=b.canvas.id;return b};this.checkCanvasXpressOrgSite=function(){var g=new RegExp("https://canvasxpress.org/js/");var d=document.getElementsByTagName("head")[0];for(var b=0;b<d.childNodes.length;b++){var f=d.childNodes[b];if(f.type=="text/javascript"&&g.test(f.src)){CanvasXpress.factory.siteSrc=true}}};this.inititalizeConfig=function(){CanvasXpress.config=[];this.setConfigDefaults();this.setTheme();if(a){for(var b=0;b<CanvasXpress.config.length;b++){var c=CanvasXpress.config[b];if(a.hasOwnProperty(c)){this[c]=a[c]}}}this.setInitialFonts();this.setCanvas()};this.inititalizeConfig()};CanvasXpress.prototype.initText=function(){this.setTextShadow=function(a){if(this.showTextShadow){if(a){this.meta.canvas.ctx.shadowOffsetX=this.shadowOffsetX;this.meta.canvas.ctx.shadowOffsetY=this.shadowOffsetY;this.meta.canvas.ctx.shadowBlur=this.shadowBlur;this.meta.canvas.ctx.shadowColor=this.shadowColor}else{this.meta.canvas.ctx.shadowOffsetX=0;this.meta.canvas.ctx.shadowOffsetY=0;this.meta.canvas.ctx.shadowBlur=0;this.meta.canvas.ctx.shadowColor=this.background}}};this.getArcTextArea=function(B,A,z,a,C,u,p,v,j,w,d,g){if(B==undefined){B=""}var q=["poly"];var o=this.getFontPt(p);var j=this.measureText(B,p)*(Math.PI*0.5)/a;C=(C+(u/2))-(j/2)%(Math.PI*2);u=C+j;var n=this.traceArc(A,z,a,C,u,true);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}n=this.traceArc(A,z,a-o,C,u);for(var k=0;k<n.length;k++){q.push(n[k][0],n[k][1])}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?q:this.adjustNetworkObjects(q)}else{return q}};this.drawArcText=function(B,z,w,a,C,p,o,q,j,v,g,h){this.functionCallerDraw="drawArcText";if(B==undefined){B=""}var A=this.getCanvasContext();if(B==null){return}if(!A){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(z)||isNaN(w)){if(this.debug){alert("Not a valid coordinate ("+z+", "+w+") to draw "+B)}return}if(!h&&!isNaN(B)){B=this.formatNumber(B)}if(!z){z=0}if(!w){w=0}if(!o){o=this.font}if(!q){q=this.foreground}if(!j){j=this.align}if(!v){v=this.baseline}this.saveCanvas();A.strokeStyle=this.isArray(q)?q[0]:q;A.fillStyle=this.isArray(q)?q[0]:q;A.font=o;A.textAlign=j;A.textBaseline=v;this.setTextShadow(true);var d=j=="right"?1:-1;var u=this.getFontPt(o);if(((["left","center"].indexOf(j)>-1)&&g)||(j=="right"&&!g)){B=B.split("").reverse().join("");if(this.isArray(q)){q=q.reverse()}}A.translate(z,w);C+=(Math.PI*!g);C+=(Math.PI/2)+(p/2);if(j=="center"){for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o);C+=((n+(k==B.length-1?0:this.circularLetterSeparationFactor))/(a-u))/2*-d}}p=C;this.rotateCanvas(C);for(var k=0;k<B.length;k++){var n=this.measureText(B[k],o);p+=(n/2)/(a-u)*d;this.rotateCanvas((n/2)/(a-u)*d);if(this.isArray(q)){A.strokeStyle=q[k];A.fillStyle=q[k]}A.fillText(B[k],0,(g?1:-1)*(0-a+u/2));p+=(n/2+this.circularLetterSeparationFactor)/(a-u)*d;this.rotateCanvas((n/2+this.circularLetterSeparationFactor)/(a-u)*d)}this.restoreCanvas();this.setTextShadow(false)};this.getTextMultipleArea=function(o,n,k,A,B,E,D,g,q,p,j){if(o==undefined){o=""}var r=o.split(/\n/);var w=this.getFontPt(A);var C=[];var F=k;for(var u=0;u<r.length;u++){C.push(this.getTextArea(r[u],n,F,A,B,E,D,g,q,p,j));F+=w+this.margin}var z=C[0][1];var e=C[0][2];var v=C[0][3];var d=C[0][4];for(var u=1;u<C.length;u++){z=Math.min(z,C[u][1]);e=Math.min(e,C[u][2]);v=Math.max(v,C[u][3]);d=Math.max(d,C[u][4])}return[C[0][0],z,e,v,d]};this.drawTextMultiple=function(B,z,u,p,r,w,v,e,h,C,A){this.functionCaller="drawTextMultiple";var j=B.split(/\n/);var d=p;var n=[];if(!d){d=this.font}var o=this.getFontPt(d);var q=u;for(var k=0;k<j.length;k++){this.drawText(j[k],z,q,d,r,w,v,e,h,C,A);q+=o+this.margin}};this.getTextArea=function(q,o,n,B,D,F,E,g,u,r,k){var j=this;var v=function(b){b.shift();var a=["poly"];a=a.concat(j.rotatePoint(b[0],b[1],o,n,g));a=a.concat(j.rotatePoint(b[2],b[1],o,n,g));a=a.concat(j.rotatePoint(b[2],b[3],o,n,g));a=a.concat(j.rotatePoint(b[0],b[3],o,n,g));return a};if(q==undefined){q=""}if(k){if(o<this.marginLeft+this.offsetX+this.left||o>this.marginLeft+this.offsetX+this.left+this.x){return}if(n<this.marginTop+this.offsetY+this.top||n>this.marginTop+this.offsetY+this.top+this.y){return}}if(this.isMultipleLines(q)){return this.getTextMultipleArea(q,o,n,B,D,F,E,g,u,r,k)}var G=[];var p=this.measureText(q,B);var z=this.getFontPt(B);var C,e,A,d;var i=0;if(u){while(p>u&&i<10){q=q.substring(0,q.length-1);p=this.measureText(q,B);i++}}if(F=="left"){C=o;A=C+p}else{if(F=="right"){C=o-p;A=o}else{C=o-(p/2);A=o+(p/2)}}if(E=="top"){e=n;d=e+z}else{if(E=="bottom"){e=n-z;d=n}else{e=n-(z/2);d=n+(z/2)}}G=["rect",C,e,A,d];G=g?v(G):G;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?G:this.adjustNetworkObjects(G)}else{return G}};this.drawText=function(z,q,n,j,k,p,o,d,e,A,u){this.functionCallerDraw="drawText";if(z==undefined){z=""}var v=this.getCanvasContext();var i=0;if(z==null){return}if(this.isMultipleLines(z)){return this.drawTextMultiple(z,q,n,j,k,p,o,d,e,A,u)}if(!v){if(this.debug){alert("Dude, there is no canvas")}return}if(isNaN(q)||isNaN(n)){if(this.debug){alert("Not a valid coordinate ("+q+", "+n+") to draw "+z)}return}if(u){if(q<this.marginLeft+this.offsetX+this.left||q>this.marginLeft+this.offsetX+this.left+this.x){return}if(n<this.marginTop+this.offsetY+this.top||n>this.marginTop+this.offsetY+this.top+this.y){return}}if(!q){q=0}if(!n){n=0}if(!j){j=this.font}if(!k){k=this.foreground}if(!p){p=this.align}if(!o){o=this.baseline}var r=this.measureText(z,j);var g=this.getFontPt(j);if(e){while(r>e&&i<10){z=z.substring(0,z.length-1);r=this.measureText(z,j);i++}}this.saveCanvas();v.strokeStyle=k;v.fillStyle=k;v.font=j;this.translateCanvas(q,n);v.textAlign=p;v.textBaseline=o;this.setTextShadow(true);if(d){this.rotateCanvas(d)}if(A){v.strokeText(z,0,0)}else{v.fillText(z,0,0)}this.restoreCanvas();this.setTextShadow(false)};this.isMultipleLines=function(b){var a=b.toString().split(/\n/);return a.length-1};this.capitalize=function(a){if(a){return a.charAt(0).toUpperCase()+a.slice(1)}};this.decapitalize=function(a){if(a){return a.charAt(0).toLowerCase()+a.slice(1)}};this.measureTextMultiple=function(e,g){var c=e.split(/\n/);var a=0;var b=this.getCanvasContext();if(!b){return 0}if(!g){g=this.font}b.font=g;for(var d=0;d<c.length;d++){a=Math.max(a,b.measureText(c[d]).width)}return a};this.measureText=function(b,c){var a=this.getCanvasContext();if(!b||!a){return 0}b=b.toString();if(!c){c=this.font}if(!CanvasXpress.cacheText[c]){CanvasXpress.cacheText[c]={}}if(!CanvasXpress.cacheText[c][b]){a.font=c;if(this.isMultipleLines(b)){CanvasXpress.cacheText[c][b]=this.measureTextMultiple(b,c)}else{CanvasXpress.cacheText[c][b]=a.measureText(b).width}}return CanvasXpress.cacheText[c][b]};this.measureTextWidth=function(a,b){l=this.isMultipleLines(a);if(l>0){return(this.getFontPt(b)+this.margin)*(l+1)}else{return this.getFontPt(b)}};this.scaleTextToFont=function(b,e,a,c){var d=this.fontStyle+" "+e+"px "+this.fontName;if(b){while(this.measureText(b,d)>a&&e>=this.minTextSize){e-=2;d=this.fontStyle+" "+e+"px "+this.fontName}if(c){while(parseInt(e/1.33)>c-2){e--}d=this.fontStyle+" "+e+"px "+this.fontName}}return d};this.getFontPt=function(a){return a?Math.max(1,parseInt(a.toString().match(/[\-\d]+/)[0])):1};this.scaleTextToSize=function(a){var d=this.scaleTextConstantMult;if(!a){a=1}return Math.ceil(1/Math.sqrt(a)*d)};this.scaleFont=function(a,b){var d=this.getFontPt(a);var c=Math.max(1,parseInt(d*b));return a.replace(d+"px",c+"px")};this.correctPrecisionBug=function(b){var a=b.toString();if(a.match(/\.\d+00000+\d+$/)){a=a.replace(/00000+\d+$/,"")}else{if(a.match(/\.\d+99999+\d+$/)){a=a.replace(/99999+\d+$/,"9")}}return Number(a)};this.formatNumber=function(b,a){if(a&&Math.abs(b)<99999){return sprintf("%."+a+"f",Number(b)).toString()}else{if(Math.abs(b)<0.0001||Math.abs(b)>99999||b.toString().length>=8){return Number(b).toExponential(2).toString().replace("e+0","").replace(".00","")}else{return b.toString()}}};this.bestFormatNumber=function(b,a){if(typeof b==="number"&&b%1==0){return b}else{if(a!=null&&a<1){return sprintf("%.0f",Number(b))}else{if(Math.abs(b)<0.001){return sprintf("%.2e",Number(b))}else{return sprintf("%.3f",Number(b))}}}};this.getMaxtTextBySampling=function(b,h){var c={};var f=[];var g=[];for(var e=0;e<b.length;e++){var d=b[e]!=null?b[e].toString():"";if(!c.hasOwnProperty(d)){c[d]=true;f.push([d,d.length])}}f.sort(function(j,i){return j[1]<i[1]?-1:j[1]>i[1]?1:0});if(!h){h=10}if(f.length<h){h=f.length}for(var e=0;e<h;e++){g.push(f[e][0])}return this.getMaxText(g)};this.getMaxText=function(d){var f="";var b=0;if(d&&d.length>0){for(var e=0;e<d.length;e++){if(d[e]){var g=this.measureText(d[e].toString(),this.font);if(g>b){f=d[e].toString();b=g}}}}return f};this.shortenText=function(c,b,a){if(!c){return""}c=c.toString();if(a&&c.length>b){return c.substring(0,Math.max(parseInt(a/b)-2,1))+".."}else{if(c.length<=b){return c}else{return c.substring(0,b-3)+"..."}}};this.convertToNumber=function(a){if(!isNaN(a)){return parseFloat(a)}else{return a}};this.stringToHex=function(c){var b="";for(var a=0;a<c.length;a++){b+=""+c.charCodeAt(a).toString(16)}return b};this.hexToString=function(b){var c="";for(var a=0;a<b.length;a+=2){c+=String.fromCharCode(parseInt(b.substr(a,2),16))}return c}};CanvasXpress.prototype.initTime=function(){Date.prototype.getWeek=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((((this-a)/86400000)+a.getDay()+1)/7)};Date.prototype.getDayYear=function(){var a=new Date(this.getFullYear(),0,1);return Math.ceil((this-a)/86400000)};this.getMillisecond=function(a){return a.getMilliseconds()};this.getSecond=function(a){return a.getSeconds()};this.getMinuteSecond=function(a){return a.getMinutes()+":"+a.getSeconds()};this.getMinute=function(a){return a.getMinutes()};this.getHourMinute=function(a){return a.getHours()+":"+a.getMinutes()};this.getHour=function(a){return a.getHours()};this.getYearWeek=function(a){return a.getFullYear()+"-"+a.getWeek()};this.getYearMonth=function(a){return a.getFullYear()+"-"+a.getMonth()};this.getYear=function(a){return a.getFullYear()};this.times={second:1000,minute:60000,hour:3600000,day:86400000,week:604800000,month:2592000000,year:31556952000};this.parseDate=function(j){var f=0;var c=0;var e=0;var k=parseInt(j.toString().substring(0,4));var a=parseInt(j.toString().substring(4,6).replace(/^0/,""));var g=parseInt(j.toString().substring(6,8).replace(/^0/,""));var b=j.toString().match(/\:/)?j.toString().substring(10).split(":"):false;if(b){f=b[0]?parseInt(b[0].replace(/^0/,"")):0;c=b[1]?parseInt(b[1].replace(/^0/,"")):0;e=b[2]?parseInt(b[2].replace(/^0/,"")):0}return new Date(k,a-1,g,f,c,e)};this.setTimeAxis=function(){var h=this.validateTimeAxis();if(h){var g=Date.parse(h[h.length-1])-Date.parse(h[0]);var d;var b={};var c=[];this.timeValues=[];this.timeValueIndices=[];if(g>this.times.year*2){d="getYear"}else{if(g>this.times.month*2){d="getYearMonth"}else{if(g>this.times.week*2){d="getYearWeek"}else{if(g<this.times.second){d="getMillisecond"}else{if(g<this.times.minute){d="getSecond"}else{if(g<this.times.hour/4){d="getMinuteSecond"}else{if(g<this.times.hour){d="getMinute"}else{if(g<this.times.day/4){d="getHourMinute"}else{if(g<this.times.day){d="getHour"}else{d=false}}}}}}}}}if(d){if(this.timeTicksFirst){for(var a=0;a<h.length;a++){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.push(h[a]);this.timeValueIndices.push(a);b[e]=true}}}else{for(var a=h.length-1;a>=0;a--){var e=this[d](h[a]);if(!b.hasOwnProperty(e)){c.unshift(h[a]);this.timeValueIndices.unshift(a);b[e]=true}}}}else{for(var a=0;a<h.length;a++){this.timeValues.push(dateFormat(h[a],this.timeFormat));this.timeValueIndices.push(a)}}var g=Date.parse(c[c.length-1])-Date.parse(c[c.length-2]);if(d=="getYear"&&g<this.times.month*3){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearMonth"&&g<this.times.week*4){this.timeValues.pop();this.timeValueIndices.pop()}else{if(d=="getYearWeek"&&g<this.times.day*7){this.timeValues.pop();this.timeValueIndices.pop()}}}for(var a=0;a<c.length;a++){this.timeValues.push(dateFormat(c[a],this.timeFormat))}}};this.createRandomTimes=function(b){var e;var g=new Date();var a=g.getTime();var f=[new Date(a)];var h=this.isGroupedData?this.data.w:this.data.y;if(!b||!this.times[b]){b="day"}for(var c=0;c<h.smps.length;c++){e=Date.parse(h.smps[c]);if(!isNaN(e)){a=e}else{a-=this.times[b]}f.unshift(new Date(a))}return f};this.validateTimeAxis=function(){var f=this.isGroupedData?this.data.w:this.data.y;var a=false;var e=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices.length!=f.smps.length?Date.parse(f.smps[this.smpIndices[b]]):Date.parse(f.smps[b]);if(isNaN(c)){if(this.isExample){e=this.createRandomTimes();return e}else{a=true;break}}else{e.push(new Date(c))}}return a?false:e}};CanvasXpress.prototype.initColor=function(){this.validateColor=function(i,e,f){if(i){i=i.toString();i=i.replace(/\s/g,"");var b=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(i);var d=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(i);var g=(/^#?([0-9abcdef]{6})/i).exec(i);var a=(/^([0-9abcdef]{6})/i).exec(i);if(CanvasXpress.colorNames.hasOwnProperty(i)){i=this.hexToRgb(CanvasXpress.colorNames[i])}else{if(b!=null){i=b[0]}else{if(d!=null){i=d[0]}else{if(g!=null){i=this.hexToRgb(g[0])}else{if(a!=null){i=this.hexToRgb("#"+a[0])}else{i=false}}}}}}i=i&&e!=null?this.addColorTransparency(i,e):i;return i&&f?this.rgbToHex(i):i};this.darkenLightenColor=function(j,e){j=this.rgbToHex(j).substring(1,7);var i=parseInt(j,16);var h=(i>>16)+e;h=h>255?255:h<0?0:h;var f=((i>>8)&255)+e;f=f>255?255:f<0?0:f;var d=(i&255)+e;d=d>255?255:d<0?0:d;j=d|(f<<8)|(h<<16);return this.hexToRgb(j.toString(16))};this.rgbToHex=function(b){var a=function(c){c=parseInt(c,10);if(isNaN(c)){return"00"}c=Math.max(0,Math.min(c,255));return"0123456789ABCDEF".charAt((c-c%16)/16)+"0123456789ABCDEF".charAt(c%16)};if(b&&b.substr(0,1)==="#"){return b}if(b&&b.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return"#"+a(RegExp.$1)+a(RegExp.$2)+a(RegExp.$3)}else{return b}};this.complementaryColor=function(j,e){var d=this.validateColor(j.toString());if(d.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var i=parseInt(255-RegExp.$1);var f=parseInt(255-RegExp.$2);var a=parseInt(255-RegExp.$3);if(i==f&&f==a){if(i>=127){d="rgb(255,255,255)"}else{d="rgb(0,0,0)"}}else{d="rgb("+i+","+f+","+a+")"}return e?this.rgbToHex(d):d}else{return j}};this.hexToRgb=function(c){var b=function(){return parseInt(c.substring(0,2),16)};var a=function(){return parseInt(c.substring(2,4),16)};var d=function(){return parseInt(c.substring(4,6),16)};c=c.charAt(0)=="#"?c.substring(1,7):c;return"rgb("+b()+","+a()+","+d()+")"};this.addColorTransparency=function(e,d,b){if(!b){e=this.validateColor(e)}if(e){var a=e.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return"rgba("+a[1]+","+d+")"}else{return false}};this.removeColorTransparency=function(d,b){if(!b){d=this.validateColor(d)}if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return"rgb("+a[1]+")"}else{return false}};this.isColorTransparency=function(b){b=this.validateColor(b);if(b){var a=b.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return a[2]!=null?Number(a[2]):null}};this.isColorTransparent=function(d){d=this.validateColor(d);var b;if(d&&d.match(/^rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/)){return false}else{if(d){var a=d.match(/^rgba?\((\d{1,3},\d{1,3},\d{1,3})(?:,([0-9\.]+))?/i);return a[2]!=null&&a[2]==0?true:false}else{return false}}};this.combineColors=function(j){var e=[];var d=[];var n=[];var k=[];for(var f=0;f<j.length;f++){j[f]=this.validateColor(j[f])}for(var f=0;f<j.length;f++){var l=j[f];if(l&&l.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){e.push(parseInt(RegExp.$1));d.push(parseInt(RegExp.$2));n.push(parseInt(RegExp.$3));if(RegExp.$4){k.push(parseFloat(RegExp.$4))}}}if(e.length>0){var a=parseInt(this.mean(e));var h=parseInt(this.mean(d));var m=parseInt(this.mean(n));if(k.length>0){var o=parseFloat(this.mean(k));return"rgba("+a+","+h+","+m+","+o+")"}else{return"rgb("+a+","+h+","+m+")"}}return false};this.colorAsArray=function(f){f=this.validateColor(f);var b=[];if(f){var d=(/rgb\((\d{1,3}),(\d{1,3}),(\d{1,3})\)/).exec(f);var e=(/rgba\((\d{1,3}),(\d{1,3}),(\d{1,3}),([0-9\.]+)\)/).exec(f);if(d!=null){b=[parseInt(d[1]),parseInt(d[2]),parseInt(d[3])]}else{if(e!=null){b=[parseInt(e[1]),parseInt(e[2]),parseInt(e[3]),Number(e[4])]}}}return b};this.disableGradientTransparencyShadow=function(){if(!this.gradientTemp){this.gradientTemp=this.gradient}if(this.transparencyTemp==null){this.transparencyTemp=this.transparency}if(!this.showShadowTemp){this.showShadowTemp=this.showShadow}this.gradient=false;this.transparency=null;this.showShadow=false};this.enableGradientTransparencyShadow=function(){this.gradient=this.gradientTemp;this.transparency=this.transparencyTemp;this.showShadow=this.showShadowTemp};this.resetGradientTransparencyShadow=function(){delete (this.gradientTemp);delete (this.transparencyTemp);delete (this.showShadowTemp)};this.getGradientColor=function(h){if(h.match(/^rgba?\((\d{1,3}),(\d{1,3}),(\d{1,3})(?:,([0-9\.]+))?/i)){var f=Math.floor(parseInt(RegExp.$1)/this.gradientRatio);var e=Math.floor(parseInt(RegExp.$2)/this.gradientRatio);var a=Math.floor(parseInt(RegExp.$3)/this.gradientRatio);var d=RegExp.$4?parseFloat(RegExp.$4):false;if(d){return"rgba("+f+","+e+","+a+","+d+")"}else{return"rgb("+f+","+e+","+a+")"}}else{return false}};this.getGradient=function(e,d,c,b,a){if(this.gradientType=="radial"){return this.getRadialGradient(e,d,c,b,false,false,true)}else{return this.getLinearGradient(e,d,c,b,a,false,true)}};this.getLinearGradient=function(b,i,a,h,d,c,f){if(!f){this.saveCanvas()}var j=this.getCanvasContext();var e=j.createLinearGradient(b,i,a,h);if(!d){d=this.foreground}if(!c){c=this.getGradientColor(d);e.addColorStop(0,c);e.addColorStop(0.6,d);e.addColorStop(1,d)}else{e.addColorStop(0,d);e.addColorStop(0.5,c)}return e};this.getRadialGradient=function(j,h,a,e,d,c,i){if(!i){this.saveCanvas()}var b=a/5.5;var k=this.getCanvasContext();var f=k.createRadialGradient(j-b,h-b,1,j,h,a);if(!e){e=this.foreground}if(!d){if(this.transparency!=null){d="rgba(0,0,0,"+this.transparency+")"}else{d="rgb(0,0,0)"}}if(!c){c="rgba(0,0,0,0)"}f.addColorStop(0,e);f.addColorStop(1,d);f.addColorStop(1,c);return f};this.colorRGBfromString=function(b){var a=b.match(/^\W*([0-9A-F]{3}([0-9A-F]{3})?)\W*$/i);if(a){if(a[1].length===6){this.colorFromRgb(parseInt(a[1].substr(0,2),16)/255,parseInt(a[1].substr(2,2),16)/255,parseInt(a[1].substr(4,2),16)/255)}else{this.colorFromRgb(parseInt(a[1].charAt(0)+a[1].charAt(0),16)/255,parseInt(a[1].charAt(1)+a[1].charAt(1),16)/255,parseInt(a[1].charAt(2)+a[1].charAt(2),16)/255)}}};this.colorFromRgb=function(e,d,a){if(this.colorRGB){if(e!=null){this.colorRGB[0]=Math.min(Math.max(0,e),1)}if(d!=null){this.colorRGB[1]=Math.min(Math.max(0,d),1)}if(a!=null){this.colorRGB[2]=Math.min(Math.max(0,a),1)}var c=this.rgbFromHsv(this.colorRGB[0],this.colorRGB[1],this.colorRGB[2]);if(c[0]!=null){this.colorHSV[0]=c[0]}if(c[2]!=0){this.colorHSV[1]=c[1]}this.colorHSV[2]=c[2]}};this.rgbFromHsv=function(i,f,c){var j=Math.min(Math.min(i,f),c);var d=Math.max(Math.max(i,f),c);var a=d-j;if(a==0){return[null,0,d]}else{var e=i==j?3+(c-f)/a:(f==j?5+(i-c)/a:1+(f-i)/a);return[e==6?0:e,a/d,d]}};this.colorFromHsv=function(c,b,a){if(c!=null){this.colorHSV[0]=Math.min(Math.max(0,c),6)}if(b!=null){this.colorHSV[1]=Math.min(Math.max(0,b),1)}if(a!=null){this.colorHSV[2]=Math.min(Math.max(0,a),1)}this.colorRGB=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],this.colorHSV[2])};this.hsvFromRgb=function(e,d,b){if(e==null){return[b,b,b]}var c=Math.floor(e);var g=c%2?e-c:1-(e-c);var a=b*(1-d);var j=b*(1-d*g);switch(c){case 0:return[b,j,a];case 1:return[j,b,a];case 2:return[a,b,j];case 3:return[a,j,b];case 4:return[j,a,b];case 5:return[b,a,j];case 6:return[b,a,j]}};this.colorRGBToString=function(){if(this.colorRGB){return(256|Math.round(255*this.colorRGB[0])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[1])).toString(16).substr(1)+(256|Math.round(255*this.colorRGB[2])).toString(16).substr(1)}};this.getColorNames=function(){return this.sortObject(CanvasXpress.colorNames)};this.getColorSchemes=function(){return this.sortObject(CanvasXpress.colorSchemes)};this.getHexColor=function(a){var b=/^#?[0-9a-fA-F]{6}$/i;if(b.test(a)){return a.substring(a.length-6,a.length)}else{var c=a.toLowerCase();if(CanvasXpress.colorNames.hasOwnProperty(c)){return CanvasXpress.colorNames[c]}else{throw new Error(a+" is not a valid color.")}}};this.getColorForValue=function(a,c){if(!a){a=this.meta.def.colorBrew}for(var d=0;d<a.breaks.length;d++){if(a.breaks[d]>=c){return a.colors[d]}}return a.colors[a.colors.length-1]};this.setColorForValues=function(a,d){var g=this;var c=function(l){var j=function(t,q){var n=a.grads[l];var s=n.min;var y=n.max;var p=n.scol.substring(t,q);var z=n.ecol.substring(t,q);var v=d<s?s:d>y?y:d;var i=y-s;var w=parseInt(p,16);var m=parseInt(z,16);var u=(m-w)/i;var o=Math.round(u*(v-s)+w);var x=o.toString(16);return x.length==1?"0"+x:x};var k=j(0,2);var h=j(2,4);var b=j(4,6);return g.hexToRgb("#"+k+h+b)};if(!a){a=this.meta.def.colorBrew}if(a.length==1){return c(0)}else{var f=(a.max-a.min)/a.grads.length;var e=Math.min(Math.floor((Math.max(d,a.min)-a.min)/f),a.grads.length-1);return c(e)}};this.getColorBrew=function(L,C,F,g,f,c){var h=L||this.colorSpectrum;if(C!=null&&F!=null&&C==F){F+=0.1}var G=C!=null?C:this.minData!=null?this.minData:0;var t=F!=null?F:this.maxData!=null?this.maxData:100;var J=!c&&this.setMinX!=null?this.setMinX:null;var x=!c&&this.setMaxX!=null?this.setMaxX:null;var D,w;var M=[];if(g==null){zero=(G+t)/2}else{zero=g;var D=g-G;var w=t-g;if(D>w){t=g+D}else{G=g-w}}var u=this[this.axisAlgorithm](Math.min(J||G,x||t),Math.max(J||G,x||t),5,this.axisWilkinsonLoose);var H=(u[u.length-1]-u[0])/(h.length-1);var a=this.getAxisDecimals(u[1]-u[0]);var d=this.getMaxText(u);var I=this.measureText(d.toString(),this.font);var q=u[u.length-1]-u[0];var e=q/this.colorSpectrumNumber;if(f&&f.length>1&&f.length==h.length){for(var E=0;E<f.length;E++){f[E]=Number(f[E])}f=f.sort(function(l,i){return l-i});var y=u[0];var B=Math.ceil((this.colorSpectrumNumber-1)/h.length);for(var E=0;E<f.length;E++){var o=f[E];var K=this.seq(y,o,false,B);M=M.concat(K);var m=M.length-1;y=o+(M[m]-M[m-1])}}else{M=this.seq(u[0],u[u.length-1],false,this.colorSpectrumNumber)}while(M.length<this.colorSpectrumNumber){M.push(u[u.length-1])}var A={scol:this.getHexColor(h[0]),ecol:this.getHexColor(h[1]),min:u[0],max:u[0]+H};var k={spectrum:h,stops:f,z:g,colors:[],legend:[],grads:[A],rmin:G,rmax:t,min:u[0],max:u[u.length-1],range:q,zero:zero,vals:u,incr:H,decs:a,breaks:M,maxLevLen:I,maxLevChr:d.toString().length,maxLevStr:d};for(var E=1;E<h.length-1;E++){A={scol:this.getHexColor(h[E]),ecol:this.getHexColor(h[E+1]),min:u[0]+(H*E),max:u[0]+(H*(E+1))};k.grads.push(A)}var j=u[0];for(var E=0;E<this.colorSpectrumNumber;E++){k.colors.push(this.setColorForValues(k,j));j+=e}for(var E=0;E<this.colorSpectrumNumber;E++){j=M[E];k.legend.push(this.setColorForValues(k,j))}return k};this.setColorBrew=function(b,c){if(!this.meta.def.colorBrew||b){if(this.meta.vals.colors){this.meta.vals.colors={}}if(this.graphType.match(/Stacked/)){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minDataStacked,this.maxDataStacked,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{if(this.heatmapAutoAdjust||!this.meta.def.colorBrew){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData,this.maxData,this.colorSpectrumZeroValue,this.colorSpectrumBreaks)}else{var a=this.meta.def.colorBrew;if(c){this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,this.minData||a.rmin,this.maxData||a.rmax,this.colorSpectrumZeroValue||a.z,this.colorSpectrumBreaks||a.stops)}else{this.meta.def.colorBrew=this.getColorBrew(this.colorSpectrum,a.rmin,a.rmax,a.z,a.stops)}}}}};this.validateUserColors=function(){var a=[];for(var b=0;b<this.colors.length;b++){a.push(this.validateColor(this.colors[b]))}if(a.length>0){this.colors=a}};this.validateUserColors()};CanvasXpress.prototype.initAttributes=function(){this.setStyle=function(c,b,d){var a=this.getCanvasContext();c=this.validateColor(c);if(this.transparency!=null){c=this.addColorTransparency(c,this.transparency)}a.fillStyle=c;a.strokeStyle=c;a.lineWidth=b?b:this.outlineWidth;a.lineCap=d?d:this.capType;this.setShadow(true)};this.setClipBoundaries=function(c){var b,d,a,e;if(c&&c.length==4){b=c[0];d=c[1];a=c[2];e=c[3]}else{b=this.marginLeft+this.offsetX+this.left;d=this.marginTop+this.offsetY+this.top;a=this.x;e=this.y}return[b,d,a,e]};this.setClipArea=function(a){var e=this.getCanvasContext();this.saveCanvas();e.strokeStyle="rgba(255,255,255,0)";var d,f,c,g;if(a){d=a[0];f=a[1];c=a[2];g=a[3]}else{d=this.marginLeft+this.offsetX+this.left;f=this.marginTop+this.offsetY+this.top;c=this.x+1;g=this.y+1}e.rect(d,f,c,g);e.clip();this.meta.state.clip=true};this.resetClipArea=function(){this.restoreCanvas();this.meta.state.clip=false};this.resetStyle=function(){this.setShadow(false)};this.setShadow=function(c){if(this.showShadow){var a=this.getCanvasContext();var b="rgba(255,255,255,0)";if(c){a.shadowOffsetX=this.shadowOffsetX;a.shadowOffsetY=this.shadowOffsetY;a.shadowBlur=this.shadowBlur;a.shadowColor=this.shadowColor}else{a.shadowOffsetX=0;a.shadowOffsetY=0;a.shadowBlur=0;a.shadowColor=this.background;a.strokeStyle="rgba(255,255,255,0)";a.fillStyle="rgba(255,255,255,0)"}}};this.lineTo=function(c,e,b,d){if(c==b){c=(((c+0.5)<<1)>>1)+0.5;b=c}else{if(e==d){e=(((e+0.5)<<1)>>1)+0.5;d=e}}var a=this.getCanvasContext();a.moveTo(c,e);a.lineTo(b,d);a.stroke()};this.bitCode=function(b,c){var a=0;if(b[0]<c[0]){a|=1}else{if(b[0]>c[2]){a|=2}}if(b[1]<c[1]){a|=4}else{if(b[1]>c[3]){a|=8}}return a};this.intersect=function(d,c,e,f){return e&8?[d[0]+(c[0]-d[0])*(f[3]-d[1])/(c[1]-d[1]),f[3]]:e&4?[d[0]+(c[0]-d[0])*(f[1]-d[1])/(c[1]-d[1]),f[1]]:e&2?[f[2],d[1]+(c[1]-d[1])*(f[2]-d[0])/(c[0]-d[0])]:e&1?[f[0],d[1]+(c[1]-d[1])*(f[0]-d[0])/(c[0]-d[0])]:null};this.lineClip=function(n,l,h){var k,j,d,m;var g=n.length;var e=this.bitCode(n[0],l);var c=[];if(!l){l=this.setClipBoundaries()}for(var f=1;f<g;f++){k=n[f-1];j=n[f];d=m=this.bitCode(j,l);while(true){if(!(e|d)){c.push(k);if(d!==m){c.push(j);if(f<g-1){result.push(c);c=[]}}else{if(f===g-1){c.push(j)}}break}else{if(e&d){break}else{if(e){k=this.intersect(k,j,e,l);e=this.bitCode(k,l)}else{j=this.intersect(k,j,d,l);d=this.bitCode(j,l)}}}}e=m}if(c.length){h.push(c)}return h};this.polygonClip=function(j,h){var g,c,f,a,d;if(!h){h=this.setClipBoundaries()}for(var b=1;b<=8;b*=2){g=[];c=j[j.length-1];f=!(this.bitCode(c,h)&b);for(var e=0;e<j.length;e++){a=j[e];d=!(this.bitCode(a,h)&b);if(d!==f){g.push(this.intersect(c,a,b,h))}if(d){g.push(a)}c=a;f=d}j=g;if(!j.length){break}}return g};this.clip=function(v,f,k){var d,c,p,n,j,o,v;var q,e,a,m;var u=[];if(!k){k=this.setClipBoundaries()}var e=k[0];var q=k[1];var a=k[2];var m=k[3];switch(v){case"path":u[0]=[];u[1]=[];for(var g=0;g<f[0].length;g++){c=f[0][g];n=f[1][g];if(c<e||c>a){c=null}if(n<q||n>m){n=null}u[0].push(c);u[1].push(n)}break;case"box":case"rect":case"rectangle":case"rect2":case"rect3":case"roundrect":d=this.parseInt(f[0]-(f[2]/2));p=this.parseInt(f[1]-(f[3]/2));c=this.parseInt(d+f[2]);n=this.parseInt(p+f[3]);if(c>d){if(n>p){if(d>a+this.outlineWidth||p>m+this.outlineWidth||c<e||n<q){return false}if(d<e){d=e}if(c>a){c=a}if(p<q){p=q}if(n>m){n=m}}else{if(d>a+this.outlineWidth||n>m+this.outlineWidth||c<e||p<q){return false}if(d<e){d=e}if(c>a){c=a}if(p>m){p=m}if(n<q){n=q}}}else{if(n>p){if(c>a+this.outlineWidth||p>m+this.outlineWidth||d<e||n<q){return false}if(d>a){d=a}if(c<e){c=e}if(p<q){p=q}if(n>m){n=m}}else{if(c>a+this.outlineWidth||n>m+this.outlineWidth||d<e||p<q){return false}if(d>a){d=a}if(c<e){c=e}if(p>m){p=m}if(n<q){n=q}}}u=[d,p,c-d,n-p];break;case"poly":break;case"circle":case"sphere":case"square":case"triangle":case"triangle2":case"equilateral":case"equilateral2":case"diamond":case"rhombus":case"hexagon":case"octagon":case"oval":case"oval2":case"oval3":case"arc":case"arc2":case"ellipse":case"ellipse2":case"ellipse3":case"plus":case"minus":case"mdavid":case"star":case"pie":case"pie0":case"pie1":case"pie2":case"pie3":case"pie4":case"pie5":case"pie6":case"pie7":case"pie8":case"pie9":case"pacman":case"pacman2":d=parseInt(f[0]);p=parseInt(f[1]);if(d>e+a||d<e||p<q||p>q+m){return false}u=[d,p];break;case"line":d=parseFloat(f[0]);p=parseFloat(f[1]);c=parseFloat(f[2]);n=parseFloat(f[3]);if(d==c){if(d<e||d>a){return false}else{if(p>n){if(p<q){return false}else{if(p>m){p=m}}if(n>m){return false}else{if(n<q){n=q}}}else{if(p>m){return false}else{if(p<q){p=q}}if(n<q){return false}else{if(n>m){n=m}}}}}else{if(p==n){if(p<q||p>m){return false}else{if(d>c){if(d<e){return false}else{if(d>a){d=a}}if(c>a){return false}else{if(c<e){c=e}}}else{if(d>a){return false}else{if(d<e){d=e}}if(c<e){return false}else{if(c>a){c=a}}}}}else{if(d>c){if(d<e||c>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=d-c;if(d>a){p-=(d-a)*j/o;d=a}if(p>m){d-=(p-m)*o/j;p=m}if(c<e){n+=(e-c)*j/o;c=e}if(n<q){c+=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=d-c;if(d>a){p+=(d-a)*j/o;d=a}if(p<q){d-=(q-p)*o/j;p=q}if(c<e){n-=(e-c)*j/o;c=e}if(n>m){c+=(n-m)*o/j;n=m}}}}}else{if(c<e||d>a){return false}else{if(p>n){if(p<q||n>m){return false}else{j=p-n;o=c-d;if(d<e){p-=(e-d)*j/o;d=e}if(p>m){d+=(p-m)*o/j;p=m}if(c>a){n+=(c-a)*j/o;c=a}if(n<q){c-=(q-n)*o/j;n=q}}}else{if(n<q||p>m){return false}else{j=n-p;o=c-d;if(d<e){p+=(e-d)*j/o;d=e}if(p<q){d+=(q-p)*o/j;p=q}if(c>a){n-=(c-a)*j/o;c=a}if(n>m){c-=(n-m)*o/j;n=m}}}}}}}u=[d,p,c,n];break;default:return false}return u};this.getLineArea=function(G,v,a,u,W,R,F,K,H,S,T,U,I,L,M){var N=Math.max(F,this.lineWidthEvent);var J=[];var z=["poly"];G=this.validateBezier(G,v,a,u,W,H,S);if(G.match(/error/)){if(this.showErrorBars&&this.isNumeric([v,a,u,W,F])){v=Math.ceil(v);u=Math.ceil(u);a=Math.ceil(a);W=Math.ceil(W);F=Math.ceil(F);var B=F/2;if(F>0){z=["poly",v,a-N,u-N,W-N,u-N,W-B,u+N,W-B,u+N,W+B,u-N,W+B,u-N,W+N,v,a+N]}else{z=["poly",u-N,W+N,u-B,W+N,u-B,W-N,u+B,W-N,u+B,W+N,u+N,W+N,v+N,a,v-N,a]}}else{return false}}else{if(G=="spline"||G=="cardinalSpline"){if(v.length<3){return v.length<2?false:this.getLineArea("line",v[0],a[0],v[1],a[1],R,F,K,H,S,T,U,I,L,M)}for(var Q=0;Q<v.length;Q++){z.push(v[Q],a[Q]-N);J.push(a[Q]+N,v[Q])}z=z.concat(J.reverse())}else{if(G=="arch"){if(v.length!=3||a.length!=3){return false}for(var Q=0;Q<v.length;Q++){if(!this.isNumeric([v[Q],a[Q]])){return false}}J=this.traceQuadraticCurve(v[0],a[0],v[1],a[1],v[2],a[2],0.25,true);for(var Q=0;Q<J.length;Q++){z.push(J[Q][0],J[Q][1])}J=this.traceQuadraticCurve(v[0],a[0],v[1],a[1],v[2],a[2],0.25);for(var Q=0;Q<J.length;Q++){z.push(J[Q][0],J[Q][1])}}else{if(G=="arc"){z=["poly"];J=this.traceArc(v,a,u,H,S,true);for(var Q=0;Q<J.length;Q++){z.push(J[Q][0],J[Q][1])}J=this.traceArc(v,a,u-N,H,S);for(var Q=0;Q<J.length;Q++){z.push(J[Q][0],J[Q][1])}}else{if(this.isNumeric([v,a,u,W])){var y=this.shortenLine(v,a,u,W,(H||0),(S||0),G);v=y[0];a=y[1];u=y[2];W=y[3];if(T){y=this.clip("line",[v,a,u,W],U);if(y){v=y[0];a=y[1];u=y[2];W=y[3]}else{return false}}if(I&&this.isArray(I)&&I.length>0){if(this.isNumeric2DArray(I)){if(G.match(/bezier/i)){var V=[I[0][0],I[0][1]];for(var Q=0;Q<I.length;Q++){V=V.concat(I[Q])}V.push(I[I.length-1][0],I[I.length-1][1]);var d=this.cloneObject(V);for(var Q=0;Q<I.length;Q++){J=this.traceBezierCurve(d[0],d[1]-N,d[2],d[3]-N,d[4],d[5]-N,d[6],d[7]-N,0.1,true);for(var O=0;O<J.length;O++){z.push(J[O][0],J[O][1])}for(var O=0;O<6;O++){d.shift()}}d=this.cloneObject(V);var D=[];for(var Q=0;Q<I.length;Q++){J=this.traceBezierCurve(d[0],d[1]+N,d[2],d[3]+N,d[4],d[5]+N,d[6],d[7]+N,0.1,true);for(var O=0;O<J.length;O++){D.push(J[O][1],J[O][0])}for(var O=0;O<6;O++){d.shift()}}z=z.concat(D.reverse())}else{if(I.length>2){z=["poly"];var C=[];for(var Q=0;Q<I.length-1;Q++){C.push([I[Q][0],I[Q][1]])}for(var Q=I.length-1;Q>=1;Q--){C.push([I[Q][0],I[Q][1]])}J=this.enlargePolygon(C,N,1);for(var Q=0;Q<J.length;Q++){z.push(J[Q][0],J[Q][1])}}else{var r=this.parallelLinePoints(I[0][0],I[0][1],I[1][0],I[1][1],N);z=["poly",r[0],r[1],r[2],r[3],r[6],r[7],r[4],r[5]]}}}else{return false}}else{if(G.match(/curved/i)){var k=this.lineMidPoint(v,a,u,W);var E=this.lineLength(v,a,k[0],k[1]);var A=(H||0)/E;var x=(S||0)/E;var o=G.match(/curvedcc/i)&&v>u?false:!G.match(/curvedcc/i)&&u>=v?true:false;var l=u>=v?Math.asin((k[1]-a)/E):Math.asin(-(k[1]-a)/E);var P=o?l-Math.PI:l+Math.PI;z=["poly"];J=this.traceArc(k[0],k[1],E+N,(P+(o?A:-x)),(l+(o?-x:A)),!o);for(var Q=0;Q<J.length;Q++){z.push(J[Q][0],J[Q][1])}J=this.traceArc(k[0],k[1],E-N,(P+(o?A:-x)),(l+(o?-x:A)),o);for(var Q=0;Q<J.length;Q++){z.push(J[Q][0],J[Q][1])}}else{if(G.match(/bezier/i)){var h=(v+u)/2;var g=(a+W)/2;if(G.match(/beziery/i)){J=this.traceBezierCurve(v,a-N,v,g-N,u,g-N,u,W-N,0.25,true)}else{J=this.traceBezierCurve(v,a-N,h,a-N,h,W-N,u,W-N,0.25,true)}for(var Q=0;Q<J.length;Q++){z.push(J[Q][0],J[Q][1])}if(G.match(/beziery/i)){J=this.traceBezierCurve(v,a+N,v,g+N,u,g+N,u,W+N,0.25)}else{J=this.traceBezierCurve(v,a+N,h,a+N,h,W+N,u,W+N,0.25)}for(var Q=0;Q<J.length;Q++){z.push(J[Q][0],J[Q][1])}}else{if(v==u&&a!=W){z=["poly",v-N,a,v+N,a,u+N,W,u-N,W]}else{if(a==W&&v!=u){z=["poly",v,a-N,u,a-N,u,W+N,v,W+N]}else{var r=this.parallelLinePoints(v,a,u,W,N);z=["poly",r[0],r[1],r[2],r[3],r[6],r[7],r[4],r[5]]}}}}}}else{return false}}}}}if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?z:this.adjustNetworkObjects(z)}else{return z}};this.setDashDot=function(c){var a=this.getCanvasContext();var b=[];this.tempCap=a.lineCap;if(c.match(/blank/i)){b=CanvasXpress.R.lty[0]}else{if(c.match(/solid/i)){b=CanvasXpress.R.lty[1]}else{if(c.match(/dashed/i)){b=CanvasXpress.R.lty[2];b=[this.dashLength,this.dashLength-2]}else{if(c.match(/dotted/i)){b=CanvasXpress.R.lty[3];b=[this.dotLength,this.dotLength+2]}else{if(c.match(/dotdash/i)){b=CanvasXpress.R.lty[4]}else{if(c.match(/longdash/i)){b=CanvasXpress.R.lty[5]}else{if(c.match(/twodash/i)){b=CanvasXpress.R.lty[6]}}}}}}}a.setLineDash(b)};this.resetDashDot=function(){var a=this.getCanvasContext();a.lineCap=this.tempCap;a.setLineDash([])};this.validateBezier=function(c,b,g,a,f,d,h){if(this.adjustBezier){if(c.match(/bezier/i)&&(b==a||g==f)){return"line"}if(Math.abs(a-b)>=Math.abs(f-g)){if(c.match(/beziery/i)){c=c.replace("beziery","bezier");c=c.replace("bezierY","bezier")}}else{if(c.match(/bezierx/i)){c=c.replace("bezierx","beziery");c=c.replace("bezierX","bezierY")}else{if(c.match(/bezier/i)){c=c.replace("bezier","bezierY")}}}if(d!=null&&h!=null){if(c.match(/beziery/i)){if(f>g){if(g+d>f-h){c="line"}}else{if(g-d<f+h){c="line"}}}else{if(c.match(/beziery/i)){if(a>b){if(b+d>a-h){c="line"}}else{if(b-d<a+h){c="line"}}}}}}return c};this.drawLine=function(y,O,h,M,g,N,u,D,B,P,Q,S,C,E,H){this.functionCallerDraw="drawLine";var I=this.getCanvasContext();this.setDashDot(y);y=this.validateBezier(y,O,h,M,g,B,P);if(y.match(/error/)){if(this.showErrorBars&&this.isNumeric([O,h,M,g,u])){O=Math.ceil(O);M=Math.ceil(M);h=Math.ceil(h);g=Math.ceil(g);u=Math.ceil(u);var r=u/2;this.setStyle(N,false,D);if(!this.isColorTransparent(N)){I.beginPath();this.lineTo(O,h,M,g);if(Math.abs(u)>this.errorBarsWidth){if(u>0){this.lineTo(M,g-r,M,g+r)}else{this.lineTo(M-r,g,M+r,g)}}}this.resetStyle()}}else{if(y.match(/spline|cardinalSpline/)){if(O.length<3){return O.length<2?false:this.drawLine("line",O[0],h[0],O[1],h[1],N,u,D,B,P,Q,S,C,E,H)}var o=[];var T=[];var d=0;for(var K=0;K<O.length;K++){if(this.isNumeric([O[K],h[K]])){T.push(O[K],h[K]);d+=2}else{return}}this.setStyle(N,u,D);if(!this.isColorTransparent(N)){if(y.match(/spline/)){for(var K=0;K<d-4;K+=2){o=o.concat(this.splineControlPoint(T[K],T[K+1],T[K+2],T[K+3],T[K+4],T[K+5]))}I.beginPath();I.moveTo(T[0],T[1]);I.quadraticCurveTo(o[0],o[1],T[2],T[3]);for(var K=2;K<d-5;K+=2){I.bezierCurveTo(o[2*K-2],o[2*K-1],o[2*K],o[2*K+1],T[K+2],T[K+3])}I.moveTo(T[d-2],T[d-1]);I.quadraticCurveTo(o[2*d-10],o[2*d-9],T[d-4],T[d-3]);I.stroke()}else{T=this.curvePoints(T);I.beginPath();I.moveTo(T[0],T[1]);for(var K=2;K<T.length-1;K+=2){I.lineTo(T[K],T[K+1])}I.stroke()}}this.resetStyle()}else{if(y.match(/arch/)){if(O.length!=3||h.length!=3){return false}for(var K=0;K<O.length;K++){if(!this.isNumeric([O[K],h[K]])){return false}}this.setStyle(N,u,D);if(!this.isColorTransparent(N)){I.beginPath();I.moveTo(O[0],h[0]);I.quadraticCurveTo(O[1],h[1],O[2],h[2]);I.stroke()}this.resetStyle()}else{if(y=="arc"){this.setStyle(N,u,D);I.beginPath();I.arc(O,h,M,B,P,false);I.stroke();this.resetStyle()}else{if(this.isNumeric([O,h,M,g])){var k=this.shortenLine(O,h,M,g,(B||0),(P||0),y);O=k[0];h=k[1];M=k[2];g=k[3];if(Q){k=this.clip("line",[O,h,M,g],S);if(k){O=k[0];h=k[1];M=k[2];g=k[3]}else{return false}}if(C&&this.isArray(C)&&C.length>0){var l=C.length-1;if(this.isNumeric2DArray(C)){this.setStyle(N,u,D);if(y.match(/bezier/i)){if(!this.isColorTransparent(N)){I.beginPath();I.moveTo(C[0][0],C[0][1]);for(var K=0;K<C.length;K++){I.bezierCurveTo(C[K][0],C[K][1],C[K][2],C[K][3],C[K][4],C[K][5])}I.stroke()}}else{if(!this.isColorTransparent(N)){I.beginPath();this.lineTo(C[0][0],C[0][1],C[1][0],C[1][1]);for(var K=1;K<l;K++){this.lineTo(C[K][0],C[K][1],C[K+1][0],C[K+1][1])}this.lineTo(C[l-1][0],C[l-1][1],C[l][0],C[l][1])}}this.resetStyle()}else{return false}}else{if(y.match(/curved/i)){var J=this.lineMidPoint(O,h,M,g);var G=this.lineLength(O,h,J[0],J[1]);var A=(B||0)/G;var j=(P||0)/G;var R=y.match(/curvedcc/i)&&O>M?false:!y.match(/curvedcc/i)&&M>=O?true:false;var F=M>=O?Math.asin((J[1]-h)/G):Math.asin(-(J[1]-h)/G);var a=F+Math.PI;this.setStyle(N,u,D);if(!this.isColorTransparent(N)){I.beginPath();if(M>=O){I.arc(J[0],J[1],G,F-j,a+A,R)}else{I.arc(J[0],J[1],G,F+A,a-j,R)}I.stroke()}this.resetStyle()}else{if(y.match(/bezier/i)){var z=(O+M)/2;var x=(h+g)/2;this.setStyle(N,u,D);if(!this.isColorTransparent(N)){I.beginPath();I.moveTo(O,h);if(y.match(/beziery/i)){I.bezierCurveTo(O,x,M,x,M,g)}else{I.bezierCurveTo(z,h,z,g,M,g)}I.stroke()}this.resetStyle()}else{this.setStyle(N,u,D);if(!this.isColorTransparent(N)){I.beginPath();this.lineTo(O,h,M,g)}this.resetStyle()}}}}else{this.resetDashDot();return false}}}}}this.resetDashDot();var v=y.match(/bezier/i)?true:false;if(H){var L=y.match(/curved/i)&&P?P:false;if(C&&this.isArray(C)&&C.length>0){O=v?C[l][0]:C[l-1][0];h=v?C[l][1]:C[l-1][1];M=v?C[l][4]:C[l][0];g=v?C[l][5]:C[l][1];if(v){v=C[l][0]==C[l][2]?"X":"Y"}}switch(H){case"arrow":this.drawArrowHead(O,h,M,g,N,u,v,L,0);break;case"square":this.drawArrowHead(O,h,M,g,N,u,v,L,1);break;case"round":this.drawArrowHead(O,h,M,g,N,u,v,L,2);break;case"roundDocked":break}}v=y.match(/bezier/i)?true:false;if(E){var L=y.match(/curved/i)&&B?-B:false;if(C&&this.isArray(C)&&C.length>0){O=v?C[0][0]:C[0][0];h=v?C[0][1]:C[0][1];M=v?C[0][4]:C[1][0];g=v?C[0][5]:C[1][1];if(v){v=C[0][4]==C[l][2]?"X":"Y"}}switch(E){case"arrow":this.drawArrowHead(M,g,O,h,N,u,v,L,0,true);break;case"square":this.drawArrowHead(M,g,O,h,N,u,v,L,1,true);break;case"round":this.drawArrowHead(M,g,O,h,N,u,v,L,2,true);break;case"roundDocked":break}}};this.drawArrowHead=function(F,g,D,e,E,r,I,H,m,k){var z=this.getCanvasContext();var B=function(f,K,b,L){var c=[];for(var w=0;w<f.length;w++){c.push([(f[w][0]*Math.cos(K))-(f[w][1]*Math.sin(K)),(f[w][0]*Math.sin(K))+(f[w][1]*Math.cos(K))])}var J=[];for(var w=0;w<c.length;w++){J.push([c[w][0]+b,c[w][1]+L])}return J};var v=this.arrowPointSize;var h=Math.max((v/2)-1,1);var a=Math.max((v*2/3),1);var t=r?r/2:this.outlineWidth/2;var n=r?r*2:this.outlineWidth*2;var u=m==1?[[-t,-v],[-t,v]]:m==0?[[1.5,-0.5],[-v,-h*r],[-v,h*r]]:false;var s=D-F;var q=e-g;if(I){if(I=="Y"){if(Math.abs(q)>Math.abs(s)){s=0}else{s=D>F?this.arrowPointSize:-this.arrowPointSize}}else{if(Math.abs(s)>Math.abs(q)){q=0}else{q=e>g?this.arrowPointSize:-this.arrowPointSize}}}else{if(H){var p=this.lineLength(F,g,D,e);var G=this.shortenLine(F,g,D,e,0,p/2,"line");var o=G[2];var C=G[3];var y=p/2;var j=H/y;var x=D>F?Math.asin((C-g)/y):Math.asin(-(C-g)/y);var d=k?x+(Math.PI/20):x-(Math.PI/20);if(D>F){F=o+y*Math.cos(d-j);g=C+y*Math.sin(d-j);D=o+y*Math.cos(x-j);e=C+y*Math.sin(x-j)}else{F=o+y*Math.cos((d-j)+Math.PI);g=C+y*Math.sin((d-j)+Math.PI);D=o+y*Math.cos((x-j)+Math.PI);e=C+y*Math.sin((x-j)+Math.PI)}s=D-F;q=e-g}}this.setStyle(E,m==1?r+2:r);if(m<2){var l=B(u,Math.atan2(q,s),D,e);z.beginPath();z.moveTo(l[0][0],l[0][1]);for(var A=1;A<l.length;A++){if(!isNaN(l[A][0])&&!isNaN(l[A][1])){z.lineTo(l[A][0],l[A][1])}}if(m==0){if(!isNaN(l[0][0])&&!isNaN(l[0][1])){z.lineTo(l[0][0],l[0][1])}z.closePath();z.fill()}else{z.closePath();z.stroke()}}else{if(m==2){z.beginPath();z.arc(D,e,h*1.3,0,Math.PI*2,true);z.closePath();z.fill()}else{}}this.resetStyle()};this.createPatterns=function(){var b=this.getCanvasContext();var d;var e=document.createElement("canvas");e.width=5;e.height=5;var a=e.getContext("2d");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.hatchForward=b.createPattern(e,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.hatchReverse=b.createPattern(e,"repeat");e.width=3;e.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();CanvasXpress.cachePatterns.stripeVertical=b.createPattern(e,"repeat");a.clearRect(0,0,3,3);a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.stripeHorizontal=b.createPattern(e,"repeat");e.width=5;e.height=5;a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.fill();CanvasXpress.cachePatterns.polkaDot=b.createPattern(e,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,0);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.crossHatch=b.createPattern(e,"repeat");e.width=3;e.height=3;a.clearRect(0,0,3,3);a.beginPath();a.moveTo(1.5,0);a.lineTo(1.5,3);a.stroke();a.beginPath();a.moveTo(0,1.5);a.lineTo(3,1.5);a.stroke();CanvasXpress.cachePatterns.crossStripe=b.createPattern(e,"repeat");e.width=5;e.height=5;a.clearRect(0,0,5,5);a.beginPath();a.strokeRect(1,1,4,4);a.stroke();CanvasXpress.cachePatterns.squares=b.createPattern(e,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,1,0,Math.PI*2);a.stroke();CanvasXpress.cachePatterns.circles=b.createPattern(e,"repeat");e.width=7;e.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.plus=b.createPattern(e,"repeat");e.width=7;e.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(1,3.5);a.lineTo(6,3.5);a.stroke();CanvasXpress.cachePatterns.minus=b.createPattern(e,"repeat");e.width=7;e.height=7;a.clearRect(0,0,7,7);a.beginPath();a.moveTo(3.5,1);a.lineTo(3.5,6);a.stroke();CanvasXpress.cachePatterns.bars=b.createPattern(e,"repeat");e.width=5;e.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,5);a.lineTo(2.5,0);a.lineTo(5,5);a.stroke();CanvasXpress.cachePatterns.squiglesHorizontal=b.createPattern(e,"repeat");e.width=5;e.height=5;a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(5,2.5);a.lineTo(0,5);a.stroke();CanvasXpress.cachePatterns.squiglesVertical=b.createPattern(e,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(0,0);a.lineTo(3,0);a.lineTo(0,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(2,5);a.lineTo(5,2);a.lineTo(5,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickForward=b.createPattern(e,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(5,0);a.lineTo(2,0);a.lineTo(5,3);a.closePath();a.stroke();a.fill();a.beginPath();a.moveTo(0,5);a.lineTo(0,2);a.lineTo(3,5);a.closePath();a.stroke();a.fill();CanvasXpress.cachePatterns.brickReverse=b.createPattern(e,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.arc(2.5,2.5,2,0,Math.PI*2);a.moveTo(0,5);a.lineTo(5,0);a.stroke();CanvasXpress.cachePatterns.art=b.createPattern(e,"repeat");a.clearRect(0,0,5,5);a.beginPath();a.moveTo(2,0);a.lineTo(0,0);a.lineTo(0,3);a.lineTo(2,3);a.stroke();a.beginPath();a.moveTo(3,3);a.lineTo(5,5);a.stroke();a.beginPath();a.moveTo(5,3);a.lineTo(3,5);a.stroke();CanvasXpress.cachePatterns.pcx=b.createPattern(e,"repeat");e.width=5;e.height=3;a.clearRect(0,0,5,3);a.beginPath();a.moveTo(0,0);a.lineTo(5,3);a.stroke();CanvasXpress.cachePatterns.hatchForward3=b.createPattern(e,"repeat");a.clearRect(0,0,5,3);a.beginPath();a.moveTo(5,0);a.lineTo(0,3);a.stroke();CanvasXpress.cachePatterns.hatchReverse3=b.createPattern(e,"repeat")};this.sphere=function(f,e,d,m,h,g,F,E,D){var c=Math.sin(F);var A=Math.cos(F);var b=Math.sin(E);var x=Math.cos(E);var a=Math.sin(D);var v=Math.cos(D);var C=function(j){var k=j.y;j.y=(k*A)+(j.z*c*-1);j.z=(k*c)+(j.z*A);var i=j.x;j.x=(i*x)+(j.z*b*-1);j.z=(i*b)+(j.z*x);var i=j.x;j.x=(i*v)+(j.y*a*-1);j.y=(i*a)+(j.y*v)};var l=[];var n=Math.PI/12;var t=Math.PI*2;var r=Math.PI/2;for(var B=1;B>=-1;B-=2){for(var z=0;z<r;z+=n){var u=Math.cos(z)*m;var o=Math.cos(z)*g;var q=Math.sin(z)*h*B*-1;for(var w=0;w<t;w+=n){var s={x:(Math.cos(w)*u),y:q,z:(Math.sin(w)*o)};C(s);s.x+=f;s.y+=e;s.z+=d;if(B>0){l.push([s.x,s.y,s.z])}else{l.unshift([s.x,s.y,s.z])}}}}return l};this.drawShapeSetShapeStyle=function(j,i,k,d,e,c,b,a,g){var l=this.getCanvasContext();this.saveCanvas();this.translateCanvas(j,i);if(a){this.rotateCanvas(a)}if(this.transparency!=null){e=this.addColorTransparency(e,this.transparency)}if(this.gradient){if(this.gradientType=="radial"){l.fillStyle=this.getGradient(0,0,Math.max(Math.abs(k),Math.abs(d)),e)}else{l.fillStyle=this.getGradient(0,0,k,d,e)}}else{if(b){switch(b){case"closed":case"solid":l.fillStyle=e;break;case"open":break;default:l.fillStyle=CanvasXpress.cachePatterns[b]?CanvasXpress.cachePatterns[b]:e;break}}else{l.fillStyle=e}}l.strokeStyle=c?c:this.foreground;l.lineWidth=g?g:this.outlineWidth;l.lineJoin=this.joinType;if((k&&l.lineWidth>=k)||(d&&l.lineWidth>=d)){l.strokeStyle=e}this.setShadow(true)};this.drawShapeDraw=function(d,c){var b=this.getCanvasContext();if(d&&d.length>1){var a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.beginPath();b.moveTo(a[0]+0.5,a[1]+0.5);while(d.length>0){a=d.shift();while(a[0]==null||a[1]==null){a=d.shift()}b.lineTo(a[0]+0.5,a[1]+0.5)}if(!c){b.closePath()}}};this.drawShapeFillStroke=function(b,d,c){var a=this.getCanvasContext();if(c&&c=="open"){a.stroke()}else{if(d==b||a.strokeStyle==a.fillStyle){a.fill()}else{a.fill();a.stroke()}}};this.drawShapeRestore=function(a,d,c){var b=this.getCanvasContext();this.setShadow(false);if(c){this.rotateCanvas(-c)}this.translateCanvas(-a,-d);this.restoreCanvas()};this.getShapeArea=function(v,m,l,n,G,H,D,C,B,k,L,M,A,I,q,J){var j=this;var F=function(d){if(j.graphType=="Network"){return d}d.shift();var b=["poly"];var f=Math.cos(B);var c=Math.sin(B);for(var e=0;e<d.length;e+=2){b.push((f*(m-d[e]))+(c*(l-d[e+1]))+d[e]);b.push((f*(l-d[e+1]))-(c*(m-d[e]))+d[e+1])}return b};var g,a;var N=["poly"];var K=[];if(!M){M=this.setClipBoundaries()}switch(v){case"arc2":K=this.traceArc(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc(m,l,G-n,A,I);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"pie":N.push(m,l);K=this.traceArc(m,l,G,A,I,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"confidence":for(var E=0;E<m.length;E++){N.push(m[E][0],l[E][0]);K.push(l[E][1],m[E][1])}N=N.concat(K.reverse());break;case"violin":for(var E=0;E<m[0].length;E++){N.push(m[0][E],l[0][E]);K.push(l[1][E],m[1][E])}N=N.concat(K.reverse());break;case"bezier":K=this.traceBezierCurve(m[0],l[0],m[1],l[1],m[2],l[2],m[3],l[3],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceBezierCurve(m[0],l[0]+G,m[1],l[1]+G,m[2],l[2]+G,m[3],l[3]+G,0.25);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"arch":K=this.traceQuadraticCurve(m[0],l[0],m[1],l[1],m[2],l[2],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc(m[4],l[4],G[0],n[2],n[3]);for(var E=1;E<K.length;E++){N.push(K[E][0],K[E][1])}if(m[0]==m[3]&&l[0]==l[3]&&m[1]==m[4]&&l[1]==l[4]&&m[2]==m[5]&&l[2]==l[5]){break}K=this.traceQuadraticCurve(m[3],l[3],m[4],l[4],m[5],l[5],0.25,true);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}K=this.traceArc(m[1],l[1],G[1],n[0],n[1]);for(var E=0;E<K.length;E++){N.push(K[E][0],K[E][1])}break;case"polygon":case"path":case"spline":case"hull":for(var E=0;E<m.length;E++){if(v=="spline"){N.push(m[E],l[E]-2);K.push(l[E]+2,m[E])}else{N.push(m[E],l[E])}}break;default:g=n/2;a=G/2;break}switch(v){case"image":N=["rect",m-(g*this.zoom),l-(a*this.zoom),m+(g*this.zoom),l+(a*this.zoom)];break;case"mdavid":case"star":case"circle":case"sphere":N=["circle",m,l,n];break;case"diamond":case"rhombus":N=["poly",m,l-a,m+g,l,m,l+a,m-g,l];break;case"box":case"rect":case"rectangle":case"roundrect":case"brace":case"square":case"hexagon":case"octagon":case"oval":case"arc":case"arc3":case"ellipse":case"plus":case"minus":case"pch0":case"pch1":case"pch2":case"pch3":case"pch4":case"pch5":case"pch6":case"pch7":case"pch8":case"pch9":case"pch10":case"pch11":case"pch12":case"pch13":case"pch14":case"pch15":case"pch16":case"pch17":case"pch18":case"pch21":case"pch22":case"pch23":case"pch24":case"pch25":N=["rect",m-g,l-a,m+g,l+a];break;case"pch19":g+=2;a+=2;N=["rect",m-g,l-a,m+g,l+a];break;case"pch20":g-=2;a-=2;g=Math.max(2,g);a=Math.max(2,a);N=["rect",m-g,l-a,m+g,l+a];break;case"rect2":return this.getShapeArea("rectangle",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"rect3":return this.getShapeArea("rectangle",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"triangle":case"equilateral":N=["poly",m,l-a,m+g,l+a,m-g,l+a];break;case"triangle2":case"equilateral2":N=["poly",m,l+a,m+g,l-a,m-g,l-a];break;case"oval2":return this.getShapeArea("oval",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"oval3":return this.getShapeArea("oval",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"ellipse2":return this.getShapeArea("ellipse",m,l,n,n/2,H,D,C,B,k,L,M,A,I,q,J);case"ellipse3":return this.getShapeArea("ellipse",m,l,n,n/3,H,D,C,B,k,L,M,A,I,q,J);case"pie0":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/5,q,J);case"pie1":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/3.5,q,J);case"pie2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/2,q,J);case"pie3":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI/1.5,q,J);case"pie4":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI,q,J);case"pie5":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.2,q,J);case"pie6":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.4,q,J);case"pie7":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.6,q,J);case"pie8":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*1.8,q,J);case"pie9":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,0,Math.PI*2,q,J);case"pacman":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*1/4,Math.PI*7/4,q,J);case"pacman2":return this.getShapeArea("pie",m,l,n,n/2,H,D,C,B,k,L,M,Math.PI*5/4,Math.PI*3/4,q,J)}N=B?F(N):N;if(this.graphType=="Network"){return this.preScaleNetwork&&!this.isAnimation?N:this.adjustNetworkObjects(N)}else{return N}};this.drawShape=function(U,P,O,R,ai,aj,Z,Y,W,N,ao,aq,V,al,S,am){this.functionCallerDraw="drawShape";var M,ap,j,ar,X,ac;var I=this.getCanvasContext();if(Y){switch(Y){case"closed":case"solid":case"open":break;default:var at=Y;Y="closed";this.drawShape(U,P,O,R,ai,aj,aj,Y,W,N,ao,aq,V,al,S,am);Y=at;break}}switch(U){case"polygon":case"path":case"spline":case"arch":case"hull":case"confidence":case"violin":case"bezier":var ae=Number.MAX_VALUE;var L=Number.MAX_VALUE*-1;var ad=Number.MAX_VALUE;var J=Number.MAX_VALUE*-1;ap=[];M=[];if(P.length==O.length){if(U=="spline"&&P.length<5){return this.drawShape("polygon",P,O,R,ai,aj,Z,Y,W,N,ao,aq,V,al,S,am)}if(U=="arch"&&(P.length!=6||O.length!=6||R.length!=4||ai.length!=2)){return false}if(U=="bezier"){if(this.isNumeric(P)&&this.isNumeric(O)&&this.isNumeric(ai)){for(var ah=0;ah<P.length;ah++){ae=Math.min(ae,P[ah]);L=Math.max(L,P[ah]);ad=Math.min(ad,O[ah]);J=Math.max(J,O[ah]);M.push([P[ah],O[ah]])}P=(ae+L)/2;O=(ad+J)/2;for(var ah=0;ah<M.length;ah++){M[ah][0]-=P;M[ah][1]-=O;ap.push(M[ah][0],M[ah][1])}}else{return false}}else{if(U=="confidence"){for(var ah=0;ah<P.length;ah++){if(P[ah][0]!=null&&P[ah][1]!=null&&O[ah][0]!=null&&O[ah][1]!=null&&this.isNumeric([P[ah][0],P[ah][1],O[ah][0],O[ah][1]])){ae=Math.min(ae,Math.min(P[ah][0],P[ah][1]));L=Math.max(L,Math.max(P[ah][0],P[ah][1]));ad=Math.min(ad,Math.min(O[ah][0],O[ah][1]));J=Math.max(J,Math.max(O[ah][0],O[ah][1]));M.push([[P[ah][0],P[ah][1]],[O[ah][0],O[ah][1]]])}}P=(ae+L)/2;O=(ad+J)/2;for(var ah=0;ah<M.length;ah++){M[ah][0][0]-=P;M[ah][0][1]-=P;M[ah][1][0]-=O;M[ah][1][1]-=O;ap.push([M[ah][0][0],M[ah][0][1]],[M[ah][1][0],M[ah][1][1]])}}else{if(U=="violin"){if(P[0].length==O[0].length&&P[1].length==O[1].length&&P[0].length==P[1].length){for(var ah=0;ah<P[0].length;ah++){if(this.isNumeric([P[0][ah],P[1][ah],O[0][ah],O[1][ah]])){ae=Math.min(ae,Math.min(P[0][ah],P[1][ah]));L=Math.max(L,Math.max(P[0][ah],P[1][ah]));ad=Math.min(ad,Math.min(O[0][ah],O[1][ah]));J=Math.max(J,Math.max(O[0][ah],O[1][ah]));M.push([[P[0][ah],P[1][ah]],[O[0][ah],O[1][ah]]])}}P=(ae+L)/2;O=(ad+J)/2;for(var ah=0;ah<M.length;ah++){M[ah][0][0]-=P;M[ah][0][1]-=P;M[ah][1][0]-=O;M[ah][1][1]-=O;ap.push([M[ah][0][0],M[ah][0][1]],[M[ah][1][0],M[ah][1][1]])}}else{return false}}else{for(var ah=0;ah<P.length;ah++){if(P[ah]&&O[ah]&&this.isNumeric([P[ah],O[ah]])){ae=Math.min(ae,P[ah]);L=Math.max(L,P[ah]);ad=Math.min(ad,O[ah]);J=Math.max(J,O[ah]);M.push([P[ah],O[ah]])}}P=U=="arch"?P[1]:(ae+L)/2;O=U=="arch"?O[1]:(ad+J)/2;for(var ah=0;ah<M.length;ah++){M[ah][0]-=P;M[ah][1]-=O;ap.push(M[ah][0],M[ah][1])}}}}}else{return false}break;default:if(this.isNumeric([P,O,R,ai])){if(ao){M=this.clip(U,[P,O,R,ai],aq);if(M){if(M.length==4){R=Math.max(1,M[2]);ai=Math.max(1,M[3]);P=M[0]+(R/2);O=M[1]+(ai/2)}else{if(M.length==2){P=M[0];O=M[1]}}}else{return false}}else{R=Math.max(1,R);ai=Math.max(1,ai)}j=R/2;ar=ai/2;X=ai/R;ac=1.5}else{return false}break}switch(U){case"image":if(S&&(CanvasXpress.cacheImages[this.getFileName(S)]||CanvasXpress.images[S])){this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);if(CanvasXpress.images[S]){this.drawImage(CanvasXpress.images[S],-j*this.zoom,-ar*this.zoom,R*this.zoom,ai*this.zoom)}else{this.drawImage(CanvasXpress.cacheImages[this.getFileName(S)],-j*this.zoom,-ar*this.zoom,R*this.zoom,ai*this.zoom)}}else{return this.drawShape("rectangle",P,O,R,ai,"rgba(0,0,0,0.5)","rgba(0,0,0,0.5)",Y,W,N,ao,aq,V,al,S,am)}break;case"circle":case"sphere":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);if(!this.isColorTransparent(aj)||!this.isColorTransparent(Z)){I.beginPath();I.arc(0,0,R/2,0,Math.PI*2,true);I.closePath();this.drawShapeFillStroke(aj,Z,Y)}break;case"box":case"rect":case"rectangle":M=[[-j,-ar],[j,-ar],[j,ar],[-j,ar]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);j=j+0.5;ar=ar+0.5;I.beginPath();I.moveTo(-j,-ar);I.lineTo(j,-ar);I.lineTo(j,ar);I.lineTo(-j,ar);I.closePath();this.drawShapeFillStroke(aj,Z,Y);break;case"rect2":return this.drawShape("rectangle",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,V,al,S,am);break;case"rect3":return this.drawShape("rectangle",P,O,R,R/3,aj,Z,Y,W,N,ao,aq,V,al,S,am);break;case"roundrect":var Q=R>ai?ai/4:R/4;this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(-j,-ar+Q);I.lineTo(-j,ar-Q);I.quadraticCurveTo(-j,ar,-j+Q,ar);I.lineTo(j-Q,ar);I.quadraticCurveTo(j,ar,j,ar-Q);I.lineTo(j,-ar+Q);I.quadraticCurveTo(j,-ar,j-Q,-ar);I.lineTo(-j+Q,-ar);I.quadraticCurveTo(-j,-ar,-j,-ar+Q);I.closePath();this.drawShapeFillStroke(aj,Z,Y);break;case"brace":var Q=R>ai?ai/4:R/4;this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(-j,-ar);I.bezierCurveTo(-j,0,0,0,0,ar);I.bezierCurveTo(0,0,j,0,j,-ar);this.drawShapeFillStroke(aj,Z,Y);break;case"square":M=[[-j,-j],[j,-j],[j,j],[-j,j]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"triangle":if(R==ai){return this.drawShape("equilateral",P,O,R,ai,aj,Z,Y,W,N,ao,aq,V,al,S,am)}M=[[0,-ar],[j,ar],[-j,ar]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"triangle2":if(R==ai){return this.drawShape("equilateral2",P,O,R,ai,aj,Z,Y,W,N,ao,aq,V,al,S,am)}M=[[0,ar],[j,-ar],[-j,-ar]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"equilateral":var Q=R*Math.sqrt(3)/6;var g=Q/2;var C=Math.sqrt((Q*Q)-(g*g));M=[[0,-ar],[j,ar],[-j,ar]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"equilateral2":var Q=R*Math.sqrt(3)/6;var g=Q/2;var C=Math.sqrt((Q*Q)-(g*g));M=[[0,ar],[j,-ar],[-j,-ar]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"diamond":case"rhombus":M=[[0,-ar],[j,0],[0,ar],[-j,0]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"hexagon":var an=R/3;var q=an-j;M=[[q,-ar],[-q,-ar],[j,0],[-q,ar],[q,ar],[-j,0]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"octagon":var au=R/4;var ag=ai/4;M=[[-au,-ar],[au,-ar],[j,-ag],[j,ag],[au,ar],[-au,ar],[-j,ag],[-j,-ag]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"oval":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.saveCanvas();this.scaleCanvas(1,X);I.beginPath();I.arc(0,0,R/2,0,Math.PI*2,true);I.closePath();this.restoreCanvas();this.drawShapeFillStroke(aj,Z,Y);break;case"oval2":return this.drawShape("oval",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,V,al,S,am);break;case"oval3":return this.drawShape("oval",P,O,R,R/3,aj,Z,Y,W,N,ao,aq,V,al,S,am);break;case"arc":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.saveCanvas();this.scaleCanvas(1,X);I.beginPath();I.arc(0,0,R/2,0,Math.PI,true);if(Y!="open"){I.closePath()}this.restoreCanvas();this.drawShapeFillStroke(aj,Z,Y);break;case"arc2":var E=ai*Math.cos(V);var ax=ai*Math.sin(V);var D=ai*Math.cos(al);var av=ai*Math.sin(al);var B=this.shortenLine(0,0,E,ax,0,R,"line");var v=this.shortenLine(0,0,D,av,0,R,"line");this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(B[2],B[3]);I.lineTo(E,ax);I.arc(0,0,ai,V,al,false);I.lineTo(v[2],v[3]);I.arc(0,0,ai-R,al,V,true);I.closePath();this.drawShapeFillStroke(aj,Z,Y);break;case"arc3":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.saveCanvas();this.scaleCanvas(1,X);I.beginPath();I.arc(0,0,R/2,0,Math.PI,true);this.restoreCanvas();this.drawShapeFillStroke(aj,Z,Y);break;case"arch":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(M[0][0],M[0][1]);I.quadraticCurveTo(M[1][0],M[1][1],M[2][0],M[2][1]);I.arc(0,0,ai[0],R[3],R[2],true);I.quadraticCurveTo(M[4][0],M[4][1],M[5][0],M[5][1]);I.arc(0,0,ai[1],R[1],R[0],true);I.closePath();this.drawShapeFillStroke(aj,Z,Y);break;case"path":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M,Y=="open");this.drawShapeFillStroke(aj,Z,Y);break;case"polygon":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M,Y=="open");this.drawShapeFillStroke(aj,Z,Y);break;case"spline":var T=[];var ab=[];var F=[];ab.push(ap.shift());ab.push(ap.shift());F.push(ap.pop());F.unshift(ap.pop());var aa=ap.length;for(var ah=0;ah<aa-4;ah+=2){T=T.concat(this.splineControlPoint(ap[ah],ap[ah+1],ap[ah+2],ap[ah+3],ap[ah+4],ap[ah+5]))}this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(ab[0],ab[1]);I.lineTo(ap[0],ap[1]);I.quadraticCurveTo(T[0],T[1],ap[2],ap[3]);for(var ah=2;ah<aa-5;ah+=2){I.bezierCurveTo(T[2*ah-2],T[2*ah-1],T[2*ah],T[2*ah+1],ap[ah+2],ap[ah+3])}I.quadraticCurveTo(T[2*aa-10],T[2*aa-9],ap[aa-2],ap[aa-1]);I.lineTo(F[0],F[1]);I.lineTo(ab[0],ab[1]);this.drawShapeFillStroke(aj,Z,Y);break;case"hull":var af;var aa=1;var G=[];while(ap.length>1){G.push([ap.shift(),ap.shift()])}var T=this.hullControlPoints(G);var m=[[G[0][0],G[0][1],T[T.length-1][0],T[T.length-1][1],T[0][0],T[0][1],G[1][0],G[1][1]]];for(var ah=1;ah<G.length-1;ah++){m.push([G[ah][0],G[ah][1],T[aa][0],T[aa][1],T[aa+1][0],T[aa+1][1],G[ah+1][0],G[ah+1][1]]);aa+=2}m.push([G[ah][0],G[ah][1],T[aa][0],T[aa][1],T[aa+1][0],T[aa+1][1],G[0][0],G[0][1]]);this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(m[0][0],m[0][1]);for(var ah=0;ah<m.length;ah++){I.bezierCurveTo(m[ah][2],m[ah][3],m[ah][4],m[ah][5],m[ah][6],m[ah][7])}this.drawShapeFillStroke(aj,Z,Y);break;case"violin":var aa=ap.length;var T=[];var K=[];for(var ah=0;ah<aa-4;ah+=2){var aw=(aa-1)-ah;T=T.concat(this.splineControlPoint(ap[ah][0],ap[ah+1][0],ap[ah+2][0],ap[ah+3][0],ap[ah+4][0],ap[ah+5][0]));K=K.concat(this.splineControlPoint(ap[aw-1][1],ap[aw][1],ap[aw-3][1],ap[aw-2][1],ap[aw-5][1],ap[aw-4][1]))}if(this.graphOrientation=="vertical"){for(var ah=0;ah<T.length-1;ah+=2){if(T[ah]>0){T[ah]=0}if(K[ah]<0){K[ah]=0}}}else{for(var ah=1;ah<T.length;ah+=2){if(T[ah]>0){T[ah]=0}if(K[ah]<0){K[ah]=0}}}this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(ap[0][0],ap[1][0]);I.quadraticCurveTo(T[0],T[1],ap[2][0],ap[3][0]);for(var ah=2;ah<aa-5;ah+=2){I.bezierCurveTo(T[2*ah-2],T[2*ah-1],T[2*ah],T[2*ah+1],ap[ah+2][0],ap[ah+3][0])}I.quadraticCurveTo(T[2*aa-10],T[2*aa-9],ap[aa-2][0],ap[aa-1][0]);I.lineTo(ap[aa-2][1],ap[aa-1][1]);I.quadraticCurveTo(K[0],K[1],ap[aa-4][1],ap[aa-3][1]);for(var ah=2;ah<aa-5;ah+=2){var aw=(aa-1)-ah;I.bezierCurveTo(K[2*ah-2],K[2*ah-1],K[2*ah],K[2*ah+1],ap[aw-3][1],ap[aw-2][1])}I.quadraticCurveTo(K[2*aa-10],K[2*aa-9],ap[0][1],ap[1][1]);I.lineTo(ap[0][0],ap[1][0]);this.drawShapeFillStroke(aj,Z,Y);break;case"confidence":var aa=ap.length;var T=[];var K=[];for(var ah=0;ah<aa-4;ah+=2){var aw=(aa-1)-ah;T=T.concat(this.splineControlPoint(ap[ah][0],ap[ah+1][0],ap[ah+2][0],ap[ah+3][0],ap[ah+4][0],ap[ah+5][0]));K=K.concat(this.splineControlPoint(ap[aw-1][1],ap[aw][1],ap[aw-3][1],ap[aw-2][1],ap[aw-5][1],ap[aw-4][1]))}this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(ap[0][0],ap[1][0]);I.quadraticCurveTo(T[0],T[1],ap[2][0],ap[3][0]);for(var ah=2;ah<aa-5;ah+=2){I.bezierCurveTo(T[2*ah-2],T[2*ah-1],T[2*ah],T[2*ah+1],ap[ah+2][0],ap[ah+3][0])}I.quadraticCurveTo(T[2*aa-10],T[2*aa-9],ap[aa-2][0],ap[aa-1][0]);I.lineTo(ap[aa-2][1],ap[aa-1][1]);I.quadraticCurveTo(K[0],K[1],ap[aa-4][1],ap[aa-3][1]);for(var ah=2;ah<aa-5;ah+=2){var aw=(aa-1)-ah;I.bezierCurveTo(K[2*ah-2],K[2*ah-1],K[2*ah],K[2*ah+1],ap[aw-3][1],ap[aw-2][1])}I.quadraticCurveTo(K[2*aa-10],K[2*aa-9],ap[0][1],ap[1][1]);I.lineTo(ap[0][0],ap[1][0]);this.drawShapeFillStroke(aj,Z,Y);break;case"bezier":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(ap[0],ap[1]);I.bezierCurveTo(ap[2],ap[3],ap[4],ap[5],ap[6],ap[7]);I.lineTo(ap[6],ap[7]+ai);I.bezierCurveTo(ap[4],ap[5]+ai,ap[2],ap[3]+ai,ap[0],ap[1]+ai);I.lineTo(ap[0],ap[1]);this.drawShapeFillStroke(aj,Z,Y);break;case"ellipse":var a=j*0.5522848;var ak=ar*0.5522848;this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.moveTo(0,ar);I.bezierCurveTo(0,ar-ak,j-a,0,j,0);I.bezierCurveTo(j+a,0,R,ar-ak,R,ar);I.bezierCurveTo(R,ar+ak,j+a,ai,j,ai);I.bezierCurveTo(j-a,ai,0,ar+ak,0,ar);I.closePath();this.drawShapeFillStroke(aj,Z,Y);break;case"ellipse2":return this.drawShape("ellipse",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,V,al,S,am);break;case"ellipse3":return this.drawShape("ellipse",P,O,R,R/3,aj,Z,Y,W,N,ao,aq,V,al,S,am);break;case"plus":M=[[-ac,-ar],[ac,-ar],[ac,-ac],[j,-ac],[j,ac],[ac,ac],[ac,ar],[-ac,ar],[-ac,ac],[-j,ac],[-j,-ac],[-ac,-ac],[-ac,-ar]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"minus":M=[[-j,-ac],[j,-ac],[j,ac],[-j,ac],[-j,-ac]];this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.drawShapeDraw(M);this.drawShapeFillStroke(aj,Z,Y);break;case"mdavid":var an=R/3;var A=Math.PI/6;this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.saveCanvas();this.scaleCanvas(0.8,0.8);this.rotateCanvas(H*0.45);I.beginPath();I.moveTo(an,0);for(var ah=0;ah<11;ah++){this.rotateCanvas(A);if(ah%2==0){I.lineTo((an/0.55),0)}else{I.lineTo(an,0)}}I.closePath();this.restoreCanvas();this.drawShapeFillStroke(aj,Z,Y);break;case"star":var k=(R/4);var H=Math.PI/5;this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);this.saveCanvas();this.scaleCanvas(0.7,0.7);this.rotateCanvas(H*0.45);I.beginPath();I.moveTo(k,0);for(var ah=0;ah<9;ah++){this.rotateCanvas(H);if(ah%2==0){I.lineTo((k/0.35),0)}else{I.lineTo(k,0)}}I.closePath();this.restoreCanvas();this.drawShapeFillStroke(aj,Z,Y);break;case"pie":if(typeof(V)=="undefined"){V=0}if(typeof(al)=="undefined"){al=Math.PI*2}this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);I.beginPath();I.arc(0,0,R/2,V,al,false);I.lineTo(0,0);I.closePath();this.drawShapeFillStroke(aj,Z,Y);break;case"pie0":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI/5,S,am);break;case"pie1":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI/3.5,S,am);break;case"pie2":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI/2,S,am);break;case"pie3":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI/1.5,S,am);break;case"pie4":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI,S,am);break;case"pie5":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI*1.2,S,am);break;case"pie6":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI*1.4,S,am);break;case"pie7":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI*1.6,S,am);break;case"pie8":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI*1.8,S,am);break;case"pie9":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,0,Math.PI*2,S,am);break;case"pacman":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,Math.PI*1/4,Math.PI*7/4,S,am);break;case"pacman2":return this.drawShape("pie",P,O,R,R/2,aj,Z,Y,W,N,ao,aq,Math.PI*5/4,Math.PI*3/4,S,am);break;case"pch0":this.drawShape("square",P,O,R,R,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch1":this.drawShape("circle",P,O,R,R,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch2":this.drawShape("equilateral",P,O,R,R,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch3":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,"open",false,N);I.moveTo(0,-ar);this.lineTo(0,-ar,0,ar);I.stroke();I.moveTo(-j,0);this.lineTo(-j,0,j,0);I.stroke();this.drawShapeFillStroke(aj,Z,Y);break;case"pch4":this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,"open",false,N);I.moveTo(-j,-ar);this.lineTo(-j,-ar,j,ar);I.stroke();I.moveTo(j,-ar);this.lineTo(j,-ar,-j,ar);I.stroke();this.drawShapeFillStroke(aj,Z,Y);break;case"pch5":this.drawShape("diamond",P,O,R,R,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch6":this.drawShape("equilateral2",P,O,R,R,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch7":this.drawShape("pch0",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);this.drawShape("pch4",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch8":this.drawShape("pch3",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);this.drawShape("pch4",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch9":this.drawShape("pch3",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);this.drawShape("pch5",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch10":this.drawShape("pch1",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);this.drawShape("pch3",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch11":this.drawShape("pch2",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);this.drawShape("pch6",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch12":this.drawShape("pch0",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);this.drawShape("pch3",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch13":this.drawShape("pch1",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);this.drawShape("pch4",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch14":this.drawShape("pch0",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);this.drawShape("pch6",P,O,R,ai,aj,Z,"open",false,N,ao,aq,V,al,S,am);break;case"pch15":case"pch22":this.drawShape("square",P,O,R,R,aj||this.foreground,Z,"closed",false,N,ao,aq,V,al,S,am);break;case"pch16":case"pch21":this.drawShape("circle",P,O,R,R,aj||this.foreground,Z,"closed",false,N,ao,aq,V,al,S,am);break;case"pch17":case"pch24":this.drawShape("equilateral",P,O,R,R,aj||this.foreground,Z,"closed",false,N,ao,aq,V,al,S,am);break;case"pch18":case"pch23":this.drawShape("diamond",P,O,R,R,aj||this.foreground,Z,"closed",false,N,ao,aq,V,al,S,am);break;case"pch19":this.drawShape("circle",P,O,R+2,R+2,aj||this.foreground,Z,"closed",false,N,ao,aq,V,al,S,am);break;case"pch20":this.drawShape("circle",P,O,Math.max(2,R-2),Math.max(2,R-2),aj||this.foreground,Z,"closed",false,N,ao,aq,V,al,S,am);break;case"pch25":this.drawShape("equilateral2",P,O,R,R,aj||this.foreground,Z,"closed",false,N,ao,aq,V,al,S,am);break;default:this.drawShapeSetShapeStyle(P,O,R,ai,aj,Z,Y,W,N);break}this.drawShapeRestore(P,O,W)};this.drawImage=function(c,a,o,k,f,b,p,m,d){var n=this.getCanvasContext();try{if(b&&p&&m&&d){n.drawImage(c,a,o,k,f,b,p,m,d)}else{n.drawImage(c,a,o,k,f)}}catch(j){var g=this;setTimeout(function(){g.draw()},100)}};this.drawVideo=function(c,b,d){var e=this;var a=this.getCanvasContext();if(c.paused||c.ended){return false}a.drawImage(c,0,0,b,d);this.videoUpdate();setTimeout(function(){e.drawVideo(c,b,d)},50)};this.setGlobalCompositionOperation=function(b){if(!CanvasXpress.system.isIE&&b){var a=this.getCanvasContext();a.globalCompositeOperation=b;this.meta.state.globalCompositeOperation=b}};this.rectangleClear=function(a,e,c,d){var b=this.getCanvasContext();b.clearRect(a,e,c,d)};this.translateCanvas=function(a,c){var b=this.getCanvasContext();b.translate(a,c);this.meta.state.translate[0]+=a;this.meta.state.translate[1]+=c};this.rotateCanvas=function(b){var a=this.getCanvasContext();a.rotate(b);this.meta.state.rotate[0]+=b};this.scaleCanvas=function(a,c){var b=this.getCanvasContext();b.scale(a,c);this.meta.state.scale[0]*=a;this.meta.state.scale[1]*=c};this.saveCanvas=function(){var a=this.getCanvasContext();a.save();this.meta.state.save++};this.restoreCanvas=function(){var a=this.getCanvasContext();a.restore();this.meta.state.save--}};CanvasXpress.prototype.initRangeAlgorithms=function(){this.heckbert=function(d,k,b){var c=function(i,m){var o;var p=Math.floor(Math.log(i)/Math.LN10);var n=i/Math.pow(10,p);if(m){if(n<1.5){o=1}else{if(n<3){o=2}else{if(n<7){o=5}else{o=10}}}}else{if(n<1){o=1}else{if(n<2){o=2}else{if(n<5){o=5}else{o=10}}}}return o*Math.pow(10,p)};if(d>k){var f=k;d=k;d=f}var j=[];var g=c(k-d,false);var l=c(g/(b-1),true);var a=Math.floor(d/l)*l;var h=Math.ceil(k/l)*l;for(var e=a;e<=h;e+=l){j.push(this.correctPrecisionBug(e))}return j};this.wilkinson=function(c,h,a){var b=function(z,B,A,y){var u=[10,1,5,2,2.5,3,4,1.5,7,6,8,9];var w=B-z;var r=A-1;var o=1-Math.abs(A-y)/y;var D=w/r;var t=Math.floor(Math.log(D)/Math.LN10);var E=Math.pow(10,t);var p=null;for(var C=0;C<u.length;C++){var s=u[C]*E;var F=Math.floor(z/s)*s;var n=F+r*s;if(F<=z&&n>=B){var v=1-(C-(F<=0&&n>=0?1:0))/u.length;var q=(B-z)/(n-F);if(q>0.8){var x=o+v+q;if(p==null||x>p.score){p={lmin:F,lmax:n,lstep:s,score:x}}}}}if(!p){p={lmin:z,lmax:B,lstep:1,score:0}}return p};if(c>h){var g=h;c=h;c=g}var j=[];var e=null;var l=[];for(var f=Math.max(Math.floor(a/2),2);f<=Math.ceil(6*a);f++){l.push(f)}for(var f=0;f<l.length;f++){var d=l[f];var m=b(c,h,d,a);if((m!=null&&e==null)||(m&&e&&m.score>e.score)){e=m}}for(var f=e.lmin;f<=e.lmax;f+=e.lstep){j.push(this.correctPrecisionBug(f))}return j};this.wilkinsonExtended=function(a,y,R,C){var A=2.22e-14;var f=function(j,g){for(var c=0;c<g.length;c++){if(j==g[c]){return c}}};var J=function(c,w,m,g,z,Y){var k=w.length;var s=f(c,w);var Z=(g%Y<A||Y-(g%Y)<A)&&g<=0&&z>=0?1:0;return 1-s/(k-1)-m+Z};var K=function(s,m,g){var w=m.length;var k=f(s,m);var c=1;return 1-k/(w-1)-g+c};var h=function(c,i,j,g){return 1-0.5*(Math.pow(i-g,2)+Math.pow(c-j,2))/Math.pow(0.1*(i-c),2)};var r=function(c,k,i){var g=k-c;if(i>g){var j=(i-g)/2;return 1-0.5*(Math.pow(j,2)+Math.pow(j,2))/Math.pow(0.1*g,2)}else{return 1}};var o=function(j,c,i,s,w,q){var n=(j-1)/(q-w);var g=(c-1)/(Math.max(q,s)-Math.min(i,w));return 2-Math.max(n/g,g/n)};var X=function(g,c){return g>=c?2-(g-1)/(c-1):1};var e=[1,5,2,2.5,4,3];var G=[0.25,0.2,0.5,0.05];var P=e.length;var L={score:-2};var H=[];if(a>y){var l=a;a=y;y=l}if(y-a<A){for(var U=0;U<=R;U++){H.push(a)}return H}var T=1;while(T<Number.POSITIVE_INFINITY){for(var U=0;U<P;U++){var N=e[U];var u=K(N,e,T);if((G[0]*u+G[1]+G[2]+G[3]<L.score)){T=Number.POSITIVE_INFINITY;break}var S=2;while(S<Number.POSITIVE_INFINITY){var p=X(S,R);if((G[0]*u+G[1]+G[2]*p+G[3]<L.score)){break}var E=(y-a)/(S+1)/T/N;var F=Math.ceil(Math.log(E)/Math.LN10);while(F<Number.POSITIVE_INFINITY){var D=T*N*Math.pow(10,F);var B=r(a,y,D*(S-1));if((G[0]*u+G[1]*B+G[2]*p+G[3]<L.score)){break}var v=Math.floor(y/D)*T-(S-1)*T;var O=Math.ceil(a/D)*T;if(v>O){F++;continue}for(var x=v;x<=O;x++){var t=x*(D/T);var M=t+D*(S-1);var d=D;var I=J(N,e,T,t,M,d);var W=h(a,y,t,M);var V=o(S,R,a,y,t,M);var b=G[0]*I+G[1]*W+G[2]*V+G[3];if(b>L.score&&(!C||(t<=a&&M>=y))){L={lmin:t,lmax:M,lstep:d,score:b}}}F++}S++}}T++}for(var U=L.lmin;U<=L.lmax;U+=L.lstep){H.push(this.correctPrecisionBug(U))}return H};this.rPretty=function(o,p,r){if(o>p){var w=p;o=p;o=w}var a,e,b;var l=[];var q=Math.floor(r)-1;var s=Math.floor(q%3);var g=0.75;var v=1.5;var d=0.5+1.5*v;var f=p-o;if(f==0&&p==0){a=1;e=true;b=1}else{a=Math.max(Math.abs(o),Math.abs(p));b=1+d>=1.5*v+0.5?1/(1+v):1.5/1+d;e=f<(a*b*Math.max(1,q)*1e-7*3)}if(e){if(a>10){a=9+a/10}a=a*g;if(s>1){a/=s}}else{a=f;if(q>1){a/=q}}if(a<20*1e-7){a=20*1e-7}var c=Math.pow(10,Math.floor(Math.log(a)/Math.LN10));var j=c;if((2*c)-a<v*(a-j)){j=2*c;if((5*c)-a<d*(a-j)){j=5*c;if((10*c)-a<v*(a-j)){j=10*c}}}var y=Math.floor(o/j+1e-7);var x=Math.ceil(p/j-1e-7);while(y*j>o+(1e-7*j)){y--}while(x*j<p-(1e-7*j)){x++}var t=Math.floor(0.5+x-y);if(t<s){t=s-t;if(y>=0){x+=t/2;y=y-t/2+t%2}else{y-=t/2;x=x+t/2+t%2}q=s}else{q=t}for(var u=y*j;u<=x*j;u+=j){l.push(this.correctPrecisionBug(u))}return l};this.getAxisDecimals1=function(a){return a===0?0:a.toExponential().replace(/e[\+\-0-9]*$/,"").replace(/^0\.0*|\./,"").length};this.getAxisDecimals2=function(b){var a=1000000;var c=(((b*a)-(parseInt(b)*a))/a).toString().replace(/\./,"").length-1;return c};this.getAxisDecimals=function(a){a=this.correctPrecisionBug(a);var b=a===0||a%1===0?0:a.toExponential().replace(/e[\+\-0-9]+$/,"").replace(/^0\.0+|\./,"").length;return Math.min(b,20)}};CanvasXpress.prototype.initPrimitives=function(){this.initText();this.initTime();this.initColor();this.initAttributes();this.initRangeAlgorithms()};CanvasXpress.prototype.initGeneralUtils=function(){this.modifyObjectArray=function(b,f,g,e,h){this.functionCaller="modifyObjectArray";if(this.isTransition()){return}var d=this[g];if(e){var a={};if(this.isArray(b)){for(var c=0;c<b.length;c++){a[b[c]]=true}}else{a[b]=true}for(var c in a){if(this.isInArray(c,d)){d=this.removeFromArray(c,d);delete (a[c])}}for(var c in a){d.push(c)}this[g]=d}else{if(f){var a={};var j=[];if(this.isArray(b)){for(var c=0;c<b.length;c++){a[b[c]]=1}}else{a[b]=1}for(var c=0;c<d.length;c++){if(!a.hasOwnProperty(d[c])){j.push(d[c])}}this[g]=j}else{if(this.isArray(b)){for(var c=0;c<b.length;c++){d.push(b[c])}}else{d.push(b)}}}if(h){this.draw()}};this.getObjectArray=function(b){var d={};if(b&&this.isArray(b)){for(var c=0;c<b.length;c++){d[b[c]]=true}}return d};this.isInArray=function(d,b){if(this.isArray(d)){if(this.isArray(b)){for(var c=0;c<d.length;c++){if(b.indexOf(d[c])>-1){return true}}}return false}else{return this.isArray(b)?b.indexOf(d)>-1:false}};this.removeFromArray=function(e,b){if(this.isArray(b)){var d=[];for(var c=0;c<b.length;c++){if(b[c]!=e){d.push(b[c])}}}return d};this.isFunction=function(a){var b={};return a&&b.toString.call(a)==="[object Function]"};this.isArray=function(a){return Array.isArray(a)};this.isObject=function(a){return a instanceof Object};this.isUnique=function(b){return this.getUniqueEls(b).length==b.length};this.toArray=function(a){return this.isArray(a)?a:[a]};this.getKeys=function(a){return this.isArray(a)?a:this.isObject(a)?Object.keys(a):[]};this.unique=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return this.getUniqueEls(this.getKeys(a))}else{return[a]}}};this.getUniqueEls=function(b){return b.filter(function(a,c){return b.indexOf(a)===c})};this.getUniqueKeys=function(a){if(this.isArray(a)){return this.getUniqueEls(a)}else{if(this.isObject(a)){return this.getUniqueEls(this.getKeys(a))}else{return[a]}}};this.shuffleArray=function(b){for(var d=b.length;d>0;d--){var c=Math.floor(this.random()*d);var a=b[--d];b[d]=b[c];b[c]=a}return b};this.toNumber=function(b){var e=[];var c=this.isArray(b);b=this.toArray(b);for(var d=0;d<b.length;d++){e.push(Number(b[d]))}return c?e:e[0]};this.cloneObject=function(b,a){if(b==null||typeof(b)!="object"){return b}if(a&&!this.isR){return this.isArray(b)?Object.assign([],b):Object.assign({},b)}else{return JSON.parse(JSON.stringify(b))}};this.isSameObject=function(d,c){if(d===c){return true}if(typeof(d)!="object"||typeof(c)!="object"){return false}return JSON.stringify(d)==JSON.stringify(c)};this.isNumber=function(a){return a===null||a===undefined?true:!isNaN(parseFloat(a))&&isFinite(a)};this.isNumeric2DArray=function(a){for(var c=0;c<a.length;c++){for(var b=0;b<a[c].length;b++){if(!this.isNumber(a[c][b])){return false}}}return true};this.isNumeric=function(b,a,e){if(a){for(var d=0;d<this.smpIndices.length;d++){var c=this.smpIndices[d];if(!this.isNumber(b[c])){return false}}}else{if(e){for(var d=0;d<this.varIndices.length;d++){var c=this.varIndices[d];if(!this.isNumber(b[c])){return false}}}else{for(var c=0;c<b.length;c++){if(!this.isNumber(b[c])){return false}}}}return true};this.isEmpty=function(b,a,e){if(a){for(var d=0;d<this.smpIndices.length;d++){var c=this.smpIndices[d];if(b[c]!=""){return false}}}else{if(e){for(var d=0;d<this.varIndices.length;d++){var c=this.varIndices[d];if(b[c]!=""){return false}}}else{for(var c=0;c<b.length;c++){if(b[c]!=""){return false}}}}return true};this.isDate=function(b,a,f){var d=function(g){if(toString.call(g)==="[object Date]"){return true}if(typeof g.replace==="function"){g.replace(/^\s+|\s+$/gm,"")}var h=/(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;return h.test(g)};if(a){for(var e=0;e<this.smpIndices.length;e++){var c=this.smpIndices[e];if(b[c]&&!d(b[c])){return false}}}else{if(f){for(var e=0;e<this.varIndices.length;e++){var c=this.varIndices[e];if(b[c]&&!d(b[c])){return false}}}else{for(var c=0;c<b.length;c++){if(b[c]&&!d(b[c])){return false}}}}return true};this.padNumber=function(b,a){if(!a){a=4}b=b+"";return b.length>=a?b:new Array(a-b.length+1).join("0")+b};this.isPivotable=function(){var b=this.data.y.vars.length;var c=this.data.x?this.getKeys(this.data.x):[];var a=c.length;return b+a==3};this.pivotMatrix=function(h,f,k,c){var a={};var e=[];var d=[];for(var b=0;b<h.length;b++){if(!a[h[b][f]]){a[h[b][f]]={}}a[h[b][f]][h[b][k]]=h[b][c];if(e.indexOf(h[b][k])==-1){e.push(h[b][k])}}e=this.stringRangeSort(e);var j=[];j.push("Vars");j.push.apply(j,e);d.push(j);for(var g in a){j=[];j.push(g);for(var b=0;b<e.length;b++){j.push(a[g][e[b]]||"")}d.push(j)}return d};this.transposeMatrix=function(a){return a[0].map(function(b,d){return a.map(function(c){return c[d]})})};this.filterNumbers=function(a){var c=[];for(var b=0;b<a.length;b++){if(this.isNumber(a[b])){c.push(a[b])}}return c};this.cleanArray=function(b,a,e){var d=[];if(a){for(var c=0;c<this.smpIndices.length;c++){d.push(b[this.smpIndices[c]])}d=this.filterNumbers(d)}else{if(e){for(var c=0;c<this.varIndices.length;c++){d.push(b[this.varIndices[c]])}d=this.filterNumbers(d)}else{d=this.filterNumbers(b)}}return d};this.cleanArrays=function(e,d,b,j){var h=[];var g=[];if(b){for(var f=0;f<this.smpIndices.length;f++){var c=this.filterNumbers([e[this.smpIndices[f]],d[this.smpIndices[f]]]);if(c.length==2){h.push(e[this.smpIndices[f]]);g.push(d[this.smpIndices[f]])}}}else{if(j){for(var f=0;f<this.varIndices.length;f++){var c=this.filterNumbers([e[this.varIndices[f]],d[this.varIndices[f]]]);if(c.length==2){h.push(e[this.varIndices[f]]);g.push(d[this.varIndices[f]])}}}else{for(var f=0;f<e.length;f++){var c=this.filterNumbers([e[f],d[f]]);if(c.length==2){h.push(e[f]);g.push(d[f])}}}}return[h,g]};this.reverseArray=function(a){tmp=a.reverse();return tmp};this.parseInt=function(a){return((a+0.5)<<1)>>1};this.resetStagingDrawingBuffer=function(){this.stagingDrawingBuffer={len:0,map:[],keys:{},data:[]}};this.addKeyStagingDrawingBuffer=function(f,c,j,d,g){var e=this.parseInt(c)+":"+this.parseInt(j)+":"+this.parseInt(d)+":"+this.parseInt(g);var a=this.stagingDrawingBuffer;if(!a.keys.hasOwnProperty(e)){a.keys[e]=[]}a.keys[e].push(f);a.map.push(e);a.data[f]=[]};this.addDataStagingDrawingBuffer=function(e,g,h,d){var c=this.stagingDrawingBuffer;c.len=e;c.data[e].push([g,h,d])};this.drawDataStagingDrawingBuffer=function(p){var o=this;var h=function(c){var b=c.split(":");b[0]=this.parseInt(b[0]);b[1]=this.parseInt(b[1]);b[2]=this.parseInt(b[2]);b[3]=this.parseInt(b[3]);return b[0]+b[2]>0&&b[1]+b[3]>0&&b[0]-b[2]<o.width&&b[1]-b[3]<o.height};var a=0;var s=this.stagingDrawingBuffer;for(var m=0;m<=s.len;m++){var f=s.map[m];var e=s.keys[f].length-1;if(m==s.keys[f][e]&&h(f)){a++;var q=s.data[m];for(var g=0;g<q.length;g++){var r=q[g];if(r[0].match(/drawSelected/)){this[r[0]].apply(this,r[1])}else{r[1].unshift(r[0]);if(r[2]){this.addToRender(r[1],r[2],false,null,false,p)}else{this.addToRender(r[1],false,false,null,false,p)}}}}}this.resetStagingDrawingBuffer()}};CanvasXpress.prototype.initPlotUtils=function(){this.setVideoControls=function(){if(this.isVideo){var b=this;if(typeof _V_=="undefined"||!_V_.autoSetupTimeout){setTimeout(function(){b.setVideoControls()},100)}else{var e=_V_(this.target+"-cX-Video");var a=this.$(this.target+"-cX-Video");if(e&&a){a.style.position="absolute";a.style.background="transparent";this.video=a.childNodes[0];this.video.style.display="none";this.video.style.zIndex=-1;this.video.playbackRate=this.videoPlaybackRate;b.addEvtListener(this.video,"loadeddata",function(){b.addEvtListener(b.video,"play",b.videoPlay,false)},false);if(this.videoAutoplay){e.play();var c=function(){this.play=function(){if(b.video.readyState==4){b.drawVideo(b.video,b.width,b.height);clearInterval(d)}};var d=b.setInterval(this.play,30)};c.call()}}}}};this.drawLayoutCanvasCompartments=function(){this.functionCaller="drawLayoutCanvasCompartments";var n=this.canvasBoxColor;var m=this.height;var s=this.width;var g=this.left;var d=this.right;var p=this.bottom;var u=this.top;var j=this.marginLeft;var e=this.marginRight;var q=this.marginBottom;var a=this.marginTop;var o=this.layoutLeft;var k=this.layoutRight;var f=this.layoutBottom;var i=this.layoutTop;this.addToRender(["drawShape","rectangle",(j+this.offsetX)+(this.layoutWidth/2),(a+this.offsetY)+(this.layoutHeight/2),this.layoutWidth,this.layoutHeight,false,n,"open"]);this.addToRender(["drawLine","line",j,0,j,m,n]);this.addToRender(["drawLine","line",o+j,0,o+j,m,n]);this.addToRender(["drawLine","line",0,a,s,a,n]);this.addToRender(["drawLine","line",0,a+i,s,a+i,n]);this.addToRender(["drawLine","line",s-e,0,s-e,m,n]);this.addToRender(["drawLine","line",s-(e+k),0,s-(e+k),m,n]);this.addToRender(["drawLine","line",0,m-q,s,m-q,n]);this.addToRender(["drawLine","line",0,m-(q+f),s,m-(q+f),n]);this.addToRender(["drawLine","line",o+j+g,0,o+j+g,m,n]);this.addToRender(["drawLine","line",0,a+i+u,s,a+i+u,n]);this.addToRender(["drawLine","line",s-(e+k+d),0,s-(e+k+d),m,n]);this.addToRender(["drawLine","line",0,m-(q+f+p),s,m-(q+f+p),n])};this.drawCanvasBox=function(a){this.functionCaller="drawCanvasBox";if(this.canvasBox&&(this.graphType!="Network"||a)){this.addToRender(["disableGradientTransparencyShadow"]);this.addToRender(["drawShape","rectangle",this.width/2,this.height/2,this.width-2,this.height-2,false,this.canvasBoxColor,"open"]);this.addToRender(["enableGradientTransparencyShadow"])}};this.drawPlotWindow=function(){this.functionCaller="drawPlotWindow";if(this.backgroundType.match("window")){this.addToRender(["disableGradientTransparencyShadow"]);var a=this.marginLeft+this.offsetX+this.left;var b=this.marginTop+this.offsetY+this.top;if(this.backgroundType=="windowSolidGradient"){var c=this.getLinearGradient(a,b,this.gradientOrientation=="vertical"?a:b+this.y,this.gradientOrientation=="vertical"?a+this.x:b,this.backgroundGradient1Color,this.backgroundGradient2Color);this.addToRender(["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x,this.y,c,c])}else{if(this.backgroundType=="windowImage"){this.addToRender(["drawShape","image",a+(this.x/2),b+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage])}else{this.addToRender(["drawShape","rectangle",a+(this.x/2),b+(this.y/2),this.x,this.y,this.backgroundWindow,this.backgroundWindow])}}this.addToRender(["enableGradientTransparencyShadow"])}};this.validateSegregation=function(){var e="";var b=this.segregateVariablesBy;var d=this.segregateSamplesBy;if(b.length>0){var a=[];for(var c=0;c<b.length;c++){if((this.data.z&&this.data.z.hasOwnProperty(b[c]))||b[c]=="variable"){a.push(b[c])}}b=a}if(d.length>0){var a=[];for(var c=0;c<d.length;c++){if((this.data.x&&this.data.x.hasOwnProperty(d[c]))||d[c]=="sample"){a.push(d[c])}}d=a}if(b.length>0&&d.length>0){if(d.length>1){while(d.length>1){d.pop()}e+="Only one sample segregation when variable segregation is selected\n";e+="segregateSamplesBy was set to: "+d[0]+"\n"}if(b.length>1){while(b.length>1){b.pop()}e+="Only one variable segregation when sample segregation is selected\n";e+="segregateVariblesBy was set to: "+b[0]+"\n"}}else{if(d.length>0){if(d.length>2){while(d.length>2){d.pop()}e+="Maximum of two sample segregations\n";e+="segregateSamplesBy was set to: "+d[0]+","+d[1]+"\n"}}else{if(b.length>0){if(b.length>2){while(b.length>2){b.pop()}e+="Maximum of two variable segregations\n";e+="segregateVariablesBy was set to: "+b[0]+","+b[1]+"\n"}}}}if(e!=""){this.removeMenus();alert(e);return false}return true};this.validateOverlays=function(){if(this.smpOverlays.length>0){var a=[];for(var b=0;b<this.smpOverlays.length;b++){if(this.smpOverlays[b]=="-"||(this.data.x&&this.data.x.hasOwnProperty(this.smpOverlays[b]))){a.push(this.smpOverlays[b])}}this.smpOverlays=a}if(this.varOverlays.length>0){var a=[];for(var b=0;b<this.varOverlays.length;b++){if(this.varOverlays[b]=="-"||(this.data.z&&this.data.z.hasOwnProperty(this.varOverlays[b]))){a.push(this.varOverlays[b])}}this.varOverlays=a}};this.isDotplotGraph=function(){if(this.graphType.match(/Dotplot/)){return true}else{if(this.graphType=="Boxplot"&&(this.showBoxplotOriginalData||this.showViolinBoxplot)){return true}else{return false}}}};CanvasXpress.prototype.initConfigUtils=function(){this.encode=function(a){return btoa(encodeURIComponent(a).replace(/%([0-9A-F]{2})/g,function(b,c){return String.fromCharCode("0x"+c)}))};this.decode=function(a){return decodeURIComponent(Array.prototype.map.call(atob(a),function(b){return"%"+("00"+b.charCodeAt(0).toString(16)).slice(-2)}).join(""))};this.getFileName=function(a){return a.substring(a.lastIndexOf("/")+1)};this.getTitleSubtitleHeight=function(){var b=0;var a;this.setTitleSubtitleFont();if(this.title){a=this.title.split(/\n/);b+=(this.margin+this.getFontPt(this.titleFont))*a.length;if(this.subtitle){a=this.subtitle.split(/\n/);b+=(this.margin+this.getFontPt(this.subtitleFont))*a.length}b+=this.margin}return b};this.setTitleSubtitleFont=function(){this.setPropertyFontSize(this.width,"titleFont");this.adjustFont(this.title,"titleFont",this.width);this.setPropertyFontSize(this.width,"subtitleFont");this.adjustFont(this.subtitle,"subtitleFont",this.width)};this.drawTitle=function(){this.functionCaller="drawTitle";this.setTitleSubtitleFont();if(this.title){var a=this.titleAlign=="left"?this.marginLeft+this.left:this.titleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;var b=this.marginTop+(this.getFontPt(this.titleFont)/2);if(this.isMap){a+=parseInt(this.meta.canvas.ctx2.canvas.style.left);b+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}this.addToRender(["drawText",this.title,a,b,this.titleFont,this.titleColor,this.titleAlign=="left"?"left":this.titleAlign=="right"?"right":"center","middle"]);if(this.subtitle){a=this.subtitleAlign=="left"?this.marginLeft+this.left:this.subtitleAlign=="right"?this.width-(this.marginRight+this.right):this.width/2;this.addToRender(["drawText",this.subtitle,a,b+(this.getFontPt(this.titleFont)/2)+this.margin+(this.getFontPt(this.subtitleFont)/2),this.subtitleFont,this.subtitleColor,this.subtitleAlign=="left"?"left":this.subtitleAlign=="right"?"right":"center","middle"])}}};this.getFontHeight=function(){this.setFont();return this.getFontPt(this.font)};this.setFont=function(){var b;if(this.autoScaleFont){var c=1-this.percentAspectRatioPlotArea;var a=this.layoutComb?(this.width/this.layoutCols)*c*2.5:this.width*c;var e=this.layoutComb?(this.height/this.layoutRows)*c*2.5:this.height*c;b=Math.min(Math.max(parseInt((Math.max(a,e)/30)*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}else{b=Math.min(Math.max(parseInt(this.fontSize*this.fontScaleFontFactor),this.minTextSize),this.maxTextSize)}this.font=this.fontStyle+" "+b+"px "+this.fontName};this.setPropertyFontSize=function(h,f,c){if(!h||!f){return}var a=1;var e={titleFont:a+4,subtitleFont:a+2,decorationFont:a,axisTickFont:a,axisTitleFont:a,smpLabelFont:a,smpTitleFont:a,varLabelFont:a,varTitleFont:a,legendFont:a,overlayFont:a,citationFont:a-10,motionCurrentFont:a+50};var g=f.replace("Font","ScaleFontFactor");this[f+"Size"]=Math.min(Math.max(parseInt((h/30)*this[g])+e[f],this.minTextSize),c||this.maxTextSize);this[f]=this[f+"Style"]+" "+this[f+"Size"]+"px "+this.fontName};this.adjustFont=function(b,c,g){if(b&&c&&g){var e=this.getFontPt(this[c]);var a=this.measureText(b,this[c]);while(a>g&&e>this.minTextSize){e--;this[c]=this[c+"Style"]+" "+e+"px "+this.fontName;a=this.measureText(b,this[c])}}};this.setAspectRatioProperties=function(){if(this.adjustAspectRatio){var b=this.meta.config.orig;var g=Math.min(this.width,this.height);var f=this.zoomScale?this.zoom:1;var e=["ringSeparation","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","dataPointSize"];if(this.adjustAspectRatioHeatmapIndicator){e.push("heatmapIndicatorHeight");e.push("heatmapIndicatorWidth")}for(var c=0;c<e.length;c++){if(!b[e[c]]){b[e[c]]=this[e[c]]}}for(var c=0;c<e.length;c++){this[e[c]]=Number(Math.max(0.5,g*this[e[c]]/833).toFixed(1))}if(this.layoutValid){var a=Math.max(this.layoutRows,this.layoutCols);this.dataPointSize=Number(Math.max(0.5,this.dataPointSize/a).toFixed(1))}if(this.graphType=="Network"){var h=this.data.nodes.length;this.nodeSize=h>50?30:h>30?40:50}}};this.resetAspectRatioProperties=function(){if(this.adjustAspectRatio){if(this.graphType=="Network"&&!this.layoutDone){this.setTimeout(this.resetAspectRatioProperties,50);return}var a=this.meta.config.orig;var c=["ringSeparation","margin","marginLeft","marginTop","marginRight","marginBottom","overlaysThickness","dendrogramHeight","heatmapSeparatorThickness","dataPointSize"];if(this.adjustAspectRatioHeatmapIndicator){c.push("heatmapIndicatorHeight");c.push("heatmapIndicatorWidth")}for(var b=0;b<c.length;b++){if(a[c[b]]){this[c[b]]=a[c[b]];delete (a[c[b]])}}}};this.drawCitation=function(){this.functionCaller="drawCitation";if(this.citation){var c=this.width-this.margin;var d=this.height-this.margin;if(this.isMap){c+=parseInt(this.meta.canvas.ctx2.canvas.style.left);d+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}var b=20*this.printMagnification;this.setPropertyFontSize(this.width,"citationFont",b);var a=this.measureText(this.citation,this.citationFont);var e=1;while(a>this.width||e>9){b/=2;this.setPropertyFontSize(this.width,"citationFont",b);a=this.measureText(this.citation,this.citationFont);e++}this.addToRender(["drawText",this.citation,c,d,this.citationFont,this.citationColor,"right","bottom"])}};this.drawCx=function(){var b=this.hexToString("686578546f537472696e67");var e=this[b]("6472617754657874");var c=this[b]("6d657461");if(CanvasXpress[this[b]("666163746f7279")][this[b]("76616c6964")]!=null){switch(CanvasXpress[this[b]("666163746f7279")][this[b]("76616c6964")]){case 0:return;case 1:var a=this[b]("4e6f7420612076616c696420636f7079206f662063616e766173587072657373");this[e](a,this.width/2,this.height/2,this.font,"rgba(0,0,0,0.5)","center","middle");return;case 2:var a=this[b]("556e737570706f727465642063616e7661735870726573732056657273696f6e");this[e](a,this.width/2,this.height/2,this.font,"rgba(0,0,0,0.5)","center","middle");return;case 3:var a=this[b]("63616e76617358707265737320522076657273696f6e206f6e6c79");this[e](a,this.width/2,this.height/2,this.font,"rgba(0,0,0,0.5)","center","middle");return;default:return}}};this.getGroupColor=function(b,e){if(this.isGroupedData){var a=this.data.w.grps[e];this.isGroupedData=false;var h=this.getPropertyValue(b,a[0],"colorBy");for(var d=1;d<a.length;d++){var f=this.getPropertyValue(b,a[d],"colorBy");if(f!=h){this.isGroupedData=true;return this.foreground}}this.isGroupedData=true;return h}else{return this.getPropertyValue(b,e,"colorBy")}};this.drawSelectedBackgroundLabel=function(b,c,a,d){this.functionCaller="drawSelectedBackgroundLabel";if(this.isInSelectedDataPoints(b,c)){if(this.selectDataMode=="name"){if(this.selectDataModeDescription&&this.data.z&&this.data.z[this.selectDataModeDescription]){lab=this.data.z[this.selectDataModeDescription][b]||this.data.y.vars[b]}else{lab=this.data.y.vars[b]}this.addToRender(["drawText",lab,a,d,this.varLabelFont,this.foreground,"center","middle"])}return true}return false};this.drawSelectedBackground=function(i,k,l,b,f,g,d,a,j,e,c){this.functionCaller="drawSelectedBackground";if(this.isInSelectedDataPoints(i,k)){if(this.selectDataMode=="area"){this.addToRender(["drawShape",l,b,f,g+5,d+5,this.selectedBackgroundColor,this.foreground,"closed",a,1,j,false,e,c])}return true}return false};this.isInSelectedDataPoints=function(a,c){if(this.isSelectDataPoints){if(this.graphType=="Scatter2D"&&this.isHistogram){if(this.data.y.histogram[a][c]&&this.data.y.histogram[a][c].length>0){for(var b=0;b<this.data.y.histogram[a][c].length;b++){var d=this.data.y.histogram[a][c][b];if(this.selectDataPoint[d]){if(this.broadcastType=="var"){return true}else{if(this.selectDataPoint[d].hasOwnProperty(c)){return true}}}}}}else{if(this.selectDataPoint[a]){if(this.broadcastType=="var"){return true}else{if(this.selectDataPoint[a].hasOwnProperty(c)){return true}}}}}return false};this.isVisibleSelectedDataPoint=function(a,b){if(this.isSelectDataPoints){if(this.hideDataPoint.length>0&&this.hideDataPoint[a]){if(this.broadcastType=="var"){return false}else{if(this.hideDataPoint[a].hasOwnProperty(b)){return false}}}}return true};this.getVarColor=function(a,c){if(this.isArray(this.highlightVar)){for(var b=0;b<this.highlightVar.length;b++){if(this.highlightVar[b]==a){return this.varHighlightColor}}}else{if(this.highlightVar==a){return this.varHighlightColor}}return c?this.dendrogramColor:this.varLabelFontColor};this.getSmpColor=function(c,b){if(this.isArray(this.highlightSmp)){for(var a=0;a<this.highlightSmp.length;a++){if(this.highlightSmp[a]==c){return this.smpHighlightColor}}}else{if(this.highlightSmp==c){return this.smpHighlightColor}}return b?this.dendrogramColor:this.smpLabelFontColor};this.getNodeColor=function(c,a){if(this.isArray(this.highlightNode)){for(var b=0;b<this.highlightNode.length;b++){if(this.highlightNode[b]==c){return this.nodeHighlightColor}}}else{if(this.highlightNode==c){return this.nodeHighlightColor}}return this.selectNode.hasOwnProperty(c)?this.nodeHighlightColor:a?a:this.nodeFontColor};this.getTechnicalIndicatorColor=function(a){return this[a.toLowerCase()+"Color"]?this[a.toLowerCase()+"Color"]:"rgb(255,255,0)"};this.getDendrogramColor=function(a,c){if(a){if(this.colorVarDendrogramBy&&this.data.z&&this.data.z.hasOwnProperty(this.colorVarDendrogramBy)){var b=this.getVariableIndices(a);if(b>-1){return this.getPropertyValue(b,false,"colorVarDendrogramBy")}}return this.getVarColor(a,true)}else{if(this.colorSmpDendrogramBy&&this.data.x&&this.data.x.hasOwnProperty(this.colorSmpDendrogramBy)){var b=this.getSampleIndices(c);if(b>-1){return this.getPropertyValue(false,b,"colorSmpDendrogramBy")}}return this.getSmpColor(c,true)}};this.isStringOverlays=function(c){var a=this.meta.data;if((!c||c=="v")&&a.z&&this.varOverlays.length>0){for(var b=0;b<this.varOverlays.length;b++){var d=this.varOverlays[b];if(a.z[d].type!="Numeric"){return true}}}if((!c||c=="s")&&a.x&&this.smpOverlays.length>0){for(var b=0;b<this.smpOverlays.length;b++){var d=this.smpOverlays[b];if(a.x[d].type!="Numeric"){return true}}}return false};this.isUniqueFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].unique){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].unique){return true}}}return false};this.isNumericFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type=="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type=="Numeric"){return true}}}return false};this.isStringFactor=function(b){var a=this.meta.data;if((!b||b=="v")&&a.z){for(var c in a.z){if(a.z[c].type!="Numeric"){return true}}}if((!b||b=="s")&&a.x){for(var c in a.x){if(a.x[c].type!="Numeric"){return true}}}return false};this.getBestSizes=function(g,f){if(this.graphType=="Network"){var d=f?0.5:0.05;var a=Math.min(parseInt(2/g*10)/10,d);var e=[0.5];for(var c=0;c<g-1;c++){e.push(e[c]+a)}return e}else{if(g>this.sizes.length){return this.cloneObject(this.sizes)}else{var e=[];var b=Math.floor(this.sizes.length/g);for(var c=0;c<g;c++){e.push(this.sizes[c*b])}return e}}};this.isBinConfigurations=function(){for(var a in this.binConfigurations){return true}return false};this.initValidity=function(){var y=this.hexToString("686578546f537472696e67");var C=this[y]("6d657461");var n=this[y]("666163746f7279");var k=this[y]("636c69656e74");var e=this[y]("656e636f6465");var A=this[y]("76616c6964");var d=this[y]("74696d65");var D=this[y]("7374617274");var a=this[y]("73697465537263");var B=this[y]("757365724964");var a=this[y]("76657273696f6e");var i=this[y]("68726566");var p=new RegExp(this[y]("63616e7661737870726573732e6f7267"));var j=new RegExp(this[y]("5e66696c653a"));var o=new RegExp(this[y]("626d732e636f6d"));var g=new RegExp(this[y]("6c6f63616c686f7374"));CanvasXpress[n][k]=this[e]([this[C][d][D],this[B],CanvasXpress[n][a],this[i]].join("::"));this.setPixelImage();if(this[B]==1){if(navigator.onLine){if(this[i]&&CanvasXpress[n][a]){CanvasXpress[n][A]=0}else{if(this[i]&&j.test(this[i])){CanvasXpress[n][A]=0}else{if(this[i]&&g.test(this[i])){CanvasXpress[n][A]=0}else{if(this[i]&&!p.test(this[i])){CanvasXpress[n][A]=1}else{CanvasXpress[n][A]=0}}}}}else{CanvasXpress[n][A]=0}}else{if(this[B]==2&&!this.isR){CanvasXpress[n][A]=3}else{if(this[B]==3&&!o.test(this[i])&&!g.test(this[i])&&!j.test(this[i])){CanvasXpress[n][A]=1}else{CanvasXpress[n][A]=0}}}};this.getWorstAspectRatio=function(k,j){if(!k||k.length==0){return Number.MAX_VALUE}else{var e=0;var f=0;var b=Number.MAX_VALUE;for(var c=0;c<k.length;c++){var g=k[c].area;e+=g;b=(b<g)?b:g;f=(f>g)?f:g}var d=j*j;var h=e*e;return Math.max(d*f/h,h/(d*b))}};this.adjustTreemapCoords=function(f,e){if(f){var c=this.treemapBorderWidth?1:0;var a=this.treemapBorderWidth;var b=a*2;var d=this.smpLabelFontSize*c;e.left+=a;if(e.height>d+b){e.top+=d+a;e.height-=(d+b);e.border=2}else{if(e.height>b){e.top+=a;e.height-=b;e.border=1}else{if(e.height>a){e.height-=a;e.border=0}else{e.border=-1}}}e.width-=b}};this.setTreemapRowVerticalLayout=function(k,h,g,f){var c=0;for(var b=0;b<k.length;b++){c+=k[b].area}var a=c/h;var e=0;for(var b=0;b<k.length;b++){var j=k[b].area/a;k[b].coords={width:a,height:j,left:g.left,top:g.top+e};this.adjustTreemapCoords(f,k[b].coords);e+=j}var d={width:g.width-a,height:g.height,left:g.left+a,top:g.top};d.orientation=Math.min(d.width,d.height);if(d.orientation!=d.height){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return d};this.setTreemapRowHorizontalLayout=function(l,j,h,g){var d=0;for(var c=0;c<l.length;c++){d+=l[c].area}var k=d/j;var f=h.top;var b=0;for(var c=0;c<l.length;c++){var a=l[c].area/k;l[c].coords={width:a,height:k,left:h.left+b,top:f};this.adjustTreemapCoords(g,l[c].coords);b+=a}var e={width:h.width,height:h.height-k,left:h.left,top:h.top+k};e.orientation=Math.min(e.width,e.height);if(e.orientation!=e.width){this.treemapOrientation=this.treemapOrientation=="horizontal"?"vertical":"horizontal"}return e};this.setTreemapRowLayout=function(a,b,c,d){if(this.treemapOrientation=="horizontal"){return this.setTreemapRowVerticalLayout(a,b,c,d)}else{return this.setTreemapRowHorizontalLayout(a,b,c,d)}};this.computeTreemapDimensions=function(a,c,b,f,h){if(a.length+c.length==1){var e=(a.length==1)?a:c;e[0].coords=f;this.adjustTreemapCoords(h,e[0].coords);return}if(a.length>=2&&c.length==0){c=[a.shift()]}if(a.length==0){if(c.length>0){this.setTreemapRowLayout(c,b,f,h)}return}var d=a[0];if(this.getWorstAspectRatio(c,b)>=this.getWorstAspectRatio([d].concat(c),b)){this.computeTreemapDimensions(a.slice(1),c.concat([d]),b,f,d.title)}else{var g=this.setTreemapRowLayout(c,b,f,h);this.computeTreemapDimensions(a,[],g.orientation,g,d.title)}};this.squarifyTreemap=function(a,g){var f=g.width*g.height;var e=0;var b=[];for(var d=0;d<a.length;d++){b[d]=parseFloat(a[d].area);e+=b[d]}for(var d=0;d<b.length;d++){a[d].area=f*b[d]/e}var c=this.treemapOrientation=="horizontal"?g.height:g.width;a.sort(function(i,h){return h.area-i.area});this.computeTreemapDimensions(a.slice(1),[a[0]],c,g,a[0].title)};this.processTreemap=function(b,d){if(!this.treemapOrientation){this.treemapOrientation="horizontal"}if(d.width>=d.height){this.treemapOrientation="horizontal"}else{this.treemapOrientation="vertical"}if(b.length){this.squarifyTreemap(b,d);for(var c=0;c<b.length;c++){var a=b[c].children?b[c].children:b[c];var d={width:b[c].coords.width,height:b[c].coords.height,left:b[c].coords.left,top:b[c].coords.top};this.processTreemap(a,d)}}return b};this.getCloudPointsAtRadius=function(a){if(this.tagCloudGridPoints[a]){return this.tagCloudGridPoints[a]}var b=a*8;var c=b;var d=[];if(a==0){d.push([this.tagCloudGridCenter[0],this.tagCloudGridCenter[1],0])}while(c--){d.push([this.tagCloudGridCenter[0]+a*Math.cos(-c/b*2*Math.PI),this.tagCloudGridCenter[1]+a*Math.sin(-c/b*2*Math.PI)*this.tagCloudTextEllipticity,c/b*2*Math.PI])}this.tagCloudGridPoints[a]=d;return d};this.getCloudRotateDeg=function(){if(this.tagCloudTextRotateRatio==0){return 0}if(this.random()>this.tagCloudTextRotateRatio){return 0}return(-Math.PI/2)+(this.random()*Math.PI)};this.getCloudTextInfo=function(z,n,o){var a=Math.min(500,Math.floor(this.tagCloudTextWeightFactor*n));var s=document.createElement("canvas");var A=s.getContext("2d",{willReadFrequently:true});var p=a+"px "+this.fontName;A.font=p;var b=this.measureText(z,p);var m=a;var i=b+m*2;var g=m*3;var B=Math.ceil(i/this.tagCloudTextGridSize);var c=Math.ceil(g/this.tagCloudTextGridSize);i=B*this.tagCloudTextGridSize;g=c*this.tagCloudTextGridSize;var t=-b*0.5;var q=-m*0.5;var u=Math.ceil((i*Math.abs(Math.sin(o))+g*Math.abs(Math.cos(o)))/this.tagCloudTextGridSize);var d=Math.ceil((i*Math.abs(Math.cos(o))+g*Math.abs(Math.sin(o)))/this.tagCloudTextGridSize);var v=d*this.tagCloudTextGridSize;var r=u*this.tagCloudTextGridSize;if(v<1||r<1){return{occupied:[],bounds:[0,0,0,0],gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}}s.setAttribute("width",v);s.setAttribute("height",r);A.save();A.translate(v/2,r/2);A.rotate(-o);A.font=a+"px "+this.fontName;A.fillStyle="#000";A.textBaseline="middle";A.fillText(z,t,q+a*0.5);A.restore();var w=A.getImageData(0,0,v,r).data;var f=[];var l=d,k,j,h;var e=[u/2,d/2,u/2,d/2];while(l--){k=u;while(k--){h=this.tagCloudTextGridSize;singleGridLoop:{while(h--){j=this.tagCloudTextGridSize;while(j--){if(w[((k*this.tagCloudTextGridSize+h)*v+(l*this.tagCloudTextGridSize+j))*4+3]){f.push([l,k]);if(l<e[3]){e[3]=l}if(l>e[1]){e[1]=l}if(k<e[0]){e[0]=k}if(k>e[2]){e[2]=k}break singleGridLoop}}}}}}return{occupied:f,bounds:e,gw:d,gh:u,fillTextOffsetX:t,fillTextOffsetY:q,fillTextWidth:b,fillTextHeight:m,fontSize:a}};this.canFitCloudText=function(g,f,h,b,a){var e=a.length;while(e--){var d=g+a[e][0];var c=f+a[e][1];if(d>=this.tagCloudGridWidth||c>=this.tagCloudGridHeight||d<0||c<0||!this.tagCloudGrid[d][c]){return false}}return true};this.fillCloudGridAt=function(a,b){if(a>=this.tagCloudGridWidth||b>=this.tagCloudGridHeight||a<0||b<0){return}this.tagCloudGrid[a][b]=false};this.updateCloudGrid=function(e,c,d){var a=d.occupied;var b=a.length;while(b--){this.fillCloudGridAt(e+a[b][0],c+a[b][1])}};this.drawCloudTag=function(c,h,f,d){this.functionCaller="drawCloudTag";var j=this;var k=this.getCloudRotateDeg();var e=this.getCloudTextInfo(c,h,k);if(!e){return false}var b=e.bounds;if((b[1]-b[3]+1)>this.tagCloudGridWidth||(b[2]-b[0]+1)>this.tagCloudGridHeight){return false}var a=this.tagCloudGridMaxRadius+1;var i=this.addColorTransparency(f,0);while(a--){var l=this.getCloudPointsAtRadius(this.tagCloudGridMaxRadius-a);l=[].concat(l);this.shuffleArray(l);var g=l.some(function m(o){var u=Math.floor(o[0]-e.gw/2);var t=Math.floor(o[1]-e.gh/2);var v=e.gw;var q=e.gh;var p=e.fontSize+"px "+j.fontName;var n="1px "+j.fontName;if(!j.canFitCloudText(u,t,v,q,e.occupied)){return false}var s=((u+e.gw/2)*j.tagCloudTextGridSize);var r=((t+e.gh/2)*j.tagCloudTextGridSize);j.addToRender(["drawText",c,s,r,p,f,"center","middle",-k],d,false,null,false,[j.width/2,j.height/2,n,i,-Math.PI*2]);j.updateCloudGrid(u,t,e);return true});if(g){return true}}return false};this.setTagCloud=function(b){this.tagCloudTextGridSize=Math.max(this.tagCloudTextGridSize,4);if(this.colorBy&&this.legendColorsN){this.tagCloudGridWidth=Math.floor(this.x/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.y/this.tagCloudTextGridSize)}else{this.tagCloudGridWidth=Math.floor(this.width/this.tagCloudTextGridSize);this.tagCloudGridHeight=Math.floor(this.height/this.tagCloudTextGridSize)}this.tagCloudGridCenter=[this.tagCloudGridWidth/2,this.tagCloudGridHeight/2];this.tagCloudGridMaxRadius=Math.floor(Math.sqrt(this.tagCloudGridWidth*this.tagCloudGridWidth+this.tagCloudGridHeight*this.tagCloudGridHeight));this.tagCloudGridPoints=[];if(!b){this.setTagCloudTextWeightFactor()}else{this.tagCloudTextWeightFactor*=b}this.tagCloudGrid=[];var c=this.tagCloudGridWidth;var a;while(c--){this.tagCloudGrid[c]=[];a=this.tagCloudGridHeight;while(a--){this.tagCloudGrid[c][a]=true}}};this.setTagCloudTextWeightFactor=function(){var h=0;var b=0;var k=this.varIndices[0];for(var g=0;g<this.smpIndices.length;g++){var f=this.smpIndices[g];var j=this.getDataAtPos(k,f);var e=this.data.y.smps[f].length;var c=e*j*0.5*j;b=Math.max(c,b);h+=c}if(!this.tagCloudTries){this.tagCloudTries=1}b=parseInt(Math.max(this.width,this.height));if(h>b){this.tagCloudTextWeightFactor=(this.width*this.height)/(h*this.tagCloudTries)}else{this.tagCloudTextWeightFactor=(this.width*this.height)/(h*this.tagCloudTries*(b/h))}this.tagCloudTries+=1};this.getVariableColor=function(a){for(var b=0;b<this.data.y.vars.length;b++){if(this.data.y.vars[b]==a){return this.colors[b%this.colors.length]}}return this.colors[0]};this.getOutlineColor=function(){if(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData){return false}else{return this.objectBorderColor?this.objectBorderColor:this.foreground}};this.getDefaultMetaDataObject=function(){var a=this.meta.def.colorBrew;return{rmin:a.rmin,rmax:a.rmax,min:a.min,max:a.max,decs:a.decs,vals:a.vals,maxLevLen:a.maxLevLen,maxLevChr:a.maxLevChr,maxLevStr:a.maxLevStr,colorBrew:a}};this.setPieData=function(m,o,l){if(!this.cacheColors){this.cacheColors={PIE:{}}}else{if(!this.cacheColors.PIE){this.cacheColors.PIE={}}}var b={no:0,idso:[],ids:[],cols:[],data:{},raw:{},oprc:0,tot:this.sum(m)};for(var h=0;h<m.length;h++){var g=o?this.varIndices[h]:h;var a=m[g]/b.tot;var e=o?this.data.y.vars[g]:h;var n;if(l&&l[h%l.length]){n=l[h%l.length]}else{if(this.cacheColors.PIE.hasOwnProperty(e)){n=this.cacheColors.PIE[e]}else{n=this.pieColors[h%this.pieColors.length]?this.pieColors[h%this.pieColors.length]:this.colors[h%this.colors.length];this.cacheColors.PIE[e]=n}}if(!isNaN(a)){b.data[g]=a;b.raw[g]=m[g];if(h>=this.maxPieSectors-1){b.oprc+=a;b.idso.push(g);b.no++}else{b.ids.push(g)}b.cols.push(n)}}if(b.no){b.ids.push(-1)}return b};this.drawPie=function(t,g,f,q,H,v){this.functionCaller="drawPie";var o=function(){for(var a=0;a<t.ids.length;a++){if(t.data[t.ids[a]]&&t.data[t.ids[a]]>-1&&isNaN(t.data[t.ids[a]])){return false}}return true};if(o()){var w,d,m;var k=this.startPieSectors!=null?(this.startPieSectors*Math.PI/180)%360:0;var z=this.pieSegmentLabels=="inside"?q-(q/3):q+(q/6);var F=0;var B=this.layoutComb?this.smpIndices[0]:this.xAxisIndices?this.xAxisIndices[0]:0;for(var D=0;D<t.ids.length;D++){var h=t.ids[D];var u=h>-1?t.data[h]:t.oprc;var e=t.cols[D];w=d!=null?parseFloat(d):parseFloat((Math.PI*(2*F))-k);d=parseFloat(w+(Math.PI*(2*(u))));var G=(w+d)/2;var A=(d-w)/32;var C=this.pieType=="separated"?this.background:this.pieType=="solid"?this.foreground:this.foreground;this.drawSelectedBackground(h>-1?h:t.idso[0],B,"pie",g,f,(q*2)+10,q+10,false,true,w,d);if(this.graphType=="Network"){this.addToRender(["drawShape","pie",g,f,(q*2),q,e,e,"closed",false,1,false,false,w,d],H[D],v)}else{if(this.graphType!="Pie"){this.addToRender(["drawShape","pie",g,f,(q*2),q,e,e,"closed",false,1,false,false,w,d],H[D],v)}else{if(h>-1){this.addToRender(["drawShape","pie",g,f,(q*2),q,e,e,"closed",false,1,false,false,w,d],[h,B])}else{this.addToRender(["drawShape","pie",g,f,(q*2),q,e,e,"closed",false,1,false,false,w,d],t.idso)}}}var E=t.ids.length>1?g-Math.sin(G-(Math.PI/2))*z:g;var b=t.ids.length>1?f+Math.cos(G-(Math.PI/2))*z:f;if(this.graphType!="Network"&&this.showPieValues&&(d-w)>0.05){if(this.pieLabelType=="value"){this.addToRender(["drawText",t.raw[h],E,b,this.axisTickFont,this.axisTickColor,"center","middle"])}else{this.addToRender(["drawText",sprintf("%."+this.pieSegmentPrecision+"f",u*100)+"%",E,b,this.axisTickFont,this.axisTickColor,"center","middle"])}}F+=u}F=0;d=null;if(t.ids.length>1){for(var D=0;D<t.ids.length;D++){var h=t.ids[D];var u=h>-1?t.data[h]:t.oprc;w=d!=null?parseFloat(d):parseFloat((Math.PI*(2*F))-k);d=parseFloat(w+(Math.PI*(2*(u))));var C=this.pieType=="separated"?this.background:this.pieType=="solid"?this.foreground:this.foreground;this.addToRender(["drawShape","pie",g,f,(q*2),q,false,C,"open",false,this.pieSegmentSeparation,false,false,w,d],false,false,null,true);F+=u}}if(this.pieInnerRadius>0&&this.pieInnerRadius<1){this.addToRender(["drawShape","circle",g,f,q*this.pieInnerRadius*2,q*this.pieInnerRadius*2,this.background,this.background,"closed"])}}};this.drawBarPlot=function(U,T,N,E,B,I,D,x,M,K,V,J,X,L,R,O){this.functionCaller="drawBarPlot";var C,A,S,H;var j=this;var W=this.getOutlineColor();var F=this.variableSpaceFactor/2;var Q=B/2;if(K=="vertical"||this.graphType=="Network"){for(var P=0;P<U.length;P++){C=((U[P]-M)*D)-x;var G;if(!isNaN(C)){if(C<0){G=this.addToRender(["drawShape","rectangle",(N+F)+((B-this.variableSpaceFactor)/2),E+(-C/2),B-this.variableSpaceFactor,-C,V[P],W||V[P],J[P],false,false,R],X[P],L)}else{G=this.addToRender(["drawShape","rectangle",(N+F)+((B-this.variableSpaceFactor)/2),E-(C/2),B-this.variableSpaceFactor,C,V[P],W||V[P],J[P],false,false,R],X[P],L)}S=E-C;H=N+Q;if(T[P]&&!isNaN(T[P])){A=(T[P]/2)*D;this.addToRender(["drawLine","error",H,S,H,S-A,W||this.objectBorderColor,-Q,"butt"],false,false,G);this.addToRender(["drawLine","error",H,S,H,S+A,W||this.objectBorderColor,-Q,"butt"],false,false,G)}if(this.showDataValues){this.addToRender(["drawText",this.correctPrecisionBug(U[P]),H,E-(C+this.overlayFontSize),this.overlayFont,V[P],"center","bottom"],false,false,G)}}N+=I}}else{for(var P=0;P<U.length;P++){C=((U[P]-M)*D)-x;var G;if(!isNaN(C)){if(C<0){if(O){G=this.addToRender(["drawShape","rectangle",((N+O)-x)+(-C/2),(E+F)+((B-this.variableSpaceFactor)/2),-C,B-this.variableSpaceFactor,V[P],W||V[P],J[P],false,false,R],X[P],L)}else{G=this.addToRender(["drawShape","rectangle",(N+C)+(-C/2),(E+F)+((B-this.variableSpaceFactor)/2),-C,B-this.variableSpaceFactor,V[P],W||V[P],J[P],false,false,R],X[P],L)}}else{if(O){G=this.addToRender(["drawShape","rectangle",((N+O)-(C+x))+(C/2),(E+F)+((B-this.variableSpaceFactor)/2),C,B-this.variableSpaceFactor,V[P],W||V[P],J[P],false,false,R],X[P],L)}else{G=this.addToRender(["drawShape","rectangle",N+(C/2),(E+F)+((B-this.variableSpaceFactor)/2),C,B-this.variableSpaceFactor,V[P],W||V[P],J[P],false,false,R],X[P],L)}}S=O?(N+O)-(C+x):N+C;H=E+Q;if(T[P]&&!isNaN(T[P])){A=(T[P]/2)*D;this.addToRender(["drawLine","error",S,H,S+A,H,W||this.objectBorderColor,Q,"butt"],false,false,G);this.addToRender(["drawLine","error",S,H,S-A,H,W||this.objectBorderColor,Q,"butt"],false,false,G)}if(this.showDataValues){this.addToRender(["drawText",this.correctPrecisionBug(U[P]),S+this.overlayFontSize,H,this.overlayFont,V[P],"left","middle"],false,false,G)}}E+=I}}};this.drawLinePlot=function(ab,aa,T,M,K,X,L,S,Q,ad,O,N,af,Z,Y,U,D){this.functionCaller="drawLinePlot";var G=function(){var b=[[],[]];if(Q=="vertical"){for(var a=0;a<r[0].length;a++){b[0].push(r[0][a]);b[1].push(r[1][a][0])}for(var a=r[0].length-1;a>=0;a--){b[0].push(r[0][a]);b[1].push(r[1][a][1])}}else{for(var a=0;a<r[1].length;a++){b[0].push(r[0][a][0]);b[1].push(r[1][a])}for(var a=r[1].length-1;a>=0;a--){b[0].push(r[0][a][1]);b[1].push(r[1][a])}}return b};var P,A,y,x,j,ah,ag,D,ac,H;var J=null;var B=null;var F=K/2;var E=Math.min(10,K/3);var ae=O=="open"?ad:this.foreground;var R=ab.length-1;var I=[[],[]];var r=[[],[]];var V=[];if(Q=="vertical"){A=T;y=T+X;if(J==null){J=A}for(var W=1;W<ab.length;W++){P=W-1;if(this.isObject(L)){j=M-((ab[P]-L[P].min)*L[P].units);ah=M-((ab[W]-L[W].min)*L[W].units)}else{j=M-((ab[P]-S)*L);ah=M-((ab[W]-S)*L)}if(B==null){B=j}if(!isNaN(j)){if(this.lineDecoration&&N){this.addToRender(["drawShape",N,A,j,E,E,ad,ae,O[P],false,false,Y],af[P],Z,H,false,[J,B])}else{this.addToRender(["drawShape","sphere",A,j,E,E,this.addColorTransparency(ad,0),"rgba(0,0,0,0)",O[P],false,false,Y],af[P],Z,H,false,[J,B])}if(aa[P]!=null&&!isNaN(aa[P])){ag=(aa[P]/2)*this.isObject(L)?L[P].units:L;if(this.lineErrorType=="bar"){this.addToRender(["drawLine","error",A,j,A,j+ag,ad,-F,"butt"],false,false,H,false,[J,B]);this.addToRender(["drawLine","error",A,j,A,j-ag,ad,-F,"butt"],false,false,H,false,[J,B])}else{r[0].push([A,A]);r[1].push([j+ag,j-ag]);V.push([A,j])}}if(this.lineType=="spline"){I[0].push(A);I[1].push(j)}}if((this.lineType!="spline"&&!isNaN(j)&&!isNaN(ah))||ab.length<3){ac=this.addToRender(["drawLine","line",A,j,y,ah,ad,this.lineThickness,"butt",false,false,Y],["Line:"+D+":"+W],false,H,false,[J,B])}else{if(this.lineType=="spline"&&isNaN(ah)){ac=this.addToRender(["drawLine","spline",I[0],I[1],false,false,ad,this.lineThickness,false,false,false,Y],["Line:"+D],false,H,false,[J,B]);I=[[],[]];J=null;B=null}}if(!H){H=ac}if(r[0].length>0&&isNaN(ah)){var v=this.addColorTransparency(ad,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+D],false,null,false,V)}else{var C=G();this.addToRender(["drawShape","path",C[0],C[1],false,false,v,v,"closed"],["Line-Error:"+D],false,null,false,V)}r=[[],[]];V=[]}A+=X;y+=X}if(!isNaN(ah)){if(this.lineDecoration&&N){this.addToRender(["drawShape",N,A,ah,E,E,ad,ae,O[R],false,false,Y],af[R],Z,H,false,[J,B])}else{this.addToRender(["drawShape","sphere",A,ah,E,E,this.addColorTransparency(ad,0),"rgba(0,0,0,0)",O[R],false,false,Y],af[R],Z,H,false,[J,B])}if(aa[R]!=null&&!isNaN(aa[R])){ag=(aa[R]/2)*this.isObject(L)?L[R].units:L;if(this.lineErrorType=="bar"){this.addToRender(["drawLine","error",A,ah,A,ah+ag,ad,-F,"butt"],false,false,H);this.addToRender(["drawLine","error",A,ah,A,ah-ag,ad,-F,"butt"],false,false,H)}else{if(W==ab.length){r[0].push([A,A]);r[1].push([ah+ag,ah-ag]);V.push([A,ah])}}}if(this.lineType=="spline"){I[0].push(A);I[1].push(ah)}}if(this.lineType=="spline"){this.addToRender(["drawLine","spline",I[0],I[1],false,false,ad,this.lineThickness,false,false,false,Y],["Line:"+D],false,null,false,[J,B])}if(r[0].length>0){var v=this.addColorTransparency(ad,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+D],false,null,false,V)}else{var C=G();this.addToRender(["drawShape","path",C[0],C[1],false,false,v,v,"closed"],["Line-Error:"+D],false,null,false,V)}}}else{j=M;ah=M+X;if(B==null){B=j}for(var W=1;W<ab.length;W++){P=W-1;if(this.isObject(L)){A=U?T+U-((ab[P]-L[P].min)*L[P].units):T+((ab[P]-L[P].min)*L[P].units);y=U?T+U-((ab[W]-L[W].min)*L[W].units):T+((ab[W]-L[W].min)*L[W].units)}else{A=U?T+U-((ab[P]-S)*L):T+((ab[P]-S)*L);y=U?T+U-((ab[W]-S)*L):T+((ab[W]-S)*L)}if(J==null){J=A}if(!isNaN(A)){if(this.lineDecoration&&N){this.addToRender(["drawShape",N,A,j,E,E,ad,ae,O[P],false,false,Y],af[P],Z,H,false,[J,B])}else{this.addToRender(["drawShape","sphere",A,j,E,E,this.addColorTransparency(ad,0),"rgba(0,0,0,0)",O[P],false,false,Y],af[P],Z,H,false,[J,B])}if(aa[P]!=null&&!isNaN(aa[P])){x=(aa[P]/2)*this.isObject(L)?L[P].units:L;if(this.lineErrorType=="bar"){this.addToRender(["drawLine","error",A,j,A+x,j,ad,F,"butt"],false,false,H);this.addToRender(["drawLine","error",A,j,A-x,j,ad,F,"butt"],false,false,H)}else{r[0].push([A+x,A-x]);r[1].push([j,j]);V.push([A,j])}}if(this.lineType=="spline"){I[0].push(A);I[1].push(j)}}if((this.lineType!="spline"&&!isNaN(A)&&!isNaN(y))||ab.length<3){ac=this.addToRender(["drawLine","line",A,j,y,ah,ad,this.lineThickness,"butt",false,false,Y],["Line:"+D+":"+W],false,H,false,[J,B])}else{if(this.lineType=="spline"&&isNaN(y)){ac=this.addToRender(["drawLine","spline",I[0],I[1],false,false,ad,this.lineThickness,false,false,false,Y],["Line:"+D],false,H,false,[J,B]);I=[[],[]];J=null;B=null}}if(!H){H=ac}if(r[1].length>0&&isNaN(y)){var v=this.addColorTransparency(ad,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+D],false,null,false,V)}else{var C=G();this.addToRender(["drawShape","path",C[0],C[1],false,false,v,v,"closed"],["Line-Error:"+D],false,null,false,V)}r=[[],[]];V=[]}j+=X;ah+=X}if(!isNaN(y)){if(this.lineDecoration&&N){this.addToRender(["drawShape",N,y,j,E,E,ad,ae,O[R],false,false,Y],af[R],Z,H,false,[J,B])}else{this.addToRender(["drawShape","sphere",y,j,E,E,this.addColorTransparency(ad,0),"rgba(0,0,0,0)",O[R],false,false,Y],af[R],Z,H,false,[J,B])}if(aa[R]!=null&&!isNaN(aa[R])){x=(aa[R]/2)*this.isObject(L)?L[R].units:L;if(this.lineErrorType=="bar"){this.addToRender(["drawLine","error",y,j,y+x,j,ad,F,"butt"],false,false,H);this.addToRender(["drawLine","error",y,j,y-x,j,ad,F,"butt"],false,false,H)}else{r[0].push([y+x,y-x]);r[1].push([j,j]);V.push([y,j])}}if(this.lineType=="spline"){I[0].push(y);I[1].push(j)}}if(this.lineType=="spline"){this.addToRender(["drawLine","spline",I[0],I[1],false,false,ad,this.lineThickness,false,false,false,Y],["Line:"+D],false,null,false,[J,B])}if(r[1].length>0){var v=this.addColorTransparency(ad,0.3);if(this.lineType=="spline"){this.addToRender(["drawShape","confidence",r[0],r[1],false,false,v,v,"closed"],["Line-Error:"+D],false,null,false,V)}else{var C=G();this.addToRender(["drawShape","path",C[0],C[1],false,false,v,v,"closed"],["Line-Error:"+D],false,null,false,V)}}}};this.drawStackedPlot=function(N,G,A,s,P,C,K,y,m,D,O,B,Q,F,H,L){this.functionCaller="drawStackedPlot";var h=A;var r=G;var j=this;var J=function(c,e,b,d,a){return j.processTreemap(c,{width:d,height:a,left:e,top:b})};if(D=="vertical"){A=h-m;for(var I=0;I<N.length;I++){if(N[I]>0){var x=C?(N[I]*100/K[0])*y:N[I]*y;if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+(s/2),A-(x/2),s,x,O[I],O[I]],Q[I],F)}else{if(P){var E=J(P[I],G,A-x,s,x);this.drawTreemap(E,0,0)}else{this.addToRender(["drawShape","rectangle",G+(s/2),A-(x/2),s,x,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}A-=x}}A=h-m;for(var I=N.length-1;I>=0;I--){if(N[I]<0){var x=C?(N[I]*100/-K[1])*y:N[I]*y;if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+(s/2),A-(x/2),s,-x,O[I],O[I]],Q[I],F)}else{if(P){var E=J(P[I],G,A-x,s,-x);this.drawTreemap(E,0,0)}else{this.addToRender(["drawShape","rectangle",G+(s/2),A-(x/2),s,-x,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}A-=x}}}else{G=r+m;for(var I=0;I<N.length;I++){if(N[I]>0){var x=C?(N[I]*100/K[0])*y:N[I]*y;if(H){if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+H-(x/2),A+(s/2),x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F)}else{if(P){var E=J(P[I],G+H-x,A,x,s);this.drawTreemap(E,0,0)}else{this.addToRender(["drawShape","rectangle",G+H-(x/2),A+(s/2),x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}G-=x}else{if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+(x/2),A+(s/2),x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F)}else{if(P){var M=J(P[I],G,A,x,s);this.drawTreemap(M,0,0)}else{this.addToRender(["drawShape","rectangle",G+(x/2),A+(s/2),x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}G+=x}}}G=r+m;for(var I=N.length-1;I>=0;I--){if(N[I]<0){var x=C?(N[I]*100/-K[1])*y:N[I]*y;if(H){if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+H-(x/2),A+(s/2),-x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F)}else{if(P){var E=J(P[I],G+H-x,A,-x,s);this.drawTreemap(E,0,0)}else{this.addToRender(["drawShape","rectangle",G+H-(x/2),A+(s/2),-x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}G-=x}else{if(this.graphType=="Network"){this.addToRender(["drawShape","rectangle",G+(x/2),A+(s/2),-x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F)}else{if(P){var M=J(P[I],G,A,-x,s);this.drawTreemap(M,0,0)}else{this.addToRender(["drawShape","rectangle",G+(x/2),A+(s/2),-x,s,O[I],this.objectBorderColor?this.objectBorderColor:this.foreground,B[I]],Q[I],F,null,false,L)}}G+=x}}}}};this.drawAreaPlot=function(ah,Z,S,Q,ad,T,af,V,J,D,m,X,ae,aj,W,al,ak,M,G){this.functionCaller="drawAreaPlot";var Y=ah.length-1;var aa=ae&&this.lineType=="rect"?"path":this.lineType=="rect"?"polygon":"spline";var A=[];var B=[];var U=[];var am=-D*J;var C=m*J;var L=function(b,a){for(var c=a+1;c<ah[b].length;c++){if(ah[b][c]>0){return 1}else{if(ah[b][c]<0){return -1}}}return 0};if(X=="vertical"){for(var ac=0;ac<ah[0].length;ac++){A[ac]=af=="stacked"&&D<0?S-C:S;B[ac]=S-C}for(var ac=0;ac<ah.length;ac++){var ag=Z;var P=ae?[]:[Z];var N=ae?[]:[S-am];var H=0;var ai,K;for(var ab=0;ab<ah[0].length;ab++){if(isNaN(ah[ac][ab])){if(!ae){P.push(ag-T);N.push(S-am)}if(ae&&this.lineType=="spline"){this.addToRender(["drawLine",aa,P,N,false,false,aj[ac],this.lineThickness],al[ac],ak,null,false,S-am)}else{if(D>=0&&Y>0&&af!="normal"){var E=U[U.length-1][1];P.shift();var F=[];var an=[];for(var ac=1;ac<N.length;ac++){F.push([P[ac-1],P[ac-1]]);an.push([N[ac],E[ac]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,aj[Y],this.objectBorderColor?this.objectBorderColor:aj[Y],W[Y]],al[Y],ak,null,false,S-am)}else{this.addToRender(["drawShape",aa,P,N,this.width,this.height,aj[ac],this.objectBorderColor?this.objectBorderColor:aj[ac],W[ac]],al[ac],ak,null,false,S-am)}}if(G){var u=this.addColorTransparency(aj[ac],0);for(var I=0;I<P.length;I++){ai=this.addToRender(["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],[al[ac][0],G[I]],false,null,true);if(!ae){this.addToRender(["drawLine","line",P[I],N[I]+T,P[I],N[0],u,T],[al[ac][0],G[I]],false,ai,true)}}}P=ae?[]:[ag+T];N=ae?[]:[S-am]}else{var R=af=="percent"?((ah[ac][ab]-D)*100/V[ab])*J:(ah[ac][ab]-(af=="stacked"&&D<0?0:D))*J;P.push(ag);if(af&&(af=="stacked"||af=="percent")){if(ah[ac][ab]>0||H>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{if(ah[ac][ab]<0||H<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{var O=L(ac,ab);if(O<0){N.push(B[ab]-R);B[ab]-=R;H=-1}else{if(O>0){N.push(A[ab]-R);A[ab]-=R;H=1}else{N.push(am)}}}}}else{N.push(S-R)}}ag+=T}if(!ae){P.push(Z+Q);N.push(S-am)}U.push([P,N,aj[ac],W[ac],al[ac]])}}else{for(var ac=0;ac<ah[0].length;ac++){A[ac]=M?Z+M:af=="stacked"&&D<0?Z+C:Z;B[ac]=Z+C}for(var ac=0;ac<ah.length;ac++){var ag=S;var P=ae?[]:M?[Z+M]:[Z+am];var N=ae?[]:[S];var H=0;var ai,K;for(var ab=0;ab<ah[0].length;ab++){if(isNaN(ah[ac][ab])){if(!ae){P.push(M?Z+M:Z+am);N.push(ag-T)}if(ae&&this.lineType=="spline"){this.addToRender(["drawLine",aa,P,N,false,false,aj[ac],this.lineThickness],al[ac],ak,null,false,Z+am)}else{var E=U[U.length-1][0];if(D>=0&&Y>0&&af!="normal"){N.shift();var F=[];var an=[];for(var ac=1;ac<P.length;ac++){F.push([P[ac],E[ac]]);an.push([N[ac-1],N[ac-1]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,aj[Y],this.objectBorderColor?this.objectBorderColor:aj[Y],W[Y]],al[Y],ak,null,false,Z+am)}else{this.addToRender(["drawShape",aa,P,N,this.width,this.height,aj[ac],this.objectBorderColor?this.objectBorderColor:aj[ac],W[ac]],al[ac],ak,null,false,Z+am)}}if(G){var u=this.addColorTransparency(aj[ac],0);for(var I=0;I<P.length;I++){ai=this.addToRender(["drawShape","sphere",P[I],N[I],T,T,u,"rgba(0,0,0,0)",W[ac]],[al[ac][0],G[I]],false,null,true);if(!ae){this.addToRender(["drawLine","line",P[I]-T,N[I],P[0],N[I],u,T],[al[ac][0],G[I]],false,ai,true)}}}P=ae?[]:[M?Z+M:Z+am];N=ae?[]:[ag+T]}else{var R=af=="percent"?((ah[ac][ab]-D)*100/V[ab])*J:(ah[ac][ab]-(af=="stacked"&&D<0?0:D))*J;N.push(ag);if(af&&(af=="stacked"||af=="percent")){if(M){P.push(A[ab]-R);A[ab]-=R}else{if(ah[ac][ab]>0||H>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{if(ah[ac][ab]<0||H<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{var O=L(ac,ab);if(O<0){P.push(B[ab]+R);B[ab]+=R;H=-1}else{if(O>0){P.push(A[ab]+R);A[ab]+=R;H=1}else{N.push(am)}}}}}}else{P.push(M?Z+M-R:Z+R)}}ag+=T}if(!ae){P.push(M?Z+M:Z+am);N.push(S+ad)}U.push([P,N,aj[ac],W[ac],al[ac]])}}while(Y>=0){var ai,K;var ab=U.pop();if(ae){if(this.lineType=="spline"){this.addToRender(["drawLine",aa,ab[0],ab[1],false,false,ab[2],this.lineThickness],ab[4],ak,null,false,X=="vertical"?S-am:Z+am)}else{var K=null;for(var ac=1;ac<ab[0].length;ac++){var ai=this.addToRender(["drawLine",aa,ab[0][ac-1],ab[1][ac-1],ab[0][ac],ab[1][ac],ab[2],this.lineThickness],ab[4],ak,K,false,X=="vertical"?S-am:Z+am);if(K==null){K=ai}}}}else{if(D>=0&&Y>0&&af!="normal"){var E=X=="vertical"?U[U.length-1][1]:U[U.length-1][0];if(X=="vertical"){ab[0].shift();ab[0].pop();var F=[];var an=[];for(var ac=1;ac<ab[1].length-1;ac++){F.push([ab[0][ac-1],ab[0][ac-1]]);an.push([ab[1][ac],E[ac]])}ab[1].shift();ab[1].pop();this.addToRender(["drawShape","confidence",F,an,this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,S-am)}else{ab[1].shift();ab[1].pop();var F=[];var an=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],E[ac]]);an.push([ab[1][ac-1],ab[1][ac-1]])}ab[0].shift();ab[0].pop();this.addToRender(["drawShape","confidence",F,an,this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,Z+am)}}else{if(af=="normal"||af=="stacked"){this.addToRender(["drawShape",aa,ab[0],ab[1],this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,X=="vertical"?S-am:Z+am)}else{if(X=="vertical"){var an=[];for(var ac=1;ac<ab[1].length-1;ac++){an.push([ab[1][ac],ab[1][0]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,S-am)}else{var F=[];for(var ac=1;ac<ab[0].length-1;ac++){F.push([ab[0][ac],ab[0][0]])}this.addToRender(["drawShape","confidence",F,an,this.width,this.height,ab[2],this.objectBorderColor?this.objectBorderColor:ab[2],ab[3]],ab[4],ak,null,false,Z+am)}}}}if(G){var u=this.addColorTransparency(ab[2],0);var g=Math.min(10,T);for(var ac=0;ac<ab[0].length;ac++){ai=this.addToRender(["drawShape","sphere",ab[0][ac],ab[1][ac],g,g,u,"rgba(0,0,0,0)",ab[3]],[ab[4][0],G[ac]],false,null,true);if(!ae){if(X=="vertical"){this.addToRender(["drawLine","line",ab[0][ac],ab[1][ac]+T,ab[0][ac],ab[1][0],u,T],[ab[4][0],G[ac]],false,ai,true)}else{this.addToRender(["drawLine","line",ab[0][ac]-T,ab[1][ac],ab[0][0],ab[1][ac],u,T],[ab[4][0],G[ac]],false,ai,true)}}}}Y--}};this.drawBoxPlot=function(S,L,D,A,H,C,K,J,T,I,V,Q){this.functionCaller="drawBoxPlot";var y=function(a){return J=="vertical"?D-((a-K)*C):L+((a-K)*C)};var U=this.foreground;var E=this.variableSpaceFactor/2;var O=A/2;var n=O/2;var k=n/2;var R=A/this.boxPlotOutliersRatio;var x={};if(J=="vertical"){for(var N=0;N<S.length;N++){var G=L+O;var B=[];var P=[];var e=this.showBoxplotOriginalData||this.showViolinBoxplot?Q[N]:T[N];for(var M=0;M<5;M++){B.push(y(S[N][M]));P.push(B[B.length-1].toString())}var F=this.addToRender(["drawShape","rectangle",(L+E)+((A-this.variableSpaceFactor)/2),B[3]+((B[2]-B[3])/2),A-this.variableSpaceFactor,B[2]-B[3],T[N],this.objectBorderColor?this.objectBorderColor:T[N],I[N]],V[N],false,null,false,D);if(this.unique(P).length!=1){this.addToRender(["drawLine","median",L+E,B[4],L+(A-E),B[4],this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],false,false,F);this.addToRender(["drawLine","error",G,B[2],G,B[0],U,-O,"butt"],false,false,F);this.addToRender(["drawLine","error",G,B[3],G,B[1],U,-O,"butt"],false,false,F)}if(this.boxplotMean){this.addToRender(["drawShape","rectangle",G,y(S[N][6]),n,n,this.boxplotMeanColor,this.boxplotMeanColorBorder],false,false,F,false,D)}if(S[N][5]){for(var M=0;M<S[N][5].length;M++){this.addToRender(["drawShape","sphere",G,y(S[N][5][M]),R,R,T[N],U,I[N]],["Outlier:"+S[N][5][M]],false,F,false,D)}}if(!x.hasOwnProperty(e)){x[e]=[]}x[e].push([L+E+(A/2),B[4]]);L+=H}}else{for(var N=0;N<S.length;N++){var G=D+O;var B=[];var P=[];var e=this.showBoxplotOriginalData||this.showViolinBoxplot?Q[N]:T[N];for(var M=0;M<5;M++){B.push(y(S[N][M]));P.push(B[B.length-1].toString())}var F=this.addToRender(["drawShape","rectangle",B[2]+((B[3]-B[2])/2),(D+E)+((A-this.variableSpaceFactor)/2),B[3]-B[2],A-this.variableSpaceFactor,T[N],this.objectBorderColor?this.objectBorderColor:T[N],I[N]],V[N],false,null,false,L);if(this.unique(P).length!=1){this.addToRender(["drawLine","median",B[4],D+E,B[4],D+(A-E),this.boxplotMedianColor,this.boxplotMedianWidth,"butt"],false,false,F);this.addToRender(["drawLine","error",B[2],G,B[0],G,U,O,"butt"],false,false,F);this.addToRender(["drawLine","error",B[3],G,B[1],G,U,O,"butt"],false,false,F)}if(this.boxplotMean){this.addToRender(["drawShape","rectangle",y(S[N][6]),G,n,n,this.boxplotMeanColor,this.boxplotMeanColorBorder],false,false,F,false,L)}if(S[N][5]){for(var M=0;M<S[N][5].length;M++){this.addToRender(["drawShape","sphere",y(S[N][5][M]),G,R,R,T[N],U,I[N]],["Outlier:"+S[N][5][M]],false,F,false,L)}}if(!x.hasOwnProperty(e)){x[e]=[]}x[e].push([B[4],D+E+(A/2)]);D+=H}}if(this.boxplotConnect){for(var e in x){if(x[e].length>1){var F=this.addToRender(["drawLine","line",x[e][0][0],x[e][0][1],x[e][1][0],x[e][1][1],e,this.boxplotConnectWidth,"butt"],["Line:"],false);for(var N=1;N<x[e].length-1;N++){this.addToRender(["drawLine","line",x[e][N][0],x[e][N][1],x[e][N+1][0],x[e][N+1][1],e,this.boxplotConnectWidth,"butt"],["Line:"],false,F)}}}}};this.drawCandlestickPlot=function(L,G,A,n,K,s,F,D,E,M,O){this.functionCaller="drawCandlestickPlot";var e=function(a){return E=="vertical"?A-((a-F)*s):G+((a-F)*s)};var N=this.foreground;var J=n/2;if(E=="vertical"){for(var I=0;I<L.length;I++){var C=G+J;var q=[];for(var H=0;H<L[I].length;H++){q.push(e(L[I][H]))}if(D){if(q[0]>q[1]){var k=G+(n/2);var f=q[1]+((q[0]-q[1])/2);var B=this.addToRender(["drawShape","rectangle",k,f,n,q[0]-q[1],false,M,"open"],O[I]);this.addToRender(["drawLine","line",C,q[1],C,q[2],M,false,"butt"],false,false,B,false,A);this.addToRender(["drawLine","line",C,q[3],C,q[0],M,false,"butt"],false,false,B,false,A)}else{var k=G+(n/2);var f=q[0]+((q[1]-q[0])/2);var B=this.addToRender(["drawShape","rectangle",k,f,n,q[1]-q[0],M,M,"closed"],O[I]);this.addToRender(["drawLine","line",C,q[3],C,q[1],M,false,"butt"],false,false,B,false,A);this.addToRender(["drawLine","line",C,q[0],C,q[2],M,false,"butt"],false,false,B,false,A)}}else{this.addToRender(["drawShape","rectangle",G+(n/2),q[0]+((A-q[0])/2),n,A-q[0],M,M,"closed"],O[I])}G+=K}}else{for(var I=0;I<L.length;I++){var C=A+J;var q=[];for(var H=0;H<L[I].length;H++){q.push(e(L[I][H]))}if(D){if(q[1]>q[0]){var k=q[0]+((q[1]-q[0])/2);var f=A+(n/2);var B=this.addToRender(["drawShape","rectangle",k,f,q[1]-q[0],n,false,M,"open"],O[I]);this.addToRender(["drawLine","line",q[1],C,q[2],C,M,false,"butt"],false,false,B,false,G);this.addToRender(["drawLine","line",q[3],C,q[0],C,M,false,"butt"],false,false,B,false,G)}else{var k=q[1]+((q[0]-q[1])/2);var f=A+(n/2);var B=this.addToRender(["drawShape","rectangle",k,f,q[0]-q[1],n,M,M,"closed"],O[I]);this.addToRender(["drawLine","line",q[3],C,q[1],C,M,false,"butt"],false,false,B,false,G);this.addToRender(["drawLine","line",q[0],C,q[2],C,M,false,"butt"],false,false,B,false,G)}}else{this.addToRender(["drawShape","rectangle",G+((q[0]-G)/2),A+(n/2),q[0]-G,n,M,M,"closed"],O[I])}A+=K}}};this.drawViolin=function(I,D,r,H,n,B,z,J,w,v){this.functionCaller="drawViolin";var e=I.kde;var g=[];var E=[];var f=[];var A=[];var b=[[],[]];var k,j;var a=[];if(e.length<3){e.splice(1,0,[(e[0][0]+e[1][0])/2,(e[0][1]+e[1][1])/2])}for(var G=0;G<e.length;G++){a.push(e[G][1])}var F=this.max(a);if(F==0){for(var G=1;G<e.length-1;G++){e[G][1]=0.000001}F=0.000001}var C=(H/2.2)/(F);var s=this.addColorTransparency(J,0.25);if(z=="vertical"){for(var G=0;G<e.length;G++){k=(e[G][1]*C);j=((e[G][0]-B)*n);g.push(D-k);E.push(r-j);f.push(D+k);A.push(r-j);b[0].push(D);b[1].push(r-j)}}else{for(var G=0;G<e.length;G++){k=((e[G][0]-B)*n);j=(e[G][1]*C);g.push(D+k);E.push(r-j);f.push(D+k);A.push(r+j);b[0].push(D+k);b[1].push(r)}}this.addToRender(["drawShape","violin",[g,f],[E,A],false,false,s,this.foreground,w],["Violin:"+v],false,null,false,b)};this.drawDotPlot=function(ad,ac,V,N,Z,Q,M,U,O,S,af,W,R,ah,K,P,J,F,E){this.functionCaller="drawDotPlot";var I=this;var f=function(){var e=I.jitterColumns%2?I.jitterColumns:I.jitterColumns+1;var b=Math.max(Z-I.sizes[0],I.sizes[0])/(e-1);var a=[0];var c=1;for(var d=0;d<e/2;d+=2){a.push(c*-b);a.push(c*b);c++}return a};var B=[];var D=f();var ag=this.getOutlineColor();if(S=="vertical"){for(var Y=0;Y<ad.length;Y++){if(this.showViolinBoxplot&&this.isRawData&&ad[Y].length>1){this.drawViolin(this.getViolin(ad[Y]),V,N,Z,M,U,S,af[Y][0],W[Y][0],F+":"+Y)}if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){for(var X=0;X<ad[Y].length;X++){var T=this.jitter?D[X%D.length]:0;var g=ah?ah[Y][X]:false;var L=N-((ad[Y][X]-U)*M);if(!isNaN(L)){var ae=this.addToRender(["drawShape",R[Y][X],V+T,L,O[Y][X],O[Y][X],af[Y][X],ag||af[Y][X],W[Y][X],false,false,P],g,K,null,false,N);B.push([V+T,L,O[Y][X]/2,g]);if(!this.isGroupedData){if(ac[Y]&&ac[Y][X]&&!isNaN(ac[Y][X])){var ai=(ac[Y][X]/2)*M;this.addToRender(["drawLine","error",V+T,L,V+T,L+ai,af[Y][X],-Z,"butt",false,false,true],false,false,ae);this.addToRender(["drawLine","error",V+T,L,V+T,L-ai,af[Y][X],-Z,"butt",false,false,true],false,false,ae)}}}else{B.push([V+T,Number.NaN,O[Y][X]/2,g])}}if(this.showErrorBars&&this.isGroupedData&&ac[Y]&&ac[Y]&&!isNaN(ac[Y][0])&&!isNaN(ac[Y][1])){var L=N-((ac[Y][0]-U)*M);var ai=(ac[Y][1]/2)*M;this.addToRender(["drawShape","diamond",V,L,this.margin*2,this.margin*2,this.foreground,this.foreground,"closed",false,false,P]);this.addToRender(["drawLine","line",V,L-ai,V,L+ai,this.foreground,this.lineThickness*2,"butt",false,false,P])}}V+=Q}}else{for(var Y=0;Y<ad.length;Y++){if(this.showViolinBoxplot&&this.isRawData&&ad[Y].length>1){this.drawViolin(this.getViolin(ad[Y]),V,N,Z,M,U,S,af[Y][0],W[Y][0],F+":"+Y)}if((this.showBoxplotOriginalData&&this.isRawData)||this.graphType.match(/Dot/)||(this.graphType.match(/Bar/)&&this.barType=="lollipop"&&!this.isGroupedData)){for(var X=0;X<ad[Y].length;X++){var T=this.jitter?D[X%D.length]:0;var g=ah?ah[Y][X]:false;var L=J?V+J-((ad[Y][X]-U)*M):V+((ad[Y][X]-U)*M);if(!isNaN(L)){var ae=this.addToRender(["drawShape",R[Y][X],L,N+T,O[Y][X],O[Y][X],af[Y][X],ag||af[Y][X],W[Y][X],false,false,P],g,K,null,false,V);B.push([L,N+T,O[Y][X]/2,g]);if(!this.isGroupedData){if(ac[Y]&&ac[Y][X]&&!isNaN(ac[Y][X])){var ai=(ac[Y][X]/2)*M;this.addToRender(["drawLine","error",L,N+T,L+ai,N+T,af[Y][X],Z,"butt",false,false,true],false,false,ae);this.addToRender(["drawLine","error",L,N+T,L-ai,N+T,af[Y][X],Z,"butt",false,false,true],false,false,ae)}}}else{B.push([Number.NaN,N+T,O[Y][X]/2,g])}}}if(this.showErrorBars&&this.isGroupedData&&ac[Y]&&ac[Y]&&!isNaN(ac[Y][0])&&!isNaN(ac[Y][1])){var L=V+((ac[Y][0]-U)*M);var ai=(ac[Y][1]/2)*M;this.addToRender(["drawShape","diamond",L,N,this.margin*2,this.margin*2,this.foreground,this.foreground,"closed",false,false,P]);this.addToRender(["drawLine","line",L-ai,N,L+ai,N,this.foreground,this.lineThickness*2,"butt",false,false,P])}N+=Q}}if(this.connectBy&&this.data.x&&this.data.x.hasOwnProperty(this.connectBy)&&this.isRawData){var x=this.connectBy==this.colorBy?this.meta.data.x[this.colorBy]:false;for(var Y in this.connectByData){var ae;var H=null;var ad=this.connectByData[Y];var G=x&&x.type!="Numeric"?x.colors[x.order[Y]%x.colors.length]:this.getColorForValue(x.colorBrew,Y);if(ad.length>1){for(var X=1;X<ad.length;X++){var L=B[ad[X-1]];var ai=B[ad[X]];ae=this.addToRender(["drawLine","line",L[0],L[1],ai[0],ai[1],G,this.connectByWidth,"butt",L[2],ai[2],P],["Line:"+this.connectBy+" "+Y],false,H);if(H==null){H=ae}}}}}else{if(this.connectBy&&this.data.z&&this.data.z.hasOwnProperty(this.connectBy)&&this.isRawData){this.connectByDataVar.push(B);if(E){var x=this.connectBy==this.colorBy?this.meta.data.z[this.colorBy]:false;for(var Y in this.connectByData){var ad=this.connectByData[Y];if(ad.length>1){for(var W=0;W<this.connectByDataVar[0].length;W++){for(var X=1;X<ad.length;X++){var L=this.connectByDataVar[ad[X-1]][W];var ai=this.connectByDataVar[ad[X]][W];var ab=Y;if(L&&ai){var C=this.data.y.vars[L[3][0]];var aa=this.data.y.vars[ai[3][0]];var A=this.data.y.smps[L[3][(this.isGroupedData?2:1)]];var z=this.data.y.smps[ai[3][(this.isGroupedData?2:1)]];if(A==z){ab=C+" - "+aa+" ("+A+")"}else{ab=C+" ("+A+") - "+aa+" ("+z+")"}}this.addToRender(["drawLine","line",L[0],L[1],ai[0],ai[1],this.connectByColor,this.connectByWidth,"butt",L[2],ai[2],P],["Line:"+this.connectBy+" "+ab])}}}}}}}};this.drawHeatmap=function(F,A,q,j,C,E,I,D,x,H){this.functionCaller="drawHeatmap";var n=0;var g=A;var s=0.5;var z=this.meta.vals;if(!z.colors){z.colors={}}for(var B=0;B<F.length;B++){var k=F[B];var G=k==null||isNaN(k)?this.missingDataColor:z.colors[k.toString()]?z.colors[k.toString()]:this.getColorForValue(H,k);var y=E?G:this.heatmapCellBoxColor;z.colors[k==null?"null":k.toString()]=G;if(this.graphType=="Network"){if(this.shapeByShape){this.addToRender(["drawShape",this.shapeByShape,A+(j/2),q+(C/2),j/2,C/2,G,y,x[B]],I[B],D)}else{this.addToRender(["drawShape","rectangle",A+(j/2),q+(C/2),j,C,G,G,x[B]],I[B],D)}}else{if(this.shapeByShape){this.addToRender(["drawShape",this.shapeByShape,A+(j/2),q+(C/2),j/2,C/2,G,y,x?x[B]:false],I[B],D)}else{if(B>0&&B<F.length-1){if(n>=0.5){this.addToRender(["drawShape","rect",A+((j+s)/2),q+((C+s)/2),j+s,C+s,G,G,x?x[B]:false],I[B],D,null,false,[g,q+((C+s)/2),0,C+s]);n=0}}else{this.addToRender(["drawShape","rect",A+((j+s)/2),q+((C+s)/2),j+s,C+s,G,G,x?x[B]:false],I[B],D,null,false,[g,q+((C+s)/2),0,C+s])}}}if(this.showDataValues){this.addToRender(["drawText",this.correctPrecisionBug(k),(A+j)-2,(q+C)-2,this.overlayFont,this.foreground,"right","bottom"])}A+=j;n+=j}};this.drawTreemap=function(B,u,p,C,D){this.functionCaller="drawTreemap";var f=this;var r=this.graphOrientation=="vertical"?this.top+this.y:this.left;var k=function(d,c){f.functionCaller="drawTreemap";if(c){f.addToRender(["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,false,f.objectBorderColor?f.objectBorderColor:false,"open",false,d.outline,C,D],false,false,null,false,r)}else{f.addToRender(["drawShape","rectangle",(d.coords.left+u)+(d.coords.width/2),(d.coords.top+p)+(d.coords.height/2),d.coords.width,d.coords.height,d.color,f.objectBorderColor?f.objectBorderColor:false,"closed",false,false,C,D],d.index,false,null,false,r)}if(d.label){var b=f.measureText(d.label,f.overlayFont);if(b+f.margin<d.coords.width&&f.overlayFontSize+f.margin<d.coords.height){if(c){f.addToRender(["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5),"center","middle"])}else{f.addToRender(["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"left","top"])}}else{if(b+f.margin<d.coords.height&&f.overlayFontSize+f.margin<d.coords.width){if(c){f.addToRender(["drawText",d.label,d.coords.left+u+(d.coords.width/2),d.coords.top+p+(d.coords.height/2),f.overlayFont,f.addColorTransparency(f.foreground,0.5),"center","middle",-Math.PI/2])}else{f.addToRender(["drawText",d.label,d.coords.left+u+f.margin,d.coords.top+p+f.margin,f.overlayFont,f.foreground,"right","top",-Math.PI/2])}}}}};var s=function(c){for(var b=0;b<c.length;b++){if(c[b].children){s(c[b].children);k(c[b],true)}else{k(c[b])}}};for(var v=0;v<B.length;v++){var a=B[v];var q=this.treemapBorderWidth?1:0;var E=this.treemapBorderWidth;var o=E*2;var e=this.smpLabelFontSize*q;var g=this.treemapBorderColor;var m=u+a.coords.left-E;var j=p+a.coords.top-(e+E);var n=a.coords.width+o;var A=a.coords.height+e+o;if(a.title){this.addToRender(["disableGradientTransparencyShadow"]);if(a.coords.border>1){this.addToRender(["drawShape","rectangle",m+(n/2),j+((e+(E/2))/2),n,e+(E/2),g,g,"close",false,E,C,D]);this.addToRender(["drawShape","rectangle",m+(n/2),j+(A/2),n,A,false,g,"open",false,E,C,D])}else{if(a.coords.border>0){this.addToRender(["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D])}else{if(a.coords.border>-1){this.addToRender(["drawShape","rectangle",m+(n/2),(j+(e+E))+((A-(e+E))/2),n,A-(e+E),false,g,"open",false,E,C,D])}}}var z=this.measureText(a.title,this.smpLabelFont);if(z+this.margin<n&&this.smpLabelFontSize<=e&&a.coords.height>e+(E/2)){this.addToRender(["drawText",a.title,m+this.margin,j+(this.smpLabelFontSize/2),this.smpLabelFont,this.foreground,"left","middle"])}this.addToRender(["enableGradientTransparencyShadow"])}if(a.children){s(a.children)}else{k(a)}}};this.drawSankey=function(b){this.functionCaller="drawSankey";var f=b.links[0].target.x-b.links[0].source.x;for(var a=0;a<b.links.length;a++){var c=b.links[a];this.addToRender(["drawShape","bezier",c.plotX,c.plotY,f,c.dy,c.color,c.color,false,c.colors],c.tooltip,false,null,false,[this.left,this.top+this.y/2,f,c.dy])}for(var a=0;a<b.nodes.length;a++){var e=b.nodes[a];this.addToRender(["drawShape","rectangle",e.plotX+(e.dx/2),e.plotY+(e.dy/2),e.dx,e.dy,e.color,this.foreground],e.tooltip,false,null,false,[this.left,this.top+this.y/2,e.dx,e.dy]);this.addToRender(["drawText",e.name,e.plotX+(e.dx/2),e.plotY+(e.dy/2),this.overlayFont,this.overlayFontColor,"center","middle",-Math.PI/2],[e.tooltip[0]+":T"])}};this.drawTree=function(a,f){this.functionCaller="drawTree";if(this.data.tree&&this.data.tree.plot){var k=this.data.tree.plot;var d=this.treeNodeSize/2;var h=this.treeNodeSize/4;var e=a=="vertical"?true:false;var g=this;var j=function(p){var l=e?p.x0:p.y0;var o=e?p.y0:p.x0;if(p.children){for(var m=0;m<p.children.length;m++){j(p.children[m])}if(e){if(p.parent){g.addToRender(["drawText",p.data.name,l,o-((g.treeNodeSize/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"right","middle",Math.PI/2],["Tree-Text:"+p.id],false,null,false,[b,i])}else{g.addToRender(["drawText",p.data.name,l,o-((g.treeNodeSize/2)+g.margin),g.smpLabelFont,g.smpLabelFontColor,"center","bottom"],["Tree-Text:"+p.id],false,null,false,[b,i])}}else{g.addToRender(["drawText",p.data.name,l-((g.treeNodeSize/2)+g.margin),o,g.smpLabelFont,g.smpLabelFontColor,"right","middle"],["Tree-Text:"+p.id],false,null,false,[b,i])}}else{if(e){g.addToRender(["drawText",p.data.name,l,o+(g.treeNodeSize/2)+g.margin,g.smpLabelFont,g.smpLabelFontColor,"left","middle",Math.PI/2],["Tree-Text-:"+p.id],false,null,false,[b,i])}else{g.addToRender(["drawText",p.data.name,l+(g.treeNodeSize/2)+g.margin,o,g.smpLabelFont,g.smpLabelFontColor,"left","middle"],["Tree-Text:"+p.id],false,null,false,[b,i])}}g.addToRender(["drawShape",p.data.shape,l,o,p.data.size,p.data.size,p.data.color,g.treeLinkColor,p.data.pattern,false,g.treeLinkWidth],["Tree-Node:"+p.id],false,null,false,[b,i]);if(p._children){g.addToRender(["drawLine","line",l-h,o,l+h,o,g.foreground],["Tree-Line1:"+p.id],false,null,false,[b,i]);g.addToRender(["drawLine","line",l,o-h,l,o+h,g.foreground],["Tree-Line2:"+p.id],false,null,true,[b,i])}else{if(p.children){g.addToRender(["drawLine","line",l-h,o,l+h,o,g.foreground],["Tree-Line1:"+p.id],false,null,false,[b,i])}}};var c=function(s){if(s.children){for(var m=0;m<s.children.length;m++){c(s.children[m])}}if(s.parent){var l=e?s.x0:s.y0;var r=e?s.y0:s.x0;var o=e?s.parent.x0:s.parent.y0;var q=e?s.parent.y0:s.parent.x0;var p=s._clicked?[o,q,o,q]:[b,i,b,i];g.addToRender(["drawLine","bezier",o,q,l,r,g.treeLinkColor,g.treeLinkWidth,false],[s.parent.id+":"+s.id],false,null,false,p);s._clicked=false}};var b=e?k.x0:k.y0;var i=e?k.y0:k.x0;c(k);if(!f){j(k)}}};this.zoomOncoprintVariables=function(c){this.functionCaller="zoomOncoprintVariables";if(this.isTransition()){return}var b=[];this.setOriginalIndices(false,this.varIndices,this.smpIndices);this.varIndicesStart=0;for(var a=0;a<Math.min(c,this.varIndices.length);a++){b.push(this.varIndices[a])}this.varIndices=b;this.draw()}};CanvasXpress.prototype.init3dUtils=function(){this.setTrigonometry=function(){if(!this.meta.math){this.meta.math={sin:[0],cos:[1]};for(var b=1;b<=360;b++){var a=Math.PI/(180/b);this.meta.math.sin[b]=Math.sin(a);this.meta.math.cos[b]=Math.cos(a)}}};this.set3DRotation=function(){this.setTrigonometry();var a=["xRotate","yRotate","zRotate"];for(var b=0;b<a.length;b++){if(this[a[b]]>360){this[a[b]]-=360}if(this[a[b]]<0){this[a[b]]=360}}};this.set3DParams=function(){var b=this.zoom;var a=this.x;this.perspective=a*this.perspectiveFactor;this.lenX=a/4*b*this.x3DRatio;this.lenY=a/4*b*this.y3DRatio;this.lenZ=a/4*b*this.z3DRatio;this.padX=a/2;this.padY=this.y/2;this.padZ=this.padY};this.get3DTransfrom=function(g,a,k){var f,e,b;var h=[];var n=this.meta.math.sin;var j=this.meta.math.cos;var d=this.perspective;var m=this.xRotate;var l=this.yRotate;var i=this.zRotate;e=a;b=k;a=e*j[parseInt(l)]-b*n[parseInt(l)];k=e*n[parseInt(l)]+b*j[parseInt(l)];f=g;b=k;g=b*n[parseInt(m)]+f*j[parseInt(m)];k=b*j[parseInt(m)]-f*n[parseInt(m)];f=g;e=a;g=f*j[parseInt(i)]-e*n[parseInt(i)];a=f*n[parseInt(i)]+e*j[parseInt(i)];if(this.perspective){g=g*(d/(k+d));a=a*(d/(k+d));k=k*(d/(k+d))}h.push(g+this.padX);h.push(a+this.padY);h.push(k+this.padZ);return h}};CanvasXpress.prototype.initApiUtils=function(){this.getValidGraphTypes=function(){return this.validGraphTypes};this.setHeatmapScheme=function(){this.initializeAttributes()};this.hasIndicator=function(){if(this.graphType.match(/Scatter/)||this.graphType=="Bar"){return true}else{return false}};this.hasLegend=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"){return true}else{return false}};this.hasLegendProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Correlation"&&this.graphType!="Heatmap"&&this.graphType!="Pie"){return true}else{return false}};this.hasData=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){return true}else{return false}};this.hasDataSamples=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}return true}else{return false}};this.hasDataGroups=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&!this.graphType.match(/Scatter/)){if(this.graphType=="Correlation"&&this.correlationAxis!="samples"){return false}if(this.data.x){return true}else{return false}}else{return false}};this.hasDataVariables=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"){if(this.graphType=="Correlation"&&this.correlationAxis!="variables"){return false}return true}else{return false}};this.hasDataProperties=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Heatmap"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"){return true}else{return false}};this.hasOrientation=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&this.graphType!="Circular"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasOverlays=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.hasDendrograms=function(){if(this.graphType!="Heatmap"&&(this.smpDendrogramNewick||this.varDendrogramNewick)){return true}else{return false}};this.hasDecorations=function(){return this.decorations&&(this.decorations.nlfit||this.decorations.line||this.decorations.reg||this.decorations.nor||this.decorations.area)?true:false};this.isSegregable=function(){if(this.graphType!="Network"&&this.graphType!="Genome"&&this.graphType!="Venn"&&this.graphType!="Pie"&&this.graphType!="Correlation"&&!this.graphType.match(/Scatter/)){return true}else{return false}};this.getLineTypes=function(){var e=["line"];var c=["","dashed","dotted","bezierY","bezierX","curved"];var a=["arrow","arrowHead","arrowTail","arrowHeadSquareTail","arrowTailSquareHead","square","squareHead","squareTail","squareHeadArrowTail","squareTailArrowHead"];for(var d=0;d<a.length;d++){e.push(a[d]+"Line")}for(var d=1;d<c.length;d++){for(var b=0;b<a.length;b++){e.push(c[d]+this.capitalize(a[b])+"Line")}}return e};this.isValidShape=function(c){var a=["circle","sphere","box","rect","rectangle","rect2","rect3","roundrect","brace","square","triangle","triangle2","equilateral","equilateral2","star","diamond","rhombus","hexagon","octagon"];a=a.concat(["oval","oval2","oval3","arc","arc2","arc3","arch","path","polygon","spline","hull","violin","confidence","bezier","ellipse","ellipse2","ellipse2","plus","minus"]);a=a.concat(["pie","pie0","pie1","pie2","pie3","pie4","pie5","pie6","pie7","pie8","pie9","pacman","pacman2","mdavid","image"]);a=a.concat(["pch0","pch1","pch2","pch3","pch4","pch5","pch6","pch7","pch8","pch9","pch10","pch11","pch12","pch13","pch14","pch15","pch16","pch17","pch18","pch19","pch20","pch21","pch22","pch23","pch24","pch25"]);for(var b=0;b<a.length;b++){if(a[b]==c){return true}}return false};this.getHeatmapSchemes=function(){var c=[];var d=["blue","red","green","yellow","cyan","purple","white","black"];for(var b=0;b<d.length;b++){c.push(d[b]);for(var a=0;a<d.length;a++){if(d[b]!=d[a]){c.push(d[b]+"-"+d[a])}}}return c};this.isCompatibleGraphType=function(b,a){if(b.match(/^Bar$|^Line$|Boxplot|Dotplot/)){return a.match(/^Bar$|^Line$|Boxplot|Dotplot/)?true:false}else{return false}};this.isOneDimensionalGraph=function(){return !this.graphType.match(/Scatter|Network|Venn|Genome|Circular|Correlation/)};this.modifyHighlights=function(c,b,d){var a=d?"highlightVar":"highlightSmp";this.modifyObjectArray(c,b,a)};this.getHighlights=function(a){return this.getObjectArray(a?this.highlightVar:this.highlightSmp)};this.modifyOverlaysProperties=function(h){this.functionCaller="modifyOverlaysProperties";if(this.isTransition()){return}var e=this;var b,a,g;var f=false;if(!this.isArray(h)){var d=[];for(var c=0;c<arguments.length;c++){d.push(arguments[c])}h=d;f=true}a=h.shift();g=this.cloneObject(h);while(g.length>1){b=g.shift();if(!e[b]){e[b]={}}e=e[b]}b=g.shift();e[b]=isNaN(a)?a:Number(a);if(!f){h.unshift(a)}this.draw()};this.modifySmpOverlays=function(b,a){this.modifyObjectArray(b,a,"smpOverlays")};this.modifyVarOverlays=function(b,a){this.modifyObjectArray(b,a,"varOverlays")};this.getSmpOverlays=function(){return this.getObjectArray(this.smpOverlays)};this.getVarOverlays=function(){return this.getObjectArray(this.varOverlays)};this.getXData=function(){var b=[];if(this.data.x){for(var a in this.data.x){b.push(a)}}return b};this.getZData=function(){var b=[];if(this.data.z){for(var a in this.data.z){b.push(a)}}return b};this.getXZData=function(){return this.graphType.match(/Scatter/)?this.getZData():this.getXData()};this.getSamplesVariablesAsArray=function(){return this.graphType.match(/scatter/i)?this.getSamplesAsArray():this.getVariablesAsArray};this.getSamplesAsArray=function(){var d=this.getSamples();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getVariablesAsArray=function(){var d=this.getVariables();var b=[];for(var c=0;c<d.length;c++){b.push(d[c].name)}return b};this.getNodeData=function(a){return this.getNetworkData("nodes",a)};this.getEdgeData=function(a){return this.getNetworkData("edges",a)};this.isBooleanData=function(c){for(var a in c){if(c[a]["t"]=="numeric"){var b=this.getKeys(c[a]["o"]);if(b.length==2&&(c[a]["o"].hasOwnProperty("true")&&c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&(c[a]["o"].hasOwnProperty("true")||c[a]["o"].hasOwnProperty("false"))){c[a]["t"]="string"}else{if(b.length==1&&c[a]["o"].hasOwnProperty("")){c[a]["t"]="string"}}}}}};this.getSampleVariableData=function(k,p,n,j,q){var g={smps:{idx:"smpIndices",spc:"x"},vars:{idx:"varIndices",spc:"z"}};var b={};b[k]={o:{},t:"string"};if(p){b[k]["o"]=this.getObjectArray(this.data.y[k])}else{for(var e=0;e<this[g[k]["idx"]].length;e++){b[k]["o"][this.data.y[k][this[g[k]["idx"]][e]]]=true}}if(j||q){var l=j?this.getVariableIndices(n):this.getSampleIndices(n);if(l>-1){b={};b[n]={o:{},t:"numeric"};if(p){var d=this.meta.data.y.range[n];b[n]["o"]={min:d.min,max:d.max}}else{var f=[];if(j){for(var e=0;e<this.smpIndices.length;e++){f.push(this.data.y.data[l][this.smpIndices[e]])}}else{for(var e=0;e<this.varIndices.length;e++){f.push(this.data.y.data[this.varIndices[e]][l])}}var a=this.range(f);b[n]["o"]={min:a[0],max:a[1]}}}}else{if(this.data[g[k]["spc"]]){for(var h in this.data[g[k]["spc"]]){if(n&&h!=n){continue}var d=this.meta.data[g[k]["spc"]][h];b[h]={o:{},t:d.type.toLowerCase()};if(p){if(d.type=="Numeric"){b[h]["t"]="numeric";b[h]["o"]={min:d.rmin,max:d.rmax}}else{b[h]["t"]="string";b[h]["o"]=this.cloneObject(d.levels)}}else{for(var e=0;e<this[g[k]["idx"]].length;e++){var c=this.getMetadataValue(this[g[k]["idx"]][e],g[k]["spc"],h,true);if(!b[h]["o"].hasOwnProperty(c)){b[h]["o"][c]=true}}if(b[h]["t"]=="numeric"){var f=[];for(var c in b[h]["o"]){for(var e=0;e<b[h]["o"][c];e++){f.push(c)}}var a=this.range(f);b[h]["o"]={min:a[0],max:a[1]}}}}}}return b};this.getNetworkData=function(d,a){if(this.graphType=="Network"&&!this[d+"Data"]){this[d+"Data"]={};var f=this.meta.data[d];for(var b in f){if(f[b].type=="String"){this[d+"Data"][b]={o:f[b].order,t:f[b].type.toLowerCase()}}else{this[d+"Data"][b]={o:{min:f[b].rmin,max:f[b].rmax},t:f[b].type.toLowerCase()}}}if(this[d+"Properties"].length>0){for(var c=0;c<this.data[d].length;c++){var e=this.data[d][c];this.getAdditionalData(e,this[d+"Data"],this[d+"Properties"])}}}if(this.graphType=="Network"){return a?this[d+"Data"]:this.getKeys(this[d+"Data"])}else{return false}};this.getFilteredNetworkData=function(g,j){var b={};b[g]={};if(this.graphType=="Network"){for(var e=0;e<this.data[g].length;e++){var d=this.data[g][e];if(j||(!j&&!d.hide)){for(var h in d){if(typeof(d[h])!="object"){if(b[g].hasOwnProperty(h)){b[g][h]["o"][d[h]]=true;if(isNaN(d[h])){b[g][h]["t"]="string"}}else{b[g][h]={o:{},t:isNaN(d[h])?"string":"numeric"};b[g][h]["o"][d[h]]=true}}}}if(this[g+"Properties"].length>0){this.getAdditionalData(d,b,this[g+"Properties"])}}this.isBooleanData(b[g]);for(var h in b[g]){if(b[g][h]["t"]=="numeric"){var f=[];for(var c in b[g][h]["o"]){f.push(c)}var a=this.range(f);b[g][h]["o"]={min:a[0],max:a[1]}}}}return b[g]};this.getFeatureData=function(a){if(!this.featuresData){var h={};var d=this.skipConfigurableProperties?this.getObjectArray(this.featureConfigurableProperties):{};for(var g=0;g<this.data.tracks.length;g++){var c=this.data.tracks[g];var b=c.data;for(var e=0;e<b.length;e++){var l=b[e];for(var k in l){if(!d[k]){if(typeof(l[k])!="object"){if(h.hasOwnProperty(k)){if(h[k]["o"].hasOwnProperty(l[k])){h[k]["o"][l[k]]=true}if(isNaN(l[k])){h[k]["t"]="string"}}else{h[k]={o:{},t:isNaN(l[k])?"string":"numeric"};h[k]["o"][l[k]]=true}}}}}if(this.featuresProperties.length>0){this.getAdditionalData(b,h,this.featuresProperties)}}this.featuresData=h}return a?this.featuresData:this.getKeys(this.featuresData)};this.getAdditionalData=function(d,e,h){for(var f=0;f<h.length;f++){var b=d;var k=false;if(h[f].length>0){for(var c=0;c<h[f].length;c++){var a=h[f][c];if(b[a]){b=b[a]}else{k=true;break}}if(!k){for(var g in b){if(typeof(b[g])!="object"){if(e.hasOwnProperty(g)){if(isNaN(b[g])){e[g]["t"]="string"}}else{e[g]={o:{},t:isNaN(b[g])?"string":"numeric",r:f};e[g]["o"][b[g]]=true}}}}}}};this.getOperators=function(){return["","like","not like",">",">=","<","<=","==","null","not null"]};this.zoonIn=function(a){this.handleWheelEvent(a,1)};this.zoonOut=function(a){this.handleWheelEvent(a,-1)};this.clusterSamples=function(b,a){this.functionCaller="clusterSamples";if(this.isTransition()){return}this.clusterAxis="samples";if(b||!this.smpDendrogramNewick){this.smpDendrogramNewick=this.cluster()}if(!a){this.draw()}};this.clusterVariables=function(b,a){this.functionCaller="clusterVariables";if(this.isTransition()){return}this.clusterAxis="variables";if(b||!this.varDendrogramNewick){this.varDendrogramNewick=this.cluster()}if(!a){this.draw()}};this.kmeansSamples=function(e,d){this.functionCaller="kmeansSamples";if(this.isTransition()){return}this.clusterAxis="samples";if(!this.data.x){this.data.x={}}if(e||!this.data.x["k-Means-S"]){var a=this.kmeans();this.data.x["k-Means-S"]=[];for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];this.data.x["k-Means-S"][c]=a[b]}if(!this.isInArray("k-Means-S",this.smpOverlays)){this.smpOverlays.push("k-Means-S")}this.updateMetaData("x","k-Means-S",false,true);this.sortSamplesByCategory("k-Means-S",true)}if(!d){this.draw()}};this.kmeansVariables=function(e,d){this.functionCaller="kmeansVariables";if(this.isTransition()){return}this.clusterAxis="variables";if(!this.data.z){this.data.z={}}if(e||!this.data.z["k-Means-V"]){var a=this.kmeans();this.data.z["k-Means-V"]=[];for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];this.data.z["k-Means-V"][c]=a[b]}if(!this.isInArray("k-Means-V",this.varOverlays)){this.varOverlays.push("k-Means-V")}this.updateMetaData("z","k-Means-V",false,true);this.sortVariablesByCategory("k-Means-V",true)}if(!d){this.draw()}};this.setFunctions=function(){var a=this.functions;a.push("clusterSamples");a.push("clusterVariables");a.push("transpose");a.push("transform");a.push("sortSamplesByCategory");a.push("sortSamplesByVariable");a.push("sortVariablesByCategory");a.push("sortVariablesBySample");a.push("hideUnhideSmps");a.push("hideUnhideVars");a.push("desegregateSamples");a.push("segregateSamples");a.push("groupSamples");a.push("ungroupSamples");a.push("desegregateVariables");a.push("segregateVariables");a.push("kmeansSamples");a.push("kmeansVariables");a.push("createContour");a.push("removeContour");a.push("showCodeDiv");a.push("hideCodeDiv");a.push("showInfoDiv");a.push("hideInfoDiv");a.push("updateCodeDiv");a.push("createHistogram");a.push("removeHistogram");a.push("addRegressionLine");a.push("addNormalDistributionLine");a.push("recalculateLayout");a.push("createRandomData");a.push("drawArea");a.push("draw");a.push("reset");a.push("print")};this.initializeApi=function(){this.setFunctions()};this.initializeApi()};CanvasXpress.prototype.initDimensionUtils=function(){this.resizeCanvas=function(e,b,c){this.functionCaller="resizeCanvas";var a=this.margin;if(e||b||c){if(b||c){if(b){this.width=b;this.originalWidth=b}if(c){this.height=c;this.originalHeight=c}}else{if(e){this.width=this.originalWidth;this.height=this.originalHeight}}this.top=a+this.getTitleSubtitleHeight();this.left=a;this.right=a;this.bottom=a;this.resetRender()}if(!this.isSVG){this.meta.canvas.ctx.canvas.width=this.width;this.meta.canvas.ctx.canvas.height=this.height;this.meta.canvas.ctx.canvas.style.width=this.width+"px";this.meta.canvas.ctx.canvas.style.height=this.height+"px";this.meta.canvas.ctx2.canvas.width=this.width;this.meta.canvas.ctx2.canvas.height=this.height}this.addToRender(["disableGradientTransparencyShadow"]);if(this.backgroundType=="image"){if(this.graphType=="Network"){var i=this.scaleFactorX||1;var f=this.scaleFactorY||1;this.drawImage(CanvasXpress.cacheImages[this.getFileName(this.backgroundImage)],0,0,this.maxX,this.maxY,this.offsetX*i,this.offsetY*f,this.maxX*i,this.maxY*f)}else{this.addToRender(["drawShape","image",this.width/2,this.height/2,this.width,this.height,false,false,false,false,false,false,false,false,false,this.backgroundImage])}}else{if(this.backgroundType=="windowImage"){this.addToRender(["drawShape","image",this.left+(this.x/2),this.top+(this.y/2),this.x,this.y,false,false,false,false,false,false,false,false,false,this.backgroundImage])}else{if(this.backgroundType=="solid"||this.backgroundType=="window"||this.backgroundType=="windowSolidGradient"||this.backgroundType=="video"){this.addToRender(["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,this.background,this.background])}else{var d=this.getLinearGradient(0,0,this.gradientOrientation=="vertical"?0:this.height,this.gradientOrientation=="vertical"?this.height:0,this.backgroundGradient1Color,this.backgroundGradient2Color);this.addToRender(["drawShape","rectangle",0+(this.width/2),0+(this.height/2),this.width,this.height,d,d])}}}this.addToRender(["enableGradientTransparencyShadow"])};this.setWidth=function(a,b){this.setDimensions(a,false,b)};this.setHeight=function(b,a){this.setDimensions(false,b,a)};this.getWidth=function(){return this.marginLeft+this.left+this.x+this.right+this.marginRight};this.getHeight=function(){return this.marginTop+this.top+this.y+this.bottom+this.marginBottom};this.setDimensions=function(a,e,d,b){this.functionCaller="setDimensions";if(this.isTransition()){return}if(!this.resizable){return}var g=this.meta.canvas.ctx.canvas;if(!a||!this.resizableX){a=this.width}if(!e||!this.resizableY){e=this.height}a=g.originalWidth=parseInt(a);e=g.originalHeight=parseInt(e);this.clickLayoutNoAnimation(d);if(!this.reproducing){this.removeMotionDiv(true)}if(this.graphType=="Network"){this.scaleFactorX=null;this.scaleFactorY=null}this.draw(a,e);this.updateRemoteNavigationWindow();if(b){var f=this;setTimeout(function(){f.resizeViewport()},b)}else{this.resizeViewport()}};this.initializeDimensions=function(){var b=this.meta.canvas.ctx.canvas;var a=this.margin;if(b.width){this.originalWidth=b.width;this.width=b.width}else{if(this.width){this.originalWidth=this.width;b.width=this.width}else{this.width=600;this.originalWidth=this.width;b.width=this.width}}if(b.height){this.originalHeight=b.height;this.height=b.height}else{if(this.height){this.originalHeight=this.height;b.height=this.height}else{this.height=600;this.originalHeight=this.height;b.height=this.height}}this.top=a+this.getTitleSubtitleHeight();this.left=a;this.right=a;this.bottom=a;this.x=this.width-(this.leftMargin+this.left+this.rightMargin+this.right);this.y=this.height-(this.topMargin+this.top+this.bottomMargin+this.bottom)};this.initializeDimensions()};CanvasXpress.prototype.initUtils=function(){this.initGeneralUtils();this.initPlotUtils();this.initConfigUtils();this.init3dUtils();this.initApiUtils();this.initDimensionUtils()};CanvasXpress.prototype.initLegendUtils=function(){this.validateLegendPositions=function(){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}if(this.legendPosition!="right"&&this.legendPosition!="bottom"){if(this.graphType=="Circular"){if(this.legendPosition!="top"){this.legendPosition="right"}}else{this.legendPosition="right"}}}if(!this.overlaysLegendPosition){this.overlaysLegendPosition="topRight"}if(this.layoutValid){var a=this.meta.config.orig;a.insideLegend=this.insideLegend;this.insideLegend=false;if(this.legendPosition!="bottom"&&this.legendPosition!="right"){a.legendPosition=this.legendPosition;this.legendPosition="right"}}};this.setLegendFont=function(){if(this.autoScaleFont){var b=(1-this.percentAspectRatioPlotArea);var a=this.min(this.width*b,this.height*b);this.setPropertyFontSize(a,"legendFont")}else{this.legendFont=this.legendFontStyle+" "+parseInt(this.legendFontSize)+"px "+this.fontName}};this.drawLegendBackgroundBox=function(e,r,p,g,m,o,j,f){this.functionCaller="drawLegendBackgroundBox";var n=this.graphType=="Map"||this.graphType=="Correlation"?false:j?this.decorationsBackgroundColor:this.legendBackgroundColor;var c=f?this.legendBackgroundColor:j?this.decorationsBoxColor:this.legendBoxColor;var q=j?this.decorationsBox:this.legendBox;var k=this.graphType;var s=[0,0,this.width,this.height];if(m){if(q&&n&&!f&&k!="Network"){this.addToRender(["disableGradientTransparencyShadow"]);this.addToRender(["drawShape","rectangle",e+(p/2),r+(g/2),p,g,n,n,"solid",false,false,true,s],[-1],o);this.addToRender(["enableGradientTransparencyShadow"])}else{if(n){this.addToRender(["drawShape","rectangle",e+(p/2),r+(g/2),p,g,n,n,"solid",false,false,true,s],[-1],o)}else{this.addToRender(["drawShape","rectangle",e+(p/2),r+(g/2),p,g,false,"rgba(0,0,0,0)","open",false,false,true,s],[-1],o)}}}else{if(q){this.addToRender(["disableGradientTransparencyShadow"]);this.addToRender(["drawShape","rectangle",e+(p/2),r+(g/2),p,g,false,c,"open",false,false,true,s]);this.addToRender(["enableGradientTransparencyShadow"])}}};this.getDiameterLegend=function(){var a=Math.min(this.width,this.height);return Number(Math.max(0.5,a*12/833).toFixed(1))};this.setCustomLegendDimensions=function(j){var e=j.text.length;var u=this.getDiameterLegend();var z=j.size;if(z){for(var k=0;k<z.length;k++){if(z[k]){u=Math.max(u,z[k])}}}var y=this.measureText(j.title||"",this.legendFont);var g=this.measureText(this.getMaxText(j.text),this.legendFont);var p=this.getFontPt(this.legendFont);var v=this.legendColumns>e?e:this.legendColumns;var a=Math.ceil(e/v);var b=Math.max(y,(g+u+(this.margin*2))*v);var x=b+(this.margin*(v+2));var o=j.title?(a*(Math.max(u,p)+this.margin))+p+(this.margin*2):(a*(Math.max(u,p)+this.margin))+(this.margin*1);this["legend"+j.id+"Width"]=x;this["legend"+j.id+"Height"]=o};this.setPropertyLegendDimensions=function(c,n,b){var a=this.decapitalize(c)+"By";if(this[a]&&(this[a+"ShowLegend"]||this.graphType=="Network")){var r,g,o;if(n){r=this[a];g=n;o=b&&b.sizes?b.sizes:this.sizes}else{if(this.data.x&&this.data.x.hasOwnProperty(this[a])){r=this[a];g=this.meta.data.x[this[a]].maxLevStr;o=this.meta.data.x[this[a]].sizes||this.sizes}else{if(this.data.z&&this.data.z.hasOwnProperty(this[a])){r=this[a];g=this.meta.data.z[this[a]].maxLevStr;o=this.meta.data.z[this[a]].sizes||this.sizes}else{if(a.match("Node")){r=this[a];g=this.meta.data.nodes[this[a]].maxLevStr;o=this.meta.data.nodes[this[a]].sizes||this.sizes}else{if(a.match("Edge")){r=this[a];g=this.meta.data.edges[this[a]].maxLevStr;o=this.meta.data.edges[this[a]].sizes||this.sizes}else{r=0;g=0;o=this.sizes}}}}}var k=this.getDiameterLegend();if(c=="Size"||c=="SizeNode"||c=="SizeEdge"){for(var h=0;h<this["legend"+c+"sN"];h++){if(o[h]){k=Math.max(k,o[h])}}}var j=this.getFontPt(this.legendFont);var t=this.legendColumns>this["legend"+(c=="Outline"?"Color":c)+"sN"]?this["legend"+(c=="Outline"?"Color":c)+"sN"]:this.legendColumns;var e=Math.ceil(this["legend"+(c=="Outline"?"Color":c)+"sN"]/t);var q=this.measureText(r,this.legendFont);var s=(this.measureText(g,this.legendFont)+k+(this.margin*2))*t;this["legend"+(c=="Outline"?"Color":c)+"Width"]=Math.max(q,s)+(this.margin*(t+2));this["legend"+(c=="Outline"?"Color":c)+"Height"]=(e*(Math.max(k,j)+this.margin))+j+(this.margin*3)}};this.setPropertyLegendIndicatorDimensions=function(d,a){var i=this.decapitalize(d)+"By";var c=0;var e=0;var g=this.getFontPt(this.legendFont);if(this[i]){switch(d){case"Color":case"ColorNode":case"ColorEdge":case"Outline":var b=a.maxLevLen;if(this.legendPosition.match(/top|bottom/)){e=this.heatmapIndicatorHeight+(this.margin*4)+g;e+=g+this.margin;c=this.heatmapIndicatorWidth+b}else{e=this.heatmapIndicatorWidth+(this.margin*3)+g;c=this.heatmapIndicatorHeight+(this.margin*4)+b}break;case"Shape":case"ShapeNode":case"ShapeEdge":case"Size":case"SizeNode":case"SizeEdge":this.setPropertyLegendDimensions(d,a.maxLevStr,a);return;case"Pattern":case"PatternNode":case"PatternEdge":c=0;e=0;break}}this["legend"+(d=="Outline"?"Color":d)+"Width"]=c;this["legend"+(d=="Outline"?"Color":d)+"Height"]=e};this.setDecorationsLegendDimensions=function(){this.legendDecorationWidth=0;this.legendDecorationHeight=0;this.legendDecorationMaxLabel=0;if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){if(!this.legendInside){if(this.decorationsPosition!="right"&&this.decorationsPosition!="bottom"&&this.graphType!="Network"){this.decorationsPosition="bottom"}}var f=this.getFontPt(this.decorationFont);var h=this.decorations;var b=0;if(h.nlfit){var g=this.measureText(sprintf("%96s","X"),this.decorationFont)+(this.margin*5);var a=0;for(var e=0;e<h.nlfit.length;e++){var c=this.measureText(h.nlfit[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin+g+this.margin);this.legendDecorationHeight=(h.nlfit.length*f*2)+f+this.margin}if(h.line){var a=0;for(var e=0;e<h.line.length;e++){if(h.line[e].label){var c=this.measureText(h.line[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}}if(a>0){b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.line.length*f*2)+this.margin}}if(h.reg){var g=this.measureText(sprintf("%45s","X"),this.decorationFont)+(this.margin*2);var a=0;for(var e=0;e<h.reg.length;e++){var c=this.measureText(h.reg[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin+g+this.margin);this.legendDecorationHeight+=(h.reg.length*f*2)+f+this.margin}if(h.nor){var g=this.measureText(sprintf("%30s","X"),this.decorationFont)+(this.margin*1);var a=0;for(var e=0;e<h.nor.length;e++){var c=this.measureText(h.nor[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin+g+this.margin);this.legendDecorationHeight+=(h.nor.length*f*2)+f+this.margin}if(h.area){var a=0;for(var e=0;e<h.area.length;e++){var c=this.measureText(h.area[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.area.length*f*2)+this.margin}if(h.kaplanMeier){var a=0;for(var e=0;e<h.kaplanMeier.length;e++){var c=this.measureText(h.kaplanMeier[e].label,this.decorationFont);a=Math.max(c,a);this.legendDecorationMaxLabel=Math.max(a,this.legendDecorationMaxLabel)}b=Math.max(b,this.margin+a+this.margin);this.legendDecorationHeight+=(h.kaplanMeier.length*f*2)-this.margin}this.legendDecorationWidth=b}};this.setOncoprintLegendDimension=function(){this.legendOncoprintWidth=0;this.legendOncoprintHeight=0;if(this.isOncoprint){var c=this.measureText("Amplification",this.legendFont);var e=this.measureText("Deletion",this.legendFont);var b=this.measureText("Mutation",this.legendFont);this.legendOncoprintWidth=100+c+e+b+(this.margin*2);this.legendOncoprintHeight=30+(this.margin*2)}};this.setSampleLegendDimension=function(){this.legendSampleWidth=0;this.legendSampleHeight=0;var d=this.getFontPt(this.legendFont);var b=0;if(this.graphType.match(/Scatter/)){if(this.xAxisIndices.length!=this.yAxisIndices.length||this.xAxisIndices.length>1){if(this.xAxisIndices.length==this.yAxisIndices.length&&this.xAxisIndices.length>1){for(var c=0;c<this.xAxisIndices.length;c++){var a;if(this.isHistogram){a=this.measureText(this.shortenText(this.xAxis[c],this.maxSmpStringLen),this.legendFont)}else{a=this.measureText(this.shortenText(this.xAxis[c],this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[c],this.maxSmpStringLen),this.legendFont)}b=Math.max(a,b)}}else{if(this.xAxisIndices.length>this.yAxisIndices.length){b=this.measureText(this.shortenText(this.getMaxText(this.xAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.yAxis[0],this.maxSmpStringLen),this.legendFont)}else{if(this.yAxisIndices.length>this.xAxisIndices.length){if(this.isHistogram){b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen),this.legendFont)}else{b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen)+" vs "+this.shortenText(this.xAxis[0],this.maxSmpStringLen),this.legendFont)}}}}this.legendSampleWidth=(d-1)+b+(this.margin*3);this.legendSampleHeight=(Math.max(this.xAxisIndices.length,this.yAxisIndices.length)*(d+this.margin))+this.margin}else{if(this.isHistogram){b=this.measureText(this.shortenText(this.getMaxText(this.yAxis),this.maxSmpStringLen),this.legendFont);this.legendSampleWidth=(d-1)+b+(this.margin*3);this.legendSampleHeight=(Math.max(this.xAxisIndices.length,this.yAxisIndices.length)*(d+this.margin))+this.margin}}}};this.setVariableLegendDimension=function(){this.legendVariableWidth=0;this.legendVariableHeight=0;var a=this.isDOE&&this.layoutCurrentDOE?this.meta.data.x[this.layoutCurrentDOE]:this.meta.data.y;var f=this.getFontPt(this.legendFont);if(this.graphType=="Pie"){var g=this.varIndices.length>this.maxPieSectors?this.maxPieSectors:this.varIndices.length;var d=this.isDOE&&this.layoutCurrentDOE?this.shortenText(a.maxLevStr,this.maxVarStringLen):this.shortenText(a.maxVarStr,this.maxVarStringLen);if(this.maxPieSectors<this.varIndices.length&&d.length<5){d=this.shortenText("Other",this.maxVarStringLen)}var b=this.measureText(d,this.legendFont);if(b>this.width/2){this.legendFont=this.scaleTextToFont(b,f,this.width/2)}this.legendVariableWidth=this.measureText(d,this.legendFont)+f+(this.margin*3);this.legendVariableHeight=((f+this.margin)*g)+this.margin}else{if(this.layoutValid&&this.segregateVariablesBy.length>0){if(this.segregateVariablesBy[0]=="variable"||(this.segregateVariablesBy.length>1&&this.segregateVariablesBy[1]=="variable")){return}else{var c=a.maxVarChr>this.maxVarStringLen?a.maxVarStr.substring(0,this.maxVarStringLen):a.maxVarStr;this.legendVariableWidth=((this.margin*3)+(f*2)+this.measureText(c,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil(this.data.y.vars.length/this.legendColumns)*f*1.5)+this.margin}}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){var c=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],this.getFontPt(this.legendFont)):this.getFontPt(this.legendFont);var d=this.shortenText(a.maxVarStr,this.maxVarStringLen);this.legendVariableWidth=((c-1)+this.measureText(d,this.legendFont)+(this.margin*3))*this.legendColumns;this.legendVariableHeight=(Math.ceil(this.varIndices.length/this.legendColumns)*(c+this.margin))+this.margin}else{if(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine"){var c=a.maxVarChr>this.maxVarStringLen?a.maxVarStr.substring(0,this.maxVarStringLen):a.maxVarStr;this.legendVariableWidth=((this.margin*3)+(f*2)+this.measureText(c,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil((this.xAxisVarIndices.length+this.xAxis2VarIndices.length)/this.legendColumns)*f*1.5)+this.margin}else{if(!this.colorBy&&(this.graphType=="Bar"||this.graphType=="Line"||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot")){var c=a.maxVarChr>this.maxVarStringLen?a.maxVarStr.substring(0,this.maxVarStringLen):a.maxVarStr;this.legendVariableWidth=((this.margin*3)+(f*2)+this.measureText(c,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil(this.varIndices.length/this.legendColumns)*f*1.5)+this.margin}else{if(this.graphType=="Circular"&&!this.showIdeogram){var c=a.maxVarChr>this.maxVarStringLen?a.maxVarStr.substring(0,this.maxVarStringLen):a.maxVarStr;var e=this.rAxisIndex>=0?this.varIndices.length-1:this.varIndices.length;this.legendVariableWidth=((this.margin*3)+(f*2)+this.measureText(c,this.legendFont))*this.legendColumns;this.legendVariableHeight=(Math.ceil(e/this.legendColumns)*f*1.5)+this.margin}}}}}}};this.setVennLegendDimension=function(){var a=this.data.venn.legend?this.getMaxText(this.data.venn.legend):"N/A";this.legendWidth=this.measureText(a,this.legendFont)+(this.margin*6);this.legendHeight=this.margin+this.margin+((this.getFontPt(this.legendFont)+this.margin)*this.vennGroups)};this.setOverlaysLegendDimensions=function(){var b=this.getFontPt(this.legendFont);var s=this.getDiameterLegend();var k=Math.max(b,s);var d=["varOverlays","smpOverlays"];var e=["varOverlayProperties","smpOverlayProperties"];var y=["showVarOverlaysLegend","showSmpOverlaysLegend"];this.legendOverlaysLayout=[];this.legendOverlaysWidth=0;this.legendOverlaysHeight=0;var q=this.margin;var n=this.margin;var a=0;var g=0;var l=0;var B=false;if(this.showOverlays&&(this.showVarOverlaysLegend||this.showSmpOverlaysLegend)){for(var v=0;v<d.length;v++){if(this[d[v]].length>0&&this[y[v]]){for(var t=0;t<this[d[v]].length;t++){var f=0;var x=0;var p=this[d[v]][t];if(p!="-"){var A=d[v]=="varOverlays"?"z":"x";var r=this.meta.data[A][p];var u=this.measureText(r.maxLevStr,this.legendFont);var z=this.measureText(p,this.legendFont);if(this.graphType=="Circular"||(this[e[v]][p]&&this[e[v]][p].type=="Default")){B=true;if(r.type=="String"){f=Math.max(z,u+k+(this.margin*3))*this[d[v]+"LegendColumns"];x=((Math.max(b,s)+this.margin)*Math.ceil(r.levels.length/this[d[v]+"LegendColumns"]))+b+(this.margin*3)}else{if(this.overlaysLegendPosition.match(/right/i)){f=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z);x=this.heatmapIndicatorWidth+(this.margin*3)+b}else{f=this.heatmapIndicatorWidth+(this.margin*3)+b;x=Math.max(this.heatmapIndicatorHeight+(this.margin*2)+u,z)}}this["legend"+p+"Width"]=f;this["legend"+p+"Height"]=x;if(this.overlaysLegendPosition.match(/right/i)){if(g+this.margin+x>(this.height-(this.top+this.bottom))){q+=this.margin+f;a=f;g=x;if(this.legendOverlaysLayout[l]){l++}this.legendOverlaysLayout[l]=[[A,p,f,x]]}else{if(f>a){q+=(f-a);a=f}g+=x;if(!this.legendOverlaysLayout[l]){this.legendOverlaysLayout[l]=[]}this.legendOverlaysLayout[l].push([A,p,f,x])}}else{if(a+this.margin+f>(this.width-(this.left+this.right))){n+=this.margin+x;a=f;g=x;if(this.legendOverlaysLayout[l]){l++}this.legendOverlaysLayout[l]=[[A,p,f,x]]}else{if(x>g){n+=(x-g);g=x}a+=f;if(!this.legendOverlaysLayout[l]){this.legendOverlaysLayout[l]=[]}this.legendOverlaysLayout[l].push([A,p,f,x])}}}}}}}}if(this.overlaysLegendPosition.match(/right/i)){this.legendOverlaysWidth=B?q+this.margin:0;this.legendOverlaysHeight=B?g+this.margin:0}else{this.legendOverlaysWidth=B?a+this.margin:0;this.legendOverlaysHeight=B?n+this.margin:0}};this.setLegendDimensions=function(){if(this.showDecorations&&this.showDecorationsLegend&&this.decorations){this.decorationLayout=[0]}if(this.showLegend){this.legendLayout=[];this.legendWidth=0;this.legendHeight=0;var a=this.margin;var k=this.margin;var b=0;var j=0;var g=0;var e=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:["Color","Shape","Size","Pattern","Variable","Sample"];for(var c=0;c<e.length;c++){var f=this["legend"+e[c]+"Width"];var d=this["legend"+e[c]+"Height"];if(f>0){if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legendLayout[g]=[e[c]];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legendLayout[c]=[e[c]];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(e[c])}}}}for(var c=0;c<this.legend.length;c++){this.legend[c].id="Custom"+c;this.setCustomLegendDimensions(this.legend[c]);var f=this["legendCustom"+c+"Width"];var d=this["legendCustom"+c+"Height"];if(this.legendPosition.match(/right|left/i)){if(j+this.margin+d>this.height){a+=this.margin+f;b=f;j=d;this.legendLayout[g]=[this.legend[c].id];g++}else{if(f>b){a+=(f-b);b=f}j+=d;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(this.legend[c].id)}}else{if(b+this.margin+f>this.width){k+=this.margin+d;b=f;j=d;this.legendLayout[c]=[this.legend[c].id];g++}else{if(d>j){k+=(d-j);j=d}b+=f;if(!this.legendLayout[g]){this.legendLayout[g]=[]}this.legendLayout[g].push(this.legend[c].id)}}}this.legendWidth=this.legendPosition.match(/right|left/i)?a+this.margin:b+this.margin;this.legendHeight=this.legendPosition.match(/right|left/i)?j+this.margin:k+this.margin}};this.setLegends=function(){var h=this;var g=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:["Color","Shape","Size","Pattern","Outline"];var q=["shapeByData","sizeByData","patternByData","outlineByData"];var n=function(a,o,t,v){var u=o=="Outline"?"Color":o;var s=(h.decapitalize(u)+"s").replace("Node","").replace("Edge","");delete (h["legend"+u+"sS"]);h["legend"+u+"Meta"]=a;if(t){h["legend"+u+"Meta"].vals=h.rPretty(t[0],t[1],5);h["legend"+u+"Meta"].decs=h.getAxisDecimals(t[1]-t[0]);h["legend"+u+"Meta"].maxLevStr=h.getMaxText(h["legend"+(o=="Outline"?"Color":o)+"Meta"].vals);h["legend"+u+"Meta"].maxLevLen=h.measureText(h["legend"+u+"Meta"].maxLevStr,h.font);h["legend"+u+"Meta"].maxLevChr=h["legend"+u+"Meta"].maxLevStr.toString().length}h["legend"+u+"sMax"]=h["legend"+u+"Meta"].maxLevStr;h["legend"+u+"sN"]=h["legend"+u+"Meta"].vals.length;for(var p=0;p<h["legend"+u+"Meta"].vals.length;p++){h["legend"+u+"s"][h["legend"+u+"Meta"].vals[p].toString()]=h[s][p]}h.setPropertyLegendIndicatorDimensions(o,h["legend"+u+"Meta"])};var j=function(A,H,w,C,x){var E=0;var u=0;var z=false;var B={};var r={};var a=A[h.decapitalize(C).replace("Node","").replace("Edge","")+"s"]||h[h.decapitalize(C).replace("Node","").replace("Edge","")+"s"];var y=h.isGroupedData&&h.graphType!="Dotplot"&&h.graphType!="Boxplot"&&!h.showBoxplotOriginalData&&h.groupingFactors.length==1;if(H=="x"){var s=h.isGroupedData?h.grpIndices:h.smpIndices;for(var F=0;F<s.length;F++){var t=s[F];if(h.isGroupedData&&(h.graphType=="Dotplot"||(h.graphType=="Boxplot"&&h.showBoxplotOriginalData))){h.isGroupedData=false;for(var D=0;D<h.data.w.grps[t].length;D++){var v=h.getMetadataValue(h.data.w.grps[t][D],H,h[w]);r[v]=true}h.isGroupedData=true}else{var v=h.isGroupedData?h.getSmpAnnotations(h[w],h.data.w.grps[F],true):h.getMetadataValue(t,H,h[w]);r[v]=true}}}else{if(H=="z"){for(var F=0;F<h.varIndices.length;F++){var t=h.varIndices[F];var v=h.getMetadataValue(t,H,h[w]);r[v]=true}}else{if(H=="m"){for(var F=0;F<h.varIndices.length;F++){for(var D=0;D<h.smpIndices.length;D++){var v=x[h.varIndices[F]][h.smpIndices[D]];r[v]=true}}}else{if(H=="modified"){A.order={};for(var F=0;F<A.levels.length;F++){r[A.levels[F]]=true;A.order[A.levels[F]]=F}}else{if(H=="nodes"||H=="edges"){A.order={};for(var F=0;F<A.levels.length;F++){r[A.levels[F]]=true;A.order[A.levels[F]]=F}}}}}}r=h.getKeys(r);if(A.type=="Numeric"){if(A.orderS){r.sort(function(l,i){return A.orderS[l]-A.orderS[i]})}else{r.sort(function(l,i){return l-i});A.orderS={};for(var F=0;F<r.length;F++){A.orderS[r[F]]=F}}}else{r.sort(function(l,i){return A.order[l]-A.order[i]})}for(var F=0;F<r.length;F++){var v=r[F]!=null?r[F]:"NA";var G=h.measureText(v,h.legendFont);if(G>E){E=G;h["legend"+C+"sMax"]=v}B[v]=(A.type=="Numeric"?A.orderS[v]:A.order[v])%a.length;h["legend"+C+"s"][v]=a[B[v]];u++}h["legend"+C+"sS"]=r;z=H=="m"||H=="modified"?h["legend"+C+"sMax"]:false;h["legend"+C+"sN"]=u;h["legend"+C+"Meta"]=A;h.setPropertyLegendDimensions(C,z,A)};this.validateLegendPositions();this.setLegendFont();if(this.graphType=="Venn"){this.setVennLegendDimension();return}else{if(this.graphType=="Network"){for(var f=0;f<g.length;f++){var e=g[f];var k=this.decapitalize(g[f]);var b=k+"By";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;if(this[b]){var d=this.meta.data[e.match("Node")?"nodes":"edges"][this[b]];if(d.type=="Numeric"){n(d,e)}else{j(d,e.match("Node")?"nodes":"edges",b,e)}}}}else{if(this.isMultidimensionalData){for(var f=0;f<q.length;f++){if(this.data.y[this[q[f]]]){var c=this.data.y[this[q[f]]];var d=this.meta.data[this[q[f]]];var e=q[f].replace("ByData","");e=this.capitalize(e);var k=this.decapitalize(e);var b=k+"By";this["legend"+(e=="Outline"?"Color":e)+"s"]=[];this["legend"+(e=="Outline"?"Color":e)+"sN"]=0;if(d.type=="Numeric"){n(d,e,[d.min,d.max])}else{j(d,"m",b,e,c)}}}}else{for(var f=0;f<g.length;f++){var e=g[f];var k=this.decapitalize(g[f]);var b=k+"By";this["legend"+e+"s"]={};this["legend"+e+"sN"]=0;this["legend"+e+"Width"]=0;this["legend"+e+"Height"]=0;if(this[b]){if(this.data.x&&this.data.x.hasOwnProperty(this[b])){var d=this.meta.data.x[this[b]];this[k+"ByType"]="x";if(d.type=="Numeric"&&!d[b]){n(d,e)}else{j(d,"x",b,e)}}else{if(this.data.z&&this.data.z.hasOwnProperty(this[b])){var d=this.meta.data.z[this[b]];this[k+"ByType"]="z";if(d.type=="Numeric"&&!d[b]){n(d,e)}else{j(d,"z",b,e)}}else{if(this.getSampleIndices(this[b])>-1&&this.meta.data.y.range[this[b]]){var d=this.meta.data;if(d.modified&&d.modified.z&&d.modified.z[this[b]]){d=d.modified.z;if(!d.meta){d.meta={}}d.meta[this[b]]={levels:d[this[b]]};j(d.meta[this[b]],"modified",b,e)}else{d=d.y.range[this[b]];n(d,e,[d.min,d.max])}}else{if(this[b]=="variable"){h["legend"+e+"sN"]=this.varIndices.length;this.setVariableLegendDimension()}}}}}}}}}this.setDecorationsLegendDimensions();this.setSampleLegendDimension();this.setVariableLegendDimension();this.setOncoprintLegendDimension();this.setOverlaysLegendDimensions();this.setLegendDimensions()};this.addLegend=function(c,b){if(c){if(b){var a=this.findXYCoordinates(b);c.x=a.x;c.y=a.y}this.legend.push(c)}};this.deleteLegend=function(c){if(c&&c.id){var b=[];for(var a=0;a<this.legend.length;a++){if(this.legend[a].id!=c.id){b.push(this.legend[a])}}this.legend=b}};this.drawDecorationData=function(){this.functionCaller="drawDecorationData";var Y=this.marginLeft+this.offsetX+this.left;var U=this.marginTop+this.offsetY+this.top;var af=this.decorations;if(this.showDecorations&&af){if(this.graphType.match(/Scatter/)){if(af.nlfit){var h,M,f;var E=this.varIndices;var H,g;for(var ab=0;ab<af.nlfit.length;ab++){var aw=[];var au=[];var L=ab%this.colors.length;var a=Number(this.transformValue(this.yAxisTransform,af.nlfit[ab].param[0]));var aI=Number(this.transformValue(this.yAxisTransform,af.nlfit[ab].param[1]));var aH=Number(af.nlfit[ab].param[2]);var aF=Number(af.nlfit[ab].param[3]);var V=this.xAxisIndices.length==1?this.xAxisIndices[0]:this.xAxisIndices[ab];var ax=this.getDataForSmpGrpAtIndex(V);if(this.xAxisTransform=="percentile"){h=this.range(ax);f=h[0];M=h[1]}E.sort(function(i,d){return ax[i]-ax[d]});L=af.nlfit[ab].color?af.nlfit[ab].color:this.colors[L];for(var aa=0;aa<E.length;aa++){var A=E[aa];var O=this.getDataAtPos(A,V);var N;var K=[];if(O>0){if(aa>0){var av=E[aa-1];var ay=this.getDataAtPos(av,V);if(ay>0){var P=(O-ay)/this.functionIntervals;for(var Z=0;Z<this.functionIntervals;Z++){K.push(ay);ay+=P}}}else{K=[O]}for(var Z=0;Z<K.length;Z++){if(af.nlfit[ab].type=="reg"){N=a+((aI-a)/(1+aH/(Math.pow(K[Z],aF))))}else{N=a+((aI-a)/(1+(Math.pow((K[Z]/aH),aF))))}if(this.xAxisTransform){K[Z]=this.xAxisTransform=="percentile"?this.percentile(f,M,K[Z]):this.transformValue(this.xAxisTransform,K[Z])}H=Y+((K[Z]-this.xAxisMin)*this.xAxisUnit);g=(U+this.y)-((N-this.yAxisMin)*this.yAxisUnit);aw.push(H);au.push(g)}}}if(aw.length>0){this.addToRender(["drawShape","path",aw,au,false,false,L,L,"open",false,false,true],["Decor-Non-Lin-"+aa+"-"+ab]);if(af.nlfit[ab].type=="reg"){N=a+((aI-a)/(1+aH/(Math.pow(aH,aF))))}else{N=a+((aI-a)/(1+(Math.pow((aH/aH),aF))))}if(this.xAxisTransform){aH=this.xAxisTransform=="percentile"?this.percentile(f,M,aH):this.transformValue(this.xAxisTransform,aH)}H=Y+((aH-this.xAxisMin)*this.xAxisUnit);g=(U+this.y)-((N-this.yAxisMin)*this.yAxisUnit);var ar=this.addToRender(["drawLine","dottedLine",Y,g,H,g,L],["Decor-Non-Lin-EC-h"+aa+"-"+ab]);this.addToRender(["drawLine","dottedLine",H,g,H,(U+this.y),L],["Decor-Non-Lin-EC-v"+aa+"-"+ab],false,ar)}}}if(af.line){for(var ab=0;ab<af.line.length;ab++){if(af.line[ab].x!=null||af.line[ab].y!=null){var L=af.line[ab].color?af.line[ab].color:this.colors[ab%this.colors.length];var ah=af.line[ab].type?af.line[ab].type:"line";var O=af.line[ab].x!=null?af.line[ab].x:null;var N=af.line[ab].y!=null?af.line[ab].y:null;var D=af.line[ab].x2!=null?af.line[ab].x2:null;var b=af.line[ab].y2!=null?af.line[ab].y2:null;var Q=af.line[ab].width?af.line[ab].width:1;var H,g,F,e;if(O!=null&&N!=null&&D!=null&&b!=null){H=Y+((O-this.xAxisMin)*this.xAxisUnit);F=Y+((D-this.xAxisMin)*this.xAxisUnit);g=U+this.y-((N-this.yAxisMin)*this.yAxisUnit);e=U+this.y-((b-this.yAxisMin)*this.yAxisUnit);this.addToRender(["drawLine",ah,H,g,F,e,L,Q],["Decor-Line-"+ab])}else{if(O!=null){H=Y+((O-this.xAxisMin)*this.xAxisUnit);g=U;F=H;e=g+this.y;this.addToRender(["drawLine",ah,H,g,F,e,L,Q],["Decor-Line-"+ab])}else{if(N!=null){H=Y;g=U+this.y-((N-this.yAxisMin)*this.yAxisUnit);F=H+this.x;e=g;this.addToRender(["drawLine",ah,H,g,F,e,L,Q],["Decor-Line-"+ab])}}}}}}if(af.reg){for(var ab=0;ab<af.reg.length;ab++){if(af.reg[ab].slope&&af.reg[ab].intercept){var L=af.reg[ab].color?af.reg[ab].color:this.colors[ab%this.colors.length];var G=this.addColorTransparency(this.colors[ab%this.colors.length],0.5);var m=this.getPropertyValue(ab,false,"patternBy");var ah=af.reg[ab].type?af.reg[ab].type:"line";var aB=Number(af.reg[ab].slope);var ad=Number(af.reg[ab].intercept);var I=af.reg[ab].cor;var u="y ~ "+this.formatNumber(aB)+"x + "+this.formatNumber(ad)+" (r = "+this.formatNumber(I)+")";var R=af.reg[ab].ci;var H=af.reg[ab].start?af.reg[ab].start:this.xAxisMin;var g=(aB*H)+ad;var F=af.reg[ab].end?af.reg[ab].end:this.xAxisMax;var e=(aB*F)+ad;H=Y+(H*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(U+this.y)-(g*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);F=Y+(F*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(U+this.y)-(e*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);this.addToRender(["drawLine",ah,H,g,F,e,L,false,false,false,false,true],["Decor-Reg-"+ab]);var v=[];var r=[];var J=R.length-1;var al=[];for(var aa=0;aa<R.length;aa++){H=Y+(R[aa][0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(U+this.y)-(R[aa][1]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);e=(U+this.y)-(R[aa][2]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);v.push([H,H]);r.push([g,e]);al.push([H,(g+e)/2])}if(this.showRegressionConfidence){this.addToRender(["drawShape","confidence",v,r,false,false,G,false,m,false,false,true],[u+":Confidence"],false,null,false,al)}}}}if(af.nor){for(var ab=0;ab<af.nor.length;ab++){if(af.nor[ab].mu&&af.nor[ab].sigma){var C=[];var B=[];var at=[];var H,g;var L=ab%this.colors.length;var am=af.nor[ab].mu;var aj=af.nor[ab].sigma;var p=af.nor[ab].start?af.nor[ab].start:af.nor[ab].yAxis?this.yAxisMin:this.xAxisMin;var ac=af.nor[ab].end?af.nor[ab].end:af.nor[ab].yAxis?this.yAxisMax:this.xAxisMax;var an=120;if(p<am&&am<ac){var ay,ao,q,c;var P=(am-p)/an;var s=aj*aj;var T=s*2;var ae=1/Math.sqrt(2*Math.PI*s);if(af.nor[ab].yAxis){q=af.nor[ab].max?af.nor[ab].max*this.xAxisUnit:this.x-(this.x*this.axisExtension);c=q/ae;ay=p;for(var aa=0;aa<an-1;aa++){ao=(ae*Math.pow(Math.E,-Math.pow(ay-am,2)/s));at.push([ay,ao]);H=Y+(ao*c);g=(U+this.y)-(ay*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);C.push(H);B.push(g);ay+=P}P=(ac-am)/an;ay=am;for(var aa=0;aa<an;aa++){ao=(ae*Math.pow(Math.E,-Math.pow(ay-am,2)/s));at.push([ay,ao]);H=Y+(ao*c);g=(U+this.y)-(ay*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);C.push(H);B.push(g);ay+=P}L=af.nor[ab].color?af.nor[ab].color:this.colors[L];this.addToRender(["drawShape","path",C,B,false,false,L,L,"open",false,false,true],["Decor-Nor-"+ab])}else{q=af.nor[ab].max?af.nor[ab].max*this.yAxisUnit:this.y-(this.y*this.axisExtension);c=q/ae;ay=p;for(var aa=0;aa<an-1;aa++){ao=(ae*Math.pow(Math.E,-Math.pow(ay-am,2)/s));at.push([ay,ao]);H=Y+(ay*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(U+this.y)-(ao*c);C.push(H);B.push(g);ay+=P}P=(ac-am)/an;ay=am;for(var aa=0;aa<an;aa++){ao=(ae*Math.pow(Math.E,-Math.pow(ay-am,2)/s));at.push([ay,ao]);H=Y+(ay*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(U+this.y)-(ao*c);C.push(H);B.push(g);ay+=P}L=af.nor[ab].color?af.nor[ab].color:this.colors[L];this.addToRender(["drawShape","path",C,B,false,false,L,L,"open",false,false,true],["Decor-Nor-"+ab])}}}}}if(af.area){for(var ab=0;ab<af.area.length;ab++){if(af.area[ab].type&&af.area[ab].x&&af.area[ab].y&&af.area[ab].width&&af.area[ab].height){if(this.isValidShape(af.area[ab].type)){var H=Y+(af.area[ab].x*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);var g=(U+this.y)-(af.area[ab].y*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);var L=af.area[ab].color?af.area[ab].color:this.colors[ab%this.colors.length];var o=af.area[ab].width*this.xAxisUnit;var ag=af.area[ab].height*this.yAxisUnit;this.addToRender(["drawShape",af.area[ab].type,H,g,o,ag,L,af.area[ab].outline,af.area[ab].pattern,af.area[ab].rotate],["Decor-Area-"+ab])}}}}if(af.kaplanMeier){var H,g,F,e,aC,aA,X,W,L,G,ai,aD,aG,aE,aq,ar;for(var ab=0;ab<af.kaplanMeier.length;ab++){ai=[[],[]];aD=[[],[]];aG=[[],[]];L=af.kaplanMeier[ab].color;G=this.addColorTransparency(L,0.5);H=Y;g=(U+this.y)-(this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);F=Y+(af.kaplanMeier[ab].data.times[0]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(U+this.y)-(af.kaplanMeier[ab].data.data[0][3]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aA=(U+this.y)-(af.kaplanMeier[ab].data.data[0][4]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);W=(U+this.y)-(af.kaplanMeier[ab].data.data[0][5]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aE=H;aq=g;ar=this.addToRender(["drawLine","line",H,g,F,g,L,false,false,false,false,true],["Decor-KM-h-0-"+ab],false,null,false,[aE,aq,aE,aq]);this.addToRender(["drawLine","line",F,g,F,e,L,false,false,false,false,true],["Decor-KM-v-0-"+ab],false,ar,false,[aE,aq,aE,aq]);if(this.showKaplanMeierConfidence){ai[0].push(H,F,F);ai[1].push(g,g,aA);aD[0].push(H,F,F);aD[1].push(g,g,W)}for(var aa=1;aa<af.kaplanMeier[ab].data.times.length;aa++){H=Y+(af.kaplanMeier[ab].data.times[aa-1]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);g=(U+this.y)-(af.kaplanMeier[ab].data.data[aa-1][3]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aC=(U+this.y)-(af.kaplanMeier[ab].data.data[aa-1][4]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);X=(U+this.y)-(af.kaplanMeier[ab].data.data[aa-1][5]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);F=Y+(af.kaplanMeier[ab].data.times[aa]*this.xAxisUnit)-(this.xAxisMin*this.xAxisUnit);e=(U+this.y)-(af.kaplanMeier[ab].data.data[aa][3]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);aA=(U+this.y)-(af.kaplanMeier[ab].data.data[aa][4]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);W=(U+this.y)-(af.kaplanMeier[ab].data.data[aa][5]*this.yAxisUnit)+(this.yAxisMin*this.yAxisUnit);this.addToRender(["drawLine","line",H,g,F,g,L,false,false,false,false,true],["Decor-KM-h-"+aa+"-"+ab],false,ar,false,[aE,aq,aE,aq]);this.addToRender(["drawLine","line",F,g,F,e,L,false,false,false,false,true],["Decor-KM-h-"+aa+"-"+ab],false,ar,false,[aE,aq,aE,aq]);if(this.showKaplanMeierConfidence){ai[0].push(H,F,F);ai[1].push(aC,aC,aA);aD[0].push(H,F,F);aD[1].push(X,X,W)}}if(this.showKaplanMeierConfidence){aG[0]=ai[0].concat(aD[0].reverse());aG[1]=ai[1].concat(aD[1].reverse());this.addToRender(["drawShape","polygon",aG[0],aG[1],false,false,G,G,"closed"],["Decor-KM-Conf"+ab])}}}}else{if(af.line){for(var ab=0;ab<af.line.length;ab++){var H,g,F,e;var ak=true;var ah=af.line[ab].type||"line";var z=af.line[ab].color;var S=this.transformValue(this.isTransformedData,af.line[ab].value||0);var n=af.line[ab].label||false;var ap=af.line[ab].width||1;var az=af.line[ab].align||"left";if(this.graphOrientation=="vertical"){H=this.marginLeft+this.offsetX+this.left;F=H+this.x;g=this.marginTop+this.offsetY+this.top+this.y-((S-this.xAxisMin)*this.xAxisUnit);e=g;ak=g<=this.marginTop+this.offsetY+this.top+this.y&&g>=this.marginTop+this.offsetY+this.top?true:false}else{H=this.marginLeft+this.offsetX+this.left+((S-this.xAxisMin)*this.xAxisUnit);F=H;g=this.marginTop+this.offsetY+this.top;e=g+this.y;ak=H<=this.marginLeft+this.offsetX+this.left+this.x&&this.marginLeft+this.offsetX+this.left?true:false}if(ak){if(n){if(this.graphOrientation=="vertical"){if(az=="right"){this.addToRender(["drawText",n,F-this.margin,e-this.margin,this.decorationFont,this.decorationColor,"right","bottom"])}else{if(az=="center"){this.addToRender(["drawText",n,H+(this.x/2),e-this.margin,this.decorationFont,this.decorationColor,"center","bottom"])}else{this.addToRender(["drawText",n,H+this.margin,e-this.margin,this.decorationFont,this.decorationColor,"left","bottom"])}}}else{if(az=="right"){this.addToRender(["drawText",n,F+(this.margin*2),e-this.margin,this.decorationFont,this.decorationColor,"left","middle"])}else{if(az=="center"){this.addToRender(["drawText",n,F+(this.margin*2),g+(this.y/2),this.decorationFont,this.decorationColor,"left","middle"])}else{this.addToRender(["drawText",n,F+(this.margin*2),g+this.margin,this.decorationFont,this.decorationColor,"left","middle"])}}}}this.addToRender(["drawLine",ah,H,g,F,e,z,ap],["Decor-Line"+ab])}}}if(af.marker){this.drawMarkers()}}}};this.drawOncoprintLegend=function(){this.functionCaller="drawOncoprintLegend";if(this.isOncoprint){var a=this.marginLeft+this.offsetX+this.left+15;var g=this.marginTop+this.offsetY+this.top+this.y+this.bottom+this.margin-30;var d=this.measureText("Amplification",this.legendFont);var i=this.measureText("Deletion",this.legendFont);var f=this.measureText("Mutation",this.legendFont);if(this.legendOncoprintX&&this.legendOncoprintY){a=this.legendOncoprintX;g=this.legendOncoprintY}else{if(this.showLegend){if(!this.legendInside&&this.legendPosition=="bottom"){g-=this.legendHeight}}}this.legendOncoprintCurX=a;this.legendOncoprintCurY=g;var h=this.legendOncoprintCurX-10;var e=g-20;var c=100+d+i+f+(this.margin*2);var b=30+(this.margin*2);this.addToRender(["drawShape","rect",h+(c/2),e+(b/2),c,b,this.background,this.background],[-1],["-legend-oncoprint"]);this.addToRender(["drawShape","rect",a,g,10,30,"rgb(255,0,0)"],["Onc-Amplification"]);a=a+10+this.margin;this.addToRender(["drawText","Amplification",a,g,this.legendFont,this.legendColor,"left","middle"]);a=a+d+25;this.addToRender(["drawShape","rect",a,g,10,30,"rgb(0,0,255)"],["Onc-Deletion"]);a=a+10+this.margin;this.addToRender(["drawText","Deletion",a,g,this.legendFont,this.legendColor,"left","middle"]);a=a+i+25;this.addToRender(["drawShape","rect",a,g,10,30,"rgb(220,220,220)"],["Onc-Mutation"]);this.addToRender(["drawShape","rect",a,g,10,10,"rgb(0,153,0)"]);a=a+10+this.margin;this.addToRender(["drawText","Mutation",a,g,this.legendFont,this.legendColor,"left","middle"])}};this.drawStockIndicatorsLegend=function(){this.functionCaller="drawStockIndicatorsLegend";var d=this.marginLeft+this.offsetX+this.left;var n=this.marginTop+this.offsetY+this.top;if(this.summaryType=="candle"&&this.stockIndicators.length>0){var a=this.getFontPt(this.legendFont);var f=a/2;var b=this.measureText(this.getMaxText(this.stockIndicators),this.legendFont)+a+(this.margin*2);var k=this.graphOrientation=="vertical"?d+(this.margin*2):d+this.x-b;var j=n+this.margin+a;for(var e=0;e<this.stockIndicators.length;e++){var g=this.getTechnicalIndicatorColor(this.stockIndicators[e]);this.addToRender(["drawLine","line",k+f,j+f,k+f+a,j+f,g,false,"butt",false,false,true]);this.addToRender(["drawText",this.stockIndicators[e],k+a+this.margin,j+f,this.legendFont,g,"left","middle"]);j+=this.margin+a}}};this.drawSampleLegend=function(b,l){this.functionCaller="drawSampleLegend";var k=b;var d=l;var q=this.getFontPt(this.legendFont);var p=(q-1)/2;l+=this.margin+p;this.drawLegendBackgroundBox(k,d,this.legendSampleWidth,this.legendSampleHeight,true,"-legend-sample");var n=Math.max(this.xAxisIndices.length,this.yAxisIndices.length);for(var f=0;f<n;f++){var c=f%this.colors.length;var o=0;var h=this.getPropertyValue(f,false,"patternBy");var g=this.xAxisIndices.length==this.yAxisIndices.length?this.yAxis[f]:this.xAxisIndices.length>this.yAxisIndices.length?this.yAxis[this.yAxisCurrent]:this.yAxis[f];var j=this.xAxisIndices.length==this.yAxisIndices.length?this.xAxis[f]:this.xAxisIndices.length>this.yAxisIndices.length?this.xAxis[f]:this.xAxis[this.xAxisCurrent];var m=this.isHistogram?this.shortenText(g,this.maxSmpStringLen):this.shortenText(g,this.maxSmpStringLen)+" vs "+this.shortenText(j,this.maxSmpStringLen);var e=b+p+this.margin;var a=l+p+this.margin;if(this.colorBy){this.addToRender(["drawShape",this.shapes[o],e,l,q-1,q-1,this.background,this.colors[c],"open"])}else{this.addToRender(["drawShape",this.shapes[o],e,l,q-1,q-1,this.colors[c],this.foreground,h])}this.addToRender(["drawText",m,e+p+this.margin,l,this.legendFont,this.legendColor,"left","middle"]);l+=q+this.margin}this.drawLegendBackgroundBox(k,d,this.legendSampleWidth,this.legendSampleHeight)};this.drawVariableLegend=function(B,c){this.functionCaller="drawVariableLegend";var o=B;var D=c;var n=this.getFontPt(this.legendFont);var t=n/2;var a=n*2;var d=n*1.5;var u=0;if(this.legendVariableWidth==0||this.legendVariableHeight==0){return}else{if(this.graphType=="Pie"){this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var A=!this.layoutComb?this.width-(B+(this.margin*1.5)):this.isDOE?this.layoutWidth-((B-this.offsetX)+(this.margin*1.5)):999999;B+=t+this.margin;c+=n;for(var x=0;x<this.varPie.ids.length;x++){var f=false;var m=this.varPie.ids[x];var g=this.varPie.cols[x];var q=m>-1?this.shortenText(this.data.y.vars[m],this.maxVarStringLen):"Other";this.addToRender(["drawShape","square",B,c,n,n,g,this.foreground,"closed"]);if(A>0){while(this.measureText(q,this.legendFont)>A&&q.length>1){q=q.substring(0,q.length-1);f=true}if(f){q=q+"..."}this.addToRender(["drawText",q,B+n,c,this.legendFont,this.legendColor,"left","middle"])}c+=n+this.margin;if(this.layoutComb){if((c-this.offsetY)>this.layoutHeight){this.addToRender(["drawText","...",B+n,c,this.legendFont,this.legendColor,"left","bottom"]);break}}else{if(c>this.height){this.addToRender(["drawText","...",B+n,c,this.legendFont,this.legendColor,"left","bottom"]);break}}}this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight)}else{if((this.colorBy&&this.colorBy=="variable")||(this.shapeBy&&this.shapeBy=="variable")||(this.sizeBy&&this.sizeBy=="variable")||(this.patternBy&&this.patternBy=="variable")){this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var w=this.sizeBy&&this.sizeBy=="variable"?Math.max(this.sizes[this.varIndices.length-1],n):n;var C=w/2;var z=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(this.varIndices.length/this.legendColumns);c+=this.margin+this.margin;for(var x=0;x<b;x++){for(var s=0;s<this.legendColumns;s++){B=o+(this.margin+(z*s));if(u<this.varIndices.length){var m=this.varIndices[u];var g=this.graphType=="Circular"||(this.colorBy&&this.colorBy=="variable")?u%this.colors.length:0;var p=this.shapeBy&&this.shapeBy=="variable"?u%this.shapes.length:0;var v=this.sizeBy&&this.sizeBy=="variable"?this.sizes[u%this.sizes.length]:w;var l=this.patternBy&&this.patternBy=="variable"?this.patterns[u%this.patterns.length]:this.getPropertyValue(m,false,"patternBy");var k=B+C;var y=c+C;var q=this.shortenText(this.data.y.vars[m],this.maxVarStringLen);if(this.colorBy&&this.colorBy!="variable"){this.addToRender(["drawShape",this.shapes[p],k,c,v,v,this.background,this.foreground,l])}else{this.addToRender(["drawShape",this.shapes[p],k,c,v,v,this.colors[g],this.foreground,l])}this.addToRender(["drawText",q,k+C+this.margin,c,this.legendFont,this.legendColor,"left","middle"])}else{break}u++}c+=w+this.margin}this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight)}else{if(this.graphType=="BarLine"||this.graphType=="DotLine"||this.graphType=="AreaLine"||this.graphType=="StackedLine"||this.graphType=="StackedPercentLine"){this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var h=this.xAxisVarIndices.concat(this.xAxis2VarIndices);var z=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(h.length/this.legendColumns);c+=this.margin;for(var x=0;x<b;x++){for(var s=0;s<this.legendColumns;s++){B=o+this.margin+(z*s);if(u<h.length){var m=u<this.xAxisVarIndices.length?this.xAxisVarIndices[u]:this.xAxis2VarIndices[u-this.xAxisVarIndices.length];var g=u<this.xAxisVarIndices.length?this.getVariableColor(this.data.y.vars[m]):this.coordinateLineColor?this.colors[(u-this.xAxisVarIndices.length)%this.colors.length]:this.getVariableColor(this.data.y.vars[m]);var l=this.getPropertyValue(m,false,"patternBy");var q=this.shortenText(this.data.y.vars[m],this.maxVarStringLen);if(u<this.xAxisVarIndices.length){this.addToRender(["drawShape","rectangle",B+(n/2),c+(n/2),n,n,g,this.foreground,l],["Var-"+m]);this.addToRender(["drawText",q,B+a,c+t,this.legendFont,this.legendColor,"left","middle"],["Var-"+m])}else{this.addToRender(["drawLine","line",B,c+t,B+n,c+t,g],["Var-"+m]);if(this.lineDecoration){}this.addToRender(["drawText",q,B+a,c+t,this.legendFont,this.legendColor,"left","middle"],["Var-"+m])}}else{break}u++}c+=d}this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight)}else{if(this.graphType=="Bar"||this.graphType=="Line"||this.graphType=="ParallelCoordinates"||this.graphType=="Area"||this.graphType=="Dotplot"||this.graphType=="Stacked"||this.graphType=="StackedPercent"||this.graphType=="Boxplot"){this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var z=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(this.varIndices.length/this.legendColumns);c+=this.margin;for(var x=0;x<b;x++){for(var s=0;s<this.legendColumns;s++){B=o+this.margin+(z*s);if(u<this.varIndices.length){var m=this.varIndices[u];var g=this.getVariableColor(this.data.y.vars[m]);var l=this.getPropertyValue(m,false,"patternBy");var q=this.shortenText(this.data.y.vars[m],this.maxVarStringLen);if(this.graphType=="Line"||this.graphType=="ParallelCoordinates"){this.addToRender(["drawLine","line",B,c+t,B+n,c+t,g],["Var-"+m]);if(this.lineDecoration){this.addToRender(["drawShape",this.lineDecoration=="symbol"?this.shapes[u%this.shapes.length]:"circle",B+t,c+t,t,t,g,g,l])}}else{if(this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){if(this.shapeBy){this.addToRender(["drawShape",this.shapes[u%this.shapes.length],B+t,c+t,n,n,g,this.foreground,l],["Var-"+m])}else{this.addToRender(["drawShape","circle",B+t,c+t,n,n,g,this.foreground,l],["Var-"+m])}}else{this.addToRender(["drawShape","rectangle",B+(n/2),c+(n/2),n,n,g,this.foreground,l],["Var-"+m])}}this.addToRender(["drawText",q,B+a,c+t,this.legendFont,this.legendColor,"left","middle"],["Var-"+m])}else{break}u++}c+=d}this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight)}else{if(this.graphType=="Circular"&&!this.showIdeogram){var r=this.r/2.7;if(this.legendVariableWidth>r||this.legendVariableHeight>r){return}this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight,true,"-legend-variable");var e=[];if(this.rAxisIndex>=0){for(var x=0;x<this.varIndices.length;x++){if(x==this.rAxisIndex){continue}e.push(this.varIndices[x])}}else{e=this.varIndices}var z=this.legendVariableWidth/this.legendColumns;var b=Math.ceil(e.length/this.legendColumns);c+=this.margin;for(var x=0;x<b;x++){for(var s=0;s<this.legendColumns;s++){B=o+this.margin+(z*s);if(u<e.length){var m=e[u];var g=this.colors[u%this.colors.length];var l=this.getPropertyValue(m,false,"patternBy");var q=this.shortenText(this.data.y.vars[m],this.maxVarStringLen);this.addToRender(["drawShape","rectangle",B+(n/2),c+(n/2),n,n,g,this.foreground,l],["Var-"+m]);this.addToRender(["drawText",q,B+a,c+t,this.legendFont,this.legendColor,"left","middle"],["VarLbl-"+m])}else{break}u++}c+=d}this.drawLegendBackgroundBox(o,D,this.legendVariableWidth,this.legendVariableHeight)}}}}}}};this.drawVennLegend=function(){this.functionCaller="drawVennLegend";if(this.showLegend){var j=this.getFontPt(this.legendFont);var d=this.vennMarginLeft+this.marginLeft+this.left;var c=d+(j*2);var g=this.vennMarginTop+this.marginTop+this.top+this.y+this.margin+(j/2);var h=[];var a=[];for(var f in this.data.venn.legend){a.push(f)}a=a.sort();if(this.vennGroups==4){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,153,51)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[3]):"rgb(153,204,0)");h.push(this.vennColors.length>3&&this.validateColor(this.vennColors[3])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==3){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(0,255,0)");h.push(this.vennColors.length>2&&this.validateColor(this.vennColors[2])?this.validateColor(this.vennColors[2]):"rgb(0,0,255)")}else{if(this.vennGroups==2){h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(0,0,255)");h.push(this.vennColors.length>1&&this.validateColor(this.vennColors[1])?this.validateColor(this.vennColors[1]):"rgb(255,0,0)")}else{h.push(this.vennColors.length>0&&this.validateColor(this.vennColors[0])?this.validateColor(this.vennColors[0]):"rgb(255,0,0)")}}}for(var f=0;f<this.vennGroups;f++){if(!this.vennLegendColors){this.addToRender(["drawText",a[f]+": ",d,g,this.legendFont,this.legendColor,"left","middle"])}var b=this.data.venn.legend&&this.data.venn.legend[a[f]]?this.data.venn.legend[a[f]]:"N/A";var e=(this.measureText(b,this.legendFont)>this.x)?this.scaleTextToFont(b,j,this.x-this.margin):this.legendFont;if(!this.vennLegendColors){this.addToRender(["drawText",b,c,g,e,this.legendColor,"left","middle"])}else{this.addToRender(["drawText",b,d,g,e,h[f],"left","middle"])}g+=this.margin+j}}};this.drawColorIndicator=function(B,f,o,H,E,g){this.functionCaller="drawColorIndicator";if(g||E||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy||this.colorNodeBy||this.colorEdgeBy){var r=H||this.colorBy||this.outlineBy||this.colorNodeBy||this.colorEdgeBy;var m=g?"-legend-"+g+"-color":E?"-legend-indicator-color":"-legend-color";var h=g?"overlaysLegendPosition":E?"heatmapIndicatorPosition":"legendPosition";var G=g?g:E?0:this.legendColorWidth?this.legendColorWidth/2:10;var s=B;var F=f;var b=0;var A=this.heatmapIndicatorHeight;var e=this.heatmapIndicatorHeight;var u=o.min;var y=o.max;var a=o.decs;var q=o.vals;var p=this.heatmapIndicatorWidth/(y-u);var D=this.graphType=="Circular"?o:o.colorBrew?o.colorBrew:this.meta.def.colorBrew;var l=this.heatmapIndicatorWidth/this.colorSpectrumNumber;var t=h=="overlaysLegendPosition"&&this[h]=="topRight"?true:false;var d=this.heatmapIndicatorHeight+(this.getFontPt(this.legendFont)*((r)?2:1))+(this.margin*2);if(this[h]&&this[h].toString().match(/top|bottom/)&&!t){this.drawLegendBackgroundBox(s-(this.margin*2),F-this.margin,this.heatmapIndicatorWidth+(this.margin*4),d,true,"-legend-indicator-color",false,true);if(r){this.addToRender(["drawText",r,B+(this.heatmapIndicatorWidth/2),f,this.legendFont,this.legendColor,"center","top"]);b=this.margin+this.getFontPt(this.legendFont);f+=b}for(var x=0;x<this.colorSpectrumNumber;x++){var n=D.stops&&D.stops.length>0?this.getColorForValue(D,D.breaks[x]):D.legend[x];var C=this.transparency!=null?this.addColorTransparency(n,this.transparency):n;this.addToRender(["drawLine","line",B,f,B,f+e,C,l+1.5]);B+=l}B=s;f+=e;if(D.stops&&D.stops.length>0){var z=B+(this.measureText(D.breaks[0].toString(),this.legendFont)/2);this.addToRender(["drawText",D.breaks[0],B,f,this.legendFont,this.legendColor,"center","top"]);for(var x=0;x<D.stops.length-1;x++){for(var w=0;w<this.colorSpectrumNumber;w++){if(D.breaks[w]>=D.stops[x]){B=s+(w*l);var k=(this.measureText(D.breaks[x].toString(),this.legendFont)/2);if(B-k>z){this.addToRender(["drawText",D.stops[x],B,f,this.legendFont,this.legendColor,"center","top"]);z=B+k}break}}}B=s+(this.colorSpectrumNumber*l);this.addToRender(["drawText",D.stops[D.stops.length-1],B,f,this.legendFont,this.legendColor,"center","top"])}else{this.addToRender(["drawText",u,B,f,this.legendFont,this.legendColor,"center","top"]);B=s+(this.heatmapIndicatorWidth/2);this.addToRender(["drawText",(u+y)/2,B,f,this.legendFont,this.legendColor,"center","top"]);B=s+((this.colorSpectrumNumber-1)*l);this.addToRender(["drawText",y,B,f,this.legendFont,this.legendColor,"center","top"])}if(this.graphType=="Heatmap"&&this.heatmapIndicatorHistogram){this.drawHeatmapIndicatorHistogram(s,F+b)}}else{this.drawLegendBackgroundBox(s,F,this.legendColorWidth,this.legendColorHeight,true,m,false,true);if(r){this.addToRender(["drawText",r,B+G+this.margin,f,this.legendFont,this.legendColor,"center","top"]);f+=(this.margin*1.5)+this.getFontPt(this.legendFont)}for(var x=0;x<this.colorSpectrumNumber;x++){var C=this.transparency!=null?this.addColorTransparency(D.legend[x],this.transparency):D.legend[x];this.addToRender(["drawLine","line",B,f,B+A,f,C,l+1.5]);f+=l}B+=A;if(r){f=F+(this.margin*1.5)+this.getFontPt(this.legendFont)}else{f=F}for(var x=0;x<q.length;x++){if(q[x]>=u&&q[x]<=y){var e=f+((q[x]-u)*p);this.addToRender(["drawText",q[x],B+this.margin,e,this.legendFont,this.legendColor,"left","middle"])}}}}};this.drawHeatmapIndicatorHistogram=function(x,b){this.functionCaller="drawHeatmapIndicatorHistogram";var w,a;var o=x;var z=b+this.heatmapIndicatorHeight;var y=[];for(var u=0;u<this.data.y.vars.length;u++){for(var s=0;s<this.data.y.smps.length;s++){var g=this.getDataAtPos(u,s,false,this.xAxisTransform,this.get1DMinFloorValue(),this.get1DMaxCeilValue());if(g!=null&&g!=""&&!isNaN(g)){y.push(g)}}}var k=this.range(y);var m=this.freedmanDiaconis(y);var r=k[0];var t=k[1];var q=Math.ceil((t-r)/m);var e=[];for(var u=0;u<q;u++){e[u]=0}for(var u=0;u<this.data.y.vars.length;u++){for(var s=0;s<this.data.y.smps.length;s++){var g=this.getDataAtPos(u,s,false,this.xAxisTransform,this.get1DMinFloorValue(),this.get1DMaxCeilValue());if(g!=null&&g!=""&&!isNaN(g)){var n=parseInt((g-r)/m);e[n]++}}}r=0;t=0;for(var u=0;u<q;u++){r=Math.min(r,e[u]);t=Math.max(t,e[u])}var l=this.legendFont;var h=this[this.axisAlgorithm](r,t,3,this.axisWilkinsonLoose);var p=this.getMaxText(h);var f=(this.heatmapIndicatorWidth-1)/q;var c=this.heatmapIndicatorHeight/h[h.length-1];if(this.heatmapIndicatorPosition=="topLeft"){l=this.scaleTextToFont(p,this.getFontPt(this.legendFont),this.left-(this.heatmapIndicatorWidth+(this.margin*3)))}for(var u=0;u<h.length;u++){b=(h[u]*c);this.addToRender(["drawLine","line",o-this.margin,z-b,o,z-b,this.foreground]);this.addToRender(["drawText",h[u],o-(this.margin*1.5),z-b,l,this.legendColor,"right","middle"])}b=(e[0]*c);this.addToRender(["drawLine","line",o,z,o,z-b,this.heatmapIndicatorHistogramColor]);for(var u=0;u<q;u++){b=(e[u]*c);this.addToRender(["drawLine","line",o,z-b,o+f,z-b,this.heatmapIndicatorHistogramColor]);if(u<q-1){a=(e[u+1]*c);this.addToRender(["drawLine","line",o+f,z-b,o+f,z-a,this.heatmapIndicatorHistogramColor])}o+=f}this.addToRender(["drawLine","line",o,z-a,o,z,this.heatmapIndicatorHistogramColor])};this.isDrawPropertyLegend=function(a){if(a){if(this.graphType=="Network"){return(this[a+"By"]&&this.meta.data.edges[this[a+"By"]])||(this[a+"By"]&&this.meta.data.nodes[this[a+"By"]])}else{return(this[a+"By"]&&this.isMultidimensionalData)||(this[a+"By"]&&((this.data.x&&this.data.x.hasOwnProperty(this[a+"By"]))||(this.data.z&&this.data.z.hasOwnProperty(this[a+"By"]))||this.getSampleIndices(this[a+"By"])>-1))}}else{if(this.graphType=="Network"){return(this.colorEdgeBy&&this.meta.data.edges[this.colorEdgeBy])||(this.colorNodeBy&&this.meta.data.nodes[this.colorNodeBy])}else{return(this.outlineBy&&this.isMultidimensionalData)||(this.colorBy&&((this.data.x&&this.data.x.hasOwnProperty(this.colorBy))||(this.data.z&&this.data.z.hasOwnProperty(this.colorBy))||this.getSampleIndices(this.colorBy)>-1))}}};this.drawColorLegend=function(a,b,d,c){if(this.isMap){a+=parseInt(this.meta.canvas.ctx2.canvas.style.left);b+=parseInt(this.meta.canvas.ctx2.canvas.style.top)}if(this.isDrawPropertyLegend()){if(d.type=="Numeric"&&!d.colorBy){this.drawColorIndicator(a,b,d)}else{this.drawPropertyLegend(c,a,b,d)}}};this.drawShapeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawSizeLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPatternLegend=function(a,b,d,c){this.drawPropertyLegend(c,a,b,d)};this.drawPropertyLegend=function(f,A,h,o){this.functionCaller="drawPropertyLegend";var s=this.decapitalize(f);if(this.isDrawPropertyLegend(s)){var B=f.replace("Node","").replace("Edge","")=="Size"?0:this.getDiameterLegend();if(f.replace("Node","").replace("Edge","")=="Size"){for(var z=0;z<(this.legendSizesN||o.levels.length);z++){B=Math.max(B,o.sizes?o.sizes[z]:this.sizes[z])}}var u=this.getFontPt(this.legendFont);var j=u/2;var a=this.legendColumns>this["legend"+f+"sN"]?this["legend"+f+"sN"]:this.legendColumns;var e=Math.ceil(this["legend"+f+"sN"]/a);var l=this["legend"+f+"Width"]/a;var g=h+this.margin+j;var y=Math.max(B,u);var w=0;this.drawLegendBackgroundBox(A,h,this["legend"+f+"Width"],this["legend"+f+"Height"],true,"-legend-"+s);var D=f.replace("Node","").replace("Edge","")=="Color"&&this.outlineBy?this.outlineBy:this[s+"By"];this.addToRender(["drawText",D,A+(this["legend"+f+"Width"]/2),g,this.legendFont,this.legendColor,"center","middle"]);g+=j+this.margin;this.disableGradientTransparencyShadow();if(this.legendBox){this.addToRender(["drawLine","line",A,g,A+this["legend"+f+"Width"],g,this.legendBoxColor])}this.enableGradientTransparencyShadow();g+=this.margin+(y/2);var b=this["legend"+f+"sS"]||this.sortObject(this["legend"+f+"s"]);for(var q=0;q<e;q++){for(var C=0;C<a;C++){var m=A+this.margin+B/2+(l*C);if(w<this["legend"+f+"sN"]){var v=b[w];if(f.replace("Node","").replace("Edge","")=="Color"){var k=o.colorBy&&o.colorBy.hasOwnProperty(v)?o.colorBy[v]:this.legendColors?this.legendColors[v]:o.colors[w];if(this.outlineBy){this.addToRender(["drawShape","circle",m,g,B,B,false,k,"open",false,2])}else{this.addToRender(["drawShape","circle",m,g,B,B,k,this.foreground,"closed"])}}else{if(f.replace("Node","").replace("Edge","")=="Shape"){var t=o.shapeBy&&o.shapeBy.hasOwnProperty(v)?o.shapeBy[v]:this.legendShapes?this.legendShapes[v]:o.shapes[w];this.addToRender(["drawShape",t,m,g,B,B,this.background,this.foreground,"closed"])}else{if(f.replace("Node","").replace("Edge","")=="Size"){var x=o.sizeBy&&o.sizeBy.hasOwnProperty(v)?o.sizeBy[v]:this.legendSizes?this.legendSizes[v]:o.sizes[w];this.addToRender(["drawShape","circle",m,g,x,x,this.background,this.foreground,"closed"])}else{if(f.replace("Node","").replace("Edge","")=="Pattern"){var n=o.patternBy&&o.patternBy.hasOwnProperty(v)?o.patternBy[v]:this.legendPatterns?this.legendPatterns[v]:o.patterns[w];this.addToRender(["drawShape","square",m,g,B,B,this.background,this.foreground,n])}}}}this.addToRender(["drawText",v,m+(y/2)+this.margin,g,this.legendFont,this.legendColor,"left","middle"])}w++}g+=this.margin+y}this.drawLegendBackgroundBox(A,h,this["legend"+f+"Width"],this["legend"+f+"Height"])}};this.drawCustomLegend=function(C,a,j,E,u){this.functionCaller="drawCustomLegend";var w=u.text.length;var y=this.getDiameterLegend();var q=u.size;if(q){for(var z=0;z<q.length;z++){if(q[z]){y=Math.max(y,q[z])}}}var f=this.getFontPt(this.legendFont);var b=f/2;var k=this.legendColumns>w?w:this.legendColumns;var d=Math.ceil(w/k);var l=j/k;var B=a+this.margin+b;var p=Math.max(y,f);var g=0;this.drawLegendBackgroundBox(C,a,j,E,true,"-legend-"+u.id);if(u.title){this.addToRender(["drawText",u.title,C+(j/2),B,this.legendFont,this.legendColor,"center","middle"]);B+=b+this.margin;this.disableGradientTransparencyShadow();if(this.legendBox){this.addToRender(["drawLine","line",C,B,C+j,B,this.legendBoxColor])}this.enableGradientTransparencyShadow();B+=this.margin+(p/2)}else{B+=(p/2)-b}var x=false;for(var t=0;t<d;t++){for(var D=0;D<k;D++){var m=C+this.margin+y/2+(l*D);if(g<w){if(u.shape&&u.shape[g]){var o=u.size[g]||y;var D=u.shapeColor[g]||this.background;this.addToRender(["drawShape",u.shape[g],m,B,o,o,D,D,"closed"]);x=true}if(u.line&&u.line[g]){var o=u.size[g]||y;var A=o/2;var D=u.lineColor[g]||this.background;var e=u.lineStart&&u.lineStart[g]?u.lineStart[g]:false;var v=u.lineEnd&&u.lineEnd[g]?u.lineEnd[g]:false;this.addToRender(["drawLine",u.line[g],m-A,B,m+A,B,D,false,false,false,false,false,false,false,e,v]);x=true}if(x){this.addToRender(["drawText",u.text[g],m+(p/2)+this.margin,B,this.legendFont,this.legendColor,"left","middle"])}else{this.addToRender(["drawText",u.text[g],m+(j/2),B,this.legendFont,this.legendColor,"center","middle"])}}g++}B+=this.margin+p}this.drawLegendBackgroundBox(C,a,j,E)};this.drawGenericLegend=function(r,o,m,x,p,z,n){this.functionCaller="drawGenericLegend";var s=this.getDiameterLegend();var d=this.getFontPt(this.legendFont);var q=Math.max(s,d);var b=q/2;var e=0;this.drawLegendBackgroundBox(r,o,m,x,true,"-legend");this.addToRender(["drawText",z,r+(m/2),o+this.margin+(d/2),this.legendFont,this.legendColor,"center","middle"]);e=o+d+(this.margin*2);if(this.legendBox){this.addToRender(["drawLine","line",r,e,r+m,e,this.legendBoxColor])}e+=this.margin;if(!n){n=1}var c=m/n;var f=Math.ceil(p.levels.length/n);var g=0;var a=e;for(var v=0;v<f;v++){for(var u=0;u<n;u++){var y=r+this.margin+(c*u);if(g<p.levels.length){var k=p.type=="String"?p.colors[g]:this.getColorForValue(p.colorBrew,p.levels[g]);this.addToRender(["drawShape","square",y+(s/2),a+(q/2),s,s,k,this.foreground]);this.addToRender(["drawText",p.levels[g],y+s+this.margin,a+(q/2),this.legendFont,this.legendColor,"left","middle"])}else{break}g++}a+=q+this.margin}this.drawLegendBackgroundBox(r,o,m,x)};this.drawDecorationLegend=function(e,s){this.functionCaller="drawDecorationLegend";if(this.graphType.match(/Scatter/)){var p,o;var m=this.decorations;var u=this.getFontPt(this.decorationFont);var c=this.measureText(sprintf("%15s","X"),this.decorationFont);var r=m.nlfit||m.nor||m.reg?c:0;var n=e+(r?this.legendDecorationMaxLabel+c:this.margin);var a=n;var g=s;var q=g;this.legendDecorationCurX=e;this.legendDecorationCurY=s;this.drawLegendBackgroundBox(e,(s-((u/2)+this.margin)),this.legendDecorationWidth,this.legendDecorationHeight+this.margin,true,"-legend-decorations",true);if(m.nlfit){this.addToRender(["drawText","Min",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Max",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","EC50",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Slope",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","p-Val",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","F-Chg",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);q+=u+u;for(var k=0;k<m.nlfit.length;k++){var f=k%this.colors.length;f=m.nlfit[k].color?m.nlfit[k].color:this.colors[f];a=(n+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.nlfit[k].label,a,q,this.decorationFont,f,"right","middle"]);a=n;for(var h=0;h<6;h++){var b=m.nlfit[k].param[h];if(h<2){b=this.transformValue(this.yAxisTransform,b)}else{if(h==2){}}this.addToRender(["drawText",this.formatNumber(b),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin}q+=u+u}}if(m.line){for(var k=0;k<m.line.length;k++){if(m.line[k].label){max=Math.max(max,this.measureText(m.line[k].label,this.decorationFont));for(var k=0;k<m.line.length;k++){var f=m.line[k].color?m.line[k].color:this.colors[k%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.line[k].label,a,q,this.decorationFont,f,"left","middle"]);q+=u+u}}}}if(m.reg){this.addToRender(["drawText","Slope",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Int",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Cor",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);q+=u+u;for(var k=0;k<m.reg.length;k++){var f=m.reg[k].color?m.reg[k].color:this.colors[k%this.colors.length];a=(n+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.reg[k].label,a,q,this.decorationFont,f,"right","middle"]);a=n;this.addToRender(["drawText",this.formatNumber(m.reg[k].slope),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText",this.formatNumber(m.reg[k].intercept),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText",this.formatNumber(m.reg[k].cor),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;q+=u+u}}if(m.nor){this.addToRender(["drawText","Mu",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText","Sigma",a,q,this.decorationFont,this.decorationsColor,"right","middle"]);q+=u+u;for(var k=0;k<m.nor.length;k++){var f=k%this.colors.length;f=m.nor[k].color?m.nor[k].color:this.colors[f];a=(n+this.margin)-c;if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.nor[k].label,a,q,this.decorationFont,f,"right","middle"]);a=n;this.addToRender(["drawText",this.formatNumber(m.nor[k].mu),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;this.addToRender(["drawText",this.formatNumber(m.nor[k].sigma),a,q,this.decorationFont,this.decorationsColor,"right","middle"]);a+=c+this.margin;q+=u+u}}if(m.area){for(var k=0;k<m.area.length;k++){if(m.area[k].label){var f=m.area[k].color?m.area[k].color:this.colors[k%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.area[k].label,a,q,this.decorationFont,f,"left","middle"]);q+=u+u}}}if(m.kaplanMeier){for(var k=0;k<m.kaplanMeier.length;k++){if(m.kaplanMeier[k].label){var f=m.kaplanMeier[k].color?m.kaplanMeier[k].color:this.colors[k%this.colors.length];if(this.graphType=="ScatterBubble2D"&&this.decorationsPosition=="right"&&this.zAxisShow){a+=this.margin+this.getFontPt(this.axisTitleFont)+this.margin}this.addToRender(["drawText",m.kaplanMeier[k].label,a,q,this.decorationFont,f,"left","middle"]);q+=u+u}}}this.drawLegendBackgroundBox(e,(s-((u/2)+this.margin)),this.legendDecorationWidth,this.legendDecorationHeight+this.margin,false,false,true)}};this.resetLegends=function(c){if(c){delete (this.legendDecorationCurX);delete (this.legendDecorationCurY);delete (this.legendDecorationX);delete (this.legendDecorationY)}var a=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:["Color","Shape","Size","Pattern","Variable","Sample"];for(var b=0;b<a.length;b++){this["legend"+a[b]+"Width"]=0;this["legend"+a[b]+"Height"]=0;if(c){delete (this["legend"+a[b]+"CurX"]);delete (this["legend"+a[b]+"CurY"]);delete (this["legend"+a[b]+"X"]);delete (this["legend"+a[b]+"Y"])}}delete (this.legendColorIndicatorCurX);delete (this.legendColorIndicatorCurY)};this.getXYLegendCoords=function(u,b,z){var r,p,a;var v=-1;var g=-1;var k=this;var n=function(){for(var l=0;l<k.legendLayout.length;l++){if(k.legendLayout[l]){for(var h=0;h<k.legendLayout[l].length;h++){if(k.legendLayout[l][h]==u){return[l,h]}}}}return[-1,-1]};if(this.legendLayout){var m=n();v=m[0];g=m[1];if(v>-1&&g>-1){var o=0;var d=0;if(this.legendPosition.match(/right|left/i)){for(var e=0;e<v;e++){var s=0;for(var c=0;c<this.legendLayout[e].length;c++){s=Math.max(s,this["legend"+this.legendLayout[e][c]+"Width"]+this.margin)}o+=s}for(var c=0;c<this.legendLayout[v].length;c++){d+=this["legend"+this.legendLayout[v][c]+"Height"]+this.margin}}else{for(var e=0;e<v;e++){var f=0;for(var c=0;c<this.legendLayout[e].length;c++){f=Math.max(f,this["legend"+this.legendLayout[e][c]+"Height"]+this.margin)}d+=f}for(var c=0;c<this.legendLayout[v].length;c++){o+=this["legend"+this.legendLayout[v][c]+"Width"]+this.margin}}if(this.graphType=="Circular"){r=b;p=z}else{if(this.graphType=="Network"){r=b+o;p=z;b=g==this.legendLayout[v].length-1?b+o:b;z=p+this["legend"+this.legendLayout[v][g]+"Height"]+this.margin}else{if(this.legendPosition.match(/right|left/i)){z=g==0&&(this.scatterPlotMatrix||this.layoutValid)?this.marginTop+this.layoutTop:g==0?this.marginTop+this.offsetY+this.top:z;r=b+o;a=this.legendPosition.match(/top/)?this.margin:this.legendPosition.match(/bottom/)?this.y-(d+this.margin):((this.y-d)/2);p=g==0&&(this.scatterPlotMatrix||this.layoutValid)?(this.height-d)/2:g==0?this.marginTop+this.offsetY+this.top+a:z;b=g==this.legendLayout[v].length-1?b+o:b;z=p+this["legend"+this.legendLayout[v][g]+"Height"]+this.margin}else{b=g==0&&(this.scatterPlotMatrix||this.layoutValid)?this.marginLeft+this.layoutLeft:g==0?this.marginLeft+this.offsetX+this.left:b;r=g==0&&(this.scatterPlotMatrix||this.layoutValid)?(this.width-o)/2:g==0?this.marginLeft+this.offsetX+this.left+((this.x-o)/2)+this.margin:b+this.margin;p=z+d;b=r+this["legend"+this.legendLayout[v][g]+"Width"]+this.margin;z=g==this.legendLayout[v].length-1?z+d:z}}}}}return[r,p,b,z]};this.getVariableLegendPosition=function(){var c,h;if(this.graphType=="Pie"){if(this.legendPosition=="right"){if(this.isDOE){c=this.marginLeft+this.offsetX+this.left+this.x-(this.margin*3);h=this.marginTop+this.offsetY+this.top+(this.y/2)-(this.legendVariableHeight/2)}else{c=this.width-(this.marginRight+this.legendVariableWidth+this.margin);h=(this.height/2)-(this.legendVariableHeight/2)}}else{c=(this.width/2)-(this.legendVariableWidth/2);h=this.height-(this.marginBottom+this.legendVariableHeight+this.margin)}}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return[0,0]}else{if(this.graphType=="Circular"){c=this.width-(this.marginRight+this.legendVariableWidth+this.margin);h=this.height-(this.marginBottom+this.legendVariableHeight+this.margin);return[c,h]}else{if(this.layoutValid){var d=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var b=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);var j=this.legendVariableHeight+this.legendOverlaysHeight+this.margin;var e=this.legendVariableWidth+this.legendOverlaysWidth+this.margin;c=this.legendPosition=="right"?this.width-(this.marginRight+e):this.marginLeft+this.layoutLeft+(d/2)-(e/2);h=this.legendPosition=="right"?this.marginTop+this.layoutTop+(b/2)-(j/2):this.height-(this.marginBottom+j)}else{var f=this.marginLeft+this.offsetX+this.left;var k=this.marginTop+this.offsetY+this.top;var a=this.legendVariableHeight;var i=this.legendVariableWidth;if(this.legendInside){switch(this.legendPosition){case"bottomRight":c=f+this.x-(i+this.margin);h=k+this.y-(a+this.margin);break;case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y-(a+this.margin);break;case"bottomLeft":c=f+this.margin;h=k+this.y-(a+this.margin);break;case"left":c=f+this.margin;h=k+(this.y/2)-(a/2);break;case"topLeft":c=f+this.margin;h=k+this.margin;break;case"top":c=f+(this.x/2)-(i/2);h=k+this.margin;break;case"topRight":c=f+this.x-(i+this.margin);h=k+this.margin;break;default:c=f+this.x-(i+this.margin);h=k+(this.y/2)-(a/2)}}else{var m=this.overlaysLegendPosition.match(/bottom/i)?this.legendOverlaysHeight:0;var g=this.overlaysLegendPosition.match(/right/i)?this.legendOverlaysWidth:0;switch(this.legendPosition){case"bottom":c=f+(this.x/2)-(i/2);h=k+this.y+this.bottom-(a+m+this.margin);break;default:c=f+this.x+this.right-(i+g+this.margin);h=k+(this.y/2)-(a/2)}}}}}}return[c,h]};this.getScatterLegendPosition=function(){var h=0;var f=0;var e=0;var b=0;var a=0;var g=0;var c=this.marginLeft+this.offsetX+this.left+this.margin;var i=this.marginTop+this.offsetY+this.top+this.margin;if(this.scatterPlotMatrix||this.layoutValid){e=this.width+this.margin-(this.marginRight+(this.legendWidth||0));b=this.height+this.margin-(this.marginBottom+(this.legendHeight||0));h=e-(this.legendDecorationWidth+this.margin);f=b-(this.legendDecorationHeight+this.margin)}else{if(this.graphType=="Network"){if(this.maxX-this.minX>this.maxY-this.minY){e=this.margin;b=this.margin*5}else{e=this.width-(this.legendWidth+this.margin);b=this.margin*5}}else{if(this.graphType=="Circular"){e=this.legendPosition=="top"?this.marginLeft+this.left:this.width-(this.legendVariableWidth+this.right+this.marginRight);b=this.legendPosition=="top"?this.marginTop+this.top:this.height-(this.legendVariableHeight+this.bottom+this.marginBottom)}else{if(this.legendInside){if(this.legendDecorationWidth>0&&this.legendDecorationHeight>0){var d=this.legendDecorationWidth+(this.margin*2);switch(this.decorationsPosition){case"bottomRight":h=c+this.x-d;f=i+this.y-(this.legendDecorationHeight+this.margin);break;case"bottom":h=c+(this.x/2)-(this.legendDecorationWidth/2);f=i+this.y-(this.legendDecorationHeight+this.margin);break;case"bottomLeft":h=c+this.margin;f=i+this.y-(this.legendDecorationHeight+this.margin);break;case"left":h=c+this.margin;f=i+(this.y/2)-(this.legendDecorationHeight/2);break;case"topLeft":h=c+this.margin;f=i+(this.margin*2);break;case"top":h=c+(this.x/2)-(this.legendDecorationWidth/2);f=i+(this.margin*2);break;case"topRight":h=c+this.x-d;f=i+(this.margin*2);break;default:h=c+this.x-d;f=i+(this.y/2)-(this.legendDecorationHeight/2);break}}if(this.legendWidth>0&&this.legendHeight>0){switch(this.legendPosition){case"bottomRight":e=c+this.x-this.legendWidth;b=i+this.y-this.legendHeight;break;case"bottom":e=c+(this.x/2)-(this.legendWidth/2);b=i+this.y-this.legendHeight;break;case"bottomLeft":e=c;b=i+this.y-this.legendHeight;break;case"left":e=c;b=i+(this.y/2)-(this.legendHeight/2);break;case"topLeft":e=c;b=i;break;case"top":e=c+(this.x/2)-(this.legendWidth/2);b=i;break;case"topRight":e=c+this.x-this.legendWidth;b=i;break;default:e=c+this.x-this.legendWidth;b=i+(this.y/2)-(this.legendHeight/2);break}}}else{switch(this.decorationsPosition){case"bottom":h=c+(this.x/2)-(this.legendDecorationWidth/2);f=i+this.y+this.bottom-this.legendDecorationHeight;break;default:h=c+this.x+this.right-(this.legendDecorationWidth+(this.margin*2));f=i+(this.y/2)-(this.legendDecorationHeight/2);break}a=this.legendPosition==this.decorationsPosition?this.legendDecorationWidth:0;g=this.legendPosition==this.decorationsPosition?this.legendDecorationHeight:0;switch(this.legendPosition){case"bottom":e=c+(this.x/2)-(this.legendWidth/2);b=i+this.y+this.bottom-(this.legendHeight+(g?g+this.margin:0));if(this.graphType=="Scatter3D"||this.is3DPlot){b+=this.legendHeight}break;default:e=c+this.x+this.right-(this.legendWidth+a);b=i+(this.y/2)-(this.legendHeight/2);if(this.graphType=="Scatter3D"||this.is3DPlot){e+=this.legendWidth}break}}}}}return[h,f,e,b]};this.drawIndicator=function(a,b,c){delete (this.legendColorIndicatorCurX);delete (this.legendColorIndicatorCurY);this.drawColorIndicator(a,b,false,c)};this.drawLegend=function(a){if(this.graphType=="Venn"){this.drawVennLegend()}else{if(this.graphType=="Circular"){if(this.circularType=="sunburst"){this.drawScatterLegend(a)}else{this.drawOverlaysLegend();var b=this.getVariableLegendPosition();this.drawVariableLegend(b[0],b[1])}}else{if(this.graphType=="Network"){this.drawScatterLegend()}else{if(this.graphType.match(/Scatter/)||this.is3DPlot||((this.colorBy||this.shapeBy||this.sizeBy||this.patternBy)&&this.graphType.match(/^Bar$|Boxplot|Dotplot|Treemap|TagCloud|ParallelCoordinates|Sankey|Tree|Line|Heatmap|Stacked|Map/))){this.drawScatterLegend(a);if(this.isOncoprint){this.drawOncoprintLegend()}this.drawOverlaysLegend()}else{this.draw1DLegend();this.drawOverlaysLegend()}}}}};this.draw1DLegend=function(){this.drawStockIndicatorsLegend();if(this.showLegend&&((this.graphType!="Heatmap")||(this.graphType=="Heatmap"&&(this.colorBy||this.shapeBy||this.sizeBy||this.patternBy)))){if(this.isMultidimensionalData||((this.colorBy||this.shapeBy||this.sizeBy||this.patternBy)&&this.graphType.match(/^Bar$|Boxplot|Dotplot|Treemap|TagCloud|ParallelCoordinates|Sankey|Tree|Line|Heatmap|Stacked/))){if(this.isOncoprint){this.drawOncoprintLegend()}this.drawScatterLegend()}else{if(this.graphType=="Treemap"||this.graphType=="TagCloud"){return}var c=this.getVariableLegendPosition();var a=c[0];var b=c[1];if(this.legendVariableX&&this.legendVariableY){a=this.legendVariableX;b=this.legendVariableY}this.legendVariableCurX=a;this.legendVariableCurY=b;this.drawVariableLegend(a,b)}}else{if(this.isOncoprint){this.drawOncoprintLegend()}}};this.drawOverlaysLegend=function(){var s,e;if(this.overlaysLegendPosition.match(/right/i)){s=this.layoutValid?this.marginTop+this.layoutTop:this.marginTop+this.offsetY+this.top;if(this.overlaysLegendPosition=="right"){s+=(this.y/2)-(this.legendOverlaysHeight/2)}e=this.layoutValid?this.width-(this.marginRight+this.layoutRight+this.legendOverlaysWidth):this.width-(this.marginRight+this.legendOverlaysWidth)}else{s=this.layoutValid?this.height-(this.marginBottom+this.layoutBottom+this.legendOverlaysHeight):this.height-(this.marginBottom+this.legendOverlaysHeight);e=this.layoutValid?this.marginLeft+this.layoutLeft:this.marginLeft+this.offsetX+this.left;if(this.overlaysLegendPosition=="bottom"){e+=(this.x/2)-(this.legendOverlaysWidth/2)}}var v=s;var f=e;for(var k=0;k<this.legendOverlaysLayout.length;k++){var n=this.legendOverlaysLayout[k];var r,b,d,a;var u=mw=0;var p=mh=0;for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];mw=Math.max(u,n[g][2]);mh=Math.max(p,n[g][3])}for(var g=0;g<n.length;g++){r=n[g][0];b=n[g][1];d=this.meta.data[r][b];u=this["legend"+b+"Width"];p=this["legend"+b+"Height"];a=r=="z"?this.varOverlaysLegendColumns:this.smpOverlaysLegendColumns;if(d.type=="String"){this.drawGenericLegend(f,v,u,p,d,b,a)}else{this.drawColorIndicator(f,v,d,b,false,u/2)}if(this.overlaysLegendPosition.match(/right/i)){v+=p+this.margin}else{f+=u+this.margin}}if(this.overlaysLegendPosition.match(/right/i)){f+=mw+this.margin;v=s}else{f=e;v+=mh+this.margin}}};this.drawScatterLegend=function(e){var l=this.getScatterLegendPosition();if(this.showDecorations&&this.showDecorationsLegend&&this.decorations&&!this.scatterPlotMatrix){if(this.legendDecorationX!=null&&this.legendDecorationY!=null){this.drawDecorationLegend(this.legendDecorationX,this.legendDecorationY)}else{this.drawDecorationLegend(l[0],l[1])}}if(this.showLegend){var j=this.graphType=="Network"?["ColorNode","ShapeNode","SizeNode","PatternNode","ColorEdge","SizeEdge"]:this.scatterPlotMatrix?["Color","Shape","Size","Pattern","Variable"]:["Color","Shape","Size","Pattern","Variable","Sample"];var d=l[2];var n=l[3];for(var f=0;f<j.length;f++){var q=this["legend"+j[f]+"Width"];var g=this["legend"+j[f]+"Height"];var p=this["legend"+j[f]+"X"];var k=this["legend"+j[f]+"Y"];if(q>0){if(e){this.setPropertyLegendDimensions(j[f]);q=this["legend"+j[f]+"Width"];g=this["legend"+j[f]+"Height"]}var c=("draw"+j[f]+"Legend").replace("Node","").replace("Edge","");var b=this["legend"+j[f]+"Meta"];var o=this.getXYLegendCoords(j[f],d,n);if(p&&k){this[c](p,k,b,j[f]);this["legend"+j[f]+"CurX"]=p;this["legend"+j[f]+"CurY"]=k}else{this[c](o[0],o[1],b,j[f]);this["legend"+j[f]+"CurX"]=o[0];this["legend"+j[f]+"CurY"]=o[1]}if(this.legendPosition.match(/right|left/i)){n=o[3]+this.margin}else{d=o[2]+this.margin}}}for(var f=0;f<this.legend.length;f++){var a="Custom"+f;var q=this["legend"+a+"Width"];var g=this["legend"+a+"Height"];var p=this["legend"+a+"X"];var k=this["legend"+a+"Y"];var o=this.getXYLegendCoords(a,d,n);if(p&&k){this.drawCustomLegend(p,k,q,g,this.legend[f]);this["legend"+a+"CurX"]=p;this["legend"+a+"CurY"]=k}else{this.drawCustomLegend(o[0],o[1],q,g,this.legend[f]);this["legend"+a+"CurX"]=o[0];this["legend"+a+"CurY"]=o[1]}if(this.legendPosition.match(/right|left/i)){n=o[3]+this.margin}else{d=o[2]+this.margin}}}};this.setMarker=function(f){var j=this;var k=function(q){var p=j.meta.render.objects;for(var m=0;m<p.length;m++){var n=p[m];if(n.type=="Data"&&n.idx){var l=n.idx.join(":");if(l==q||l==q+":false"||l==q+":true"||l==q+":box"){return n}}}return false};var c=function(){if(f.fontSize){return(f.fontStyle||"")+" "+parseInt(f.fontSize)+"px "+j.fontName}else{return j.decorationFont}};var e=this.graphType.match(/Treemap|Stacked/)?true:false;var g=this.isArray(f.variable)?this.getVariableIndices(f.variable):this.getVariableIndices([f.variable]);var h=this.isArray(f.sample)?this.getSampleIndices(f.sample,e):this.getSampleIndices([f.sample],e);var b=g.concat(h).join(":");var a=k(b);var i=a?this.centroidArea(a.area):false;var d=a?a.params[4]:false;if(!f.id){f.id=this.newId(this.target+"-marker-")}f.vi=g;f.si=h;if(!this.isArray(f.variable)){f.variable=[f.variable]}if(!this.isArray(f.sample)){f.sample=[f.sample]}if(!f.type){f.type="line"}f.b=[this.marginLeft+this.offsetX+this.left,this.marginTop+this.offsetY+this.top,this.x,this.y];f.len=this.measureText(f.text,c());f.width=this.measureTextWidth(f.text,c());f.tx=i?i[0]:false;f.ty=i&&f.type!="line"?i[1]-((d/2)+f.width):i?i[1]:false;return f};this.getMarker=function(c){if(c&&this.decorations&&this.decorations.marker){for(var b=0;b<this.decorations.marker.length;b++){var a=this.decorations.marker[b];if(c==a.id){return a}}}};this.drawMarkers=function(){this.functionCaller="drawMarkers";var k=this;var j=function(d,c,h){return d.ty>0&&d.ty<k.height&&d.tx>0&&d.tx<k.width};var b=function(){if(e.fontSize){return(e.fontStyle||"")+" "+parseInt(e.fontSize)+"px "+k.fontName}else{return k.decorationFont}};if(this.decorations&&this.decorations.marker){var l=this.decorations.marker;for(var f=0;f<l.length;f++){var e=this.setMarker(l[f]);if(e.tx&&e.ty&&e.b){var p,o;p=e.x?e.b[0]+(e.x*e.b[2]):this.graphOrientation=="vertical"?e.tx:e.tx+this.margin;o=e.y?e.b[1]+(e.y*e.b[3]):this.graphOrientation=="vertical"?e.ty-this.margin:e.ty;if(j(e,p,o)){var q=this.addToRender(["drawText",e.text,p,o,b(e),e.color||this.decorationsColor,e.align,e.baseline],"Marker:"+e.id);var a=this.meta.render.objects[q].area;if(e.type=="line"){var n=e.color||this.decorationsColor;var g;e.curX=p;e.curY=o;if(e.tx<a[1]-e.len){g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[1]-this.margin,a[2],a[1]-this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[1]-this.margin,g,n],false,q)}else{if(e.tx>a[3]+e.len){g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[3]+this.margin,a[2],a[3]+this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[3]+this.margin,g,n],false,q)}else{if(e.ty>a[4]+(e.width*0.2)){g=(a[1]+a[3])/2;this.addToRender(["drawLine","line",a[1],a[4]+this.margin,a[3],a[4]+this.margin,n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,g,a[4]+this.margin,n],false,q)}else{if(e.ty<a[2]-(e.width*0.2)){g=(a[1]+a[3])/2;this.addToRender(["drawLine","line",a[1],a[2]-this.margin,a[3],a[2]-this.margin,n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,g,a[2]-this.margin,n])}else{if(e.tx<a[1]){g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[1]-this.margin,a[2],a[1]-this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[1]-this.margin,g,n],false,q)}else{g=(a[2]+a[4])/2;this.addToRender(["drawLine","line",a[3]+this.margin,a[2],a[3]+this.margin,a[4],n],false,q);this.addToRender(["drawLine",e.type,e.tx,e.ty,a[3]+this.margin,g,n],false,q)}}}}}}else{e.curX=p;e.curY=o}}}}}}};CanvasXpress.prototype.initFilterUtils=function(){this.filterVariables=function(e,d,a,b){this.filterUserData(["filterVarBy"],["vars"],[d],[a],null,b)};this.filterVariablesByCategory=function(e,d,a,b){this.filterUserData(["filterVarBy"],[e],[d],[a],null,b)};this.filterSamples=function(e,d,a,b){this.filterUserData(["filterSmpBy"],["smps"],[d],[a],null,b)};this.filterSamplesByCategory=function(a,e,b,d){this.filterUserData(["filterSmpBy"],[z],[e],[b],null,d)};this.filterUserData=function(g,f,j,k,a,d){this.functionCaller="filterUserData";if(this.isTransition()){return}if(d){this.resetFilters()}var e={min:">=",max:"<=",like:"like",exact:"exact"};for(var b=0;b<g.length;b++){this[g[b]].push(a!=null&&a[b]!=null?f[b]+":::"+a[b]:f[b]);this[g[b]+"Op"].push(e[j[b]]);this[g[b]+"Case"].push(false);this[g[b]+"Value"].push(k[b])}this.reset(true);this.filterData(true);if(this.isGroupedData&&this.smpIndices.length>0){this.groupSamples(this.groupingFactors,false,false,true)}else{this.draw()}};this.filterData=function(F){if(this.isDOE){return}var q={};var R={};var Q={};var E=false;var o=this;var f=function(v,S,h){if(S.hasOwnProperty(v)){return S[v]}else{if(v.match(":::")){var d=v.split(":::");if(h[d[1]]){d[1]=parseInt(d[1]);for(var s=0;s<h[d[1]].length;s++){var k=h[d[1]][s];if(S.hasOwnProperty(k)){S=S[k]}else{return false}}if(S.hasOwnProperty(d[0])){return S[d[0]]}}}return false}};var G=function(k,v,j,h){if(!v){return true}if(o.filterSkipNullValues&&(k==null||k=="")){return true}if(v==">"){return parseFloat(k)-parseFloat(j)>0}else{if(v==">="){return parseFloat(k)-parseFloat(j)>0||parseFloat(k)-parseFloat(j)==0}else{if(v=="<"){return parseFloat(k)-parseFloat(j)<0}else{if(v=="<="){return parseFloat(k)-parseFloat(j)<0||parseFloat(k)-parseFloat(j)==0}else{if(v=="="||v=="=="){return parseFloat(k)-parseFloat(j)==0}else{if(v=="null"){return k==null}else{if(v=="not null"){return k!=null}else{if(v=="exact"){for(var d=0;d<j.length;d++){if(k.toString()==j[d].toString()){return true}}return false}else{if(v=="like"||v=="not like"){var p=false;if(h){for(var d=0;d<j.length;d++){if((k+"").search(j[d]+"")!=-1||j[d].toString()==k.toString()){p=true;if(v=="like"){break}}}}else{var a=(k+"").toLowerCase();for(var d=0;d<j.length;d++){var s=(j[d]+"").toLowerCase();if(a.search(s)!=-1||a.toString()==s.toString()){p=true;if(v=="like"){break}}}}return v=="like"?p:!p}}}}}}}}}};var g=function(a){if(!Q[a]){Q[a]=0}Q[a]++};if(this.graphType=="Genome"&&this.filterFeatureBy.length>0){for(var J=0;J<this.filterFeatureBy.length;J++){if(this.filterFeatureBy[J]){for(var I=0;I<this.data.tracks.length;I++){var D=this.data.tracks[I];var m=D.data;for(var H=0;H<m.length;H++){var l=m[H];if(this.filterSkipNullKeys&&!l.hasOwnProperty(this.filterFeatureBy[J])){continue}var u=f(this.filterFeatureBy[J],l,this.featuresProperties);if(!G(u,this.filterFeatureByOp[J],this.filterFeatureByValue[J],this.filterFeatureByCase[J])){l.hide=this.filterType=="and"?true:q[I+":"+H]?false:true;R[I+":"+H]=true}else{q[I+":"+H]=true;if(this.filterType=="or"&&R[I+":"+H]){l.hide=false}}}}}}}else{if(this.graphType=="Network"&&(this.filterNodeBy.length>0||this.filterEdgeBy.length)){for(var J=0;J<this.filterNodeBy.length;J++){if(this.filterNodeBy[J]){for(var I=0;I<this.data.nodes.length;I++){if(this.filterSkipNullKeys&&!this.data.nodes[I].hasOwnProperty(this.filterNodeBy[J])){continue}if(this.data.nodes[I].hide){continue}var u=f(this.filterNodeBy[J],this.data.nodes[I],this.nodesProperties);if(!G(u,this.filterNodeByOp[J],this.filterNodeByValue[J],this.filterNodeByCase[J])){this.data.nodes[I].hide=this.filterType=="and"?true:q[this.data.nodes[I].id]?false:true;R[this.data.nodes[I].id]=true}else{q[this.data.nodes[I].id]=true;if(this.filterType=="or"&&R[this.data.nodes[I].id]){this.data.nodes[I].hide=false}}}}}for(var J=0;J<this.filterEdgeBy.length;J++){if(this.filterEdgeBy[J]){for(var I=0;I<this.data.edges.length;I++){var t=this.data.nodes[this.data.nodeIndices[this.data.edges[I].id1]];var r=this.data.nodes[this.data.nodeIndices[this.data.edges[I].id2]];var C=t.id+":"+r.id;if(this.filterSkipNullKeys&&!this.data.edges[I].hasOwnProperty(this.filterEdgeBy[J])){continue}var u=f(this.filterEdgeBy[J],this.data.edges[I],this.edgesProperties);if(!G(u,this.filterEdgeByOp[J],this.filterEdgeByValue[J],this.filterEdgeByCase[J])){this.data.edges[I].hide=this.filterType=="and"?true:q[C]?false:true;R[C]=true}else{q[C]=true;if(this.filterType=="or"&&R[C]){this.data.edges[I].hide=false}}if(!this.data.edges[I].hide){g(t.id);g(r.id)}}}}if(this.filterEdgeBy.length>0){for(var J=0;J<this.data.nodes.length;J++){var n=this.data.nodes[J];if(!Q[n.id]){n.hide=true}}}}else{if(this.isCreateHistogram){if(this.filterVarBy.length>0){var O=this.dataStndBy;var L=this.data.y.histogram;var P=this.data.y.all}}else{if(this.filterSmpBy.length>0){for(var J=0;J<this.filterSmpBy.length;J++){var A=-1;if(this.filterSmpBy[J]){A=this.getSampleIndices(this.filterSmpBy[J]);if(A>=0){E=true;for(var I=0;I<this.varIndices.length;I++){var N=this.varIndices[I];var e=this.data.y.data[N][A];if(!G(e,this.filterSmpByOp[J],this.filterSmpByValue[J],this.filterSmpByCase[J])){this.hiddenVars[N]=this.filterType=="and"?true:q[N]?false:true;R[N]=true}else{q[N]=true;if(this.filterType=="or"&&R[N]){this.hiddenVars[N]=false}}}}else{E=true;if(this.isGroupedData&&!F){for(var I=0;I<this.grpIndices.length;I++){var N=this.grpIndices[I];var e;if(this.filterSmpBy[J]=="smps"){var x=false;for(var H=0;H<this.data.w.grps[N].length;H++){e=this.data.y.smps[this.data.w.grps[N][H]];if(G(e,this.filterSmpByOp[J],this.filterSmpByValue[J],this.filterSmpByCase[J])){x=true;break}}if(!x){this.hiddenGrps[N]=this.filterType=="and"?true:q[N]?false:true;R[N]=true}else{q[N]=true;if(this.filterType=="or"&&R[N]){this.hiddenGrps[N]=false}}}else{e=this.data.w.factors[this.filterSmpBy[J]][N];if(!G(e,this.filterSmpByOp[J],this.filterSmpByValue[J],this.filterSmpByCase[J])){this.hiddenGrps[N]=this.filterType=="and"?true:q[N]?false:true;R[N]=true}else{q[N]=true;if(this.filterType=="or"&&R[N]){this.hiddenGrps[N]=false}}}}}else{for(var I=0;I<this.smpIndices.length;I++){var N=this.smpIndices[I];var e=this.filterSmpBy[J]=="smps"?this.data.y.smps[N]:this.getMetadataValue(N,"x",this.filterSmpBy[J],true);if(!G(e,this.filterSmpByOp[J],this.filterSmpByValue[J],this.filterSmpByCase[J])){this.hiddenSmps[N]=this.filterType=="and"?true:q[N]?false:true;R[N]=true}else{q[N]=true;if(this.filterType=="or"&&R[N]){this.hiddenSmps[N]=false}}}}}}}if(E){var b=[];if(A>=0){for(var J=0;J<this.varIndices.length;J++){var w=this.varIndices[J];if(!this.hiddenVars[w]){b.push(w)}}this.varIndices=b}else{if(this.isGroupedData&&!F){for(var J=0;J<this.grpIndices.length;J++){var w=this.grpIndices[J];if(!this.hiddenGrps[w]){b.push(w)}}this.grpIndices=b}else{for(var J=0;J<this.smpIndices.length;J++){var w=this.smpIndices[J];if(!this.hiddenSmps[w]){b.push(w)}}this.smpIndices=b}}}}if(this.filterVarBy.length>0){var A=-1;for(var J=0;J<this.filterVarBy.length;J++){if(this.filterVarBy[J]){A=this.getVariableIndices(this.filterVarBy[J]);if(A>=0){E=true;for(var I=0;I<this.smpIndices.length;I++){var N=this.smpIndices[I];var e=this.data.y.data[A][N];if(!G(e,this.filterVarByOp[J],this.filterVarByValue[J],this.filterVarByCase[J])){this.hiddenSmps[N]=this.filterType=="and"?true:q[N]?false:true;R[N]=true}else{q[N]=true;if(this.filterType=="or"&&R[N]){this.hiddenSmps[N]=false}}}}else{E=true;for(var I=0;I<this.varIndices.length;I++){var N=this.varIndices[I];var e=this.filterVarBy[J]=="vars"?this.data.y.vars[N]:this.getMetadataValue(N,"z",this.filterVarBy[J]);if(!G(e,this.filterVarByOp[J],this.filterVarByValue[J],this.filterVarByCase[J])){this.hiddenVars[N]=this.filterType=="and"?true:q[N]?false:true;R[N]=true}else{q[N]=true;if(this.filterType=="or"&&R[N]){this.hiddenVars[N]=false}}}}}}if(E){var b=[];if(A>=0){for(var J=0;J<this.smpIndices.length;J++){var w=this.smpIndices[J];if(!this.hiddenSmps[w]){b.push(w)}}this.smpIndices=b}else{for(var J=0;J<this.varIndices.length;J++){var w=this.varIndices[J];if(!this.hiddenVars[w]){b.push(w)}}this.varIndices=b}}}}}}if(this.layoutComb&&this.graphType!="Candlestick"&&!this.graphType.match(/Scatter/)){this.restoreEmptyCompartments();var M=this.getObjectArray(this.varIndices);var K=this.getObjectArray(this.smpIndices);for(var J=0;J<this.data.l.comp.length;J++){var B=this.layoutParams[J];var u=B.startingVarIndices;var y=B.startingSmpIndices;var P=[];if(u){for(var I=0;I<u.length;I++){if(M.hasOwnProperty(u[I])){P.push(u[I])}}B.varIndices=P}P=[];if(y){for(var I=0;I<y.length;I++){if(K.hasOwnProperty(y[I])){P.push(y[I])}}B.smpIndices=P}}}};this.resetSmpFilters=function(a){if(a!=null&&this.filterSmpBy.length>0){this.filterSmpBy.splice(a,1);this.filterSmpByOp.splice(a,1);this.filterSmpByValue.splice(a,1);this.filterSmpByCase.splice(a,1);this.filteredSmpIndices.splice(a,1)}else{this.filterSmpBy=[];this.filterSmpByOp=[];this.filterSmpByValue=[];this.filterSmpByCase=[];this.filteredSmpIndices=[]}};this.resetVarFilters=function(a){if(a!=null&&this.filterVarBy.length>0){this.filterVarBy.splice(a,1);this.filterVarByOp.splice(a,1);this.filterVarByValue.splice(a,1);this.filterVarByCase.splice(a,1);this.filteredVarIndices.splice(a,1)}else{this.filterVarBy=[];this.filterVarByOp=[];this.filterVarByValue=[];this.filterVarByCase=[];this.filteredVarIndices=[]}};this.resetNodeFilters=function(a){if(a!=null&&this.filterNodeBy.length>0){this.filterNodeBy.splice(a,1);this.filterNodeByOp.splice(a,1);this.filterNodeByValue.splice(a,1);this.filterNodeByCase.splice(a,1)}else{this.filterNodeBy=[];this.filterNodeByOp=[];this.filterNodeByValue=[];this.filterNodeByCase=[]}};this.resetEdgeFilters=function(a){if(a!=null&&this.filterEdgeBy.length>0){this.filterEdgeBy.splice(a,1);this.filterEdgeByOp.splice(a,1);this.filterEdgeByValue.splice(a,1);this.filterEdgeByCase.splice(a,1)}else{this.filterEdgeBy=[];this.filterEdgeByOp=[];this.filterEdgeByValue=[];this.filterEdgeByCase=[]}};this.resetFeatureFilters=function(a){if(a!=null&&this.filterFeatureBy.length>0){this.filterFeatureBy.splice(a,1);this.filterFeatureByOp.splice(a,1);this.filterFeatureByValue.splice(a,1);this.filterFeatureByCase.splice(a,1)}else{this.filterFeatureBy=[];this.filterFeatureByOp=[];this.filterFeatureByValue=[];this.filterFeatureByCase=[]}};this.resetFilters=function(e,d){var a=[];if(!e){a=["filterSmpBy","filterVarBy","filterNodeBy","filterEdgeBy","filterFeatureBy"]}else{a=[e]}for(var b=0;b<a.length;b++){c=a[b];if(c=="filterSmpBy"){this.resetSmpFilters(d)}else{if(c=="filterVarBy"){this.resetVarFilters(d)}else{if(c=="filterNodeBy"){this.resetNodeFilters(d)}else{if(c=="filterEdgeBy"){this.resetEdgeFilters(d)}else{if(c=="filterFeatureBy"){this.resetFeatureFilters(d)}}}}}}}};CanvasXpress.prototype.initClusterUtils=function(){this.setDendrograms=function(){if(this.smpDendrogramNewick){this.smpDendrogram={};this.parseNewick(this.smpDendrogramNewick,"smpDendrogram")}if(this.varDendrogramNewick){this.varDendrogram={};this.parseNewick(this.varDendrogramNewick,"varDendrogram")}};this.parseNewick=function(a,d){var j=this;var v=0;var b=[];var s={};var c=0;var f=0;var t=0;var o=0;var h=[];var y=0;var z=0;this[d+"NodeId"]=0;var p=a.split(/\s*(;|\(|\)|,|:)\s*/);var k=function(C){var x=[];for(var B=0;B<C.length;B++){x.push(C[B].mid)}return j.mean(x)};var m=function(B){if(B.children){B.depth=f++;y=Math.max(y,B.depth);for(var x=0;x<B.children.length;x++){m(B.children[x]);if(B.children[x].children){B.children[x].mid=k(B.children[x].children)}}f--;o++}else{B.depth=f;t++}};var e=function(B){if(B.children){for(var x=0;x<B.children.length;x++){e(B.children[x]);if(B.children[x].children){B.children[x].len=1+y-B.children[x].depth}}}else{B.len=1+y-B.depth}};for(var w=0;w<p.length;w++){if(!v){var g=p[w];switch(g){case"(":var A={};s.children=[A];b.push(s);s=A;break;case",":if(b.length>0){var A={};b[b.length-1].children.push(A);s=A}else{v++}break;case")":s=b.pop();s.nodeId=this[d+"NodeId"]++;break;case":":break;default:var l=p[w-1];if(l==")"||l=="("||l==","){s.name=g;if(g&&!s.children){var r=d=="smpDendrogram"?this.getSampleIndices(g):this.getVariableIndices(g);if(r==-1){r=parseInt(g);s.name=d=="smpDendrogram"?this.data.y.smps[r]:this.data.y.vars[r];s.idx=r}else{s.idx=r}h.push(s.idx);s.ord=c++;s.mid=s.ord}}else{if(l==":"){s.height=parseFloat(g);z++}}}}else{if(v<3){this.parseNewick("("+a+")",d);return}else{alert(d+"is not in a valid Newick format");this[d]=false;if(d=="varDendrogram"){this.varDendrogramNewick=false}else{this.smpDendrogramNewick=false}return}}}m(s);e(s);s.max=y+1;s.leafs=t;s.useHeight=z==o;s.mid=k(s.children);s.axis=d;this[d]=s;var q={labl:d=="varDendrogram"?"variable":"sample",show:d=="varDendrogram"?"showVarDendrogram":"showSmpDendrogram",data:d=="varDendrogram"?"vars":"smps",indx:d=="varDendrogram"?"varIndices":"smpIndices",strt:d=="varDendrogram"?"varIndicesStart":"smpIndicesStart"};if(this[q.show]){if(this[q.strt]<0){if(t!=this.data.y[q.data].length){alert("Dude! The length of the "+q.labl+" nodes in the dendrogram ("+t+") is different to that one in the data ("+this.data.y[q.data].length+"). This ain't gonna work!");this[q.show]=false}else{if(t!=this[q.indx].length){alert("Ooops! Cannot show dendrogram with "+t+" nodes when only "+this[q.indx].length+" "+q.labl+" are visible.");this[q.show]=false}else{this[q.indx]=h}}}else{var u=this[q.strt]+this[q.indx].length;this[q.indx]=[];for(var w=this[q.strt];w<u;w++){this[q.indx].push(h[w])}}}};this.writeNewick=function(b){var d="";if(b.children){var a=[];for(var c=0;c<b.children.length;c++){a.push(this.writeNewick(b.children[c]))}if(a.length>0){d="("+a.join(",")+")"}}else{d=b.idx}if(b.height){d+=":"+sprintf("%.1f",b.height)}return d};this.euclidianDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f+=Math.pow(b[c]-a[c],2)}f=Math.sqrt(f)}return f};this.manhattanDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f+=Math.abs(b[c]-a[c])}}return f};this.maxDistance=function(b,a,h,g){var e=this.cleanArrays(b,a,h,g);b=e[0];a=e[1];var f=0;if(b.length==a.length){for(var c=0;c<b.length;c++){f=Math.max(f,Math.abs(b[c]-a[c]))}}return f};this.classifyKmeansVector=function(f,c){var e=Number.POSITIVE_INFINITY;var a=0;for(var d=0;d<c.length;d++){var b=this[this.distance+"Distance"](f,c[d]);if(b<e){e=b;a=d}}return a};this.addVectors=function(c,b,g,f){var e=this.cleanArrays(c,b,g,f);c=e[0];b=e[1];var a=[];if(c.length==b.length){for(var d=0;d<c.length;d++){a.push(c[d]+b[d])}}return a};this.compareVectors=function(b,a){if(this.isArray(b)&&this.isArray(a)){if(b.length!=a.length){return false}for(var c=0;c<b.length;c++){if(this.isArray(b[c])&&this.isArray(a[c])){if(!this.compareArrays(b[c],a[c])){return false}}if(b[c]!==a[c]){return false}}return true}};this.vectorDotProduct=function(b,a,g,f){var d=this.cleanArrays(b,a,g,f);b=d[0];a=d[1];var e=0;if(b.length==a.length){for(var c=0;c<b.length;c++){e+=b[c]*a[c]}}return e};this.multiplyVectorByValue=function(a,d,e,c){a=this.cleanArray(a,e,c);for(var b=0;b<a.length;b++){a[b]*=d}return a};this.getCentroid=function(d,g,f,a){var h=[];if(g.length==a.length){var e=d+f;for(var b=0;b<g.length;b++){h.push((d*g[b]+f*a[b])/e)}}return h};this.createClusterNode=function(i,b,e,f,h,a){var g={id:i,left:b,right:e,dist:f,centroid:h};if(a!=null){g.mid=a}if(b==null&&e==null){g.size=1;g.depth=0}else{g.size=b.size+e.size;g.depth=1+Math.max(b.depth,e.depth)}return g};this.createRandomCentroids=function(c){var b=this;var a=c.slice(0);a.sort(function(){return(Math.round(b.random())-0.5)});return a.slice(0,this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters)};this.createRandomVectors=function(d,g){var c=g.length;if(d>c){return null}var l=[];var f=[];var a={};var m=0;var o=0;var j,b;while(o<d){if(m==c){return null}var h=Math.floor(this.random()*c);if(h in a){continue}a[h]=1;m++;j=g[h];b=true;for(var e=0;e<o;e++){if(this.compareVectors(j,l[e])){b=false;break}}if(b){l[o]=j;f[o]=h;o++}}return{vectors:l,indices:f}};this.imputeDatum=function(a){var d=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];d.push(this.data.y.data[c][a])}}else{for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];d.push(this.data.y.data[a][c])}}return this[this.imputeMethod](d)};this.getIdsForClustering=function(){var e=[];if(this.clusterAxis=="samples"){for(var b=0;b<this.smpIndices.length;b++){var c=this.smpIndices[b];var a=this.getSampleIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}else{for(var b=0;b<this.varIndices.length;b++){var c=this.varIndices[b];var a=this.getVariableIndices(c);e[b]=a==-1?c:this.data.y.smps[c]}}return e};this.getDataForClustering=function(){var h=[];var a=[];if(this.clusterAxis=="samples"){for(var c=0;c<this.smpIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[b]){a[b]=this.imputeDatum(f)}g=a[b]}h[b][c]=g}}}else{for(var c=0;c<this.varIndices.length;c++){h[c]=[]}for(var c=0;c<this.varIndices.length;c++){var e=this.varIndices[c];for(var b=0;b<this.smpIndices.length;b++){var f=this.smpIndices[b];var g=this.data.y.data[e][f];if(isNaN(g)){if(!a[c]){a[c]=this.imputeDatum(e)}g=a[c]}h[c][b]=g}}}return h};this.cluster=function(){var n=function(){var i=a[s][0].id;var d=a[r][0].id;if(i<0&&d>=0){return true}else{if(i<0&&d<0){return d>i}else{if(i>=0&&d>=0){return i>d}else{return false}}}};var h;var z=this.getDataForClustering();var v=this.getIdsForClustering();var o=[];var e=[];var B=[];var a=[];if(!this.meta.tree){this.meta.tree={}}var u=this.meta.tree;u[this.clusterAxis]=[];for(var y=0;y<z.length;y++){o[y]=[]}o[0][0]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length-1;y++){for(var x=y+1;x<z.length;x++){o[x][x]=Number.POSITIVE_INFINITY;o[y][x]=this[this.distance+"Distance"](z[y],z[x]);o[x][y]=o[y][x]}}for(var y=0;y<z.length;y++){e[y]=0;for(var x=0;x<z.length;x++){if(o[y][e[y]]>o[y][x]){e[y]=x}}}for(var y=0;y<z.length;y++){a[y]=[];a[y][0]=this.createClusterNode(v[y],null,null,0,z[y]);B[y]=1}var b=-1;for(var q=0;q<z.length-1;q++){var s=0;for(var y=0;y<z.length;y++){if(o[y][e[y]]<o[s][e[s]]){s=y}}var r=e[s];if(n()){var c=r;r=s;s=c}var f=a[s][0];var t=a[r][0];var g=this.getCentroid(f.size,f.centroid,t.size,t.centroid);var A=this.createClusterNode(b,f,t,o[s][r],g);a[s].splice(0,0,A);for(var x=0;x<z.length;x++){if(this.linkage=="single"){if(o[s][x]>o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="complete"){if(o[s][x]<o[r][x]){o[x][s]=o[s][x]=o[r][x]}}else{if(this.linkage=="average"){o[x][s]=o[s][x]=((B[s]*o[s][x])+(B[r]*o[r][x]))/(B[s]+B[r])}}}}B[s]+=B[r];o[s][s]=Number.POSITIVE_INFINITY;for(var y=0;y<z.length;y++){o[y][r]=o[r][y]=Number.POSITIVE_INFINITY}for(var x=0;x<z.length;x++){if(e[x]==r){e[x]=s}}for(var x=0;x<z.length;x++){for(var w=0;w<z.length;w++){if(o[w][x]<o[w][e[w]]){e[w]=x}}}h=A;u[this.clusterAxis].push([f.id,t.id,h.dist]);b--}return this.writeNewickCluster(h,true)};this.isLeafNode=function(a){if(a.left==null&&a.right==null){return true}else{return false}};this.writeNewickCluster=function(k,g,j){var h="";var e="";var f=false;if(this.isLeafNode(k)){f=true;if(isNaN(k.id)){h=this.clusterAxis=="variables"?this.getVariableIndices(k.id):this.getSampleIndices(k.id)}else{h=k.id}}else{var b;var c=this.writeNewickCluster(k.left,g,true);var a=this.writeNewickCluster(k.right,g,false);if(k.mid){for(var d=0;d<k.mid.length;d++){if(g&&k.mid[d].dist){e+=","+k.mid[d].id+":"+k.mid[d].dist}else{e+=","+k.mid[d].id}e+=k.mid[d].id}}h="("+c+e+","+a+")"}if(g&&!f){h+=":"+sprintf("%.1f",k.dist)}return h};this.kmeans=function(){var p=this.getDataForClustering();var q=this.createRandomCentroids(p);var m=new Array(p.length);var b=this.clusterAxis=="samples"?this.kmeansSmpClusters:this.kmeansVarClusters;var n=new Array(b);var s=0;var v=true;while(v){for(var e=0;e<p.length;e++){m[e]=this.classifyKmeansVector(p[e],q)}v=false;for(var c=0;c<b;c++){var l=[];for(var e=0;e<m.length;e++){if(m[e]==c){l.push(p[e])}}if(!l.length){continue}var o=q[c];var u=new Array(o.length);for(var f=0;f<o.length;f++){var h=0;for(var e=0;e<l.length;e++){if(!isNaN(l[e][f])){h+=l[e][f]}}u[f]=h/l.length;if(u[f]!=o[f]){v=true}}q[c]=u;n[c]=l}s++;if(s>this.maxIterations){v=false}}var r=[];for(var e=0;e<b;e++){r[e]={distance:this[this.distance+"Distance"](q[0],q[e]),assign:e}}r=r.sort(function(g,d){return g.distance-d.distance});var a={};for(var e=0;e<r.length;e++){a[r[e].assign]=e}for(var e=0;e<m.length;e++){var t=a[m[e]]+1;if(t>9){m[e]="K"+t}else{m[e]="K-0"+t}}return m}};CanvasXpress.prototype.initSortUtils=function(){this.sortNetworkIndices=function(h){this.functionCaller="sortNetworkIndices";if(this.isTransition()){return}var g=this.data[this.networkShowDataTable];var c=[h]?h:this.networkShowDataTable=="nodes"?"id":"id1";var b=[];var f=[];for(var e=0;e<g.length;e++){b.push(e);f.push(g[e][c]?g[e][c]:null)}if(this.isNumeric(f)){var a=Number.MAX_VALUE*-1;b.sort(function(j,i){return(f[j]||a)-(f[i]||a)})}else{b.sort(function(j,i){return f[j]>f[i]?1:f[j]<f[i]?-1:0})}var d=[];for(var e=0;e<g.length;e++){d.push(g[b[e]])}if(this.sortDir=="ascending"){d.reverse()}this.data[this.networkShowDataTable]=d;if(this.networkShowDataTable=="nodes"){this.setNodeIndices()}this.draw()};this.sortIndices=function(h,c,k,a,m,j,o){var g=this;var n=this.meta.def;this.tmpAsciiArray=[];this.tmpAsciiArray1=[];this.tmpAsciiArray2=[];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;if(k){k=this.toArray(k)}if(a){a=this.toArray(a)}if(m){m=this.toArray(m)}if(!c){c=this.sortDir}if(h=="onc"){var b=[];for(var f=0;f<this.data.y.vars.length;f++){b.push(f)}this.varIndices=b;this.tmpAsciiArray=this.data.z.Alterations;this.tmpAsciiArray1=this.getDataForSmpGrpAtIndex(this.smpIndices[0]);this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1)}else{if(k&&h=="vars"){if(k.length==1&&this.data.z&&this.data.z[k[0]]){this.tmpAsciiArray=this.data.z[k[0]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray)}else{if(k.length==2&&this.data.z&&this.data.z[k[0]]&&this.data.z[k[1]]){this.tmpAsciiArray=this.data.z[k[0]];this.tmpAsciiArray1=this.data.z[k[1]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1)}else{if(k.length==3&&this.data.z&&this.data.z[k[0]]&&this.data.z[k[1]]&&this.data.z[k[2]]){this.tmpAsciiArray=this.data.z[k[0]];this.tmpAsciiArray1=this.data.z[k[1]];this.tmpAsciiArray2=this.data.z[k[2]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1);this.tmpAsciiArrayAscii2=this.isAsciiArray(this.tmpAsciiArray2)}}}this.smpSort=-1;this.varSort=k}else{if(k&&h=="smps"){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(h,c,k,a,m,j,o);this.isGroupedData=true}if(k.length==1&&this.data.x&&this.data.x[k[0]]){this.tmpAsciiArray=this.isGroupedData?this.data.w.factors[k[0]]:this.data.x[k[0]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray)}else{if(k.length==2&&this.data.x&&this.data.x[k[0]]&&this.data.x[k[1]]){this.tmpAsciiArray=this.isGroupedData?this.data.w.factors[k[0]]:this.data.x[k[0]];this.tmpAsciiArray1=this.isGroupedData?this.data.w.factors[k[1]]:this.data.x[k[1]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1)}else{if(k.length==3&&this.data.x&&this.data.x[k[0]]&&this.data.x[k[1]]&&this.data.x[k[2]]){this.tmpAsciiArray=this.isGroupedData?this.data.w.factors[k[0]]:this.data.x[k[0]];this.tmpAsciiArray1=this.isGroupedData?this.data.w.factors[k[1]]:this.data.x[k[1]];this.tmpAsciiArray2=this.isGroupedData?this.data.w.factors[k[2]]:this.data.x[k[2]];this.tmpAsciiArrayAscii=this.isAsciiArray(this.tmpAsciiArray);this.tmpAsciiArrayAscii1=this.isAsciiArray(this.tmpAsciiArray1);this.tmpAsciiArrayAscii2=this.isAsciiArray(this.tmpAsciiArray2)}}}this.varSort=-1;this.smpSort=k}else{if(j&&o){var f=a?parseInt(this.getVariableIndices(a[0])):parseInt(this.getSampleIndices(m[0]));this.tmpAsciiArray=this.data.y[j][f];this.tmpAsciiArrayAscii=false;this.smpSort=[f]}else{if(a){var d=[];for(var f=0;f<this.varIndices.length;f++){d.push(f)}if(a.length==1){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(a[0]-1,d,j);this.tmpAsciiArrayAscii=false;this.smpSort=[a[0]-1]}else{if(a.length==2){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(a[0]-1,d,j);this.tmpAsciiArray1=this.getDataForSmpGrpAtIndex(a[1]-1,d,j);this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.smpSort=[a[0]-1,a[1]-1]}else{if(a.length==3){this.tmpAsciiArray=this.getDataForSmpGrpAtIndex(a[0]-1,d,j);this.tmpAsciiArray1=this.getDataForSmpGrpAtIndex(a[1]-1,d,j);this.tmpAsciiArray2=this.getDataForSmpGrpAtIndex(a[2]-1,d,j);this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;this.smpSort=[a[0]-1,a[1]-1,a[2]-1]}}}}else{if(m){if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(h,c,k,a,m,j,o);this.isGroupedData=true}var e=this.isGroupedData&&this.summaryType=="iqr"?this.data.w.median:this.isGroupedData?this.data.w[this.summaryType]:j?this.data.y[j]:this.data.y.data;if(m.length==1){this.tmpAsciiArray=e[m[0]-1];this.tmpAsciiArrayAscii=false;this.smpSort=[m[0]-1]}else{if(m.length==2){this.tmpAsciiArray=e[m[0]-1];this.tmpAsciiArray1=e[m[1]-1];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.smpSort=[m[0]-1,m[1]-1]}else{if(a.length==3){this.tmpAsciiArray=e[m[0]-1];this.tmpAsciiArray1=e[m[1]-1];this.tmpAsciiArray2=e[m[2]-1];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;this.smpSort=[m[0]-1,m[1]-1,m[2]-1]}}}}else{if(this.isGroupedData){this.isGroupedData=false;this.sortIndices(h,c,k,a,m,j,o);this.isGroupedData=true}this.tmpAsciiArray=this.isGroupedData?this.data.w.smps:h=="vars"?this.data.y.vars:this.data.y.smps;this.tmpAsciiArrayAscii=true;if(h=="vars"){this.varSort=false}else{this.smpSort=false}}}}}}}var l=h=="vars"||h=="onc"?this.varIndices:this.isGroupedData?this.grpIndices:this.smpIndices;if(this.tmpAsciiArrayAscii){l.sort(function(p,i){return g.sortAsciibetically(p,i)})}else{l.sort(function(p,i){return g.sortNumerically(p,i)})}if(c!="ascending"){l.reverse()}this.tmpAsciiArray=[];this.tmpAsciiArray1=[];this.tmpAsciiArray2=[];this.tmpAsciiArrayAscii=false;this.tmpAsciiArrayAscii1=false;this.tmpAsciiArrayAscii2=false;if(h=="smps"){this.sortingSampleCategories=k}else{this.sortingVariableCategories=k}this.sortingSamples=a;this.sortingVariables=m;if(!n.sort){n.sort={}}if(this.isGroupedData&&h=="smps"){n.sort.grps=l}else{n.sort[h]=l}};this.isAsciiArray=function(a){return !this.isNumeric(a)};this.sortAsciibetically=function(d,c){var e=this;if(this.tmpAsciiArray[d]==this.tmpAsciiArray[c]&&this.tmpAsciiArray1.length>0){if(this.tmpAsciiArrayAscii1){return e.sortAsciibetically1(d,c)}else{return e.sortNumerically1(d,c)}}else{return((this.tmpAsciiArray[d]>this.tmpAsciiArray[c])?1:(this.tmpAsciiArray[d]<this.tmpAsciiArray[c])?-1:0)}};this.sortAsciibetically1=function(d,c){var e=this;if(this.tmpAsciiArray1[d]==this.tmpAsciiArray1[c]&&this.tmpAsciiArray2.length>0){if(this.tmpAsciiArrayAscii2){return e.sortAsciibetically2(d,c)}else{return e.sortNumerically2(d,c)}}else{return((this.tmpAsciiArray1[d]>this.tmpAsciiArray1[c])?1:(this.tmpAsciiArray1[d]<this.tmpAsciiArray1[c])?-1:0)}};this.sortAsciibetically2=function(d,c){return((this.tmpAsciiArray2[d]>this.tmpAsciiArray2[c])?1:(this.tmpAsciiArray2[d]<this.tmpAsciiArray2[c])?-1:0)};this.sortNumerically=function(e,d){var f=this;var c=Number.MAX_VALUE*-1;if((this.tmpAsciiArray[e]||c)-(this.tmpAsciiArray[d]||c)==0&&this.tmpAsciiArray1.length>0){if(this.tmpAsciiArrayAscii1){return f.sortAsciibetically1(e,d)}else{return f.sortNumerically1(e,d)}}else{return(this.tmpAsciiArray[e]||c)-(this.tmpAsciiArray[d]||c)}};this.sortNumerically1=function(e,d){var f=this;var c=Number.MAX_VALUE*-1;if((this.tmpAsciiArray1[e]||c)-(this.tmpAsciiArray1[d]||c)==0&&this.tmpAsciiArray2.length>0){if(this.tmpAsciiArrayAscii2){return f.sortAsciibetically2(e,d)}else{return f.sortNumerically2(e,d)}}else{return(this.tmpAsciiArray1[e]||c)-(this.tmpAsciiArray1[d]||c)}};this.sortNumerically2=function(e,d){var c=Number.MAX_VALUE*-1;return(this.tmpAsciiArray2[e]||c)-(this.tmpAsciiArray2[d]||c)};this.sortArray=function(a,b){var d=[];if(a.length!=b.length){return a}for(var c=0;c<a.length;c++){if(a[b[c]]){d[c]=a[b[c]]}else{return a}}return d};this.sortObject=function(b){var a=Object.keys(b);if(this.isAsciiArray(a)){if(this.sortCaseSensitive){return a.sort()}else{return a.sort(function(d,c){return d.toLowerCase().localeCompare(c.toLowerCase())})}}else{return a.sort(function(d,c){return d-c})}};this.stringRangeSort=function(d){var c={};var a;for(var b=0;b<d.length;b++){if(d[b].match(/^\d+\-\d+/)){a=d[b].split(/\-/);c[b]=Number(a[0])}else{if(d[b].match(/^\>\d+/)){a=d[b].split(/\>/);c[b]=Number(a[1])+1e-8}else{if(d[b].match(/^\<\d+/)){a=d[b].split(/\</);c[b]=Number(a[1])-1e-8}else{if(d[b].match(/^\d+/)){a=d[b];c[b]=a}else{return d.sort()}}}}}d.sort(function(f,e){c[f]-c[e]});return d};this.radixSort=function(n){var h=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];var e=new Int32Array(n.length);var f=[].concat(h);var g=[].concat(h);var j=[].concat(h);var l=[].concat(h);var a=0;var i;var b=0;var k;var c=0;var m;var d=0;var o;var p;for(p=0;p<n.length;p++){i=n[p]&255;k=(n[p]>>8)&255;m=(n[p]>>16)&255;o=(n[p]>>24)&255^128;f[i]++;g[k]++;j[m]++;l[o]++}for(p=0;p<256;p++){i=a+f[p];k=b+g[p];m=c+j[p];o=d+l[p];f[p]=a;g[p]=b;j[p]=c;l[p]=d;a=i;b=k;c=m;d=o}for(p=0;p<n.length;p++){i=n[p]&255;e[f[i]]=n[p];f[i]++}for(p=0;p<n.length;p++){k=(e[p]>>8)&255;n[g[k]]=e[p];g[k]++}for(p=0;p<n.length;p++){m=(n[p]>>16)&255;e[j[m]]=n[p];j[m]++}for(p=0;p<n.length;p++){o=(e[p]>>24)&255^128;n[l[o]]=e[p];l[o]++}return n}};CanvasXpress.prototype.initMathUtils=function(){this.isNaN=function(a){return isNaN(a)?true:a==Number.POSITIVE_INFINITY?true:a==Number.NEGATIVE_INFINITY?true:false};this.isFinite=function(a){if(this.isArray(a)){for(var b=0;b<a.length;b++){if(!isFinite(a[b])){return false}}return true}else{return isFinite(a)}};this.triCube=function(a){return(a=1-a*a*a)*a*a};this.degreesToArcLength=function(b,a){return b*a};this.radiansToArcLength=function(a,b){return(a*Math.PI*b)/180};this.arcLengthToDegrees=function(b,a){return(a*180)/(b*Math.PI)};this.arcLengthToRadians=function(b,a){return a/b};this.radians=function(a){return a*Math.PI/180};this.getAngle=function(e,g,c,f,d){var b=(Math.atan2(f-g,c-e)*180/Math.PI)%360;if(!d){d=0}while(b<d){b+=360}while(b>=(d+360)){b-=360}return b};this.getRadians=function(e,g,c,f,d){var b=Math.atan2(f-g,c-e);if(b<0){b+=(2*Math.PI)}return b};this.rotatePoint=function(c,h,b,g,d){var f=Math.cos(d)*(c-b)-Math.sin(d)*(h-g)+b;var e=Math.sin(d)*(c-b)+Math.cos(d)*(h-g)+g;return[f,e]};this.lineLength=function(b,d,a,c){return Math.sqrt(Math.pow(a-b,2)+Math.pow(c-d,2))};this.lineMidPoint=function(b,d,a,c){return[(b+a)/2,(d+c)/2]};this.parallelLinePoints=function(r,d,p,b,n){var i=p-r;var h=b-d;var o=this.lineLength(r,d,p,b);var u=i/o;var t=h/o;var s=-t;var q=u;var c=r+n*s;var f=d+n*q;var a=r-n*s;var e=d-n*q;var j=p+n*s;var m=b+n*q;var g=p-n*s;var k=b-n*q;return[c,f,a,e,j,m,g,k]};this.shortenLine=function(b,j,a,i,k,f,l){if(this.isNumeric([b,j,a,i,k,f])){if(l.match(/bezier/i)){if(l.match(/beziery/i)){return i>j?[b,j+k,a,i-f]:[b,j-k,a,i+f]}else{return a>b?[b+k,j,a-f,i]:[b-k,j,a+f,i]}}else{if(l.match(/curved/i)){return[b,j,a,i]}else{var c=Math.atan2(i-j,a-b);var d=Math.cos(c);var h=Math.sin(c);var g=this.lineLength(b,j,a,i);if(g){while(g<(k+f)){k/=1.1;f/=1.1}b+=d*k;j+=h*k;a-=d*f;i-=h*f}}}return[b,j,a,i]}};this.traceArc=function(c,b,a,m,h,d){if(m>h){var k=m;m=h;h=k}var l=[];var g=Math.PI;var i=h-m;var f=i<g/16?0:i<g/8?4:i<g/4?8:i<g?16:32;var j=i/f;l.push([a*Math.cos(m)+c,a*Math.sin(m)+b]);m+=j;while(m<h){l.push([a*Math.cos(m)+c,a*Math.sin(m)+b]);m+=j}l.push([a*Math.cos(h)+c,a*Math.sin(h)+b]);return d?l:l.reverse()};this.traceQuadraticCurve=function(l,k,e,c,j,h,b,f){var m=[];var a=function(i,q,p,o){var n=1-i;return n*n*q+2*n*i*p+i*i*o};var d=function(i){return[a(i,l,e,j),a(i,k,c,h)]};for(var g=0;g<=1;g+=b){m.push(d(g))}return f?m:m.reverse()};this.traceBezierCurve=function(j,h,c,b,l,k,g,f,a,d){var m=[];for(var e=0;e<=1;e+=a){m.push(this.deCasteljau([[j,h],[c,b],[l,k],[g,f]],e))}return d?m:m.reverse()};this.splineControlPoint=function(e,m,d,l,c,k){var n=Math.sqrt(Math.pow(d-e,2)+Math.pow(l-m,2));var h=Math.sqrt(Math.pow(c-d,2)+Math.pow(k-l,2));var g=this.tension*n/(n+h);var f=this.tension-g;var b=d+g*(e-c);var a=l+g*(m-k);var j=d-f*(e-c);var i=l-f*(m-k);return[b,a,j,i]};this.curvePoints=function(v,k){var a=[];var w=[];var f=this.tension;var g=this.tensionSegments;k=k?k:false;a=v.slice(0);if(k){a.unshift(v[v.length-1]);a.unshift(v[v.length-2]);a.unshift(v[v.length-1]);a.unshift(v[v.length-2]);a.push(v[0]);a.push(v[1])}else{a.unshift(v[1]);a.unshift(v[0]);a.push(v[v.length-2]);a.push(v[v.length-1])}var e,d,c,n,b,l,p,o,m,h,q;for(var u=2;u<(a.length-4);u+=2){for(var r=0;r<=g;r++){c=(a[u+2]-a[u-2])*f;n=(a[u+4]-a[u])*f;b=(a[u+3]-a[u-1])*f;l=(a[u+5]-a[u+1])*f;q=r/g;p=2*Math.pow(q,3)-3*Math.pow(q,2)+1;o=-(2*Math.pow(q,3))+3*Math.pow(q,2);m=Math.pow(q,3)-2*Math.pow(q,2)+q;h=Math.pow(q,3)-Math.pow(q,2);e=p*a[u]+o*a[u+2]+m*c+h*n;d=p*a[u+1]+o*a[u+3]+m*b+h*l;w.push(e);w.push(d)}}return w};this.hullControlPoints=function(f){var c=this;var f;var e=[];var g=0;var b,a;var d=function(p,n,m){var l=function(r,q){var t=q[0]-r[0];var s=q[1]-r[1];return Math.sqrt(t*t+s*s)};var o=l(p,n);var k=l(n,m);var h=c.tension*o/(o+k);var j=[((p[0]-m[0])*h)+n[0],((p[1]-m[1])*h)+n[1]];var i=[n[0]-((p[0]-m[0])*h),(n[1]-(p[1]-m[1])*h)];return[j,i]};for(b=0;b<f.length-2;b++){e.push.apply(e,d(f[b],f[b+1],f[b+2]))}e.push.apply(e,d(f[b],f[b+1],f[0]));e.push.apply(e,d(f[b+1],f[0],f[1]));return e};this.expandPolygon=function(o,w){var b=function(i){var d=Math.sqrt(i.x*i.x+i.y*i.y);return{x:i.x/d,y:i.y/d}};var s=function(d,i){return{x:d.x*i,y:d.y*i}};var l=function(i,d){return i.x*d.x+i.y*d.y};var c=function(d){return{x:d.y,y:-d.x}};var x=function(d){return{x:-d.y,y:d.x}};var v=function(F,E){var i=F[1].x-F[0].x;var D=E[0].x-E[1].x;var B=E[0].x-F[0].x;var d=F[1].y-F[0].y;var C=E[0].y-E[1].y;var p=E[0].y-F[0].y;var G=(D*p-C*B)/(d*D-i*C);return{x:F[0].x+G*(F[1].x-F[0].x),y:F[0].y+G*(F[1].y-F[0].y)}};var z=function(d){return l(c({x:d[1].x-d[0].x,y:d[1].y-d[0].y}),{x:d[2].x-d[1].x,y:d[2].y-d[1].y})>=0};var t=[];var g=z(o)?x:c;for(var u=0;u<o.length;++u){var k=o[(u>0)?u-1:o.length-1];var h=o[u];var f=o[(u<o.length-1)?u+1:0];var m={x:h[0]-k[0],y:h[1]-k[1]};var y={x:f[0]-h[0],y:f[1]-h[1]};var n=s(b(g(m)),w);var A=s(b(g(y)),w);var r={x:k[0]+n.x,y:k[1]+n.y};var j={x:h[0]+n.x,y:h[1]+n.y};var e={x:h[0]+A.x,y:h[1]+A.y};var q={x:f[0]+A.x,y:f[1]+A.y};var a=v([r,j],[e,q]);t.push([a.x,a.y])}return t};this.enlargePolygon=function(r,y,q){var f=function(i,e,d){return((d.x-i.x)*(e.y-i.y))-((e.x-i.x)*(d.y-i.y))};var z=function(p,s){var e=p.vrs[s];var d=p.vrs[(s+1)%p.vrs.length];var i=p.vrs[(s+p.vrs.length-1)%p.vrs.length];return(f(i,d,e)<0)?true:false};var h=function(s){var i=s.v2.x-s.v1.x;var d=s.v2.y-s.v1.y;var p=Math.sqrt(i*i+d*d);return{x:-d/p,y:i/p}};var o=function(d){var i=h(d);return{x:-i.x,y:-i.y}};var b=function(J){var p={vrs:J};var I=[];var D=(J.length>0)?J[0].x:undefined;var v=(J.length>0)?J[0].y:undefined;var s=D;var d=v;for(var E=0;E<p.vrs.length;E++){J[E].label=String(E);J[E].isReflex=z(p,E);var F={v1:J[E],v2:J[(E+1)%J.length],pol:p,index:E};F.outwardNormal=o(F);F.inwardNormal=h(F);I.push(F);var H=J[E].x;var G=J[E].y;D=Math.min(H,D);v=Math.min(G,v);s=Math.max(H,s);d=Math.max(G,d)}p.edges=I;p.minX=D;p.minY=v;p.maxX=s;p.maxY=d;p.closed=true;return p};var l=function(p,i,d){return{v1:{x:p.v1.x+i,y:p.v1.y+d},v2:{x:p.v2.x+i,y:p.v2.y+d}}};var C=function(p,e){var s=(e.v2.y-e.v1.y)*(p.v2.x-p.v1.x)-(e.v2.x-e.v1.x)*(p.v2.y-p.v1.y);if(s==0){return null}var i=((e.v2.x-e.v1.x)*(p.v1.y-e.v1.y)-(e.v2.y-e.v1.y)*(p.v1.x-e.v1.x))/s;var d=((p.v2.x-p.v1.x)*(p.v1.y-e.v1.y)-(p.v2.y-p.v1.y)*(p.v1.x-e.v1.x))/s;if(i<0||d<0||i>1||d>1){return null}return{x:p.v1.x+i*(p.v2.x-p.v1.x),y:p.v1.y+i*(p.v2.y-p.v1.y)}};var c=function(L,E,d,K,F,s){var J=Math.PI*2;var H=Math.atan2(K.y-E.y,K.x-E.x);var D=Math.atan2(F.y-E.y,F.x-E.x);if(H<0){H+=J}if(D<0){D+=J}var G=((H>D)?(H-D):(H+J-D));var e=((s)?-G:J-G)/q;L.push(K);for(var p=1;p<q;++p){var G=H+e*p;var I={x:E.x+Math.cos(G)*d,y:E.y+Math.sin(G)*d};L.push(I)}L.push(F)};var t=[];var u=[];for(var w=0;w<r.length;w++){u.push({x:r[w][0],y:r[w][1]})}var j=b(u);for(var w=0;w<j.edges.length;w++){var x=j.edges[w];var n=x.outwardNormal.x*y;var k=x.outwardNormal.y*y;t.push(l(x,n,k))}u=[];for(var w=0;w<t.length;w++){var g=t[w];var B=t[(w+t.length-1)%t.length];var m=C(B,g);if(m){u.push(m)}else{var A=j.edges[w].v1;c(u,A,y,B.v2,g.v1,false)}}var a=[];for(var w=0;w<u.length;w++){a.push([u[w].x,u[w].y])}return a};this.sample=function(c,g){if(c){if(!g||g<=0){g=c.length}var e,b;var f=c.slice(0);var d=c.length;var a=d-g;while(d-->a){b=Math.floor((d+1)*this.random());e=f[b];f[b]=f[d];f[d]=e}return f.slice(a)}else{return[]}};this.seq=function(e,b,d,a){var c=[];if(a||d){if(a){d=(b-e)/(Math.abs(a)-1)}else{if(b<e){d=-d}}if(d){while(d>0?b>=e:b<=e){c.push(e);e+=d}}}return c};this.rnorm=function(h,b,d){var g=this;var c=[];if(b==null){b=0}if(d==null){d=1}var f=function(){var j,i;var a=2;while(a>1){j=g.random()*2-1;i=g.random()*2-1;a=j*j+i*i}return b+d*j*Math.sqrt(-2*Math.log(a)/a)};for(var e=0;e<h;e++){c.push(f())}return c};this.percentile2=function(a,f){if(a.length===0){return 0}if(typeof f!=="number"){throw new TypeError("p must be a number")}if(f<=0){return a[0]}if(f>=1){return a[a.length-1]}var c=a.length*f;var b=Math.floor(c);var d=b+1;var e=c%1;if(d>=a.length){return a[b]}else{return a[b]*(1-e)+a[d]*e}};this.percentRank=function(a,c){if(typeof c!=="number"){throw new TypeError("v must be a number")}for(var d=0,b=a.length;d<b;d++){if(c<=a[d]){while(d<b&&c===a[d]){d++}if(d===0){return 0}if(c!==a[d-1]){d+=(c-a[d-1])/(a[d]-a[d-1])}return d/b}}return 1};this.percentile=function(d,a,e){var b=a-d;if(b==0){return 50}var c=e-d;return c*100/b};this.rank=function(a){var c=[];for(var b=0;b<a.length;b++){c.push(b)}c.sort(function(e,d){return a[e]-a[d]});return c};this.rank2=function(b){var d=b.slice().sort(function(g,f){return g-f});var e=b.slice().map(function(f){return d.indexOf(f)+1});var c={};e.map(function(f){c[f]=c[f]?c[f]++:1});var a=e.map(function(f){return f/c[f]});return a};this.min=function(b,a,e){if(this.isArray(b)){b=this.cleanArray(b,a,e);var d=Number.POSITIVE_INFINITY;for(var c=0;c<b.length;c++){d=Math.min(d,b[c])}return d}else{return this.Min(b,a)}};this.max=function(c,b,e){if(this.isArray(c)){c=this.cleanArray(c,b,e);var a=Number.NEGATIVE_INFINITY;for(var d=0;d<c.length;d++){a=Math.max(a,c[d])}return a}else{return this.Max(c,b)}};this.sum=function(b,a,g,e,f){b=this.cleanArray(b,a,g);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]}}else{if(f){if(b[c]<0){d+=b[c]}}else{d+=b[c]}}}return d};this.sumSquared=function(b,a,f,e){b=this.cleanArray(b,a,f);var d=0;for(var c=0;c<b.length;c++){if(e){if(b[c]>0){d+=b[c]*b[c]}}else{d+=b[c]*b[c]}}return d};this.sumSquaredError=function(b,a,g){b=this.cleanArray(b,a,g);var c=this.mean(b);var f=0;for(var e=0;e<b.length;e++){var d=b[e]-c;f+=d*d}return f};this.mean=function(b,a,e){b=this.cleanArray(b,a,e);var c=0;var f=0;for(var d=0;d<b.length;d++){if(!this.isNaN(b[d])){c+=Number(b[d]);f++}}if(f>0){c/=f}return c};this.range=function(c,b,f){c=this.cleanArray(c,b,f);var e=Number.MAX_VALUE;var a=Number.MAX_VALUE*-1;for(var d=0;d<c.length;d++){e=Math.min(c[d],e);a=Math.max(c[d],a)}return e==a&&e==0?[0,0.1]:e==a?[Number(e),Number(a)]:[Number(e),Number(a)]};this.median=function(b,a,f){b=this.cleanArray(b,a,f);var e=[];var d=[];var g=0;e[0]=Number.NaN;e[1]=Number.NaN;for(var c=0;c<b.length;c++){d.push(b[c]);g++}if(g>0){e[1]=g;d.sort(function(i,h){return i-h});if(g%2){e[0]=d[parseInt(g/2)]}else{e[0]=(d[parseInt((g-1)/2)]+d[g/2])/2}}return e};this.Abs=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(Math.abs(b[c]))}return d};this.square=function(b,a,e){b=this.cleanArray(b,a,e);var d=[];for(var c=0;c<b.length;c++){d.push(b[c]*b[c])}return d};this.subtractArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]-e)}return b};this.addArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(c[d]+e)}return b};this.replaceArray=function(c,e){var b=[];for(var d=0;d<c.length;d++){b.push(e)}return b};this.random=function(){this.pseudoRandom=false;if(this.pseudoRandom){this.randomSeed=(this.randomSeed*9301+49297)%233280;return this.randomSeed/233280}else{return Math.random()}};this.randomBetween=function(b,a){return(this.random()*(a-b+1))+b};this.randomInt=function(){return parseInt(this.random())};this.randomIntBetween=function(b,a){return Math.floor(this.random()*(a-b+1))+b};this.sumarizeErrorData=function(b,a,c){if(this.errorBarsType=="standardErrorMean"){return this.meanStandardErrorN(b,a,c)}else{if(this.errorBarsType=="confidenceInterval95"){return this.mean95ConfidenceIntervalN(b,a,c)}else{return this.meanStandardDeviationN(b,a,c)}}};this.meanStandardErrorN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[NaN,NaN,NaN]}return[c[0],Math.sqrt(c[1])/Math.sqrt(c[2]),c[2]]};this.mean95ConfidenceIntervalN=function(b,a,d){var c=this.meanStandardErrorN(b,a,d,true);if(this.isNaN(c[1])){return[NaN,NaN,NaN]}return[c[0],c[1]*1.96,c[2]]};this.meanStandardDeviationN=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return[NaN,NaN,NaN]}return[c[0],Math.sqrt(c[1]),c[2]]};this.quantile=function(b,a){if(a<b[0]){return 0}else{if(a>=b[0]&&a<b[1]){return 1}else{if(a>=b[1]&&a<b[2]){return 2}else{if(a>=b[2]){return 3}}}}};this.quantiles=function(k,l,f){var o=[];var g=[];var c=k.length;if(c>3){var p=Math.floor(c*0.25);var j=Math.floor(c*0.5);var b=Math.floor(c*0.75);k.sort(function(n,i){return n-i});var a;var s;var q;var r=this.mean(k);if(c%2){s=k[j]}else{s=this.mean([k[j-1],k[j]])}if((c/2)%2){a=k[p];q=k[b]}else{a=this.mean([k[p-1],k[p]]);q=this.mean([k[b-1],k[b]])}var m=(q-a)*1.5;var e,d;for(var h=0;h<=p;h++){if(k[h]<a-m){g.push(k[h])}else{e=k[h];break}}for(var h=c-1;h>=b;h--){if(k[h]>q+m){g.push(k[h])}else{d=k[h];break}}o.push(r);o.push(a);o.push(s);o.push(q);o.push(e);o.push(d);o.push(g);o.push(c)}else{if(c>2){k.sort(function(n,i){return n-i});var r=this.mean(k);o.push(r);o.push((k[0]+k[1])/2);o.push(k[1]);o.push((k[1]+k[2])/2);o.push(k[0]);o.push(k[2]);o.push(g);o.push(c)}else{if(c>1){k.sort(function(n,i){return n-i});var r=this.mean(k);o.push(r);o.push((k[0]+r)/2);o.push(r);o.push((r+k[1])/2);o.push(k[0]);o.push(k[1]);o.push(g);o.push(c)}else{if(c>0){o.push(k[0]);o.push(k[0]);o.push(k[0]);o.push(k[0]);o.push(k[0]);o.push(k[0]);o.push(g);o.push(c)}else{o.push(NaN);o.push(NaN);o.push(NaN);o.push(NaN);o.push(NaN);o.push(NaN);o.push(NaN)}}}}return o};this.quants=function(c,b,e,d){c=this.cleanArray(c,b,e);c=c.slice().sort(function(h,g){return h-g});var f=c.length-1;var a=d||[0.25,0.5,0.75];return a.map(function(l){if(l===0){return c[0]}else{if(l===1){return c[f]}else{var i=1+l*f;var k=Math.floor(i);var j=i-k;var g=c[k-1];return j===0?g:g+j*(c[k]-g)}}})};this.medianByQuantile=function(b,a,c){return this.quants(b,a,c,[0.5])};this.iqr=function(b,a,d){var c=this.quants(b,a,d);return c[2]-c[0]};this.variance=function(e,f,c,a){e=this.cleanArray(e,f,c);var b=e.length;if(b<1){return a?[NaN,NaN,NaN]:NaN}else{if(b==1){return a?[e[0],0,1]:0}else{var j=this.mean(e);var h=0;var d=b;while(--d>=0){if(!this.isNaN(e[d])){var g=e[d]-j;h+=g*g}}if(a){return this.standardDeviationType=="unbiased"?[j,h/(b-1),b]:[j,h/b,b]}else{return this.standardDeviationType=="unbiased"?h/(b-1):h/b}}}};this.deviation=function(b,a,f){b=this.cleanArray(b,a,f);var g=b.length;if(g<1){return[NaN]}else{if(g==1){return[0]}else{var c=this.mean(b);var d=[];for(var e=0;e<g;e++){if(!this.isNaN(b[e])){d[e]=b[e]-c}else{d[e]=NaN}}return d}}};this.standardDeviation=function(b,a,d){var c=this.variance(b,a,d);if(this.isNaN(c)){return c}return Math.sqrt(c)};this.standardError=function(b,a,d){var c=this.variance(b,a,d,true);if(this.isNaN(c[1])){return c[1]}return Math.sqrt(c[1])/Math.sqrt(c[2])};this.meanSquaredError=function(b,a,c){b=this.cleanArray(b,a,c);return this.sumSquaredError(this.sumSquaredError(b,a,c))/b.length};this.confidenceInterval95=function(c,b,d){var a=this.standardError(c,b,d);if(this.isNaN(a)){return a}return a*1.96};this.covariance=function(h,g,e,c){var f=this.cleanArrays(h,g,e,c);h=f[0];g=f[1];var l=0;var a=[];var b=0;var k=this.mean(h);var j=this.mean(g);for(var d=0;d<h.length;d++){a[d]=(h[d]-k)*(g[d]-j);l+=a[d];b++}if(b>0){return l/(this.standardDeviationType=="unbiased"?b-1:b)}else{return NaN}};this.correlation=function(c,b,a,e,d){if(d&&d=="spearman"){return this.correlationSpearman(c,b,a,e)}else{return this.correlationPearson(c,b,a,e)}};this.correlationSpearman=function(m,l,h,f){var k=this.cleanArrays(m,l,h,f);m=k[0];l=k[1];var a=m.length;var b=0;var e=this.rank2(m);var c=this.rank2(l);for(var g=0;g<m.length;g++){var j=e[g]-c[g];b+=j*j}return 1-(6*b/(a*(a*a-1)))};this.correlationPearson=function(c,b,a,d){return this.covariance(c,b,a,d)/this.standardDeviation(c,a,d)/this.standardDeviation(b,a,d)};this.regression=function(f,e,g,c,t,z){var k=this;var m=function(){if(!t){t=k.min(f)}if(!z){z=k.max(f)}var n=(z-t)/10;var E=[];for(var D=0;D<11;D++){E.push(t+(D*n))}return E};var u=this.cleanArrays(f,e,g,c);f=u[0];e=u[1];var s=0;var r=0;var q=0;var B=0;var l=0;var w=0;var b=0;var o=0;var j=0;var v=0;var y=0;var d=0;var h=0;var a=m();var p=[];for(var x=0;x<f.length;x++){if(!this.isNaN(f[x])&&!this.isNaN(e[x])){r+=f[x];q+=e[x];B+=f[x]*e[x];l+=f[x]*f[x];w+=e[x]*e[x];s++}}if(s>2){o=(s*B-r*q)/(s*l-r*r);j=(q-o*r)/s;b=(B-(r*q/s))/Math.sqrt((l-Math.pow(r,2)/s)*(w-Math.pow(q,2)/s));d=r/s;h=this.tinv(0.05,s-2,true);for(var x=0;x<f.length;x++){if(!this.isNaN(f[x])&&!this.isNaN(e[x])){v+=Math.pow(e[x]-((f[x]*o)+j),2);y+=Math.pow(f[x]-d,2)}}v=Math.sqrt(v/(s-2));for(var x=0;x<a.length;x++){var C=-h*v*Math.sqrt((1/s)+Math.pow(a[x]-d,2)/y);var A=o*a[x]+j;p.push([a[x],A+C,A-C,C])}}return[o,j,b,p]};this.confidenceIntervalRegression=function(){};this.slope=function(b,d,a,c){return d!=c?(a-b)/(c-d):0};this.intercept=function(a,c,b){return c-(a*b)};this.slopeIntercept=function(b,e,a,d){var c=this.slope(b,e,a,d);return[c,this.intercept(b,e,c)]};this.normalize=function(f){var e=this.standardDeviationType;this.standardDeviationType="biased";for(var c=0;c<f.length;c++){var a=this.meanStandardDeviationN(f[c]);for(var b=0;b<f[c].length;b++){f[c][b]=(f[c][b]-a[0])/a[1]}}this.standardDeviationType=e;return f};this.checkLoessCache=function(b){var a=this.meta;if(!a.vals.loess){a.vals.loess={}}var c=this.cloneObject(b);c.push(this.loessDegree,this.loessSteps,this.loessSurfaceSteps,this.loessBandwidth,this.loessSpan);c=c.join(":");return a.vals.loess.hasOwnProperty(c)?a.vals.loess[c]:false};this.loess=function(Y,H,Q){var m=this.checkLoessCache(Q);if(m){return m}var F=this;var W=function(d){var k=Math.abs(d);var i=1/(1+k/2);var j=i*Math.exp(-k*k-1.26551223+i*(1.00002368+i*(0.37409196+i*(0.09678418+i*(-0.18628806+i*(0.27886807+i*(-1.13520398+i*(1.48851587+i*(-0.82215223+i*0.17087277)))))))));return d>=0?j:2-j};var l=function(d){if(d>=2){return -100}if(d<=0){return 100}var aa=(d<1)?d:2-d;var k=Math.sqrt(-2*Math.log(aa/2));var y=-0.70711*((2.30753+k*0.27061)/(1+k*(0.99229+k*0.04481))-k);for(var i=0;i<2;i++){var w=W(y)-aa;y+=w/(1.1283791670955126*Math.exp(-(y*y))-y*w)}return(d<1)?y:-y};var X=function(i,j,d){var k=Math.sqrt(j);return i-k*Math.sqrt(2)*l(2*d)};var O=function(d){var y=Math.ceil(0.1*d.length);var k=F.cloneObject(d);k=k.sort(function(i,aa){return i-aa});for(var j=0;j<y;j++){k.shift();k.pop()}var w=F.standardDeviation(k);return function(i){return i.map(function(aa){return aa/w})}};var a=function(j,d){var w=[];for(var k=0;k<j.length;k++){if(F.isArray(j[k])&&F.isArray(d[k])){w.push(a(j[k],d[k]))}else{w.push(j[k]*d[k])}}return w};var o=function(j,ab){var w=function(d,ac,ae){if(ae>1){for(var ad=ac;ad<j.length;ad++){w(a(d,j[ad]),ad,ae-1)}}else{aa.push(d)}};var aa=[];var y=Array(j[0].length).fill(1);for(var k=0;k<=ab;k++){w(y,0,k+1)}return aa};var n=function(j,i){if(j.length<2){return Math.abs(j[0]-i[0])}else{return Math.sqrt(j.reduce(function(d,k,w){return d+Math.pow(k-i[w],2)},0))}};var P=function(i,d){return i.map(function(j){return d.map(function(k){return n(j,k)})})};var q=function(k,j,i){return k<j?Math.pow(1-Math.pow(k/j,i),i):0};var r=function(k,j,i){return k.map(function(aa){var ac=F.rank(aa);var ab=[];for(var y=0;y<ac.length;y++){ab.push([aa[ac[y]],j[ac[y]]])}var ae=F.sum(j)*i;var d=0;var w=ab.findIndex(function(af){d+=af[1];return d>=ae});var ad=i>1?ab[ab.length-1][0]*i:ab[w][0];return a(aa.map(function(af){return q(af,ad,3)}),j)})};var s=function(ad,ac){var ab=ad.length;var k=ad[0].length;var w=ac.length;var ae=ac[0].length;var j=new Array(ab);for(var d=0;d<ab;d++){j[d]=new Array(ae);for(var aa=0;aa<ae;aa++){j[d][aa]=0;for(var y=0;y<k;y++){j[d][aa]+=ad[d][y]*ac[y][aa]}}}return j};var g=function(w,k){var d=new Array(w.length);for(var aa=0;aa<d.length;aa++){d[aa]=new Array(w[aa].length);for(var y=0;y<d[aa].length;y++){d[aa][y]=w[aa][y]-k[aa][y]}}return d};var u=function(d){var j=[];for(var k=0;k<d.length;k++){j.push(d[k][0])}return j};var I=function(j,k,w){var ab=a(w,k);var ac=F.transpose(j.map(function(ae){return a(w,ae)}));var aa=s(j,ac);var d=s(j,F.transpose([ab]));var y=s(numeric.inv(aa),d);var i=s(F.transpose(y),j);var ad=g([k],i);return{beta:y,yhat:i,residuals:ad}};var e=function(d){b=[];T=[];N=a(d,K);var i=F.transpose(M);i.forEach(function(k,j){var w=I(Z,G,N[j]);b.push(u(s([k],w.beta)));T.push(w.residuals);var y=F.median(F.Abs(w.residuals[0]));d[j]=w.residuals.map(function(aa){return q(aa,6*y[0],2)})})};this.loessDegree=parseInt(this.loessDegree);if(this.loessDegree<0||this.loessDegree>2){this.loessDegree=2}this.loessBandWidth=Number(this.loessBandwidth);if(this.loessBandwidth<0||this.loessBandwidth>1){this.loessBandwidth=0.8}this.loessSpan=Number(this.loessSpan);if(this.loessSpan<0||this.loessSpan>1){this.loessSpan=0.8}var z=[Y[0]];var t=[this.loessSteps];var G=Y[1];if(Y[2]){z.push(Y[2]);t.push(this.loessSteps)}if(!H){H=Array(Y[0].length).fill(1)}var Z=o(z,this.loessDegree);var c=z.map(O);var L=z.map(function(i,d){return c[d](i)});var h=this.transposeMatrix(L);var E=[];var J=[];z.forEach(function(ac,ad){var d=ac.sort(function(ae,i){return ae-i});var j=d[0];var y=d[d.length-1];var k=(y-j)/(t[ad]-1);J.push([]);for(var w=0;w<t[ad];w++){J[ad].push(j+w*k)}var aa=1;var ab=1;for(var w=ad-1;w>=0;w--){aa*=t[w]}for(var w=ad+1;w<z.length;w++){ab*=t[w]}E.push([]);for(var w=0;w<aa;w++){E[ad]=E[ad].concat(J[ad].reduce(function(i,ae){return i.concat(Array(ab).fill(ae))},[]))}});var A=this.cloneObject(E);var V=E[0].length;var M=o(A,this.loessDegree);var U=A.map(function(i,d){return c[d](i)});var f=P(this.transpose(U),h);var K=r(f,H,this.loessBandwidth);var b;var T;var N;var C=Array(V).fill(Array(Y[0].length).fill(1));for(var x=0;x<this.loessIterations;x++){e(C)}var v={fitted:u(b),residuals:T,weights:N};(function(){var i=X(0,1,1-(1-F.loessSpan)/2);var d=N.map(function(aa,k){var w=F.sum(aa);var j=s([aa],F.transpose([aa]));var y=Math.sqrt(s([F.square(T[k][0])],F.transpose([aa]))/(w-j[0]/w));return y*i});Object.assign(v,{halfwidth:d})})();var B=[];if(Y[2]){for(var S=0;S<this.loessSurfaceSteps;S++){var D=[];for(var R=0;R<this.loessSurfaceSteps;R++){D.push(v.fitted[R*this.loessSurfaceSteps+S])}B.push(D)}}if(!this.meta.vals.loess){this.meta.vals.loess={}}var p=this.cloneObject(Q);p.push(this.loessDegree,this.loessSteps,this.loessSurfaceSteps,this.loessBandwidth,this.loessSpan);p=p.join(":");if(Y[2]){this.meta.vals.loess[p]={x:J[0],y:J[1],z:B,c:v.halfwidth}}else{this.meta.vals.loess[p]={x:E[0],y:v.fitted,c:v.halfwidth}}return this.meta.vals.loess[p]};this.loessOld=function(M,G,J){var l=this.checkLoessCache(J);if(l){return l}var F=[];var D=[];var C=function(V,W,y,U){var T=function(b,X){var x=X+1;while(x<b.length&&b[x]===0){x++}return x};var j=U[0];var a=U[1];var d=T(W,a);if((d<V.length)&&(V[d]-V[y])<(V[y]-V[j])){var k=T(W,j);U[0]=k;U[1]=d}};M=this.cleanArrays(M[0],M[1]);if(M[0].length>0){var t=this.rank(M[0]);for(var L=0;L<t.length;L++){F.push(M[0][t[L]]);D.push(M[1][t[L]])}if(M[0].length<2){return[F,D]}if(!G){G=[];for(var L=0;L<F.length;L++){G.push(1)}}var H=Math.floor(this.loessBandwidth*M[0].length);if(H<2){alert("Bandwidth for loess fitting too small!");return false}else{var m=[];var v=[];var N=[];for(var L=0;L<F.length;L++){m[L]=0;v[L]=0;N[L]=1}var q=0;while(q<=this.loessIterations){var O=[0,H-1];for(var L=0;L<F.length;L++){if(L>0){C(F,G,L,O)}var A=O[0];var r=O[1];var Q=(F[L]-F[A])>(F[r]-F[L])?A:r;var g=0;var u=0;var n=0;var s=0;var c=0;var S=Math.abs(1/(F[Q]-F[L]));for(var K=A;K<=r;++K){var f=K<L?F[L]-F[K]:F[K]-F[L];var R=this.triCube(f*S)*N[K]*G[K];var z=F[K]*R;g+=R;u+=z;n+=F[K]*z;s+=D[K]*R;c+=D[K]*z}var p=u/g;var o=s/g;var E=c/g;var e=n/g;var B=(Math.sqrt(Math.abs(e-p*p))<this.loessAccuracy)?0:((E-p*o)/(e-p*p));var I=o-B*p;m[L]=B*F[L]+I;v[L]=Math.abs(D[L]-m[L])}if(q===this.loessIterations){break}var h=this.medianByQuantile(v);if(Math.abs(h)<this.loessAccuracy){break}for(var L=0;L<F.length;L++){var P=v[L]/(6*h);N[L]=P>=1?0:Math.pow(1-P*P,2)}q++}this.meta.vals.loess.push({x:J[0],y:J[1],b:this.loessBandwidth,i:this.loessIterations,a:this.loessAccuracy,l:[F,m]});return[F,m]}}else{alert("Not valid array for loess fitting!");return false}};this.errorEllipse=function(a,c,b){if(b){return this.errorEllipse3D(a,c,b)}else{return this.errorEllipse2D(a,c)}};this.errorEllipse2D=function(k,g){var i=this.variance(k,false,false,true);var h=this.variance(g,false,false,true);var j=this.covariance(k,g);var m=[[i[1],j],[j,h[1]]];var n=numeric.eig(m);var l=Math.sqrt(2*this.gammaPinv(this.errorEllipseConfidence,1));var f=n.lambda.x[0]>n.lambda.x[1]?0:1;var e=n.lambda.x[0]<n.lambda.x[1]?0:1;var b=i[1]>h[1]?Math.sqrt(n.lambda.x[f])*l:Math.sqrt(n.lambda.x[e])*l;var a=h[1]>i[1]?Math.sqrt(n.lambda.x[f])*l:Math.sqrt(n.lambda.x[e])*l;var c=Math.atan2(n.E.x[f][1],n.E.x[f][0]);if(c<0){c+=Math.PI/2}var d={rx:b,ry:a,cx:i[0],cy:h[0],rot:c};return d};this.errorEllipse3D=function(m,l,j){var p=this.variance(m,false,false,true);var o=this.variance(l,false,false,true);var n=this.variance(j,false,false,true);var c=this.covariance(m,l);var b=this.covariance(m,j);var i=this.covariance(l,j);var t=[[p[1],c,b],[c,o[1],i],[b,i,n[1]]];var k=numeric.eig(t);var a=Math.sqrt(2*this.gammaPinv(this.errorEllipseConfidence,1));var f=this.rank(k.lambda.x);var s=f[2];var q=f[1];var r=f[0];var h=Math.sqrt(k.lambda.x[s])*a;var e=Math.sqrt(k.lambda.x[q])*a;var d=Math.sqrt(k.lambda.x[r])*a;var w=Math.atan2(k.E.x[2][s]*-1,k.E.x[1][s]*-1);var v=Math.atan2(k.E.x[2][s]*-1,k.E.x[0][s]*-1);var u=Math.atan2(k.E.x[1][s]*-1,k.E.x[0][s]*-1);if(w<0){}if(v<0){v+=Math.PI/2}if(u<0){}var g={rx:[h],ry:[e],rz:[d],cx:p[0],cy:o[0],cz:n[0],rot:[w,v,u]};return g};this.epanechnikovKernel=function(a){return function(b){return Math.abs(b/=a)<=1?0.75*(1-b*b)/a:0}};this.uniformKernel=function(a){return function(b){if(b/a<=1&&b/a>=-1){return 0.5}return 0}};this.triangularKernel=function(a){return function(b){if(b/a<=1&&b/a>=-1){return 1-Math.abs(b/a)}return 0}};this.quarticKernel=function(a){return function(b){if(b/a<=1&&b/a>=-1){var c=(1-b*b)/a;return(15/16)*c*c}return 0}};this.triweightKernel=function(a){return function(b){if(b/a<=1&&b/a>=-1){var c=(1-b*b)/a;return(35/32)*c*c*c}return 0}};this.gaussianKernel=function(a){return function(b){return 1/Math.sqrt(2*Math.PI)*Math.exp(-0.5*b*b/a)}};this.cosineKernel=function(a){return function(b){if(b/a<=1&&b>=-1/a){return Math.PI/4*Math.cos((Math.PI/2*b)/a)}return 0}};this.getBandwidthEstimate=function(e,a){var b=Math.sqrt(this.variance(e));var f=this.iqr(e)/1.34;var d=Math.pow(e.length,-0.2);var c=Math.min(b,f);return !a?1.06*c*d:0.9*c*d};this.kernelDensityEstimator=function(d,b){var c=function(e){return null!=e&&!this.isNaN(e)};var a=function(j,l){var k,g=j.length,h=0,m=-1,f=0;for(;++m<g;){c(k=l.call(j,j[m],m))&&(h+=(k-h)/++f)}return f?h:void 0};return function(e){return b.map(function(f){return[f,a(e,function(g){return d(f-g)})]})}};this.kde=function(d,b,f,h,e){var g=f[0];var c=f[1];var i=[];for(var j=g;j<=c;j+=h){i.push(j)}if(!b){b=this.getBandwidthEstimate(e)}var a=this.kernelDensityEstimator(this[d](b),i);return a(e)};this.freedmanDiaconis=function(b,a,c){if(b&&b.length>1){b=this.cleanArray(b,a,c);var d=this.iqr(b);return d==0?1:this.pretty(2*d*Math.pow(b.length,-1/3))}else{if(b&&b.length==1){return Number(b[0])}else{return 1}}};this.pretty=function(a){var c=Math.pow(10,Math.floor(Math.log(a/10)/Math.LN10));var b=10/a*c;if(b<=0.15){c*=10}else{if(b<=0.35){c*=5}else{if(b<=0.75){c*=2}}}return c*10};this.round=function(a,b){return Number(Math.round(a+"e"+b)+"e-"+b)};this.getHistogramBin=function(c,a){var d=a*Math.floor(c/a);return parseFloat(d.toFixed(this.getAxisDecimals(a)))};this.toFixed=function(h,b){var e=b||0;var d=g<0;var a=Math.pow(10,e);var g=Math.round(h*a);var c=String((d?Math.ceil:Math.floor)(g/a));var i=String((d?-g:g)%a);var f=new Array(Math.max(e-i.length,0)+1).join("0");return e?c+"."+f+i:c};this.bezierCalculatePoints=function(g,e){var b=g[0][0];var a=g[0][1];var d=g[1][0];var c=g[1][1];var h=b+(d-b)*e;var f=a+(c-a)*e;return[h,f]};this.deCasteljau=function(e,d){if(d===1){return e[e.length-1]}if(d===0){return e[0]}if(e.length==1){return e[0]}var b=[];for(var c=1,a=e.length;c<a;c++){b.push(this.bezierCalculatePoints([e[c-1],e[c]],d))}return this.deCasteljau(b,d)};this.divideBezierCurve=function(f,e,c,g){c=c||[];g=g||[];c.push(f[0]);g.push(f[f.length-1]);if(f.length===1){return[c,g]}var b=[];for(var d=1,a=f.length;d<a;d++){b.push(this.bezierCalculatePoints([f[d-1],f[d]],e))}return this.divideBezierCurve(b,e,c,g)};this.centroid=function(a){var c=[];if(!a||a.length<2){return[0,0]}else{if(a.length<3||a.length%2){return[a[0],a[1]]}else{while(a.length>1){c.push([a.shift(),a.shift()])}}}var b=c.reduce(function(d,e){return[d[0]+e[0]/c.length,d[1]+e[1]/c.length]},[0,0]);return b};this.centroidArea=function(a){var b=this.cloneObject(a);b.shift();return this.centroid(b)};this.prufer=function(c){var b=[];var e=Array.apply(null,Array(c.length+2)).map(function(a,j){return j});var h=Array.apply(null,Array(1*e.length)).map(function(){return 1});c.map(function(a){h[a]++});for(var f=0;f<c.length;f++){for(var d=0;d<e.length;d++){if(h[e[d]]===1){b.push([c[f],e[d]]);h[c[f]]--;h[e[d]]--;break}}}var g=e.filter(function(a){return h[a]===1});b.push(g);return b};this.getD3Sankey=function(){var h=function(D,C){return D<C?-1:D>C?1:D>=C?0:NaN};var f=function(H,F){var E=0,G=H.length,C,D=-1;if(F==null){while(++D<G){if(C=+H[D]){E+=C}}}else{while(++D<G){if(C=+F(H[D],D,H)){E+=C}}}return E};var t=function(H,F){var E=-1,G=H.length,D,C;if(F==null){while(++E<G){if((C=H[E])!=null&&C>=C){D=C;break}}while(++E<G){if((C=H[E])!=null&&D>C){D=C}}}else{while(++E<G){if((C=F(H[E],E,H))!=null&&C>=C){D=C;break}}while(++E<G){if((C=F(H[E],E,H))!=null&&D>C){D=C}}}return D};var x=function(D,C){return D=+D,C-=D,function(E){return D+C*E}};var v="$";function j(){}j.prototype=A.prototype={constructor:j,has:function(C){return(v+C) in this},get:function(C){return this[v+C]},set:function(C,D){this[v+C]=D;return this},remove:function(C){var D=v+C;return D in this&&delete this[D]},clear:function(){for(var C in this){if(C[0]===v){delete this[C]}}},keys:function(){var C=[];for(var D in this){if(D[0]===v){C.push(D.slice(1))}}return C},values:function(){var C=[];for(var D in this){if(D[0]===v){C.push(this[D])}}return C},entries:function(){var C=[];for(var D in this){if(D[0]===v){C.push({key:D.slice(1),value:this[D]})}}return C},size:function(){var C=0;for(var D in this){if(D[0]===v){++C}}return C},empty:function(){for(var C in this){if(C[0]===v){return false}}return true},each:function(D){for(var C in this){if(C[0]===v){D(this[C],C.slice(1),this)}}}};function A(C,F){var G=new j;if(C instanceof j){C.each(function(K,J){G.set(J,K)})}else{if(Array.isArray(C)){var E=-1,I=C.length,H;if(F==null){while(++E<I){G.set(E,C[E])}}else{while(++E<I){G.set(F(H=C[E],E,C),H)}}}else{if(C){for(var D in C){G.set(D,C[D])}}}}return G}var z=function(){var G=[],I=[],F,H,E;function D(P,N,L,Q){if(N>=G.length){return H!=null?H(P):(F!=null?P.sort(F):P)}var O=-1,J=P.length,T=G[N++],M,R,K=A(),S,U=L();while(++O<J){if(S=K.get(M=T(R=P[O])+"")){S.push(R)}else{K.set(M,[R])}}K.each(function(V,W){Q(U,W,D(V,N,L,Q))});return U}function C(K,L){if(++L>G.length){return K}var M,J=I[L-1];if(H!=null&&L>=G.length){M=K.entries()}else{M=[],K.each(function(O,N){M.push({key:N,values:C(O,L)})})}return J!=null?M.sort(function(O,N){return J(O.key,N.key)}):M}return E={object:function(J){return D(J,0,r,o)},map:function(J){return D(J,0,s,B)},entries:function(J){return C(D(J,0,s,B),0)},key:function(J){G.push(J);return E},sortKeys:function(J){I[G.length-1]=J;return E},sortValues:function(J){F=J;return E},rollup:function(J){H=J;return E}}};function r(){return{}}function o(C,D,E){C[D]=E}function s(){return A()}function B(E,C,D){E.set(C,D)}var l={};var e=12;var i=5;var m=[1,1];var p=[];var d=[];l.nodeWidth=function(C){if(!arguments.length){return e}e=+C;return l};l.nodePadding=function(C){if(!arguments.length){return i}i=+C;return l};l.nodes=function(C){if(!arguments.length){return p}p=C;return l};l.links=function(C){if(!arguments.length){return d}d=C;return l};l.size=function(C){if(!arguments.length){return m}m=C;return l};l.layout=function(C){c();k();a();g(C);b();u();return l};l.relayout=function(){b();u();return l};l.link=function(){var D=0.5;function C(L){var I=L.source.x+L.source.dx,H=L.target.x,G=x(I,H),F=G(D),E=G(1-D),K=L.source.y+L.sy+L.dy/2,J=L.target.y+L.ty+L.dy/2;return"M"+I+","+K+"C"+F+","+K+" "+E+","+J+" "+H+","+J}C.curvature=function(E){if(!arguments.length){return D}D=+E;return C};return C};function u(){var C=0.5;d.forEach(function(K){var H=K.source.x+K.source.dx,G=K.target.x,F=x(H,G),E=F(C),D=F(1-C),J=K.source.y+K.sy+K.dy/2,I=K.target.y+K.ty+K.dy/2;K.bezier=[[H,E,D,G],[J,J,I,I]]})}function c(){p.forEach(function(C){C.sourceLinks=[];C.targetLinks=[]});d.forEach(function(C){var D=C.source,E=C.target;if(typeof D==="number"){D=C.source=p[C.source]}if(typeof E==="number"){E=C.target=p[C.target]}D.sourceLinks.push(C);E.targetLinks.push(C)})}function k(){p.forEach(function(C){C.value=Math.max(f(C.sourceLinks,q),f(C.targetLinks,q))})}function a(){var D=p,E,C=0;while(D.length){E=[];D.forEach(function(F){F.x=C;F.breadth=C;F.dx=e;F.sourceLinks.forEach(function(G){E.push(G.target)})});D=E;++C}w(C);n((m[0]-e)/(C-1))}function w(C){p.forEach(function(D){if(!D.sourceLinks.length){D.x=C-1}})}function n(C){p.forEach(function(D){D.x*=C})}function g(H){var C=z().key(function(K){return K.x}).sortKeys(h).entries(p).map(function(K){return K.values});F();J();for(var I=1;H>0;--H){D(I*=0.99);J();E(I);J()}function F(){var K=t(C,function(L){return(m[1]-(L.length-1)*i)/f(L,q)});C.forEach(function(L){L.forEach(function(N,M){N.y=M;N.dy=N.value*K})});d.forEach(function(L){L.dy=L.value*K})}function E(L){C.forEach(function(M,N){M.forEach(function(O){if(O.targetLinks.length){var P=f(O.targetLinks,K)/f(O.targetLinks,q);O.y+=(P-y(O))*L}})});function K(M){return y(M.source)*M.value}}function D(L){C.slice().reverse().forEach(function(M){M.forEach(function(N){if(N.sourceLinks.length){var O=f(N.sourceLinks,K)/f(N.sourceLinks,q);N.y+=(O-y(N))*L}})});function K(M){return y(M.target)*M.value}}function J(){C.forEach(function(L){var O,K,N=0,P=L.length,M;L.sort(G);for(M=0;M<P;++M){O=L[M];K=N-O.y;if(K>0){O.y+=K}N=O.y+O.dy+i}K=N-i-m[1];if(K>0){N=O.y-=K;for(M=P-2;M>=0;--M){O=L[M];K=O.y+O.dy+i-N;if(K>0){O.y-=K}N=O.y}}})}function G(L,K){return L.y-K.y}}function b(){p.forEach(function(E){E.sourceLinks.sort(C);E.targetLinks.sort(D)});p.forEach(function(F){var G=0,E=0;F.sourceLinks.forEach(function(H){H.sy=G;G+=H.dy});F.targetLinks.forEach(function(H){H.ty=E;E+=H.dy})});function D(F,E){return F.source.y-E.source.y}function C(F,E){return F.target.y-E.target.y}}function y(C){return C.y+C.dy/2}function q(C){return C.value}return l};this.setSankey=function(){var a=this.getD3Sankey();a.nodeWidth(this.sankeyNodeWidth);a.nodePadding(this.margin);a.size([this.x,this.y]);a.nodes(this.data.sankey.nodes);a.links(this.data.sankey.links);a.layout(this.sankeyIterations);this.data.sankey.object=a};this.getD3Tree=function(){var b=this;var l=function(y,x,w){var z=w/(x.i-y.i);x.c-=z;x.s+=w;y.c+=z;x.z+=w;x.m+=w};var f=function(z){var y=0;var C=0;var B=z.children;var A=B.length;var x;while(--A>=0){x=B[A];x.z+=y;x.m+=y;y+=x.s+(C+=x.c)}};var a=function(x,w,y){return x.a.parent===w.parent?x.a:y};var r=function(w){var x=w.children;return x?x[0]:w.t};var v=function(w){var x=w.children;return x?x[x.length-1]:w.t};var e=function(x,w){return x.parent===w.parent?1:2};var i=1;var g=1;var n=null;var h=function(z,x){if(z===x){return z}var y=z.ancestors();var w=x.ancestors();var A=null;z=y.pop();x=w.pop();while(z===x){A=z;z=y.pop();x=w.pop()}return A};var d=function(w){w.data=w.data.data};var j=function(x){var w=0;do{x.height=w}while((x=x.parent)&&(x.height<++w))};var c=function(C,y){var F=new u(C);var D=+C.value&&(F.value=C.value);var A;var w=[F];var x;var E;var B;var z;if(y==null){y=function(G){return G.children}}while(A=w.pop()){if(D){A.value=+A.data.value}if((E=y(A.data))&&(z=E.length)){A.children=new Array(z);for(B=z-1;B>=0;--B){w.push(x=A.children[B]=new u(E[B]));x.parent=A;x.depth=A.depth+1}}}return F.eachBefore(j)};var u=function(w){this.data=w;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=b.treeNodeId++}};u.prototype=c.prototype={constructor:u,count:function(){return this.eachAfter(count)},each:function(C){var z=this;var A;var y=[z];var x,w,B;do{A=y.reverse();y=[];while(z=A.pop()){C(z);x=z.children;if(x){for(w=0,B=x.length;w<B;++w){y.push(x[w])}}}}while(y.length);return this},eachAfter:function(C){var A=this;var w=[A];var z=[];var y,x,B;while(A=w.pop()){z.push(A);y=A.children;if(y){for(x=0,B=y.length;x<B;++x){w.push(y[x])}}}while(A=z.pop()){C(A)}return this},eachBefore:function(A){var z=this;var w=[z];var y,x;while(z=w.pop()){A(z);y=z.children;if(y){for(x=y.length-1;x>=0;--x){w.push(y[x])}}}return this},sum:function(w){return this.eachAfter(function(A){var z=+w(A.data)||0;var y=A.children;var x=y&&y.length;while(--x>=0){z+=y[x].value}A.value=z})},sort:function(w){return this.eachBefore(function(x){if(x.children){x.children.sort(w)}})},path:function(w){var A=this;var z=h(A,w);var y=[A];while(A!==z){A=A.parent;y.push(A)}var x=y.length;while(w!==z){y.splice(x,0,w);w=w.parent}return y},ancestors:function(){var x=this;var w=[x];while(x=x.parent){w.push(x)}return w},descendants:function(){var w=[];this.each(function(x){w.push(x)});return w},leaves:function(){var w=[];this.eachBefore(function(x){if(!x.children){w.push(x)}});return w},links:function(){var w=this;var x=[];w.each(function(y){if(y!==w){x.push({source:y.parent,target:y})}});return x},copy:function(){return c(this).eachBefore(d)}};var p=function(x,w){this._=x;this.parent=null;this.children=null;this.A=null;this.a=this;this.z=0;this.m=0;this.c=0;this.s=0;this.t=null;this.i=w};p.prototype=Object.create(u.prototype);var q=function(x){var w=new p(x,0);var B;var y=[w];var D;var A;var z;var C;while(B=y.pop()){if(A=B._.children){B.children=new Array(C=A.length);for(z=C-1;z>=0;--z){y.push(D=B.children[z]=new p(A[z],z));D.parent=B}}}(w.parent=new p(null,0)).children=[w];return w};function k(B){var D=q(B);D.eachAfter(t),D.parent.m=-D.z;D.eachBefore(o);if(n){B.eachBefore(s)}else{var x=B;var C=B;var w=B;B.eachBefore(function(F){if(F.x<x.x){x=F}if(F.x>C.x){C=F}if(F.depth>w.depth){w=F}});var E=x===C?1:e(x,C)/2;var y=E-x.x;var A=i/(C.x+E+y);var z=g/(w.depth||1);B.eachBefore(function(F){F.x=(F.x+y)*A;F.y=F.depth*z})}return B}function t(y){var A=y.children;var B=y.parent.children;var x=y.i?B[y.i-1]:null;if(A){f(y);var z=(A[0].z+A[A.length-1].z)/2;if(x){y.z=x.z+e(y._,x._);y.m=y.z-z}else{y.z=z}}else{if(x){y.z=x.z+e(y._,x._)}}y.parent.A=m(y,x,y.parent.A||B[0])}function o(w){w._.x=w.z+w.parent.m;w.m+=w.parent.m}function m(I,H,C){if(H){var z=I;var y=I;var B=H;var A=z.parent.children[0];var E=z.m;var D=y.m;var G=B.m;var F=A.m;var x;while(B=v(B),z=r(z),B&&z){A=r(A);y=v(y);y.a=I;x=B.z+G-z.z-E+e(B._,z._);if(x>0){l(a(B,I,C),I,x);E+=x;D+=x}G+=B.m;E+=z.m;F+=A.m;D+=y.m}if(B&&!v(y)){y.t=B;y.m+=G-D}if(z&&!r(A)){A.t=z;A.m+=E-F;C=I}}return C}function s(w){w.x*=i;w.y=w.depth*g}k.separation=function(w){return arguments.length?(e=w,k):e};k.size=function(w){return arguments.length?(n=false,i=+w[0],g=+w[1],k):(n?null:[i,g])};k.nodeSize=function(w){return arguments.length?(n=true,i=+w[0],g=+w[1],k):(n?[i,g]:null)};k.setTree=function(x,w){return c(x,w)};k.collapse=function(w){k.collapseTree(w);k.update(w)};k.expand=function(w){k.expandTree(w);k.update(w)};k.collapseTree=function(w){if(w.children){w._children=w.children;w._children.forEach(k.collapseTree);w.children=null}};k.expandTree=function(w){if(w._children){w.children=w._children;w.children.forEach(k.expandTree);delete w._children}};return k};this.setTree=function(){var b=[];if(this.treeCircular){b=this.x>this.y?[360,this.y/2]:[360,this.x/2]}else{b=[this.graphOrientation=="vertical"?this.x:this.y,this.graphOrientation=="vertical"?this.y:this.x]}var a=function(d,c){return(d.parent==c.parent?1:2)/d.depth};this.data.tree.object=this.treeCircular?this.getD3Tree().size(b).separation(a):this.getD3Tree().size(b);if(!this.data.tree.root){this.data.tree.root=this.getD3Tree().setTree(this.data.tree.data,function(c){return c.children})}this.data.tree.plot=this.data.tree.object(this.data.tree.root);this.data.tree.plot.size=b};this.getD3CirclePack=function(){var l=this;var r=function(K,I){if(K===I){return K}var J=K.ancestors();var H=I.ancestors();var L=null;K=J.pop();I=H.pop();while(K===I){L=K;K=J.pop();I=H.pop()}return L};var o=function(H){H.data=H.data.data};var w=function(I){var H=0;do{I.height=H}while((I=I.parent)&&(I.height<++H))};var m=function(N,J){var Q=new F(N);var O=+N.value&&(Q.value=N.value);var L;var H=[Q];var I;var P;var M;var K;if(J==null){J=function(R){return R.children}}while(L=H.pop()){if(O){L.value=+L.data.value}if((P=J(L.data))&&(K=P.length)){L.children=new Array(K);for(M=K-1;M>=0;--M){H.push(I=L.children[M]=new F(P[M]));I.parent=L;I.depth=L.depth+1}}}return Q.eachBefore(w)};var F=function(H){this.data=H;this.depth=0;this.height=0;this.parent=null;if(this.nid==null){this.id=l.treeNodeId++}};F.prototype=m.prototype={constructor:F,count:function(){return this.eachAfter(count)},each:function(N){var K=this;var L;var J=[K];var I,H,M;do{L=J.reverse();J=[];while(K=L.pop()){N(K);I=K.children;if(I){for(H=0,M=I.length;H<M;++H){J.push(I[H])}}}}while(J.length);return this},eachAfter:function(N){var L=this;var H=[L];var K=[];var J,I,M;while(L=H.pop()){K.push(L);J=L.children;if(J){for(I=0,M=J.length;I<M;++I){H.push(J[I])}}}while(L=K.pop()){N(L)}return this},eachBefore:function(L){var K=this;var H=[K];var J,I;while(K=H.pop()){L(K);J=K.children;if(J){for(I=J.length-1;I>=0;--I){H.push(J[I])}}}return this},sum:function(H){return this.eachAfter(function(L){var K=+H(L.data)||0;var J=L.children;var I=J&&J.length;while(--I>=0){K+=J[I].value}L.value=K})},sort:function(H){return this.eachBefore(function(I){if(I.children){I.children.sort(H)}})},path:function(H){var L=this;var K=r(L,H);var J=[L];while(L!==K){L=L.parent;J.push(L)}var I=J.length;while(H!==K){J.splice(I,0,H);H=H.parent}return J},ancestors:function(){var I=this;var H=[I];while(I=I.parent){H.push(I)}return H},descendants:function(){var H=[];this.each(function(I){H.push(I)});return H},leaves:function(){var H=[];this.eachBefore(function(I){if(!I.children){H.push(I)}});return H},links:function(){var H=this;var I=[];H.each(function(J){if(J!==H){I.push({source:J.parent,target:J})}});return I},copy:function(){return m(this).eachBefore(o)}};var e=null;var s=1;var q=1;var h=function(H){this._=H;this.next=null};var g=function(M){var I;var L=(M=M.slice()).length;var H=null;var K=H;while(L){var J=new h(M[L-1]);if(K){K=K.next=J}else{K=H=J}M[I]=M[--L]}return{head:H,tail:K}};var t=function(H){return G(g(H),[])};var d=function(J,H){var K=H.x-J.x;var I=H.y-J.y;var L=J.r-H.r;return L*L+0.000001>K*K+I*I};var G=function(I,O){var M;var K=null;var J=I.head;var H;var N;switch(O.length){case 1:M=y(O[0]);break;case 2:M=x(O[0],O[1]);break;case 3:M=u(O[0],O[1],O[2]);break}while(J){N=J._;H=J.next;if(!M||!d(M,N)){if(K){I.tail=K;K.next=null}else{I.head=I.tail=null}O.push(N);M=G(I,O);O.pop();if(I.head){J.next=I.head;I.head=J}else{J.next=null;I.head=I.tail=J}K=I.tail;K.next=H}else{K=J}J=H}I.tail=K;return M};var y=function(H){return{x:H.x,y:H.y,r:H.r}};var x=function(S,P){var I=S.x;var R=S.y;var K=S.r;var H=P.x;var O=P.y;var J=P.r;var N=H-I;var Q=O-R;var L=J-K;var M=Math.sqrt(N*N+Q*Q);return{x:(I+H+N/M*L)/2,y:(R+O+Q/M*L)/2,r:(M+K+J)/2}};var u=function(ag,ae,ad){var ac=ag.x;var L=ag.y;var X=ag.r;var aa=ae.x;var K=ae.y;var V=ae.r;var Y=ad.x;var I=ad.y;var U=ad.r;var aj=2*(ac-aa);var N=2*(L-K);var T=2*(V-X);var ak=ac*ac+L*L-X*X-aa*aa-K*K+V*V;var ah=2*(ac-Y);var M=2*(L-I);var S=2*(U-X);var ai=ac*ac+L*L-X*X-Y*Y-I*I+U*U;var af=ah*N-aj*M;var Z=(N*ai-M*ak)/af-ac;var W=(M*T-N*S)/af;var J=(ah*ak-aj*ai)/af-L;var H=(aj*S-ah*T)/af;var R=W*W+H*H-1;var Q=2*(Z*W+J*H+X);var P=Z*Z+J*J-X*X;var O=(-Q-Math.sqrt(Q*Q-4*R*P))/(2*R);return{x:Z+W*O+ac,y:J+H*O+L,r:O}};var n=function(M,K,I){var H=M.x;var Q=M.y;var R=K.r+I.r;var P=M.r+I.r;var S=K.x-H;var O=K.y-Q;var N=S*S+O*O;if(N){var L=0.5+((P*=P)-(R*=R))/(2*N);var J=Math.sqrt(Math.max(0,2*R*(P+N)-(P-=N)*P-R*R))/(2*N);I.x=H+L*S+J*O;I.y=Q+L*O-J*S}else{I.x=H+P;I.y=Q}};var a=function(J,H){var K=H.x-J.x;var I=H.y-J.y;var L=J.r+H.r;return L*L-0.000001>K*K+I*I};var A=function(M,I,O){var K=M._;var H=M.next._;var N=K.r+H.r;var L=(K.x*H.r+H.x*K.r)/N-I;var J=(K.y*H.r+H.y*K.r)/N-O;return L*L+J*J};var i=function(H){this._=H;this.next=null;this.previous=null};var k=function(P){if(!(N=P.length)){return 0}var U,N,R,V,V,T;var X=P[0];X.x=0;X.y=0;if(!(N>1)){return X.r}var W=P[1];X.x=-W.r;W.x=X.r;W.y=0;if(!(N>2)){return X.r+W.r}n(W,X,U=P[2]);var Y=X.r*X.r;var L=W.r*W.r;var M=U.r*U.r;var Q=Y+L+M;var K=Y*X.x+L*W.x+M*U.x;var J=Y*X.y+L*W.y+M*U.y;var I,H,S,R,O,V,T;X=new i(X);W=new i(W);U=new i(U);X.next=U.previous=W;W.next=X.previous=U;U.next=W.previous=X;B:for(var S=3;S<N;++S){n(X._,W._,U=P[S]);U=new i(U);R=W.next;O=X.previous;V=W._.r;T=X._.r;do{if(V<=T){if(a(R._,U._)){W=R;X.next=W;W.previous=X;--S;continue B}V+=R._.r;R=R.next}else{if(a(O._,U._)){X=O;X.next=W;W.previous=X;--S;continue B}T+=O._.r;O=O.previous}}while(R!==O.next);U.previous=X;U.next=W;X.next=W.previous=W=U;Q+=M=U._.r*U._.r;K+=M*U._.x;J+=M*U._.y;Y=A(X,I=K/Q,H=J/Q);while((U=U.next)!==W){if((M=A(U,I,H))<Y){X=U;Y=M}}W=X.next}X=[W._];U=W;while((U=U.next)!==W){X.push(U._)}U=t(X);for(var S=0;S<N;++S){X=P[S];X.x-=U.x;X.y-=U.y}return U.r};var j=function(H){k(H);return H};var E=function(H){return H==null?null:p(H)};var p=function(H){if(typeof H!=="function"){throw new Error}return H};var z=function(){return 0};var f=function(H){return function(){return H}};var D=function(H){return Math.sqrt(H.value)};var E=function(H){return H==null?null:p(H)};var C=function(H){return function(I){if(!I.children){I.r=Math.max(0,+H(I)||0)}}};var c=function(I,H){return function(M){if(K=M.children){var K,J,O=K.length,L=I(M)*H||0,N;if(L){for(J=0;J<O;++J){K[J].r+=L}}N=k(K);if(L){for(J=0;J<O;++J){K[J].r-=L}}M.r=N+L}}};var b=function(H){return function(J){var I=J.parent;J.r*=H;if(I){J.x=I.x+H*J.x;J.y=I.y+H*J.y}}};var v=z;function B(H){H.x=s/2,H.y=q/2;if(e){H.eachBefore(C(e)).eachAfter(c(v,0.5)).eachBefore(b(1))}else{H.eachBefore(C(D)).eachAfter(c(z,1)).eachAfter(c(v,H.r/Math.min(s,q))).eachBefore(b(Math.min(s,q)/(2*H.r)))}return H}B.radius=function(H){return arguments.length?(e=E(H),B):e};B.size=function(H){return arguments.length?(s=+H[0],q=+H[1],B):[s,q]};B.padding=function(H){return arguments.length?(v=typeof H==="function"?H:f(+H),B):v};B.setPack=function(H){return m(H).sum(function(I){return I.size}).sort(function(J,I){return I.value-J.value})};return B};this.setCirclePack=function(){var b=Math.max(this.top,this.right);var a=this.width-(this.right+this.left+this.marginLeft+this.marginRight);var e=this.height-(this.top+this.bottom+this.marginTop+this.marginBottom);var c=a>e?e:a;this.data.bubble.object=this.getD3CirclePack().size([c,c]).padding(2);if(!this.data.bubble.root){this.data.bubble.root=this.getD3CirclePack().setPack(this.data.bubble.data)}this.data.bubble.plot=this.data.bubble.object(this.data.bubble.root);this.data.bubble.plot.diameter=c}};CanvasXpress.prototype.initLayout=function(){this.isValidLayout=function(){var a=this.layoutTopology?this.layoutTopology.split(/X/i):this.layout.split(/X/i);if(this.layoutTopology){this.layoutRows=a[0];this.layoutCols=a[1]}else{if(this.layout){this.layoutRows=a[0];this.layoutCols=a[1]}else{this.layoutRows=1;this.layoutCols=1;this.layoutValid=false}}if(!this.graphType.match(/Scatter/)&&this.layoutComb&&this.data.l&&(this.data.l.vars||this.data.l.smps)&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];if(this.data.l.vars&&this.data.l.smps){var f=0;for(var d=0;d<this.data.l.smps.length;d++){for(var b=0;b<this.data.l.vars.length;b++){this.data.l.comp[f]=[this.getVariableIndices(this.data.l.vars[b]),this.getSampleIndices(this.data.l.smps[d])];f++}}}else{if(this.data.l.vars){for(var d=0;d<this.data.l.vars.length;d++){this.data.l.comp[d]=this.getVariableIndices(this.data.l.vars[d])}}else{for(var d=0;d<this.data.l.smps.length;d++){this.data.l.comp[d]=this.getSampleIndices(this.data.l.smps[d])}}}this.layoutValid=true}else{if(this.layoutComb&&this.data.l&&this.data.l.smps&&this.data.l.weight&&this.data.l.type){this.data.l.comp=[];var e=this.getVariableIndices(this.data.y.vars);for(var d=0;d<this.data.l.type.length;d++){this.data.l.comp[d]=e}this.layoutValid=true}else{if(this.data.l&&this.data.l.comp){if(this.data.l.comp.length<=(this.layoutRows*this.layoutCols)){this.layoutValid=true}else{this.layoutValid=false}}else{this.layoutValid=false}}}if(this.layoutValid){this.meta.config.orig.adjustAspectRatio=this.adjustAspectRatio;this.adjustAspectRatio=true}};this.setLayoutFonts=function(){this.setLegends();if(this.graphType=="Scatter2D"){this.set2DFont()}else{if(this.graphType=="Pie"){this.setPieFont()}else{this.set1DFont()}}};this.getLayoutAxisTitleHeight=function(a){var b=0;if(this.graphType=="Treemap"||this.graphType=="TagCloud"||this.graphType=="Pie"||this.graphType=="Heatmap"){return 0}else{if(this.graphType=="Scatter2D"){if(a){return this.yAxisTitle?this.axisTitleFontSize+(this.margin*2):0}else{return this.xAxisTitle?this.axisTitleFontSize+(this.margin*2):0}}else{if(this.graphOrientation=="vertical"){b=a?this.getAxisDescription(true):this.getAxisDescription();b=b!=""?this.axisTitleFontSize+(this.margin*2):0}else{b=a?this.getAxisDescription(true):this.getAxisDescription();b=b!=""?this.axisTitleFontSize+(this.margin*2):0}}}return b};this.setLayoutLeft=function(){var a=0;if(this.isDOE){a=0}else{if(this.graphType=="Scatter2D"){if(!this.layoutAdjust){a=this.get2DYAxisWidth()}a+=this.getLayoutAxisTitleHeight()}else{if(this.graphType=="Pie"){a=(this.margin*2)+this.measureText("XX",this.smpLabelFont)}else{if(this.graphType=="Candlestick"){if(this.graphOrientation!="vertical"){this.setTimeAxis();a=this.getSampleLabelLength()}else{a=0}}else{if(this.graphType=="Heatmap"){a=0}else{if(!this.layoutAdjust){if(this.segregateVariablesBy.length>0){if(this.graphOrientation!="vertical"){a=this.getSampleLabelLength()}else{a=this.getAxisTitleTickLength()}}else{if(this.segregateSamplesBy.length>0){if(this.graphOrientation=="vertical"){a=this.getAxisTitleTickLength()}}}}else{if(this.graphOrientation!="vertical"&&this.segregateVariablesBy.length>0){a=this.getSampleLabelLength()}}if(this.graphOrientation=="vertical"){a+=this.getLayoutAxisTitleHeight()}else{a+=this.smpTitle?this.smpTitleFontSize+(this.margin*2):0}}}}}}return a};this.setLayoutRight=function(){var a=0;if(this.isDOE){a=0}else{if(this.graphType.match(/Scatter/)){if(this.showLegend){a=this.legendWidth;if(!this.layoutAdjust){a+=this.get2DYAxisWidth(true)}}}else{if(this.graphType=="Pie"){if(this.showLegend&&this.legendPosition=="right"){a=this.legendVariableWidth}}else{if(this.graphType=="Heatmap"){return 0}else{if(!this.layoutAdjust){if(this.graphOrientation=="vertical"){a=this.getAxisTitleTickLength(true)}}else{a=0}if(this.graphOrientation=="vertical"){a+=this.getLayoutAxisTitleHeight(true)}if(this.showLegend&&this.legendPosition=="right"){a+=this.getLegendWidth();if(this.graphOrientation!="vertical"){a+=this.margin}}}}}}return a};this.setLayoutTop=function(){if(this.isDOE){return 0}var a=this.getTitleSubtitleHeight();if(this.graphType=="Pie"){a+=this.getFontHeight()+(this.margin*2)}else{if(this.graphType=="Scatter2D"){if(!this.layoutAdjust){a+=this.get2DXAxisHeight(true)}}else{if(this.graphType!="Heatmap"){if(!this.layoutAdjust){if(this.graphOrientation!="vertical"){a+=this.getAxisTitleTickLength()}}if(this.graphOrientation!="vertical"){a+=this.getLayoutAxisTitleHeight()}}}}return a};this.setLayoutBottom=function(){var a=0;if(this.isDOE){a=0}else{if(this.graphType=="Scatter2D"){if(!this.layoutAdjust){a=this.get2DXAxisHeight()}if(this.showLegend&&this.legendPosition=="bottom"){a+=this.legendHeight}a+=this.getLayoutAxisTitleHeight()}else{if(this.graphType=="Pie"){if(this.showLegend&&this.legendPosition=="bottom"){var c=this.getPieLegendDimensions();a=c[1]}}else{if(this.graphType=="Candlestick"&&this.graphOrientation=="vertical"){this.setTimeAxis();a=this.getSampleLabelLength()}else{if(this.graphType=="Heatmap"){a=this.getHeatmapIndicatorHeight()}else{if(!this.layoutAdjust){if(this.graphOrientation!="vertical"){a=this.getAxisTitleTickLength(true)}}if(this.graphOrientation=="vertical"){if(this.segregateVariablesBy.length>0){a=this.getSampleLabelLength()}a+=this.smpTitle?this.smpTitleFontSize+(this.margin*2):0}else{a+=this.getLayoutAxisTitleHeight(true)}if(this.showLegend&&this.legendPosition=="bottom"){a+=this.getLegendHeight()}}}}}}return a};this.drawLayoutSampleOverlays=function(b){var a=this.smpIndices;this.smpIndices=b;this.smpIndices=a;this.showSampleNames=true;this.showOverlays=true;this.draw1DYLayout()};this.setLayoutDimensions=function(){var c=this.isGroupedData;this.offsetX=0;this.offsetY=0;this.isGroupedData=false;this.setLayoutFonts();this.setLayoutLegendDimensions();this.isGroupedData=c;this.layoutLeft=this.setLayoutLeft();this.layoutRight=this.setLayoutRight();this.layoutTop=this.setLayoutTop();this.layoutBottom=this.setLayoutBottom();if(this.layoutCanvasCompartments){var a=this.width-(this.marginLeft+this.layoutLeft+this.marginRight+this.layoutRight);var b=this.height-(this.marginTop+this.layoutTop+this.marginBottom+this.layoutBottom);this.addToRender(["drawShape","rectangle",this.marginLeft+this.layoutLeft+(a/2),this.marginTop+this.layoutTop+(b/2),a,b,false,this.canvasBoxColor,"open"])}};this.setLayoutLegendDimensions=function(){if(this.graphType=="Pie"||this.isDOE){this.setVariableLegendDimension()}else{if(this.graphType=="Scatter2D"||this.isMultidimensionalData||((this.colorBy||this.shapeBy||this.sizeBy||this.patternBy)&&this.graphType.match(/^Bar$|Boxplot|Dotplot|Treemap|Heatmap/))){this.validatePropertyValues(true)}else{this.setVariableLegendDimension()}}};this.drawLabelsTitlesLayout=function(){this.functionCaller="drawLabelsTitlesLayout";var g=0;var f=0;var p=0;var A=0;var B=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var b=this.height-(this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom);if(this.graphType=="Treemap"){return}if(this.graphType=="Pie"&&(this.showPieGrid||this.showPieSampleLabel)){var v,m;var z=0;this.setFont();var q=this.getFontPt(this.font);var d=this.marginTop+this.layoutTop;var a=this.marginLeft+this.layoutLeft;var n=["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"];for(var u=0;u<this.layoutRows;u++){v=b*this.layoutParams[z].weight[1];g=(this.marginLeft+this.layoutLeft)-this.margin;d+=v;if(this.showPieGrid){this.addToRender(["drawText",n[u],g,(d+(q/2))-(v/2),this.font,this.foreground,"right","middle"])}for(var t=0;t<this.layoutCols;t++){if(this.xAxis.length<=z){break}m=B*this.layoutParams[z].weight[0];a+=m;f=(this.marginTop+this.layoutTop)-this.margin;if(u==0){if(this.showPieGrid){this.addToRender(["drawText",t+1,(a+(q/2))-(m/2),f,this.font,this.foreground,"center","bottom"])}}if(this.showPieSampleLabel){this.addToRender(["drawText",this.xAxis[z],a-(m/1.1),d-(v/5),this.legendFont,this.foreground,"center","middle"])}z++}a=this.marginLeft+this.layoutLeft}}else{if(this.graphType=="Scatter2D"){if(this.xAxisTitle){this.addToRender(["drawText",this.xAxisTitle,this.marginLeft+this.margin+(this.axisTitleFontSize/2),this.height/2,this.axisTitleFont,this.axisTitleFontColor,"center","middle",-Math.PI/2])}if(this.yAxisTitle){var s=this.legendPosition=="bottom"?this.getLegendHeight():0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var v=this.marginBottom+this.margin+(this.axisTitleFontSize/2)+s;this.addToRender(["drawText",this.yAxisTitle,this.marginLeft+this.layoutLeft+(m/2),this.height-v,this.axisTitleFont,this.axisTitleFontColor,"center","middle"])}}else{if(this.graphType=="Heatmap"){this.draw1DXLayout()}if(this.smpTitle&&this.graphType!="Heatmap"){if(this.graphOrientation=="vertical"){var s=this.legendPosition=="bottom"?this.getLegendHeight():0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var v=this.marginBottom+this.margin+(this.smpTitleFontSize/2)+s;this.addToRender(["drawText",this.smpTitle,this.marginLeft+this.layoutLeft+(m/2),this.height-v,this.smpTitleFont,this.smpTitleFontColor,"center","middle"])}else{this.addToRender(["drawText",this.smpTitle,this.marginLeft+this.margin+(this.smpTitleFontSize/2),this.height/2,this.smpTitleFont,this.smpTitleFontColor,"center","middle",-Math.PI/2])}}var k=this.getAxisDescription();var e=this.getAxisDescription(true);if(k!=""&&this.graphType!="Heatmap"&&this.xAxisShow){if(this.graphOrientation=="vertical"){this.addToRender(["drawText",k,this.marginLeft+this.margin+(this.axisTitleFontSize/2),this.height/2,this.axisTitleFont,this.axisTitleFontColor,"center","middle",-Math.PI/2])}else{var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var v=this.margin+(this.axisTitleFontSize/2)+this.getTitleSubtitleHeight();this.addToRender(["drawText",k,this.marginLeft+this.layoutLeft+(m/2),this.marginTop+v,this.axisTitleFont,this.axisTitleFontColor,"center","middle"])}}if(e!=""&&this.graphType!="Heatmap"&&this.xAxis2Show){if(this.graphOrientation=="vertical"){var s=this.legendPosition=="right"?this.getLegendWidth():0;var o=this.marginRight+this.margin+(this.axisTitleFontSize/2)+s;this.addToRender(["drawText",e,this.width-o,this.height/2,this.axisTitleFont,this.axisTitleFontColor,"center","middle",Math.PI/2])}else{var s=this.legendPosition=="bottom"?this.getLegendHeight():0;var m=this.width-(this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight);var v=this.marginBottom+this.margin+(this.axisTitleFontSize/2)+s;this.addToRender(["drawText",e,this.marginLeft+this.layoutLeft+(m/2),this.height-v,this.axisTitleFont,this.axisTitleFontColor,"center","middle"])}}}}};this.drawDOELabelsLayout=function(m){this.functionCaller="drawDOELabelsLayout";var g=this.foreground;var j=this.font;var e=this.measureText(m,j);var b=this.getFontPt(j)/2;var l=this.layoutWidth;var d=this.layoutHeight;var k=this.marginLeft+this.offsetX;var i=this.marginTop+this.offsetY;var a=k+l-5;var c=i+d-5;this.addToRender(["drawText",m,k+20,i,j,g,"left","top"]);this.addToRender(["drawLine","line",k+b,i+b,k+15,i+b,g]);this.addToRender(["drawLine","line",k+e+25,i+b,a,i+b,g]);this.addToRender(["drawLine","line",a,i+b,a,c,g]);this.addToRender(["drawLine","line",k+b,c,a,c,g]);this.addToRender(["drawLine","line",k+b,i+b,k+b,c,g])};this.setLayoutWeights=function(){var a=this.data.l.weight;var d=this.layoutParams;var e=this.data.l.comp;if(a){if(this.isDOE||this.scatterPlotMatrix||(this.data.l.vars&&this.data.l.smps)||this.segregateSamplesBy.length>1||this.segregateVariablesBy.length>1){for(var b=0;b<a.length;b++){d[b].weight=a[b]}}else{if(this.graphType=="Pie"){for(var b=0;b<e.length;b++){d[b].weight=a[b]}}else{for(var b=0;b<a.length;b++){d[b].weight=a[b]}}}}else{if(e){a=[];for(var b=0;b<e.length;b++){a[b]=e.length;d[b].weight=a[b]}}else{alert("Wuz going on dude? This aint't gonna work!")}}};this.setLayoutGraphTypes=function(){var b=this.data.l.type;if(b){for(var a=0;a<b.length;a++){this.layoutParams[a].graphType=b&&b[a]?b[a]:this.graphType}}};this.setLayoutIndices=function(f){if(!this.layoutIndices){for(var d=0;d<this.data.l.comp.length;d++){var a;var b=this.getObjectArray(this.varIndices);var e=this.getObjectArray(this.smpIndices);if(this.data.l.vars&&this.data.l.smps){a=[];for(var c=0;c<this.data.l.comp[d][0].length;c++){if(b.hasOwnProperty(this.data.l.comp[d][0][c])){a.push(this.data.l.comp[d][0][c])}}this.layoutParams[d].varIndices=a;a=[];for(var c=0;c<this.data.l.comp[d][1].length;c++){if(e.hasOwnProperty(this.data.l.comp[d][1][c])){a.push(this.data.l.comp[d][1][c])}}this.layoutParams[d].smpIndices=a;this.setOriginalIndices(d,this.layoutParams[d].varIndices,this.layoutParams[d].smpIndices)}else{if(this.data.l.comp[d]){a=[];if(this.data.l.vars){for(var c=0;c<this.data.l.comp[d].length;c++){if(b.hasOwnProperty(this.data.l.comp[d][c])){a.push(this.data.l.comp[d][c])}}this.layoutParams[d].varIndices=a;this.layoutParams[d].smpIndices=this.smpIndices;this.setOriginalIndices(d,this.layoutParams[d].varIndices,this.smpIndices)}else{for(var c=0;c<this.data.l.comp[d].length;c++){if(e.hasOwnProperty(this.data.l.comp[d][c])){a.push(this.data.l.comp[d][c])}}this.layoutParams[d].varIndices=this.varIndices;this.layoutParams[d].smpIndices=a;this.setOriginalIndices(d,this.varIndices,this.layoutParams[d].smpIndices)}}else{if(this.data.l.vars){this.layoutParams[d].varIndices=[];this.layoutParams[d].smpIndices=this.smpIndices}else{this.layoutParams[d].varIndices=this.varIndices;this.layoutParams[d].smpIndices=[]}}}this.layoutParams[d].varIndicesStart=-1;this.layoutParams[d].smpIndicesStart=-1}for(var d=0;d<this.data.l.type.length;d++){for(var c=0;c<f.length;c++){if(!this.layoutParams[d].hasOwnProperty(f[c])){this.layoutParams[d][f[c]]=this[f[c]]}}}this.layoutIndices=true}};this.resetLayout=function(){delete (this.data.l);delete (this.layoutParams);this.offsetX=0;this.offsetY=0;this.layoutValidN=false;this.layoutValidR=false;this.layoutValidC=false;this.layoutCurrent=false;this.layoutComb=false;this.layoutIndices=false;this.layoutRestore=false;this.layout="1X1"};this.setDOE=function(){this.oneDPlot(true);this.Scatter2D(true);this.Scatter3D(true);this.Pie(true)};this.setLayoutRestore=function(){if(!this.layoutRestore){this.layoutRestore={};var c=["title","subtitle","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart","smpTitle","showVariableNames","showSampleNames","showOverlays","showLegend","legendInside","showDecorationsLegend","xAxisShow","xAxis2Show","xAxisS2Show","yAxisShow","yAxisS2Show","xAxisTitle","xAxis2Title","yAxisTitle","legendLayout"];c.push("legendDecorationWidth");c.push("legendDecorationHeight");var a=["Color","Shape","Size","Pattern","Variable","Sample"];for(var b=0;b<a.length;b++){c.push("legend"+a[b]+"s");c.push("legend"+a[b]+"sMax");c.push("legend"+a[b]+"sN");c.push("legend"+a[b]+"sS");c.push("legend"+a[b]+"Width");c.push("legend"+a[b]+"Height")}for(var b=0;b<c.length;b++){this.layoutRestore[c[b]]=this[c[b]]}if(this.isGroupedData&&this.data.w){this.layoutRestore.isGroupedData=this.isGroupedData}}};this.setLayoutParams=function(){if(!this.layoutParams&&this.data.l.comp){this.layoutParams=[];for(var a=0;a<this.data.l.type.length;a++){this.layoutParams[a]={}}}};this.removeEmptyCompartments=function(){if(this.layoutRemoveEmpty&&this.layoutParams&&!this.isDOE){var f={};var d=[];var g=["comp","desc","name","type","vars","smps","weight"];var h=0;for(var c=0;c<g.length;c++){if(this.data.l[g[c]]){f[g[c]]=[]}}for(var c=0;c<this.data.l.weight.length;c++){var b=this.layoutParams[c].varIndices.length;var e=this.layoutParams[c].smpIndices.length;if(b&&e){d.push(this.layoutParams[c]);for(var a=0;a<g.length;a++){if(this.data.l[g[a]]){f[g[a]].push(this.data.l[g[a]][c])}}if(this.data.l.group){f.group=this.data.l.group}h++}}if(h!=this.data.l.weight.length){this.stndByLayoutData={};this.stndByLayoutData.data=this.cloneObject(this.data.l);this.stndByLayoutData.pars=this.cloneObject(this.layoutParams);this.stndByLayoutData.layoutRows=this.layoutRows;this.stndByLayoutData.layoutCols=this.layoutCols;this.stndByLayoutData.layout=this.layout;this.data.l=f;this.layoutParams=d;this.layoutRows=Math.ceil(Math.sqrt(h));this.layoutCols=this.layoutRows*(this.layoutRows-1)>=h?this.layoutRows-1:this.layoutRows;this.layout=this.layoutRows+"X"+this.layoutCols;for(var c=0;c<this.data.l.weight.length;c++){this.data.l.weight[c]=[1/this.layoutCols,1/this.layoutRows]}}}};this.restoreEmptyCompartments=function(){if(this.stndByLayoutData){this.data.l=this.stndByLayoutData.data;this.layoutParams=this.stndByLayoutData.pars;this.layoutRows=this.stndByLayoutData.layoutRows;this.layoutCols=this.stndByLayoutData.layoutCols;this.layout=this.stndByLayoutData.layout;delete (this.stndByLayoutData)}};this.drawLayoutCompartments=function(g){this.functionCaller="drawLayoutCompartments";var m=["left","right","top","bottom","x","y","offsetX","offsetY","graphType","summaryType","transformType","smpInfo","varInfo","minData","maxData","xAxisMin","xAxisMax","xAxisRange","xAxis2Min","xAxis2Max","xAxis2Range","yAxisMin","yAxisMax","yAxisRange","zAxisMin","zAxisMax","zAxisRange","xAxisAbsMin","xAxisAbsMax","xAxis2AbsMin","xAxis2AbsMax","yAxisAbsMin","yAxisAbsMax","zAxisAbsMin","zAxisAbsMax","xAxisUnit","xAxis2Unit","yAxisUnit","zAxisUnit"];var e=["weight","graphType","varIndices","smpIndices","grpIndices","varIndicesStart","smpIndicesStart","setMin","setMax","setMin2","setMax2","setMinX","setMaxX","setMinY","setMaxY","setMinZ","setMaxZ"];if(this.layoutComb){if(this.isDOE){m.push("data");this.setDOE()}this.removeEmptyCompartments();if(this.graphType.match(/Scatter/)){this.xAxis=this.data.y.smps;this.yAxis=this.data.y.smps;this.initAxes()}else{if(this.data.l&&this.data.l.group){this.groupSamples(this.data.l.group,false,false,true,true);this.meta.data.g=this.data.w;this.initAxes()}else{this.initAxes(true)}}this.setLayoutDimensions();var s=this.marginLeft+this.layoutLeft+this.layoutRight+this.marginRight;var p=this.marginTop+this.layoutTop+this.layoutBottom+this.marginBottom;this.setLayoutRestore();this.setLayoutParams();this.title="";this.subtitle="";this.offsetX=this.layoutLeft;this.offsetY=this.graphType=="Pie"?0:this.layoutTop;this.setLayoutWeights();this.setLayoutGraphTypes();this.setLayoutIndices(e);var q=0;for(var o=0;o<this.layoutRows;o++){for(var n=0;n<this.layoutCols;n++){this.layoutCurrent=q;if(this.isDOE){if(this.dataStndBy.l.smps.length<=q){break}}else{if(this.graphType=="Pie"){if(this.data.l.smps.length<=q){break}}else{if(this.layoutParams.length<=q){break}}}if(this.layoutParams[q]){for(var l=0;l<e.length;l++){this[e[l]]=this.layoutParams[q].hasOwnProperty(e[l])?this.layoutParams[q][e[l]]:this[e[l]]}}this.setLayoutGraphDimensions(s,p,q);if(this.isDOE){this.drawLayoutCompartmentsDOE(s,p,q)}else{if(this.graphType.match(/Scatter/)){this.drawLayoutCompartmentsScatter(s,p,o,n,q)}else{if(this.graphType=="Pie"){this.drawLayoutCompartmentsPie(s,p,q)}else{this.drawLayoutCompartmentsOneD(s,p,q)}}}if(!this.isDOE&&this.varIndices.length>0&&this.smpIndices.length>0){g.call(this)}for(var l=0;l<m.length;l++){this.layoutParams[q][m[l]]=this.cloneObject(this[m[l]])}if(this.data.w){this.layoutParams[q].w=this.cloneObject(this.data.w)}if(this.layoutCanvasCompartments){this.drawLayoutCanvasCompartments()}if(this.isDOE||this.graphType=="Pie"){}else{if(this.graphType.match(/Scatter/)){var f,d;this.functionCaller="drawLayoutCompartmentsBox";if(o==n&&this.scatterPlotMatrixType.match(/complete/)){f=this.scaleTextToFont(this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-s)*0.7/this.layoutCols,this.y);this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),this.x,this.y,false,this.foreground,"open"]);this.addToRender(["drawText",this.data.y.smps[o],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top+(this.y/2),f,this.foreground,"center","middle"])}else{if(!this.scatterPlotMatrixType.match(/complete/)&&this.data.y.smps[q+1]){d=this.axisTitleFontSize+this.margin+this.margin;f=this.scaleTextToFont(this.meta.data.y.maxSmpStr+" & "+this.meta.data.y.maxSmpStr,this.maxTextSize,(this.width-s)*0.8/this.layoutCols,d);if(this.layoutBoxLabelColors[0]){this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(d/2),this.x,d,this.layoutBoxLabelColors[0],this.foreground])}else{this.addToRender(["drawShape","rectangle",this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(d/2),this.x,d,false,this.foreground,"open"])}this.addToRender(["drawText",this.data.y.smps[0]+" & "+this.data.y.smps[q+1],this.marginLeft+this.offsetX+this.left+(this.x/2),this.marginTop+this.offsetY+this.top-(d/2),f,this.foreground,"center","middle"])}}this.functionCaller="drawLayoutCompartments"}else{if(!this.layoutAdjust){var r=this.graphOrientation=="vertical"?n:o;var b=this.graphOrientation=="vertical"?this.layoutCols-1:this.layoutRows-1;if(r==0&&this.layoutRestore.xAxisShow&&this.graphType!="Heatmap"){this.layoutAxis=1;this.xAxisShow=true;this.draw1DXLayout()}if(r==b&&this.layoutRestore.xAxis2Show&&this.graphType!="Heatmap"){this.layoutAxis=2;this.xAxis2Show=true;this.draw1DXLayout()}}if(this.segregateVariablesBy.length){var a=false;if(this.graphOrientation=="vertical"){if(o==this.layoutRows-1){a=true}else{if(o==this.layoutRows-2&&(q+1+parseInt(this.layoutCols))>this.data.l.weight.length){a=true}}}else{if(n==0){a=true}}if(a){this.showSampleNames=this.layoutRestore.showSampleNames;this.draw1DYLayout()}}if(this.graphType!="Candlestick"){this.draw1DLabels(q)}}}this.offsetX+=this.layoutWidth;q++}this.offsetX=this.layoutLeft;this.offsetY+=this.layoutHeight}this.layoutCurrent=false;this.restoreLayoutParameters();if(this.isDOE){this.data=this.dataStndBy;this.graphType=this.data.l.type[0]}else{this.drawTitle();this.drawLabelsTitlesLayout();if(this.showLegend){if(this.isDOE||this.graphType!="Pie"){this.drawLegend(true)}}}if(this.meta.data.g){this.data.w=this.meta.data.g;delete (this.meta.data.g)}else{this.isGroupedData=false}}};this.restoreLayoutParameters=function(){for(var a in this.layoutRestore){this[a]=this.layoutRestore[a]}};this.setLayoutGraphDimensions=function(a,b,d){this.layoutWidth=(this.width-a)*this.layoutParams[d].weight[0];this.layoutHeight=(this.height-b)*this.layoutParams[d].weight[1];this.layoutParams[d].width=this.layoutWidth;this.layoutParams[d].height=this.layoutHeight};this.drawLayoutCompartmentsDOE=function(a,b,d){this.legendPosition="right";this.graphOrientation="vertical";if(d==0&&this.showDOEData){this.isShowDOEData=true;this.showLegend=this.layoutRestore.showLegend;if(this.graphType.match(/Scatter/i)){this.isHistogram=false;this.xAxis=this.configStndBy.xAxis;this.yAxis=this.configStndBy.yAxis;this.xAxisTitle=this.configStndBy.xAxisTitle;this.yAxisTitle=this.configStndBy.yAxisTitle;this.initAxes();this.initializeData(this.dataStndBy);this.varIndices=this.dataStndBy.l.doe}else{this.initializeData(this.dataStndBy);this.smpIndices=this.dataStndBy.l.doe}this.showLegend=false;if(this.graphType=="Scatter3D"){this.draw3DPlot()}else{if(this.graphType.match(/Scatter/i)){this.draw2DPlot()}else{this.plotByVariable=this.configStndBy.plotByVariable;if(this.configStndBy.groupingFactors.length>0){this.isGroupedData=true;if(this.dataStndBy.y.smps.length!=this.smpIndices.length){this.layoutComb=false;this.groupSamples(this.configStndBy.groupingFactors,false,false,true,true);this.layoutComb=true}this.draw1DPlot();this.isGroupedData=false}else{this.draw1DPlot()}this.plotByVariable=false}}this.showLegend=true;this.isShowDOEData=false}else{this.drawDOELabelsLayout(this.dataStndBy.l.smps[d][0]);this.top=5;this.bottom=5;this.right=5;this.left=5;if(this.dataStndBy.l.type[d]=="Pie"){this.showLegend=true;this.createPie(this.dataStndBy.l.smps[d][0]);this.graphType="Pie";this.layoutCurrentDOE=this.dataStndBy.l.smps[d][0];this.legendBox=false;this.drawPiePlot()}else{if(this.dataStndBy.l.type[d]=="Treemap"){this.createTreemap(this.dataStndBy.l.smps[d][0]);this.graphType="Treemap";this.draw1DPlot()}else{if(this.dataStndBy.l.type[d]=="Scatter2D"){this.createHistogram(false,false,this.dataStndBy.l.smps[d][0]);this.graphType="Scatter2D";this.initAxes();this.showLegend=false;this.xAxisTitle="";this.yAxisTitle="";this.draw2DPlot()}}}}};this.drawLayoutCompartmentsScatter=function(a,e,d,b,f){if(this.data.l.smps[f].xAxis&&this.data.l.smps[f].yAxis){this.xAxis=this.data.l.smps[f].xAxis;this.yAxis=this.data.l.smps[f].yAxis;this.xAxisIndices=this.getSampleIndices(this.xAxis);this.yAxisIndices=this.getSampleIndices(this.yAxis)}else{this.xAxis=false;this.yAxis=false;this.xAxisIndices=false;this.yAxisIndices=false}if(this.layoutAdjust&&this.xAxis&&this.yAxis){this.initAxes();this.layoutAxis=3}else{this.layoutAxis=b==0?2:0;this.layoutAxis=d==this.layoutRows&&this.layoutAxis?3:d==this.layoutRows?1:0}if(this.data.l.reg){if(this.data.l.reg[f]){if(this.decorations){delete (this.decorations)}this.addRegressionDecoration(this.data.l.reg[f].reg,this.data.l.reg[f].lab,this.data.l.reg[f].col)}}this.showLegend=false;this.legendInside=true;this.showDecorationsLegend=true;this.xAxisTitle="";this.yAxisTitle="";if(!this.layoutAdjust){this.xAxisShow=false;this.yAxisShow=false;this.xAxisS2Show=false;this.yAxisS2Show=false;if(d==0&&b%2>0){this.xAxisS2Show=true}if(d==this.layoutRows-1&&b%2==0){this.xAxisShow=true}if(b==0&&d%2>0){this.yAxisShow=true}if(b==this.layoutCols-1&&d%2==0){this.yAxisS2Show=true}}};this.drawLayoutCompartmentsPie=function(a,b,d){this.smpIndices=[this.getSampleIndices(this.data.l.smps[d])];this.showLegend=true};this.drawLayoutCompartmentsOneD=function(b,d,e){if(this.graphType=="Candlestick"){this.xAxisShow=true;this.xAxis2Show=true;this.xAxisTitle=true;this.xAxis2Title=true;if(e==1){this.summaryType="volume";if(this.showVolume){this.showSampleNames=true}}else{this.summaryType="candle";this.showSampleNames=false}}else{this.showLegend=false;this.showOverlays=true;this.isGroupedData=false;this.xAxisTitle=false;this.xAxis2Title=false;this.smpTitle=false;this.adjustAspectRatioXTries=0;this.adjustAspectRatioYTries=0;this.layoutLabels=[];if(this.segregateSamplesBy.length>0&&this.segregateVariablesBy.length>0){this.layoutLabels.push(this.data.l.name[e][0]);this.layoutLabels.push(this.data.l.name[e][1])}else{if(this.segregateSamplesBy.length>1||this.segregateVariablesBy.length>1){this.layoutLabels.push(this.data.l.name[e][1]);this.layoutLabels.push(this.data.l.name[e][0])}else{this.layoutLabels.push(this.data.l.name[e])}}if(this.varIndices.length>0&&this.smpIndices.length>0){if(this.data.l.group){var a=this.layoutParams[e].dragged?this.layoutParams[e].grpIndices:false;this.groupSamples(this.data.l.group,false,a,true,true,true);this.layoutParams[e].grpIndices=this.grpIndices;if(this.colorBy&&this.isInArray(this.colorBy,this.groupingFactors)&&this.layoutRestore.showLegend){this.showSampleNames=false}if(this.data.w.smps.length==1&&this.graphType!="Heatmap"&&this.isInArray(this.data.l.group,this.segregateSamplesBy)){this.showSampleNames=false}}else{if(this.smpIndices.length==1&&this.graphType!="Heatmap"){this.showSampleNames=false}}if(this.segregateVariablesBy.length>0&&this.graphType!="Heatmap"){this.showSampleNames=false}if(this.layoutAdjust){this.layoutAxis=3;if(this.varIndices.length>0&&this.smpIndices.length>0){this.initAxes()}}else{if(this.graphOrientation=="vertical"){this.xAxisShowLayout=!(e%this.layoutCols)?true:false}else{this.xAxisShowLayout=e<this.layoutCols?true:false;this.xAxis2ShowLayout=e>=this.layoutCols*(this.layoutRows-1)?true:false}this.xAxisShow=false;this.xAxis2Show=false}}}};this.draw1DLabels=function(j){this.functionCaller="draw1DLabels";if(this.layoutValid){var e=this.layoutCollapse?this.marginLeft+this.offsetX:this.marginLeft+this.offsetX+this.margin;var o=this.marginTop+this.offsetY;var k=this.layoutWidth;var d=k/2;var g=this.getFontHeight()+(this.margin*2);var b=g/2;var a=this.layoutHeight-((this.layoutLabels.length*g)+(this.margin*(this.layoutCollapse?0:1)));if(this.graphOrientation!="vertical"&&this.graphType!="Heatmap"&&!this.layoutAdjust){if(j>=this.layoutCols){a-=this.getAxisTitleTickLength()}}if(!this.layoutCollapse){if(this.layoutAdjust){k=this.x;e+=this.left-this.margin;d=k/2;a=this.y}else{k-=this.margin*2}}for(var f=0;f<this.layoutLabels.length;f++){if(this.layoutBoxLabelColors[f]){this.addToRender(["drawShape","rectangle",e+(k/2),o+(g/2),k,g,this.layoutBoxLabelColors[f],this.layoutBoxShow?this.foreground:this.layoutBoxLabelColors[f]],false,false,null,true)}else{if(this.layoutBoxShow){this.addToRender(["drawShape","rectangle",e+(k/2),o+(g/2),k,g,false,this.foreground,"open"],false,false,null,true)}}this.addToRender(["drawText",this.layoutLabels[f],e+d,o+b,this.font,this.foreground,"center","middle"]);o+=g}if(this.graphOrientation!="vertical"&&this.xAxisShow){o=this.marginTop+this.offsetY+this.top}if(this.layoutBoxShow){this.addToRender(["drawShape","rectangle",e+(k/2),o+(a/2),k,a,false,this.foreground,"open"],false,false,null,true)}}};this.initializeLayout=function(){this.isValidLayout()};this.initializeLayout()};CanvasXpress.prototype.initViewport=function(a){this.setViewport=function(){var d=this.$("container-"+this.target);if(!d){var G=this.$(this.target);G.className="CanvasXpress";G.style.visibility=this.debug?"visible":"hidden";var A=G.parentNode;if(!A.id){A.id=this.target+"ParentNode"}this.targetParentNode=A.id;this.targetParentNodeResponsive=false;this.targetParentNodeAspectRatio=[];var D=G.getAttribute("responsive");var y=G.getAttribute("aspectRatio");var f=G.getAttribute("resizable");if(f){if(f=="both"){this.resizable=true;this.resizableX=true;this.resizableY=true}else{if(f=="x"||f=="X"){this.resizable=true;this.resizableX=true;this.resizableY=false}else{if(f=="y"||f=="Y"){this.resizable=true;this.resizableX=false;this.resizableY=true}else{if(f=="none"){this.resizable=false;this.resizableX=false;this.resizableY=false}}}}}if(D){this.targetParentNodeResponsive=true;var m=y?y.split(/:/):[];if(A.clientWidth){G.width=A.clientWidth}else{G.width=250}if(m.length==2){m[0]=m[0]?parseInt(m[0]):1;m[1]=m[1]?parseInt(m[1]):1;G.height=parseInt(G.width*m[1]/m[0])}else{if(A.clientHeight){G.height=A.clientHeight}else{G.height=250}}this.targetParentNodeAspectRatio=[G.width,G.height]}G.width=G.originalWidth=parseInt(G.width);G.height=G.originalHeight=parseInt(G.height);G.style.width=G.width+"px";G.style.height=G.height+"px";var x=this.$cX("canvas",{id:this.target+"-events",className:"CanvasXpress",width:G.width,height:G.height},{position:"absolute",left:0,top:0,visibility:this.debug?"visible":"hidden"});this.target2=this.target+"-events";var h=this.$cX("canvas",{id:this.target+"-transitions0",className:"CanvasXpress",width:G.width,height:G.height},{position:"absolute",left:0,top:0,visibility:"hidden"});this.target3=this.target+"-transitions0";var g=this.$cX("canvas",{id:this.target+"-transitions1",className:"CanvasXpress",width:G.width,height:G.height},{position:"absolute",left:0,top:0,visibility:"hidden"});this.target4=this.target+"-transitions1";var d=this.$cX("div",{id:"container-"+this.target,className:"CanvasXpressContainer"});var C=this.$cX("div",{id:this.leafletId||this.target+"-leafletId",className:"CanvasXpressMap"},{width:G.width+"px",height:G.height+"px"});if(this.isMap){G.style.position="absolute";G.style.left="0px";G.style.top="0px"}if(a){d.style.display="none"}var I=this.$cX("div",{id:"northest-container-"+this.target,className:"CanvasXpressContainer"},{width:G.width+"px",clear:"left"});var u=this.$cX("div",{id:"northest-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:G.width+"px"});var k=this.$cX("div",{id:"north-container-"+this.target,className:"CanvasXpressContainer"},{width:G.width+"px",height:"0px",clear:"left"});var H=this.$cX("div",{id:"north-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:G.width+"px",height:"0px"});var K=this.$cX("div",{id:"middle-container-"+this.target,className:"CanvasXpressContainer"},{width:G.width+"px",height:G.height+"px",clear:"left"});var n=this.$cX("div",{id:"west-container-"+this.target,className:"CanvasXpressContainer"},{width:"0px",height:G.height+"px",cssFloat:"left"});var J=this.$cX("div",{id:"west-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:G.height+"px"});var e=this.$cX("div",{id:"center-wrapper-"+this.target,className:"CanvasXpressWrapper"});var j=this.$cX("div",{id:"east-container-"+this.target,className:"CanvasXpressContainer"},{width:"0px",height:G.height+"px"});var F=this.$cX("div",{id:"east-wrapper-"+this.target,className:"CanvasXpressWrapper"},{width:"0px",height:G.height+"px"});var b=this.$cX("div",{id:"south-container-"+this.target,className:"CanvasXpressContainer"},{width:G.width+"px",height:"0px",clear:"left"});var z=this.$cX("div",{id:"south-wrapper-"+this.target,className:"CanvasXpressWrapper",state:"open"},{width:G.width+"px",height:"0px"});I.appendChild(u);k.appendChild(H);n.appendChild(J);j.appendChild(F);b.appendChild(z);K.appendChild(n);K.appendChild(e);K.appendChild(j);d.appendChild(I);d.appendChild(k);d.appendChild(K);d.appendChild(b);if(this.isVideo){var q=this.$(this.target+"-cX-Video");if(!q){q=this.$cX("video",{id:this.target+"-cX-Video",autoplay:false,controls:this.videoControls,loop:this.videoLoop,preload:this.videoPreload,poster:this.videoPoster,dataSet:this.videoData,width:this.meta.canvas.ctx.canvas.width,height:this.meta.canvas.ctx.canvas.height,className:this.videoClassName});var r=[];var B=this.backgroundVideo;if(B&&!(B.propertyIsEnumerable("length"))&&typeof B==="object"&&typeof B.length==="number"){r=B}else{r.push(this.backgroundVideo)}for(var E=0;E<r.length;E++){var w=this.$cX("source",{src:r[E],type:r[E].match(/mp4$/)?"video/mp4":r[E].match(/webm$/)?"video/webm":"video/ogv"});q.appendChild(w)}}G.parentNode.insertBefore(d,G);e.appendChild(G.parentNode.appendChild(G));G.parentNode.insertBefore(q,G);G.parentNode.appendChild(x)}else{G.parentNode.insertBefore(d,G);e.appendChild(G.parentNode.appendChild(G));if(this.isMap){G.parentNode.appendChild(C)}G.parentNode.appendChild(x);G.parentNode.appendChild(h);G.parentNode.appendChild(g)}this.meta.canvas.ctx2=x.getContext("2d");this.meta.canvas.ctx2.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);this.meta.canvas.ctx3=h.getContext("2d");this.meta.canvas.ctx3.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0);this.meta.canvas.ctx4=g.getContext("2d");this.meta.canvas.ctx4.setTransform(this.meta.canvas.canvasPixelRatio,0,0,this.meta.canvas.canvasPixelRatio,0,0)}};this.resizeViewportNorth=function(){var f=this.$("west-container-"+this.target);var e=this.$("east-container-"+this.target);var c=this.$("northest-container-"+this.target);var d=this.$("northest-wrapper-"+this.target);var g=this.$("north-container-"+this.target);var b=this.$("north-wrapper-"+this.target);if(f&&e&&c&&d&&g&&b){c.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";d.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";g.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";b.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";g.style.height="0px";b.style.height="0px"}};this.resizeViewportWest=function(){var e=this.$(this.target+"-cX-Configurator");var b=this.$("west-container-"+this.target);var d=this.$("west-wrapper-"+this.target);if(b&&d){b.style.width="0px";d.style.width="0px";b.style.height=this.meta.canvas.ctx.canvas.height+"px";d.style.height=this.meta.canvas.ctx.canvas.height+"px"}};this.resizeViewportEast=function(){var d=this.$(this.target+"-cX-DataFilter");var b=this.$("east-container-"+this.target);var c=this.$("east-wrapper-"+this.target);if(b&&c){b.style.width="0px";c.style.width="0px";b.style.height=this.meta.canvas.ctx.canvas.height+"px";c.style.height=this.meta.canvas.ctx.canvas.height+"px"}};this.resizeViewportSouth=function(c){var h=this.$(this.target+"-cX-DataTable");var f=this.$("west-container-"+this.target);var e=this.$("east-container-"+this.target);var g=this.$("south-container-"+this.target);var b=this.$("south-wrapper-"+this.target);if(h&&f&&e&&g&&b){if(c){g.style.height=parseInt(h.style.height)+"px";b.style.height=parseInt(h.style.height)+"px";g.style.width=parseInt(h.style.width)+"px";b.style.width=parseInt(h.style.width)+"px"}else{g.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";b.style.width=(parseInt(f.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(e.style.width))+"px";g.style.height="0px";b.style.height="0px"}}};this.resizeViewport=function(){var d=this.$("middle-container-"+this.target);var b=this.$("east-container-"+this.target);var c=this.$("west-container-"+this.target);if(d&&b&&c){this.resizeViewportWest();this.resizeViewportEast();this.resizeViewportNorth();this.resizeViewportSouth();d.style.width=(parseInt(c.style.width)+this.meta.canvas.ctx.canvas.width+parseInt(b.style.width)+0)+"px";d.style.height=(this.meta.canvas.ctx.canvas.height+0)+"px"}};this.resizeViewportMiddle=function(b,d){var f=this.$("middle-container-"+this.target);var c=this.$("east-container-"+this.target);var e=this.$("west-container-"+this.target);if(f&&c&&e){this.resizeViewportWest();this.resizeViewportEast();this.resizeViewportNorth();this.resizeViewportSouth();f.style.width=(parseInt(e.style.width)+b+parseInt(c.style.width)+0)+"px";f.style.height=(d+0)+"px"}};this.resetViewportOverflow=function(c){if(c){var b=this.$(c+"-wrapper-"+this.target);if(b){b.style.overflow="visible"}}};this.initializeViewport=function(){this.setViewport()};this.initializeViewport()};CanvasXpress.prototype.initMenus=function(){this.addMenu=function(A,a,n,b,g,d,t,z){if(this.disableMenu){return}var p;var o;var j=this.$("north-wrapper-"+this.target);var c=this.$("west-container-"+this.target);this.resetLinkDiv();if(j&&c){if(a){o=this.newId("-cX-Menu-");p=this.$cX("div",{id:o,className:"CanvasXpressMenu draggable",par:n},{left:"0px",top:"0px",zIndex:this.menuIndex++,display:"none"})}else{this.removeMenus();if(b){a=b;g+=c.offsetWidth}else{a=this.setMenu();var v=this.getTargetEvent(A);var B=this.adjustedCoordinates(A,this.isMap?false:v);if(z){g=8;d=8}else{g=B.x+c.offsetWidth;d=B.y}}o=this.newId("-cX-Menu-");p=this.$cX("div",{id:o,className:"CanvasXpressMenu draggable"},{left:g+"px",top:d+"px",zIndex:this.menuIndex++})}var k=this.$cX("ul",{id:this.newId("-cX-List-"),className:"CanvasXpressList",header:t});p.appendChild(k);j.appendChild(p);var s=this.maxSubMenus;var q=a.length>s?s:a.length;if(a.length>s){k.rawMenu=a;k.rawMenuIndex=0;this.addMenuItemScroller(k,"Top")}for(var r=0;r<q;r++){if(a[r][0]=="-"){this.addMenuItemSep(k)}else{if(a[r][0]=="-text-"){this.addMenuItemText(a[r],k)}else{if(a[r][0]=="-color-"){this.addMenuItemColor(a[r],k)}else{if(a[r][0]=="-slider-"){this.addMenuItemSlider(a[r],k)}else{if(a[r][0]=="-filter-"){this.addMenuItemFilter(a[r],k)}else{this.addMenuItem(a[r],k)}}}}}}if(a.length>s){this.addMenuItemScroller(k,"Bottom")}}return o};this.pageMenuItem=function(e,f){var g,j,a,i;var h=e.rawMenuMatch||e.rawMenu;if(h){var d=e.childNodes.length-2;if(f=="Top"&&e.rawMenuIndex>0){g=e.childNodes[e.childNodes.length-2];j=h[e.rawMenuIndex-1];a=e.childNodes[2];i=true;e.rawMenuIndex--}else{if(f=="Bottom"&&h.length>(e.rawMenuIndex+d)){g=e.childNodes[2];j=h[e.rawMenuIndex+d];a=e.childNodes[e.childNodes.length-1];i=true;e.rawMenuIndex++}}if(i){this.addRemoveItemListeners("removeEvtListener",g);g.parentNode.removeChild(g);if(j[0]=="-"){this.addMenuItemSep(e,a)}else{if(j[0]=="-text-"){this.addMenuItemText(j,e,a)}else{if(j[0]=="-color-"){this.addMenuItemColor(j,e,a)}else{if(j[0]=="-slider-"){this.addMenuItemSlider(j,e,a)}else{if(j[0]=="-filter-"){this.addMenuItemFilter(j,e,a)}else{this.addMenuItem(j,e,a)}}}}}}}};this.filterScrollSearch=function(b){var k=this.$(b);if(k){var c=k.value;var n=new RegExp(k.value,"i");var h=k.parentNode.parentNode;var j=h.rawMenu;var f=[];for(var e=0;e<j.length;e++){if(j[e][0].match(n)){f.push(j[e])}}if(f.length!=j.length){h.rawMenuMatch=f}else{delete (h.rawMenuMatch)}while(h.childNodes.length>0){var d=h.childNodes[0];this.addRemoveItemListeners("removeEvtListener",d);h.removeChild(d)}var m=this.maxSubMenus;var g=f.length>m?m:f.length;h.rawMenuIndex=0;var a=this.addMenuItemScroller(h,"Top",c);for(var e=0;e<g;e++){this.addMenuItem(f[e],h)}this.addMenuItemScroller(h,"Bottom");a.focus();a.value=c}};this.addMenuItemSep=function(d,a){var c=this.$cX("li",{id:this.newId("-cX-List-Item-Sep-"),className:"CanvasXpressListItemSep"});var e=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Sep-"),className:"CanvasXpressListItemTextSep",innerHTML:"&nbsp;"});c.appendChild(e);if(a){a.parentNode.insertBefore(c,a)}else{d.appendChild(c)}};this.addMenuItemScroller=function(c,d){var b=this.$cX("li",{id:this.newId("-cX-List-Item-Scroll-"+d),className:"CanvasXpressListItemScroll"+d});var f=this.$cX("span",{id:this.newId("-cX-List-Item-Text-Scroll-"+d),className:"CanvasXpressListItemTextScroll"+d,innerHTML:"&nbsp;"});b.appendChild(f);c.appendChild(b);this.addRemoveItemListeners("addEvtListener",b);if(d=="Top"){var a=this.$cX("li",{id:this.newId("-cX-List-Item-Scroll-Search"),className:"CanvasXpressListItemScrollSearch"+d});var e=this.$cX("input",{id:this.newId("-cX-List-Item-Scroll-Search-Input"),className:"CanvasXpressListItemScrollSearch",type:"text",placeholder:" Search menu"});a.appendChild(e);c.appendChild(a);return e}};this.getMenuItemValue=function(d){if(d[2][2]){var c=this.cloneObject(d[2][2]);var b=this;while(c.length>0){var a=c.shift();if(b[a]){b=b[a]}else{return""}}return b!=null?b:""}else{return this[d[2][0]]||""}};this.addMenuItem=function(d,n,k){var j=this.newId("-cX-List-Item-");var e=this.$cX("li",{id:j,className:"CanvasXpressListItem",click:d[2],params:d[3]||[],upload:d[0]&&d[0]=="Load"?true:false,uploadParams:d[0]&&d[0]=="Load Parameters"?true:false});var m;if(d[5]){m=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemAArrow",hidefocus:"true",unselectable:"on",href:"#",menu:j,menuId:"false",menuFunc:d[5],menuParm:d[6],title:"Drag to position menu",draggable:false})}else{m=this.$cX("a",{id:this.newId("-cX-List-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#",menuFunc:d[2],menuParm:d[3],draggable:false})}var g=this.$cX("img",{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:d[1]&&CanvasXpress.images[d[1]]?CanvasXpress.images[d[1]]:CanvasXpress.images.canvasXpress,key:d[1]});var p;if(d[0]&&(d[0]=="Load"||d[0]=="Load Parameters")){p=this.$cX("span",{id:this.newId("-cX-List-Item-Text-"),className:"CanvasXpressListItemText",draggable:false},{marginRight:0});var h=this.$cX("input",{id:this.newId("-cX-List-Item-Text-File-Upload"),className:"CanvasXpressListItemText",type:"file",draggable:false},{color:"transparent",width:"100px"});p.appendChild(h)}else{p=this.$cX("span",{id:this.newId("-cX-List-Item-Text-"),className:"CanvasXpressListItemText",innerHTML:d[0]||"",draggable:false})}var c=this.$cX("span",{className:"CanvasXpressListItemTextShort",innerHTML:d[4]||"",draggable:false});m.appendChild(g);m.appendChild(p);m.appendChild(c);e.appendChild(m);if(k){k.parentNode.insertBefore(e,k)}else{n.appendChild(e)}this.addRemoveItemListeners("addEvtListener",e)};this.addMenuItemText=function(c,m,j){var h=this.newId("-cX-List-Item-Text-");var f=this.newId("-cX-List-Item-Text-Input-");var d=this.getMenuItemValue(c);var e=this.$cX("li",{id:h,className:"CanvasXpressListItem",click:c[1],params:[c[2],f]});var n=this.$cX("input",{id:f,className:"CanvasXpressList",type:"text",value:d});var k=this.$cX("a",{id:this.newId("-cX-List-Text-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"});var g=this.$cX("img",{id:this.newId("-cX-List-Text-Icon-"),className:"CanvasXpressListIcon",src:CanvasXpress.images.refreshForm,key:"refreshForm"},{marginTop:"4px"});k.appendChild(g);k.appendChild(n);e.appendChild(k);if(j){j.parentNode.insertBefore(e,j)}else{m.appendChild(e)}this.addRemoveItemListeners("addEvtListener",e)};this.addMenuItemColor=function(E,v,L){var m=this.newId("-cX-List-Item-Color-");var n=this.newId("-cX-List-Item-Color-Container-");var g=this.newId("-cX-List-Item-Color-Current-");var B=this.newId("-cX-List-Item-Color-Palete-");var f=this.newId("-cX-List-Item-Color-Palete-Current-");var k=this.newId("-cX-List-Item-Color-Saturation-");var w=this.newId("-cX-List-Item-Color-Saturation-Current-");var N=this[E[2][0]]||"";var G=this.$cX("li",{id:m,className:"CanvasXpressListItem",click:E[1],params:[E[2],g],palete:B,paleteCurrent:f,colorCurrent:g,saturation:k,saturationCurrent:w});var M=this.$cX("a",{id:this.newId("-cX-List-Color-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"},{height:"126px"});var I=this.$cX("img",{id:this.newId("-cX-List-Color-Icon-"),className:"CanvasXpressListIcon",src:CanvasXpress.images.refreshForm,key:"refreshForm"},{marginTop:"2px"});var J=N?this.rgbToHex(this.validateColor(N.replace(/[\'\"]/g,""))):this.foreground;this.colorRGBfromString(J);var t=Math.round(this.colorHSV[0]/6*180);var r=Math.round((1-this.colorHSV[1])*100);var q=Math.round((1-this.colorHSV[2])*100);var K=this.$cX("div",{id:n},{width:"188px",height:"130px",cssFloat:"left"});var C=this.$cX("div",{id:g,parentItem:m,className:"CanvasXpressConfiguratorColor",value:N},{width:"203px",height:"16px",cssFloat:"left",marginBottom:"5px",cursor:"default"});var D=this.$cX("div",{id:B,parentItem:m,className:"CanvasXpressConfiguratorColorMain"},{position:"relative",left:"0px",top:"0px",width:"181px",height:"101px"});var d=this.$cX("div",{id:f,parentItem:m,className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:(t-7)+"px",top:(r-7)+"px",width:"195px",height:"115px"});D.appendChild(d);var A=this.$cX("div",{id:k,parentItem:m,className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"188px",top:"-102px",width:"15px",height:"100px",border:"1px solid rgb(51,122,183)",clear:"left",cursor:"crosshair"});for(var H=0;H<100;H+=4){var F=this.$cX("div",false,{height:"4px",position:"relative",left:"0px",cursor:"crosshair"});A.appendChild(F)}var e=this.$cX("div",{id:w,parentItem:m,className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:"0px",top:(q-108)+"px",width:"29px",height:"115px"});A.appendChild(e);K.appendChild(C);K.appendChild(D);K.appendChild(A);M.appendChild(I);M.appendChild(K);G.appendChild(M);if(L){L.parentNode.insertBefore(G,L)}else{v.appendChild(G)}this.colorizeCurrentItemColor(G);this.colorizeSaturationItemColor(G);this.addRemoveItemListeners("addEvtListener",G)};this.colorizeCurrentItemColor=function(a){var e=this.$(a.colorCurrent);if(e){var d=this.colorRGBToString();var b=this.hexToRgb("#"+d);e.style.backgroundColor="#"+d;e.innerHTML="&nbsp;&nbsp;"+b;e.style.color=this.complementaryColor(b,true);e.value=b}};this.colorizeSaturationItemColor=function(a){var d=function(m,k,c,j,h){return"rgb("+(m*(1-j/h)*100)+"%,"+(k*(1-j/h)*100)+"%,"+(c*(1-j/h)*100)+"%)"};var f=this.$(a.saturation);if(f&&this.colorHSV){var g=f.childNodes;var b=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],1);if(b){for(var e=0;e<g.length-1;e++){g[e].style.backgroundColor=d(b[0],b[1],b[2],e,g.length-1)}}}};this.updateColorItemValue=function(b,c){if(!b){var g=this.getMenuItemComp(c);if(g){b=g[0]}else{return false}}if(this.changingColorItemOn){if(this.changingColorItemOn=="palette"){var a=this.$(b.palete);var h=this.$(b.paleteCurrent);if(a&&h){var j=this.adjustedCoordinates(c,a);if(j){var i=Math.min(Math.max(0,j.x),181);var f=Math.min(Math.max(0,j.y-25),101);h.style.left=(i-7)+"px";h.style.top=(f-7)+"px";this.colorFromHsv(i*6/180,1-f/100,null);this.colorizeCurrentItemColor(b);this.colorizeSaturationItemColor(b)}}}else{var k=this.$(b.saturation);var d=this.$(b.saturationCurrent);if(k&&d){var j=this.adjustedCoordinates(c,k);if(j){var f=Math.min(Math.max(0,j.y-25),101);d.style.top=(f-108)+"px";this.colorFromHsv(null,null,1-f/100);this.colorizeCurrentItemColor(b)}}}}return false};this.endColorItemChange=function(a){this.changingColorItemOn=false};this.addMenuItemSlider=function(q,m,I){var f=this.newId("-cX-List-Item-Slider-");var e=this.newId("-cX-List-Item-Slider-Container-");var E=this.newId("-cX-List-Item-Slider-Table-");var K=q[2][0]||"";var D=this.formatNumber(this.binConfigurations[K]["max"],this.binConfigurations[K]["dec"]);var v=this.$cX("li",{id:f,className:"CanvasXpressListItem",click:q[1],params:[q[2][0],e],slider:K});var J=this.$cX("a",{id:this.newId("-cX-List-Slider-Item-A-"),className:"CanvasXpressListItemA",hidefocus:"true",unselectable:"on",href:"#"});var H=this.$cX("div",{id:e,className:"CanvasXpressList"});var n=this.$cX("table",{id:E,className:"CanvasXpressListItemTable"},{width:"100%"});var g=this.$cX("tbody");var h=D.length*8;for(var B=0;B<this.binConfigurations[K]["n"];B++){var s=Number(B>0?this.binConfigurations[K]["bins"][B-1]["value"]:this.binConfigurations[K]["min"]);var A=Number(B<this.binConfigurations[K]["n"]-1?this.binConfigurations[K]["bins"][B+1]["value"]:this.binConfigurations[K]["max"]);var k=this.$cX("input",{id:E+"-Range-"+B,className:"CanvasXpressListItem",type:"range",value:this.binConfigurations[K]["bins"][B]["value"],min:s,max:A,step:Number(this.formatNumber((A-s)/20,this.binConfigurations[K]["dec"])),slider:K,sliderRange:B,sliderNumber:false},{width:"120px"});var j=this.$cX("input",{id:E+"-Number-"+B,className:"CanvasXpressListItem",type:"number",value:this.binConfigurations[K]["bins"][B]["value"],min:s,max:A,step:Number(this.formatNumber((A-s)/20,this.binConfigurations[K]["dec"])),slider:K,sliderRange:B,sliderNumber:true},{width:(h+18)+"px",textAlign:"right"});var c=this.$cX("tr");var G=this.$cX("th",{innerHTML:this.binConfigurations[K]["bins"][B]["name"]},{paddingRight:"5px"});var F=this.$cX("td",{id:E+"-Min-"+B,innerHTML:this.formatNumber(s,this.binConfigurations[K]["dec"])},{width:h+"px",textAlign:"right"});var C=this.$cX("td");C.appendChild(k);var z=this.$cX("td",{id:E+"-Max-"+B,innerHTML:this.formatNumber(A,this.binConfigurations[K]["dec"])},{width:h+"px"});var w=this.$cX("td",false,{paddingLeft:"5px"});w.appendChild(j);c.appendChild(G);c.appendChild(F);c.appendChild(C);c.appendChild(z);c.appendChild(w);g.appendChild(c)}n.appendChild(g);H.appendChild(n);H.appendChild(this.$cX("br"));var p=this.$cX("img",{id:this.newId("-cX-List-Icon-"),className:"CanvasXpressListIcon",src:CanvasXpress.images.refreshForm,key:"refreshForm"},{marginTop:"4px"});J.appendChild(p);J.appendChild(H);v.appendChild(J);if(I){I.parentNode.insertBefore(v,I)}else{m.appendChild(v)}this.addRemoveItemListeners("addEvtListener",v)};this.updateSliderItemValue=function(h){var a=this.changingSliderItemOn.slider;var g=this.changingSliderItemOn.sliderRange;var c=Number(this.formatNumber(this.changingSliderItemOn.value,this.binConfigurations[a]["dec"]));var d=this.$(this.changingSliderItemOn.id.replace("-Range-","-Number-"));var f=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Range-"+(g-1)));var j=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Max-"+(g-1)));var b=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Range-"+(g+1)));var i=this.$(this.changingSliderItemOn.id.replace("-Range-"+g,"-Min-"+(g+1)));this.binConfigurations[a]["bins"][g]["value"]=c;if(d){d.value=c}if(f&&j){f.max=c;f.step=(f.max-f.min)/20;j.innerHTML=c}if(b&&i){b.min=c;b.step=(b.max-b.min)/20;i.innerHTML=c}this.applySliderItemValue(a);return false};this.endSliderItemChange=function(g){if(this.changingSliderItemOn.sliderNumber){var a=this.changingSliderItemOn.slider;var f=this.changingSliderItemOn.sliderRange;var c=Number(this.formatNumber(this.changingSliderItemOn.value,this.binConfigurations[a]["dec"]));var i=this.$(this.changingSliderItemOn.id.replace("-Number-","-Range-"));var d=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Range-"+(f-1)));var j=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Max-"+(f-1)));var b=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Range-"+(f+1)));var h=this.$(this.changingSliderItemOn.id.replace("-Number-"+f,"-Min-"+(f+1)));this.binConfigurations[a]["bins"][f]["value"]=c;if(i){i.value=c}if(d&&j){d.max=c;d.step=(d.max-d.min)/20;j.innerHTML=c}if(b&&h){b.min=c;b.step=(b.max-b.min)/20;h.innerHTML=c}this.applySliderItemValue(a)}this.changingSliderItemOn=false};this.applySliderItemValue=function(f){var a=this.binConfigurations[f]["name"];var e=this.binConfigurations[f]["vi"];this.data.x[a]=[];for(var d=0;d<this.data.y.data[e].length;d++){var b=this.data.y.data[e][d];if(!isNaN(b)&&b!=""&&b!=null){for(var c=0;c<this.binConfigurations[f]["n"];c++){if(b<=this.binConfigurations[f]["bins"][c].value){this.data.x[a][d]=this.binConfigurations[f]["bins"][c].name;break}}}else{this.data.x[a][d]=""}}if(this.isGroupedData){this.ungroupSamples(true)}this.updateData(this.data);this.groupSamples([a]);this.sortSamplesByCategory([a])};this.addMenuItemFilter=function(f,d,a){var e=this.newId("-cX-List-Item-");var c=this.$cX("li",{id:e,className:"CanvasXpressListItem",type:"filter",selector:f[1].id.split(":")[1]});c.appendChild(f[1]);if(a){a.parentNode.insertBefore(c,a)}else{d.appendChild(c)}};this.addRemoveItemListeners=function(b,a){if(!a){return this.removeMenus()}else{if(a.className=="CanvasXpressListItemSep"){return}}var e=a.parentNode.parentNode;var f=a.id.match("-cX-List-Item-Color-");if(this.hasClass(e,"draggable")&&!f){this[b](e,"mousedown",this.registerMousemove,false)}if(a.upload){var d=a.childNodes[0].childNodes[1].childNodes[0];this[b](d,"change",this.loadFile,false)}else{if(a.uploadParams){var d=a.childNodes[0].childNodes[1].childNodes[0];this[b](d,"change",this.loadParamsFile,false)}else{this[b](a,"click",this.clickMenuItem,false)}}this[b](a,"mouseover",this.mouseoverMenuItem,false);this[b](a,"mouseout",this.mouseoutMenuItem,false);this[b](a,"mousewheel",this.mousewheelMenuItem,false);this[b](a,"contextmenu",this.contextMenuItem,false);if(a.className.match(/Scroll/)){this[b](a,"mousedown",this.mousedownMenuItem,false);this[b](a,"mouseup",this.mouseupMenuItem,false)}if(a.paleteCurrent&&a.saturation){this[b](a,"mousedown",this.mousedownMenuItemColor,false)}if(a.slider){this[b](a,"mousedown",this.mousedownMenuItemSlider,false)}};this.contextMenuItem=function(a){return function(h){if(!h){h=window.event}a.cancelEvent(h);var b=a.getTargetEvent(h);var n=a.getMenuItemComp(h);var f=n[1].childNodes[0];var g=n[1].childNodes[1].innerText;var k=n[1].menuFunc;var j=n[1].menuParm;var p=n[1].menuId;var q=n[2].offsetLeft;var l=n[2].offsetTop+n[1].offsetTop;a.removeMenus();var o=[["Pin "+g+" to Toolbar","pin","pinToToolbar",[f,g,k,j,p]]];var d=a.addMenu(h,o);var c=a.$(d);c.style.left=q+"px";c.style.top=l+"px";c.style.display="block";return false}}(this);this.pinToToolbar=function(d,a,c,f,e){this.removeMenus();var b=this.$(this.target+"-cX-Toolbar-Custom");if(b){var g=this.target+"-cX-Custom-Toolbar-Menu-"+c;if(!this.$(g)){d.id=g;d.style.cssFloat="left";d.style.marginLeft="10px";d.style.position="relative";d.title=a;d.fun=c;d.par=f;d.mid=e;b.appendChild(d);this.addRemoveEvtListener("addEvtListener",d,"click",this.addCustomToolbarMenu,false);this.addRemoveEvtListener("addEvtListener",d,"contextmenu",this.unpinFromToolbar,false);CanvasXpress.stack[this.target].afterRender.push(["addImageToToolbar",[d.key,a,c,f,e]])}}};this.unpinFromToolbar=function(a){return function(j){if(!j){j=window.event}a.cancelEvent(j);var c=a.getTargetEvent(j);var g=c.offsetLeft;var h=c.offsetTop;var f=[["Unpin "+c.title+"from Toolbar","unpin","removeImageFromToolbar",[c.id]]];var d=a.addMenu(j,f);var b=a.$(d);b.style.left=g+"px";b.style.top=h+"px";b.style.display="block";return false}}(this);this.addCustomToolbarMenu=function(a){return function(f){if(!f){f=window.event}a.cancelEvent(f);var c=a.getTargetEvent(f);var g=a[c.fun].apply(a,c.par);if(c.mid){var d=a.addMenu(false,g);var b=a.$(d);b.style.left=c.offsetLeft+"px";b.style.top="10px";b.style.display="block"}}}(this);this.addImageToToolbar=function(e,a,b,f,d){var c=this.$cX("img",{className:"CanvasXpressListIcon",src:CanvasXpress.images[e],key:e});this.pinToToolbar(c,a,b,f,d)};this.removeImageFromToolbar=function(b){var a=this.$(b);if(a){this.addRemoveEvtListener("removeEvtListener",a,"click",this.addCustomToolbarMenu,false);this.addRemoveEvtListener("removeEvtListener",a,"contextmenu",this.unpinFromToolbar,false);a.parentNode.removeChild(a);this.removeMenus();CanvasXpress.stack[this.target].afterRender.push(["removeImageFromToolbar",[b]])}};this.clickMenuItem=function(a){return function(h){if(!h){h=window.event}a.cancelEvent(h);var b=a.getTargetEvent(h);var m=a.getMenuItemComp(h);if(m&&!/input|textarea|select/i.test(b.tagName)){if(m[0].className.match(/Scroll/)||m[1].className.match(/Scroll/)){var c=m[0].className.match(/Scroll/)?m[0]:m[1];var n=c.parentNode;var j=c.className.match(/ScrollTop/)?"Top":"Bottom";a.pageMenuItem(n,j)}else{var f=[];if(m[0].params){for(var g=0;g<m[0].params.length;g++){if(m[0].params[g]=="event"){f.push(h)}else{if(m[0].params[g]=="component"){f.push(m)}else{f.push(m[0].params[g])}}}}if(a[m[0].click]){a[m[0].click].apply(a,f);var d=m[1].firstChild.key;var o=m[1].firstChild.src;if(d){if(d.match("unchecked")){m[1].firstChild.key="checked";m[1].firstChild.src=CanvasXpress.images.checked}else{if(d.match("checked")){m[1].firstChild.key="unchecked";m[1].firstChild.src=CanvasXpress.images.unchecked}else{if(d.match("eyeMinusIcon")){m[1].firstChild.key="eyePlusIcon";m[1].firstChild.src=CanvasXpress.images.eyePlusIcon}else{if(d.match("eyePlusIcon")){m[1].firstChild.key="eyeMinusIcon";m[1].firstChild.src=CanvasXpress.images.eyeMinusIcon}else{if(d=="lightbulb"){m[1].firstChild.key="lightbulbOff";m[1].firstChild.src=CanvasXpress.images.lightbulbOff}else{if(d=="lightbulbOff"){m[1].firstChild.key="lightbulb";m[1].firstChild.src=CanvasXpress.images.lightbulb}else{if(d=="sortAsciiDesc"){m[1].firstChild.key="sortAsciiAsc";m[1].firstChild.src=CanvasXpress.images.sortAsciiAsc}else{if(d=="sortAsciiAsc"){m[1].firstChild.key="sortAsciiDesc";m[1].firstChild.src=CanvasXpress.images.sortAsciiDesc}else{if(d.match("radioOn")){a.resetRadioMenuItem(m[2].firstChild.childNodes);if(f[1]&&f[1].match(/xAxis|yAxis|zAxis/)){m[1].firstChild.key="radioOn";m[1].firstChild.src=CanvasXpress.images.radioOn}else{m[1].firstChild.key="radioOff";m[1].firstChild.src=CanvasXpress.images.radioOff}}else{if(d.match("radioOff")){a.resetRadioMenuItem(m[2].firstChild.childNodes);m[1].firstChild.key="radioOn";m[1].firstChild.src=CanvasXpress.images.radioOn}}}}}}}}}}}}}return false}else{return false}}}(this);this.resetRadioMenuItem=function(b){for(var c=0;c<b.length;c++){var a=b[c].firstChild.firstChild;if(a&&a.nodeName.match(/img/i)){a.src=CanvasXpress.images.radioOff;a.key="radioOff"}}};this.adjustMenuItemPosition=function(f,p,o){var g,x;var q=this.remoteParentId?this.$(this.remoteParentId):this.$("container-"+this.target);var i=window.innerWidth;var b=window.innerHeight;var u=q.offsetLeft;var k=q.offsetTop;var s=q.clientWidth;var j=q.clientHeight;var a=i-u;var v=f.clientWidth;var n=f.clientHeight;if(p){g=p.offsetLeft+p.offsetWidth-5;if(g+v+5>a){g=p.offsetLeft-v+5}x=p.offsetTop+o.offsetTop}else{g=f.offsetLeft;x=f.offsetTop}f.style.left=g+"px";f.style.top=x+"px"};this.mouseoverMenuItem=function(a){return function(j){if(!j){j=window.event}var h=a.getMenuItemComp(j);if(!h){return false}if(h[0].className.match(/Scroll/)||h[1].className.match(/Scroll/)){var n=h[0].className.match(/Scroll/)?h[0]:h[1];n.className+="Active";return false}var f=h[2].firstChild.childNodes;a.hideMenusRecursively(f);h[0].className="CanvasXpressListItemActive";if(h[1].menu){var l=a[h[1].menuFunc].apply(a,h[1].menuParm);var g=a.addMenu(false,l,h[1].menu);var b=a.$(g);var k=h[2];b.style.left="0px";b.style.top="0px";b.style.display="block";a.adjustMenuItemPosition(b,k,h[1]);h[1].className="CanvasXpressListItemAArrowActive";h[1].menuId=g}else{h[1].className="CanvasXpressListItemAActive"}return false}}(this);this.mouseoutMenuItem=function(a){return function(z){if(!z){z=window.event}if(a.fastScrollMenuOn){a.fastScrollMenuOn=false;clearInterval(a.fastScrollMenu)}var w,v,u,s,i,h,g,c;var B=a.adjustedCoordinates(z);if(B){var k=a.$("north-container-"+a.target);var l=a.$("west-container-"+a.target);B.x+=l.offsetWidth;B.y+=k.offsetHeight;var o=a.getMenuItemComp(z);if(!o){return false}else{if(o[1]&&o[1].menu){var p=a.$(o[1].menuId);var x=p.firstChild.firstChild;w=p.offsetLeft;i=p.offsetTop;v=w+p.offsetWidth;h=i+p.offsetHeight;if(B.x>=w&&B.x<=v&&B.y>=i&&B.y<=h){return false}a.hideMenu(o,p);if(x&&x.type=="filter"){var A=x.firstChild;if(A.type=="string"){var r=a.$(a.target+":"+x.selector+":cX-DataFilterMask");if(r){a.addRemoveStringDataFilterListeners("removeEvtListener",r)}}else{var q=a.$(a.target+":"+x.selector+":cX-DataFilterMin");var n=a.$(a.target+":"+x.selector+":cX-DataFilterMinLabel");var j=a.$(a.target+":"+x.selector+":cX-DataFilterRange");var t=a.$(a.target+":"+x.selector+":cX-DataFilterMax");var y=a.$(a.target+":"+x.selector+":cX-DataFilterMaxLabel");var b=a.$(a.target+":"+x.selector+":cX-DataFilterScale");if(q&&n&&j&&t&&y&&b){a.addRemoveNumericDataFilterListeners("removeEvtListener",q,t,n,y,b)}}}}else{a.hideMenu(o)}}}return false}}(this);this.mousedownMenuItemColor=function(a){return function(d){if(!d){d=window.event}var b=a.getTargetEvent(d);var c=a.getMenuItemComp(d);if(!c){return false}else{if(b.id&&b.id.match(/-cX-List-Item-Color-Palete-/)){a.changingColorItemOn="palette";if(a.colorHSV[2]==0){a.colorFromHsv(null,null,1);a.colorizeCurrentItemColor(c[0]);var f=a.$(c[0].saturationCurrent);if(f){f.style.top="-108px"}}a.updateColorItemValue(c[0],d);a.colorizeSaturationItemColor(c[0])}else{if(b.parentNode.id&&b.parentNode.id.match(/-cX-List-Item-Color-Saturation-/)){a.changingColorItemOn="saturation";a.updateColorItemValue(c[0],d)}}}a.cancelEvent(d);return false}}(this);this.mousedownMenuItemSlider=function(a){return function(b){if(!b){b=window.event}a.changingSliderItemOn=a.getTargetEvent(b);return false}}(this);this.mousedownMenuItem=function(a){return function(b){if(!b){b=window.event}a.fastScrollMenuOn=true;a.fastScrollMenu=a.setInterval(function(){a.clickMenuItem(b)},100);return false}}(this);this.mouseupMenuItem=function(a){return function(b){if(!b){b=window.event}if(a.fastScrollMenuOn){a.fastScrollMenuOn=false;clearInterval(a.fastScrollMenu)}}}(this);this.mousewheelMenuItem=function(a){return function(g){if(!g){g=window.event}a.cancelEvent(g);var h=0;if(g.wheelDelta){h=g.wheelDelta;if(window.opera){h=-h}}else{if(g.detail){h=-g.detail}}if(h){var b=a.getTargetEvent(g);var f=a.getMenuItemComp(g);if(!f){return false}var c=f[0].parentNode;if(h>0){a.pageMenuItem(c,"Top")}else{a.pageMenuItem(c,"Bottom")}}return false}}(this);this.getMenuItemComp=function(b){var a=this.getTargetEvent(b);while(a&&a.tagName&&!a.tagName.match(/li/i)){a=a.parentNode}return a.parentNode&&a.parentNode.parentNode?[a,a.firstChild,a.parentNode.parentNode]:false};this.hideMenu=function(e,f){if(e){if(e[0].className.match(/Scroll/)||e[1].className.match(/Scroll/)){var g=e[0].className.match(/Scroll/)?e[0]:e[1];g.className=g.className.replace("Active","")}else{if(e[1].menu){e[1].className="CanvasXpressListItemAArrow"}else{e[1].className="CanvasXpressListItemA"}e[0].className="CanvasXpressListItem"}}if(f){var b=f.firstChild.childNodes;for(var d=0;d<b.length;d++){var a=b[d];if(!a.className.match(/Scroll|ItemSep/)){this.addRemoveItemListeners("removeEvtListener",a)}}f.parentNode.removeChild(f)}};this.hideMenusRecursively=function(e){for(var f=0;f<e.length;f++){var c=e[f];if(!c.className.match(/Scroll|ItemSep/)){var d=c.firstChild;var b=d.menu?this.$(d.menuId):false;if(b){this.hideMenusRecursively(b.firstChild.childNodes)}this.hideMenu([c,d],b)}}};this.removeMenus=function(k){var f=[];if(this.skipHeaderMouseout){this.skipHeaderMouseout.className="CanvasXpressTableCellHead";this.skipHeaderMouseout.firstChild.firstChild.className="CanvasXpressTableCellHead";this.skipHeaderMouseout=false}if(!k){var c=this.$("north-wrapper-"+this.target);if(c){var h=c.getElementsByTagName("div");for(var g=0;g<h.length;g++){if(this.hasClass(h[g],"CanvasXpressMenu")){f.unshift(this.$(h[g].id))}}}this.menuIndex=10000}else{f.push(this.$(this.target+"-cX-Menu-"+k))}if(f.length>0){for(g in this.meta.ids){if(g.match(/cX-Menu-|cX-Menu/)){delete (this.meta.ids[g])}}for(var g=0;g<f.length;g++){var a=f[g];var b=a.getElementsByTagName("li");for(var e=0;e<b.length;e++){if(b[e].className!="CanvasXpressListItemSep"){this.addRemoveItemListeners("removeEvtListener",b[e])}}a.parentNode.removeChild(a)}}};this.changeTextColorAttributeMenu=function(a,b){return this.isArray(b)?[[a,"changeTextColorAttribute",b]]:[[a,"changeTextColorAttribute",[b]]]};this.getAxisLayoutTypeMenu=function(){var a=[];a.push(["Complete - Both",this.scatterPlotMatrixType=="completeBoth"?"radioOn":"radioOff","changeLayoutType",["completeBoth"]]);a.push(["Complete - Upper",this.scatterPlotMatrixType=="completeUpper"?"radioOn":"radioOff","changeLayoutType",["completeUpper"]]);a.push(["Complete - Lower",this.scatterPlotMatrixType=="completeLower"?"radioOn":"radioOff","changeLayoutType",["completeLower"]]);a.push(["First",this.scatterPlotMatrixType=="first"?"radioOn":"radioOff","changeLayoutType",["first"]]);return a};this.getAxisLayoutMenu=function(){var a=[];a.push(["Auto-Adjust",this.layoutAdjust?"lightbulb":"lightbulbOff","toggleAttribute",["layoutAdjust"]]);a.push(["Type",false,false,false,false,"getAxisLayoutTypeMenu",[]]);return a};this.getAxisSampleMenu=function(c){var d=[];var a=this.getObjectArray(this[c+"Axis"]);for(var b=0;b<this.data.y.smps.length;b++){d.push([this.data.y.smps[b],a[this.data.y.smps[b]]?"checked":"unchecked","changeSampleInAxis",[this.data.y.smps[b],c+"Axis"]])}return d};this.getAxisMenu=function(e,d){var c=e.toUpperCase();var b=d?"2":"";var a=[];a.push([this[e+"Axis"+b+"Show"]?"Hide Axis":"Show Axis",this[e+"AxisShow"]?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",[e+"Axis"+b+"Show"]]);a.push(["Set Min","minimumValue",false,false,false,"changeTextColorAttributeMenu",["-text-","setMin"+c+b]]);a.push(["Set Max","maximumValue",false,false,false,"changeTextColorAttributeMenu",["-text-","setMax"+c+b]]);a.push(["Transform","transform",false,false,false,"getAxisTransformMenu",[e]]);if(this.graphType=="Scatter3D"||this.graphType=="ScatterBubble2D"||this.is3DPlot){a.push(["Exact Range","exactValue","toggleAttribute",[e+"AxisExact"]])}a.push(["Format","format",false,false,false,"changeTextColorAttributeMenu",["-text-",e+"Axis"+b+"TickFormat"]]);if(this.graphType.match(/Scatter/)){a.push(["Samples","samples",false,false,false,"getAxisSampleMenu",[e]])}return a};this.getFirstAxisMenu=function(){return[[this.xAxisShow?"Hide Axis":"Show Axis",this.xAxisShow?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["xAxisShow"]]]};this.getSecondAxisMenu=function(){return[[this.xAxis2Show?"Hide Axis":"Show Axis",this.xAxis2Show?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["xAxis2Show"]]]};this.getRangeAxisMenu=function(){var a=[];a.push(["Set Min","minimumValue",false,false,false,"changeTextColorAttributeMenu",["-text-","setMinX"]]);a.push(["Set Max","maximumValue",false,false,false,"changeTextColorAttributeMenu",["-text-","setMaxX"]]);return a};this.getAxesMenu=function(){var a=[];if(this.graphType=="Scatter2D"){a.push(["X-Axis","xAxis",false,false,false,"getAxisMenu",["x"]]);a.push(["Y-Axis","yAxis",false,false,false,"getAxisMenu",["y"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["axisTick"]]);if(this.scatterPlotMatrix){a.push(["Axes Layout",false,false,false,false,"getAxisLayoutMenu",[]])}}else{if(this.graphType=="Scatter3D"||this.graphType=="ScatterBubble2D"||this.is3DPlot){a.push(["X-Axis","xAxis",false,false,false,"getAxisMenu",["x"]]);a.push(["Y-Axis","yAxis",false,false,false,"getAxisMenu",["y"]]);a.push(["Z-Axis","zAxis",false,false,false,"getAxisMenu",["z"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["axisTick"]])}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){a.push(["First Axis","firstAxis",false,false,false,"getAxisMenu",["x"]]);a.push(["Second Axis","secondAxis",false,false,false,"getAxisMenu",["x",true]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["axisTick"]])}else{a.push(["First Axis","firstAxis",false,false,false,"getFirstAxisMenu",[]]);a.push(["Second Axis","secondAxis",false,false,false,"getSecondAxisMenu",[]]);a.push(["Range","range",false,false,false,"getRangeAxisMenu",[]]);a.push(["Format","format",false,false,false,"changeTextColorAttributeMenu",["-text-","xAxisTickFormat"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTickColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["axisTick"]]);if(this.layoutValid){a.push(["Auto-Adjust",this.layoutAdjust?"lightbulb":"lightbulbOff","toggleAttribute",["layoutAdjust"]])}}}}return a};this.getHeatmapBoxMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","heatmapCellBoxColor"]]);a.push(["Width","widthSpace",false,false,false,"changeTextColorAttributeMenu",["-text-","heatmapCellBoxWidth"]]);a.push([this.heatmapCellBox?"Hide Box":"Show Box",this.heatmapCellBox?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["heatmapCellBox"]]);return a};this.getHeatmapHighlightMenu=function(){return[["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","heatmapCellBoxColorHighlight"]]]};this.getHeatmapVarSmpSeparatorsMenu=function(h,d,j){var e=this.meta.data;var k=[];if(e[h]&&d.length>0){var f={};for(var g=0;g<d.length;g++){var a=d[g];if(e[h][a].type!="Numeric"){f[a]=true}}var b=this.sortObject(f);for(var g=0;g<b.length;g++){k.push([b[g],b[g]==this[j]?"radioOn":"radioOff","changeAttribute",[j,b[g]]])}}return k};this.getHeatmapSeparatorsMenu=function(){var a=[];if(this.isStringOverlays("v")){a.push(["Variables","variables",false,false,false,"getHeatmapVarSmpSeparatorsMenu",["z",this.varOverlays,"heatmapVarSeparateBy"]])}if(this.isStringOverlays("s")){a.push(["Samples","samples",false,false,false,"getHeatmapVarSmpSeparatorsMenu",["x",this.smpOverlays,"heatmapSmpSeparateBy"]])}return a};this.getHeatmapMenu=function(){var a=[];a.push(["Cell Boxes","border",false,false,false,"getHeatmapBoxMenu",[]]);a.push(["Highlight","heatmapHighlight",false,false,false,"getHeatmapHighlightMenu",[]]);if(this.isStringOverlays()){a.push(["Separators","heatmapSeparate",false,false,false,"getHeatmapSeparatorsMenu",[]])}return a};this.getPlotAreaMajorTicksMenu=function(a){return[[this[a]?"Hide Major Ticks":"Show Major Ticks",this[a]?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",[a]]]};this.getPlotAreaMinorTicksMenu=function(a){return[[this[a]?"Hide Minor Ticks":"Show Minor Ticks",this[a]?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",[a]]]};this.getPlotAreaTickTypeMenu=function(a){var b=[];b.push(["Solid","axesTickTypeSolid","changeAttribute",[a,"solid"]]);b.push(["Dotted","axesTickTypeDotted","changeAttribute",[a,"dotted"]]);return b};this.getPlotAreaGridMenu=function(b){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-",b+"AxisTickColor"]]);if(this.graphType!="Scatter3D"&&!this.is3DPlot){a.push(["Major Ticks","axesMinorTicks",false,false,false,"getPlotAreaMajorTicksMenu",[b+"AxisMajorTicks"]]);a.push(["Minor Ticks","axesMinorTicks",false,false,false,"getPlotAreaMinorTicksMenu",[b+"AxisMinorTicks"]]);a.push(["Number","editNumber",false,false,false,"changeTextColorAttributeMenu",["-text-",b+"AxisTicks"]])}a.push(["Style","axesTickType",false,false,false,"getPlotAreaTickTypeMenu",[b+"AxisTickStyle"]]);return a};this.getPlotAreaScatterGridMenu=function(){var a=[];if(this.graphType=="Scatter2D"||this.graphType=="ScatterBubble2D"){a.push(["X-Axis","xGridS",false,false,false,"getPlotAreaGridMenu",["x"]]);a.push(["Y-Axis","yGridS",false,false,false,"getPlotAreaGridMenu",["y"]])}else{if(this.graphType=="Scatter3D"||this.is3DPlot){a.push(["X-Axis","xGridS",false,false,false,"getPlotAreaGridMenu",["x"]]);a.push(["Y-Axis","yGridS",false,false,false,"getPlotAreaGridMenu",["y"]]);a.push(["Z-Axis","zGridS",false,false,false,"getPlotAreaGridMenu",["z"]])}}return a};this.getPlotAreaAxisAlgorithmMenu=function(){var a=[];a.push(["Heckbert",this.axisAlgorithm=="heckbert"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","heckbert"]]);a.push(["R Pretty",this.axisAlgorithm=="rPretty"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","rPretty"]]);a.push(["Wilkinson",this.axisAlgorithm=="wilkinson"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","wilkinson"]]);a.push(["Wilkinson Extended",this.axisAlgorithm=="wilkinsonExtended"?"radioOn":"radioOff","changeAttribute",["axisAlgorithm","wilkinsonExtended"]]);return a};this.getPlotAreaBarsTypeMenu=function(){var a=[];a.push(["Standard Deviation",this.errorBarsType=="standardDeviation"?"radioOn":"radioOff","changeAttribute",["errorBarsType","standardDeviation"]]);a.push(["Standard Error of Mean",this.errorBarsType=="standardErrorMean"?"radioOn":"radioOff","changeAttribute",["errorBarsType","standardErrorMean"]]);a.push(["95% Confidence Interval",this.errorBarsType=="confidenceInterval95"?"radioOn":"radioOff","changeAttribute",["errorBarsType","confidenceInterval95"]]);return a};this.getPlotAreaErrorBarsMenu=function(){var a=[];a.push(["Error Bars Type",false,false,false,false,"getPlotAreaBarsTypeMenu",[]]);a.push([this.showErrorBars?"Hide Error Bars":"Show Error Bars",this.showErrorBars?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showErrorBars"]]);return a};this.getPlotAreaOneVariableSpaceMenu=function(){var a=[];a.push(["Farther","spaceFarther","setFontAttributeSize",["variableSpaceFactor","increase"]]);a.push(["Closer","spaceCloser","setFontAttributeSize",["variableSpaceFactor","decrease"]]);return a};this.getPlotAreaOneSampleWidthMenu=function(){var a=[];a.push(["Wider","widthSpaceWider","setFontAttributeSize",["widthFactor","increase"]]);a.push(["Thinner","widthSpaceThinner","setFontAttributeSize",["widthFactor","decrease"]]);return a};this.getPlotAreaOneMenu=function(){var b=[];b.push(["Axis Algorithm","gridS",false,false,false,"getPlotAreaAxisAlgorithmMenu",[]]);b.push(["Error Bars","errorBars",false,false,false,"getPlotAreaErrorBarsMenu",[]]);b.push(["Border Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","plotBoxColor"]]);b.push([this.plotBox?"Hide Border":"Show Border",this.plotBox?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["plotBox"]]);if(this.graphType.match(/Dot|Boxplot/)){b.push(["Jitter","jitter","toggleAttribute",["jitter"]])}if(this.graphType=="Boxplot"){b.push(["Plot Data","bpdata","toggleAttribute",["showBoxplotOriginalData"]]);b.push(["Violin","violinOn","toggleAttribute",["showViolinBoxplot"]]);b.push(["Connect Boxplot","connects","toggleAttribute",["boxplotConnect"]])}if(this.graphType.match(/Bar|Boxplot/)&&this.data.y.vars.length>1){b.push(["Variable Space","spaceWidth",false,false,false,"getPlotAreaOneVariableSpaceMenu",[]])}b.push(["Sample Width","widthSpace",false,false,false,"getPlotAreaOneSampleWidthMenu",[]]);return b};this.getPlotAreaScatterMenu=function(){var b=[];b.push(["Axis Algorithm","gridS",false,false,false,"getPlotAreaAxisAlgorithmMenu",[]]);b.push(["Error Bars","errorBars",false,false,false,"getPlotAreaErrorBarsMenu",[]]);b.push(["Border Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","plotBoxColor"]]);b.push([this.plotBox?"Hide Border":"Show Border",this.plotBox?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["plotBox"]]);return b};this.getAxesTitleXMenu=function(){return[["Text","normalFont",false,false,false,"changeTextColorAttributeMenu",["-text-","xAxisTitle"]]]};this.getAxesTitleX2Menu=function(){return[["Text","normalFont",false,false,false,"changeTextColorAttributeMenu",["-text-","xAxis2Title"]]]};this.getAxesTitleYMenu=function(){return[["Text","normalFont",false,false,false,"changeTextColorAttributeMenu",["-text-","yAxisTitle"]]]};this.getAxesTitleZMenu=function(){return[["Text","normalFont",false,false,false,"changeTextColorAttributeMenu",["-text-","zAxisTitle"]]]};this.getAxesTitleMenu=function(){var a=[];if(this.graphType.match(/scatter/i)||this.is3DPlot){a.push(["X-Axis","xAxisTitleS",false,false,false,"getAxesTitleXMenu",[]]);a.push(["Y-Axis","yAxisTitleS",false,false,false,"getAxesTitleYMenu",[]]);if(this.graphType=="Scatter3D"||this.is3DPlot){a.push(["Z-Axis","zAxisTitleS",false,false,false,"getAxesTitleZMenu",[]])}}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){a.push(["First Axis","firstAxisTitle",false,false,false,"getAxesTitleXMenu",[]]);a.push(["Second Axis","secondAxisTitle",false,false,false,"getAxesTitleX2Menu",[]])}else{a.push(["Text","normalFont",false,false,false,"changeTextColorAttributeMenu",["-text-","xAxisTitle"]])}}a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","axisTitleColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["axisTitle"]]);return a};this.getTitleMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","titleColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["title"]]);a.push(["Text","normalFont",false,false,false,"changeTextColorAttributeMenu",["-text-","title"]]);return a};this.getSubtitleMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","subtitleColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["subtitle"]]);a.push(["Text","normalFont",false,false,false,"changeTextColorAttributeMenu",["-text-","subtitle"]]);return a};this.getTitleSubtitleMenu=function(){var a=[];if(this.graphType.match(/scatter/i)||this.is3DPlot){a.push(["Title","titleS",false,false,false,"getTitleMenu",[]]);a.push(["Subtitle","subtitleS",false,false,false,"getSubtitleMenu",[]])}else{a.push(["Title",this.graphType=="Heatmap"?"titleH":"title",false,false,false,"getTitleMenu",[]]);a.push(["Subtitle",this.graphType=="Heatmap"?"subtitleH":"subtitle",false,false,false,"getSubtitleMenu",[]])}return a};this.getLegendLocationMenu=function(){var a=[];a.push(["Inside Plot","legendInside","changeAttribute",["legendInside",true]]);a.push(["Outside Plot","legendOutside","changeAttribute",["legendInside",false]]);return a};this.getLegendPositionMenu=function(){var a=[];if(this.legendInside){a.push(["Top","legendInsideTop","changeAttribute",["legendPosition","top"]]);a.push(["Top Right","legendInsideTopRight","changeAttribute",["legendPosition","topRight"]]);a.push(["Right","legendInsideRight","changeAttribute",["legendPosition","right"]]);a.push(["Bottom Right","legendInsideBottomRight","changeAttribute",["legendPosition","bottomRight"]]);a.push(["Bottom","legendInsideBottom","changeAttribute",["legendPosition","bottom"]]);a.push(["Bottom Left","legendInsideBottomLeft","changeAttribute",["legendPosition","bottomLeft"]]);a.push(["Left","legendInsideLeft","changeAttribute",["legendPosition","left"]]);a.push(["Top Left","legendInsideTopLeft","changeAttribute",["legendPosition","topLeft"]])}else{a.push(["Bottom","bottom","changeAttribute",["legendPosition","bottom"]]);a.push(["Right","right","changeAttribute",["legendPosition","right"]])}return a};this.getLegendBorderMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","legendBoxColor"]]);a.push([this.legendBox?"Hide Border":"Show Border",this.legendBox?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["legendBox"]]);return a};this.getLegendMenu=function(){var a=[];a.push(["Border","border",false,false,false,"getLegendBorderMenu",[]]);a.push(["Background","background",false,false,false,"changeTextColorAttributeMenu",["-color-","legendBackgroundColor"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","legendColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["legend"]]);if(this.graphType!="Network"){a.push(["Position",this.legendInside?"legendInsidePosition":"positionRightBottom",false,false,false,"getLegendPositionMenu",[]]);a.push(["Location","legendLocation",false,false,false,"getLegendLocationMenu",[]])}a.push(["Columns","editNumber",false,false,false,"changeTextColorAttributeMenu",["-text-","legendColumns"]]);if(this.graphType!="Network"){a.push(["Reset Positions","refreshForm","resetLegendPosition"])}a.push([this.showLegend?"Hide Legend":"Show Legend",this.showLegend?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showLegend"]]);return a};this.getIndicatorPositionMenu=function(){var a=[];a.push(["Right","legendInsideRight","changeAttribute",["heatmapIndicatorPosition","right"]]);a.push(["Top Right","legendInsideTopRight","changeAttribute",["heatmapIndicatorPosition","topRight"]]);a.push(["Top","legendInsideTop","changeAttribute",["heatmapIndicatorPosition","top"]]);a.push(["Top Left","legendInsideTopLeft","changeAttribute",["heatmapIndicatorPosition","topLeft"]]);return a};this.getIndicatorMenu=function(){var a=[];a.push(["Position","legendInsidePosition",false,false,false,"getIndicatorPositionMenu",[]]);a.push(["Height","heightSpace",false,false,false,"changeTextColorAttributeMenu",["-text-","heatmapIndicatorHeight"]]);a.push(["Width","widthSpace",false,false,false,"changeTextColorAttributeMenu",["-text-","heatmapIndicatorWidth"]]);a.push(["Histogram","indicatorHistogram","toggleAttribute",["heatmapIndicatorHistogram"]]);a.push([this.showHeatmapIndicator?"Hide Indicator":"Show Indicator",this.showHeatmapIndicator?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showHeatmapIndicator"]]);return a};this.getDecorationsBorderMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","decorationsBoxColor"]]);a.push([this.decorationsBox?"Hide Border":"Show Border",this.decorationsBox?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["decorationsBox"]]);return a};this.getDecorationsPositionMenu=function(){var a=[];if(this.legendInside){a.push(["Top","legendInsideTop","changeAttribute",["decorationsPosition","top"]]);a.push(["Top Right","legendInsideTopRight","changeAttribute",["decorationsPosition","topRight"]]);a.push(["Right","legendInsideRight","changeAttribute",["decorationsPosition","right"]]);a.push(["Bottom Right","legendInsideBottomRight","changeAttribute",["decorationsPosition","bottomRight"]]);a.push(["Bottom","legendInsideBottom","changeAttribute",["decorationsPosition","bottom"]]);a.push(["Bottom Left","legendInsideBottomLeft","changeAttribute",["decorationsPosition","bottomLeft"]]);a.push(["Left","legendInsideLeft","changeAttribute",["decorationsPosition","left"]]);a.push(["Top Left","legendInsideTopLeft","changeAttribute",["decorationsPosition","topLeft"]])}else{a.push(["Bottom","bottom","changeAttribute",["decorationsPosition","bottom"]]);a.push(["Right","right","changeAttribute",["decorationsPosition","right"]])}return a};this.getDecorationsDataMenu=function(){return[[this.showDecorations?"Hide Decorations":"Show Decorations",this.showDecorations?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showDecorations"]]]};this.getDecorationsLegendMenu=function(){return[[this.showDecorationsLegend?"Hide Decorations Legend":"Show Decorations Legend",this.showDecorationsLegend?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showDecorationsLegend"]]]};this.getDecorationsConfidenceIntervalsMenu=function(){var a=this.decorations.reg?"showRegressionConfidence":"showKaplanMeierConfidence";return[[this[a]?"Hide Confidence Intervals":"Show Confidence Intervals",this[a]?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",[a]]]};this.getDecorationsMenu=function(){var b=this.decorations;var a=[];a.push(["Border","border",false,false,false,"getDecorationsBorderMenu",[]]);a.push(["Background","background",false,false,false,"changeTextColorAttributeMenu",["-color-","decorationsBackgroundColor"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","decorationsColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["decoration"]]);a.push(["Position",this.legendInside?"legendInsidePosition":"positionRightBottom",false,false,false,"getDecorationsPositionMenu",[]]);a.push(["Data and Legend","data",false,false,false,"getDecorationsDataMenu",[]]);a.push(["Legend","legendS",false,false,false,"getDecorationsLegendMenu",[]]);if(b.reg||b.kaplanMeier){a.push(["Confidence Intervals",b.reg?"correlationConfidence":"kaplanMeier",false,false,false,"getDecorationsConfidenceIntervalsMenu",[]])}return a};this.getOverlaysMemebersMenu=function(g,b){var f=[];var e={};for(var a=0;a<this[b+"Overlays"].length;a++){e[this[b+"Overlays"][a]]=true}var d=this.sortObject(this.data[g]);for(var a=0;a<d.length;a++){f.push([d[a],e[d[a]]?"checked":"unchecked",b=="var"?"showVariableOverlays":"showSampleOverlays",[d[a]]])}return f};this.getOverlaysPositionMemberMenu=function(a,b){var c=[];if(a=="var"){c.push(["Bottom","bottom","modifyOverlaysProperties",["bottom",a+"OverlayProperties",b,"position"]]);c.push(["Top","top","modifyOverlaysProperties",["top",a+"OverlayProperties",b,"position"]])}else{if(this.graphType=="Heatmap"||this.graphOrientation=="horizontal"){c.push(["Left","left","modifyOverlaysProperties",["left",a+"OverlayProperties",b,"position"]]);c.push(["Right","right","modifyOverlaysProperties",["right",a+"OverlayProperties",b,"position"]])}else{c.push(["Bottom","bottom","modifyOverlaysProperties",["bottom",a+"OverlayProperties",b,"position"]]);c.push(["Top","top","modifyOverlaysProperties",["top",a+"OverlayProperties",b,"position"]])}}return c};this.getOverlaysPositionMenu=function(f,b){var e=[];var d=this.sortObject(this.data[f]);for(var a=0;a<d.length;a++){e.push([d[a],false,false,false,false,"getOverlaysPositionMemberMenu",[b,d[a]]])}return e};this.getOverlaysThicknessMenu=function(f,b){var e=[];var d=this.sortObject(this.data[f]);for(var a=0;a<d.length;a++){e.push([d[a],false,false,false,false,"changeTextColorAttributeMenu",["-text-",[false,"modifyOverlaysProperties",[b+"OverlayProperties",d[a],"thickness"]]]])}return e};this.getOverlaysColorSchemesMenu=function(g,f){var e=[];var b=this.meta.data[g];var a=this.getColorSchemes();for(var d=0;d<a.length;d++){e.push([a[d],b[f].spectrum==a[d]?"radioOn":"radioOff","modifyColorProperties",[a[d],f,g]])}return e};this.getOverlaysColorMenu=function(g,d){var f=[];var a=this.meta.data[g];var e=this.sortObject(this.data[g]);for(var b=0;b<e.length;b++){if(this.isNumeric(this.data[g][e[b]])){if(this[d+"OverlayProperties"][e[b]]&&this[d+"OverlayProperties"][e[b]].type&&this[d+"OverlayProperties"][e[b]].type=="Heatmap"){f.push([e[b],false,false,false,false,"getColorSpectrumMenu",[a[e[b]].colorBrew.spectrum,"modifyColorProperties",e[b],g]])}else{f.push([e[b],false,false,false,false,"changeTextColorAttributeMenu",["-color-",[false,"modifyOverlaysProperties",[d+"OverlayProperties",e[b],"color"]]]])}}else{f.push([e[b],false,false,false,false,"getOverlaysColorSchemesMenu",[g,e[b]]])}}return f};this.getOverlaysGraphTypeMenu=function(d,f){var e=[];var b=["Area","AreaLine","Bar","BarLine","Dotplot","DotLine","Heatmap","Line","Pie","Stacked","StackedLine","StackedPercent","StackedPercentLine","Treemap"];var a=["area","areaLine","bar","barLine","dotplot","dotplotLine","heatmap","line","pie","stacked","stackedPercent","stackedPercent","stackedPercentLine","treemap"];for(var c=0;c<b.length;c++){e.push([b[c],a[c],"modifyOverlaysProperties",[b[c],d+"OverlayProperties",f,"type"]])}return e};this.getOverlaysGraphDefaultMenu=function(a,c){var b=[];b.push(["Default","heatmap","modifyOverlaysProperties",["Heatmap",a+"OverlayProperties",c,"type"]]);b.push(["Text","ut","modifyOverlaysProperties",["Text",a+"OverlayProperties",c,"type"]]);b.push(["Treemap","treemap","modifyOverlaysProperties",["Treemap",a+"OverlayProperties",c,"type"]]);return b};this.getOverlaysGraphMenu=function(g,d){var f=[];var a=this.meta.data[g];var e=this.sortObject(this.data[g]);for(var b=0;b<e.length;b++){if(this.isNumeric(this.data[g][e[b]])){f.push([e[b],false,false,false,false,"getOverlaysGraphTypeMenu",[d,e[b]]])}else{f.push([e[b],false,false,false,false,"getOverlaysGraphDefaultMenu",[d,e[b]]])}}return f};this.getOverlaysPropertiesMenu=function(d,a){var b=[];if(a=="var"){b.push(["Position","positionTopBottom",false,false,false,"getOverlaysPositionMenu",[d,a]])}else{if(this.graphType=="Heatmap"||this.graphOrientation=="vertical"){b.push(["Position","positionLeftRight",false,false,false,"getOverlaysPositionMenu",[d,a]])}else{b.push(["Position","positionTopBottom",false,false,false,"getOverlaysPositionMenu",[d,a]])}}b.push(["Thickness","widthSpace",false,false,false,"getOverlaysThicknessMenu",[d,a]]);b.push(["Color","colors",false,false,false,"getOverlaysColorMenu",[d,a]]);b.push(["Type","graphType",false,false,false,"getOverlaysGraphMenu",[d,a]]);return b};this.getLegendOverlaysPositionMenu=function(){var a=[];a.push(["Top Right","legendInsideTopRight","changeAttribute",["overlaysLegendPosition","topRight"]]);a.push(["Right","right","changeAttribute",["overlaysLegendPosition","right"]]);a.push(["Bottom Left","legendInsideBottomLeft","changeAttribute",["overlaysLegendPosition","bottomLeft"]]);a.push(["Bottom","bottom","changeAttribute",["overlaysLegendPosition","bottom"]]);return a};this.getLegendOverlaysMenu=function(a){var b="show"+a+"OverlaysLegend";return[[this[b]?"Hide Legend":"Show Legend",this[b]?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",[b]]]};this.getOverlaysMenu=function(){var a=[];if(this.graphType=="Heatmap"&&this.data.z){a.push(["Variable Overlays","overlaysVariables",false,false,false,"getOverlaysMemebersMenu",["z","var"]]);a.push(["Variable Overlays Properties","overlaysVariablesEdit",false,false,false,"getOverlaysPropertiesMenu",["z","var"]]);a.push(["Variable Overlays Legend","legends",false,false,false,"getLegendOverlaysMenu",["Var"]]);a.push(["-"])}if(this.data.x){a.push(["Sample Overlays",this.graphType=="Heatmap"?"overlaysSamplesH":"overlaysSamples1",false,false,false,"getOverlaysMemebersMenu",["x","smp"]]);a.push(["Sample Overlays Properties",this.graphType=="Heatmap"?"overlaysSamplesHEdit":"overlaysSamples1Edit",false,false,false,"getOverlaysPropertiesMenu",["x","smp"]]);a.push(["Sample Overlays Legend","legends",false,false,false,"getLegendOverlaysMenu",["Smp"]]);a.push(["-"])}a.push(["Overlays Legend Position","positionRightBottom",false,false,false,"getLegendOverlaysPositionMenu",[]]);a.push(["-"]);a.push(["Label Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","overlayFontColor"]]);a.push(["Label Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["overlay"]]);a.push(["Default Thickness","widthSpace",false,false,false,"changeTextColorAttributeMenu",["-text-","overlaysThickness"]]);if(this.data.x||this.data.z){a.push([this.showOverlays?"Hide Overlays":"Show Overlays",this.showOverlays?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showOverlays"]])}a.push(["More","more","showConfiguratorCategory",["event","Overlays"]]);return a};this.getBinDataPercentileMenu=function(d){var b=[];for(var a=0;a<this.data.y.vars.length;a++){if(d){b.push([this.data.y.vars[a],"radioOff","binDataByPercentile",[a,true]])}else{b.push([this.data.y.vars[a],"radioOff","binDataByPercentile",[a]])}}return b};this.getBinDataQuantileMenu=function(d){var b=[];for(var a=0;a<this.data.y.vars.length;a++){if(d){b.push([this.data.y.vars[a],"radioOff","binDataByQuantile",[a,true]])}else{b.push([this.data.y.vars[a],"radioOff","binDataByQuantile",[a]])}}return b};this.getBinDataCustomBinMenu=function(b){var c=[];for(var a=2;a<9;a++){c.push([a+" bins","radioOff","binDataCustom",[b,a]])}return c};this.getBinDataCustomMenu=function(){var b=[];for(var a=0;a<this.data.y.vars.length;a++){b.push([this.data.y.vars[a],false,false,false,false,"getBinDataCustomBinMenu",[a]])}return b};this.getBinDataMenu=function(){var a=[];a.push(["By Percentile Discrete","prcnt",false,false,false,"getBinDataPercentileMenu",[]]);a.push(["By Percentile Continuous","prcnt",false,false,false,"getBinDataPercentileMenu",[true]]);a.push(["By Quantile Discrete","uq",false,false,false,"getBinDataQuantileMenu",[]]);a.push(["By Quantile Continuous","uq",false,false,false,"getBinDataQuantileMenu",[true]]);a.push(["Custom","uc",false,false,false,"getBinDataCustomMenu",[]]);return a};this.getGroupSamplesMenu=function(){if(this.data.x){var d=[];var b={};var a=this.sortObject(this.data.x);for(var c=0;c<this.groupingFactors.length;c++){b[this.groupingFactors[c]]=true}for(var c=0;c<a.length;c++){d.push([a[c],b[a[c]]?"checked":"unchecked","showSampleGroups",[a[c]]])}return d}else{return false}};this.getSmpLabelHighlightLevelMenu=function(){var c=[];var b={};var d=this.isGroupedData?this.data.w:this.data.y;for(var a=0;a<this.highlightSmp.length;a++){b[this.highlightSmp[a]]=true}for(var a=0;a<d.smps.length;a++){c.push([d.smps[a],b[d.smps[a]]?"checked":"unchecked","modifyObjectArray",[d.smps[a],false,"highlightSmp",true,true]])}return c};this.getSmpLabelHighlightMenu=function(){var a=[];a.push(["Samples","samples",false,false,false,"getSmpLabelHighlightLevelMenu",[]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","smpHighlightColor"]]);return a};this.getSmpLabelMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","smpLabelFontColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["smpLabel"]]);a.push(["Highlight",this.graphType=="Heatmap"?"highlightSampleLabelsH":"highlightSampleLabels1",false,false,false,"getSmpLabelHighlightMenu",[]]);a.push(["Interval","editNumber",false,false,false,"changeTextColorAttributeMenu",["-text-","smpLabelInterval"]]);a.push(["Rotate","rotateClockwise",false,false,false,"changeTextColorAttributeMenu",["-text-","smpLabelRotate"]]);a.push([this.showSampleNames?"Hide Labels":"Show Labels",this.showSampleNames?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showSampleNames"]]);return a};this.getVarLabelHighlightLevelMenu=function(){var d=[];var c={};var a=this.data.y.vars;for(var b=0;b<this.highlightVar.length;b++){c[this.highlightVar[b]]=true}for(var b=0;b<a.length;b++){d.push([a[b],c[a[b]]?"checked":"unchecked","modifyObjectArray",[a[b],false,"highlightVar",true,true]])}return d};this.getVarLabelHighlightMenu=function(){var a=[];a.push(["Variables","variables",false,false,false,"getVarLabelHighlightLevelMenu",[]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","varHighlightColor"]]);return a};this.getVarLabelMenu=function(b){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","varLabelFontColor"]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",["varLabel"]]);a.push(["Highlight","highlightVariableLabelsH",false,false,false,"getVarLabelHighlightMenu",[]]);a.push(["Interval","editNumber",false,false,false,"changeTextColorAttributeMenu",["-text-","varLabelInterval"]]);a.push(["Rotate","rotateClockwise",false,false,false,"changeTextColorAttributeMenu",["-text-","varLabelRotate"]]);a.push([this.showVariableNames?"Hide Labels":"Show Labels",this.showVariableNames?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showVariableNames"]]);return a};this.getGraphPartMenu=function(c,b){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-",c+(b?"FontColor":"Color")]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontStyleMenu",[c]]);a.push(["Text","normalFont",false,false,false,"changeTextColorAttributeMenu",["-text-",c]]);return a};this.getFontStyleMenu=function(c){var b=[];var a="ScaleFontFactor";b.push(["Bigger","biggerFont","setFontAttributeSize",[c+a,"increase"]]);b.push(["Smaller","smallerFont","setFontAttributeSize",[c+a,"decrease"]]);b.push(["Normal","normalFont","setFontAttributeStyle",[c+"FontStyle","normal"]]);b.push(["Bold","boldFont","setFontAttributeStyle",[c+"FontStyle","bold"]]);b.push(["Italic","italicFont","setFontAttributeStyle",[c+"FontStyle","italic"]]);return b};this.getDataPointAttributesPropertySampleMenu=function(b){var d=[];var c=this.isGroupedData?this.data.w:this.data.y;for(var a=0;a<c.smps.length;a++){d.push([c.smps[a],this[b]==c.smps[a]?"radioOn":"radioOff","changeAttribute",[b,c.smps[a]]])}return d};this.getDataPointAttributesPropertyMenu=function(f){var g=[];if(f=="treemapBy"){var a={};var b=this.sortObject(this.data.x);for(var c=0;c<this.treemapBy.length;c++){a[this.treemapBy[c]]=true}for(var c=0;c<b.length;c++){g.push([b[c],a[b[c]]?"checked":"unchecked","showTreemapGroups",[b[c]]])}}else{if(this.graphType!="Line"&&this.graphType!="ParallelCoordinates"){var e=this.graphType.match(/scatter/i)||this.graphType=="Map"?this.sortObject(this.data.z):this.sortObject(this.data.x);for(var c=0;c<e.length;c++){g.push([e[c],e[c]==this[f]?"radioOn":"radioOff","changeAttribute",[f,e[c]]])}g.push(["-"])}var c="variable";if(f!="connectBy"){g.push(["Variable",c==this[f]?"radioOn":"radioOff","changeAttribute",[f,c]])}if(((!this.graphType.match(/scatter/i)&&!this.graphType=="Map")||this.graphType=="Dotplot")&&this.data.z){var d=this.sortObject(this.data.z);if(f!="connectBy"||this.graphType=="Dotplot"){g.push(["-"])}for(var c=0;c<d.length;c++){if(f!="connectBy"||this.graphType=="Dotplot"){g.push([d[c],d[c]==this[f]?"radioOn":"radioOff","changeAttribute",[f,d[c]]])}}}if(this.graphType=="Line"||this.graphType=="ParallelCoordinates"||this.graphType=="Map"){g.push(["-"]);g.push(["Sample","samples",false,false,false,"getDataPointAttributesPropertySampleMenu",[f]])}}return g};this.getDataPointAttributesMenu=function(){var a=[];if(this.graphType!="Heatmap"){a.push(["Color By","colors",false,false,false,"getDataPointAttributesPropertyMenu",["colorBy"]])}if(this.graphType.match(/scatter/i)||this.is3DPlot||this.graphType=="Dotplot"||this.graphType=="Tree"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){a.push(["Shape By","shapes",false,false,false,"getDataPointAttributesPropertyMenu",["shapeBy"]]);a.push(["Size By","sizes",false,false,false,"getDataPointAttributesPropertyMenu",["sizeBy"]])}if(!this.graphType.match(/parallelcoordinates|line/i)){a.push(["Pattern By","patterns",false,false,false,"getDataPointAttributesPropertyMenu",["patternBy"]])}if(this.graphType.match(/scatter/i)||this.is3DPlot||this.graphType=="Dotplot"||(this.graphType=="Boxplot"&&this.showBoxplotOriginalData)){a.push(["Connect By","connects",false,false,false,"getDataPointAttributesPropertyMenu",["connectBy"]])}if(this.graphType.match(/stacked/i)&&this.data.x&&this.isGroupedData){a.push(["Treemap By","treemap",false,false,false,"getDataPointAttributesPropertyMenu",["treemapBy"]])}if(this.graphType.match(/scatter/i)){a.push(["Ellipse By","ellipses",false,false,false,"getDataPointAttributesPropertyMenu",["ellipseBy"]])}return a};this.getDendrogramColorMenu=function(d){var e=[];if(d){var c=this.sortObject(this.data.z);for(var b=0;b<c.length;b++){e.push([c[b],this.colorVarDendrogramBy==c[b]?"radioOn":"radioOff","changeAttribute",["colorVarDendrogramBy",c[b]]])}}else{var a=this.sortObject(this.data.x);for(var b=0;b<a.length;b++){e.push([a[b],this.colorSmpDendrogramBy==a[b]?"radioOn":"radioOff","changeAttribute",["colorSmpDendrogramBy",a[b]]])}}return e};this.getDendrogramsMenu=function(){var a=[];if(this.graphType=="Tree"){a.push(["Radial Layout",this.treeCircular?"checked":"unchecked","toggleAttribute",["treeCircular"]]);a.push(["Inverted Tree",this.treeInverted?"checked":"unchecked","toggleAttribute",["treeInverted"]])}else{if(this.graphType=="Heatmap"){a.push(["Cluster Variable","clusterVariables","clusterVariables",[true]]);a.push(["K-Means Variable","kmeansVariables","kmeansVariables",[true]]);if(this.varDendrogram){a.push(["Color Variable Cluster By","colors",false,false,false,"getDendrogramColorMenu",[true]]);if(this.showVarDendrogram){a.push(["Hide Dendrogram","eyeMinusIcon","showHideDendrogram",["showVarDendrogram"]])}else{a.push(["Show Dendrogram","eyePlusIcon","showHideDendrogram",["showVarDendrogram"]])}}a.push(["-"])}a.push(["Cluster Samples","clusterSamples","clusterSamples",[true]]);a.push(["K-Means Samples","kmeansSamples","kmeansSamples",[true]]);if(this.smpDendrogram){a.push(["Color Sample Cluster By","colors",false,false,false,"getDendrogramColorMenu",[]]);if(this.showSmpDendrogram){a.push(["Hide Dendrogram","eyeMinusIcon","showHideDendrogram",["showSmpDendrogram"]])}else{a.push(["Show Dendrogram","eyePlusIcon","showHideDendrogram",["showSmpDendrogram"]])}}a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Clustering"]])}return a};this.getGraphTypeMenu=function(){var a=[];a.push(["Area","area","changeAttribute",["graphType","Area"],"Shit + Alt + A"]);a.push(["Area Line","areaLine","changeAttribute",["graphType","AreaLine"],"Shit + Alt + F"]);a.push(["Bar","bar","changeAttribute",["graphType","Bar"],"Shit + Alt + B"]);a.push(["Bar Line","barLine","changeAttribute",["graphType","BarLine"],"Shit + Alt + C"]);a.push(["Boxplot","boxplot","changeAttribute",["graphType","Boxplot"],"Shit + Alt + I"]);a.push(["Circular","circular","changeAttribute",["graphType","Circular"]]);a.push(["Correlation","correlation","changeAttribute",["graphType","Correlation"],"Shit + Alt + X"]);a.push(["Dot Line","dotplotLine","changeAttribute",["graphType","DotLine"],"Shit + Alt + E"]);a.push(["Dotplot","dotplot","changeAttribute",["graphType","Dotplot"],"Shit + Alt + D"]);a.push(["Heatmap","heatmap","changeAttribute",["graphType","Heatmap"],"Shit + Alt + H"]);a.push(["Line","line","changeAttribute",["graphType","Line"],"Shit + Alt + L"]);a.push(["Pie Chart","pie","changeAttribute",["graphType","Pie"],"Shit + Alt + P"]);if(this.data.y.smps.length>1){a.push(["Scatter 2D","scatter2d","changeAttribute",["graphType","Scatter2D"],"Shit + Alt + 2"])}if(this.data.y.smps.length>2){a.push(["Scatter Bubble 2D","scatterBubble2d","changeAttribute",["graphType","ScatterBubble2D"],"Shit + Alt + 4"]);a.push(["Scatter 3D","scatter3d","changeAttribute",["graphType","Scatter3D"],"Shit + Alt + 3"])}a.push(["Stacked","stacked","changeAttribute",["graphType","Stacked"],"Shit + Alt + S"]);a.push(["Stacked Line","stackedLine","changeAttribute",["graphType","StackedLine"],"Shit + Alt + U"]);a.push(["Stacked Percent","stackedPercent","changeAttribute",["graphType","StackedPercent"],"Shit + Alt + T"]);a.push(["Stacked Percent Line","stackedPercentLine","changeAttribute",["graphType","StackedPercentLine"],"Shit + Alt + W"]);a.push(["Tag Cloud","tagCloud","changeAttribute",["graphType","TagCloud"]]);a.push(["Parallel Coordinates","line","changeAttribute",["graphType","ParallelCoordinates"]]);a.push(["Sankey","network","changeAttribute",["graphType","Sankey"]]);a.push(["Tree","cluster","changeAttribute",["graphType","Tree"]]);a.push(["Treemap","treemap","changeAttribute",["graphType","Treemap"]]);return a};this.getGraphOrientationMenu=function(){var a=[];a.push(["Horizontal","graphOrientationHorizontal","changeAttribute",["graphOrientation","horizontal"]]);a.push(["Vertical","graphOrientationVertical","changeAttribute",["graphOrientation","vertical"]]);return a};this.getMarginsMenu=function(){var a=[];a.push(["General","margin",false,false,false,"changeTextColorAttributeMenu",["-text-","margin"]]);a.push(["-"]);a.push(["Bottom","marginBottom",false,false,false,"changeTextColorAttributeMenu",["-text-","marginBottom"]]);a.push(["Left","marginLeft",false,false,false,"changeTextColorAttributeMenu",["-text-","marginLeft"]]);a.push(["Top","marginTop",false,false,false,"changeTextColorAttributeMenu",["-text-","marginTop"]]);a.push(["Right","marginRight",false,false,false,"changeTextColorAttributeMenu",["-text-","marginRight"]]);return a};this.getShadesMenu=function(){var a=[];a.push(["Objects","shadow","toggleAttribute",["showShadow"]]);a.push(["Text","textShadow","toggleAttribute",["showTextShadow"]]);a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","shadowColor"]]);a.push(["More","more","showConfiguratorCategory",["event","Shadows"]]);return a};this.getCanvasBorderMenu=function(){var a=[];a.push(["Color","colors",false,false,false,"changeTextColorAttributeMenu",["-color-","canvasBoxColor"]]);a.push([this.canvasBox?"Hide Border":"Show Border",this.canvasBox?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["canvasBox"]]);return a};this.getGradientsOrientationMenu=function(){var a=[];a.push(["Horizontal","gradientHorizontal","changeAttribute",["gradientOrientation","horizontal"]]);a.push(["Vertical","gradientVertical","changeAttribute",["gradientOrientation","vertical"]]);return a};this.getGradientsTypeMenu=function(){var a=[];a.push(["Linear","gradientVertical","changeAttribute",["gradientType","linear"]]);a.push(["Radial","gradientRadial","changeAttribute",["gradientType","radial"]]);return a};this.getGradientsMenu=function(){var a=[];a.push(["Gradient","gradientToggle","toggleAttribute",["gradient"]]);a.push(["Orientation","gradientOrientation",false,false,false,"getGradientsOrientationMenu",[]]);a.push(["Type","gradientType",false,false,false,"getGradientsTypeMenu",[]]);a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Gradients"]]);return a};this.getBackgroundTypeMenu=function(){var a=[];a.push(["Solid","background","changeAttribute",["backgroundType","solid","solid"]]);a.push(["Gradient","backgroundGradient","changeAttribute",["backgroundType","gradient","gradient"]]);a.push(["Solid Window","backgroundWindow","changeAttribute",["backgroundType","window","window"]]);a.push(["Solid Window on Gradient","backgroundWindowGradient","changeAttribute",["backgroundType","windowGradient","windowGradient"]]);a.push(["Gradient Window on Solid","backgroundGradientWindow","changeAttribute",["backgroundType","windowSolidGradient","windowSolidGradient"]]);return a};this.getBackgroundMenu=function(){var a=[];a.push(["Type","backgroundType",false,false,false,"getBackgroundTypeMenu",[]]);a.push(["-"]);a.push(["Background Color","background",false,false,false,"changeTextColorAttributeMenu",["-color-","background"]]);a.push(["Window Color","backgroundWindow",false,false,false,"changeTextColorAttributeMenu",["-color-","backgroundWindow"]]);a.push(["Gradient Start Color","backgroundGradient",false,false,false,"changeTextColorAttributeMenu",["-color-","backgroundGradient1Color"]]);a.push(["Gradient End Color","backgroundGradient",false,false,false,"changeTextColorAttributeMenu",["-color-","backgroundGradient2Color"]]);a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Background"]]);return a};this.getFontsSizeStyleMenu=function(){var a=[];a.push(["Bigger","biggerFont","setFontAttributeSize",["fontScaleFontFactor","increase"]]);a.push(["Smaller","smallerFont","setFontAttributeSize",["fontScaleFontFactor","decrease"]]);a.push(["Normal","normalFont","setFontAttributeStyle",["fontStyle","normal"]]);a.push(["Bold","boldFont","setFontAttributeStyle",["fontStyle","bold"]]);a.push(["Italic","italicFont","setFontAttributeStyle",["fontStyle","italic"]]);return a};this.getFontsMenu=function(){var a=[];a.push(["Size and Style","fontSizeStyle",false,false,false,"getFontsSizeStyleMenu",[]]);a.push(["-"]);a.push(["Architects Daughter",this.fontName=="Architects Daughter"?"radioOn":"radioOff","changeAttribute",["fontName","Architects Daughter","Architects Daughter"]]);a.push(["Arial",this.fontName=="Arial"?"radioOn":"radioOff","changeAttribute",["fontName","Arial","Arial"]]);a.push(["Courier",this.fontName=="Courier"?"radioOn":"radioOff","changeAttribute",["fontName","Courier","Courier"]]);a.push(["Indie Flower",this.fontName=="Indie Flower"?"radioOn":"radioOff","changeAttribute",["fontName","Indie Flower","Indie Flower"]]);a.push(["Roboto",this.fontName=="Roboto"?"radioOn":"radioOff","changeAttribute",["fontName","Roboto","Roboto"]]);a.push(["Ubuntu",this.fontName=="Ubuntu"?"radioOn":"radioOff","changeAttribute",["fontName","Ubuntu","Ubuntu"]]);a.push(["Verdana",this.fontName=="Verdana"?"radioOn":"radioOff","changeAttribute",["fontName","Verdana","Verdana"]]);a.push(["-"]);a.push(["More","more","showConfiguratorCategory",["event","Text"]]);return a};this.getLayoutVarMenu=function(){var d=[];var a={};for(var b=0;b<this.segregateVariablesBy.length;b++){a[this.segregateVariablesBy[b]]=true}if(this.data.z){var c=this.sortObject(this.data.z);for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked":"unchecked","showVariableSegregation",[c[b]]])}d.push(["-"])}d.push(["variable",a.variable?"checked":"unchecked","showVariableSegregation",["variable"]]);return d};this.getLayoutSmpMenu=function(){var a=[];var d={};for(var c=0;c<this.segregateSamplesBy.length;c++){d[this.segregateSamplesBy[c]]=true}if(this.data.x){var b=this.sortObject(this.data.x);for(var c=0;c<b.length;c++){a.push([b[c],d[b[c]]?"checked":"unchecked","showSampleSegregation",[b[c]]])}a.push(["-"])}a.push(["sample",d.sample?"checked":"unchecked","showSampleSegregation",["sample"]]);return a};this.getLayoutMenu=function(){var a=[];if(!this.graphType.match(/Scatter/)&&!this.is3DPlot){a.push(["Segregate Samples By","samples",false,false,false,"getLayoutSmpMenu",[]]);a.push(["Segregate Variables By","variables",false,false,false,"getLayoutVarMenu",[]])}return a};this.getSegregationMenu=function(){var d=[];var c={};var d=[];if(this.data.z){var e=this.sortObject(this.data.z);for(var b=0;b<this.segregateVariablesBy.length;b++){c[this.segregateVariablesBy[b]]=true}for(var b=0;b<e.length;b++){d.push([e[b],c[e[b]]?"checked":"unchecked","showVariableSegregation",[e[b]]])}d.push(["-"])}if(this.data.x){var a=this.sortObject(this.data.x);for(var b=0;b<this.segregateSamplesBy.length;b++){c[this.segregateSamplesBy[b]]=true}for(var b=0;b<a.length;b++){d.push([a[b],c[a[b]]?"checked":"unchecked","showSampleSegregation",[a[b]]])}d.push(["-"])}d.push(["variable",c.variable?"checked":"unchecked","showVariableSegregation",["variable"]]);d.push(["sample",c.sample?"checked":"unchecked","showSampleSegregation",["sample"]]);if(!this.graphType.match(/Scatter/)&&!this.is3DPlot&&d.length>0){return d}else{return false}};this.getColorSpectrumMenu=function(b,g,m,l,k){var c=[];var a=this.getObjectArray(b);var f=this.getColorNames();for(var e=0;e<f.length;e++){if(a[f[e]]){var h=0;for(var d=0;d<b.length;d++){if(f[e]==b[d]){h=d;break}}if(m&&l){c.push([f[e]+" ("+(h+1)+")","checked",g,[f[e],m,l]])}else{c.push([f[e]+" ("+(h+1)+")","checked",g,[f[e]]])}}else{if(m&&l){c.push([f[e],"unchecked",g,[f[e],m,l]])}else{c.push([f[e],"unchecked",g,[f[e]]])}}}return c};this.getColorSchemeMenu=function(e,f){var d=[];var a=this.getColorSchemes();for(var b=0;b<a.length;b++){d.push([a[b],this[e]==a[b]?"radioOn":"radioOff","changeAttribute",[e,a[b],false,f]])}return d};this.getColorsSpectrumCompMenu=function(){var a=[];a.push(["Colors","colors",false,false,false,"getColorSpectrumMenu",[this.colorSpectrum,"changeColorSpectrum"]]);a.push(["Zero-Center","z",false,false,false,"changeTextColorAttributeMenu",["-text-",[false,"changeColorSpectrumZeroValue",[null]]]]);return a};this.getColorsMenu=function(){var a=[];a.push(["Scheme","palette",false,false,false,"getColorSchemeMenu",["colorScheme","changeColorScheme"]]);a.push(["Spectrum","indicatorCenterRainbow",false,false,false,"getColorsSpectrumCompMenu",[]]);return a};this.getResizeMenu=function(){var a=[];a.push(["Height","resizeVer",false,false,false,"changeTextColorAttributeMenu",["-text-",["height","setHeight"]]]);a.push(["Width","resizeHor",false,false,false,"changeTextColorAttributeMenu",["-text-",["width","setWidth"]]]);return a};this.getThemeMenu=function(){var a=[];a.push(["CanvasXpress",this.theme=="cx"?"radioOn":"radioOff","changeTheme",["cx"]]);a.push(["Economist",this.theme=="economist"?"radioOn":"radioOff","changeTheme",["economist"]]);a.push(["GGPlot",this.theme=="ggplot"?"radioOn":"radioOff","changeTheme",["ggplot"]]);a.push(["Gray-Inverse",this.theme=="igray"?"radioOn":"radioOff","changeTheme",["igray"]]);a.push(["Excel",this.theme=="excel"?"radioOn":"radioOff","changeTheme",["excel"]]);a.push(["Paul Tol",this.theme=="paulTol"?"radioOn":"radioOff","changeTheme",["paulTol"]]);a.push(["Solarized",this.theme=="solarized"?"radioOn":"radioOff","changeTheme",["solarized"]]);a.push(["Stata",this.theme=="stata"?"radioOn":"radioOff","changeTheme",["stata"]]);a.push(["Tableau",this.theme=="tableau"?"radioOn":"radioOff","changeTheme",["tableau"]]);a.push(["Wall Street Journal",this.theme=="wallStreetJournal"?"radioOn":"radioOff","changeTheme",["wallStreetJournal"]]);a.push(["-"]);a.push(["None",this.theme=="none"?"radioOn":"radioOff","changeTheme",["none"]]);return a};this.getGeneralMenu=function(){var a=[];a.push(["Background","background",false,false,false,"getBackgroundMenu",[]]);a.push(["Border","border",false,false,false,"getCanvasBorderMenu",[]]);a.push(["Color","colors",false,false,false,"getColorsMenu",[]]);a.push(["Font","fontSizeStyle",false,false,false,"getFontsMenu",[]]);a.push(["Gradients","gradientDiagonal",false,false,false,"getGradientsMenu",[]]);if(!this.graphType.match(/Scatter/)&&!this.is3DPlot){a.push(["Graph Orientation","graphOrientation",false,false,false,"getGraphOrientationMenu",[]])}a.push(["Graph Type","graphType",false,false,false,"getGraphTypeMenu",[]]);if(!this.graphType.match(/Scatter/)&&!this.is3DPlot){a.push(["Layout","segregate",false,false,false,"getLayoutMenu",[]])}a.push(["Margins","margin",false,false,false,"getMarginsMenu",[]]);a.push(["Shadows","shadow",false,false,false,"getShadesMenu",[]]);a.push(["Size","resize",false,false,false,"getResizeMenu",[]]);a.push(["Theme","palette",false,false,false,"getThemeMenu",[]]);a.push(["Transparency","transparency",false,false,false,"changeTextColorAttributeMenu",["-text-","transparency"]]);return a};this.getSwitchSmpToAnnotationMenu=function(){var b=[];for(var a=0;a<this.data.y.smps.length;a++){b.push([this.data.y.smps[a],"radioOff","switchSmpToAnnotation",[this.data.y.smps[a]]])}return b};this.getSwitchAnnotationToSmpMenu=function(){var c=[];var b=this.sortObject(this.data.z);for(var a=0;a<b.length;a++){if(this.meta.data.z[b[a]]){c.push([b[a],"radioOff","switchAnnotationToSmp",[b[a]]])}}return c};this.getSwitchSmpAnnotationToIdMenu=function(){var c=[];var a=this.sortObject(this.data.x);for(var b=0;b<a.length;b++){if(this.meta.data.x[a[b]].unique){c.push([a[b],"radioOff","switchSmpAnnotationToId",[a[b]]])}}return c};this.getSwitchVarToAnnotationMenu=function(){var a=[];for(var b=0;b<this.data.y.vars.length;b++){a.push([this.data.y.vars[b],"radioOff","switchVarToAnnotation",[this.data.y.vars[b]]])}return a};this.getSwitchAnnotationToVarMenu=function(){var b=[];var a=this.sortObject(this.data.x);for(var c=0;c<a.length;c++){if(this.meta.data.x[a[c]]){b.push([a[c],"radioOff","switchAnnotationToVar",[a[c]]])}}return b};this.getSwitchVarAnnotationToIdMenu=function(){var c=[];var b=this.sortObject(this.data.z);for(var a=0;a<b.length;a++){if(this.meta.data.z[b[a]].unique){c.push([b[a],"radioOff","switchVarAnnotationToId",[b[a]]])}}return c};this.getSwitchSamplesMenu=function(){var a=[];a.push(["Sample to Annotation","switchb",false,false,false,"getSwitchSmpToAnnotationMenu",[]]);if(this.data.z){a.push(["Annotation to Sample","switchu",false,false,false,"getSwitchAnnotationToSmpMenu",[]])}if(this.data.x&&this.isUniqueFactor("s")){a.push(["Annotation to Id","switch",false,false,false,"getSwitchSmpAnnotationToIdMenu",[]])}a.push(["Create New Sample Id","more","switchSmpIdToAnnotation",[]]);return a};this.getSwitchVariablesMenu=function(){var a=[];a.push(["Variable to Annotation","switchb",false,false,false,"getSwitchVarToAnnotationMenu",[]]);if(this.data.x){a.push(["Annotation to Variable","switchu",false,false,false,"getSwitchAnnotationToVarMenu",[]])}if(this.data.z&&this.isUniqueFactor("v")){a.push(["Annotation to Id","switch",false,false,false,"getSwitchVarAnnotationToIdMenu",[]])}a.push(["Create New Variable Id","more","switchVarIdToAnnotation",[]]);return a};this.getSwitchMenu=function(){var a=[];a.push(["Samples","samples",false,false,false,"getSwitchSamplesMenu",[]]);a.push(["Variables","variables",false,false,false,"getSwitchVariablesMenu",[]]);return a};this.getConvertNumericToStringMenu=function(f,b){var d=[];var e=this.sortObject(this.data[f]);for(var a=0;a<e.length;a++){if(this.meta.data[f][e[a]]&&this.meta.data[f][e[a]].type=="Numeric"){d.push([e[a],"radioOff","switchNumericToString",[e[a],b]])}}return d};this.getConvertStringToNumericMenu=function(f,b){var d=[];var e=this.sortObject(this.data[f]);for(var a=0;a<e.length;a++){if(this.meta.data[f][e[a]]&&this.meta.data[f][e[a]].type!="Numeric"){d.push([e[a],"radioOff","switchStringToNumeric",[e[a],b]])}}return d};this.getConvertVarSmpMenu=function(d,a){var b=[];if(this.isNumericFactor(a)){b.push(["Numeric to String","convertNumberString",false,false,false,"getConvertNumericToStringMenu",[d,a=="s"]])}if(this.isStringFactor(a)){b.push(["String to Numeric","convertStringNumber",false,false,false,"getConvertStringToNumericMenu",[d,a=="s"]])}return b};this.getConvertMenu=function(){var a=[];if(this.data.x){a.push(["Samples","samples",false,false,false,"getConvertVarSmpMenu",["x","s"]])}if(this.data.z){a.push(["Variables","variables",false,false,false,"getConvertVarSmpMenu",["z","v"]])}return a};this.getTransformPercentMenu=function(){var a=[];a.push(["By Sample","samples","transform",["percentile","samples"]]);a.push(["By Variable","variables","transform",["percentile","variables"]]);return a};this.getTransformZScoreMenu=function(){var a=[];a.push(["By Sample","samples","transform",["zscore","samples"]]);a.push(["By Variable","variables","transform",["zscore","variables"]]);return a};this.getTransformRatioMenu=function(){var a=[];a.push(["To Sample","samples",false,false,false,"getTransformRatioSmpMenu",[]]);if(this.data.x&&this.isGroupedData){a.push(["To Group","groups",false,false,false,"getTransformRatioGrpMenu",[]]);if(this.ratioGroupReference&&this.data.x.hasOwnProperty(this.ratioGroupReference)){a.push(["To Level","levels",false,false,false,"getTransformRatioLevMenu",[]])}}return a};this.getTransformRatioLevMenu=function(){var c=[];var a=this.sortObject(this.getObjectArray(this.data.x[this.ratioGroupReference]));for(var b=0;b<a.length;b++){if(a[b]!=null){c.push([a[b],this.ratioLevelReference==a[b]?"radioOn":"radioOff","changeTransformRatio",["level",a[b]]])}}return c};this.getTransformRatioGrpMenu=function(){var b=[];var a=this.sortObject(this.data.x);for(var c=0;c<a.length;c++){b.push([a[c],this.ratioGroupReference==a[c]?"radioOn":"radioOff","changeTransformRatio",["group",a[c]]])}return b};this.getTransformRatioSmpMenu=function(){var c=[];for(var a=0;a<this.data.y.smps.length;a++){var b=this.data.y.smps[a];c.push([b,this.ratioSampleReference==b?"radioOn":"radioOff","changeTransformRatio",["sample",b]])}return c};this.getTransformMenu=function(){var a=[];a.push(["Log Base 2","log2","transform",["log2"]]);a.push(["Log Base 10","log10","transform",["log10"]]);a.push(["Exp Base 2","exp2","transform",["exp2"]]);a.push(["Exp Base 10","exp10","transform",["exp10"]]);a.push(["Ceil data","ceil",false,false,false,"changeTextColorAttributeMenu",["-text-",[false,"modifyTransform",["tceil"]]]]);a.push(["Floor data","floor",false,false,false,"changeTextColorAttributeMenu",["-text-",[false,"modifyTransform",["tfloor"]]]]);a.push(["Percentile","percent2",false,false,false,"getTransformPercentMenu",[]]);a.push(["Z-Score","zScore",false,false,false,"getTransformZScoreMenu",[]]);a.push(["Ratio","ratio",false,false,false,"getTransformRatioMenu",[]]);a.push(["-"]);a.push(["Reset","refreshForm","transform",["reset"]]);a.push(["-"]);a.push(["Overwrite data","disk","transform",["save"]]);return a};this.getAxisTransformMenu=function(b){var c=[];b=b.toLowerCase();c.push(["Log Base 2","log2","changeAttribute",[b+"AxisTransform","log2"]]);c.push(["Log Base 10","log10","changeAttribute",[b+"AxisTransform","log10"]]);c.push(["Exp Base 2","exp2","changeAttribute",[b+"AxisTransform","exp2"]]);c.push(["Exp Base 10","exp10","changeAttribute",[b+"AxisTransform","exp10"]]);c.push(["Percentile","percent2","changeAttribute",[b+"AxisTransform","exp10"]]);c.push(["-"]);c.push(["Reset","refreshForm","changeAttribute",[b+"AxisTransform",false]]);return c};this.getSortSmpIntensityMenu=function(){var c=[];var a={};if(this.sortingSamples){for(var b=0;b<this.sortingSamples.length;b++){a[this.sortingSamples[b]]=true}}for(var b=0;b<this.data.y.smps.length;b++){c.push([this.data.y.smps[b],a[b+1]?"radioOn":"radioOff","showSorting",["smp","var",this.data.y.smps[b]]])}return c};this.getSortVarIntensityMenu=function(){var c=[];var a={};if(this.sortingVariables){for(var b=0;b<this.sortingVariables.length;b++){a[this.sortingVariables[b]]=true}}for(var b=0;b<this.data.y.vars.length;b++){c.push([this.data.y.vars[b],a[b+1]?"radioOn":"radioOff","showSorting",["var","smp",this.data.y.vars[b]]])}return c};this.getSortSmpCatMenu=function(){var d=[];var b={};var a=this.sortObject(this.data.x);if(this.sortingSampleCategories){for(var c=0;c<this.sortingSampleCategories.length;c++){b[this.sortingSampleCategories[c]]=true}}for(var c=0;c<a.length;c++){d.push([a[c],b[a[c]]?"checked":"unchecked","showSorting",["cat","smp",a[c]]])}return d};this.getSortVarCatMenu=function(){var d=[];var a={};var c=this.sortObject(this.data.z);if(this.sortingVariableCategories){for(var b=0;b<this.sortingVariableCategories.length;b++){a[this.sortingVariableCategories[b]]=true}}for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked":"unchecked","showSorting",["cat","var",c[b]]])}return d};this.getSortSmpMenu=function(){var a=[];a.push(["By Variable Intensity","variables",false,false,false,"getSortVarIntensityMenu",[]]);if(this.data.x){a.push(["By Sample Category","X",false,false,false,"getSortSmpCatMenu",[]])}a.push(["By Name","samples","showSorting",["cat","smp","samples"]]);return a};this.getSortVarMenu=function(){var a=[];a.push(["By Sample Intensity","samples",false,false,false,"getSortSmpIntensityMenu",[]]);if(this.data.z){a.push(["By Variable Category","z",false,false,false,"getSortVarCatMenu",[]])}a.push(["By Name","variables","showSorting",["cat","var","variables"]]);return a};this.getSortMenu=function(){var a=[];if(this.sortDir=="ascending"){a.push(["Change Sorting","sortAsciiDesc","changeAttribute",["sortDir","descending",true]])}else{a.push(["Change Sorting","sortAsciiAsc","changeAttribute",["sortDir","ascending",true]])}a.push(["Case Sensitive",this.sortCaseSensitive?"checked":"unchecked","toggleAttribute",["sortCaseSensitive"]]);a.push(["-"]);a.push(["Sort Samples","samples",false,false,false,"getSortSmpMenu",[]]);a.push(["Sort Variables","variables",false,false,false,"getSortVarMenu",[]]);return a};this.getSliderMenu=function(){var a=[];for(var b in this.binConfigurations){a.push([b,false,false,false,false,[["-slider-","changeBin",[b]]]])}return a};this.getPivotMenu=function(){var b=[];if(this.isPivotable()){if(this.data.y.vars.length==3){var c=this.data.y.vars;b.push([c[0]+" as Variables; "+c[1]+" as Samples","radioOff","pivotYY",[c[0],c[1]]]);b.push([c[0]+" as Variables; "+c[2]+" as Samples","radioOff","pivotYY",[c[0],c[2]]]);b.push([c[1]+" as Variables; "+c[0]+" as Samples","radioOff","pivotYY",[c[1],c[0]]]);b.push([c[1]+" as Variables; "+c[2]+" as Samples","radioOff","pivotYY",[c[1],c[2]]]);b.push([c[2]+" as Variables; "+c[0]+" as Samples","radioOff","pivotYY",[c[2],c[0]]]);b.push([c[2]+" as Variables; "+c[1]+" as Samples","radioOff","pivotYY",[c[2],c[1]]])}else{if(this.data.y.vars.length==2){var c=this.data.y.vars;var a=this.getKeys(this.data.x);b.push([a[0]+" as Variables; "+c[0]+" as Samples","radioOff","pivotXY",[a[0],c[0]]]);b.push([a[0]+" as Variables; "+c[1]+" as Samples","radioOff","pivotXY",[a[0],c[1]]]);b.push([c[0]+" as Variables; "+a[0]+" as Samples","radioOff","pivotXY",[c[0],a[0]]]);b.push([c[1]+" as Variables; "+a[0]+" as Samples","radioOff","pivotXY",[c[1],a[0]]])}else{var a=this.getKeys(this.data.x);b.push([a[0]+" as Variables; "+a[1]+" as Samples","radioOff","pivotXX",[a[0],a[1]]]);b.push([a[1]+" as Variables; "+a[0]+" as Samples","radioOff","pivotXX",[a[1],a[0]]])}}}return b};this.getRdatasetsMenu=function(){var a=[];if(this.Rdatasets){var c=this.sortObject(this.Rdatasets);c=c.sort(function(e,d){return e.toLowerCase()>d.toLowerCase()});for(var b=0;b<c.length;b++){a.push([c[b],"radioOff","getRLibraryDataSets",[c[b]]])}}return a};this.getRangeMenu=function(){var a=[];a.push(["Set Min","minimumValue",false,false,false,"changeTextColorAttributeMenu",["-text-","setMinX"]]);a.push(["Set Max","maximumValue",false,false,false,"changeTextColorAttributeMenu",["-text-","setMaxX"]]);a.push(["Exact Range","exactValue","toggleAttribute",["xAxisExact"]]);return a};this.getSummaryTypeMenu=function(){var c=[];var b=["mean","median","min","max","sum"];c.push(["Raw",!this.summaryType||this.summaryType=="raw"?"radioOn":"radioOff","modifySummaryType",["raw"]]);for(var a=0;a<b.length;a++){c.push([this.capitalize(b[a]),this.summaryType==b[a]?"radioOn":"radioOff","modifySummaryType",[b[a]]])}return c};this.getDataMenu=function(){var a=[];if(this.isBinConfigurations()){a.push(["Configure Bins","ub",false,false,false,"getSliderMenu",[]])}if(this.data.x||this.data.z){a.push(["Convert Annotations","convert",false,false,false,"getConvertMenu",[]])}if(this.graphType=="Heatmap"){a.push(["Range","range",false,false,false,"getRangeMenu",[]])}a.push(["Summary Type","sum",false,false,false,"getSummaryTypeMenu",[]]);a.push(["Switch Data","switch",false,false,false,"getSwitchMenu",[]]);if(!this.graphType.match(/Scatter/i)){a.push(["Sort","sortAsciiAsc",false,false,false,"getSortMenu",[]])}a.push(["Transform","transform",false,false,false,"getTransformMenu",[]]);if(!this.layoutValid){a.push(["Transpose","transposeData","transpose"])}if(this.isPivotable()){a.push(["Pivot","pivot",false,false,false,"getPivotMenu",[]])}if(!this.layoutValid){a.push(["Bin Data","binData",false,false,false,"getBinDataMenu",[]])}return a};this.getLoessMenu=function(){var a=[];a.push([this.showLoessFit?"Hide Loess Fit":"Show Loess Fit",this.showLoessFit?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showLoessFit"]]);return a};this.getHistogramDensityMenu=function(){var b=["epanechnikovKernel","uniformKernel","triangularKernel","quarticKernel","triweightKernel","gaussianKernel","cosineKernel"];var a=[];for(var d=0;d<b.length;d++){var c=b[d].replace("Kernel","");a.push([c,b[d]==this.histogramDensityKernel?"radioOn":"radioOff","changeAttribute",["histogramDensityKernel",b[d],false,"modifyHistogram"]])}return a};this.getHistogramMenu=function(){var a=[];a.push(["Bin Number","editNumber",false,false,false,"changeTextColorAttributeMenu",["-text-",["histogramBins","modifyHistogram"]]]);a.push(["Density Kernel","kernelHistogram",false,false,false,"getHistogramDensityMenu",[]]);a.push(["Remove Histogram","removeHistogram","removeHistogram"]);a.push([this.showHistogramDensity?"Hide Density":"Show Density",this.showHistogramDensity?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showHistogramDensity","modifyHistogram"]]);a.push(["Stagger Histograms","histogramStagger","toggleAttribute",["histogramStagger","modifyHistogram"]]);a.push(["More","more","showConfiguratorCategory",["event","Histograms"]]);return a};this.getDOEMenu=function(){var d=[];var c=this.initialGraphType.match(/Scatter/)?this.getKeys(this.dataStndBy.z):this.getKeys(this.dataStndBy.x);var a=this.getObjectArray(this.includeDOE);for(var b=0;b<c.length;b++){d.push([c[b],a[c[b]]?"checked":"unchecked","modifyDOE",[c[b]]])}return d};this.getCorrelationCatMenu=function(f,d){var b=[];var e=this.sortObject(this.data[f]);for(var a=0;a<e.length;a++){if(this.isNumeric(this.data[f][e[a]])){b.push([e[a],"radioOff","correlateData",[d,e[a]]])}}return b};this.getCorrelationMenu=function(){var b=[];var a=[];if(this.data.y.vars.length>3){b.push(["Samples","samples","correlateData"])}if(this.data.y.smps.length>3&&this.data.x&&this.isNumericFactor("s")){b.push(["Sample Annotation","samples",false,false,false,"getCorrelationCatMenu",["x",true]])}if(this.data.y.smps.length>3){b.push(["Variables","variables","correlateData",[true]])}if(this.data.y.vars.length>3&&this.data.z&&this.isNumericFactor("v")){b.push(["Variable Annotation","variables",false,false,false,"getCorrelationCatMenu",["z",false]])}return b};this.getMagnificationMenu=function(){var a=[];for(var b=1;b<=10;b++){a.push([(96*b)+" DPI",this.printMagnification==b?"radioOn":"radioOff","changeAttributeNoDraw",["printMagnification",b]])}return a};this.getParametersMenu=function(){var a=[];a.push(["Load Parameters","add2",true,[]]);a.push(["Save as JSON","disk","save",[]]);return a};this.getFileMenu=function(){var a=[];a.push(["Save as PNG","camera","print",[],"Ctrl + P"]);if(!this.graphType.match(/Venn|TagCloud|Map/)){a.push(["Save as SVG","cameraSVG","saveSVG",[]])}a.push(["Save as JSON","disk","save",[]]);a.push(["Print Magnification","find",false,false,false,"getMagnificationMenu",[]]);a.push(["-"]);a.push(["Reproducible Research","RepRsrch","clickRepResearch",[]]);a.push(["Show JSON code","purpleCode","clickShowCode",[]]);a.push(["Reproduce","redo","reproduce",[],"Ctrl + Alt + R"]);a.push(["Demonstrate","eyeArrowIcon","demonstrate",[],"Ctrl + Alt + D"]);if(this.remoteService&&this.remoteServiceType=="webService"){a.push(["Save customizations to server","disk","saveRemote",["afterRender"]]);a.push(["Clear parameters from server","deleteSaved","clearRemote",[]])}a.push(["-"]);a.push(["Load","add2",true,[]]);if(this.Rdatasets){a.push(["R Datasets","CRAN",false,false,false,"getRdatasetsMenu",[]])}a.push(["-"]);a.push(["Parameters","cog",false,false,false,"getParametersMenu",[]]);a.push(["-"]);a.push(["Reset","refreshForm","masterReset",[],"ESC"]);return a};this.getExploreMenu=function(){var a=[];a.push(["Filters","funnel","clickDataFilters",[]]);a.push(["Table","table","clickDataTable",[]]);a.push(["Configure","configure","clickDataExplorer",[]]);a.push(["-"]);a.push(["Search Parameters","find","addConfiguratorCloseMenus"]);return a};this.getConfigurationMenu=function(){var e=this.decorations;var b={Bar:true,Line:true,Area:true,AreaLine:true,BarLine:true,Boxplot:true,Dotplot:true,DotLine:true,Heatmap:true,Treemap:true,TagCloud:true,ParallelCoordinates:true,Sankey:true,Stacked:true,StackedLine:true,StackedPercent:true,StackedPercentLine:true,Candlestick:true};var a=[];if(this.isMap||this.graphType=="Tree"){a.push(["Citation",this.graphType=="Heatmap"?"citationH":"citation1",false,false,false,"getGraphPartMenu",["citation"]]);a.push(["Legend","legends",false,false,false,"getLegendMenu",[]]);a.push(["Title / Subtitle",this.graphType=="Heatmap"?"titleSubtitleH":"titleSubtitle",false,false,false,"getTitleSubtitleMenu",[]])}else{if(b[this.graphType]&&!this.is3DPlot){if(this.graphType!="Heatmap"){a.push(["Axes","axis1",false,false,false,"getAxesMenu",[]]);a.push(["Axes Titles","axisTitle1",false,false,false,"getAxesTitleMenu",[]])}a.push(["Citation",this.graphType=="Heatmap"?"citationH":"citation1",false,false,false,"getGraphPartMenu",["citation"]]);a.push(["General",this.graphType=="Heatmap"?"generalH":"general1",false,false,false,"getGeneralMenu",[]]);a.push(["Grid","grid",false,false,false,"getPlotAreaGridMenu",["x"]]);if(this.graphType!="Heatmap"){a.push(["Plot Area","plotArea",false,false,false,"getPlotAreaOneMenu",[]]);if(e){a.push(["Decorations","decorationLines",false,false,false,"getDecorationsMenu",[]])}a.push(["Legend","legends",false,false,false,"getLegendMenu",[]]);if(this.data.x){a.push(["Overlays","overlaysSamplesH",false,false,false,"getOverlaysMenu",[]])}}if(this.graphType=="Heatmap"){a.push(["Indicator","indicator",false,false,false,"getIndicatorMenu",[]]);a.push(["Heatmap","heatmap",false,false,false,"getHeatmapMenu",[]]);if(this.data.x||this.data.z){a.push(["Overlays","overlaysSamplesH",false,false,false,"getOverlaysMenu",[]])}}a.push(["Sample Labels",this.graphType=="Heatmap"?"sampleLabelsH":"sampleLabels1",false,false,false,"getSmpLabelMenu",[]]);a.push(["Samples Title",this.graphType=="Heatmap"?"sampleTitleH":"sampleTitle1",false,false,false,"getGraphPartMenu",["smpTitle",true]]);if(this.graphType=="Heatmap"){a.push(["Variable Labels","variableLabelsH",false,false,false,"getVarLabelMenu",[]]);a.push(["Variables Title","variableTitleH",false,false,false,"getGraphPartMenu",["varTitle",true]])}a.push(["Title / Subtitle",this.graphType=="Heatmap"?"titleSubtitleH":"titleSubtitle",false,false,false,"getTitleSubtitleMenu",[]])}else{if(this.graphType.match(/scatter/i)||this.is3DPlot){a.push(["Axes","axesS",false,false,false,"getAxesMenu",[]]);a.push(["Axes Titles","axesTitlesS",false,false,false,"getAxesTitleMenu",[]]);a.push(["Citation","citationS",false,false,false,"getGraphPartMenu",["citation"]]);a.push(["General","generalS",false,false,false,"getGeneralMenu",[]]);a.push(["Grid","gridS",false,false,false,"getPlotAreaScatterGridMenu",[]]);a.push(["Plot Area","plotArea",false,false,false,"getPlotAreaScatterMenu",[]]);if(e){var c=e.nlfit?"nonlinearFit":e.line?"decorationLine":e.lines?"decorationLines":e.reg?"regressionLine":e.nor?"normalDistribution":e.area?"decorationArea":e.kaplanMeier?"kaplanMeier":false;a.push(["Decorations",c,false,false,false,"getDecorationsMenu",[]])}a.push(["Legend","legendS",false,false,false,"getLegendMenu",[]]);a.push(["Title / Subtitle","titleSubtitleS",false,false,false,"getTitleSubtitleMenu",[]]);if(this.isSelectDataPoints){a.push(["Show hidden data points","showSelected","showHideSelectedDataPoint",[false,45],"Ctrl + Insert"]);a.push(["Hide data points","hideSelected","showHideSelectedDataPoint",[false,46],"Ctrl + Delete"])}}}}return a};this.getAlignNetworkMenu=function(){var a=[];a.push(["Top","alignTop","alignDistributeSelectedNodes",[false,84]]);a.push(["Right","alignRight","alignDistributeSelectedNodes",[false,82]]);a.push(["Bottom","alignBottom","alignDistributeSelectedNodes",[false,66]]);a.push(["Left","alignLeft","alignDistributeSelectedNodes",[false,76]]);return a};this.getDistributeNetworkMenu=function(){var a=[];a.push(["Vertically","distributeVertical","alignDistributeSelectedNodes",[false,86]]);a.push(["Horozontally","distributeHorizontal","alignDistributeSelectedNodes",[false,72]]);return a};this.getRotateNetworkMenu=function(){var a=[];a.push(["Clockwise","rotateClockwise","arrowMove",[34]]);a.push(["Clockwise - Animate","rotateClockwiseCont","arrowMove",[39,true]]);a.push(["Anticlockwise","rotateAnticlockwise","arrowMove",[33]]);a.push(["Anticlockwise - Animate","rotateAnticlockwiseCont","arrowMove",[37,true]]);return a};this.getOrderNetworkMenu=function(){var a=[];a.push(["Send to back","moveBack","orderNodes",["sendNodeToBack"]]);a.push(["Send backward","moveBackwards","orderNodes",["sendNodeBackward"]]);a.push(["Bring to front","moveFront","orderNodes",["bringNodeToFront"]]);a.push(["Bring forward","moveForwards","orderNodes",["bringNodeForward"]]);return a};this.getNetworkNodeEdgeAttributesMenu=function(){var a=[];a.push(["Nodes","nodes",false,false,false,"getNetworkNodeAttributesMenu",[]]);a.push(["Edges","edges",false,false,false,"getNetworkEdgeAttributesMenu",[]]);return a};this.getNetworkNodeAttributesPropertyMenu=function(b){var d=[];var c=this.sortObject(this.meta.data.nodes);for(var a=0;a<c.length;a++){d.push([c[a],this[b]==c[a]?"radioOn":"radioOff","changeAttribute",[b,c[a]]])}return d};this.getNetworkNodeAttributesMenu=function(){var a=[];a.push(["Color By","colors",false,false,false,"getNetworkNodeAttributesPropertyMenu",["colorNodeBy"]]);a.push(["Shape By","shapes",false,false,false,"getNetworkNodeAttributesPropertyMenu",["shapeNodeBy"]]);a.push(["Size By","sizes",false,false,false,"getNetworkNodeAttributesPropertyMenu",["sizeNodeBy"]]);a.push(["Pattern By","patterns",false,false,false,"getNetworkNodeAttributesPropertyMenu",["patternNodeBy"]]);return a};this.getNetworkEdgeAttributesPropertyMenu=function(b){var d=[];var c=this.sortObject(this.meta.data.edges);for(var a=0;a<c.length;a++){d.push([c[a],this[b]==c[a]?"radioOn":"radioOff","changeAttribute",[b,c[a]]])}return d};this.getNetworkEdgeAttributesMenu=function(){var a=[];a.push(["Color By","colors",false,false,false,"getNetworkEdgeAttributesPropertyMenu",["colorEdgeBy"]]);a.push(["Size By","lineWidth",false,false,false,"getNetworkEdgeAttributesPropertyMenu",["sizeEdgeBy"]]);return a};this.setMenu=function(){var a={Bar:true,Line:true,Area:true,AreaLine:true,BarLine:true,Boxplot:true,Dotplot:true,DotLine:true,Heatmap:true,Treemap:true,TagCloud:true,ParallelCoordinates:true,Stacked:true,StackedLine:true,StackedPercent:true,StackedPercentLine:true,Candlestick:true};this.menu=[];this.menu.push(["File","file",false,false,false,"getFileMenu",[]]);this.menu.push(["-"]);if(this.graphType!="Map"){this.menu.push(["Explore","find",false,false,false,"getExploreMenu",[]]);this.menu.push(["-"])}if(this.graphType=="Network"){this.menu.push(["Legend","legends",false,false,false,"getLegendMenu",[]]);this.menu.push(["-"]);this.menu.push(["Data Point Attributes","colorShapeSize",false,false,false,"getNetworkNodeEdgeAttributesMenu",[]]);this.menu.push(["-"]);this.menu.push([this.showNetworkCommunities?"Hide Communities":"Show Communities",this.showNetworkCommunities?"eyeMinusIcon":"eyePlusIcon","toggleAttribute",["showNetworkCommunities"]]);if(this.showNetworkCommunities&&!this.colorNodeBy){this.menu.push(["Coordinate Convex Hull Color","communitiesOn","toggleAttribute",["coordinateNetworkConvexHullCommunityColor"]])}this.menu.push(["-"]);if(this.isSelectNodes){this.menu.push(["Align","alignBottom",false,false,false,"getAlignNetworkMenu",[]]);this.menu.push(["Distribute","distributeVertical",false,false,false,"getDistributeNetworkMenu",[]]);this.menu.push(["Rotate","rotateAnticlockwise",false,false,false,"getRotateNetworkMenu",[]]);this.menu.push(["Order","moveFront",false,false,false,"getOrderNetworkMenu",[]]);this.menu.push(["-"]);this.menu.push(["Show conections","connections","showHideSelectedDataPoint",[false,36],"Ctrl + Home"]);this.menu.push(["-"]);this.menu.push(["Show hidden nodes","showSelected","showHideSelectedDataPoint",[false,45],"Ctrl + Insert"]);this.menu.push(["Hide nodes","hideSelected","showHideSelectedDataPoint",[false,46],"Ctrl + Delete"]);this.menu.push(["-"]);this.menu.push(["Undo","undo","undo",[],"Ctrl + z"]);this.menu.push(["Redo","redo","redo",[],"Ctrl + y"]);this.menu.push(["-"]);this.menu.push(["Recalculate Layout","network2","recalculateLayoutSelectedNodes"])}else{if(this.isHiddenNodes){this.menu.push(["Show hidden nodes","showSelected","hideUnhideNodes",[],"Ctrl + Insert"]);this.menu.push(["-"])}this.menu.push(["Rotate","rotateAnticlockwise",false,false,false,"getRotateNetworkMenu",[]]);this.menu.push(["-"]);this.menu.push(["Redraw","refreshForm","recalculateLayout"])}}if(this.graphType=="Map"){this.menu.push(["Customize","cog",false,false,false,"getConfigurationMenu",[]]);this.menu.push(["-"]);if(this.data.z){this.menu.push(["Color By","colors",false,false,false,"getDataPointAttributesPropertyMenu",["colorBy"]])}}else{if(this.graphType=="Tree"){this.menu.push(["Customize","cog",false,false,false,"getConfigurationMenu",[]]);this.menu.push(["-"]);if(this.data.x){this.menu.push(["Data Point Attributes","colorShapeSize",false,false,false,"getDataPointAttributesMenu",[]]);this.menu.push(["-"])}this.menu.push(["Layout","cluster",false,false,false,"getDendrogramsMenu",[]])}else{if(this.graphType=="Circular"){this.menu.push(["Cluster","cluster",false,false,false,"getDendrogramsMenu",[]]);this.menu.push(["-"])}}}if(this.isDOE){this.menu.push(["Modify Meta-Data Plots","doe",false,false,false,"getDOEMenu",[]]);this.menu.push(["Remove Meta-Data Plots","removeDoe","removeDOE"]);this.menu.push(["-"])}else{if(a[this.graphType]&&!this.is3DPlot){this.menu.push(["Customize","cog",false,false,false,"getConfigurationMenu",[]]);this.menu.push(["-"]);this.menu.push(["Data","data",false,false,false,"getDataMenu",[]]);this.menu.push(["-"]);if(this.data.x||this.graphType=="ParallelCoordinates"||this.graphType=="Line"){this.menu.push(["Data Point Attributes","colorShapeSize",false,false,false,"getDataPointAttributesMenu",[]]);this.menu.push(["-"])}if((this.data.x||this.data.z)&&this.isRawData){if(this.data.x){this.menu.push(["Group Samples","groupSamples",false,false,false,"getGroupSamplesMenu",[]])}if(this.data.x||this.data.z){this.menu.push(["Segregate Data","segregate",false,false,false,"getSegregationMenu",[]])}this.menu.push(["-"])}if(!this.layoutValid&&this.isRawData){this.menu.push(["Cluster","cluster",false,false,false,"getDendrogramsMenu",[]]);this.menu.push(["-"]);if(this.isHistogram){this.menu.push(["Histogram","histogram",false,false,false,"getHistogramMenu",[]])}else{if(!this.isCorrelate){this.menu.push(["Correlate","regressionLine",false,false,false,"getCorrelationMenu",[]]);if(this.data.x){this.menu.push(["Explore Meta-Data","doe","createDOE"])}this.menu.push(["Histogram","histogram","createHistogramTr"])}}}}else{if(this.graphType=="Circular"){this.menu.push(["Data","data",false,false,false,"getDataMenu",[]]);this.menu.push(["-"]);if(this.data.x||this.data.z){if(this.data.x||this.data.z){this.menu.push(["Segregate Data","segregate",false,false,false,"getSegregationMenu",[]])}this.menu.push(["-"])}}else{if(this.graphType.match(/scatter/i)||this.is3DPlot){this.menu.push(["Customize","cog",false,false,false,"getConfigurationMenu",[]]);this.menu.push(["-"]);this.menu.push(["Data","data",false,false,false,"getDataMenu",[]]);this.menu.push(["-"]);if(this.graphType=="Scatter2D"){if(this.isHistogram){this.menu.push(["Histogram","histogram",false,false,false,"getHistogramMenu",[]])}else{if(this.isCorrelate){this.menu.push(["Remove Correlation","removeRegressionLine","removeCorrelation"])}else{if(this.decorations&&this.decorations.reg){this.menu.push(["Remove Correlation","removeRegressionLine","removeCorrelation"])}else{this.menu.push(["Loess","nonlinearFit",false,false,false,"getLoessMenu",[]]);this.menu.push(["Correlate","regressionLine","correlateData"])}if(this.data.z&&!this.scatterPlotMatrix){this.menu.push(["Explore Meta-Data","doe","createDOE"])}if(!this.scatterPlotMatrix){this.menu.push(["Create Histogram","histogram","createHistogram"])}}}}else{if(this.graphType=="Scatter3D"){this.menu.push(["Loess","nonlinearFit",false,false,false,"getLoessMenu",[]])}}if(this.data.z){this.menu.push(["Data Point Attributes","colorShapeSize",false,false,false,"getDataPointAttributesMenu",[]])}}}}}return this.menu};this.resetMenus=function(){this.removeMenus()}};CanvasXpress.prototype.initLinks=function(){this.addLinkDiv=function(){if(this.$(this.target+"-cX-Link")){this.resetLinkDiv();return}var b=this.$cX("div",{id:this.target+"-cX-Link",className:"CanvasXpressLink"},{zIndex:10002,display:"none"});var a=this.$cX("ul",{id:this.target+"-cX-Link-Content",className:"CanvasXpressList"});var c=this.$("north-wrapper-"+this.target);if(c){b.appendChild(a);c.appendChild(b)}};this.showLinkDiv=function(J,b,D){var K=this.$(this.target+"-cX-Link-Content");var k=this.$("west-container-"+this.target);var M=false;if(K){this.resetLinkDiv();var L=this.adjustedCoordinates(J);if(L){var h=L.x+k.offsetWidth;var f=L.y;for(var H=0;H<b.length;H++){var o=b[H].url;var C=b[H].name;var r=b[H].title;var E=b[H].icon;var v=b[H].source;var B=b[H].params;if(o){M=true}else{if(v&&this.data.links&&this.data.links[v]){o=this.data.links[v].url;M=true;if(B){for(var G in B){o=o.replace("$"+G+"$",B[G])}}}}var F=this.$cX("li",{className:"CanvasXpressListItem"});var c=r?r:this.data.links&&v&&this.data.links[v]&&this.data.links[v].title?this.data.links[v].title:"";var N=this.$cX("a",{className:"CanvasXpressListItemA",href:o,alt:c,title:c,target:"_blank"});var I=this.$cX("img",{className:"CanvasXpressListIcon",src:E?E:this.data.links&&v&&this.data.links[v]&&this.data.links[v].icon?this.data.links[v].icon:CanvasXpress.images.canvasXpress});var A=this.$cX("span",{className:"CanvasXpressListItemText",innerHTML:C?C:this.data.links&&v&&this.data.links[v]&&this.data.links[v].name?this.data.links[v].name:H});N.appendChild(I);N.appendChild(A);F.appendChild(N);this.addRemoveLinkListeners("addEvtListener",F);K.appendChild(F)}K.parentNode.style.left=h+"px";K.parentNode.style.top=f+"px";K.parentNode.style.display=M?"block":"none"}}};this.addRemoveLinkListeners=function(b,a){if(a){this.addRemoveEvtListener(b,a,"click",this.clickLink,false);this.addRemoveEvtListener(b,a,"mouseover",this.mouseoverLink,false);this.addRemoveEvtListener(b,a,"mouseout",this.mouseoutLink,false)}};this.clickLink=function(a){return function(b){if(!b){b=window.event}a.resetLinkDiv();return false}}(this);this.mouseoverLink=function(a){return function(c){if(!c){c=window.event}var b=a.getMenuItemComp(c);if(b){b[0].className="CanvasXpressListItemActive";b[1].className="CanvasXpressListItemAActive"}return false}}(this);this.mouseoutLink=function(a){return function(c){if(!c){c=window.event}var b=a.getMenuItemComp(c);if(b){b[0].className="CanvasXpressListItem";b[1].className="CanvasXpressListItemA"}return false}}(this);this.resetLinkDiv=function(){var a=this.$(this.target+"-cX-Link-Content");if(a&&a.childNodes){while(a.childNodes.length>0){this.addRemoveLinkListeners("removeEvtListener",a.childNodes[0]);a.removeChild(a.childNodes[0])}a.parentNode.style.display="none"}};this.resetLinks=function(){this.resetLinkDiv()};this.initializeLinks=function(){if(!this.disableEvents){this.addLinkDiv()}};this.initializeLinks()};CanvasXpress.prototype.initTooltip=function(){this.addTooltipDiv=function(u,r,q,a,b){this.resetInfoSpan();var f=0;var j=this.target+"-cX-TooltipDiv"+f;var w=this.$(this.target+"-cX-Info");if(w&&w.style.display!="none"){r=parseInt(w.style.left);q=parseInt(w.style.top)}var k=this.$(j);while(k){f++;j=this.target+"-cX-TooltipDiv"+f;k=this.$(j)}var l=this.$cX("div",{id:j,className:"CanvasXpressTooltip draggable"},{left:r+"px",top:q+"px"});var p=this.$cX("img",{id:j+"Close",className:"CanvasXpressTooltip",src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"});var g=this.$cX("img",{id:j+"Marker",className:"CanvasXpressTooltip",src:CanvasXpress.images.pencil,obj:b,alt:"Add Marker",title:"Add Marker"});if(!a){a={}}a.clear="both";var v=this.$cX("div",{id:j+"HTML",innerHTML:u||""},a);l.appendChild(p);if(b){l.appendChild(g)}l.appendChild(v);var h=this.$("center-wrapper-"+this.target);h.appendChild(l);return l};this.addRemoveTooltipDivsListeners=function(a,b){this.addRemoveEvtListener(a,b,"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,b,"touchstart",this.registerMousemove,false);this.addRemoveEvtListener(a,b.childNodes[0],"click",this.closeTooltipDiv,false);if(b.childNodes[1]&&b.childNodes[0].tagName.toUpperCase()=="IMG"){this.addRemoveEvtListener(a,b.childNodes[1],"click",this.addMarkerTooltipDiv,false)}};this.closeTooltipDiv=function(a){return function(c){if(!c){c=window.event}var b=c.target||c.srcElement;if(b){var f=b.parentNode;a.addRemoveTooltipDivsListeners("removeEvtListener",f);f.parentNode.removeChild(f)}return false}}(this);this.addMarkerTooltipDiv=function(a){return function(c){var b=c.target||c.srcElement;if(b){var g=b.parentNode;var f=b.obj;if(f){a.addMarkerConfigurator(c,f)}}return false}}(this);this.showTooltipDiv=function(f,j,b,a,i,h,c){var g;if(i&&h){g=this.addTooltipDiv(j,i,h,a,c);this.addRemoveTooltipDivsListeners("addEvtListener",g)}else{var l=this.$(this.target+"-cX-Info");var k=b?this.regularCoordinates(f,b):this.adjustedCoordinates(f,l);if(k){i=k.x;h=f?k.y:k.y+25;g=this.addTooltipDiv(j,i,h,a,c);this.addRemoveTooltipDivsListeners("addEvtListener",g)}}};this.resetTooltipDivs=function(){var c=0;var a=this.target+"-cX-TooltipDiv"+c;var b=this.$(a);while(b){this.addRemoveTooltipDivsListeners("removeEvtListener",b);b.parentNode.removeChild(b);c++;a=this.target+"-cX-TooltipDiv"+c;b=this.$(a)}};this.addInfoSpan=function(){if(this.$(this.target+"-cX-Info")){this.resetInfoSpan();return}var b=this.$("center-wrapper-"+this.target);var a=this.$cX("span",{id:this.target+"-cX-Info",className:"CanvasXpressTooltip"},{display:"none"});b.appendChild(a)};this.resetInfoSpan=function(d,c){var b=this.$(this.target+"-cX-Info");if(b&&!this.noInfoSpanReset){var a=new Date().getTime()-this.infoStartTime;if(a>this.infoTimeIn||c){b.style.left="0px";b.style.top="0px";b.style.display="none";b.innerHTML=""}}};this.flashInfoSpan=function(l,k,o,d,a){var g=this;if(d){this.noInfoSpanReset=true}var q=new Date().getTime()-this.infoStartTime;var r=this.$(this.target+"-cX-Info");var j=this.$(this.target);var b=j.getClientRects();if(r){r.innerHTML=o;r.style.display="block";var n=parseInt(r.clientWidth);var f=parseInt(r.clientHeight);r.style.left=(l||0)+"px";r.style.top=(k||0)+"px";if(a){for(var e in a){r.style[e]=a[e]}}if(d){this.noInfoSpanReset=true;var m=function(){this.update=function(){var c=new Date().getTime();if(c-g.infoStartTime>d){g.noInfoSpanReset=false;g.resetInfoSpan();clearInterval(h)}};var h=g.setInterval(this.update,d)};m.call()}}};this.showInfoSpan=function(g,m,a){if(this.draggingOn||this.remoteUpdating||this.noInfoSpanReset){return}var o=new Date().getTime()-this.infoStartTime;var p=this.$(this.target+"-cX-Info");if(p&&m&&m!=""&&o>this.infoTimeIn){var n=a?this.regularCoordinates(g,a):this.adjustedCoordinates(g,p);if(n){var j=n.x;var i=g?n.y:n.y+25;if(CanvasXpress.system.isIE){j+=document.body.scrollLeft;i+=document.body.scrollTop}var f;var c;if(g&&g.type=="touchmove"){f=25;c=40}else{f=10;c=20}if(!isNaN(m)){m=m.toString()}if(m.match(/\w/)){p.innerHTML=m;p.style.left=(j+f)+"px";p.style.top=(i-c)+"px";p.style.display="inline";if(this.isMap){p.style.zIndex=10000}var l=parseInt(p.clientWidth);var b=parseInt(p.clientHeight);if(l<window.innerWidth&&l>(window.innerWidth+window.pageXOffset)-j&&(l+c)<(j-window.pageXOffset)){p.style.left=(j-(l+c))+"px";p.style.left=(j-(parseInt(p.clientWidth)+c))+"px"}if(b<window.innerHeight&&b>(window.innerHeight+window.pageYOffset)-i&&(b-(f*1.5))<(i-window.pageYOffset)){p.style.top=(i-(b-(f*1.5)))+"px";p.style.top=(i-(parseInt(p.clientHeight)-(f*1.5)))+"px"}this.infoStartTime=new Date().getTime();var d=this;var k=function(){this.update=function(){var h=new Date().getTime();if(h-d.infoStartTime>d.infoTimeOut){d.resetInfoSpan();clearInterval(e)}};var e=d.setInterval(this.update,100)};k.call()}}}};this.addMarkerConfigurator=function(Q,H){var y=this.$("center-wrapper-"+this.target);if(y){var F=this.target+"-cX-Marker";if(this.$(F)){this.closeMarkerConfigurator(false,this.$(F))}var O=Q.target||Q.srcElement;var D=O.parentNode;var R=this.adjustedCoordinates(Q);var z=H.y?H.y.vars:H.w.vars;var C=H.y?H.y.smps:H.w.smps;var k=this.graphType.match(/Treemap|Stacked/)?true:false;var I={};var E=false;var A={id:this.newId(this.target+"-marker-"),vi:this.getVariableIndices(z),si:this.getSampleIndices(C,k),variable:z,sample:C,update:false};var L=false;var G=["text","color","fontSize","fontStyle","align","baseline","type","x","y"];for(var N=0;N<G.length;N++){I[G[N]]=""}I.align="center";I.baseline="middle";I.type="line";if(this.decorations&&this.decorations.marker){for(var N=0;N<this.decorations.marker.length;N++){var J=this.decorations.marker[N];if(this.isSameObject(J.variable,z)&&this.isSameObject(J.sample,C)){for(var M=0;M<G.length;M++){I[G[M]]=J[G[M]]}L=true;A.update=true}}}var B=this.$cX("div",{id:F,className:"CanvasXpressMarker draggable",par:D.id,obj:A},{left:R.x+"px",top:(R.y-this.height)+"px",display:"block",position:"relative"});var c=this.$cX("img",{id:F+"ConfiguratorMarkerClose",className:"CanvasXpressDataTableToolbarImage",src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"});var f=this.$cX("div",{id:F+"Container",className:"CanvasXpressDataTableContainer"},{left:"12px"});var d=this.$cX("table",{id:F+"MarkerTable",className:"CanvasXpressDataTable"});var a=this.$cX("tbody");for(var N=0;N<G.length;N++){var b=this.$cX("tr");var q=this.$cX("th",{className:"CanvasXpressTableCellHead"},{height:G[N]=="text"?"64px":"18px",width:"80px",backgroundRepeat:"repeat"});var l=this.$cX("div",{className:"CanvasXpressTableCell",innerHTML:this.capitalize(G[N])},{height:G[N]=="text"?"64px":"18px",width:"80px"});var u=this.$cX("td",{className:"CanvasXpressTableCell"},{height:G[N]=="text"?"64px":"18px",width:"160px",border:"1px solid #ccc"});var t=this.$cX("div",{className:"CanvasXpressTableCell"},{height:G[N]=="text"?"64px":"18px",width:"160px"});var h;if(G[N]=="text"){h=this.$cX("textarea",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",name:G[N],value:I[G[N]],rows:3},{width:"100%",border:"none"})}else{if(G[N]=="color"){h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"color",name:G[N],value:I[G[N]]?this.validateColor(I[G[N]],null,true):""},{width:"100%",border:"none"})}else{if(G[N]=="type"){h=this.$cX("select",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",size:1},{width:"100%",border:"none",backgroundColor:"white"});var x=this.$cX("option",{text:"line",value:"line"});try{h.add(x,null)}catch(P){h.add(x)}var g=this.$cX("option",{text:"annotation",value:"annotation"});try{h.add(g,null)}catch(P){h.add(g)}if(I[G[N]]&&I[G[N]]!="line"){h.options[1].selected=true;E=true}}else{if(G[N]=="x"||G[N]=="y"){h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"number",name:G[N],value:I[G[N]]?sprintf("%.2f",Number(I[G[N]])):0,min:0,max:1,step:0.01},{width:"100%",border:"none"});if(E){h.disabled=true}}else{if(G[N].match(/fontSize/)){h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"number",name:G[N],value:I[G[N]]||12},{width:"100%",border:"none"})}else{h=this.$cX("input",{id:F+"ConfiguratorMarker-"+G[N],className:"CanvasXpressMarker",type:"text",name:G[N],value:I[G[N]]||""},{width:"100%",border:"none"})}}}}}var r=this.$cX("input",{id:F+"ConfiguratorMarkerRemove",value:"Remove",type:"button"},{cssFloat:"left",borderRadius:"5px",position:"relative",top:"308px",left:"12px",width:"125px",height:"24px"});var K=this.$cX("input",{id:F+"ConfiguratorMarkerAdd",value:L?"Update":"Add",type:"button"},{cssFloat:"left",borderRadius:"5px",position:"relative",top:"308px",left:"24px",width:"125px",height:"24px"});t.appendChild(h);u.appendChild(t);q.appendChild(l);b.appendChild(q);b.appendChild(u);a.appendChild(b)}d.appendChild(a);f.appendChild(d);B.appendChild(c);B.appendChild(f);B.appendChild(r);B.appendChild(K);y.appendChild(B);this.addRemoveMarkerConfiguratorListeners("addEvtListener")}};this.addRemoveMarkerConfiguratorListeners=function(e){var b=this.$(this.target+"-cX-Marker");var h=this.$(this.target+"-cX-MarkerConfiguratorMarkerClose");var g=this.$(this.target+"-cX-MarkerConfiguratorMarkerRemove");var d=this.$(this.target+"-cX-MarkerConfiguratorMarkerAdd");var f=this.$(this.target+"-cX-MarkerConfiguratorMarker-type");if(b&&h&&g&&d&&f){this[e](b,"mousedown",this.registerMousemove,false);this[e](h,"click",this.closeMarkerConfigurator,false);this[e](g,"click",this.removeMarker,false);this[e](d,"click",this.addMarker,false);this[e](f,"change",this.changeTypeMarker,false)}};this.closeMarkerConfigurator=function(a){return function(f,b){var c=f?(f.target||f.srcElement):false;var d=c?a.$(c.parentNode.par):b?a.$(b.par):false;if(d){a.addRemoveTooltipDivsListeners("removeEvtListener",d);d.parentNode.removeChild(d)}if(!b){b=c.parentNode}a.addRemoveMarkerConfiguratorListeners("removeEvtListener",b);b.parentNode.removeChild(b);return false}}(this);this.removeMarker=function(a){return function(c){var b=c.target||c.srcElement;a.modifyMarker(b.parentNode.obj,true);a.closeMarkerConfigurator(c);return false}}(this);this.addMarker=function(a){return function(c){var b=c.target||c.srcElement;a.modifyMarker(b.parentNode.obj);a.closeMarkerConfigurator(c);return false}}(this);this.changeTypeMarker=function(a){return function(d){var c=d.target||d.srcElement;var f=this.value;var b=c.parentNode.parentNode.parentNode.nextElementSibling;var g=b.nextElementSibling;b.childNodes[1].childNodes[0].childNodes[0].disabled=f=="line"?false:true;g.childNodes[1].childNodes[0].childNodes[0].disabled=f=="line"?false:true;return false}}(this);this.modifyMarker=function(e,a){var d=["text","color","fontSize","fontStyle","align","baseline","type","x","y"];for(var b=0;b<d.length;b++){var c=this.$(this.target+"-cX-MarkerConfiguratorMarker-"+d[b]);if(c){e[d[b]]=c.value}}this.updateMarker(e,a)};this.updateMarker=function(e,b){this.functionCaller="updateMarker";if(this.isTransition()){return}if(b){if(e.update){var d=[];for(var c=0;c<this.decorations.marker.length;c++){var a=this.decorations.marker[c];if(this.isSameObject(a.variable,e.variable)&&this.isSameObject(a.sample,e.sample)){continue}d.push(a)}this.decorations.marker=d}else{return false}}else{if(e.update){for(var c=0;c<this.decorations.marker.length;c++){var a=this.decorations.marker[c];if(this.isSameObject(a.variable,e.variable)&&this.isSameObject(a.sample,e.sample)){a.text=e.text;a.color=e.color;a.fontSize=Number(e.fontSize);if(e.fontStyle!=""){a.fontStyle=e.fontStyle}a.align=e.align;a.baseline=e.baseline;a.x=Number(e.x);a.y=Number(e.y);a.type=e.type;break}}}else{if(!this.decorations){this.decorations={}}if(!this.decorations.marker){this.decorations.marker=[]}this.decorations.marker.push({vi:e.vi,si:e.si,variable:e.variable,sample:e.sample,text:e.text,color:e.color,fontSize:Number(e.fontSize),fontStyle:e.fontStyle,align:e.align,baseline:e.baseline,x:Number(e.x),y:Number(e.y),type:e.type})}}this.draw()};this.initializeTooltip=function(){if(!this.disableEvents){this.addInfoSpan()}};this.initializeTooltip()};CanvasXpress.prototype.initToolbar=function(){this.addToolbarDiv=function(){if(this.$(this.target+"-cX-Toolbar")){return}var a=this.beaconImage;var o=this.meta.canvas.ctx.canvas.height<350&&!CanvasXpress.system.isTouchScreen;var k=this.meta.canvas.ctx.canvas.height>=500?"16px":"16px";var g=this.$cX("div",{id:this.target+"-cX-Toolbar"},{position:"absolute",overflow:"hidden",width:this.width+"px",height:"0px",left:"7px",top:"4px",zIndex:1});var r=this.$cX("div",{id:this.target+"-cX-Toolbar-Custom"},{cssFloat:"left"});var b=this.$cX("img",{id:this.target+"-cX-ToolbarSave",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.camera,alt:"Save as png",title:"Save as png"},{width:k,height:k});var i=this.$cX("img",{id:this.target+"-cX-ToolbarMove",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.move,alt:"Move Canvas (Grab here)",title:"Move Canvas (Grab here)",draggable:false},{width:k,height:k,display:this.movable?"none":"block",cursor:"move"});var j=this.$cX("img",{id:this.target+"-cX-ToolbarLayout",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.funnel,alt:"Explore data",title:"Explore data"},{width:k,height:k,display:this.disableDataFilters||this.disableDataTable||this.disableConfigurator||o?"none":"block"});var h=this.$cX("img",{id:this.target+"-cX-ToolbarDataExplorer",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.configure,alt:"Configure",title:"Configure"},{width:k,height:k,display:this.isMap?"none":"block"});var l=this.$cX("img",{id:this.target+"-cX-ToolbarInformation",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.information1,alt:"Data Details",title:"Data Details"},{width:k,height:k,display:this.info?"block":"none"});var f=this.$cX("img",{id:this.target+"-cX-ToolbarMaxMin",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.inout,alt:"Minimize / Maximize",title:"Minimize / Maximize"},{marginRight:"13px",width:k,height:k});g.appendChild(r);g.appendChild(a);g.appendChild(f);g.appendChild(l);g.appendChild(h);g.appendChild(j);g.appendChild(i);g.appendChild(b);var n=this.$("north-wrapper-"+this.target);if(n){n.appendChild(g);this.addRemoveToolbarListeners("addEvtListener")}};this.addRemoveToolbarListeners=function(c){this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarSave"),"click",this.print,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarMove"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarLayout"),"click",this.clickLayout,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarDataExplorer"),"click",this.clickDataExplorer,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarInformation"),"click",this.clickDataDetails,false);this.addRemoveEvtListener(c,this.$(this.target+"-cX-ToolbarMaxMin"),"click",this.clickGraphMaxMin,false);var a=this.$(this.target+"-cX-Toolbar-Custom");if(c=="removeEvtListener"&&a){for(var b=0;b<a.childNodes.length;b++){this.addRemoveEvtListener(c,a.childNodes[b],"click",this.addCustomToolbarMenu,false);this.addRemoveEvtListener(c,a.childNodes[b],"contextmenu",this.unpinFromToolbar,false)}}};this.backgroundMask=function(a){var b=this.$("container-"+this.target);if(b){if(a){b.style.position="fixed";b.style.left=0;b.style.top=0;b.style.padding="2px";b.style.width=a[0]+"px";b.style.height=a[1]+"px";b.style.zIndex=1000000;b.style.backgroundColor="white"}else{b.style.position="relative";b.style.left="";b.style.top="";b.style.padding="";b.style.width="";b.style.height="";b.style.zIndex="";b.style.backgroundColor=""}}};this.clickLayoutNoAnimation=function(c){if(this.appLayout&&!c){var b=this.showFadeResizeMoveAnimation;this.showFadeResizeMoveAnimation=false;this.hideTable();this.hideDataFilter();var a=this.$(this.target+"-cX-ToolbarLayout");a.src=CanvasXpress.images.funnel;a.alt="Explore data";a.title="Explore data";this.appLayout=false;this.activeAccordion=false;this.showFadeResizeMoveAnimation=b;return false}};this.clickLayoutShowDataFilter=function(){this.showDataFilter();if(!this.dataFilterLastState||(this.dataFilterLastState&&this.dataFilterLastState!="docked")){this.moveDataFilter(false,"dock");if(!this.activeAccordion){var a=this;setTimeout(function(){if(a.graphType=="Genome"){a.activateAccordion(false,a.$(a.target+"-cX-DataFilterGenomeHeader"))}else{if(a.graphType=="Network"){a.activateAccordion(false,a.$(a.target+"-cX-DataFilterNodeHeader"))}else{a.activateAccordion(false,a.$(a.target+"-cX-DataFilterVariableHeader"))}}},this.showFadeResizeMoveAnimation?500:0)}}};this.clickDataFilters=function(a){return function(d){if(!d){d=window.event}a.removeMenus();if(a.maximized){if(a.appLayout){a.clickLayout(d,a.$(a.target+"-cX-ToolbarLayout"));setTimeout(function(){a.clickDataFilters(d)},2000)}else{if(a.appLayoutDataTable){a.clickDataTable(d);setTimeout(function(){a.clickLayout(d,a.$(a.target+"-cX-ToolbarLayout"))},1500)}else{var b=a.dataFilterWidth+10;var c=a.heigthOffsetDataFilter();a.appLayoutDataFilter=a.appLayoutDataFilter?false:true;if(a.appLayoutDataFilter){a.setDimensions(a.width-b,a.height,true);a.resizeWidthOnLayoutActive=b;a.dataFilterHeight=a.meta.canvas.ctx.canvas.height-c;a.clickLayoutShowDataFilter()}else{if(a.activeAccordion){a.activateAccordion(false,a.activeAccordion.previousSibling)}a.hideDataFilter();setTimeout(function(){a.resizeViewportMiddle(a.width+b,a.height);a.setDimensions(a.width+b,a.height,true,250);a.resizeWidthOnLayoutActive=false},250)}}}}else{a.showDataFilter()}return false}}(this);this.clickLayoutShowDataTable=function(){this.updateDataTable();if(!this.dataTableLastState||(this.dataTableLastState&&this.dataTableLastState!="docked")){this.moveDataTableDiv("dock")}var c=this;var a=this.getDataFilterState();var e=this.$("middle-container-"+this.target);var d=parseInt(e.style.width)+(a=="docked"?(this.dataFilterWidth+6):0)-(this.appLayoutDataTable?17:-1);var b=this.dataTableLastHeight||parseInt(this.dataTableTarget.style.height);setTimeout(function(){c.dataTableTarget=c.$(c.target+"-cX-DataTable");c.updateDataTableResizerDiv(false,d,b);c.endDataTableResizerDiv();c.hideToolbar()},this.showFadeResizeMoveAnimation?500:0)};this.clickDataTable=function(a){return function(c){if(!c){c=window.event}a.removeMenus();if(a.maximized){if(a.appLayout){a.clickLayout(c,a.$(a.target+"-cX-ToolbarLayout"));setTimeout(function(){a.clickDataTable(c)},2000)}else{if(a.appLayoutDataFilter){a.clickDataFilters(c);setTimeout(function(){a.clickLayout(c,a.$(a.target+"-cX-ToolbarLayout"))},1500)}else{a.setDataTableDimensions();var b=a.dataTableLastHeight?a.dataTableRowsHeight-51:a.dataTableRowsHeight+53;a.appLayoutDataTable=a.appLayoutDataTable?false:true;if(a.appLayoutDataTable){a.setDimensions(a.width,a.height-b,true);a.resizeHeightOnLayoutActive=true;a.clickLayoutShowDataTable()}else{a.hideTable();setTimeout(function(){a.setDimensions(a.width,a.height+b,true,250);a.resizeHeightOnLayoutActive=false},250)}}}}else{a.updateDataTable()}return false}}(this);this.clickLayout=function(a){return function(i,c,j){if(!i){i=window.event}if(a.appLayoutDataTable){a.clickDataTable(i);setTimeout(function(){a.clickDataFilters(i)},1000)}else{if(a.appLayoutDataFilter){a.clickDataFilters(i);setTimeout(function(){a.clickDataTable(i)},1000)}else{var g=a.showTransition?1000:0;var f=a.showFadeResizeMoveAnimation?500+g:g;if(!c){if(i){c=i.target||i.srcElement}else{c=a.$(a.target+"-cX-ToolbarLayout")}}a.appLayout=a.appLayout?false:true;c.src=CanvasXpress.images.funnel;c.alt="Explore data";c.title="Explore data";if(a.resizeHeightOnLayout){a.setDataTableDimensions()}var b=a.dataFilterWidth+10;var d=a.dataTableLastHeight?a.dataTableRowsHeight-51:a.dataTableRowsHeight+53;if(a.appLayout){if(a.resizeWidthOnLayout&&a.width-b>=b*1.3){if(a.resizeHeightOnLayout&&a.height-d>=d*1){a.setDimensions(a.width-b,a.height-d,true);a.resizeWidthOnLayoutActive=b;a.resizeHeightOnLayoutActive=d}else{a.setDimensions(a.width-b,a.height,true);a.resizeWidthOnLayoutActive=b}a.resizeViewport()}else{if(a.resizeHeightOnLayout&&a.height-d>=d*1){a.setDimensions(a.width,a.height-d,true);a.resizeHeightOnLayoutActive=d;a.resizeViewport()}}a.dataFilterHeight=a.meta.canvas.ctx.canvas.height-a.heigthOffsetDataFilter();setTimeout(function(){a.clickLayoutShowDataFilter();a.setTimeout(function(){a.clickLayoutShowDataTable()},f)},1)}else{setTimeout(function(){if(a.activeAccordion){a.activateAccordion(false,a.activeAccordion.previousSibling)}a.hideDataFilter();setTimeout(function(){a.hideTable();a.hideToolbar();setTimeout(function(){if(a.resizeWidthOnLayoutActive){if(a.resizeHeightOnLayoutActive){a.setDimensions(a.width+a.resizeWidthOnLayoutActive,a.height+a.resizeHeightOnLayoutActive,true)}else{a.setDimensions(a.width+a.resizeWidthOnLayoutActive,a.height,true)}}else{if(a.resizeHeightOnLayoutActive){a.setDimensions(a.width,a.height+a.resizeHeightOnLayoutActive,true)}}a.resizeWidthOnLayoutActive=false;a.resizeHeightOnLayoutActive=false;setTimeout(function(){a.updateRemoteNavigationWindow()},f*0.2)},f)},f)},f)}}}return false}}(this);this.clickDataExplorer=function(a){return function(b){if(!b){b=window.event}a.removeMenus();a.addDataExplorer(b);return false}}(this);this.clickDataDetails=function(a){return function(d){if(!d){d=window.event}var b=document.body.scrollLeft;var f=document.body.scrollTop;var c={maxWidth:"500px",maxHeight:"500px",whiteSpace:"normal",overflow:"auto",textAlign:"left"};a.showTooltipDiv(d,a.info,false,c,d.clientX+b-a.width,d.clientY+f);return false}}(this);this.clickRepResearch=function(a){return function(g){if(!g){g=window.event}var b=document.body.scrollLeft;var h=document.body.scrollTop;var c=a.prettyJSON(CanvasXpress.stack[a.target]);var f='<pre class="CanvasXpressCode">\n'+c+"</pre>\n";var d={maxWidth:"500px",maxHeight:"500px",whiteSpace:"normal",overflow:"auto",textAlign:"left"};a.showTooltipDiv(g,f,false,d,g.clientX+b-(a.width/2),g.clientY+h);return false}}(this);this.clickShowCode=function(a){return function(b){if(!b){b=window.event}a.showCodeDiv();return false}}(this);this.clickGraphMaxMin=function(a){return function(c){if(!c){c=window.event}var b=1;if(a.appLayout){a.clickLayout(c,a.$(a.target+"-cX-ToolbarLayout"));b=2000}else{if(a.appLayoutDataTable){a.clickDataTable(c);b=1000}else{if(a.appLayoutDataFilter){a.clickDataFilters(c);b=1000}else{b=1}}}setTimeout(function(){var g=a.remoteService?a.$(a.remoteParentId+"-canvasXpressRemoteWindow"):a.$("container-"+a.target);var f=a.$(a.target+"-cX-ToolbarMaxMin");var e=window.innerWidth;var d=window.innerHeight;if(g&&f){if(a.maximized){a.backgroundMask();f.alt="Maximize";f.title="Maximize";f.src=CanvasXpress.images.inout;a.setDimensions(a.maximized[0],a.maximized[1]);g.style.left=a.maximized[2];g.style.top=a.maximized[3];document.documentElement.style.overflowX=a.maximized[4];document.documentElement.style.overflowY=a.maximized[5];a.maximized=false;a.dataFilterHeight=a.meta.canvas.ctx.canvas.height-a.heigthOffsetDataFilter()}else{a.backgroundMask([e,d]);f.alt="Minimize";f.title="Minimize";f.src=CanvasXpress.images.inout;a.maximized=[a.width,a.height,g.style.left,g.style.top,document.body.style.overflowX,document.body.style.overflowY];document.documentElement.style.overflowX="hidden";document.documentElement.style.overflowY="hidden";a.setDimensions(e-4,d-4);a.dataFilterHeight=a.meta.canvas.ctx.canvas.height-a.heigthOffsetDataFilter()}}},b);return false}}(this);this.showToolbar=function(e){if(!this.disableToolbar&&!this.dataTableMaximized){var b=this.$(this.target+"-cX-Toolbar");var d=this.$("west-container-"+this.target);var a=this.$(this.target+"-cX-ToolbarMove");if(b&&parseInt(b.style.height)==0&&d&&a){a.style.display=this.movable&&!this.maximized?"block":"none";this.resizeMove(b,0,4,this.width,24,250);if(e){var c=this;setTimeout(function(){c.hideToolbar(e)},e)}}}};this.hideToolbar=function(d){var a=this.$(this.target+"-cX-Toolbar");var c=this.$("west-container-"+this.target);if(a&&parseInt(a.style.height)==24&&c){this.resizeMove(a,0,4,this.width,0,250)}else{if(d&&a&&parseInt(a.style.height)>0){var b=this;setTimeout(function(){b.hideToolbar(d)},d)}}};this.isToolbar=function(c){if(!c){c=window.event}var b=this.adjustedCoordinates(c);if(b){var a=b.x;var d=b.y;if(d>0&&d<24&&a>0&&a<this.width){this.showToolbar()}else{if(d>24&&d<this.height&&a>0&&a<this.width){this.hideToolbar()}}}};this.addTouchToolbarDiv=function(){if(this.$(this.target+"-cX-TouchToolbar")){return}var n=24;var j=this.meta.canvas.ctx.canvas.height>=500?16:11;var f=this.$cX("div",{id:this.target+"-cX-TouchToolbar"},{position:"absolute",width:(n+j+12)+"px",height:((n*6)+12)+"px",left:0+"px",top:((this.height-(n*6))/2)+"px",display:"flex",zIndex:1});var g=this.$cX("div",{id:this.target+"-cX-TouchToolbarLeft"},{width:0,height:((n*6)+12)+"px",overflow:"hidden"});var b=this.$cX("div",{id:this.target+"-cX-TouchToolbarRight"},{width:(j-1)+"px",height:"128px"});var d=this.$cX("img",{id:this.target+"-cX-TouchToolbarMouse",className:"CanvasXpressToolbarImage",key:"mouse",src:CanvasXpress.images.hoverToolbar,swp:CanvasXpress.images.mouseLeft,title:"Toggle hover / drag"},{width:n+"px",height:n+"px"});var o=this.$cX("img",{id:this.target+"-cX-TouchToolbarAlt",className:"CanvasXpressToolbarImage",key:"alt",src:CanvasXpress.images.alt24,swp:CanvasXpress.images.alt24,title:"Toggle Alt on / off"},{width:n+"px",height:n+"px",opacity:0.3,filter:"alpha(opacity=30)"});var q=this.$cX("img",{id:this.target+"-cX-TouchToolbarShift",className:"CanvasXpressToolbarImage",key:"shift",src:CanvasXpress.images.shift24,swp:CanvasXpress.images.shift24,title:"Toggle Shift on / off"},{width:n+"px",height:n+"px",opacity:0.3,filter:"alpha(opacity=30)"});var l=this.$cX("img",{id:this.target+"-cX-TouchToolbarCtrl",className:"CanvasXpressToolbarImage",key:"ctrl",src:CanvasXpress.images.ctrl24,swp:CanvasXpress.images.ctrl24,title:"Toggle Ctrl on / off"},{width:n+"px",height:n+"px",opacity:0.3,filter:"alpha(opacity=30)"});var p=this.$cX("img",{id:this.target+"-cX-TouchToolbarWheel",className:"CanvasXpressToolbarImage",key:"wheel",src:CanvasXpress.images.mouseNone,swp:CanvasXpress.images.mouseScroll,title:"Toggle Ctrl on / off"},{width:n+"px",height:n+"px"});var k=this.$cX("img",{id:this.target+"-cX-TouchToolbarEsc",className:"CanvasXpressToolbarImage",key:"esc",src:CanvasXpress.images.esc24,swp:CanvasXpress.images.esc24,title:"Click to ESC"},{width:n+"px",height:n+"px"});var i=this.$cX("img",{id:this.target+"-cX-TouchToolbarMobileHandle",className:"CanvasXpressToolbarImage",src:CanvasXpress.images.mobileHandle,title:"Interaction"},{width:(j-4)+"px",height:n+"px",position:"relative",top:((n*2.5)+6)+"px"});g.appendChild(d);g.appendChild(o);g.appendChild(q);g.appendChild(l);g.appendChild(p);g.appendChild(k);b.appendChild(i);f.appendChild(g);f.appendChild(b);var p=this.$("west-wrapper-"+this.target);if(p){p.appendChild(f);this.addRemoveTouchToolbarListeners("addEvtListener")}};this.addRemoveTouchToolbarListeners=function(a){this.addRemoveEvtListener(a,this.$(this.target+"-cX-TouchToolbarMobileHandle"),"click",this.clickMobileHandle,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-TouchToolbarMouse"),"click",this.clickMobileKey,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-TouchToolbarAlt"),"click",this.clickMobileKey,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-TouchToolbarShift"),"click",this.clickMobileKey,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-TouchToolbarCtrl"),"click",this.clickMobileKey,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-TouchToolbarWheel"),"click",this.clickMobileKey,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-TouchToolbarEsc"),"click",this.clickMobileKey,false)};this.teaseMobileControls=function(a){var b=this;if(!a){a=1000}if(!this.disableTouchToolbar&&CanvasXpress.system.isTouchScreen){b.clickMobileHandle();setTimeout(function(){b.clickMobileHandle()},a)}};this.clickMobileHandle=function(a){return function(f){if(!f){f=window.event}var c=a.$(a.target+"-cX-TouchToolbarLeft");var d=a.meta.canvas.ctx.canvas.height>=500?38:28;if(c){var b=parseInt(c.clientWidth);if(b>0){a.resizeMove(c,0,0,0,(d*6)+12,250)}else{a.resizeMove(c,0,0,d,(d*6)+12,250)}}return false}}(this);this.clickMobileKey=function(a){return function(g){if(!g){g=window.event}var b=this.key;if(b=="wheel"){a.resetMobileKeys()}else{if(a.wheelKeyMobile){var h=a.$(a.target+"-cX-TouchToolbarWheel");d=h.src;h.src=h.swp;h.swp=d;a.wheelKeyMobile=false}}a[b+"KeyMobile"]=a[b+"KeyMobile"]?false:true;var d=this.src;this.src=this.swp;this.swp=d;var f=["Alt","Shift","Ctrl"];for(var c=0;c<f.length;c++){var h=a.$(a.target+"-cX-TouchToolbar"+f[c]);if(a[f[c].toLowerCase()+"KeyMobile"]){h.style.opacity=1;h.style.filter="alpha(opacity=100)"}else{h.style.opacity=0.3;h.style.filter="alpha(opacity=30)"}}if(b=="esc"){a.resetMobileKeys();a.masterReset(g)}else{var f=["alt","shift","ctrl"];var h=a.$(a.target+"-cX-TouchToolbarMouse");for(var c=0;c<f.length;c++){if(a[f[c]+"KeyMobile"]){if(!a.mouseKeyMobile){d=h.src;h.src=h.swp;h.swp=d;a.mouseKeyMobile=true}break}}}return false}}(this);this.resetMobileKeys=function(){var d=["Mouse","Alt","Shift","Ctrl","Wheel","Esc"];for(var b=0;b<d.length;b++){var e=this.$(this.target+"-cX-TouchToolbar"+d[b]);var a=d[b].toLowerCase();if(e&&this[a+"KeyMobile"]){var c=e.src;e.src=e.swp;e.swp=c;this[a+"KeyMobile"]=false;if(a.match(/alt|shift|ctrl/)){e.style.opacity=0.3;e.style.filter="alpha(opacity=30)"}}}};this.initializeToolbar=function(){if(!this.disableEvents){if(!this.disableToolbar){this.addToolbarDiv()}if(!this.disableTouchToolbar&&CanvasXpress.system.isTouchScreen){}}};this.initializeToolbar()};CanvasXpress.prototype.initConfigurator=function(){this.addConfigurator=function(a){return function(ad,C,M,L){var w=false;if(!ad){ad=window.event}if(a.isVML||a.disableConfigurator){return}var ag=a.$(a.target+"-cX-Configurator");if(ag){w=true;if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=ag;a.activeTarget.style.zIndex=10001}var E="Search property or function";a.configuringOn=true;if(C){if(a.isArray(C)){C=C[0]}if(a.graphType=="Network"){a.configuringNetwork=C;if(a.data.nodes.length>C){E="Configure "+(a.data.nodes[C].label||a.data.nodes[C].name||a.data.nodes[C].id)}else{var A=a.data.edges[C-a.data.nodes.length];var H=a.data.nodes[a.data.nodeIndices[A.id1]];var G=a.data.nodes[a.data.nodeIndices[A.id2]];E="Configure "+(H.label||H.name||H.id)+" - "+(G.label||H.name||G.id)}}else{if(a.graphType=="Genome"){a.configuringGenome=C;E="Configure track "+C}}}var B=M!=null&&L!=null?{x:M,y:L}:a.adjustedCoordinates(ad);if(B){M=B.x;L=B.y;if(w){ag.style.left=M+"px";ag.style.top=L+"px";return}else{ag=a.$cX("div",{id:a.target+"-cX-Configurator",className:"CanvasXpressConfigurator draggable"},{cursor:"move",left:M+"px",top:L+"px",padding:"10px",position:"absolute",zIndex:10001})}var aa=a.$cX("div",{id:a.target+"-cX-ConfiguratorKeyText"},{display:"block",marginBottom:"5px",width:a.configuratorWidth+"px"});var ab=a.$cX("span",{id:a.target+"-cX-ConfiguratorKeyTextSpan",className:"CanvasXpressConfigurator",innerHTML:E});var I=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeyMenu",className:"CanvasXpressConfigurator",src:CanvasXpress.images.menuDropdown,alt:"Open menus",title:"Open menus"});var ac=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeySearch",className:"CanvasXpressConfigurator",src:CanvasXpress.images.find,alt:"Browse properties by category",title:"Browse properties by category"});var Y=a.$cX("img",{id:a.target+"-cX-ConfiguratorKeyClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"});var Z=a.$cX("input",{id:a.target+"-cX-ConfiguratorKey",className:"CanvasXpressConfigurator",type:"text"},{display:"block",width:a.configuratorWidth+"px"});var X=a.$cX("select",{id:a.target+"-cX-ConfiguratorCategories",className:"CanvasXpressConfigurator",size:5},{display:"none",width:a.configuratorWidth+"px"});var R=a.$cX("div",{id:a.target+"-cX-ConfiguratorSugestionsText",innerHTML:"Select property"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px"});var Q=a.$cX("select",{id:a.target+"-cX-ConfiguratorSugestions",className:"CanvasXpressConfigurator",size:10},{display:"none",width:a.configuratorWidth+"px"});var af=a.$cX("div",{id:a.target+"-cX-ConfiguratorSugestionsDescription"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px",minHeight:"56px",overflow:"auto"});var O=a.$cX("div",{id:a.target+"-cX-ConfiguratorValueText",innerHTML:"Current value"},{display:"none",margin:"5px 0px 5px 0px",width:a.configuratorWidth+"px"});var ai=a.$cX("div",{id:a.target+"-cX-ConfiguratorSeeAlso"},{display:"none",width:a.configuratorWidth+"px",minHeight:"20px",overflow:"auto"});var N=a.$cX("input",{id:a.target+"-cX-ConfiguratorValue",className:"CanvasXpressConfigurator",type:"text"},{display:"none",width:a.configuratorWidth+"px"});var D=a.$cX("input",{id:a.target+"-cX-ConfiguratorApply",value:"Apply",type:"button"},{display:"none",cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:(a.configuratorWidth/2)+"px"});var ah=a.$cX("input",{id:a.target+"-cX-ConfiguratorButton",value:"Draw",type:"button"},{display:"none",cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:(a.configuratorWidth/2)+"px"});var S=a.$cX("img",{id:a.target+"-cX-ConfiguratorOptionsClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"});var K=a.$cX("div",{id:a.target+"-cX-ConfiguratorOptions",className:"CanvasXpressConfigurator draggable"},{cursor:"move",display:"none",padding:"10px",position:"absolute"});var U=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorCurrent",className:"CanvasXpressConfiguratorColor"},{width:"181px",height:"16px",cssFloat:"left",cursor:"default"});var T=a.$cX("img",{id:a.target+"-cX-ConfiguratorColorClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"});var W=a.$cX("div",{id:a.target+"-cX-ConfiguratorColor",className:"CanvasXpressConfigurator draggable"},{width:"204px",cursor:"move",display:"none",padding:"10px",position:"absolute"});var F=a.$cX("div",{id:a.target+"-cX-ConfiguratorFilter",className:"CanvasXpressConfiguratorFilter draggable",innerHTML:'Build filter ("+" to set "-" to remove)'},{cursor:"move",display:"none",padding:"10px",position:"absolute"});var J=a.$cX("img",{id:a.target+"-cX-ConfiguratorFilterClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"});var P=a.$cX("div",{id:a.target+"-cX-ConfiguratorExample",className:"CanvasXpressConfiguratorExample draggable"},{width:(a.configuratorExamplesSize+35)+"px",maxHeight:(a.configuratorExamplesSize)+"px",cursor:"move",display:"none",padding:"10px",position:"absolute",overflow:"hidden",paddingBottom:"35px"});var ae=a.$cX("span",{id:a.target+"-cX-ConfiguratorExampleSpan",className:"CanvasXpressConfiguratorExample",innerHTML:""});var t=a.$cX("img",{id:a.target+"-cX-ConfiguratorExampleClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"});var h=a.$cX("div",{id:a.target+"-cX-ConfiguratorExampleContent",className:"CanvasXpressConfiguratorExampleContent"},{maxWidth:(a.configuratorExamplesSize+35)+"px",maxHeight:(a.configuratorExamplesSize)+"px"});aa.appendChild(ab);aa.appendChild(Y);aa.appendChild(ac);aa.appendChild(I);K.appendChild(document.createTextNode("Select option ..."));K.appendChild(S);K.appendChild(a.$cX("br"));W.appendChild(U);W.appendChild(T);W.appendChild(a.$cX("br"));F.appendChild(J);F.appendChild(a.$cX("br"));P.appendChild(ae);P.appendChild(t);P.appendChild(a.$cX("br"));P.appendChild(h);ag.appendChild(aa);ag.appendChild(Z);ag.appendChild(X);ag.appendChild(R);ag.appendChild(Q);ag.appendChild(af);ag.appendChild(ai);ag.appendChild(O);ag.appendChild(N);ag.appendChild(D);ag.appendChild(ah);ag.appendChild(K);ag.appendChild(W);ag.appendChild(F);ag.appendChild(P);var V=a.$("west-wrapper-"+a.target);if(V){V.appendChild(ag);if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=ag;a.addRemoveConfiguratorListeners("addEvtListener");if(a.configuringNetwork||a.configuringGenome){a.selectConfig(false,true)}setTimeout(function(){Z.focus()},300)}}}}(this);this.addConfiguratorCloseMenus=function(a){return function(d,c,b,f){a.removeMenus();a.addConfigurator(d,c,b,f)}}(this);this.addRemoveConfiguratorListeners=function(B){var v=this.$(this.target+"-cX-Configurator");var j=this.$(this.target+"-cX-ConfiguratorCategories");var C=this.$(this.target+"-cX-ConfiguratorSugestions");var x=this.$(this.target+"-cX-ConfiguratorApply");var w=this.$(this.target+"-cX-ConfiguratorButton");var k=this.$(this.target+"-cX-ConfiguratorKeyClose");var o=this.$(this.target+"-cX-ConfiguratorKeySearch");var h=this.$(this.target+"-cX-ConfiguratorKeyMenu");var u=this.$(this.target+"-cX-ConfiguratorOptions");var a=this.$(this.target+"-cX-ConfiguratorOptionsClose");var g=this.$(this.target+"-cX-ConfiguratorColor");var d=this.$(this.target+"-cX-ConfiguratorColorClose");var y=this.$(this.target+"-cX-ConfiguratorFilter");var e=this.$(this.target+"-cX-ConfiguratorFilterClose");var r=this.$(this.target+"-cX-ConfiguratorExample");var A=this.$(this.target+"-cX-ConfiguratorExampleClose");if(v&&j&&C&&w&&x&&k&&o&&h&&u&&a&&g&&d&&y&&e&&r&&A){this[B](v,"mousedown",this.registerMousemove,false);this[B](j,"change",this.changeCategory,false);this[B](j,"click",this.changeCategory,false);this[B](C,"change",this.clickSuggestions,false);this[B](C,"click",this.clickSuggestions,false);this[B](x,"click",this.clickApplyConfigurator,false);this[B](w,"click",this.clickConfigurator,false);this[B](h,"click",this.clickMenuDropDown,false);this[B](o,"click",this.clickSearch,false);this[B](k,"click",this.closeConfigurator,false);this[B](u,"mousedown",this.registerMousemove,false);this[B](a,"click",this.closePropertyOptions,false);this[B](g,"mousedown",this.registerMousemove,false);this[B](d,"click",this.closePropertyColor,false);this[B](y,"mousedown",this.registerMousemove,false);this[B](e,"click",this.closePropertyFilter,false);this[B](r,"mousedown",this.registerMousemove,false);this[B](A,"click",this.closePropertyExample,false)}};this.getConfigurableProperties=function(){if(this.configuringNetwork){if(this.data.nodes.length>this.configuringNetwork){return this.getNodeConfigurableProperties(this.configuringNetwork)}else{return this.getEdgeConfigurableProperties(this.configuringNetwork-this.data.nodes.length)}}else{if(this.configuringGenome){if(!isNaN(this.configuringGenome)||this.configuringGenome.match(/:/)){return this.featureConfigurableProperties}else{if(this.configuringGenome.match(/track/)){return this.trackConfigurableProperties}else{this.configuringGenome=false}}}}var c=[];for(var b in CanvasXpress.doc.P){if(!CanvasXpress.doc.P[b].Z){var a=this.getGraphTypes(CanvasXpress.doc.P[b],true);if(a.hasOwnProperty(this.graphType)){c.push(b)}}}return c};this.getConfigurableObjectDoc=function(a){if(this.configuringNetwork){if(this.data.nodes.length>this.configuringNetwork){return CanvasXpress.doc.N[a]?CanvasXpress.doc.N[a]:false}else{return CanvasXpress.doc.E[a]?CanvasXpress.doc.E[a]:false}}else{if(this.configuringGenome){if(!isNaN(this.configuringGenome)||this.configuringGenome.match(/:/)){return CanvasXpress.doc.F[a]?CanvasXpress.doc.F[a]:false}else{if(this.configuringGenome.match(/track/)){return CanvasXpress.doc.G[a]?CanvasXpress.doc.G[a]:false}else{this.configuringGenome=false;return CanvasXpress.doc.P[a]?CanvasXpress.doc.P[a]:false}}}else{return CanvasXpress.doc.P[a]?CanvasXpress.doc.P[a]:false}}};this.selectConfig=function(D,F){var z=this.$(this.target+"-cX-ConfiguratorKey");var q=this.$(this.target+"-cX-ConfiguratorSugestionsText");var n=this.$(this.target+"-cX-ConfiguratorSugestions");var E=this.$(this.target+"-cX-ConfiguratorSugestionsDescription");var l=this.$(this.target+"-cX-ConfiguratorValueText");var H=this.$(this.target+"-cX-ConfiguratorSeeAlso");var j=this.$(this.target+"-cX-ConfiguratorValue");var f=this.$(this.target+"-cX-ConfiguratorApply");var G=this.$(this.target+"-cX-ConfiguratorButton");var B=this.$(this.target+"-cX-ConfiguratorValueHREF");var m=document.activeElement;var y=this.getConfigurableProperties();var w=[];if(this.getKeyCode(D)==13){this.resetOptionColorFiltersExamples();if(this.editingDescriptionOn){this.submitEditPropertyDescription()}else{if(n&&j&&j.value){var g=false;for(var A=0;A<y.length;A++){if(n.value==y[A]){g=true;break}}if(g){this.clickConfigurator(D,n,j)}else{this.resetConfigurator()}}}}else{if(m.id.match(/canvasXpressConfiguratorFilterValue/)){return}else{if(z&&m.id==z.id||F){this.resetOptionColorFiltersExamples();this.resetEditPropertyDescription();for(var A=0;A<y.length;A++){if(y[A].toLowerCase().indexOf(z.value.toLowerCase())>=0){w.push(y[A])}}if(w.length>0&&q&&n&&E&&l&&H&&j&&G&&f){this.resetSugestions();if(!this.configuringNetwork&&!this.configuringGenome){w.sort(function(d,c){return CanvasXpress.doc.P[d].M>CanvasXpress.doc.P[c].M?1:CanvasXpress.doc.P[c].M>CanvasXpress.doc.P[d].M?-1:d>c?1:c>d?-1:0});for(var A=0;A<w.length;A++){var y=this.$cX("option",{text:CanvasXpress.doc.P[w[A]].M?CanvasXpress.doc.P[w[A]].M+" : "+w[A]:"NA : "+w[A],value:w[A]});try{n.add(y,null)}catch(C){n.add(y)}}}else{w.sort();for(var A=0;A<w.length;A++){var y=this.$cX("option",{text:w[A],value:w[A]});try{n.add(y,null)}catch(C){n.add(y)}}}n.options[0].selected=true;this.setConfiguratorPropertyValue(n,E,l,H,j);q.innerHTML="Select property ("+w.length+")";q.style.display="block";n.style.display="block";E.style.display="block";l.style.display="block";H.style.display="block";j.style.display="block";G.style.display="block";f.style.display="block"}else{z.value=z.value.slice(0,z.value.length-1)}}else{if(j&&m.id==j.id){this.resetOptionColorFiltersExamples();this.resetEditPropertyDescription();if(B&&B.innerHTML=="color"){B.style.color=j.value?this.rgbToHex(this.validateColor(j.value.replace(/[\'\"]/g,""))):this.foreground}}else{if(this.remoteService){this.resetOptionColorFiltersExamples();this.selectDataSet(D)}}}}}return false};this.clickSearch=function(a){return function(H){if(!H){H=window.event}a.configuringNetwork=false;a.configuringGenome=false;a.resetEditOptionColorFiltersExamples();var F=a.$(a.target+"-cX-ConfiguratorKeyTextSpan");var D=a.$(a.target+"-cX-ConfiguratorKey");var B=a.$(a.target+"-cX-ConfiguratorCategories");var x=a.$(a.target+"-cX-ConfiguratorSugestionsText");var w=a.$(a.target+"-cX-ConfiguratorSugestions");var I=a.$(a.target+"-cX-ConfiguratorSugestionsDescription");var t=a.$(a.target+"-cX-ConfiguratorValueText");var K=a.$(a.target+"-cX-ConfiguratorSeeAlso");var q=a.$(a.target+"-cX-ConfiguratorValue");var J=a.$(a.target+"-cX-ConfiguratorButton");var c=a.$(a.target+"-cX-ConfiguratorApply");var h=a.$(a.target+"-cX-ConfiguratorOptions");var A=a.$(a.target+"-cX-ConfiguratorColor");var j=a.$(a.target+"-cX-ConfiguratorFilter");var C=a.getKeys(CanvasXpress.doc.M).sort();var p=[];if(D&&D.style.display=="none"){if(F){F.innerText="Search property or function"}if(B){B.style.display="none"}D.value="";D.style.display="block"}else{if(F){for(var E=0;E<C.length;E++){if(CanvasXpress.doc.M[C[E]].U){var f=a.getGraphTypes({M:C[E]},true);if(f.hasOwnProperty(a.graphType)){p.push(C[E])}}else{p.push(C[E])}F.innerText="Select category ("+p.length+")"}}if(D){D.style.display="none"}if(B){a.resetCategories();for(var E=0;E<p.length;E++){var y=a.$cX("option",{text:p[E],value:p[E]});try{B.add(y,null)}catch(G){B.add(y)}}B.style.display="block"}}if(x&&w&&I&&t&&K&&q&&J&&c&&h&&A&&j){x.style.display="none";w.style.display="none";I.style.display="none";t.style.display="none";K.style.display="none";q.style.display="none";J.style.display="none";c.style.display="none";h.style.display="none";A.style.dysplay="none";j.style.dysplay="none"}return false}}(this);this.clickMenuDropDown=function(a){return function(b){if(!b){b=window.event}a.closeConfigurator(b);a.addMenu(b,false,false,false,8,8);return false}}(this);this.closeConfigurator=function(a){return function(b){if(!b){b=window.event}a.resetViewportOverflow("west");a.resetConfigurator();return false}}(this);this.changeCategory=function(a){return function(G,D,I){if(!G){G=window.event}a.resetEditOptionColorFiltersExamples();var C=a.$(a.target+"-cX-ConfiguratorCategories");var w=a.$(a.target+"-cX-ConfiguratorSugestionsText");var t=a.$(a.target+"-cX-ConfiguratorSugestions");var H=a.$(a.target+"-cX-ConfiguratorSugestionsDescription");var q=a.$(a.target+"-cX-ConfiguratorValueText");var K=a.$(a.target+"-cX-ConfiguratorSeeAlso");var l=a.$(a.target+"-cX-ConfiguratorValue");var f=a.$(a.target+"-cX-ConfiguratorApply");var J=a.$(a.target+"-cX-ConfiguratorButton");var g=a.$(a.target+"-cX-ConfiguratorOptions");var B=a.$(a.target+"-cX-ConfiguratorColor");var h=a.$(a.target+"-cX-ConfiguratorFilter");var k=CanvasXpress.doc.M;if(I){C.value=I}if(C&&C.value&&w&&t&&H&&q&&K&&l&&J&&g&&B&&h){var y=k[C.value].P.sort();a.resetSugestions();for(var E=0;E<y.length;E++){if(I&&y[E]==I){D=E}var A=a.$cX("option",{text:y[E],value:y[E]});try{t.add(A,null)}catch(F){t.add(A)}}t.options[D||0].selected=true;w.innerHTML="Select property ("+y.length+")";a.setConfiguratorPropertyValue(t,H,q,K,l);w.style.display="block";t.style.display="block";H.style.display="block";q.style.display="block";K.style.display="block";l.style.display="block";f.style.display="block";J.style.display="block";g.style.display="none";B.style.display="none";h.style.display="none"}return false}}(this);this.hideCategories=function(){var a=this.$(this.target+"-cX-ConfiguratorCategories");var b=this.$(this.target+"-cX-ConfiguratorKeyTextSpan");var c=this.$(this.target+"-cX-ConfiguratorKeySearch");var e=this.$(this.target+"-cX-ConfiguratorKeyDock");if(a&&b&&c&&e){a.style.display="none";b.innerHTML="";c.style.display="none";e.style.display="none"}};this.resetCategories=function(){var a=this.$(this.target+"-cX-ConfiguratorCategories");if(a){if(a.hasChildNodes()){while(a.childNodes.length>=1){a.removeChild(a.firstChild)}}a.style.display="none"}};this.clickSuggestions=function(a){return function(b){if(!b){b=window.event}a.resetEditOptionColorFiltersExamples();a.setConfiguratorPropertyValue();return false}}(this);this.setConfiguratorPropertyValue=function(l,e,j,g,h){if(!l){l=this.$(this.target+"-cX-ConfiguratorSugestions")}if(!e){e=this.$(this.target+"-cX-ConfiguratorSugestionsDescription")}if(!j){j=this.$(this.target+"-cX-ConfiguratorValueText")}if(!g){g=this.$(this.target+"-cX-ConfiguratorSeeAlso")}if(!h){h=this.$(this.target+"-cX-ConfiguratorValue")}var k;var f=this.$(this.target+"-cX-ConfiguratorOptions");var c=this.getConfigurableObjectDoc(l.value);h.value="";h.style.readonly=false;if(this.configuringNetwork){if(typeof(this[l.value])=="function"){h.style.disabled="disabled";h.style.readonly=false}else{if(this.configuringNetwork<this.data.nodes.length){k=this.data.nodes[this.configuringNetwork][l.value]}else{k=this.data.edges[this.configuringNetwork-this.data.nodes.length][l.value]}}}else{if(this.configuringGenome){var b=this.subtracksInfo;if(!isNaN(this.configuringGenome)){k=this.data.tracks[b[this.configuringGenome].track].data[b[this.configuringGenome].index][l.value]}else{if(this.configuringGenome.match(/:/)){k=parseInt(this.configuringGenome.split(":")[1]);k=this.data.tracks[b[k].track].data[b[k].index][l.value]}else{k=parseInt(this.configuringGenome.replace("track-",""));k=this.data.tracks[b[k].track][l.value]}}}else{if(typeof(this[l.value])=="function"){j.innerHTML="Current&nbsp;value&nbsp;[&nbsp;<i>function</i>&nbsp;]&nbsp;"+this[l.value].length+"&nbsp;parameter(s)";if(this[l.value].length==0){h.style.disabled="disabled";h.style.readonly=false}}else{k=this[l.value]}}}h.value=k?JSON.stringify(k):"";this.addPropertyDescription(e,c,l.value);this.addPropertySeeAlsoLinks(g,c);this.addPropertyOptions(j,f,c,l.value,k);if(this.showConfiguratorExamplesOnSelect){this.resetPropertyExample();this.clickExamplePropertyDescription(false,l.value)}};this.resetSugestions=function(){var a=this.$(this.target+"-cX-ConfiguratorSugestions");if(a){if(a.hasChildNodes()){while(a.childNodes.length>=1){a.removeChild(a.firstChild)}}a.style.display="none"}};this.addPropertyDescription=function(r,g,f){var t=g&&g.C?g.C:"";var j=g&&g.M?g.M:"";var v=g&&g.H?true:false;this.resetPropertyDescription(r);var n=this.$cX("img",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionEdit",src:CanvasXpress.images.pencil,alt:"Edit description",title:"Edit description"},{cursor:"default",margin:"2px",width:"10px",height:"10px"});var a=this.$cX("i",{innerHTML:f});var w=this.$cX("span",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan",className:"CanvasXpressConfigurator",prop:f,innerHTML:" : "+t});var k=this.$cX("i",{innerHTML:j});var l=this.$cX("a",{id:this.target+"-cX-ConfiguratorSugestionsDescriptionExample",href:"javascript:void(0)",alt:"Show examples",title:"Show examples"});var u=this.$cX("span",false,{className:"CanvasXpressConfigurator"});l.appendChild(a);u.appendChild(document.createTextNode("Description [ "));u.appendChild(k);u.appendChild(document.createTextNode(" ]"));r.appendChild(u);r.appendChild(this.$cX("br"));r.appendChild(v?l:a);r.appendChild(w);r.appendChild(n);this.addEvtListener(l,"click",this.clickExamplePropertyDescription,false);this.addEvtListener(n,"click",this.clickEditPropertyDescription,false)};this.resetPropertyDescription=function(f,b,a){if(!f){f=this.$(this.target+"-cX-ConfiguratorSugestionsDescription")}if(!b){b=this.$(this.target+"-cX-ConfiguratorSugestionsDescriptionEdit")}if(f&&b){this.removeEvtListener(b,"click",this.clickEditPropertyDescription,false);if(!a){a=this.$(this.target+"-cX-ConfiguratorSugestionsDescriptionExample")}if(a){this.removeEvtListener(a,"click",this.clickExamplePropertyDescription,false)}while(f.childNodes.length>0){var g=f.childNodes[0];f.removeChild(g)}}};this.getGraphTypes=function(e,c){var a=[];if(e.U){for(var b=0;b<e.U.length;b++){var d=e.U[b];a=a.concat(CanvasXpress.graphTypes[d])}}else{if(CanvasXpress.doc.M[e.M].U){for(var b=0;b<CanvasXpress.doc.M[e.M].U.length;b++){var d=CanvasXpress.doc.M[e.M].U[b];a=a.concat(CanvasXpress.graphTypes[d])}}else{a=["Bar"]}}return c?this.getObjectArray(a):this.getUniqueEls(a).sort()};this.getExamplesDocObject=function(c,v){var h=[];if(c){var g=this.getConfigurableObjectDoc(c);var w=this.getGraphTypes(g);for(var n=0;n<g.H.length;n++){if(g.H[n].match(/^\{\[/)){var s=[];var a=g.H[n]=="{[*]}"||g.H[n].match(/^\{\[.+?\]\}[^,]/)||g.H[n].match(/^\{\[.+\]\}[^,]$/)?{}:JSON.parse(String(g.H[n].replace(/^\{\[.+?\],/,"{")));var e=a.data?this.getDataSet(a.data):false;var l=a.skipExample?this.getObjectArray(a.skipExample):{};var q=a.functions?a.functions:false;if(e){delete (a.data)}if(l){delete (a.skipExample)}if(q){delete (a.functions)}if(g.H[n].match(/^\{\[[^\*].+\]/)){s=g.H[n].replace(/"/g,"");s=s.split("]")[0].replace("{[","").split(",")}else{if(g.T=="option"){s=g.O}else{if(g.T=="boolean"){s=[true,false]}else{if(g.T=="color"){s=["rgb(255,125,51)","rgb(51,255,125)","rgb(125,51,255)"];s.unshift(g.D)}else{if(g.T=="float"){s=g.D=="null"?[null,0.5]:[parseFloat(g.D),Math.max(parseFloat(g.D)*2,1)]}else{if(g.T=="integer"){s=g.D==0?[0,1]:[parseInt(g.D),parseInt((parseInt(g.D)*2)+0.5)]}}}}}}if(s.length>8){s=this.sample(s,8)}for(var m=0;m<s.length;m++){if(l.hasOwnProperty(s[m])){continue}var b=(v?c:this.target)+"-cX-ConfiguratorExample-"+c+"-"+String(s[m]).replace(/\s/m,"-")+"-"+n;var k=this.cloneObject(a);if(s[m]=="null"||s[m]==null){k[c]=null}else{k[c]=g.T=="integer"||g.T=="float"?Number(s[m]):s[m];if(k[c]=="false"){k[c]=false}else{if(k[c]=="true"){k[c]=true}}}if(!k.graphType){k.graphType=w[2]||w[0]}if(q){h.push([b,e,k,q])}else{h.push([b,e,k])}}}else{var m=JSON.parse(String(g.H[n]));var t=m.data?this.getDataSet(m.data):false;var r=m.functions?m.functions:false;if(t){delete (m.data)}if(r){delete (m.functions)}var b=(v?c:this.target)+"-cX-ConfiguratorExample-"+c+"-"+n;if(!m.graphType){m.graphType=w[2]||w[0]}if(r){h.push([b,t,m,r])}else{h.push([b,t,m])}}}}return h};this.clickExamplePropertyDescription=function(a){return function(y,r,C){a.resetPropertyExample();var k=function(j,c){var p=["sankey","tree","bubble"];for(var e=0;e<p.length;e++){delete (j[p[e]]);delete (c[p[e]])}return j?j:c};var d=function(){if(a.graphType!=m){m=a.graphType;B=a.getDataSet()}return B};var x=C?a.$(r+"-cX-API-Example"):a.$(a.target+"-cX-ConfiguratorExample");var f=C?a.$(r+"-cX-API-ExampleSpan"):a.$(a.target+"-cX-ConfiguratorExampleSpan");var q=C?a.$(r+"-cX-API-ExampleContent"):a.$(a.target+"-cX-ConfiguratorExampleContent");var m=a.graphType;var B=a.getDataSet();if(x&&f&&q){x.style.display="block";if(!r){r=this.firstChild.innerHTML}var g=a.getExamplesDocObject(r);f.innerHTML=r;for(var u=0;u<g.length;u++){var s=g[u][0];var w=g[u][2];a.graphType=w.graphType;var o=k(a.cloneObject(g[u][1]),d());var h=g[u][3];var z=a.$cX("canvas",{id:s,width:C?500:a.configuratorExamplesSize,height:C?500:a.configuratorExamplesSize});q.appendChild(z);if(!w.title){if(w[r]!=null){if(this.isArray(w[r])){w.title=r+" : "+w[r].join(",")}else{if(this.isObject(w[r])){w.title=r+" : Object"}else{w.title=r+" : "+w[r]}}}else{w.title=r+" : null"}}var l=new CanvasXpress(s,o,w);if(h){for(var t=0;t<h.length;t++){if(h[t].match(/:/)){var b=h[t].split(":");l[b.shift()].apply(l,b)}else{l[h[t]]()}}}}if(!C){if(a.alignConfiguratorExamples||a.configuratorLastState=="docked"){var n=a.$(a.target+"-cX-Configurator");x.style.left=n.offsetWidth+"px";x.style.top="-1px";x.style.height=(n.clientHeight-45)+"px";q.style.maxHeight=(n.clientHeight-45)+"px";a.removeClass(x,"draggable")}else{var A=a.adjustedCoordinates(y,x);x.style.left=A.x+"px";x.style.top=A.y+"px";delete (x.style.height);q.style.Maxheight="500px";a.addClass(x,"draggable")}}}}}(this);this.clickEditPropertyDescription=function(a){return function(h){if(!h){h=window.event}a.resetPropertyColor();a.resetPropertyFilter();a.resetPropertyExample();var f=a.$(a.target+"-cX-Configurator");var g=a.$(a.target+"-cX-ConfiguratorSugestions");var u=a.$(a.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan");var m=a.$(a.target+"-cX-ConfiguratorOptions");if(f&&g&&u&&m){m.style.display="none";var t=a.adjustedCoordinates(h,g);if(t){a.editingDescriptionOn=true;var r=t.x;var o=t.y;var j=a.$cX("div",{id:a.target+"-cX-ConfiguratorEditForm",className:"CanvasXpressConfigurator draggable"},{cursor:"move",left:r+"px",top:o+"px",padding:"10px",position:"absolute",width:(a.configuratorWidth*0.8)+"px"});var l=a.$cX("img",{id:a.target+"-cX-ConfiguratorEditFormClose",className:"CanvasXpressConfigurator",src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"});var q=a.$cX("textarea",{id:a.target+"-cX-ConfiguratorEditFormValue",className:"CanvasXpressConfigurator",value:u.prop+u.innerHTML,rows:10},{width:"100%",maxWidth:(a.configuratorWidth*0.8)+"px"});var n=a.$cX("input",{id:a.target+"-cX-ConfiguratorEditFormButton",value:"Submit",type:"button"},{width:"100%",borderRadius:"5px",maxWidth:(a.configuratorWidth*0.8)+"px"});j.appendChild(document.createTextNode("Editing "+g.value));j.appendChild(l);j.appendChild(a.$cX("br"));j.appendChild(q);j.appendChild(n);a.addEvtListener(l,"click",a.closeEditPropertyDescription,false);a.addEvtListener(n,"click",a.submitEditPropertyDescription,false);f.appendChild(j)}}}}(this);this.submitEditPropertyDescription=function(a){return function(f){if(!f){f=window.event}var c=a.$(a.target+"-cX-ConfiguratorSugestions");var b=a.$(a.target+"-cX-ConfiguratorEditFormValue");var d=a.$(a.target+"-cX-ConfiguratorSugestionsDescriptionEditSpan");if(c&&b&&d){b.value=b.value.replace(/\n/g,"");CanvasXpress.doc.P[c.value].C=b.value;d.innerHTML=b.value;alert("New description for:\n - "+c.value+" -\nwas submitted and may apppear\nin new versions of CanvasXpress\nThank you for your contribution")}a.resetEditPropertyDescription()}}(this);this.closeEditPropertyDescription=function(a){return function(b){if(!b){b=window.event}a.resetEditPropertyDescription()}}(this);this.resetEditPropertyDescription=function(){var e=this.$(this.target+"-cX-ConfiguratorEditForm");var f=this.$(this.target+"-cX-ConfiguratorEditFormClose");var a=this.$(this.target+"-cX-ConfiguratorEditFormButton");if(e&&f&&a){this.addEvtListener(f,"click",this.closeEditPropertyDescription,false);this.addEvtListener(a,"click",this.submitEditPropertyDescription,false);e.parentNode.removeChild(e)}this.editingDescriptionOn=false};this.addPropertySeeAlsoLinks=function(e,g){this.resetPropertySeeAlsoLinks(e);var d=this.$cX("span",false,{className:"CanvasXpressConfigurator"});d.appendChild(document.createTextNode("See Also: "));e.appendChild(d);if(g&&g.S){for(var f=0;f<g.S.length;f++){var h=this.$cX("a",{href:"javascript:void(0)",innerHTML:g.S[f]});this.addEvtListener(h,"click",this.clickPropertySeeAlsoLinks,false);e.appendChild(h);if(f<g.S.length-1){e.appendChild(document.createTextNode(", "))}}}};this.clickPropertySeeAlsoLinks=function(a){return function(h){if(!h){h=window.event}var f=a.$(a.target+"-cX-ConfiguratorKey");var b=a.$(a.target+"-cX-ConfiguratorCategories");var g=a.$(a.target+"-cX-ConfiguratorSugestions");var c=h.target||h.srcElement;if(b&&b.style.display=="block"){var l=CanvasXpress.doc.P[c.innerHTML];var j=CanvasXpress.doc.M[l.M].P.sort();b.value=l.M;for(i=0;i<j.length;i++){if(j[i]==c.innerHTML){a.changeCategory(h,i);return false}}a.changeCategory(h)}else{if(f){f.value=c.innerHTML;a.selectConfig(h,true)}}return false}}(this);this.resetPropertySeeAlsoLinks=function(b){if(!b){b=this.$(this.target+"-cX-ConfiguratorSeeAlso")}if(b&&b.childNodes){while(b.childNodes.length>0){var d=b.childNodes[0];if(d.nodeName.toLowerCase()=="a"){this.removeEvtListener(d,"click",this.clickPropertySeeAlsoLinks,false)}b.removeChild(d)}}};this.addPropertyOptions=function(w,p,f,g,s){this.resetPropertyOptions(w,p);var q=this.$cX("span",false,{className:"CanvasXpressConfigurator"});var l=this.$cX("i");q.appendChild(document.createTextNode("Current value"));if(f&&f.T&&(f.T=="option"||f.T=="array"||f.T=="boolean")){var x=this.$cX("div",{id:this.target+"-cX-ConfiguratorOptionsContainer",className:"CanvasXpressConfiguratorOptions"});var r=this.$cX("a",{href:"javascript:void(0)",innerHTML:f.T,alt:"Modify property",title:"Modify property"});this.addEvtListener(r,"click",this.clickPropertyOptions,false);q.appendChild(document.createTextNode(" ["));l.appendChild(r);q.appendChild(document.createTextNode(" "));q.appendChild(l);q.appendChild(document.createTextNode(" ]"));if(f.T=="array"){var n=f.X?this[f.X]():f.O?f.O:[];var m=this.getObjectArray(s);if(n.length>0){for(var h=0;h<n.length;h++){var g=this.$cX("input",{type:"checkbox",value:n[h],checked:m.hasOwnProperty(n[h])?true:false},{marginLeft:"0px"});this.addEvtListener(g,"change",this.updatePropertyValue,false);x.appendChild(document.createTextNode((h+1)+". "));x.appendChild(g);x.appendChild(document.createTextNode(n[h]));x.appendChild(this.$cX("br"))}}else{x.appendChild(this.$cX("br"));x.appendChild(document.createTextNode("This array is user defined"));x.appendChild(this.$cX("br"))}}else{var n=f.T=="boolean"?["true","false"]:f.X?this[f.X]():f.O?f.O:[];if(f.X&&f.O){n=n.concat(f.O)}for(var h=0;h<n.length;h++){var g=this.$cX("a",{href:"javascript:void(0)",innerHTML:n[h],alt:"Modify property",title:"Modify property"},{padding:"2px"});this.addEvtListener(g,"click",this.updatePropertyValue,false);x.appendChild(document.createTextNode((h+1)+". "));x.appendChild(g);x.appendChild(this.$cX("br"))}}p.appendChild(x)}else{if(f&&f.T){q.appendChild(document.createTextNode(" ["));if(f.T=="color"){var n;if(this.configuringNetwork){if(this.configuringNetwork<this.data.nodes.length){n=this.data.nodes[this.configuringNetwork][g]}else{n=this.data.edges[this.configuringNetwork-this.data.nodes.length][g]}}else{if(this.configuringGenome){var e=this.subtracksInfo;if(!isNaN(this.configuringGenome)){n=this.data.tracks[e[this.configuringGenome].track].data[e[this.configuringGenome].index]}else{if(this.configuringGenome.match(/:/)){n=parseInt(this.configuringGenome.split(":")[1]);n=this.data.tracks[e[n].track].data[e[n].index]}else{n=parseInt(this.configuringGenome.replace("track-",""));n=this.data.tracks[e[n].track]}}}else{n=this[g]}}var r=this.$cX("a",{id:this.target+"-cX-ConfiguratorValueHREF",href:"javascript:void(0)",innerHTML:f.T,alt:"Modify color",title:"Modify color"},{color:n?this.rgbToHex(this.validateColor(n)):this.foreground});this.addEvtListener(r,"click",this.addPropertyColor,false);l.appendChild(r)}else{if(f&&f.T=="filter"){var r=this.$cX("a",{id:this.target+"-cX-ConfiguratorValueFilter",href:"javascript:void(0)",innerHTML:f.T,name:g});r.opts=f.X?this[f.X]():f.O?f.O:[];r.opts.unshift("");this.addEvtListener(r,"click",this.addPropertyFilter,false);l.appendChild(r)}else{l.appendChild(document.createTextNode(f.T))}}q.appendChild(document.createTextNode(" "));q.appendChild(l);q.appendChild(document.createTextNode(" ]"))}}w.appendChild(q)};this.clickPropertyOptions=function(a){return function(b){if(!b){b=window.event}a.resetEditPropertyDescription();var c=a.$(a.target+"-cX-ConfiguratorOptions");if(c){c.style.display="block";c.style.left=b.layerX+"px";c.style.top=b.layerY+"px"}return false}}(this);this.closePropertyOptions=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorOptions")}}(this);this.resetPropertyOptions=function(a,e,b){if(!a){a=this.$(this.target+"-cX-ConfiguratorValueText")}if(!e){e=this.$(this.target+"-cX-ConfiguratorOptions")}if(a&&a.childNodes&&!b){while(a.childNodes.length>0){var f=a.childNodes[0];if(f.nodeName.toLowerCase()=="a"){this.removeEvtListener(f,"click",this.clickPropertyOptions,false)}a.removeChild(f)}}if(e){var d=this.$(this.target+"-cX-ConfiguratorOptionsContainer");if(d){while(d.childNodes.length>0){var f=d.childNodes[0];if(f.nodeName.toLowerCase()=="a"){this.removeEvtListener(f,"click",this.updatePropertyValue,false)}else{if(f.nodeName.toLowerCase()=="input"&&f.type=="checkbox"){this.removeEvtListener(f,"change",this.updatePropertyValue,false)}}d.removeChild(f)}e.removeChild(d)}e.style.display="none"}};this.addPropertyFilter=function(a){return function(d){if(!d){d=window.event}a.resetEditPropertyDescription();var b=d.target||d.srcElement;var c=a.$(a.target+"-cX-ConfiguratorFilter");a.addAllPropertyFilters(b.name,b.opts);c.style.display="block";c.opts=b.opts;c.style.left=d.layerX+"px";c.style.top=d.layerY+"px"}}(this);this.addAllPropertyFilters=function(c,d){var b=this.$(this.target+"-cX-ConfiguratorFilter");for(var a=0;a<this[c].length;a++){this.insertPropertyFilterRow(b,a,c,d)}this.insertPropertyFilterRow(b,this[c].length,c,d)};this.insertPropertyFilterRow=function(F,B,r,y){if(!F){F=this.$(this.target+"-cX-ConfiguratorFilter")}if(F){var e=this.configuratorWidth*0.25;var G=this.$cX("div",{id:this.target+"-cX-ConfiguratorFilterContainer"+B},{width:(this.configuratorWidth*1.05)+"px"});var q=this.$cX("select",{id:this.target+"-cX-ConfiguratorFilterSelect"+B,className:"CanvasXpressConfiguratorFilter",param:r,idx:B},{marginRight:"2px",marginLeft:"1px",width:e+"px"});if(!y){y=F.opts}y.sort();for(var A=0;A<y.length;A++){var d=this.$cX("option",{text:y[A],value:y[A]});try{q.add(d,null)}catch(E){q.add(d)}if(this[r][B]&&y[A]==this[r][B]){d.selected=true}}this.addEvtListener(q,"change",this.unsetPropertyFilterRow,false);var t=this.$cX("select",{id:this.target+"-cX-ConfiguratorFilterOp"+B,className:"CanvasXpressConfiguratorFilter",param:r,idx:B},{marginRight:"2px",width:e+"px"});var x=this.getOperators();for(var A=0;A<x.length;A++){var d=this.$cX("option",{text:x[A],value:x[A]});try{t.add(d,null)}catch(E){t.add(d)}if(this[r+"Op"][B]&&x[A]==this[r+"Op"][B]){d.selected=true}}this.addEvtListener(t,"change",this.unsetPropertyFilterRow,false);var I=this.$cX("img",{src:CanvasXpress.images.caseSensitive},{width:"10px"});var H=this.$cX("input",{id:this.target+"-cX-ConfiguratorFilterCase"+B,type:"checkbox",param:r,idx:B,alt:"Check for case sensitive",title:"Check for case sensitive"},{width:"10px"});if(this[r+"Case"][B]){H.checked=true}this.addEvtListener(H,"change",this.unsetPropertyFilterRow,false);var n=this.$cX("input",{id:this.target+"-cX-ConfiguratorFilterValue"+B,param:r,idx:B,type:"text"},{width:e+"px"});if(this[r+"Value"][B]){n.value=this[r+"Value"][B]}this.addEvtListener(n,"change",this.unsetPropertyFilterRow,false);var u=this.$cX("img",{id:this.target+"-cX-ConfiguratorFilterMinus"+B,src:CanvasXpress.images.minus,alt:"Remove Filter",title:"Remove Filter",param:r,idx:B},{padding:"9px 2px 2px 2px",cssFloat:"left",cursor:"default",width:"10px"});this.addEvtListener(u,"click",this.removePropertyFilterRow,false);var e=this.$cX("img",{id:this.target+"-cX-ConfiguratorFilterPlus"+B,src:CanvasXpress.images.add1,alt:"Set Filter",title:"Set Filter",param:r,idx:B},{padding:"7px 2px 2px 2px",cssFloat:"right",cursor:"default",width:"10px"});this.addEvtListener(e,"click",this.addPropertyFilterRow,false);var D=this.$cX("img",{id:this.target+"-cX-ConfiguratorFilterCheck"+B,src:CanvasXpress.images.accept,alt:"Filter added",title:"Filter added"},{padding:"7px 2px 2px 2px",cssFloat:"right",cursor:"default",width:"10px",display:this[r][B]?"block":"none"});var C=this.$cX("div",{id:this.target+"-cX-ConfiguratorFilterCheckEmpty"+B},{cssFloat:"right",cursor:"default",width:"10px",display:this[r][B]?"none":"block"});G.appendChild(u);G.appendChild(q);G.appendChild(t);G.appendChild(I);G.appendChild(H);G.appendChild(n);G.appendChild(C);G.appendChild(D);G.appendChild(e);F.appendChild(G)}};this.addPropertyFilterRow=function(a){return function(q){if(!q){q=window.event}var b=q.target||q.srcElement;var d=b.parentNode;var r=b.param;var l=b.idx;var t=a.$(a.target+"-cX-ConfiguratorValue");var n=a.$(a.target+"-cX-ConfiguratorFilterCheck"+l);var m=a.$(a.target+"-cX-ConfiguratorFilterCheckEmpty"+l);if(d&&r&&l!=null&&t&&n&&m){var j=d.childNodes[1].value;var f=d.childNodes[2].value;var s=d.childNodes[4].checked;var u=d.childNodes[5].value;if(j!=""&&((f!=""&&u!="")||f.match("null"))){if(a[r].length>0&&a[r][l]!=null){a[r][l]=j;a[r+"Op"][l]=f;a[r+"Value"][l]=u;a[r+"Case"][l]=s}else{a[r].push(j);a[r+"Op"].push(f);a[r+"Value"].push(u);a[r+"Case"].push(s);a.insertPropertyFilterRow(false,l+1,r)}t.value='["'+a[r].join('", "')+'"]';n.style.display="block";m.style.display="none"}}}}(this);this.removePropertyFilterRow=function(a){return function(k){if(!k){k=window.event}var d=k.target||k.srcElement;var j=d.parentNode;var h=j.parentNode;var l=d.param;var f=d.idx;var b=a.$(a.target+"-cX-ConfiguratorValue");if(j&&l&&f!=null&&b){a.resetFilters(l,f);a.resetPropertyFilter(true);a.addAllPropertyFilters(l,h.opts);b.value=a[l].length>0?'["'+a[l].join('", "')+'"]':"[]"}}}(this);this.unsetPropertyFilterRow=function(a){return function(m){if(!m){m=window.event}var p=[];var b=m.target||m.srcElement;var n=b.param;var f=b.idx;if(n&&f!=null){if(a[n].length>0&&a[n][f]){a[n][f]=false;a[n+"Op"][f]=false;a[n+"Value"][f]=false;a[n+"Case"][f]=false;for(var d=0;d<a[n].length;d++){if(d!=f){p.push(a[n][d])}}var l=a.$(a.target+"-cX-ConfiguratorFilterCheck"+f);var k=a.$(a.target+"-cX-ConfiguratorFilterCheckEmpty"+f);var o=a.$(a.target+"-cX-ConfiguratorValue");if(l&&k&&o){l.style.display="none";k.style.display="block";o.value=p.length>0?'["'+p.join('", "')+'"]':"[]"}}}}}(this);this.closePropertyFilter=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorFilter");a.resetPropertyFilter()}}(this);this.closePropertyExample=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorExample");a.resetPropertyExample()}}(this);this.resetPropertyFilter=function(a){var b=this.$(this.target+"-cX-ConfiguratorFilter");if(b){if(b&&b.childNodes){while(b.childNodes.length>3){var c=b.childNodes[3];this.removeEvtListener(c.childNodes[0],"click",this.removePropertyFilterRow,false);this.removeEvtListener(c.childNodes[1],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[2],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[4],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[5],"change",this.unsetPropertyFilterRow,false);this.removeEvtListener(c.childNodes[8],"click",this.addPropertyFilterRow,false);b.removeChild(b.childNodes[3])}}if(!a){b.style.display="none"}}};this.resetPropertyExample=function(a){var b=this.$(this.target+"-cX-ConfiguratorExample");if(b){this.destroyInDOM(b.getElementsByTagName("canvas"));if(!a){b.style.display="none"}}};this.addPropertyColor=function(a){return function(j){if(!j){j=window.event}a.resetEditPropertyDescription();var d=a.$(a.target+"-cX-ConfiguratorColor");var t=a.$(a.target+"-cX-ConfiguratorValue");if(d&&t){var g=t.value?a.rgbToHex(a.validateColor(t.value.replace(/[\'\"]/g,""))):a.foreground;a.colorRGBfromString(g);var r=Math.round(a.colorHSV[0]/6*180);var q=Math.round((1-a.colorHSV[1])*100);var m=Math.round((1-a.colorHSV[2])*100);var l=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorContainer"},{width:"210px",height:"101px",marginTop:"7px"});var b=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorPalette",className:"CanvasXpressConfiguratorColorMain"},{position:"relative",left:"0px",top:"0px",width:"181px",height:"101px"});var o=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorPaletteCurrent",className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:(r-7)+"px",top:(q-7)+"px",width:"195px",height:"115px"});b.appendChild(o);var w=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorSaturation",className:"CanvasXpressConfiguratorColor"},{position:"relative",left:"188px",width:"15px",height:"100px",border:"1px solid rgb(51,122,183)",cursor:"crosshair"});for(var f=0;f<100;f+=4){var u=a.$cX("div",false,{height:"4px",position:"relative",left:"0px",cursor:"crosshair"});w.appendChild(u)}var k=a.$cX("div",{id:a.target+"-cX-ConfiguratorColorSaturationCurrent",className:"CanvasXpressConfiguratorColorExtra"},{position:"relative",left:"0px",top:(m-108)+"px",width:"29px",height:"115px"});w.appendChild(k);l.appendChild(b);l.appendChild(w);d.appendChild(l);a.colorizeCurrentColorDiv();a.colorizeSaturationColorDiv();a.addEvtListener(b,"mousedown",a.registerPalette,false);a.addEvtListener(w,"mousedown",a.registerSaturation,false);d.style.display="block";d.style.left=j.layerX+"px";d.style.top=j.layerY+"px"}return false}}(this);this.registerPalette=function(a){return function(b){if(!b){b=window.event}a.changingColorOn="palette";if(a.colorHSV[2]==0){a.colorFromHsv(null,null,1);a.colorizeCurrentColorDiv();var c=a.$(a.target+"-cX-ConfiguratorColorSaturationCurrent");if(c){c.style.top="-108px"}}a.updateColorValue(b);a.colorizeSaturationColorDiv();return false}}(this);this.registerSaturation=function(a){return function(b){if(!b){b=window.event}a.changingColorOn="saturation";a.updateColorValue(b);return false}}(this);this.updateColorValue=function(g){if(this.changingColorOn){if(this.changingColorOn=="palette"){var f=this.$(this.target+"-cX-ConfiguratorColorPalette");var b=this.$(this.target+"-cX-ConfiguratorColorPaletteCurrent");if(f&&b){var d=this.adjustedCoordinates(g,f);if(d){var a=Math.min(Math.max(0,d.x),181);var j=Math.min(Math.max(0,d.y),101);b.style.left=(a-7)+"px";b.style.top=(j-7)+"px";this.colorFromHsv(a*6/180,1-j/100,null);this.colorizeCurrentColorDiv();this.colorizeSaturationColorDiv()}}}else{var c=this.$(this.target+"-cX-ConfiguratorColorSaturation");var h=this.$(this.target+"-cX-ConfiguratorColorSaturationCurrent");if(c&&h){var d=this.adjustedCoordinates(g,c);if(d){var j=Math.min(Math.max(0,d.y),101);h.style.top=(j-108)+"px";this.colorFromHsv(null,null,1-j/100);this.colorizeCurrentColorDiv()}}}}};this.colorizeCurrentColorDiv=function(){var f=this.$(this.target+"-cX-ConfiguratorColorCurrent");var a=this.$(this.target+"-cX-ConfiguratorValue");var d=this.$(this.target+"-cX-ConfiguratorValueHREF");if(f&&a&&d){var e=this.colorRGBToString();var b=this.hexToRgb("#"+e);f.style.backgroundColor="#"+e;f.innerHTML="&nbsp;&nbsp;"+b;f.style.color=this.complementaryColor(b,true);a.value='"'+b+'"';d.style.color="#"+e}};this.colorizeSaturationColorDiv=function(){var b=function(m,k,c,j,h){return"rgb("+(m*(1-j/h)*100)+"%,"+(k*(1-j/h)*100)+"%,"+(c*(1-j/h)*100)+"%)"};var e=this.$(this.target+"-cX-ConfiguratorColorSaturation");if(e&&this.colorHSV){var f=e.childNodes;var a=this.hsvFromRgb(this.colorHSV[0],this.colorHSV[1],1);if(a){for(var d=0;d<f.length-1;d++){f[d].style.backgroundColor=b(a[0],a[1],a[2],d,f.length-1)}}}};this.endColorChange=function(a){this.changingColorOn=false};this.closePropertyColor=function(a){return function(b){if(!b){b=window.event}a.handleHideDiv(a.target+"-cX-ConfiguratorColor");a.resetPropertyColor()}}(this);this.resetPropertyColor=function(){var c=this.$(this.target+"-cX-ConfiguratorColor");var b=this.$(this.target+"-cX-ConfiguratorColorPalette");var a=this.$(this.target+"-cX-ConfiguratorColorSaturation");if(c&&b&&a){if(c&&c.childNodes){while(c.childNodes.length>3){c.removeChild(c.childNodes[3])}this.removeEvtListener(b,"mousedown",this.registerPalette,false);this.removeEvtListener(a,"mousedown",this.registerSaturation,false)}c.style.display="none"}};this.updatePropertyValue=function(a){return function(h){if(!h){h=window.event}a.resetEditPropertyDescription();var f=a.$(a.target+"-cX-ConfiguratorValue");var j=a.$(a.target+"-cX-ConfiguratorOptions");var d=h.target||h.srcElement;if(d.nodeName.toLowerCase()=="input"){var b=[];for(var g=0;g<d.parentNode.childNodes.length;g++){var k=d.parentNode.childNodes[g];if(k.checked){b.push(k.value)}}f.value=b.length>0?'["'+b.join('", "')+'"]':"[]"}else{if(f&&j){if(d.innerHTML=="true"){f.value=d.innerHTML}else{if(d.innerHTML=="false"){f.value=d.innerHTML}else{if(d.innerHTML=="null"){f.value=d.innerHTML}else{f.value='"'+d.innerHTML+'"'}}}j.style.display="none"}}return false}}(this);this.clickApplyConfigurator=function(a){return function(b){return a.clickConfigurator(b,false,false,true)}}(this);this.clickConfigurator=function(a){return function(g,d,c,b){if(!g){g=window.event}if(!d){d=a.$(a.target+"-cX-ConfiguratorSugestions")}if(!c){c=a.$(a.target+"-cX-ConfiguratorValue")}if(d&&c){var f=a.getConfigurableObjectDoc(d.value);if(c.value){var h=JSON.parse(c.value);if(f.T=="color"&&!a.validateColor(h)){alert('"'+h+'" is NOT a valid color');return false}}}a.updateClickConfigurator(d.value,c.value,b);return false}}(this);this.updateClickConfigurator=function(h,d,b){this.functionCaller="updateClickConfigurator";if(this.isTransition()){return}if(this.configuringNetwork){if(this.configuringNetwork<this.data.nodes.length){if(typeof(this[h])=="function"){this[h](this.data.nodes[this.configuringNetwork])}else{this.data.nodes[this.configuringNetwork][h]=JSON.parse(d)}}else{if(typeof(this[h])=="function"){this[h](this.data.edges[this.configuringNetwork-this.data.nodes.length])}else{this.data.edges[this.configuringNetwork-this.data.nodes.length][h]=JSON.parse(d)}}}else{if(this.configuringGenome){var g=this.subtracksInfo;if(!isNaN(this.configuringGenome)){this.data.tracks[g[this.configuringGenome].track].data[g[this.configuringGenome].index][h]=JSON.parse(d)}else{if(this.configuringGenome.match(/:/)){var k=parseInt(this.configuringGenome.split(":")[1]);this.data.tracks[g[k].track].data[g[k].index][h]=JSON.parse(d)}else{var k=parseInt(this.configuringGenome.replace("track-",""));this.data.tracks[k][h]=JSON.parse(d)}}}else{if(typeof(this[h])=="function"){if(this[h].length>0&&d){var c=JSON.parse(d);this[h](c)}else{this[h]()}this.resetConfigurator();return false}else{if(h=="summaryType"&&this.isGroupedData&&this[h]!=JSON.parse(d)){var e=this.groupingFactors;this.ungroupSamples(true);this[h]=JSON.parse(d);this.meta.config.user[h]=this[h];this.groupSamples(e,false,false,false,true)}else{this[h]=JSON.parse(d);this.meta.config.user[h]=this[h]}}}}if(!b){this.resetConfigurator()}var j=h.match(/filter(.+)By/);if(j){this.reset();this.filterData()}this.resetPropertyExample();this.draw()};this.handleHideDiv=function(a){var b=this.$(a);if(b){b.style.display="none"}return false};this.resetOptionColorFiltersExamples=function(){this.resetPropertyOptions(false,false,true);this.resetPropertyColor();this.resetPropertyFilter();this.resetPropertyExample()};this.resetEditOptionColorFiltersExamples=function(){this.resetEditPropertyDescription();this.resetPropertyOptions(false,false,true);this.resetPropertyFilter();this.resetPropertyExample()};this.resetConfigurator=function(){if(this.configuringOn&&this.configuringOn!="docked"){this.resetEditOptionColorFiltersExamples();this.resetPropertyDescription();this.resetPropertySeeAlsoLinks();this.editingDescriptionOn=false;this.configuratorLastState=false;this.configuringOn=false;this.configuringNetwork=false;this.configuringGenome=false;this.addRemoveConfiguratorListeners("removeEvtListener");this.removeTarget(this.target+"-cX-Configurator")}}};CanvasXpress.prototype.initCodeInfo=function(){this.addInfoCodeDiv=function(){if(this.$(this.target+"-cX-Code")){return}var h=this.$cX("div",{id:this.target+"-cX-Code",className:"CanvasXpressCode draggable"},{left:"25px",top:"-"+(this.height-25)+"px",display:"none"});var j=this.$cX("img",{id:this.target+"-cX-CodeCloseImage",className:"CanvasXpressCode",src:CanvasXpress.images.cancel1,alt:"Close Code",title:"Close Code"});var f=this.$cX("img",{id:this.target+"-cX-CodePrettyImage",className:"CanvasXpressCode",src:CanvasXpress.images.blueCode,alt:"Pretty Code",title:"Pretty Code"});var e=this.$cX("img",{id:this.target+"-cX-CodeCompactImage",className:"CanvasXpressCode",src:CanvasXpress.images.greenCode,alt:"Compact Code",title:"Compact Code"});var d=this.$cX("img",{id:this.target+"-cX-CodeTabImage",className:"CanvasXpressCode",src:CanvasXpress.images.yellowCode,alt:"Tab Code",title:"Tab Code"});var b=this.$cX("img",{id:this.target+"-cX-CodeParamsImage",className:"CanvasXpressCode",src:CanvasXpress.images.redCode,alt:"Params Code",title:"Params Code"});var k=this.$cX("img",{id:this.target+"-cX-CodeSelectImage",className:"CanvasXpressCode",src:CanvasXpress.images.selectAll,alt:"Select Code",title:"Select Code"});var g=this.$cX("div",{id:this.target+"-cX-CodeContainer",className:"CanvasXpressCodeContainer"});var a=this.$("north-wrapper-"+this.target);var l=this.$("south-wrapper-"+this.target);if(a){a.appendChild(g)}if(l){h.appendChild(j);h.appendChild(f);h.appendChild(e);h.appendChild(d);h.appendChild(b);h.appendChild(k);h.appendChild(g);l.appendChild(h);this.addRemoveCodeListeners("addEvtListener")}};this.addRemoveCodeListeners=function(a){this.addRemoveEvtListener(a,this.$(this.target+"-cX-Code"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeCloseImage"),"click",this.clickCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodePrettyImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeCompactImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeTabImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeParamsImage"),"click",this.clickChangeCode,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-CodeSelectImage"),"click",this.clickSelectCode,false)};this.clickCode=function(a){return function(b){if(!b){b=window.event}a.hideCodeDiv();return false}}(this);this.clickChangeCode=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);switch(b.id){case a.target+"-cX-CodePrettyImage":a.codeType="pretty";break;case a.target+"-cX-CodeCompactImage":a.codeType="compact";break;case a.target+"-cX-CodeTabImage":a.codeType="tab";break;case a.target+"-cX-CodeParamsImage":a.codeType="params";break;default:break}a.updateCodeDiv();return false}}(this);this.clickSelectCode=function(a){return function(d){if(!d){d=window.event}var b;var c=a.$(a.target+"-cX-CodeContent");if(c){if(document.selection){b=document.body.createTextRange();b.moveToElementText(c);b.select()}else{if(window.getSelection){b=document.createRange();b.selectNode(c);window.getSelection().addRange(b)}}}return false}}(this);this.clearCodeDiv=function(){var b=this.$(this.target+"-cX-Code");var a=this.$(this.target+"-cX-CodeContent");if(b&&a){a.parentNode.removeChild(a);b.style.display="none"}};this.getDataJSON=function(b){var a={x:true,y:true,z:true,market:true,venn:true,nodes:true,edges:true,tracks:true,video:true};var d=this.cloneObject(this.data,true);for(var c in d){if(!a.hasOwnProperty(c)){delete (d[c])}}return b?this.prettyJSON(d):JSON.stringify(d)};this.getConfigJSON=function(a){return a?this.prettyJSON(this.getConfig()):JSON.stringify(this.getConfig())};this.getCodeJSONJS=function(a){var b=this.getDataJSON(a);var e=this.getConfigJSON(a);return'new CanvasXpress("canvas", '+b+", "+e+");\n"};this.updateCodeDiv=function(i){var j=this.$(this.target+"-cX-Code");var d=this.$(this.target+"-cX-CodeContainer");var g=this.getDataJSON(this.codeType=="pretty");var e=this.codeType=="params"?"{\n  ...\n}":g;var f=this.getConfigJSON(this.codeType=="pretty"||this.codeType=="params");if(j&&d){this.clearCodeDiv();var a=this.codeType=="tab"||this.codeType=="compact"?"span":"pre";var b=this.codeType=="tab"?"canvasID\t"+e+"\t"+f+"\n":'new CanvasXpress("canvasID", '+e+", "+f+")\n";d.appendChild(this.$cX(a,{id:this.target+"-cX-CodeContent",className:"CanvasXpressCodeContent",innerHTML:b}));j.style.display="block";if(i){j.style.zIndex=i}}};this.updateInfoDiv=function(a){var b=this.$(this.target+"-cX-Info");if(b&&a){b.innerHTML=a}};this.showDiv=function(a){var b=this.$(this.target+"-cX-"+a);if(b){b.style.display="block"}};this.hideDiv=function(a){var b=this.$(this.target+"-cX-"+a);if(b){b.style.display="none"}};this.showCodeDiv=function(){this.updateCodeDiv();this.removeMenus();this.showDiv("Code")};this.hideCodeDiv=function(){this.hideDiv("Code")};this.showInfoDiv=function(){this.removeMenus();this.showDiv("Info")};this.hideInfoDiv=function(){this.hideDiv("Info")};this.initializeCodeInfo=function(){this.addInfoCodeDiv()};this.initializeCodeInfo()};CanvasXpress.prototype.initBin=function(){this.addBinConfigurator=function(M,B){this.removeMenus();var z=this.target+"-"+M+"-cX-Bin";var f=this.range(this.data.y.data[M]);var E=(f[1]-f[0])/B;var w=this.getAxisDecimals(f[0])+1;this.binConfigurations[z]={};this.binConfigurations[z]["apply"]=false;this.binConfigurations[z]["n"]=B;this.binConfigurations[z]["vi"]=M;this.binConfigurations[z]["min"]=f[0];this.binConfigurations[z]["max"]=f[1];this.binConfigurations[z]["dec"]=w;this.binConfigurations[z]["name"]="Custom-"+this.data.y.vars[M]+"-Bin";this.binConfigurations[z]["bins"]=[];for(var H=0;H<B;H++){this.binConfigurations[z]["bins"][H]={name:"Bin-"+(H+1),value:Number(f[0]+((H+1)*E))}}var I=this.$cX("div",{id:z,className:"CanvasXpressBin draggable"},{left:"20px",top:"-200px",display:"block"});var g=this.$cX("img",{id:z+"CloseImage",className:"CanvasXpressBin",src:CanvasXpress.images.cancel1,alt:"Close Bin Configurator",title:"Close Bin Configurator"});var J=this.$cX("div",{id:z+"Container",className:"CanvasXpressBinContainer"});var C=this.$cX("input",{id:z+"Name",className:"CanvasXpressBin",type:"text",value:"Custom-"+this.data.y.vars[M]+"-Bin"},{width:"100%"});var A=this.$cX("div",{id:z+"NameSegmentContainer",className:"CanvasXpressBinNameContainer"});var y=this.$cX("table",{id:z+"NameSegment",className:"CanvasXpressBinTable"},{width:"100%"});var v=this.$cX("tbody");var G=this.$cX("th");var F=this.$cX("th",{innerHTML:"Name"});var D=this.$cX("th",{innerHTML:"Max"});var o=this.$cX("tr");o.appendChild(G);o.appendChild(F);o.appendChild(D);v.appendChild(o);for(var H=0;H<B;H++){var G=this.$cX("td",{innerHTML:H+1},{width:(this.configuratorWidth*0.1)+"px"});var F=this.$cX("td");var D=this.$cX("td");var e=this.$cX("input",{id:z+"Name"+H,className:"CanvasXpressBin",type:"text",value:"Bin-"+(H+1)},{width:(this.configuratorWidth*0.65)+"px"});var h=this.$cX("input",{id:z+"Value"+H,className:"CanvasXpressBin",type:"text",value:this.formatNumber(f[0]+((H+1)*E),w)},{width:(this.configuratorWidth*0.25)+"px"});var o=this.$cX("tr");D.appendChild(h);F.appendChild(e);o.appendChild(G);o.appendChild(F);o.appendChild(D);v.appendChild(o)}y.appendChild(v);A.appendChild(y);var L=this.$cX("input",{id:z+"Apply",value:"Apply",type:"button"},{cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:"50%"});var K=this.$cX("input",{id:z+"Button",value:"Done",type:"button"},{cssFloat:"left",borderRadius:"5px",top:"4px",position:"relative",width:"50%"});var u=this.$("south-wrapper-"+this.target);if(u){J.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Edit Name"}));J.appendChild(this.$cX("br"));J.appendChild(C);J.appendChild(this.$cX("br"));J.appendChild(this.$cX("br"));J.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Edit Bin Name and Range"}));J.appendChild(this.$cX("br"));J.appendChild(A);J.appendChild(L);J.appendChild(K);J.appendChild(this.$cX("br"));I.appendChild(g);I.appendChild(J);u.appendChild(I);this.addRemoveBinListeners("addEvtListener",z)}};this.addRemoveBinListeners=function(b,d){var c=d?[d]:this.getKeys(this.binConfigurations);for(var a=0;a<c.length;a++){this.addRemoveEvtListener(b,this.$(c[a]),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(b,this.$(c[a]+"CloseImage"),"click",this.closeBinConfigurator,false);this.addRemoveEvtListener(b,this.$(c[a]+"Apply"),"click",this.applyBinConfigurator,false);this.addRemoveEvtListener(b,this.$(c[a]+"Button"),"click",this.doneBinConfigurator,false);if(b=="removeEvtListener"&&this.binConfigurations[c[a]]&&!this.binConfigurations[c[a]]["apply"]){delete (this.binConfigurations[c[a]])}}};this.closeBinConfigurator=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);var f=b.id.replace("CloseImage","");var d=a.$(f);if(d){a.addRemoveBinListeners("removeEvtListener",f);d.parentNode.removeChild(d)}return false}}(this);this.validateBinning=function(a){var e=false;var h=this.$(a+"Name0").value;var m=this.$(a+"Value0").value;for(var k=1;k<this.binConfigurations[a]["n"];k++){var p=this.$(a+"Name"+k).value;var b=this.$(a+"Value"+k).value;if(h==""||h==null){e="Value for Bin "+k+" CANNOT be null";break}else{if(p==""||p==null){e="Value for Bin "+(k+1)+" CANNOT be null";break}else{if(m==""||m==null){e="Value for "+h+" ("+m+") CANNOT be null";break}else{if(b==""||b==null){e="Value for "+p+" ("+b+") CANNOT be null";break}else{if(isNaN(m)){e="Value for "+h+" ("+m+") is NOT a number";break}else{if(isNaN(b)){e="Value for "+p+" ("+b+") is NOT a number";break}else{if(m>b){e="Value for "+h+" ("+m+")CANNOT be greater that value for "+p+" ("+b+")";break}h=p;m=b}}}}}}}if(e){alert(e);return false}else{for(var k=0;k<this.binConfigurations[a]["n"];k++){var c=this.$(a+"Name"+k).value;var o=this.$(a+"Value"+k).value;this.binConfigurations[a]["bins"][k]={name:c,value:o}}var d=this.binConfigurations[a]["name"];var g=this.binConfigurations[a]["vi"];this.data.x[d]=[];for(var k=0;k<this.data.y.data[g].length;k++){var o=this.data.y.data[g][k];if(!isNaN(o)&&o!=""&&o!=null){for(var f=0;f<this.binConfigurations[a]["n"];f++){if(o<=this.binConfigurations[a]["bins"][f].value){this.data.x[d][k]=this.binConfigurations[a]["bins"][f].name;break}}}else{this.data.x[d][k]=""}}if(this.isGroupedData){this.ungroupSamples(true)}this.updateData(this.data);this.groupSamples([d]);this.sortSamplesByCategory([d]);this.binConfigurations[a]["apply"]=true;return true}};this.applyBinConfigurator=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);var d=b.id.replace("Apply","");a.validateBinning(d)}}(this);this.doneBinConfigurator=function(a){return function(d){if(!d){d=window.event}var b=a.getTargetEvent(d);var g=b.id.replace("Button","");var c=a.validateBinning(g);var f=a.$(g);if(f&&c){a.addRemoveBinListeners("removeEvtListener",g);f.parentNode.removeChild(f)}return false}}(this)};CanvasXpress.prototype.initDataExplorer=function(){this.addDataExplorer=function(f){var a=this.target+"-cX-DataExplorer";var j=this.$(a);if(j){return}var g=this.$cX("div",{id:this.target+"-cX-DataExplorer",className:"CanvasXpressBin draggable"},{left:"20px",top:"-"+(this.height-20)+"px",display:"block"});var m=this.$cX("img",{id:this.target+"-cX-DataExplorerCloseImage",className:"CanvasXpressBin",src:CanvasXpress.images.cancel1,alt:"Close Data Explorer",title:"Close Data Explorer"});var h=this.$cX("div",{id:this.target+"-cX-DataExplorerContainer",className:"CanvasXpressBinContainer"});var k=this.$("south-wrapper-"+this.target);if(k){g.appendChild(m);var o=this.loadDataExplorerTopPanel();h.appendChild(o);var i=this.$cX("img",{id:this.target+"-cX-DataExplorerMinimizeImage1",className:"CanvasXpressBin",src:CanvasXpress.images.collapseFolder,srt:CanvasXpress.images.expandFolder,alt:"Collapse Variables and Sample Metadata",title:"Collapse Variables and Sample Metadata"});h.appendChild(i);var n=this.loadDataExplorerMiddlePanel();h.appendChild(n);h.appendChild(this.$cX("br"));h.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"201px"}));var b=this.$cX("img",{id:this.target+"-cX-DataExplorerMinimizeImage2",className:"CanvasXpressBin",src:CanvasXpress.images.collapseFolder,srt:CanvasXpress.images.expandFolder,alt:"Collapse Samples and Variable Metadata",title:"Collapse Samples and Variable Metadata"});h.appendChild(b);var l=this.loadDataExplorerBottomPanel();h.appendChild(l);g.appendChild(h);k.appendChild(g);this.addRemoveDataExplorerListeners("addEvtListener")}};this.loadDataExplorerTopPanel=function(){var g=this.loadFormatDataExplorerDiv();var c=this.loadLayoutDataExplorerDiv();var a=this.loadMetadataDataExplorerDiv();var h=this.loadPropertiesDataExplorerDiv();var f=this.loadOrientationDataExplorerDiv();var b=this.loadGraphTypesDataExplorerDiv();var e=this.loadAxesDataExplorerDiv();var d=this.$cX("div",{className:"CanvasXpressDataExplorerPanel"});d.appendChild(g);d.appendChild(c);d.appendChild(a);d.appendChild(this.$cX("br"));d.appendChild(h);d.appendChild(f);d.appendChild(this.$cX("br"));d.appendChild(b);d.appendChild(e);d.appendChild(this.$cX("br"));d.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"201px"}));return d};this.loadDataExplorerMiddlePanel=function(){var b=this.loadVariablesDataExplorerDiv();var a=this.loadAnnotationsDataExplorerDiv();var c=this.$cX("div",{className:"CanvasXpressDataExplorerPanel"});c.appendChild(this.$cX("br"));c.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Variables / Data Series"}));c.appendChild(this.$cX("img",{id:this.target+"-cX-DataExplorerSortVariables",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.sortAsciiAsc,asr:CanvasXpress.images.sortAsciiDesc,params:["sortDataExplorer"],alt:"Sort Variables",title:"Sort Variables"},{border:"none",padding:0}));c.appendChild(this.$cX("br"));c.appendChild(b);c.appendChild(this.$cX("br"));c.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Sample Metadata"}));c.appendChild(this.$cX("img",{id:this.target+"-cX-DataExplorerSortAnnotations",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.sortAsciiAsc,asr:CanvasXpress.images.sortAsciiDesc,params:["sortDataExplorer"],alt:"Sort Sample Metadata",title:"Sort Sample Metadata"},{border:"none",padding:0}));c.appendChild(this.$cX("br"));c.appendChild(a);return c};this.loadDataExplorerBottomPanel=function(){var a=this.loadSamplesDataExplorerDiv();var c=this.loadDescriptionsDataExplorerDiv();var b=this.$cX("div",{className:"CanvasXpressDataExplorerPanel"});b.appendChild(this.$cX("br"));b.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Samples"}));b.appendChild(this.$cX("img",{id:this.target+"-cX-DataExplorerSortSamples",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.sortAsciiAsc,asr:CanvasXpress.images.sortAsciiDesc,params:["sortDataExplorer"],alt:"Sort Samples",title:"Sort Samples"},{border:"none",padding:0}));b.appendChild(this.$cX("br"));b.appendChild(a);b.appendChild(this.$cX("br"));b.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Variable Metadata"}));b.appendChild(this.$cX("img",{id:this.target+"-cX-DataExplorerSortDescriptions",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.sortAsciiAsc,asr:CanvasXpress.images.sortAsciiDesc,params:["sortDataExplorer"],alt:"Sort Variable Metadata",title:"Sort Variable Metadata"},{border:"none",padding:0}));b.appendChild(this.$cX("br"));b.appendChild(c);return b};this.loadFormatDataExplorerDiv=function(){var b=this.$cX("div",{id:this.target+"-cX-DataExplorerFormat",className:"CanvasXpressDataExplorer"},{width:"47px",height:"46px",textAlign:"center",cssFloat:"left"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerTranspose",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.transposeData,params:["transpose"],alt:"Transpose data",title:"Transpose data"});b.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Format",title:"Click in icons to reformat data",alt:"Click in icons to reformat data"},{width:"47px",cursor:"pointer"}));b.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"53px"}));b.appendChild(a);return b};this.loadLayoutDataExplorerDiv=function(){var c=this.$cX("div",{id:this.target+"-cX-DataExplorerLayout",className:"CanvasXpressDataExplorer"},{width:"60px",height:"46px",textAlign:"center",cssFloat:"left"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerGroupSamples",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.groupSamples,params:["groupSamples"],alt:"Group Samples",title:"Group Samples"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerSegregate",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.segregate,params:["segregate"],alt:"Segregate Data",title:"Segregate Data"});c.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Layout",title:"Drag sample metadata to change layout",alt:"Drag sample metadata to change layout"},{width:"60px",cursor:"pointer"}));c.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"66px"}));c.appendChild(a);c.appendChild(b);return c};this.loadMetadataDataExplorerDiv=function(){var a=this.$cX("div",{id:this.target+"-cX-DataExplorerMetadata",className:"CanvasXpressDataExplorer"},{width:"45px",height:"46px",textAlign:"center",cssFloat:"left"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerDOE",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.doe,params:["createDOE"],alt:"Explore Meta Data",title:"Explore Meta Data"});a.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"DOE",title:"Click in icon to explore meta data",alt:"Click in icon to explore meta data"},{width:"45px",cursor:"pointer"}));a.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"51px"}));a.appendChild(b);return a};this.loadPropertiesDataExplorerDiv=function(){var g=this.$cX("div",{id:this.target+"-cX-DataExplorerProperties",className:"CanvasXpressDataExplorer"},{width:"90px",height:"83px",textAlign:"center",cssFloat:"left"});var d=this.$cX("img",{id:this.target+"-cX-DataExplorerColor",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.colors,params:["colorBy"],alt:"Color Data",title:"Color Data"});var f=this.$cX("img",{id:this.target+"-cX-DataExplorerShape",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.shapes,params:["shapeBy"],alt:"Shape Data",title:"Shape Data"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerSize",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.sizes,params:["sizeBy"],alt:"Size Data",title:"Size Data"});var c=this.$cX("img",{id:this.target+"-cX-DataExplorerPattern",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.patterns,params:["patternBy"],alt:"Pattern Data",title:"Pattern Data"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerConnect",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.connects,params:["connectBy"],alt:"Connect Data",title:"Connect Data"});var e=this.$cX("img",{id:this.target+"-cX-DataExplorerTreemapBy",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.treemap,params:["treemapBy"],alt:"Treemap Data",title:"Treemap Data"});g.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Properties",title:"Drag metadata to change propeties",alt:"Drag metadata to change properties"},{width:"90px",cursor:"pointer"}));g.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"96px"}));g.appendChild(d);g.appendChild(f);g.appendChild(b);g.appendChild(c);g.appendChild(a);g.appendChild(e);return g};this.loadOrientationDataExplorerDiv=function(){var c=this.$cX("div",{id:this.target+"-cX-DataExplorerOrientation",className:"CanvasXpressDataExplorer"},{width:"77px",height:"46px",textAlign:"center",cssFloat:"left"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerVertical",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.graphOrientationVertical,params:["changeAttribute",["graphOrientation","vertical"]],alt:"Vertical Graph",title:"Vertical Graph"});var d=this.$cX("img",{id:this.target+"-cX-DataExplorerHorizontal",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.graphOrientationHorizontal,params:["changeAttribute",["graphOrientation","horizontal"]],alt:"Horizontal Graph",title:"Horizontal Graph"});var b=this.loadFileUploadDataExplorerDiv();c.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Orientation",title:"Click icon to change graph orientation",alt:"Click icon to change graph orientation"},{width:"77px",cursor:"pointer"}));c.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"83px"}));c.appendChild(a);c.appendChild(d);c.appendChild(b);return c};this.loadFileUploadDataExplorerDiv=function(){var e=this.$cX("div",{id:this.target+"-cX-DataExplorerFileUploadDiv"});var a=this.$cX("label",{htmlFor:this.target+"-cX-DataExplorerFileUpload"},{maxWidth:"inherit"});var b=this.$cX("span",{innerHTML:"Upload",className:"CanvasXpressDataExplorer",title:"Click to upload a new file",alt:"Click to upload a new file",params:["fileUpload"]});var c=this.$cX("input",{id:this.target+"-cX-DataExplorerFileUpload",type:"file"},{display:"none"});a.appendChild(b);e.appendChild(a);e.appendChild(c);return e};this.loadGraphTypesDataExplorerDiv=function(){var j=this.$cX("div",{id:this.target+"-cX-DataExplorerGraphs",className:"CanvasXpressDataExplorer"},{width:"120px",height:"144px",textAlign:"center",cssFloat:"left",marginBottom:"15px"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerArea",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.area,params:["changeAttribute",["graphType","Area"]],alt:"Area",title:"Area"});var k=this.$cX("img",{id:this.target+"-cX-DataExplorerBar",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.bar,params:["changeAttribute",["graphType","Bar"]],alt:"Bar",title:"Bar"});var l=this.$cX("img",{id:this.target+"-cX-DataExplorerBoxplot",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.boxplot,params:["changeAttribute",["graphType","Boxplot"]],alt:"Boxplot",title:"Boxplot"});var p=this.$cX("img",{id:this.target+"-cX-DataExplorerCorrelation",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.correlation,params:["changeAttribute",["graphType","Correlation"]],alt:"Correlation",title:"Correlation"});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerCircular",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.circular,params:["changeAttribute",["graphType","Circular"]],alt:"Circular",title:"Circular"});var i=this.$cX("img",{id:this.target+"-cX-DataExplorerHeatmap",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.heatmap,params:["changeAttribute",["graphType","Heatmap"]],alt:"Heatmap",title:"Heatmap"});var h=this.$cX("img",{id:this.target+"-cX-DataExplorerDotplot",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.dotplot,params:["changeAttribute",["graphType","Dotplot"]],alt:"Dotplot",title:"Dotplot"});var o=this.$cX("img",{id:this.target+"-cX-DataExplorerLine",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.line,params:["changeAttribute",["graphType","Line"]],alt:"Line",title:"Line"});var g=this.$cX("img",{id:this.target+"-cX-DataExplorerPie",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.pie,params:["changeAttribute",["graphType","Pie"]],alt:"Pie Chart",title:"Pie Chart"});var f=this.$cX("img",{id:this.target+"-cX-DataExplorerScatter2D",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.scatter2d,params:["changeAttribute",["graphType","Scatter2D"]],alt:"Scatter 2D",title:"Scatter 2D"});var d=this.$cX("img",{id:this.target+"-cX-DataExplorerScatterBubble2D",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.scatterBubble2d,params:["changeAttribute",["graphType","ScatterBubble2D"]],alt:"Scatter Bubble 2D",title:"Scatter Bubble 2D"});var e=this.$cX("img",{id:this.target+"-cX-DataExplorerScatter3D",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.scatter3d,params:["changeAttribute",["graphType","Scatter3D"]],alt:"Scatter 3D",title:"Scatter 3D"});var q=this.$cX("img",{id:this.target+"-cX-DataExplorerStacked",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.stacked,params:["changeAttribute",["graphType","Stacked"]],alt:"Stacked",title:"Stacked"});var m=this.$cX("img",{id:this.target+"-cX-DataExplorerStackedPercent",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.stackedPercent,params:["changeAttribute",["graphType","StackedPercent"]],alt:"Stacked Percent",title:"Stacked Percent"});var c=this.$cX("img",{id:this.target+"-cX-DataExplorerTagCloud",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.tagCloud,params:["changeAttribute",["graphType","TagCloud"]],alt:"Tag Cloud",title:"Tag Cloud"});var n=this.$cX("img",{id:this.target+"-cX-DataExplorerTreemap",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.treemap,params:["changeAttribute",["graphType","Treemap"]],alt:"Treemap",title:"Treemap"});j.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Graph Types",title:"Click in icons to change graph type",alt:"Click in icons to change graph type"},{width:"120px",cursor:"pointer"}));j.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"126px"}));j.appendChild(b);j.appendChild(k);j.appendChild(l);j.appendChild(a);j.appendChild(p);j.appendChild(i);j.appendChild(h);j.appendChild(o);j.appendChild(g);j.appendChild(f);j.appendChild(d);j.appendChild(e);j.appendChild(q);j.appendChild(m);j.appendChild(c);j.appendChild(n);return j};this.loadAxesDataExplorerDiv=function(){var f=this.$cX("div",{id:this.target+"-cX-DataExplorerAxes",className:"CanvasXpressDataExplorer"},{width:"46px",height:"144px",textAlign:"center",cssFloat:"left",marginBottom:"15px"});var b=this.$cX("img",{id:this.target+"-cX-DataExplorerXAxis",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.xAxis,params:["addToAxis",["xAxis"]],alt:"X-Axis",title:"X-Axis"});var e=this.$cX("img",{id:this.target+"-cX-DataExplorerLinLogXAxis",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.linLogV,params:["linLog",["xAxis"]],alt:"X-Axis Lin / Log",title:"X-Axis Lin / Log"},{width:"10px",height:"24px",border:"none",padding:0});var h=this.$cX("img",{id:this.target+"-cX-DataExplorerYAxis",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.yAxis,params:["addToAxis",["yAxis"]],alt:"Y-Axis",title:"Y-Axis"});var d=this.$cX("img",{id:this.target+"-cX-DataExplorerLinLogYAxis",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.linLogV,params:["linLog",["yAxis"]],alt:"Y-Axis Lin / Log",title:"Y-Axis Lin / Log"},{width:"10px",height:"24px",border:"none",padding:0});var g=this.$cX("img",{id:this.target+"-cX-DataExplorerZAxis",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.zAxis,params:["addToAxis",["zAxis"]],alt:"Z-Axis",title:"Z-Axis"});var c=this.$cX("img",{id:this.target+"-cX-DataExplorerLinLogZAxis",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.linLogV,params:["linLog",["zAxis"]],alt:"Z-Axis Lin / Log",title:"Z-Axis Lin / Log"},{width:"10px",height:"24px",border:"none",padding:0});var a=this.$cX("img",{id:this.target+"-cX-DataExplorerMotion",className:"CanvasXpressDataExplorer",src:CanvasXpress.images.motion,params:["motion"],alt:"Motion",title:"Motion"});f.appendChild(this.$cX("span",{className:"CanvasXpressBin",innerHTML:"Axes",title:"Drag Samples to assign to Axis",alt:"Drag Samples to assign to Axis"},{width:"46px",cursor:"pointer"}));f.appendChild(this.$cX("hr",{className:"CanvasXpressDataExplorer"},{width:"52px"}));f.appendChild(b);f.appendChild(e);f.appendChild(h);f.appendChild(d);f.appendChild(g);f.appendChild(c);f.appendChild(a);return f};this.loadVariablesDataExplorerDiv=function(b){if(!b){b=this.$cX("div",{id:this.target+"-cX-DataExplorerVariables",className:"CanvasXpressDataExplorer",type:"vars"},{width:"180px",height:"58px",overflowY:"auto"})}for(var c=0;c<this.data.y.vars.length;c++){var a=this.$cX("img",{src:CanvasXpress.images.canvasXpress,className:"CanvasXpressDataExplorerMask"});var d=this.$cX("span",{id:this.target+"-cX-DataExplorerVariables-"+this.data.y.vars[c],innerHTML:this.data.y.vars[c],className:"CanvasXpressDataExplorerNumeric draggable",type:"vars",numeric:true,params:["switchVarToAnnotation"],draggable:true,spellcheck:false});d.appendChild(a);b.appendChild(d)}return b};this.loadSamplesDataExplorerDiv=function(c){if(!c){c=this.$cX("div",{id:this.target+"-cX-DataExplorerSamples",className:"CanvasXpressDataExplorer",type:"smps"},{width:"180px",height:"58px",overflowY:"auto"})}for(var b=0;b<this.data.y.smps.length;b++){var a=this.$cX("img",{src:CanvasXpress.images.canvasXpress,className:"CanvasXpressDataExplorerMask"});var d=this.$cX("span",{id:this.target+"-cX-DataExplorerSamples-"+this.data.y.smps[b],innerHTML:this.data.y.smps[b],className:"CanvasXpressDataExplorerNumeric draggable",type:"smps",numeric:true,params:["switchSmpToAnnotation"],draggable:true,spellcheck:false});d.appendChild(a);c.appendChild(d)}return c};this.loadAnnotationsDataExplorerDiv=function(b){var d=this.meta.data.x;if(!b){b=this.$cX("div",{id:this.target+"-cX-DataExplorerAnnotations",className:"CanvasXpressDataExplorer",type:"x"},{width:"180px",height:"58px",overflowY:"auto"})}if(this.data.x){for(var e in this.data.x){var c=d[e].unique?"CanvasXpressDataExplorerUnique draggable":d[e].type=="String"?"CanvasXpressDataExplorerString draggable":"CanvasXpressDataExplorerNumeric draggable";var a=this.$cX("img",{src:CanvasXpress.images.canvasXpress,className:"CanvasXpressDataExplorerMask"});var f=this.$cX("span",{id:this.target+"-cX-DataExplorerAnnotations-"+e,innerHTML:e,className:c,type:"x",unique:d[e].unique,numeric:d[e].type=="String"?false:true,params:["switchAnnotationToVar"],draggable:true,spellcheck:false});if(d[e].unique){f.alt="Double-click to convert to Sample Id";f.title="Double-click to convert to Sample Id"}f.appendChild(a);b.appendChild(f)}}return b};this.loadDescriptionsDataExplorerDiv=function(f){var c=this.meta.data.z;if(!f){f=this.$cX("div",{id:this.target+"-cX-DataExplorerDescriptions",className:"CanvasXpressDataExplorer",type:"z"},{width:"180px",height:"58px",overflowY:"auto"})}if(this.data.z){for(var d in this.data.z){var b=c[d].unique?"CanvasXpressDataExplorerUnique draggable":c[d].type=="String"?"CanvasXpressDataExplorerString draggable":"CanvasXpressDataExplorerNumeric draggable";var a=this.$cX("img",{src:CanvasXpress.images.canvasXpress,className:"CanvasXpressDataExplorerMask"});var e=this.$cX("span",{id:this.target+"-cX-DataExplorerDescriptions-"+d,innerHTML:d,className:b,type:"z",unique:c[d].unique,numeric:c[d].type=="String"?false:true,params:["switchAnnotationToSmp"],draggable:true,spellcheck:false});if(c[d].unique){e.alt="Double-click to convert to Variable Id";e.title="Double-click to convert to Variable Id"}e.appendChild(a);f.appendChild(e)}}return f};this.addRemoveDataExplorerListeners=function(q){var e;var F=this.$(this.target+"-cX-DataExplorerFormat");var w=this.$(this.target+"-cX-DataExplorerMetadata");var G=this.$(this.target+"-cX-DataExplorerOrientation");var E=this.$(this.target+"-cX-DataExplorerGraphs");var H=this.$(this.target+"-cX-DataExplorerAxes");var A=this.$(this.target+"-cX-DataExplorerLayout");var u=this.$(this.target+"-cX-DataExplorerProperties");var o=this.$(this.target+"-cX-DataExplorerVariables");var B=this.$(this.target+"-cX-DataExplorerSortVariables");var r=this.$(this.target+"-cX-DataExplorerSamples");var y=this.$(this.target+"-cX-DataExplorerSortSamples");var n=this.$(this.target+"-cX-DataExplorerAnnotations");var k=this.$(this.target+"-cX-DataExplorerSortAnnotations");var h=this.$(this.target+"-cX-DataExplorerDescriptions");var c=this.$(this.target+"-cX-DataExplorerSortDescriptions");this.addRemoveEvtListener(q,this.$(this.target+"-cX-DataExplorerMinimizeImage1"),"click",this.collapseExpandDataExplorerPanel,false);this.addRemoveEvtListener(q,this.$(this.target+"-cX-DataExplorerMinimizeImage2"),"click",this.collapseExpandDataExplorerPanel,false);this.addRemoveEvtListener(q,this.$(this.target+"-cX-DataExplorer"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(q,this.$(this.target+"-cX-DataExplorerCloseImage"),"click",this.closeDataExplorer,false);e=[F,w,G,E];for(var D=0;D<e.length;D++){if(e[D]){this.addRemoveEvtListener(q,e[D],"click",this.dataExplorerClick,false);if(e[D].childNodes.length==5&&e[D].childNodes[4].id==this.target+"-cX-DataExplorerFileUploadDiv"){this[q](e[D].childNodes[4].childNodes[1],"change",this.loadFile,false)}}}e=[H,A,u,o,r,n,h];for(var D=0;D<e.length;D++){if(e[D]){this.addRemoveEvtListener(q,e[D],"drop",this.dropDataExplorer,false);this.addRemoveEvtListener(q,e[D],"dragover",this.dragOverDataExplorer,false);this.addRemoveEvtListener(q,e[D],"dragenter",this.dragEnterDataExplorer,false);this.addRemoveEvtListener(q,e[D],"dragleave",this.dragLeaveDataExplorer,false);for(var C=0;C<e[D].childNodes.length;C++){var b=e[D].childNodes[C];if(b.tagName=="SPAN"){this.addRemoveEvtListener(q,b,"dragstart",this.dragStartDataExplorer,false);this.addRemoveEvtListener(q,b,"dragend",this.dragEndDataExplorer,false)}}}}e=[n,h];for(var D=0;D<e.length;D++){if(e[D]){this.addRemoveEvtListener(q,e[D],"dblclick",this.dataExplorerDblclick,false)}}e=[A,u];for(var D=0;D<e.length;D++){if(e[D]){this.addRemoveEvtListener(q,e[D],"click",this.dataExplorerClickReset,false)}}e=[B,y,k,c];for(var D=0;D<e.length;D++){if(e[D]){this.addRemoveEvtListener(q,e[D],"click",this.dataExplorerClickSort,false)}}e=[H];for(var D=0;D<e.length;D++){if(e[D]){for(var C=0;C<e[D].childNodes.length;C++){var b=e[D].childNodes[C];if(b.tagName=="IMG"){if(b.id.match(/LinLog/)){this.addRemoveEvtListener(q,b,"click",this.dataExplorerClickLinLog,false)}else{this.addRemoveEvtListener(q,b,"click",this.dataExplorerClickReset,false)}}}}}};this.collapseExpandDataExplorerPanel=function(a){return function(f){if(!f){f=window.event}var b=a.getTargetEvent(f);var d=b.nextElementSibling;var c=b.title;if(c.match("Collapse")){b.title=c.replace("Collapse","Expand");d.style.display="none"}else{b.title=c.replace("Expand","Collapse");d.style.display="block"}b.alt=b.title;var g=b.src;b.src=b.srt;b.srt=g;return false}}(this);this.dragStartDataExplorer=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c).parentNode;b.style.opacity="0.3";c.dataTransfer.setDragImage(b,0,0);c.dataTransfer.setData("text",b.id);return false}}(this);this.dragEnterDataExplorer=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(b.parentNode.tagName=="SPAN"){b=b.parentNode}if(b.tagName=="SPAN"&&b.parentNode.lastChild&&b.parentNode.lastChild.tagName!="IMG"){b.parentNode.className="CanvasXpressDataExplorerActive"}else{if(b.tagName=="SPAN"&&b.parentNode.lastChild&&b.parentNode.lastChild.tagName=="IMG"){b.parentNode.className="CanvasXpressDataExplorer"}else{if((b.tagName=="DIV"&&b.lastChild&&b.lastChild.tagName!="IMG")||b.tagName=="IMG"){b.className="CanvasXpressDataExplorerActive"}}}return false}}(this);this.dragOverDataExplorer=function(a){return function(c){a.cancelEvent(c);var b=a.getTargetEvent(c);if(b.parentNode.tagName=="SPAN"){b=b.parentNode}if(b.tagName=="SPAN"&&b.parentNode.lastChild&&b.parentNode.lastChild.tagName!="IMG"){b.parentNode.className="CanvasXpressDataExplorerActive"}else{if(b.tagName=="DIV"&&b.lastChild&&b.lastChild.tagName!="IMG"){b.className="CanvasXpressDataExplorerActive"}}return false}}(this);this.dragLeaveDataExplorer=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(b.parentNode.tagName=="SPAN"){b=b.parentNode}if(b.tagName=="DIV"||b.tagName=="IMG"){b.className="CanvasXpressDataExplorer"}return false}}(this);this.dragEndDataExplorer=function(a){return function(g){if(!g){g=window.event}var c=a.getTargetEvent(g);if(c.parentNode.tagName=="SPAN"){c.blur();c=c.parentNode;c.focus()}c.style.opacity="1.0";var d=c.parentNode;if(d.tagName=="SPAN"){d=d.parentNode}d.className="CanvasXpressDataExplorer";var f=d.type;var b=c.type;if(f==b){return false}return false}}(this);this.dropDataExplorer=function(a){return function(s){a.cancelEvent(s);var p,l,c,m;var t=s.dataTransfer.getData("text");var g=a.$(t);if(g){var w=g.innerText;var v=g.type;var h=g.numeric;var u=g.params[0];if(s.target.tagName=="IMG"){s.target.className="CanvasXpressDataExplorer";p=a.getTargetEvent(s);m=p.title.split(" : ")[0];l=p.params[0];switch(l){case"treemapBy":if(v=="x"){var r=a.treemapBy;if(a.isInArray(w,r)){var b=[];for(var o=0;o<r.length;o++){if(r[o]!=w){b.push(r[o])}}r=b}else{r.push(w)}if(r.length>0){p.title=m+" : "+a.treemapBy.join(", ");p.alt=p.title}else{p.title=m;p.alt=p.title}}else{alert("Ooops! Only Sample factors")}a.draw();return false;case"groupSamples":if(v=="x"){var f=a.groupingFactors;if(a.isInArray(w,f)){var b=[];for(var o=0;o<f.length;o++){if(f[o]!=w){b.push(f[o])}}f=b}else{f.push(w)}if(f.length>0){a.groupSamples(f);p.title=m+" : "+a.groupingFactors.join(", ");p.alt=p.title}else{a.ungroupSamples();p.title=m;p.alt=p.title}}else{alert("Ooops! Only Sample factors")}return false;case"segregate":if(v=="x"){var q=a.segregateSamplesBy;if(a.isInArray(w,q)){var b=[];for(var o=0;o<q.length;o++){if(q[o]!=w){b.push(q[o])}}if(b.length>0){a.segregateSamplesBy=b;a.segregate("Samples",b)}else{a.segregateSamplesBy=[];a.desegregate("Samples")}}else{if(a.segregateSamplesBy.length+a.segregateVariablesBy.length<2){q.push(w);a.segregate("Samples",q)}else{alert("Ooops! Only 2 segregation factors")}}}else{if(v=="z"){var q=a.segregateVariablesBy;if(a.isInArray(w,q)){var b=[];for(var o=0;o<q.length;o++){if(q[o]!=w){b.push(q[o])}}if(b.length>0){a.segregateVariablesBy=b;a.segregate("Variables",b)}else{a.segregateVariablesBy=[];a.desegregate("Variables")}}else{if(a.segregateSamplesBy.length+a.segregateVariablesBy.length<2){q.push(w);a.segregate("Variables",q)}else{alert("Ooops! Only 2 segregation factors")}}}else{alert("Ooops! Only Sample or Variable factors");return false}}var b=a.segregateVariablesBy;b=b.concat(a.segregateSamplesBy);p.title=b.length>0?m+" : "+b.join(", "):m;p.alt=p.title;return false;case"addToAxis":var n=p.params[1][0];if(v=="smps"){if(s.shiftKey){a.changeSampleInAxis(w,n)}else{a.changeSampleInAxis(w,n,true)}p.title=m+" : "+a[n].join(", ");p.alt=p.title}else{alert("Ooops! Only samples allowed")}return false;case"motion":if(v=="smps"){c=p.type;g.type=c;a[u](w);g.params[0]="switchAnnotationToSmp";var j=a.$(a.target+"-cX-DataExplorerDescriptions");if(j){j.appendChild(g)}}else{if(v=="vars"){g.type=c;a[u](w);g.params[0]="switchAnnotationToVar";var k=a.$(a.target+"-cX-DataExplorerAnnotations");if(k){k.appendChild(g)}}}a.changeAttribute("motionBy",w);p.title=m+" : "+w;p.alt=p.title;return false;case"linLog":return false;default:a.changeAttribute(l,w);p.title=m+" : "+w;p.alt=p.title;return false}}else{if(s.target.tagName=="SPAN"&&s.target.parentNode.lastChild&&s.target.parentNode.lastChild.tagName!="IMG"){p=s.target.parentNode}else{if(s.target.tagName=="DIV"){p=s.target}}c=p.type;if(v==c){return false}else{if(v=="smps"&&c=="z"){g.type=c;a[u](w);g.params[0]="switchAnnotationToSmp"}else{if(v=="z"&&c=="smps"){g.type=c;a[u](w);g.params[0]="switchSmpToAnnotation"}else{if(v=="vars"&&c=="x"){g.type=c;a[u](w);g.params[0]="switchAnnotationToVar"}else{if(v=="x"&&c=="vars"){g.type=c;a[u](w);g.params[0]="switchVarToAnnotation"}else{alert("Ooops! Only changes between data and ortogonal numeric metadata");return false}}}}}p.appendChild(g)}}return false}}(this);this.dataExplorerClick=function(a){return function(d){if(!d){d=window.event}var c=a.getTargetEvent(d);var b=c.params;if(c.tagName.match(/input/i)){return true}else{if(b[1]){a[b[0]].apply(a,b[1])}else{if(b[0]=="createDOE"&&a.isDOE){a.removeDOE()}else{if(b[0]=="fileUpload"){return false}else{a[b[0]]()}}}}return false}}(this);this.dataExplorerDblclick=function(a){return function(f){if(!f){f=window.event}var c=a.getTargetEvent(f).parentNode;var d=c.type;var b=c.innerText;if(d=="z"){if(a.unique(a.data.z[b])){a.switchVarAnnotationToId(b);a.resetDataExplorer()}}else{if(a.unique(a.data.x[b])){a.switchSmpAnnotationToId(b);a.resetDataExplorer()}}return false}}(this);this.dataExplorerClickSort=function(a){return function(f){if(!f){f=window.event}var b=a.getTargetEvent(f);var j=b.id.replace("-cX-DataExplorerSort","-cX-DataExplorer");var d=a.$(j);if(d){var h=d.childNodes.length-1;for(var c=h;c>0;c--){d.insertBefore(d.lastChild,d.childNodes[h-c])}var g=b.src;b.src=b.asr;b.asr=g}return false}}(this);this.dataExplorerClickLinLog=function(a){return function(f){if(!f){f=window.event}var c=a.getTargetEvent(f);var b=c.params;if(c&&b){var d=b[1][0]+"Transform";if(a[d]){a.changeAttribute(d,false)}else{a.changeAttribute(d,a.transformBase==2?"log2":"log10")}}return false}}(this);this.dataExplorerClickReset=function(a){return function(j){if(!j){j=window.event}var c=a.getTargetEvent(j);var f=c.title.split(" : ")[0];var b=c.params;c.title=f;c.alt=f;switch(b[0]){case"treemapBy":if(a.treemapBy.length>0){a.treemapBy=[]}a.draw();return false;case"groupSamples":if(a.groupingFactors.length>0){a.ungroupSamples()}return false;case"segregate":for(var g=0;g<a.segregateSamplesBy.length;g++){a.showSampleSegregation(a.segregateSamplesBy[g])}for(var g=0;g<a.segregateVariablesBy.length;g++){a.showVariableSegregation(a.segregateVariablesBy[g])}return false;case"addToAxis":var h=c.params[1][0];var d=a[h];a.changeSampleInAxis(d[0],h,true);c.title=f+" : "+a[h].join(", ");c.alt=c.title;return false;case"motion":a.changeAttribute("motionBy",false);return false;default:if(a[b[0]]){a.changeAttribute(b[0],false)}return false}}}(this);this.closeDataExplorer=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);var f=b.id.replace("CloseImage","");var d=a.$(f);if(d){a.addRemoveDataExplorerListeners("removeEvtListener");d.parentNode.removeChild(d)}return false}}(this);this.resetDataExplorer=function(){var j=this.$(this.target+"-cX-DataExplorerContainer");var b=this.$(this.target+"-cX-DataExplorerVariables");var g=this.$(this.target+"-cX-DataExplorerSamples");var a=this.$(this.target+"-cX-DataExplorerAnnotations");var h=this.$(this.target+"-cX-DataExplorerDescriptions");this.addRemoveDataExplorerListeners("removeEvtListener");var e=[b,g,a,h];for(var d=0;d<e.length;d++){var f=e[d];while(f.childNodes.length>0){f.removeChild(f.childNodes[0])}}this.loadVariablesDataExplorerDiv(b);this.loadSamplesDataExplorerDiv(g);this.loadAnnotationsDataExplorerDiv(a);this.loadDescriptionsDataExplorerDiv(h);this.addRemoveDataExplorerListeners("addEvtListener")}};CanvasXpress.prototype.initDataFilter=function(){this.heigthOffsetDataFilter=function(){return this.graphType=="Genome"?66:95};this.addDataFilterDiv=function(){if(this.$(this.target+"-cX-DataFilter")){return}var j=this.dataFilterLastX!=null?parseInt(this.dataFilterLastX):-this.meta.canvas.ctx.canvas.width*0.5;var h=this.dataFilterLastY!=null?parseInt(this.dataFilterLastY):this.meta.canvas.ctx.canvas.height*0.5;var u=this.heigthOffsetDataFilter();this.dataFilterHeight=this.meta.canvas.ctx.canvas.height-u;this.activeAccordion=null;var B=this.$cX("div",{id:this.target+"-cX-DataFilter",className:"CanvasXpressDataFilter draggable-container"},{top:h+"px",left:j+"px",display:"none",zIndex:10000,marginLeft:"3px"});var o=this.$cX("div",{id:this.target+"-cX-DataFilterToolbar",className:"CanvasXpressDataFilterToolbar draggable"},{width:this.dataFilterWidth+"px"});var b=this.$cX("span",{innerHTML:"Filters",className:"CanvasXpressDataFilterToolbarText"});var s=this.$cX("img",{id:this.target+"-cX-DataFilterKeyFlash",className:"CanvasXpressDataFilterToolbarImage",src:this.filterFlashingOn?CanvasXpress.images.lightbulb:CanvasXpress.images.lightbulbOff,alt:this.filterFlashingOn?"Turn off Flashing":"Turn on Flashing",title:this.filterFlashingOn?"Turn off Flashing":"Turn on Flashing"},{display:this.graphType=="Network"?"block":"none"});if(CanvasXpress.system.isIE){s.style.marginTop="-10px"}var g=this.$cX("img",{id:this.target+"-cX-DataFilterKeyReset",className:"CanvasXpressDataFilterToolbarImage",src:CanvasXpress.images.funnelCross,alt:"Reset filters",title:"Reset filters"});if(CanvasXpress.system.isIE){g.style.marginTop="-10px"}var v=this.$cX("img",{id:this.target+"-cX-DataFilterKeyDock",className:"CanvasXpressDataFilterToolbarImage",src:this.dataFilterLastState&&this.dataFilterLastState=="docked"?CanvasXpress.images.unpin:CanvasXpress.images.pin,alt:this.dataFilterLastState&&this.dataFilterLastState=="docked"?"Undock":"Dock",title:this.dataFilterLastState&&this.dataFilterLastState=="docked"?"Undock":"Dock",state:this.dataFilterLastState&&this.dataFilterLastState=="docked"?"docked":"free"});if(CanvasXpress.system.isIE){v.style.marginTop="-10px"}var x=this.$cX("img",{id:this.target+"-cX-DataFilterKeyClose",className:"CanvasXpressDataFilterToolbarImage",src:CanvasXpress.images.cancel1,alt:"Close",title:"Close"});if(CanvasXpress.system.isIE){x.style.marginTop="-10px"}var C=this.$cX("div",{id:this.target+"-cX-DataFilterContainer",className:"CanvasXpressDataFilterContainer"},{width:this.dataFilterWidth+"px"});var m=this.$cX("div",{id:this.target+"-cX-DataFilterVariableHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType.match(/Genome|Network/)?"none":"block"});var r=this.$cX("div",{id:this.target+"-cX-DataFilterVariableContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var e=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Variables",className:"CanvasXpressDataFilterText"});var k=this.$cX("div",{id:this.target+"-cX-DataFilterSampleHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType.match(/Genome|Network/)?"none":"block"});var q=this.$cX("div",{id:this.target+"-cX-DataFilterSampleContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var c=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Samples",className:"CanvasXpressDataFilterText"});var y=this.$cX("div",{id:this.target+"-cX-DataFilterNodeHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType=="Network"?"block":"none"});var A=this.$cX("div",{id:this.target+"-cX-DataFilterNodeContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var n=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Nodes",className:"CanvasXpressDataFilterText"});var t=this.$cX("div",{id:this.target+"-cX-DataFilterEdgeHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType=="Network"?"block":"none"});var z=this.$cX("div",{id:this.target+"-cX-DataFilterEdgeContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var i=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Edges",className:"CanvasXpressDataFilterText"});var f=this.$cX("div",{id:this.target+"-cX-DataFilterGenomeHeader",className:"CanvasXpressDataFilterHead"},{width:this.dataFilterWidth+"px",display:this.graphType=="Genome"?"block":"none"});var l=this.$cX("div",{id:this.target+"-cX-DataFilterGenomeContent",className:"CanvasXpressDataFilterContent"},{width:this.dataFilterWidth+"px",height:"0px",display:"none"});var a=this.$cX("span",{innerHTML:"&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Features",className:"CanvasXpressDataFilterText"});o.appendChild(b);o.appendChild(x);o.appendChild(v);o.appendChild(g);o.appendChild(s);m.appendChild(e);k.appendChild(c);y.appendChild(n);t.appendChild(i);f.appendChild(a);C.appendChild(m);C.appendChild(r);C.appendChild(k);C.appendChild(q);C.appendChild(y);C.appendChild(A);C.appendChild(t);C.appendChild(z);C.appendChild(f);C.appendChild(l);B.appendChild(o);B.appendChild(C);var p=this.$("east-wrapper-"+this.target);if(p){p.appendChild(B);this.addRemoveDataFilterListeners("addEvtListener")}};this.addRemoveDataFilterListeners=function(k){var e=this.$(this.target+"-cX-DataFilterToolbar");var a=this.$(this.target+"-cX-DataFilterKeyFlash");var g=this.$(this.target+"-cX-DataFilterKeyReset");var b=this.$(this.target+"-cX-DataFilterKeyDock");var c=this.$(this.target+"-cX-DataFilterKeyClose");var h=this.$(this.target+"-cX-DataFilterVariableHeader");var i=this.$(this.target+"-cX-DataFilterSampleHeader");var d=this.$(this.target+"-cX-DataFilterNodeHeader");var f=this.$(this.target+"-cX-DataFilterEdgeHeader");var j=this.$(this.target+"-cX-DataFilterGenomeHeader");if(e&&a&&g&&b&&c&&h&&i&&d&&f&&j){this[k](e,"mousedown",this.registerMousemove,false);this[k](a,"click",this.flashDataFilter,false);this[k](g,"click",this.resetDataFilter,false);this[k](b,"click",this.dockUndockDataFilter,false);this[k](c,"click",this.hideDataFilter,false);this[k](h,"click",this.activateAccordion,false);this[k](i,"click",this.activateAccordion,false);this[k](d,"click",this.activateAccordion,false);this[k](f,"click",this.activateAccordion,false);this[k](j,"click",this.activateAccordion,false)}};this.flashDataFilter=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(a.filterFlashingOn){a.filterFlashingOn=false;b.src=CanvasXpress.images.lightbulbOff;b.alt="Turn on Flashing";b.title="Turn on Flashing"}else{a.filterFlashingOn=true;b.src=CanvasXpress.images.lightbulb;b.alt="Turn off Flashing";b.title="Turn off Flashing"}return false}}(this);this.activateAccordion=function(a){return function(f,b){if(!f){f=window.event}var d=a;if(!b){b=a.getTargetEvent(f)}if(b){if(b.tagName.toLowerCase()=="span"){b=b.parentNode}b.className="CanvasXpressDataFilterHeadActive";b.firstChild.className="CanvasXpressDataFilterTextActive";var c=b.nextSibling;if(c){setTimeout(function(){if(d.activeAccordion&&c.id==d.activeAccordion.id){c=false}d.transitionAccordion(new Date().getTime(),250,c,d.activeAccordion);if(d.activeAccordion){var e=d.activeAccordion.previousSibling;e.className="CanvasXpressDataFilterHead";e.firstChild.className="CanvasXpressDataFilterText"}d.activeAccordion=c},33)}}return false}}(this);this.moveDataFilter=function(l,m){var k,n;var p=this.$(this.target+"-cX-DataFilter");var i=this.$(this.target+"-cX-DataFilterToolbar");var e=this.$(this.target+"-cX-DataFilterKeyDock");var d=this.$(this.remoteParentId+"-canvasXpressRemoteWindow");var f=this.$("north-container-"+this.target);var a=this.$("south-container-"+this.target);var j=this.$("west-container-"+this.target);var t=this.$("middle-container-"+this.target);var c=this.$("east-container-"+this.target);var o=this.$("east-wrapper-"+this.target);var b=64;var r=0;var q=this.showFadeResizeMoveAnimation?500:0;var g=this;if(p&&i&&e&&f&&a&&j&&t&&c&&o){var s=(i.clientWidth-this.dataFilterWidth)+2;n=parseInt(f.clientHeight)+this.meta.canvas.ctx.canvas.height+parseInt(a.clientHeight);if(e.state=="free"&&!l){e.state="docked";this.dataFilterLastState="docked";this.dataFilterLastX=p.style.left;this.dataFilterLastY=p.style.top;var k=parseInt(j.style.width)+this.meta.canvas.ctx.canvas.width+i.clientWidth+2;if(d){this.resizeMove(d,0,0,Math.max(k,parseInt(a.clientWidth))+r,n+b)}this.resizeMove(t,0,0,k,this.meta.canvas.ctx.canvas.height);this.resizeMove(c,0,0,this.dataFilterWidth+s,this.meta.canvas.ctx.canvas.height);this.resizeMove(o,0,0,this.dataFilterWidth+s,this.meta.canvas.ctx.canvas.height);this.resizeMove(p,0,0,this.dataFilterWidth,this.meta.canvas.ctx.canvas.height)}else{e.state="free";this.dataFilterLastState="free";if(l){delete (this.dataFilterLastState);this.dataFilterLastX=null;this.dataFilterLastY=null;this.fade(p,500,function(){g.resetFade(p);p.style.display="none";p.style.width=g.dataFilterWidth+"px";p.style.height=g.meta.canvas.ctx.canvas.height+"px"})}k=parseInt(j.style.width)+this.meta.canvas.ctx.canvas.width;if(d){this.resizeMove(d,0,0,Math.max(k,parseInt(a.clientWidth))+r,n+b)}this.resizeMove(t,0,0,k,this.meta.canvas.ctx.canvas.height);this.resizeMove(c,0,0,0,this.meta.canvas.ctx.canvas.height);this.resizeMove(o,0,0,0,this.meta.canvas.ctx.canvas.height);if(!l){this.resizeMove(p,-this.meta.canvas.ctx.canvas.width*0.5,this.meta.canvas.ctx.canvas.height*0.5,this.dataFilterWidth,this.meta.canvas.ctx.canvas.height)}}if(m){e.state=m}if(e.state=="docked"){e.src=CanvasXpress.images.unpin;e.alt="Undock";e.title="Undock"}else{e.src=CanvasXpress.images.pin;e.alt="Dock";e.title="Dock"}}};this.getDataFilterState=function(){var a=this.$(this.target+"-cX-DataFilterKeyDock");return a?a.getAttribute("state"):false};this.updateDataFilter=function(a){this.functionCaller="updateDataFilter";if(this.isTransition()){return}var m=this;var c=this.isDOE;var g,j;var b=function(u,p,w,i,s){var q={min:">=",max:"<=",like:"like",exact:"exact"};if(q[w]){m[u].push(s!=null&&s!=false?i+":::"+s:i);m[u+"Op"].push(q[w]);m[u+"Case"].push(false);m[u+"Value"].push(m.toDoFilter[p][i][w])}};if(this.filteringStringOn||this.filteringNumericOn||a){this.resetFilters();var n=false;if(c){this.removeDOE(true)}for(var k in this.toDoFilter){for(var e in this.toDoFilter[k]){for(var l in this.toDoFilter[k][e]){var d=this.toDoFilter[k][e]["ref"];if(l!="ref"){if(k=="sample"){b("filterSmpBy",k,l,e,d)}else{if(k=="variable"){b("filterVarBy",k,l,e,d)}else{if(k=="node"){b("filterNodeBy",k,l,e,d)}else{if(k=="edge"){b("filterEdgeBy",k,l,e,d)}else{if(k=="feature"){b("filterFeatureBy",k,l,e,d)}}}}}}}}}this.reset(true);this.filterData(true);this.updateDataTable();if(this.layoutComb){g=this.varIndices;j=this.smpIndices}if(c){this.createDOE(true)}if(this.decorations&&this.decorations.reg){this.updateCorrelation()}if(this.validateAxesOnFilterData()){if(this.graphType=="Network"&&this.filterFlashingOn){var f=[];for(var h=0;h<this.data.nodes.length;h++){if(!this.data.nodes[h].hide){f.push(this.data.nodes[h].id)}}this.flashNode(f,false,5)}else{if(this.isGroupedData&&this.smpIndices.length>0){this.groupSamples(this.groupingFactors,false,false,true,true)}this.draw();if(this.layoutComb){this.varIndices=g;this.smpIndices=j}}}else{if(!this.scatterPlotMatrix){this.reset(true)}this.draw()}}};this.refreshDataFilters=function(B,w,F,Q,z){if(B&&w){var b=function(c){var a=1000000;return(((c*a)-(parseInt(c)*a))/a).toString().replace(/\./,"").length-1};var h=CanvasXpress.system.isIE?46:44;var O,A;switch(w){case"variable":A=this.getVariableIndices(F);O=A>=0?this.getSampleVariableData("smps"):this.getSampleVariableData("vars");break;case"sample":A=this.getSampleIndices(F);O=A>=0?this.getSampleVariableData("vars"):this.getSampleVariableData("smps");break;case"node":O=this.getFilteredNetworkData("nodes");break;case"edge":O=this.getFilteredNetworkData("edges");break}if(O){if(!this.lastRefreshedFilter){this.lastRefreshedFilter=[]}var E=this.lastRefreshedFilter.length>0?this.lastRefreshedFilter[this.lastRefreshedFilter.length-1]:"";var M=false;while(E==F){this.lastRefreshedFilter.pop();E=this.lastRefreshedFilter[this.lastRefreshedFilter.length-1];M=true}for(var H=0;H<B.childNodes.length;H++){var P=B.childNodes[H];var y=this.$(P.id.replace("DataFilterContainer","DataFilterScroll"));var C=this.$(P.id.replace("DataFilterContainer","DataFilterOptions"));var D=this.$(P.id.replace("DataFilterContainer","DataFilterRange"));var I=this.$(P.id.replace("DataFilterContainer","DataFilterMin"));var x=this.$(P.id.replace("DataFilterContainer","DataFilterMax"));var m=this.$(P.id.replace("DataFilterContainer","DataFilterMinLabel"));var N=this.$(P.id.replace("DataFilterContainer","DataFilterMaxLabel"));if(y&&C&&O.hasOwnProperty(y.uvalue)){if(y.uvalue!=F){var u=this.sortObject(O[y.uvalue]["o"]);y.fvalues=["(All) "+u.length+" values"];for(var G=0;G<u.length;G++){y.fvalues.push(u[G])}y.fvalues.push("")}else{if(Q&&M&&(E==y.uvalue||this.lastRefreshedFilter.length==0)){y.fvalues=y.values}}while(C.childNodes.length>0){C.removeChild(C.childNodes[0])}this.loadStringFilter(y.fvalues,y.uvalue,C,y.values.length,O[y.uvalue]["o"]);if(y.type=="long"){y.style.height=y.fvalues.length-2>this.maxItemMenuCheckbox?((y.fvalues.length+1)*16)+"px":(((y.fvalues.length-1)*19)+4)+"px"}}else{if(D&&I&&x&&m&&N&&O.hasOwnProperty(D.uvalue)){var L=b(O[D.uvalue]["o"].max-O[D.uvalue]["o"].min);var K,e;if(D.uvalue!=F){if(D.min==O[D.uvalue]["o"].min&&D.max!=O[D.uvalue]["o"].max){if(D.scale=="log"){K=O[D.uvalue]["o"].max?(Math.log(O[D.uvalue]["o"].max)-D.lmin)/D.lunits:0}else{K=(O[D.uvalue]["o"].max-D.min)/D.units}K=Math.ceil(K);D.style.width=Math.max(0,Math.floor(K)-parseInt(I.style.left))+"px"}else{if(D.min!=O[D.uvalue]["o"].min&&D.max==O[D.uvalue]["o"].max){if(D.scale=="log"){K=O[D.uvalue]["o"].min?(Math.log(O[D.uvalue]["o"].min)-D.lmin)/D.lunits:0}else{K=(O[D.uvalue]["o"].min-D.min)/D.units}K=Math.ceil(K);D.style.width=(parseInt(D.style.width)-K+parseInt(I.style.left))+"px";I.style.left=K+"px";D.style.left=K+"px";x.style.left=K+"px"}else{if(D.min!=O[D.uvalue]["o"].min&&D.max!=O[D.uvalue]["o"].max){if(D.scale=="log"){K=O[D.uvalue]["o"].max?(Math.log(O[D.uvalue]["o"].max)-D.lmin)/D.lunits:0;e=O[D.uvalue]["o"].min?(Math.log(O[D.uvalue]["o"].min)-D.lmin)/D.lunits:0}else{K=(O[D.uvalue]["o"].max-D.min)/D.units;e=(O[D.uvalue]["o"].min-D.min)/D.units}if(!this.isNumber(e)||!this.isNumber(K)){continue}e=Math.ceil(e);K=Math.ceil(K);D.style.width=(K-e)+"px";I.style.left=e+"px";D.style.left=e+"px";x.style.left=e+"px"}else{if(D.min==O[D.uvalue]["o"].min&&D.max==O[D.uvalue]["o"].max){D.style.width=(this.dataFilterWidth-h)+"px";I.style.left="0px";D.style.left="0px";x.style.left="0px"}}}}m.value=this.bestFormatNumber(O[D.uvalue]["o"].min,L);N.value=this.bestFormatNumber(O[D.uvalue]["o"].max,L)}}}}if(Q){this.refreshDataFilters(Q,w,F)}else{this.lastRefreshedFilter.push(F)}}}else{if(z){var M=this.$(this.target+"-cX-DataFilterContainer");if(M){this.lastRefreshedFilter=[];for(var H=0;H<M.childNodes.length;H++){if(M.childNodes[H].id.match("Content")){var P=M.childNodes[H];for(var G=0;G<P.childNodes.length;G++){if(P.childNodes[G].id.match("Items")){var J=P.childNodes[G];for(var F=0;F<J.childNodes.length;F++){if(J.childNodes[F].id.match("Container")){var O=J.childNodes[F];var y=this.$(O.id.replace("DataFilterContainer","DataFilterScroll"));var C=this.$(O.id.replace("DataFilterContainer","DataFilterOptions"));if(y&&C){y.fvalues=y.values;while(C.childNodes.length>0){C.removeChild(C.childNodes[0])}this.loadStringFilter(y.fvalues,y.uvalue,C,y.values.length)}}}}}}}}}}};this.validateAxesOnFilterData=function(){if(!this.startingXAxisIndices){this.startingXAxis=this.xAxis;this.startingXAxisIndices=this.graphType.match(/Scatter/i)?this.xAxisIndices:this.xAxisVarIndices}if(!this.startingXAxis2Indices){this.startingXAxis2=this.xAxis2;this.startingXAxis2Indices=this.xAxis2VarIndices}if(!this.startingYAxisIndices){this.startingYAxis=this.yAxis;this.startingYAxisIndices=this.yAxisIndices}if(!this.startingZAxisIndices){this.startingZAxis=this.zAxis;this.startingZAxisIndices=this.zAxisIndices}if(this.graphType.match(/Scatter/i)){var a=this.getObjectArray(this.smpIndices);this.xAxis=[];this.xAxisIndices=[];for(var b=0;b<this.startingXAxisIndices.length;b++){if(a.hasOwnProperty(this.startingXAxisIndices[b])){this.xAxis.push(this.data.y.smps[this.startingXAxisIndices[b]]);this.xAxisIndices.push(this.startingXAxisIndices[b])}}if(this.xAxisIndices.length<1){this.xAxis=this.startingXAxis;this.xAxisIndices=this.startingXAxisIndices;if(this.debug){alert("Cannot filter since there are no samples left in X-Axis")}return false}this.yAxis=[];this.yAxisIndices=[];for(var b=0;b<this.startingYAxisIndices.length;b++){if(a.hasOwnProperty(this.startingYAxisIndices[b])){this.yAxis.push(this.data.y.smps[this.startingYAxisIndices[b]]);this.yAxisIndices.push(this.startingYAxisIndices[b])}}if(this.yAxisIndices.length<1){this.yAxis=this.startingYAxis;this.yAxisIndices=this.startingYAxisIndices;if(this.debug){alert("Cannot filter since there are no samples left in Y-Axis")}return false}if(this.graphType=="Scatter3D"||this.graphType=="ScatterBubble2D"){this.zAxis=[];this.zAxisIndices=[];for(var b=0;b<this.startingZAxisIndices.length;b++){if(a.hasOwnProperty(this.startingZAxisIndices[b])){this.zAxis.push(this.data.y.smps[this.startingZAxisIndices[b]]);this.zAxisIndices.push(this.startingZAxisIndices[b])}}if(this.zAxisIndices.length<1){this.zAxis=this.startingZAxis;this.zAxisIndices=this.startingZAxisIndices;if(this.debug){alert("Cannot filter since there are no samples left in Z-Axis")}return false}}}else{if(this.graphType.match(/BarLine|DotLine|AreaLine|StackedLine|StackedPercentLine/)){var a=this.getObjectArray(this.varIndices);this.xAxis=[];this.xAxisIndices=[];for(var b=0;b<this.startingXAxisIndices.length;b++){if(a.hasOwnProperty(this.startingXAxisIndices[b])){this.xAxis.push(this.data.y.vars[this.startingXAxisIndices[b]]);this.xAxisIndices.push(this.startingXAxisIndices[b])}}if(this.xAxisIndices.length<1){this.xAxis=this.startingXAxis;this.xAxisIndices=this.startingXAxisIndices;if(this.debug){alert("Cannot filter since there are no variables left in X-Axis")}return false}this.xAxis2=[];this.xAxis2Indices=[];for(var b=0;b<this.startingXAxis2Indices.length;b++){if(a.hasOwnProperty(this.startingXAxis2Indices[b])){this.xAxis2.push(this.data.y.vars[this.startingXAxis2Indices[b]]);this.xAxis2Indices.push(this.startingXAxis2Indices[b])}}if(this.xAxis2Indices.length<1){this.xAxis2=this.startingXAxis2;this.xAxisIndices2=this.startingXAxis2Indices;if(this.debug){alert("Cannot filter since there are no variables left in X-Axis2")}return false}}}return true};this.showDataFilter=function(a){return function(d){if(!d){d=window.event}var f=a.$(a.target+"-cX-DataFilter");if(f){a.standbyTransition=a.showTransition;a.showTransition=false;if(f.style.left=="0px"&&f.style.top=="0px"){var b=a.$("west-container-"+a.target);var c=a.$("middle-container-"+a.target);if(b&&c){c.style.width=(parseInt(b.clientWidth)+a.meta.canvas.ctx.canvas.width+a.dataFilterWidth)+"px"}}if(a.activeTarget){a.activeTarget.style.zIndex=10000}a.activeTarget=f;f.style.display="block";a.loadDataFilter();f.style.zIndex=10001}return false}}(this);this.removeGenericDataFilterListenersOrReset=function(A){var z=[];var x=[];switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Area":case"AreaLine":case"Dotplot":case"DotLine":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Boxplot":case"Correlation":case"Pie":case"Scatter2D":case"ScatterBubble2D":case"Scatter3D":case"Candlestick":case"Circular":case"Map":var l=this.$(this.target+"-cX-DataFilterSampleContent");var m=this.$(this.target+"-cX-DataFilterVariableContent");if(l&&m){z.push(l,m);x.push(this.getSampleVariableData("smps",true));x.push(this.getSampleVariableData("vars",true))}break;case"Venn":return;case"Network":var t=this.$(this.target+"-cX-DataFilterNodeContent");var p=this.$(this.target+"-cX-DataFilterEdgeContent");if(t&&p){z.push(t,p);x.push(this.getNodeData(true));x.push(this.getEdgeData(true))}break;case"Genome":var h=this.$(this.target+"-cX-DataFilterGenomeContent");if(h){z.push(h);x.push(this.getFeatureData(true))}break}for(var u=0;u<x.length;u++){var g=z[u];var n=x[u];var C=this.getKeys(n);C.sort();for(var r=0;r<C.length;r++){var B=n[C[r]]["t"];var y=C[r].replace(/\W/g,"_");if(B=="string"){var b=this.$(this.target+":"+y+":cX-DataFilterInput");var q=this.$(this.target+":"+y+":cX-DataFilterScroll");var w=this.$(this.target+":"+y+":cX-DataFilterMask");if(q&&b){if(A){b.value="";this.resetSelectStringFilter(q)}else{this.addRemoveStringDataFilterListeners("removeEvtListener",w)}}}else{var o=this.$(this.target+":"+y+":cX-DataFilterMin");var k=this.$(this.target+":"+y+":cX-DataFilterMinLabel");var f=this.$(this.target+":"+y+":cX-DataFilterRange");var s=this.$(this.target+":"+y+":cX-DataFilterMax");var v=this.$(this.target+":"+y+":cX-DataFilterMaxLabel");var a=this.$(this.target+":"+y+":cX-DataFilterScale");var e=CanvasXpress.system.isIE?46:44;if(o&&k&&f&&s&&v&&a){if(A){o.style.left="0px";k.value=this.bestFormatNumber(f.min,f.decis);f.style.left="0px";f.style.width=(this.dataFilterWidth-e)+"px";s.style.left="0px";v.value=this.bestFormatNumber(f.max,f.decis)}else{this.addRemoveNumericDataFilterListeners("removeEvtListener",o,s,k,v,a)}}}}}};this.loadDataFilter=function(){if(!this.toDoFilter){this.toDoFilter={}}switch(this.graphType){case"Bar":case"Line":case"BarLine":case"Area":case"AreaLine":case"Dotplot":case"DotLine":case"Heatmap":case"Stacked":case"StackedLine":case"StackedPercent":case"StackedPercentLine":case"Boxplot":case"Correlation":case"Pie":case"Scatter2D":case"ScatterBubble2D":case"Scatter3D":case"Candlestick":case"Circular":case"Map":return this.loadDataFilterSmpVar();case"Venn":return;case"Network":return this.loadDataFilterNetwork();case"Genome":return this.loadDataFilterGenome()}};this.loadDataFilterGeneric=function(b,r,j){var o=this.graphType=="Genome"?95:116;var p=this.getKeys(j);p.sort();if(!r.loaded){r.loaded={}}var a=r.id+"Search";if(!this.$(a)){var k=this.$cX("div",{id:a,className:"CanvasXpressDataFilterContainerHoverable"},{width:"97%"});var q=this.$cX("input",{id:a+"Input",type:"text",placeholder:" Search filters"},{cursor:"default",width:"97%",margin:"3px",border:"none"});var m=this.$cX("div",{id:a+"Items"});k.appendChild(q);r.appendChild(k);r.appendChild(m)}var h=this.$(a+"Items");if(h){h.style.height=this.meta.canvas.ctx.canvas.height-o}for(var g=0;g<p.length;g++){var l=j[p[g]]["t"];var e=j[p[g]]["r"];var n=this.getKeys(j[p[g]]["o"]);var f=this.target+":"+p[g].replace(/\W/g,"_")+":cX-DataFilterContainer";if(!this.$(f)){if(n.length>0){if(l=="string"){if(!r.loaded[p[g]]){m.appendChild(this.createStringFilter(b,p[g],n,e));r.loaded[p[g]]=true}}else{if(!r.loaded[p[g]]){if(n[0]=="min"&&n[1]=="max"){n=[j[p[g]]["o"]["min"],j[p[g]]["o"]["max"]]}m.appendChild(this.createNumericFilter(b,p[g],n,e));r.loaded[p[g]]=true}}}}}};this.loadDataFilterSmpVar=function(){var b=this.$(this.target+"-cX-DataFilterSampleContent");var a=this.$(this.target+"-cX-DataFilterVariableContent");if(b&&a){this.loadDataFilterGeneric("sample",b,this.getSampleVariableData("smps",true));this.loadDataFilterGeneric("variable",a,this.getSampleVariableData("vars",true))}};this.loadDataFilterNetwork=function(){var b=this.$(this.target+"-cX-DataFilterNodeContent");var a=this.$(this.target+"-cX-DataFilterEdgeContent");if(b&&a){this.loadDataFilterGeneric("node",b,this.getNodeData(true));this.loadDataFilterGeneric("edge",a,this.getEdgeData(true))}};this.loadDataFilterGenome=function(){var a=this.$(this.target+"-cX-DataFilterGenomeContent");if(a){this.loadDataFilterGeneric("feature",a,this.getFeatureData(true))}};this.createNumericFilter=function(n,C,m,w,j,F){var i=this;var a=function(d){var b=1000000;return(((d*b)-(parseInt(d)*b))/b).toString().replace(/\./,"").length-1};var c=function(){if(F){return[(F[1]-F[0])/A,(F[0]-m[0])/A]}else{return[i.dataFilterWidth-h,0]}};var h=CanvasXpress.system.isIE?46:44;m=this.filterNumbers(m);m.sort(function(e,d){return e-d});var H=C.replace(/\W/g,"_");var x=j?this.target+":"+H+"_":this.target+":"+H;var J=this.$cX("div",{id:x+":cX-DataFilterContainer",className:"CanvasXpressDataFilterContainerHoverable",type:"numeric",args:[n,C,m,w,j]});var B=this.$cX("div",{id:x+":cX-DataFilterScale",className:m[0]<=0?"CanvasXpressDataFilterContainerScaleNone":"CanvasXpressDataFilterContainerScaleLinearLog",innerHTML:C,draggable:true},{width:(this.dataFilterWidth-18)+"px",margin:"5px"});var u=this.$cX("div",false,{width:(this.dataFilterWidth-18)+"px",height:"14px",margin:"2px"});var E=parseFloat(m[0])<0?false:parseFloat(m[0])==0?0:Math.log(parseFloat(m[0]));var I=parseFloat(m[m.length-1])<0?false:parseFloat(m[m.length-1])==0?0:Math.log(parseFloat(m[m.length-1]));var L=E!=null&&I!=null?(I-E)/(this.dataFilterWidth-h):false;var A=(m[m.length-1]-m[0])/(this.dataFilterWidth-h);var f=c();var p=this.$cX("div",{id:x+":cX-DataFilterRange",className:"CanvasXpressDataFilterContainerRange",min:parseFloat(m[0]),max:parseFloat(m[m.length-1]),cmin:parseFloat(m[0]),cmax:parseFloat(m[m.length-1]),range:m[m.length-1]-m[0],units:A,decis:a(m[m.length-1]-m[0]),lmin:E,lmax:I,lunits:L,scale:L?"linear":false,filter:n,ref:w,uvalue:C},{width:f[0]+"px",left:f[1]+"px"});var D=this.$cX("input",{id:x+":cX-DataFilterMinLabel",className:"CanvasXpressDataFilterContainerMinValue",type:"text",value:this.bestFormatNumber(F?F[0]:m[0],p.decis)});var o=this.$cX("input",{id:x+":cX-DataFilterMaxLabel",className:"CanvasXpressDataFilterContainerMaxValue",type:"text",value:this.bestFormatNumber(F?F[1]:m[m.length-1],p.decis)});var K=this.$cX("div",{className:"CanvasXpressDataFilterContainerNumeric"},{width:(i.dataFilterWidth-16)+"px"});var G=this.$cX("div",{id:x+":cX-DataFilterMin",className:"CanvasXpressDataFilterContainerMin"},{left:f[1]+"px"});var y=this.$cX("div",{id:x+":cX-DataFilterMax",className:"CanvasXpressDataFilterContainerMax"},{left:f[1]+"px"});u.appendChild(D);u.appendChild(o);K.appendChild(G);K.appendChild(p);K.appendChild(y);J.appendChild(B);J.appendChild(u);J.appendChild(K);this.addRemoveNumericDataFilterListeners("addEvtListener",G,y,D,o,B);return J};this.addRemoveNumericDataFilterListeners=function(e,d,a,f,c,b){if(e&&d&&a&&f&&c&&b){this[e](d,"mousedown",this.mousedownNumericFilter,false);this[e](a,"mousedown",this.mousedownNumericFilter,false);this[e](f,"change",this.changeNumericFilter,false);this[e](c,"change",this.changeNumericFilter,false);this[e](b,"click",this.clickNumericFilter,false);this[e](b,"dragstart",this.dragStartDataFilter,false);this[e](b,"dragend",this.dragEndDataFilter,false)}};this.dragStartDataFilter=function(a){return function(c){if(!c){c=window.event}c.acs=a.adjustedCoordinates(c);var b=a.getTargetEvent(c);if(b){c.dataTransfer.setDragImage(b.parentNode,-5,-5);b.parentNode.style.opacity="0.3";c.dataTransfer.setData("text",b.parentNode.id);a.xMouseDown=c.screenX;a.yMouseDown=c.screenY}return false}}(this);this.dragEndDataFilter=function(a){return function(f){if(!f){f=window.event}f.ace=a.adjustedCoordinates(f);var c=a.getTargetEvent(f);if(c){a.addRemoveDataFilter(f.srcElement.parentNode);var d=f.screenX-a.xMouseDown;var b=f.screenY-a.yMouseDown}return false}}(this);this.addRemoveDataFilter=function(e,o,g,j,n){var h=false;if(!e){this.loadDataFilter();if(o&&g&&j){if(j=="string"){g[2].shift();g[2].pop()}e=n?this.$(n):this[o].apply(this,g)}else{return}h=true}if(!o){o=e.type=="string"?"createStringFilter":"createNumericFilter"}if(!g){g=e.args}if(!e){return}e.style.opacity="1.0";e.style.cssFloat="left";var a=e.parentNode;if((h&&!n)||a.id.match(/DataFilter/)){var k=this.$("northest-wrapper-"+this.target);if(k){k.appendChild(e)}if(!h){CanvasXpress.stack[this.target].afterRender.push(["addRemoveDataFilter",[false,o,g,e.type]])}}else{var c=e.id.split(":")[1];var b;if(e.type=="string"){var d=this.$(this.target+":"+c+":cX-DataFilterMask");if(d){b=this.rebuildDataTableFilter();this.addRemoveStringDataFilterListeners("removeEvtListener",d)}}else{var i=this.$(this.target+":"+c+":cX-DataFilterMin");var m=this.$(this.target+":"+c+":cX-DataFilterMinLabel");var l=this.$(this.target+":"+c+":cX-DataFilterMax");var f=this.$(this.target+":"+c+":cX-DataFilterMaxLabel");var q=this.$(this.target+":"+c+":cX-DataFilterScale");if(i&&m&&l&&f){b=this.rebuildDataTableFilter();this.addRemoveNumericDataFilterListeners("removeEvtListener",i,l,m,f,q)}}if(!h){CanvasXpress.stack[this.target].afterRender.push(["addRemoveDataFilter",[false,o,g,e.type,c]])}a.removeChild(e);if(b){this.rebuildDataTableFilter(b)}}};this.changeNumericFilter=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(b){a.filteringNumericOn=b;a.updateNumericFilter(c)}return false}}(this);this.mousedownNumericFilter=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(b){a.filteringNumericOn=b;a.xMouseDown=c.clientX;a.yMouseDown=c.clientY}return false}}(this);this.clickNumericFilter=function(a){return function(h){if(!h){h=window.event}var d=a.getTargetEvent(h);if(d){var c=a.$(d.id.replace("cX-DataFilterScale","cX-DataFilterRange"));var g=a.adjustedCoordinates(h,d);if(c&&g&&c.scale){var f=a.isIE?46:44;var b=parseInt(a.dataFilterWidth-18);if(g.x>b-13){d.className="CanvasXpressDataFilterContainerScaleLogLinear";c.scale="log"}else{if(g.x>b-26){d.className="CanvasXpressDataFilterContainerScaleLinearLog";c.scale="linear"}}}}return false}}(this);this.updateNumericFilter=function(v){if(this.filteringNumericOn){var i=this;var q=function(){if(t.parentNode.parentNode.parentNode.className=="CanvasXpressListItem"){if(i.graphType=="Network"){if(f=="node"){return i.$(i.target+"-cX-DataFilterNodeContentSearchItems")}else{return i.$(i.target+"-cX-DataFilterEdgeContentSearchItems")}}else{var e;if(f=="sample"){e=i.getSampleIndices(y);return e>=0?i.$(i.target+"-cX-DataFilterVariableContentSearchItems"):i.$(i.target+"-cX-DataFilterSampleContentSearchItems")}else{e=i.getVariableIndices(y);return e>=0?i.$(i.target+"-cX-DataFilterSampleContentSearchItems"):i.$(i.target+"-cX-DataFilterVariableContentSearchItems")}}}else{return t.parentNode.parentNode.parentNode}};this.cancelEvent(v);var t=this.filteringNumericOn;var x,p,r,h,j,w,b;if(t.id.match(/cX-DataFilterMin(Label)?/)){b=RegExp.$1;x=true;p=t.id.replace("cX-DataFilterMin"+b,"cX-DataFilterMin");r=t.id.replace("cX-DataFilterMin"+b,"cX-DataFilterMax");h=t.id.replace("cX-DataFilterMin"+b,"cX-DataFilterRange");j=t.id.replace("cX-DataFilterMin"+b,"cX-DataFilterMinLabel");w=t.id.replace("cX-DataFilterMin"+b,"cX-DataFilterMaxLabel")}else{if(t.id.match(/cX-DataFilterMax(Label)?/)){b=RegExp.$1;x=false;r=t.id.replace("cX-DataFilterMax"+b,"cX-DataFilterMax");p=t.id.replace("cX-DataFilterMax"+b,"cX-DataFilterMin");h=t.id.replace("cX-DataFilterMax"+b,"cX-DataFilterRange");j=t.id.replace("cX-DataFilterMax"+b,"cX-DataFilterMinLabel");w=t.id.replace("cX-DataFilterMax"+b,"cX-DataFilterMaxLabel")}}p=this.$(p);r=this.$(r);h=this.$(h);j=this.$(j);w=this.$(w);if(p&&r&&h&&j&&w){var l,u;var c=CanvasXpress.system.isIE?46:44;var m=this.dataFilterWidth-c;if(b){var B=t.value-0;var n;var g=j.value-0;var d=w.value-0;var s=false;if(t===w&&B<g){B=g;s=true}if(t===j&&B>d){B=d;s=true}if(B<h.min){B=h.min;s=true}if(B>h.max){B=h.max;s=true}if(s){t.value=this.bestFormatNumber(B,h.decis)}if(h.scale=="log"){u=B?(Math.log(B)-h.lmin)/h.lunits:0}else{u=(B-h.min)/h.units}u=Math.ceil(u);if(x){u=Math.ceil(u);h.style.width=(parseInt(h.style.width)-u+parseInt(p.style.left))+"px";p.style.left=u+"px";h.style.left=u+"px";r.style.left=u+"px"}else{h.style.width=Math.max(0,Math.floor(u)-parseInt(p.style.left))+"px"}}else{l=v.clientX-this.xMouseDown;u=parseInt(p.style.left)+l;var a=x?parseInt(h.style.width)-l:parseInt(h.style.width)+l;var o=this.absoluteCoordinates(p);var k=this.absoluteCoordinates(r);if(x){if(u>0&&a>0){this.xMouseDown=v.clientX;u=Math.max(0,Math.min(m,u));a=Math.max(0,Math.min(m,a))}else{if(u>0){u-=l;a=(k.x-o.x)-29}else{a+=u;u=0}}p.style.left=u+"px";h.style.left=u+"px";h.style.width=a+"px";r.style.left=u+"px";var z;if(h.scale=="log"){z=u!=0?Math.exp((h.lunits*u)+h.lmin):0}else{z=(h.units*u)+h.min}z=Math.min(Math.max(z,h.min),parseFloat(w.value));j.value=this.bestFormatNumber(z,h.decis)}else{if(u+a<=m&&a>=0){this.xMouseDown=v.clientX;u=Math.max(0,Math.min(m,u));a=Math.max(0,Math.min(m-u,a))}else{if(u+a>m){u-=l;a=m-u}}h.style.width=Math.max(0,a)+"px";var A;if(h.scale=="log"){A=a!=m?Math.exp((h.lunits*(u+a))+h.lmin):h.max}else{A=(h.units*(u+a))+h.min}A=Math.max(Math.min(A,h.max),parseFloat(j.value));w.value=this.bestFormatNumber(A,h.decis)}}var y=h.uvalue;var f=h.filter;if(!this.toDoFilter[f]){this.toDoFilter[f]={}}if(!this.toDoFilter[f][y]){this.toDoFilter[f][y]={}}if(b){if(x){this.toDoFilter[f][y]["min"]=B}else{this.toDoFilter[f][y]["max"]=B}}else{if(z!=null){this.toDoFilter[f][y]["min"]=z}if(A!=null){this.toDoFilter[f][y]["max"]=A}}if(h.ref!=null){this.toDoFilter[f][y]["ref"]=h.ref}this.updateDataFilter();this.refreshDataFilters(q(),f,y);if(b){this.endNumericFilter(v)}}}return false};this.endNumericFilter=function(a){if(this.filteringNumericOn){this.filteringNumericOn=false}};this.createStringFilter=function(y,j,x,a,w,p){x.sort();x.unshift("(All) "+x.length+" values");x.push("");var r=j.replace(/\W/g,"_");var b=w?this.target+":"+r+"_":this.target+":"+r;var u=this.$cX("div",{id:b+":cX-DataFilterContainer",className:"CanvasXpressDataFilterContainerHoverable",type:"string",args:[y,j,x,a,w]});if(w){u.style.width="180px"}var h=this.$cX("div",{id:b+":cX-DataFilterLabel",innerHTML:j,draggable:true},{width:"98%",margin:"5px"});var n=this.$cX("input",{id:b+":cX-DataFilterInput",type:"text",placeholder:" Search values"},{cursor:"default",width:"94%",marginLeft:"5px"});var f=this.$cX("div",{id:b+":cX-DataFilterMask",className:x.length-2>this.maxItemMenuCheckbox?"CanvasXpressDataFilterContainerMask":"CanvasXpressDataFilterContainerMaskNoOverflow"},{width:"93%",height:x.length-2>this.maxItemMenuCheckbox?"80px":(((x.length-1)*19)+4)+"px"});var A=this.$cX("div",{id:b+":cX-DataFilterScroll",type:(x.length-2)>this.maxItemMenuCheckbox?"long":"short",filter:y,uvalue:j,values:x,fvalues:x,selected:{0:p?false:true},ref:a,skey:r,last:0},{width:"93%",height:x.length-2>this.maxItemMenuCheckbox?((x.length+1)*16)+"px":(((x.length-1)*19)+4)+"px"});var c=this.$cX("div",{id:b+":cX-DataFilterOptions"},{width:"100%",position:"relative"});this.loadStringFilter(x,r,c,x.length,false,w,p);A.appendChild(c);f.appendChild(A);u.appendChild(h);if(x.length-2>this.maxItemMenuCheckbox){u.appendChild(n)}u.appendChild(f);this.addRemoveStringDataFilterListeners("addEvtListener",f);return u};this.loadStringFilter=function(E,t,h,j,F,B,x){if(E&&t&&h){var D=x?this.getObjectArray(x):false;if(j-2>this.maxItemMenuCheckbox){for(var u=0;u<Math.min(5,E.length);u++){var b=E[u].length>30?E[u].substr(0,30)+" ...":E[u];var A=(!F&&!x&&u==0)||(F&&F.hasOwnProperty(E[u]))||(x&&D.hasOwnProperty(E[u]))?"CanvasXpressDataFilterContainerItemSelected":"CanvasXpressDataFilterContainerItem";var e=B?this.target+":"+t+"_:cX-DataFilterItem-"+u:this.target+":"+t+":cX-DataFilterItem-"+u;var C=this.$cX("div",{id:e,className:A,innerHTML:b,alt:E[u],title:E[u],index:u},{width:"111%"});h.appendChild(C)}}else{for(var u=0;u<E.length-1;u++){var b=E[u].length>30?E[u].substr(0,30)+" ...":E[u];var e=B?this.target+":"+t+"_:cX-DataFilterDivItem-"+u:this.target+":"+t+":cX-DataFilterDivItem-"+u;var y=this.$cX("div",{id:e,alt:E[u],title:E[u],value:b,index:u});var f=B?this.target+":"+t+"_:cX-DataFilterInputItem-"+u:this.target+":"+t+":cX-DataFilterInputItem-"+u;var C=this.$cX("input",{id:f,className:"CanvasXpressCheckbox",type:"checkbox",checked:F&&!F.hasOwnProperty(E[u])?false:true,value:b,index:u,name:""});if(x){C.checked=D.hasOwnProperty(E[u])?true:false}var m=this.$cX("label",{"for":this.target+":"+t+":cX-DataFilterItem-"+u,className:"CanvasXpressCheckboxLabel",innerHTML:E[u]});y.appendChild(C);y.appendChild(m);h.appendChild(y)}}}};this.addRemoveStringDataFilterListeners=function(c,b){if(c&&b){var a=b.parentNode.firstElementChild;if(b.firstChild.type=="long"){this[c](b,"scroll",this.scrollStringFilter,false)}this[c](b,"mousedown",this.registerStringFilter,false);this[c](b,"mouseup",this.endStringFilter,false);this[c](a,"dragstart",this.dragStartDataFilter,false);this[c](a,"dragend",this.dragEndDataFilter,false)}};this.scrollStringFilter=function(a){return function(j,c,n){if(!j){j=window.event}if(!c){c=a.getTargetEvent(j)}var p=c.firstChild;var f=p.firstChild;var g=p.skey;var m=Math.max(0,Math.min(Math.ceil(c.scrollTop/16),p.fvalues.length-5));f.style.top=c.scrollTop+"px";for(var h=0;h<Math.min(5,p.fvalues.length);h++){var l=a.$(a.target+":"+g+":cX-DataFilterItem-"+h);if(l){var c=p.fvalues[m+h].length>30?p.fvalues[m+h].substr(0,30)+" ...":p.fvalues[m+h];l.className=p.selected[m+h]?"CanvasXpressDataFilterContainerItemSelected":"CanvasXpressDataFilterContainerItem";l.innerHTML=c;l.alt=p.fvalues[m+h];l.title=p.fvalues[m+h];l.index=m+h}}if(a.filteringStringOn&&!n){a.updateSelectStringFilter(false,a.$(a.target+":"+g+":cX-DataFilterItem-4"),true)}return false}}(this);this.registerStringFilter=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(!b.id){b=b.parentNode}if(!b.id.match(/cX-DataFilterMask/)){if(!b.id.match(/cX-DataFilterDivItem/)){if(b.parentNode.id.match(/cX-DataFilterDivItem/)){a.updateSelectStringFilter(false,b,false,true);a.filteringStringOn=b.parentNode}else{a.$(b.parentNode.id.replace("cX-DataFilterOptions","cX-DataFilterInput")).value="";a.updateSelectStringFilter(false,b,c.shiftKey,c.ctrlKey);a.filteringStringOn=b}}else{a.updateSelectStringFilter(false,b.firstChild,false,true);a.filteringStringOn=b}}return false}}(this);this.endStringFilter=function(a){return function(k,d,g){if(!k){k=window.event}if(!d&&a.filteringStringOn&&a.filteringStringOn.parentNode){d=a.filteringStringOn.parentNode.parentNode}if(!d){return}var m=function(){if(d.parentNode.parentNode.parentNode.className=="CanvasXpressListItem"){if(a.graphType=="Network"){if(j=="node"){return a.$(a.target+"-cX-DataFilterNodeContentSearchItems")}else{return a.$(a.target+"-cX-DataFilterEdgeContentSearchItems")}}else{var e;if(j=="sample"){e=a.getVariableIndices(t);return e>=0?a.$(a.target+"-cX-DataFilterVariableContentSearchItems"):a.$(a.target+"-cX-DataFilterSampleContentSearchItems")}else{e=a.getSampleIndices(t);return e>=0?a.$(a.target+"-cX-DataFilterSampleContentSearchItems"):a.$(a.target+"-cX-DataFilterVariableContentSearchItems")}}}else{return d.parentNode.parentNode.parentNode}};var u=d.selected;var j=d.filter;var t=d.uvalue;var b=d.ref;var p=d.fvalues;var c=g?"like":"exact";var n;if(!u[0]){if(!a.toDoFilter[j]){a.toDoFilter[j]={}}if(!a.toDoFilter[j][t]){a.toDoFilter[j][t]={}}a.toDoFilter[j][t][c]=[];for(var h in u){a.toDoFilter[j][t][c].push(p[h])}if(b!=null){a.toDoFilter[j][t]["ref"]=b}}else{if(a.toDoFilter[j]&&a.toDoFilter[j][t]){delete (a.toDoFilter[j][t])}}a.filteringStringOn=true;a.updateDataFilter();a.refreshDataFilters(m(),j,t,d.parentNode.parentNode.parentNode.className=="CanvasXpressListItem"?d.parentNode.parentNode.parentNode:false);a.scrollStringFilter(false,d.parentNode,true);a.filteringStringOn=false;return false}}(this);this.updateStringFilter=function(c){var a=this.getTargetEvent(c);var d=this.filteringStringOn&&this.filteringStringOn.id?this.filteringStringOn.id.replace(/-\d$/,""):"";if(a.id.match(d)&&!c.ctrlKey){this.updateSelectStringFilter(false,a,true);this.dragStringFilter=[a.parentNode.parentNode.parentNode,a.id.split("-")[2]]}else{if(this.dragStringFilter){var b=this.dragStringFilter[1]>=3?16:-16;this.dragStringFilter[0].scrollTop+=b;this.scrollStringFilter(false,this.dragStringFilter[0],false)}}};this.updateSelectStringFilter=function(j,G,D,c){if(j){var F=this.$(j);var w=this.$(j.replace("cX-DataFilterInput","cX-DataFilterScroll"));if(F.value){var m;try{m=new RegExp(F.value.toLowerCase())}catch(F){return}var y=0;var u=w.firstChild;var H=u.childNodes[0].index;var E=null;var k=0;w.selected={};for(var B=1;B<w.fvalues.length-1;B++){if(w.fvalues[B].toLowerCase().match(m)){if(!E){E=B;k=B*16}w.selected[B]=true;y++}}if(y+2==w.fvalues.length){w.selected={0:true};E=0}if(E!=null){w.parentNode.scrollTop=k;this.scrollStringFilter(false,w.parentNode)}this.endStringFilter(false,w)}else{this.resetSelectStringFilter(w);this.endStringFilter(false,w)}}else{if(G){var d=G.index;var u=G.parentNode;var t=false;if(!u.id){return false}while(!u.id.match(/cX-DataFilterOptions/)){u=u.parentNode;t=true;if(!u.id){return false}}var k=u.parentNode;var A=k.last;var C=k.selected;var g=k.fvalues;var H=u.childNodes[0].index;var y=0;var a=c&&k.selected[d];k.selected={};if(!a){k.selected[d]=true}if(D){if(d>A){for(var B=A;B<=d;B++){k.selected[B]=true;if(B){y++}}}else{for(var B=d;B<=A;B++){k.selected[B]=true;if(B){y++}}}}else{if(c){if(!a){k.last=d}if(t&&d==0){for(var B=0;B<g.length-1;B++){k.selected[B]=true}}else{for(var B in C){if(B==d&&a){continue}k.selected[B]=true;if(B){y++}}}}else{k.last=d}}if(y>0){delete (k.selected[0])}if(!t){delete (k.selected[g.length-1]);for(var B=0;B<u.childNodes.length;B++){u.childNodes[B].className=k.selected[B+H]?"CanvasXpressDataFilterContainerItemSelected":"CanvasXpressDataFilterContainerItem"}}}}};this.resetSelectStringFilter=function(a){if(a){a.selected={0:true};var b=a.parentNode;b.scrollTop=0;this.scrollStringFilter(false,b)}};this.updateSearchFilters=function(e){var g=this.$(e).parentNode.parentNode;if(g){var h=g.childNodes;var b=new RegExp(h[0].firstChild.value,"i");for(var d=0;d<h[1].childNodes.length;d++){var a=h[1].childNodes[d].id.split(":");if(a[1].match(b)){h[1].childNodes[d].style.display="block"}else{h[1].childNodes[d].style.display="none"}}}};this.hideDataFilterNoAnimation=function(){var a=this.showFadeResizeMoveAnimation;this.showFadeResizeMoveAnimation=false;this.hideDataFilter();this.showFadeResizeMoveAnimation=a;return false};this.hideDataFilter=function(a){return function(b){if(!b){b=window.event}a.showTransition=a.standbyTransition;delete (a.dragStringFilter);a.moveDataFilter(true);return false}}(this);this.dockUndockDataFilter=function(a){return function(c){if(!c){c=window.event}var b=a.$(a.target+"-cX-DataFilter");if(b){a.moveDataFilter()}return false}}(this);this.resizeDataFilter=function(){this.dataFilterHeight=this.meta.canvas.ctx.canvas.height-this.heigthOffsetDataFilter();if(this.activeAccordion){this.activeAccordion.style.height=this.dataFilterHeight+"px"}};this.resetDataFilter=function(a){return function(d,g,b){a.functionCaller="resetDataFilter";if(a.isTransition()){return}a.resetFilters();a.refreshDataFilters(false,false,false,false,true);a.toDoFilter={};a.reset();a.updateDataTable();if(b){var c=a.$(a.target+"-cX-DataFilter");if(c){a.removeGenericDataFilterListenersOrReset();c.parentNode.removeChild(c);a.addDataFilterDiv()}}else{a.removeGenericDataFilterListenersOrReset(true)}if(a.isOncoprint){a.sortIndices("onc","desc")}if(!g){if(a.isGroupedData){a.groupSamples(a.groupingFactors)}else{a.draw()}}return false}}(this);this.rebuildDataFilter=function(){this.resetDataFilter(false,true,true)};this.initializeDataFilterEvents=function(){this.addDataFilterDiv()};this.initializeDataFilterEvents()};CanvasXpress.prototype.initDataTable=function(){this.addDataTableDiv=function(J,K){if(this.$(this.target+"-cX-DataTable")){return}var C=this;var f=function(){if(C.graphType.match(/Correlation|Venn/)){return"none"}else{return"block"}};var O=function(n,d,b){var o=C.$cX(d==0||b==0?"th":"td",{id:C.target+"-cX-DataTableCell."+d+"."+b,className:d==0||b==0?"CanvasXpressTableCellHead":"CanvasXpressTableCell"},{width:C.colWidth+"px",height:C.rowHeight+"px"});n.appendChild(o)};if(!K){this.setDataTableDimensions(J)}var c=52;var R=46;var D=this.dataTableLastX!=null?parseInt(this.dataTableLastX):0;var B=this.dataTableLastY!=null?parseInt(this.dataTableLastY):-this.meta.canvas.ctx.canvas.height*0.5;var E=this.dataTableLastWidth||this.dataTableColsWidth+c;var L=this.dataTableLastHeight||this.dataTableRowsHeight+R;var I=((this.colWidth+8)*3)+6;var a=((this.rowHeight+4)*3)+8;var P=this.$cX("div",{id:this.target+"-cX-DataTable",className:"CanvasXpressDataTable draggable-container"},{top:B+"px",left:D+"px",width:E+"px",height:L+"px",minWidth:(I+c)+"px",minHeight:(a+R+20)+"px",display:"none",marginTop:"3px"});var k=this.$cX("div",{id:this.target+"-cX-DataTableToolbar",className:"CanvasXpressDataTableToolbar draggable"},{width:E+"px",minWidth:(I+c)+"px"});var v=this.$cX("img",{id:this.target+"-cX-DataTableSaveImage",className:"CanvasXpressDataTableToolbarImage",src:CanvasXpress.images.disk,alt:"Save data",title:"Save data"});var g=this.$cX("img",{id:this.target+"-cX-DataTableMaximizeMinimizeImage",className:"CanvasXpressDataTableToolbarImage",src:CanvasXpress.images.inout,alt:"Minimize / Maximize",title:"Minimize / Maximize"});var x=this.$cX("img",{id:this.target+"-cX-DataTableColorImage",className:"CanvasXpressDataTableToolbarImage",src:CanvasXpress.images.colors,alt:"Color Data Table",title:"Color Data Table"},{display:f()});var m=this.$cX("img",{id:this.target+"-cX-DataTableTransposeImage",className:"CanvasXpressDataTableToolbarImage",src:CanvasXpress.images.transpose,alt:"Transpose data",title:"Transpose data"});var s=this.$cX("img",{id:this.target+"-cX-DataTableNetworkImage",className:"CanvasXpressDataTableToolbarImage",src:this.networkShowDataTable=="nodes"?CanvasXpress.images.edges:CanvasXpress.images.nodes,alt:this.networkShowDataTable=="nodes"?"Show edge data":"Show node data",title:this.networkShowDataTable=="nodes"?"Show edge data":"Show node data"},{display:this.graphType=="Network"?"block":"none"});var q=this.$cX("img",{id:this.target+"-cX-DataTableFilterResetImage",className:"CanvasXpressDataTableToolbarImage",src:CanvasXpress.images.funnelCross,alt:"Reset filters",title:"Reset filters"});var y=this.$cX("img",{id:this.target+"-cX-DataTableDockImage",className:"CanvasXpressDataTableToolbarImage",src:this.dataTableLastState&&this.dataTableLastState=="docked"?CanvasXpress.images.unpin:CanvasXpress.images.pin,alt:this.dataTableLastState&&this.dataTableLastState=="docked"?"Undock":"Dock",title:this.dataTableLastState&&this.dataTableLastState=="docked"?"Undock":"Dock"});var A=this.$cX("img",{id:this.target+"-cX-DataTableCloseImage",className:"CanvasXpressDataTableToolbarImage",src:CanvasXpress.images.cancel1,alt:"Close table",title:"Close table"});var u=this.$cX("div",{id:this.target+"-cX-DataTableContainer",className:"CanvasXpressDataTableContainer"},{width:E+"px",height:(L-20)+"px",minWidth:(I+c)+"px",minHeight:(a+R)+"px"});var S=this.$cX("div",{id:this.target+"-cX-DataTableTableMask",className:"CanvasXpressDataTableMask"},{width:(E-c)+"px",height:(L-R)+"px",minWidth:I+"px",minHeight:(a+20)+"px"});var G=this.$cX("table",{id:this.target+"-cX-DataTableTable",className:"CanvasXpressDataTable"});var Q=this.$cX("tbody");for(var N=0;N<this.maxRows;N++){var H=this.$cX("tr");for(var M=0;M<this.maxCols;M++){O(H,N,M)}Q.appendChild(H)}var e=this.$cX("div",{id:this.target+"-cX-DataTableVer",className:"CanvasXpressDataTableVertical"},{height:(L-R)+"px",minHeight:(a+20)+"px"});var p=this.$cX("img",{id:this.target+"-cX-DataTableVerImage",src:CanvasXpress.images.canvasXpress,width:1,height:this.dataTableTotalHeight},{maxHeight:this.dataTableTotalHeight+"px"});e.appendChild(p);var h=this.$cX("div",{id:this.target+"-cX-DataTableHor",className:"CanvasXpressDataTableHorizontal"},{width:(E-c)+"px",minWidth:I+"px"});var z=this.$cX("img",{id:this.target+"-cX-DataTableHorImage",src:CanvasXpress.images.canvasXpress,width:this.dataTableTotalWidth,height:1},{maxWidth:this.dataTableTotalWidth+"px"});h.appendChild(z);var l=this.$cX("div",{id:this.target+"-cX-DataTableResizer",className:"CanvasXpressDataTableResizer resizable"});k.appendChild(A);k.appendChild(y);k.appendChild(q);k.appendChild(m);k.appendChild(x);k.appendChild(g);k.appendChild(v);k.appendChild(s);G.appendChild(Q);S.appendChild(G);u.appendChild(S);u.appendChild(e);u.appendChild(h);u.appendChild(l);P.appendChild(k);P.appendChild(u);var F=this.$("south-wrapper-"+this.target);if(F){F.appendChild(P);this.addRemoveDataTableListeners("addEvtListener")}};this.addRemoveDataTableListeners=function(a,f){this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTable"),"mousewheel",this.scrollDataTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableHor"),"scroll",this.scrollTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableVer"),"scroll",this.scrollTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableToolbar"),"mousedown",this.registerMousemove,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableSaveImage"),"click",this.saveTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableMaximizeMinimizeImage"),"click",this.maximizeMinimizeTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableColorImage"),"click",this.colorTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableFilterResetImage"),"click",this.filterResetTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableNetworkImage"),"click",this.networkUpdateTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableTransposeImage"),"click",this.transposeDataTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableDockImage"),"click",this.dockUndockTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCloseImage"),"click",this.hideTable,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableResizer"),"mousedown",this.mousedownDataTableResizer,false);var e=f?f[0]:this.maxRows;var g=f?f[1]:this.maxCols;for(var d=0;d<g;d++){this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"click",this.clickDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"mousemove",this.mousemoveDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"mousedown",this.mousedownDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"mouseover",this.mouseoverDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell.0."+d),"mouseout",this.mouseoutDataTableHeader,false)}for(var d=0;d<e;d++){this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+".0"),"mouseover",this.mouseoverDataTableHeader,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+".0"),"mouseout",this.mouseoutDataTableHeader,false)}for(var d=1;d<e;d++){for(var b=1;b<g;b++){this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+"."+b),"mouseover",this.mouseoverDataTableCell,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+"."+b),"mouseout",this.mouseoutDataTableCell,false);this.addRemoveEvtListener(a,this.$(this.target+"-cX-DataTableCell."+d+"."+b),"click",this.clickDataTableCell,false)}}};this.scrollDataTable=function(a){return function(c){if(!c){c=window.event}a.removeMenus();a.cancelEvent(c);var b=a.$(a.target+"-cX-DataTableVer");if(b){if(c.wheelDelta>0){b.scrollTop+=100}else{b.scrollTop-=100}}return false}}(this);this.scrollTable=function(a){return function(g){if(!g){g=window.event}a.removeMenus();var j=a.$(a.target+"-cX-DataTable");var b=a.$(a.target+"-cX-DataTableVer");var f=a.$(a.target+"-cX-DataTableHor");if(j&&b&&f&&!a.resizingDataTableOn){var i=Math.ceil(f.scrollLeft/(f.scrollWidth/a.totalCols));var c=Math.ceil(b.scrollTop/(b.scrollHeight/a.totalRows));a.dataTableLastScrollLeft=f.scrollLeft;a.dataTableLastScrollTop=b.scrollTop;a.dataTableLastScrollWidth=f.scrollWidth;a.dataTableLastScrollHeight=b.scrollHeight;if(i!=a.startCol||c!=a.startRow){a.startCol=i;a.startRow=c;a.updateDataTable(false,false,false,true)}}return false}}(this);this.maximizeMinimizeTable=function(a){return function(i){if(!i){i=window.event}a.removeMenus();var d=a.$(a.target+"-cX-DataTable");var k=a.$(a.target+"-cX-DataFilter");var h=window.innerWidth;var c=window.innerHeight;var g=k&&a.activeAccordion?a.dataFilterWidth+10:0;var b=k?a.activeAccordion:false;var j,f;if(d){a.dataTableTarget=d;if(a.dataTableMaximized){if(!a.maximized){a.backgroundMask()}j=a.dataTableMaximized[2];f=a.dataTableMaximized[3];if(!a.maximized){document.documentElement.style.overflowX=a.dataTableMaximized[4];document.documentElement.style.overflowY=a.dataTableMaximized[5]}a.updateDataTableResizerDiv(false,a.dataTableMaximized[0],a.dataTableMaximized[1]);if(k&&a.activeAccordion){a.dataFilterHeight=a.dataTableMaximized[6];k.style.left=a.dataTableMaximized[7];b.style.height=a.dataTableMaximized[8]}delete (a.dataTableMaximized)}else{if(!a.maximized){a.backgroundMask([h,c])}a.dataTableMaximized=[a.dataTableLastWidth,a.dataTableLastHeight,parseInt(d.style.left),parseInt(d.style.top),document.body.style.overflowX,document.body.style.overflowY];if(!a.maximized){document.documentElement.style.overflowX="hidden";document.documentElement.style.overflowY="hidden"}j=-(a.height+3);f=0;a.updateDataTableResizerDiv(false,h-(6+g),c-6);if(k&&a.activeAccordion){a.dataTableMaximized.push(a.dataFilterHeight,k.style.left,b.style.height);a.dataFilterHeight=c-(a.heigthOffsetDataFilter()+4);k.style.left=(h-(a.width+a.dataFilterWidth+13))+"px";b.style.height=a.dataFilterHeight+"px"}}a.endDataTableResizerDiv();d=a.$(a.target+"-cX-DataTable");d.style.top=j+"px";d.style.left=f+"px"}return false}}(this);this.colorTable=function(a){return function(b){if(!b){b=window.event}a.removeMenus();a.colorDataTable=a.colorDataTable?false:true;a.updateDataTable();return false}}(this);this.filterResetTable=function(a){return function(b){if(!b){b=window.event}a.removeMenus();a.resetDataFilter(b);a.updateDataTable();return false}}(this);this.saveTable=function(a){return function(g){if(!g){g=window.event}a.removeMenus();var b=a.maxCols;var f=a.maxRows;var c=a.startCol;var i=a.startRow;a.maxCols=a.totalCols;a.maxRows=a.totalRows;a.startCol=0;a.startRow=0;var h=a.updateDataTable(false,false,true);a.exportToExcel(h);a.maxCols=b;a.maxRows=f;a.startCol=c;a.startRow=i;return false}}(this);this.dockUndockTable=function(a){return function(d){if(!d){d=window.event}a.removeMenus();var c=a.dataTableLastState&&a.dataTableLastState=="docked"?"undock":"dock";var b=a.getTargetEvent(d);if(c=="dock"){b.src=CanvasXpress.images.unpin;b.alt="Undock";b.title="Undock"}else{b.src=CanvasXpress.images.pin;b.alt="Dock";b.title="Dock"}a.moveDataTableDiv(c);return false}}(this);this.transposeDataTable=function(a){return function(b){if(!b){b=window.event}a.removeMenus();a.startRow=0;a.startCol=0;a.dataTableTransposed=a.dataTableTransposed?false:true;a.sortDataTableHead=false;a.updateDataTable(false,true,false,false,true);a.resizeDataTable();if(a.dataTableMaximized){a.$(a.target+"-cX-DataTable").style.top=-(a.height+3)+"px"}return false}}(this);this.minimizeTable=function(a){return function(b){if(!b){b=window.event}a.moveDataTableDiv("min");return false}}(this);this.maximizeTable=function(a){return function(b){if(!b){b=window.event}a.moveDataTableDiv("max");return false}}(this);this.hideTableNoAnimation=function(){var a=this.showFadeResizeMoveAnimation;this.showFadeResizeMoveAnimation=false;this.hideTable();this.showFadeResizeMoveAnimation=a;return false};this.hideTable=function(a){return function(b){if(!b){b=window.event}a.removeMenus();var c=a.$(a.target+"-cX-DataTable");if(c){a.showDataTable=false;a.moveDataTableDiv("hide");setTimeout(function(){a.hideUnhideDataTable(true);a.resetFade(c);a.resetDataTable(true)},500)}return false}}(this);this.networkUpdateTable=function(a){return function(c){if(!c){c=window.event}a.removeMenus();var b=a.getTargetEvent(c);a.networkShowDataTable=a.networkShowDataTable=="nodes"?"edges":"nodes";a.updateDataTable(false,true,false,true);return false}}(this);this.mousedownDataTableResizer=function(a){return function(d){if(!d){d=window.event}a.removeMenus();var b=d.target||d.srcElement;if(a.hasClass(b,"resizable")){var f=a.$(a.target+"-cX-DataTable");if(f){a.dataTableTarget=f;a.xMouseDown=d.clientX;a.yMouseDown=d.clientY;a.dataTableWidth=parseInt(a.dataTableTarget.style.width);a.dataTableHeight=parseInt(a.dataTableTarget.style.height);a.resizingDataTableOn=true}}return false}}(this);this.mousemoveDataTableHeader=function(a){return function(j){if(!j){j=window.event}var c=a.resizingDataTableColumnOn?a.dataTableColumnTarget:a.getTargetEvent(j);var n=a.adjustedCoordinates(j,c);var l=a.$(a.target+"-cX-DataTableHorImage");if(n&&l){if(a.resizingDataTableColumnOn){var b=a.dataTableColumnTarget.id.split(".");var g=parseInt(b[2]);var k=n.x-a.xMouseDown;var m=Math.max(a.colWidth,(a.dataTableColumnWidth[a.startCol+g]||a.colWidth)+k);a.dataTableColumnTarget.firstChild.style.width=m+"px";l.width+=k;l.style.maxWidth=l.width+"px";for(var h=a.startRow;h<a.startRow+a.totalRows;h++){var d=a.$(a.target+"-cX-DataTableCell."+h+"."+g);if(d){d.style.width=m+"px";d.firstChild.style.width=m+"px"}}a.dataTableColumnWidth[a.startCol+g]=m;a.xMouseDown=n.x;a.yMouseDown=n.y;document.body.style.cursor="col-resize"}else{var f=(c.offsetLeft+c.clientWidth)-n.x;if(f<5&&c.nodeName.toLowerCase()=="th"){c.style.cursor="col-resize"}else{c.style.cursor=a.isResizeDataTable(c,n)?"col-resize":"default"}}}return false}}(this);this.mousedownDataTableHeader=function(a){return function(d){if(!d){d=window.event}var b=a.getTargetEvent(d);b=b.nodeName.toLowerCase()=="th"||!a.isIE?b:b.parentNode;var c=a.adjustedCoordinates(d,b);if(c){if(a.isResizeDataTable(b,c)){a.dataTableColumnTarget=b;a.xMouseDown=c.x;a.yMouseDown=c.y;a.resizingDataTableColumnOn=true;document.body.style.cursor="col-resize"}}return false}}(this);this.isResizeDataTable=function(a,b){return(a.offsetLeft+a.offsetWidth)-b.x<(CanvasXpress.system.isIE?10:5)&&(a.nodeName.toLowerCase()=="th"||(CanvasXpress.system.isIE&&a.parentNode&&a.parentNode.nodeName.toLowerCase()=="th"))};this.getColumnsDataTableHeaderMenu=function(){var a=this.maxCols;var g=this.maxRows;var e=this.startCol;var j=this.startRow;var b=this.dataTableColumnHide;this.maxCols=this.totalCols;this.maxRows=0;this.startCol=0;this.startRow=0;this.dataTableColumnHide={};var h=this.updateDataTable(false,false,true);this.maxCols=a;this.maxRows=g;this.startCol=e;this.startRow=j;this.dataTableColumnHide=b;var k=[];for(var f=1;f<h[0].length;f++){k.push([h[0][f],this.dataTableColumnHide[h[0][f]]?"unchecked":"checked","hideUnhideDataTableColumn",[h[0][f]]])}return k};this.getColumnsDataTableHeaderFilterMenu=function(c,i){var a,k,j,h;if(this.graphType=="Network"){a=this.networkShowDataTable.replace(/s$/,"");k=this.networkShowDataTable;j=this.getFilteredNetworkData(k,true);h=this.getFilteredNetworkData(k)}else{switch(c){case"cxv":a="variable";k="vars";break;case"cxx":a="sample";k="smps";break;case"cxs":a="sample";k="smps";break;case"cxz":a="variable";k="vars";break}j=this.getSampleVariableData(k,true,i,c=="cxv",c=="cxs");h=this.getSampleVariableData(k,false,i,c=="cxv",c=="cxs")}var b=this.getKeys(j[i]["o"]);var g=this.getKeys(h[i]["o"]);if(j[i].t=="numeric"&&b[0]=="min"&&b[1]=="max"){b=[j[i]["o"]["min"],j[i]["o"]["max"]];g=[h[i]["o"]["min"],h[i]["o"]["max"]]}var g=j[i].t=="string"?this.createStringFilter(a,i,b,false,true,this.isSameObject(b,g)?false:g):this.createNumericFilter(a,i,b,false,true,this.isSameObject(b,g)?false:g);return[["-filter-",g]]};this.clickDataTableHeader=function(a){return function(l,f){if(!l){l=window.event}if(a.noSorting){return}if(!f){a.cancelEvent(l);f=a.getTargetEvent(l)}var b=a.target+"-cX-DataTableCell.0.0";if(f.tagName.match(/th/i)){f=f.firstChild}if(f.tagName.match(/^a$/i)){if(a.skipHeaderMouseout&&a.skipHeaderMouseout.id==this.id){a.removeMenus();return false}var o=a.maxCols;var w=a.maxRows;var j=a.startCol;var q=a.startRow;var u=a.dataTableColumnHide;a.maxCols=a.totalCols;a.maxRows=0;a.startCol=0;a.startRow=0;a.dataTableColumnHide={};var n=a.updateDataTable(false,false,true);a.maxCols=o;a.maxRows=w;a.startCol=j;a.startRow=q;a.dataTableColumnHide=u;var p=[];for(var k=1;k<n[0].length;k++){p.push([n[0][k],a.dataTableColumnHide[n[0][k]]?"unchecked":"checked","hideUnhideDataTableColumn",[n[0][k]]])}var h=[];h.push(["Sort Ascending","sortAsciiAsc","sortDataTableByColumn",["asc",f.parentNode]]);h.push(["Sort Descending","sortAsciiDesc","sortDataTableByColumn",["desc",f.parentNode]]);h.push(["-"]);h.push(["Columns","table",false,false,false,"getColumnsDataTableHeaderMenu",[]]);if(!a.graphType.match(/Candlestick|Venn|Genome|Video/)){h.push(["-"]);h.push(["Filter","funnel",false,false,false,"getColumnsDataTableHeaderFilterMenu",[f.parentNode.type,f.parentNode.innerText]])}var g=a.absoluteCoordinates(f);var r=a.absoluteCoordinates(a.$(a.target+"-cX-DataTable"));var t=a.absoluteCoordinates(a.$(a.target));a.addMenu(l,false,false,h,(g.x-r.x)+(r.x-t.x),g.y-(t.y-18),this);a.skipHeaderMouseout=this}else{if(f.className=="CanvasXpressTableCellSortDesc"){f.className="CanvasXpressTableCellSortAsc"}else{f.className="CanvasXpressTableCellSortDesc"}if(a.sortDataTableHead){if(a.sortDataTableHead.id!=f.id){var v=a.$(a.sortDataTableHead.id);if(v){if(f.parentNode.id==b){a.sortDataTableHead.id=a.target+"-cX-DataTableCellContent.0.0"}v.className="CanvasXpressTableCell"}}}a.removeMenus();a.sortDataTableHead=f;a.sortDataTable()}return false}}(this);this.mouseoverDataTableHeader=function(a){return function(b){if(!b){b=window.event}this.className="CanvasXpressTableCellHeadActive";this.firstChild.firstChild.className="CanvasXpressTableCellHeadActive";return false}}(this);this.mouseoutDataTableHeader=function(a){return function(b){if(!b){b=window.event}if(a.skipHeaderMouseout&&a.skipHeaderMouseout.id==this.id){return false}else{this.className="CanvasXpressTableCellHead";this.firstChild.firstChild.className="CanvasXpressTableCellHead"}return false}}(this);this.mouseoverDataTableCell=function(a){return function(b){if(!b){b=window.event}this.className="CanvasXpressTableCellActive";if(a.colorDataTable&&this.style.background){this.style.background=a.removeColorTransparency(this.style.background)}return false}}(this);this.mouseoutDataTableCell=function(a){return function(b){if(!b){b=window.event}this.className="CanvasXpressTableCell";if(a.colorDataTable&&this.style.background){this.style.background=a.addColorTransparency(this.style.background,a.colorDataTableTransparency)}return false}}(this);this.clickDataTableCell=function(a){return function(b){if(!b){b=window.event}a.removeMenus();return false}}(this);this.hideUnhideDataTableColumn=function(a){if(this.dataTableColumnHide[a]){delete (this.dataTableColumnHide[a])}else{this.dataTableColumnHide[a]=true}this.updateDataTable(false,false,false,true)};this.sortDataTableByColumn=function(b,a){if(b=="asc"){a.className="CanvasXpressTableCellSortDesc"}else{a.className="CanvasXpressTableCellSortAsc"}this.sortDataTableHead=a;this.clickDataTableHeader(false,a)};this.setDataTableDimensions=function(d,k){var b=0;var p=0;var e=0;var l=false;var j=function(){for(var a=0;a<d.w.grps.length;a++){e+=d.w.grps[a].length}return e};if(!d){d=this.data}if(!this.dataTableColumnHide){this.dataTableColumnHide={}}var s=0;if(d.x){for(var h in d.x){if(!this.dataTableColumnHide[h]){s++}}}var m=0;if(d.z){for(var h in d.z){if(!this.dataTableColumnHide[h]){m++}}}var w=this.getDataTableDimensions();if(w[0]!=this.maxRows||w[1]!=this.maxCols){this.initialMaxRows=this.maxRows;this.initialMaxCols=this.maxCols}if(this.graphType=="Network"){var q=this.getAllNetworkAttributes(d);b=this.dataTableTransposed?1+d[this.networkShowDataTable].length:1+q[1];p=this.dataTableTransposed?1+q[1]:1+d[this.networkShowDataTable].length}else{if(this.graphType=="Genome"){b=1;p=1}else{if(this.graphType=="Venn"){var u=this.getVennCompartments(d);b=this.dataTableTransposed?1+u[1]:2;p=this.dataTableTransposed?2:1+u[1]}else{if(this.graphType=="Correlation"){b=this.correlationAxis=="samples"?1+d.y.smps.length:1+d.y.vars.length;p=b}else{if(this.graphType=="Candlestick"){if(d.y){b=this.dataTableTransposed?1+(d.y.smps.length*d.y.vars.length):6;p=this.dataTableTransposed?6:1+(d.y.smps.length*d.y.vars.length)}else{if(d.market){b=this.dataTableTransposed?1+(d.market.smps.length*d.market.vars.length):6;p=this.dataTableTransposed?6:1+(d.market.smps.length*d.market.vars.length)}}}else{if(d.y&&d.y.vars&&d.y.smps){b=this.dataTableTransposed?1+m+d.y.smps.length:1+s+d.y.vars.length;p=this.dataTableTransposed?1+s+d.y.vars.length:1+m+d.y.smps.length}else{if(d.w&&d.w.vars&&d.w.grps){e=j();b=this.dataTableTransposed?1+m+e:1+s+d.w.vars.length;p=this.dataTableTransposed?1+s+d.w.vars.length:1+m+e}}}}}}}if(this.maxRows>b){this.initialMaxRows=this.maxRows;this.maxRows=b}if(this.maxCols>p){this.initialMaxCols=this.maxCols;this.maxCols=p}if(this.totalRows==null||this.totalCols==null){this.totalRows=b;this.totalCols=p}else{if(k||b!=this.totalRows||p!=this.totalCols||w[0]!=this.maxRows||w[1]!=this.maxCols||w[2]!=this.rowHeight||w[3]!=this.colWidth){this.totalRows=b;this.totalCols=p;l=true}else{this.totalRows=b;this.totalCols=p;if(this.showDataTable){this.hideUnhideDataTable()}}}this.dataTableTotalHeight=this.rowHeight/2;for(var h=0;h<this.totalRows;h++){this.dataTableTotalHeight+=(this.setDataTableRowHeight(h)+8)}this.dataTableRowsHeight=this.rowHeight/2;for(var h=this.startRow;h<this.startRow+this.maxRows;h++){this.dataTableRowsHeight+=(this.setDataTableRowHeight(h)+8)}this.dataTableTotalWidth=-(this.colWidth+12);for(var h=0;h<this.totalCols;h++){this.dataTableTotalWidth+=(this.setDataTableColumnWidth(h)+12)}this.dataTableColsWidth=-(this.colWidth+12);for(var h=this.startCol;h<this.startCol+this.maxCols;h++){this.dataTableColsWidth+=(this.setDataTableColumnWidth(h)+12)}if(l){this.resetDataTable(true,w)}};this.setDataTableColumnWidth=function(b,a){if(!this.dataTableColumnWidth[b]){this.dataTableColumnWidth[b]=this.colWidth}else{if(a){this.dataTableColumnWidth[b]=Math.max(a,this.colWidth)}}return this.dataTableColumnWidth[b]};this.setDataTableRowHeight=function(a,b){if(!this.dataTableRowHeight[a]){this.dataTableRowHeight[a]=this.rowHeight}else{if(b){this.dataTableRowHeight[a]=Math.max(b,this.rowHeight)}}return this.dataTableRowHeight[a]};this.getAllNetworkAttributes=function(c){var b=this.getNetworkData(this.networkShowDataTable,true);var d=this.getKeys(b).length;return[b,d]};this.getVennCompartments=function(c){var b={};var d=0;if(c.venn&&c.venn.data){for(var a in c.venn.data){b[a]=1;d++}}return[b,d]};this.getDataTableDimensions=function(){var f=0;var i=0;var e=0;var b=0;var d=this.$(this.target+"-cX-DataTableTable");var g=this.$(this.target+"-cX-DataTableCell.0.0");if(d){var a=d.childNodes[0].rows;if(a){f=a.length;i=a[0].cells.length;e=g&&g.firstChild&&g.firstChild.style?parseInt(g.firstChild.style.height):0;b=g&&g.firstChild&&g.firstChild.style?parseInt(g.firstChild.style.width):0}}return[f,i,e,b]};this.resetDataTable=function(b,a){this.addRemoveDataTableListeners("removeEvtListener",a);this.removeTarget(this.target+"-cX-DataTable");this.addDataTableDiv(false,b)};this.rebuildDataTable=function(b,a){this.resetDataTable()};this.hideUnhideDataTable=function(a){if(this.initialMaxRows){this.maxRows=this.initialMaxRows}if(this.initialMaxCols){this.maxCols=this.initialMaxCols}var b=this.$(this.target+"-cX-DataTable");if(b){if(a==true){b.style.display="none"}else{b.style.display="block"}}};this.resizeDataTable=function(){var g=this.$(this.target+"-cX-DataTableContainer");var d=this.$(this.target+"-cX-DataTableVer");var f=this.$(this.target+"-cX-DataTableHor");if(g&&d&&f){var b=0;this.maxCols=0;for(var e=this.startCol;e<this.totalCols;e++){b+=this.dataTableColumnWidth[e]+8;if(parseInt(g.style.width)<b){this.maxCols++;break}else{this.maxCols++}}if(b<parseInt(g.style.width)&&this.startCol>0){for(var e=this.startCol;e>=0;e--){if(b+this.dataTableColumnWidth[e]+8<parseInt(g.style.width)){b+=this.dataTableColumnWidth[e]+8;this.maxCols++;this.startCol--}else{break}}}if(parseInt(g.style.width)>this.dataTableTotalWidth){this.maxCols=(this.totalCols-this.startCol)}this.maxCols=Math.max(3,Math.min(this.maxCols,(this.totalCols-this.startCol)));var a=0;this.maxRows=0;for(var e=this.startRow;e<this.totalRows;e++){a+=this.dataTableRowHeight[e]+4;if(parseInt(g.style.height)<a){this.maxRows++;break}else{this.maxRows++}}if(a<parseInt(g.style.height)&&this.startRow>0){for(var e=this.startRow;e>=0;e--){if(a+this.dataTableRowHeight[e]+4<parseInt(g.style.height)){a+=this.dataTableRowHeight[e]+4;this.maxRows++;this.startRow--}else{break}}}if(parseInt(g.style.height)>this.dataTableTotalHeight){this.totalRows=(this.totalRows-this.startRow)}this.maxRows=Math.max(3,Math.min(this.maxRows,(this.totalRows-this.startRow)));this.updateDataTable(false,true,false,true);d=this.$(this.target+"-cX-DataTableVer");f=this.$(this.target+"-cX-DataTableHor");if(d&&f){if(!CanvasXpress.system.isIE){d.scrollHeight=this.dataTableLastScrollHeight}d.scrollTop=this.dataTableLastScrollTop?this.dataTableLastScrollTop:d.scrollTop;if(!CanvasXpress.system.isIE){f.scrollWidth=this.dataTableLastScrollWidth}f.scrollLeft=this.dataTableLastScrollLeft?this.dataTableLastScrollLeft:f.scrollLeft}if(this.dataTableLastState=="docked"){this.resizeViewportSouth(true)}}};this.sortDataTable=function(){this.sortDir=this.sortDataTableHead.className=="CanvasXpressTableCellSortDesc"?"descending":"ascending";var a=this.sortDataTableHead.innerText?this.sortDataTableHead.innerText:this.sortDataTableHead.textContent;if(this.graphType=="Network"){if(this.dataTableTransposed){if(this.sortDataTableHead.type=="cxb"){this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}else{this.sortNetworkIndices(a)}}else{this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}}else{if(this.graphType=="Genome"){this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}else{if(this.graphType=="Venn"){this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}else{if(this.graphType=="Correlation"){if(this.correlationAxis=="samples"){if(this.sortDataTableHead.type=="cxb"){this.sortSamples()}else{this.sortSamples(false,false,a,"cor",true);this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false}}else{if(this.sortDataTableHead.type=="cxb"){this.sortVariables()}else{this.sortVariables(false,false,a,"cor",true);this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false}}}else{if(this.graphType=="Candlestick"){this.sortDataTableHead.className="CanvasXpressTableCell";this.sortDataTableHead=false;return}else{if(this.data.y.vars&&this.data.y.smps){if(this.dataTableTransposed){if(this.sortDataTableHead.type=="cxx"){this.sortSamplesByCategory([a])}else{if(this.sortDataTableHead.type=="cxv"){this.sortSamplesByVariable(a)}else{if(this.sortDataTableHead.type=="cxb"){this.sortSamples()}}}}else{if(this.sortDataTableHead.type=="cxz"){this.sortVariablesByCategory([a])}else{if(this.sortDataTableHead.type=="cxs"){this.sortVariablesBySample(a)}else{if(this.sortDataTableHead.type=="cxb"){this.sortVariables()}}}}}}}}}}this.updateDataTable(false,true,false,false,true)};this.getDataClassAsArray=function(H,g,X,M,J,h){var u=0;var t=0;var G=0;var A=0;var S=[];var T=[];var U=[];var D=[];var C=[];var P=[];var I=this.meta.data;var e=this.isGroupedData;this.isGroupedData=false;var n=function(k,l,b,q){if(l.hasOwnProperty(k)){return l[k]!=null?l[k]:""}else{if(b[0][k]&&b[0][k].hasOwnProperty("r")){var m=b[0][k]["r"];for(var f=0;f<q[m].length;f++){var d=q[m][f];if(l.hasOwnProperty(d)){l=l[d]}else{return""}}if(l.hasOwnProperty(k)){return l[k]!=null?l[k]:""}}return""}};if(g==null){g=0}if(X==null){X=999}if(M==null){M=0}if(J==null){J=999}if(this.graphType=="Network"){var V=this.getAllNetworkAttributes(H);D.push("");C.push("cxb");P.push(false);if(this.dataTableTransposed){for(var O in V[0]){if(t<X&&A>=g&&!this.dataTableColumnHide[O]){D.push(O);C.push("cxx");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);for(var O=0;O<H[this.networkShowDataTable].length;O++){if(!H[this.networkShowDataTable][O].hide){if(u<J&&G>=M){t=0;A=0;D=[O+1];C=["cxz"];P=[false];for(var N in V[0]){if(t<X&&A>=g&&!this.dataTableColumnHide[N]){var z=n(N,H[this.networkShowDataTable][O],V,this[this.networkShowDataTable+"Properties"]);var F=I[this.networkShowDataTable][N].type.match(/String|Object/)?I[this.networkShowDataTable][N].colors[I[this.networkShowDataTable][N].order[z]]:this.getColorForValue(I[this.networkShowDataTable][N].colorBrew,z);D.push(z);C.push("cxy");P.push(F);t++}A++}S.push(D);T.push(C);U.push(P);u++}G++}}}else{for(var O=0;O<H[this.networkShowDataTable].length;O++){if(!H[this.networkShowDataTable][O].hide){if(t<X&&A>=g&&!this.dataTableColumnHide[O+1]){D.push(O+1);C.push("cxz");P.push(false);t++}A++}}S.push(D);T.push(C);U.push(P);for(var O in V[0]){if(u<J&&G>=M){t=0;A=0;D=[O];C=["cxx"];P=[false];for(var N=0;N<H[this.networkShowDataTable].length;N++){if(!H[this.networkShowDataTable][N].hide){if(t<X&&A>=g&&!this.dataTableColumnHide[N+1]){var z=n(O,H[this.networkShowDataTable][N],V,this[this.networkShowDataTable+"Properties"]);var F=I[this.networkShowDataTable][O].type.match(/String|Object/)?I[this.networkShowDataTable][O].colors[I[this.networkShowDataTable][O].order[z]]:this.getColorForValue(I[this.networkShowDataTable][O].colorBrew,z);D.push(z);C.push("cxy");P.push(F);t++}A++}}S.push(D);T.push(C);U.push(P);u++}G++}}}else{if(this.graphType=="Genome"){S=[["Not implemented"]];T=[["cxb"]]}else{if(this.graphType=="Venn"){var z=this.getVennCompartments(H);D.push("");C.push("cxb");P.push(false);if(this.dataTableTransposed){D.push("No");C.push("cxz");P.push(false);S.push(D);T.push(C);U.push(P);for(var O in z[0]){if(u<J&&G>=M){t=0;A=0;D=[O];C=["cxx"];P=[false];if(t<X&&A>=g){D.push(H.venn.data[O]);C.push("cxy");P.push(false);t++}A++;S.push(D);T.push(C);U.push(P);u++}G++}}else{for(var O in z[0]){if(t<X&&A>=g){D.push(O);C.push("cxx");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);if(u<J&&G>=M){t=0;A=0;D=["No"];C=["cxz"];P=[false];for(var O in z[0]){if(t<X&&A>=g){D.push(H.venn.data[O]);C.push("cxy");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P)}}}else{if(this.graphType=="Correlation"){var y=this.correlationAxis=="samples"?H.y.smps:H.y.vars;var p=this.correlationAxis=="samples"?this.smpIndices:this.varIndices;var w=this.correlationAxis=="samples"?"cxs":"cxv";D.push("");C.push("cxb");P.push(false);for(var O=0;O<y.length;O++){if(t<X&&A>=g&&!this.dataTableColumnHide[h?y[p[O]]:y[O]]){D.push(h?y[p[O]]:y[O]);C.push(w);P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);for(var O=0;O<y.length;O++){if(u<J&&G>=M){t=0;A=0;D=[h?y[p[O]]:y[O]];C=[w];P=[false];for(var N=0;N<y.length;N++){if(t<X&&A>=g&&!this.dataTableColumnHide[h?y[p[N]]:y[N]]){if(H.y.cor){D.push(h?H.y.cor[p[O]][p[N]]:H.y.cor[O][N])}else{D.push(O==N?1:H.y.data)}C.push("cxy");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);u++}G++}}else{if(this.graphType=="Candlestick"){var V=["open","low","high","close","volume"];D.push("");C.push("cxb");P.push(false);if(this.dataTableTransposed){for(var O=0;O<H.y.vars.length;O++){for(var N=0;N<V.length;N++){var K=H.y.vars.length>1?H.y.vars[O]+":"+V[N]:V[N];if(t<X&&A>=g&&!this.dataTableColumnHide[K]){D.push(K);C.push("cxv");P.push(false);t++}A++}}S.push(D);T.push(C);U.push(P);for(var O=0;O<H.y.smps.length;O++){if(u<J&&G>=M){t=0;A=0;D=[H.y.smps[O]];C=["cxs"];P=[false];for(var N=0;N<H.y.vars.length;N++){for(var L=0;L<V.length;L++){var K=H.y.vars.length>1?H.y.vars[N]+":"+V[L]:V[L];if(t<X&&A>=g&&!this.dataTableColumnHide[K]){D.push(H.y[V[L]][N][O]!=null?H.y[V[L]][N][O]:H.y[V[L]][O]);C.push("cxy");P.push(false);t++}A++}}S.push(D);T.push(C);U.push(P);u++}G++}}else{for(var O=0;O<H.y.smps.length;O++){if(t<X&&A>=g&&!this.dataTableColumnHide[H.y.smps[O]]){D.push(H.y.smps[O]);C.push("cxs");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);for(var O=0;O<H.y.vars.length;O++){for(var N=0;N<V.length;N++){if(u<J&&G>=M){t=0;A=0;var K=H.y.vars.length>1?H.y.vars[O]+":"+V[N]:V[N];D=[K];C=["cxv"];P=[false];for(var L=0;L<H.y.smps.length;L++){if(t<X&&A>=g&&!this.dataTableColumnHide[H.y.smps[L]]){D.push(H.y[V[N]][O][L]!=null?H.y[V[N]][O][L]:H.y[V[N]][L]);C.push("cxy");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);u++}G++}}}}else{if(H.y.vars&&H.y.smps){var R=h?this.varIndices.length:H.y.vars.length;var Q=h?this.smpIndices.length:H.y.smps.length;var E=H.x?this.sortObject(H.x):false;var B=H.z?this.sortObject(H.z):false;D.push("");C.push("cxb");P.push(false);if(this.dataTableTransposed){if(H.x){for(var O=0;O<E.length;O++){if(t<X&&A>=g&&!this.dataTableColumnHide[E[O]]){D.push(E[O]);C.push("cxx");P.push(I.x[E[O]].type);t++}A++}}for(var O=0;O<R;O++){if(t<X&&A>=g&&!this.dataTableColumnHide[h?H.y.vars[this.varIndices[O]]:H.y.vars[O]]){D.push(h?H.y.vars[this.varIndices[O]]:H.y.vars[O]);C.push("cxv");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);if(H.z){for(var O=0;O<B.length;O++){if(u<J&&G>=M){t=0;A=0;D=[B[O]];C=["cxz"];P=[I.z[B[O]].type];if(H.x){for(var N=0;N<E.length;N++){if(t<X&&A>=g&&!this.dataTableColumnHide[E[N]]){D.push("");C.push("cxb");P.push(false);t++}A++}}for(var N=0;N<R;N++){if(t<X&&A>=g&&!this.dataTableColumnHide[h?H.y.vars[this.varIndices[N]]:H.y.vars[N]]){var W=h?this.getMetadataValue(this.varIndices[N],"z",B[O]):this.getMetadataValue(N,"z",B[O]);var x=I.z[B[O]].type=="String"?I.z[B[O]].colors[I.z[B[O]].order[W]]:this.getColorForValue(I.z[B[O]].colorBrew,W);D.push(W);C.push("cxz");P.push(x);t++}A++}S.push(D);T.push(C);U.push(P);u++}G++}}for(var O=0;O<Q;O++){if(u<J&&G>=M){t=0;A=0;D=[h?H.y.smps[this.smpIndices[O]]:H.y.smps[O]];C=["cxs"];P=[false];if(H.x){for(var N=0;N<E.length;N++){if(t<X&&A>=g&&!this.dataTableColumnHide[E[N]]){var W=h?this.getMetadataValue(this.smpIndices[O],"x",E[N]):this.getMetadataValue(O,"x",E[N]);var x=I.x[E[N]].type=="String"?I.x[E[N]].colors[I.x[E[N]].order[W]]:this.getColorForValue(I.x[E[N]].colorBrew,W);D.push(W);C.push("cxx");P.push(x);t++}A++}}for(var N=0;N<R;N++){if(t<X&&A>=g&&!this.dataTableColumnHide[h?H.y.vars[this.varIndices[N]]:H.y.vars[N]]){if(h){D.push(H.y.data[this.varIndices[N]][this.smpIndices[O]]!=null?H.y.data[this.varIndices[N]][this.smpIndices[O]]:H.y.data[this.smpIndices[O]])}else{D.push(H.y.data[N][O]!=null?H.y.data[N][O]:H.y.data[O])}C.push("cxy");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);u++}G++}}else{if(H.z){for(var O=0;O<B.length;O++){if(t<X&&A>=g&&!this.dataTableColumnHide[B[O]]){D.push(B[O]);C.push("cxz");P.push(I.z[B[O]].type);t++}A++}}for(var O=0;O<Q;O++){if(t<X&&A>=g&&!this.dataTableColumnHide[h?H.y.smps[this.smpIndices[O]]:H.y.smps[O]]){D.push(h?H.y.smps[this.smpIndices[O]]:H.y.smps[O]);C.push("cxs");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);if(H.x){for(var O=0;O<E.length;O++){if(u<J&&G>=M){t=0;A=0;D=[E[O]];C=["cxx"];P=[I.x[E[O]].type];if(H.z){for(var N=0;N<B.length;N++){if(t<X&&A>=g&&!this.dataTableColumnHide[B[N]]){D.push("");C.push("cxb");P.push(false);t++}A++}}for(var N=0;N<Q;N++){if(t<X&&A>=g&&!this.dataTableColumnHide[h?H.y.smps[this.smpIndices[N]]:H.y.smps[N]]){var W=h?this.getMetadataValue(this.smpIndices[N],"x",E[O]):this.getMetadataValue(N,"x",E[O]);var x=I.x[E[O]].type=="String"?I.x[E[O]].colors[I.x[E[O]].order[W]]:this.getColorForValue(I.x[E[O]].colorBrew,W);D.push(W);C.push("cxx");P.push(x);t++}A++}S.push(D);T.push(C);U.push(P);u++}G++}}for(var O=0;O<R;O++){if(u<J&&G>=M){t=0;A=0;D=[h?H.y.vars[this.varIndices[O]]:H.y.vars[O]];C=["cxv"];P=[false];if(H.z){for(var N=0;N<B.length;N++){if(t<X&&A>=g&&!this.dataTableColumnHide[B[N]]){var W=h?this.getMetadataValue(this.varIndices[O],"z",B[N]):this.getMetadataValue(O,"z",B[N]);var x=I.z[B[N]].type=="String"?I.z[B[N]].colors[I.z[B[N]].order[W]]:this.getColorForValue(I.z[B[N]].colorBrew,W);D.push(W);C.push("cxz");P.push(x);t++}A++}}for(var N=0;N<Q;N++){if(t<X&&A>=g&&!this.dataTableColumnHide[h?H.y.smps[this.smpIndices[N]]:H.y.smps[N]]){if(h){D.push(H.y.data[this.varIndices[O]][this.smpIndices[N]]!=null?H.y.data[this.varIndices[O]][this.smpIndices[N]]:H.y.data[this.smpIndices[N]])}else{D.push(H.y.data[O][N]!=null?H.y.data[O][N]:H.y.data[N])}C.push("cxy");P.push(false);t++}A++}S.push(D);T.push(C);U.push(P);u++}G++}}}}}}}}this.isGroupedData=e;return[S,T,U]};this.updateDataTable=function(g,c,d,h,b){if(this.dataTableLastState&&this.dataTableLastState=="docked"&&h){this.dataTableLastX=0;this.dataTableLastY=0}if(!this.dataTableLastState){this.dataTableLastState="free"}if(!g){g=this.data}else{g=this.getUngroupedDataObject(g)}if(!d){this.setDataTableDimensions(g,c)}var a=this.getDataClassAsArray(g,this.startCol,this.maxCols,this.startRow,this.maxRows,true);if(d){return a[0]}else{this.loadDataTableValues(a[0],a[1],a[2],h,b);if(this.dataTableMaximized){this.$(this.target+"-cX-DataTable").style.top=-(this.height+3)+"px"}}};this.loadDataTableValues=function(F,G,H,A,x){var r=this.$(this.target+"-cX-DataTable");if(r){var v=this.setDataTableRowHeight(0);var g=this.setDataTableColumnWidth(0);for(var C=0;C<this.maxRows;C++){for(var B=0;B<this.maxCols;B++){var y=this.target+"-cX-DataTableCell."+C+"."+B;var I=this.target+"-cX-DataTableCellContent."+C+"."+B;var k=this.target+"-cX-DataTableCellContentA."+C+"."+B;var E=this.$(y);if(E){if(E.hasChildNodes()){while(E.childNodes.length>=1){E.removeChild(E.firstChild)}}var h=this.$cX("div",{id:I,className:"CanvasXpressTableCell ",title:"",alt:""});if(C==0){var J=this.$cX("a",{id:k,className:"CanvasXpressTableCellHead ",href:"#"});h.appendChild(J)}h.appendChild(document.createTextNode(""));if(B==0){h.style.height=v+"px";E.style.height=v+"px"}if(C==0){h.style.width=g+"px";E.style.width=g+"px"}E.style.background="";E.appendChild(h)}}}var p=this.startRow;for(var C=0;C<F.length;C++){var D=this.startCol;for(var B=0;B<F[C].length+this.startCol;B++){var y=this.target+"-cX-DataTableCell."+C+"."+B;var I=this.target+"-cX-DataTableCellContent."+p+"."+D;var k=this.target+"-cX-DataTableCellContentA."+p+"."+D;var E=this.$(y);if(E){if(E.hasChildNodes()){while(E.childNodes.length>=1){E.removeChild(E.firstChild)}}var K=F[C][B]!=null?F[C][B]:"";var f=G[C][B]!=null?G[C][B]:"";var m=H[C][B];if(!isNaN(K)&&f=="cxy"&&this.graphType!="Network"){K=this.bestFormatNumber(K)}var h=this.$cX("div",{id:I,className:"CanvasXpressTableCell ",title:K,alt:K,type:f});if(C==0){var J=this.$cX("a",{id:k,className:"CanvasXpressTableCellHead ",href:"#"});h.appendChild(J)}h.appendChild(document.createTextNode(K));if(C!=0){h.style.height=this.setDataTableRowHeight(p)+"px";E.style.height=this.setDataTableRowHeight(p)+"px"}else{h.style.height=this.setDataTableRowHeight(0)+"px";E.style.height=this.setDataTableRowHeight(0)+"px"}if(B!=0){h.style.width=this.setDataTableColumnWidth(D)+"px";E.style.width=this.setDataTableColumnWidth(D)+"px"}else{h.style.width=this.setDataTableColumnWidth(0)+"px";E.style.width=this.setDataTableColumnWidth(0)+"px"}E.appendChild(h);if(this.colorDataTable){if(m&&C>0&&B>0){E.style.background=this.addColorTransparency(m,this.colorDataTableTransparency)}else{if(C>0&&B>0){E.style.background=""}else{h.alt=K+" ("+m+")";h.title=K+" ("+m+")";h.ftype=m}}}D++}}p++}if(this.sortDataTableHead){var u=this.$(this.sortDataTableHead.id);var l=this.$(this.target+"-cX-DataTableCell.0.0").firstChild;var o=this.target+"-cX-DataTableCellContent.0.0";if(u){u.className=this.sortDataTableHead.className}if(l){l.className=this.sortDataTableHead.id==o?this.sortDataTableHead.className:"CanvasXpressTableCell"}}this.activeTarget=r;r.style.display="block"}};this.moveDataTableDiv=function(e){var n=this.$(this.target+"-cX-DataTable");if(n){var p,r,j;var a=this.$(this.remoteParentId+"-canvasXpressRemoteWindow");var g=this.$("north-container-"+this.target);var c=this.$("west-container-"+this.target);var m=this.$("east-container-"+this.target);var o=this.$("south-container-"+this.target);var q=this.$("south-wrapper-"+this.target);var b=64;var f=0;var i=this.showFadeResizeMoveAnimation?500:0;var k=this;if(c&&m&&o&&q){if(e&&e=="dock"){this.dataTableLastState="docked";this.dataTableLastHeight=n.clientHeight;this.dataTableLastX=n.offsetLeft;this.dataTableLastY=n.offsetTop;r=Math.max(n.clientWidth,parseInt(c.style.width)+parseInt(m.style.width)+this.meta.canvas.ctx.canvas.width)+2;j=parseInt(g.style.height)+this.meta.canvas.ctx.canvas.height+n.clientHeight+2;if(a){this.resizeMove(a,0,0,r+f,j+b)}this.resizeMove(o,0,0,r,n.clientHeight+2);this.resizeMove(q,0,0,r,n.clientHeight+2);this.resizeMove(n,0,0,n.clientWidth,n.clientHeight)}else{if(e&&e=="hide"){delete (this.dataTableLastState);delete (this.dataTableLastX);delete (this.dataTableLastY);r=parseInt(c.style.width)+parseInt(m.style.width)+this.meta.canvas.ctx.canvas.width;j=parseInt(g.style.height)+this.meta.canvas.ctx.canvas.height;if(a){this.resizeMove(a,0,0,r+f,j+b)}this.fade(n);this.resizeMove(q,0,0,r,0);this.resizeMove(o,0,0,r,0)}else{if(e&&(e=="max"||e=="release"||e=="undock")){this.dataTableLastState="free";r=parseInt(c.style.width)+parseInt(m.style.width)+this.meta.canvas.ctx.canvas.width;j=parseInt(g.style.height)+this.meta.canvas.ctx.canvas.height;if(a){this.resizeMove(a,0,0,r+r,j+b)}if(e=="max"||e=="undock"){this.resizeMove(n,parseInt(this.dataTableLastX),parseInt(this.dataTableLastY),n.clientWidth,parseInt(this.dataTableLastHeight)||(this.dataTableRowsHeight+42))}this.resizeMove(q,0,0,r,0);this.resizeMove(o,0,0,r,0)}else{return}}}}}};this.updateDataTableResizerDiv=function(g,l,k){if(!g){g=window.event}if(g&&(l==null||k==null)){l=Math.abs(this.dataTableWidth)-(this.xMouseDown-g.clientX);k=Math.abs(this.dataTableHeight)-(this.yMouseDown-g.clientY)}if(this.dataTableTarget&&this.dataTableTarget.style){var i=this.$(this.target+"-cX-DataTable");var j=this.$(this.target+"-cX-DataTableContainer");var a=this.$(this.target+"-cX-DataTableTableMask");var n=this.$(this.target+"-cX-DataTableVer");var b=this.$(this.target+"-cX-DataTableHor");var o=this.$(this.target+"-cX-DataTableToolbar");var f=52;var p=46;if(i&&j&&a&&n&&b&&o){this.dataTableTarget.style.width=CanvasXpress.system.isIE?Math.max(0,l)+"px":l+"px";j.style.width=CanvasXpress.system.isIE?Math.max(0,l)+"px":l+"px";a.style.width=CanvasXpress.system.isIE?Math.max(0,(l-f))+"px":(l-f)+"px";b.style.width=CanvasXpress.system.isIE?Math.max(0,(l-f))+"px":(l-f)+"px";o.style.width=CanvasXpress.system.isIE?Math.max(0,l)+"px":l+"px";this.dataTableTarget.style.height=CanvasXpress.system.isIE?Math.max(0,k)+"px":k+"px";j.style.height=CanvasXpress.system.isIE?Math.max(0,(k-20))+"px":(k-20)+"px";a.style.height=CanvasXpress.system.isIE?Math.max(0,(k-p))+"px":(k-p)+"px";n.style.height=CanvasXpress.system.isIE?Math.max(0,(k-p))+"px":(k-p)+"px";this.dataTableLastWidth=l;this.dataTableLastHeight=k}}};this.endDataTableResizerDiv=function(a){if(this.dataTableTarget!=null){this.resizeDataTable();this.xMouseDown=null;this.yMouseDown=null;this.dataTableWidth=null;this.dataTableHeight=null;this.dataTableTarget=false;this.resizingDataTableOn=false}};this.endDataTableColumnResize=function(a){that=this;this.xMouseDown=null;this.yMouseDown=null;this.resizingDataTableColumnOn=false;this.dataTableColumnTarget=false;document.body.style.cursor="default";this.noSorting=true;setTimeout(function(){that.noSorting=false},200)};this.initializeDataTableEvents=function(){this.addDataTableDiv()};this.initializeDataTableEvents()};CanvasXpress.prototype.initCanvasResizerEvents=function(){this.addCanvasResizerDiv=function(a){if(a){if(this.$("canvasXpressCanvasResize")){return}}else{if(this.$(this.target+"canvasXpressCanvasResize")){return}}var b=this.$cX("div",{id:a?"canvasXpressCanvasResize":this.target+"canvasXpressCanvasResize",className:"CanvasXpressCanvasResizer"},{left:"0px",top:"0px",width:"0.5px",height:"0.5px",position:"absolute",display:"none",zIndex:100001});if(a){b.style.opacity=0.5;b.style.filter="alpha(opacity = 50)";b.style.backgroundColor=this.resizerBackgroundColor}if(a){document.body.appendChild(b);return b}else{this.meta.canvas.ctx.canvas.parentNode.appendChild(b)}};this.isCanvasResize=function(c){if(this.resizable){if(!c){c=window.event}var b=this.adjustedCoordinates(c);if(b){var a=b.x;var d=b.y;if(a>this.width-18&&this.resizableX&&d>this.height-18&&this.resizableY){this.resizeCanvasCursorShow="se-resize";return true}else{if(a>this.width-18&&this.resizableX&&d>20){this.resizeCanvasCursorShow="e-resize";return true}else{if(d>this.height-18&&this.resizableY){this.resizeCanvasCursorShow="s-resize";return true}else{this.resizeCanvasCursorShow=false;return false}}}}}};this.updateCanvasResizerCursor=function(d){if(this.resizable){if(!d){d=window.event}var b=this.$(this.target2);if(b){var c=this.adjustedCoordinates(d);if(c){var a=c.x;var f=c.y;if(a>this.width-18&&this.resizableX&&f>this.height-18&&this.resizableY){b.style.cursor="se-resize";this.resizeCanvasCursorShow="se-resize"}else{if(a>this.width-18&&this.resizableX&&f>20){b.style.cursor="e-resize";this.resizeCanvasCursorShow="e-resize"}else{if(f>this.height-18&&this.resizableY){b.style.cursor="s-resize";this.resizeCanvasCursorShow="s-resize"}else{if(!this.movingOn){b.style.cursor="default";this.resizeCanvasCursorShow=false}}}}}}}};this.updateCanvasResizer=function(f){if(this.resizingCanvasOn&&this.resizeCanvasCursorShow){document.body.style.cursor=this.resizeCanvasCursorShow;var c=this.$(this.target+"canvasXpressCanvasResize");var a=this.$("canvasXpressCanvasResize");var b=this.adjustedCoordinates(f);var d=this.relativeCoordinates(this.meta.canvas.ctx.canvas);if(c&&b&&d){if(this.resizeCanvasCursorShow=="se-resize"){w=b.x;h=b.y}else{if(this.resizeCanvasCursorShow=="e-resize"){w=b.x;h=this.height}else{if(this.resizeCanvasCursorShow=="s-resize"){w=this.width;h=b.y}}}if(!a){a=this.addCanvasResizerDiv(true)}this.preventSelection();dx=b.x-this.meta.canvas.ctx.canvas.width;dy=b.y-this.meta.canvas.ctx.canvas.height;c.style.width=w+"px";c.style.height=h+"px";c.style.display="block";a.style.left=d.x+"px";a.style.top=d.y+"px";a.style.width=w+"px";a.style.height=h+"px";a.style.display="block";CanvasXpress.resizing=true}}};this.showMask=function(){var a=this.$(this.target+"canvasXpressCanvasResize");if(a){a.className="CanvasXpressCanvasResizer"+this.loadingImage;a.style.width=this.meta.canvas.ctx.canvas.width+"px";a.style.height=this.meta.canvas.ctx.canvas.height+"px";a.style.display="block"}};this.hideMask=function(){var b=this.hexToString("686578546f537472696e67");var a=this;var c=this.$(this.target+"canvasXpressCanvasResize");if(c){c.style.width="0.5px";c.style.height="0.5px";c.style.display="none"}setTimeout(function(){var d=a.beaconImage.width;if(d==256){CanvasXpress[a[b]("666163746f7279")][a[b]("76616c6964")]=2}else{if(d==250){CanvasXpress[a[b]("666163746f7279")][a[b]("76616c6964")]=1}else{CanvasXpress[a[b]("666163746f7279")][a[b]("76616c6964")]=0}}a.drawCx()},1000)};this.endCanvasResizer=function(f){this.functionCaller="endCanvasResizer";if(this.resizingCanvasOn){if(this.isTransition()){return}var c=this.$(this.target);var a=this.$(this.target+"canvasXpressCanvasResize");var l=this.$("canvasXpressCanvasResize");var b=this.$("west-container-"+this.target);var j=this.$("middle-container-"+this.target);var d=this.$("east-container-"+this.target);if(c&&a&&l){this.clickLayoutNoAnimation();var k=parseInt(a.style.width);var g=parseInt(a.style.height);j.style.width=(parseInt(b.style.width)+parseInt(a.style.width)+parseInt(d.style.width))+"px";j.style.height=a.style.height;this.draw(k,g);a.style.width="0.5px";a.style.height="0.5px";a.style.display="none";c.style.cursor="default";this.updateRemoteNavigationWindow();this.resetMotionDiv();document.body.removeChild(l);this.resizeCanvasCursorShow=false;this.resizingCanvasOn=false;CanvasXpress.resizing=false}}};this.initializeCanvasResizerEvents=function(){if(!this.disableEvents){this.addCanvasResizerDiv();this.showMask()}};this.initializeCanvasResizerEvents()};CanvasXpress.prototype.initMotionEvents=function(){this.addMotionDiv=function(){var F=this.target+"-cX-Motion";if(!this.reproducing&&(this.$(F)||!this.motionBy)){if(!this.motionBy){this.removeMotionDiv()}else{if(this.motionObject&&this.motionObject.name!=this.motionBy){this.resetMotionDiv()}else{if(this.motionObject&&this.motionObject.setIndices){this.updateMotionIndices([this.motionObject.current])}}}return}var I=this.reproducing?1:3;var B=this.reproducing?18:0;var z=this.reproducing?18:0;var S=this.width-(this.margin*6);var b=this.margin*I;var e=45+this.margin+B;var U=this.height-(e+this.margin);var f=20;var n=this.margin;var u=f;var k=21+this.margin+B;var h=S-(f+(this.margin*8));var o=this.margin*4;var v=14;var m=this.margin+B;var C=S-(f+(this.margin*8));var G=this.margin*4;var K=10;var E=this.margin+B;var w=S+17-(f+(this.margin*8)+2);var A=15+(this.margin*4);var D=14;var y=this.margin+B;this.motionControlWidth=h;this.setMotionObject();var g=this.motionObject;var V=this.$cX("div",{id:F,className:this.reproducing?"CanvasXpressMotion draggable":"CanvasXpressMotion"},{left:b+"px",top:U+"px",width:(S+z)+"px",height:e+"px",position:"absolute"});if(this.reproducing){V.style.backgroundColor="rgb(245, 245, 245)";V.style.border="1px solid rgb(51, 122, 183)";V.style.borderRadius="5px";V.style.boxSizing="content-box"}var O=this.$cX("img",{id:F+"CloseImage",className:"CanvasXpressMotion",src:CanvasXpress.images.cancel1,alt:"Close Reproducer",title:"Close Reproducer"},{cssFloat:"right",padding:"3px"});var R=this.$cX("span",{id:F+"Span",className:"CanvasXpressMotion",innerHTML:"Customization Timeline"},{left:"8px",top:"5px",position:"absolute",cssFloat:"left",fontWeight:"bold"});var P=this.$cX("img",{id:F+"Play",src:CanvasXpress.images.playButton,className:"CanvasXpressMotion"},{left:n+"px",top:k+"px",width:f+"px",height:u+"px",position:"relative",cssFloat:"left"});var M=this.$cX("div",{id:F+"Scale",className:"CanvasXpressMotion"},{left:o+"px",top:m+"px",width:h+"px",height:v+"px",position:"relative",cssFloat:"left"});var J=this.$cX("div",{id:F+"Ticks",className:"CanvasXpressMotion"},{left:G+"px",top:E+"px",width:C+"px",height:K+"px",position:"relative",cssFloat:"left"});var W=this.$cX("div",{id:F+"Container",className:"CanvasXpressMotionContainer"},{left:A+"px",top:y+"px",width:w+"px",height:D+"px",position:"relative",cssFloat:"left",clear:"none"});var X=this.$cX("div",{id:F+"Current",className:"CanvasXpressMotionCurrent"},{left:"0px",cursor:"pointer"});var N=this.$cX("div",{id:F+"Range",className:"CanvasXpressMotionRange"},{width:0,maxWidth:w+"px"});if(g.type=="String"){for(var T=0;T<g.levels.length;T++){var S=g.levels.length>3?this.measureText(T.toString()," 2pt Arial"):this.measureText(g.levels[T].toString()," 2pt Arial");var H=g.levels[T].length>18?g.levels[T].substring(0,15)+"...":g.levels[T];var Q=this.$cX("div",{innerHTML:(g.levels.length>3?T.toString():g.levels[T]),title:g.levels[T]},{left:(parseInt((T*g.unit)-(S/2)))+"px",cssFloat:"left",position:"absolute",fontSize:"xx-small",cursor:"pointer"});M.appendChild(Q);var L=this.$cX("div",{innerHTML:"|"},{left:(parseInt(T*g.unit)+1)+"px",cssFloat:"left",position:"absolute",fontSize:"xx-small"});J.appendChild(L)}}else{for(var T=0;T<g.values.length;T++){var S=this.measureText(g.values[T].toString()," 2pt Arial");var Q=this.$cX("div",{innerHTML:g.values[T],title:g.values[T]},{left:(parseInt(((g.values[T]-g.min)*g.unit)-(S/2)))+"px",cssFloat:"left",position:"absolute",fontSize:"xx-small",cursor:"pointer"});M.appendChild(Q);var L=this.$cX("div",{innerHTML:"|"},{left:(parseInt((g.values[T]-g.min)*g.unit)+1)+"px",cssFloat:"left",position:"absolute",fontSize:"xx-small"});J.appendChild(L)}}if(this.reproducing){V.appendChild(O)}W.appendChild(N);W.appendChild(X);if(this.reproducing){V.appendChild(R)}V.appendChild(P);V.appendChild(M);V.appendChild(J);V.appendChild(W);this.updateMotionIndices();var w=this.$("center-wrapper-"+this.target);if(w){w.appendChild(V);this.addRemoveMotionListeners("addEvtListener")}if(this.motionCache){this.refreshMotionDiv()}};this.setMotionObject=function(){if(this.motionObject&&this.motionObject.name==this.motionBy){return}else{if(this.reproducing){var h=CanvasXpress.stack[this.target].afterRender;var g=h.length;var a={type:"String",levels:[],unit:this.motionControlWidth/(g-1),current:h[0][0],currentIdx:0,name:"Reproduce",fraction:0};for(var c=0;c<g;c++){a.levels.push(h[c][0])}this.motionObject=a}else{var a={};var d=[];var b={};var e=this.data.x&&this.data.x[this.motionBy]?this.meta.data.x[this.motionBy]:this.meta.data.z[this.motionBy];if(e.type=="Numeric"){if(this.data.x&&this.data.x[this.motionBy]){for(var c=0;c<this.data.x[this.motionBy].length;c++){var f=this.data.x[this.motionBy][c];if(!b.hasOwnProperty(f)){d.push(f);b[f]=true}}a.meta="x"}else{for(var c=0;c<this.data.z[this.motionBy].length;c++){var f=this.data.z[this.motionBy][c];if(!b.hasOwnProperty(f)){d.push(f);b[f]=true}}a.meta="z"}if(d.length>20){a.type="Numeric";a.values=[];a.min=e.rmin;a.max=e.rmax;a.unit=this.motionControlWidth/(e.vals[e.vals.length-1]-e.rmin);a.current=e.rmin;for(var c=0;c<e.vals.length;c++){if(e.vals[c]>=e.rmin){a.values.push(e.vals[c])}}}else{a.type="String";a.levels=d.sort(function(j,i){return j-i});a.unit=this.motionControlWidth/(d.length-1);a.current=d[0]}}else{a.type="String";a.levels=e.levels;a.unit=this.motionControlWidth/(e.levels.length-1);a.current=e.levels[0]}a.varIndices=this.cloneObject(this.varIndices);a.smpIndices=this.cloneObject(this.smpIndices);a.grpIndices=this.cloneObject(this.grpIndices);a.varIndicesMotion=[];a.smpIndicesMotion=[];a.grpIndicesMotion=[];a.name=this.motionBy;a.fraction=0;this.motionObject=a}}};this.updateMotionIndices=function(g,a){if(this.motionBy&&this.motionObject){var c=[];var h=this.motionObject.meta=="x"?this.motionObject.smpIndices:this.motionObject.varIndices;var k=this.motionObject.meta=="x"?this.data.x[this.motionBy]:this.data.z[this.motionBy];if(this.motionObject.type=="String"){var b=g&&g[0]!=null?g[0]:this.motionObject.levels[0];for(var e=0;e<h.length;e++){var j=h[e];if(k[j]==b){c.push(j)}}}else{var d=g&&g[0]!=null?g[0]:this.motionObject.min;var f=g&&g[1]!=null?g[1]:this.motionObject.values[0];for(var e=0;e<h.length;e++){var j=h[e];if(k[j]>d&&k[j]<=f){c.push(j)}}}if(this.motionObject.meta=="x"){this.smpIndices=c}else{this.varIndices=c}if(g&&g.length>0&&!a){this.motionObject.varIndicesMotion.push(this.cloneObject(this.varIndices));this.motionObject.smpIndicesMotion.push(this.cloneObject(this.smpIndices));this.motionObject.grpIndicesMotion.push(this.cloneObject(this.grpIndices))}if(this.motionObject.varIndicesMotion.length>3){this.motionObject.varIndicesMotion.shift()}if(this.motionObject.smpIndicesMotion.length>3){this.motionObject.smpIndicesMotion.shift()}if(this.motionObject.grpIndicesMotion.length>3){this.motionObject.grpIndicesMotion.shift()}}};this.addRemoveMotionListeners=function(d){var a=this.$(this.target+"-cX-Motion");var e=this.$(this.target+"-cX-MotionPlay");var f=this.$(this.target+"-cX-MotionCurrent");if(d&&a&&e&&f){if(this.reproducing){var b=this.$(this.target+"-cX-MotionCloseImage");if(b){this[d](b,"click",this.closeMotion,false)}this[d](a,"mousedown",this.registerMousemove,false)}this[d](e,"click",this.clickMotion,false);this[d](f,"mousedown",this.mousedownMotion,false)}};this.closeMotion=function(a){return function(c){if(!c){c=window.event}var b=a.getTargetEvent(c);if(b){a.removeMotionDiv()}}}(this);this.mousedownMotion=function(a){return function(d){if(!d){d=window.event}var b=a.getTargetEvent(d);if(b){var c=a.$(a.target+"-cX-MotionRange");if(c){a.motionOn=c.style.width;a.xMouseDown=d.clientX;a.yMouseDown=d.clientY}}return false}}(this);this.updateMotion=function(l,v,k){this.functionCaller="updateMotion";if(this.isTransition()){return}var a=this.$(this.target+"-cX-MotionRange");var u=this.$(this.target+"-cX-MotionCurrent");if(a&&u){var d;var p=this.motionControlWidth;var w=v!=null?Math.min(Math.max(0,v),p):l?Math.min(Math.max(0,l.clientX+parseInt(this.motionOn)-this.xMouseDown),p):0;var j=w/this.motionObject.unit;a.style.width=w+"px";this.motionFraction=w/p;if(this.motionObject.type=="String"){d=parseInt(j);if(this.reproducing){if(d==0&&this.motionObject.currentIdx==0){this.initializeDataReproduceMotion()}if(d!=this.motionObject.currentIdx){if(d==(this.motionObject.currentIdx+1)){var q=this.showTransition;var g=CanvasXpress.stack[this.target].afterRender[d];var n=g[0];var b=g[1]||[];var o=g[2]||{};for(var m in o){this[m]=o[m]}this.reproducing=true;this.showTransition=false;this[n].apply(this,b);this.showTransition=q}else{this.reproduceMotionDataToIdx(d)}this.motionObject.currentIdx=d}}else{if(this.motionObject.levels[d]!=this.motionObject.current||k){this.updateMotionIndices([this.motionObject.levels[d]],k);this.motionObject.current=this.motionObject.levels[d];this.draw()}}}else{d=j+this.motionObject.min;for(var h=1;h<this.motionObject.values.length;h++){if(this.motionObject.values[h]>d){this.updateMotionIndices([this.motionObject.values[h-1],d,k]);this.motionObject.current=d;this.draw();break}}}}};this.initializeDataReproduceMotion=function(){var d=JSON.parse(JSON.stringify(CanvasXpress.stack[this.target].data));var b=JSON.parse(JSON.stringify(CanvasXpress.stack[this.target].config));var f=CanvasXpress.stack[this.target].afterRender;var a=this.showTransition;this.setConfigDefaults();for(var e in b){this[e]=b[e]}this.reproducing=true;this.showTransition=false;this.layoutValid=false;this.initializeData(d,true);this.resetLegendPosition(true);this.resetDendrograms();this.initializeGraph(true);this[f[0][0]].apply(this,f[0][1]);this.showTransition=a};this.reproduceMotionDataToIdx=function(a){this.initializeDataReproduceMotion();for(var d=1;d<=a;d++){var b=CanvasXpress.stack[this.target].afterRender[d];var e=b[0];var h=b[1]||[];var g=b[2]||{};for(var f in g){this[f]=g[f]}this[e].apply(this,h)}};this.endMotion=function(){this.motionOn=false;return false};this.clickMotion=function(a){return function(g){if(!g){g=window.event}var f=a.getTargetEvent(g);if(f){a.motionOn=0;var d=a.motionControlWidth;var c=d/100;var h=0;var b=function(){if(h>=d){var j=function(){var k=a.reproducing?0:a.motionObject.varIndicesMotion.length;if(k<1){a.motionOn=false;clearInterval(e);return}if(!a.reproducing){a.motionObject.varIndicesMotion.shift();a.motionObject.smpIndicesMotion.shift();a.motionObject.grpIndicesMotion.shift()}a.updateMotion(g,d,true)};clearInterval(i);var e=a.setInterval(j,50)}h+=c;a.updateMotion(g,h)};a.updateMotion(g,h);var i=a.setInterval(b,50)}};return false}(this);this.refreshMotionDiv=function(){this.updateMotionIndices(this.motionCache.current,true);this.motionObject.current=this.motionCache.current;var a=this.$(this.target+"-cX-MotionRange");if(a){a.style.width=parseInt(Number(this.motionControlWidth)*Number(this.motionCache.fraction))+"px"}this.motionObject.setIndices=false;delete (this.motionCache)};this.removeMotionDiv=function(a){var c=this.$(this.target+"-cX-Motion");if(c){this.addRemoveMotionListeners("removeEvtListener");var b=this.reproducing?CanvasXpress.stack[this.target].afterRender.length-1:0;if(a){this.motionCache={name:this.motionObject.name,current:this.motionObject.type=="String"?[this.motionObject.current]:[this.motionObject.current],fraction:this.motionFraction}}this.reset();this.initAxes();if(b){this.reproduceMotionDataToIdx(b)}this.skipStack=false;this.reproducing=false;delete (this.motionObject);c.parentNode.removeChild(c)}};this.resetMotionDiv=function(){if(this.motionBy){this.skipStack=true;this.removeMotionDiv();this.addMotionDiv()}}};CanvasXpress.prototype.initDraggingEvents=function(){this.getActiveLayout=function(k){if(k){var h={};if(k&&k.type=="keydown"){h.x=(this.layoutComb?this.layoutParams[0].width:this.width)/2;h.y=(this.layoutComb?this.layoutParams[0].height:this.height)/2}else{h=this.adjustedCoordinates(k)}if(this.layoutValid){var a=h.x;var g=h.y;var m=0;for(var f=0;f<this.layoutRows;f++){for(var d=0;d<this.layoutCols;d++){if(m<this.data.l.weight.length){var b=this.getBoundsXY(m);if(a>=b[0]&&a<=b[1]&&g>=b[2]&&g<=b[3]){this.layoutValidR=f;this.layoutValidC=d;this.layoutValidN=m;m={idx:m,row:f,col:d,ac:h};return m}m++}else{return false}}}}else{return{idx:0,row:0,col:0,ac:h}}}return false};this.setActiveLayout=function(a){var b=this.getActiveLayout(a);if(b&&b.row&&b.col&&b.idx){this.layoutValidR=b.row;this.layoutValidC=b.col;this.layoutValidN=b.idx}};this.getActiveLayoutIndicesMetadata=function(f){var g=this.getActiveLayout(f);if(g){var q=this.layoutComb?this.layoutParams[g.idx]:this;var a=this.cloneObject(q.varIndices);var h=this.isGroupedData?this.cloneObject(q.grpIndices):this.cloneObject(q.smpIndices);if(a&&h){this.setOriginalIndices(g.idx,a,h);var n=g.ac.x-(q.offsetX+this.marginLeft+q.left);var k=g.ac.y-(q.offsetY+this.marginTop+q.top);var m=Math.min(Math.max(n,0),q.x)/q.x;var l=Math.ceil(a.length/10)*2;var d=Math.round(m*l);var p=l-d;var j=Math.min(Math.max(k,0),q.y)/q.y;var i=Math.ceil(h.length/10)*2;var b=Math.round(j*i);var o=i-b;return{ac:g.ac,row:g.row,col:g.col,idx:g.idx,lcx:m,stx:d,edx:p,lcy:j,sty:b,edy:o,vin:a,sin:h}}else{var n=g.ac.x-(q.offsetX+this.marginLeft+q.left);var k=g.ac.y-(q.offsetY+this.marginTop+q.top);var m=Math.min(Math.max(n,0),q.x)/q.x;var j=Math.min(Math.max(k,0),q.y)/q.y;return{ac:g.ac,row:g.row,col:g.col,idx:g.idx,lcx:m,lcy:j}}}return false};this.setIndicesAfterWheelEvent=function(k,l){var h,a,p,j,n,f,o;var c=false;var b=this.getActiveLayoutIndicesMetadata(k);if(b){var q=this.layoutComb?this.layoutParams[b.idx]:this;if(this.graphType=="Correlation"){h=this.correlationAxis=="variables"?true:false;a=this.correlationAxis=="samples"?true:false;p=b.stx;j=b.edx;n=b.stx;f=b.edx;o=false}else{if(this.graphType=="Heatmap"){h=!this.zoomVariablesDisable?true:false;a=!this.zoomSamplesDisable?true:false;p=b.stx;j=b.edx;n=b.sty;f=b.edy;o=false}else{if(this.graphType.match(/Bar|Line|Dotplot|Boxplot|Area|Stacked/)){h=false;a=true;p=false;j=false;n=this.graphOrientation=="vertical"?b.stx:b.sty;f=this.graphOrientation=="vertical"?b.edx:b.edy;o=true}}}if(l>0){if(h&&b.vin.length>3){if(q.varIndicesStart<0){q.varIndicesStart++}for(var g=0;g<p;g++){b.vin.shift();q.varIndicesStart++}for(var g=0;g<j;g++){b.vin.pop()}c=true}if(a&&b.sin.length>3){if(q.smpIndicesStart<0){q.smpIndicesStart++}for(var g=0;g<n;g++){b.sin.shift();q.smpIndicesStart++}for(var g=0;g<f;g++){b.sin.pop()}c=true}}else{if(h){for(var g=0;g<p;g++){if(q.varIndicesStart>=0&&q.varIndicesStart+b.vin.length<q.startingVarIndices.length){b.vin.push(q.startingVarIndices[q.varIndicesStart+b.vin.length]);c=true}else{if(q.varIndicesStart>0){q.varIndicesStart--;b.vin.unshift(q.startingVarIndices[q.varIndicesStart]);c=true}}}for(var g=0;g<j;g++){if(q.varIndicesStart>0){q.varIndicesStart--;b.vin.unshift(q.startingVarIndices[q.varIndicesStart]);c=true}else{if(q.varIndicesStart>=0&&q.varIndicesStart+b.vin.length<q.startingVarIndices.length){b.vin.push(q.startingVarIndices[q.varIndicesStart+b.vin.length]);c=true}}}}if(a){for(var g=0;g<n;g++){if(q.smpIndicesStart>=0&&q.smpIndicesStart+b.sin.length<q.startingSmpIndices.length){b.sin.push(q.startingSmpIndices[q.smpIndicesStart+b.sin.length]);c=true}else{if(q.smpIndicesStart>0){q.smpIndicesStart--;b.sin.unshift(q.startingSmpIndices[q.smpIndicesStart]);c=true}}}for(var g=0;g<f;g++){if(q.smpIndicesStart>0){q.smpIndicesStart--;b.sin.unshift(q.startingSmpIndices[q.smpIndicesStart]);c=true}else{if(q.smpIndicesStart>=0&&q.smpIndicesStart+b.sin.length<q.startingSmpIndices.length){b.sin.push(q.startingSmpIndices[q.smpIndicesStart+b.sin.length]);c=true}}}}}if(c){this.drawIndicesAfterWheelEvent(h,b.vin,a,b.sin,o,b.idx)}}};this.drawIndicesAfterWheelEvent=function(g,e,c,f,b,a){this.functionCaller="drawIndicesAfterWheelEvent";if(this.isTransition()){return}var d=this.layoutComb?this.layoutParams[a]:this;if(g){d.varIndices=e}if(c){if(b){this.setSamplesVisible(f,true)}if(d.isGroupedData){d.grpIndices=f}else{d.smpIndices=f}}this.draw()};this.setRangesAfterWheelEvent=function(i,k){this.functionCaller="setRangesAfterWheelEvent";var c=this.getActiveLayoutIndicesMetadata(i);if(c){var p,j,n,h;var q=this.layoutComb?this.layoutParams[c.idx]:this;var l=c.ac.x>(this.marginLeft+q.offsetX+q.left)&&c.ac.x<(this.marginLeft+q.offsetX+q.left+q.x);var f=c.ac.y>(this.marginTop+q.offsetY+q.top)&&c.ac.y<(this.marginTop+q.offsetY+q.top+q.y);var b=q.xAxisRange*this.zoomStep*c.lcx;var a=q.yAxisRange*this.zoomStep*c.lcy;var o=q.xAxisRange*this.zoomStep*(1-c.lcx);var g=q.yAxisRange*this.zoomStep*(1-c.lcy);if(k>0){if(l){p=this.setMinX=q.setMinX!=null?q.setMinX+b:q.xAxisMin+b;j=this.setMaxX=q.setMaxX!=null?q.setMaxX-o:q.xAxisMax-o}if(f&&this.graphType!="Genome"){n=this.setMinY=q.setMinY!=null?q.setMinY+g:q.yAxisMin+g;h=this.setMaxY=q.setMaxY!=null?q.setMaxY-a:q.yAxisMax-a}}else{if(l){p=this.setMinX=q.setMinX!=null?q.setMinX-b:q.xAxisMin-b;j=this.setMaxX=q.setMaxX!=null?q.setMaxX+o:q.xAxisMax+o}if(f&&this.graphType!="Genome"){n=this.setMinY=q.setMinY!=null?q.setMinY-g:q.yAxisMin-g;h=this.setMaxY=q.setMaxY!=null?q.setMaxY+a:q.yAxisMax+a}}this.isTransformedAxis("xAxis","X");this.isTransformedAxis("yAxis","Y");if(q.setMinX=="Infinity"||q.setMaxX=="Infinity"){this.setMinX=p;this.setMaxX=j}if(q.setMinY=="Infinity"||q.setMaxY=="Infinity"){this.setMinY=n;this.setMaxY=h}this.drawRangesAfterWheelEvent(this.setMinX,this.setMaxX,this.setMinY,this.setMaxY,c.idx)}};this.drawRangesAfterWheelEvent=function(f,c,e,b,a){this.functionCaller="drawRangesAfterWheelEvent";if(this.isTransition()){return}var d=this.layoutComb?this.layoutParams[a]:this;d.setMinX=f;d.setMaxX=c;d.setMinY=e;d.setMaxY=b;this.draw();this.isTransformedAxis("xAxis","X",true);this.isTransformedAxis("yAxis","Y",true)};this.setIndicesAfterPannEvent=function(j,b){var a,p;var h=0;var o=this.layoutComb?this.layoutParams[this.layoutValidN||0]:this;var c=this.cloneObject(o.varIndices);var n=o.isGroupedData?this.cloneObject(o.grpIndices):this.cloneObject(o.smpIndices);this.setOriginalIndices(this.layoutComb?this.layoutValidN:0,c,n);if(this.graphType=="Correlation"){h=1;switch(b){case 37:p=o.varIndicesStart>0?3:o.smpIndicesStart>0?4:1;break;case 39:p=o.varIndicesStart>-1?5:o.smpIndicesStart>-1?6:1;break}}else{if(this.graphType=="Heatmap"){h=2}else{if(this.graphType.match(/Bar|Line|Dotplot|Boxplot|Area|Stacked/)){h=3}}}switch(b){case 33:a=h==1?1:h==2?4:h==3?4:1;break;case 34:a=h==1?1:h==2?6:h==3?6:1;break;case 35:a=h==1?1:h==2?1:h==3?1:1;break;case 36:a=h==1?1:h==2?2:h==3?1:1;break;case 37:a=h==1?p:h==2?3:h==3?4:1;break;case 38:a=h==1?1:h==2?4:h==3?4:1;break;case 39:a=h==1?p:h==2?5:h==3?6:1;break;case 40:a=h==1?1:h==2?6:h==3?6:1;break}var l=false;if(a==1){return false}else{if(a==2){o.varIndicesStart=-1;o.smpIndicesStart=-1;o.varIndices=o.startingVarIndices;if(o.isGroupedData){o.grpIndices=o.startingSmpIndices}else{o.smpIndices=o.startingSmpIndices}l=true}else{if(a==3){if(o.varIndicesStart>0){c.unshift(o.startingVarIndices[o.varIndicesStart-1]);c.pop();o.varIndicesStart--;l=true}}else{if(a==4){for(var f=0;f<(b==33?5:1);f++){if(o.smpIndicesStart>0){n.unshift(o.startingSmpIndices[o.smpIndicesStart-1]);n.pop();o.smpIndicesStart--;l=true}}}else{if(a==5){if(o.varIndicesStart>-1&&o.varIndicesStart+c.length<o.startingVarIndices.length){c.push(o.startingVarIndices[o.varIndicesStart+c.length]);c.shift();o.varIndicesStart++;l=true}}else{if(a==6){for(var f=0;f<(b==34?5:1);f++){if(o.smpIndicesStart>-1&&o.smpIndicesStart+n.length<o.startingSmpIndices.length){n.push(o.startingSmpIndices[o.smpIndicesStart+n.length]);n.shift();o.smpIndicesStart++;l=true}}}}}}}}if(l){this.drawIndicesAfterPannEvent(c,n,this.layoutValidN||0)}};this.drawIndicesAfterPannEvent=function(b,c,a){this.functionCaller="drawIndicesAfterPannEvent";if(this.isTransition()){return}var d=this