% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.fm.R
\name{calc.fm}
\alias{calc.fm}
\title{calc.fm}
\usage{
calc.fm(trace, min_height = 8, plot_it = FALSE)
}
\arguments{
\item{trace}{numeric vector, e.g., the fundamental frequency from
`trace.fund`, NOTE this would be `trace$fund` and not the whole `trace`
object.}

\item{min_height}{the minimum difference between a bottom and a peak for an infliction point to be
accepted.}

\item{plot_it}{logical, if `TRUE` plot the trace and peaks to current window. Default is `FALSE`.}
}
\value{
Returns a data frame with fm = median difference between peaks and bottoms and ipi = inter peak,
np = number of peaks.
interval (s).
}
\description{
Calculates the frequency modulation for a wave object and returns several measurements in
a data frame.
}
\examples{
require(callsync)
require(seewave)
require(tuneR)
path_git = 'https://raw.githubusercontent.com'
path_repo = '/simeonqs/callsync/master/tests/testthat/files'
file_1 = '/wave_1.wav'
url_1 = paste0(path_git, path_repo, file_1)
local_file_1 = paste(tempdir(), file_1, sep = '/')
if(!file.exists(local_file_1))
  download.file(url_1, destfile = local_file_1, mode = 'wb',)
wave = readWave(local_file_1)
trace = trace.fund(wave)
result = calc.fm(trace$fund)

}
