% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_prop.R
\name{stat_prop}
\alias{stat_prop}
\title{Callback rates on paired data}
\usage{
stat_prop(x, level = 0.95)
}
\arguments{
\item{x}{A \code{callback} object.}

\item{level}{A number, containing the level of the confidence intervals (0.95
by default).}
}
\value{
A data frame containing the following components (p refers to a proportion of
tests, r refers to a proportion of callbacks):

\tabular{ll}{
\code{tests} \tab number of tests\cr
\code{Lxx_p_callback}\tab overall callback rate, lower bound\cr
\code{p_callback}\tab overall callback rate\cr
\code{Uxx_p_callback}\tab overall callback rate, upper bound\cr
\code{Lxx_p_cand1}\tab 1st candidate callback rate, lower bound\cr
\code{p_cand1}\tab 1st candidate callback rate \cr
\code{Uxx_p_cand1}\tab 1st candidate callback rate, upper bound\cr
\code{Lxx_p_cand2}\tab 2nd candidate callback rate, lower bound\cr
\code{p_cand2}\tab 2nd candidate callback rate \cr
\code{Uxx_p_cand2}\tab 2nd candidate callback rate, upper bound\cr
\code{callback}\tab number of callbacks\cr
\code{Lxx_r_cand1}\tab 1st candidate proportion of callbacks, lower bound\cr
\code{r_cand1}\tab 1st candidate proportion of callbacks \cr
\code{Uxx_r_cand1}\tab 1st candidate proportion of callbacks, upper bound\cr
\code{Lxx_r_cand2}\tab 2nd candidate proportion of callbacks, lower bound\cr
\code{r_cand2}\tab 2nd candidate proportion of callbacks \cr
\code{Uxx_r_cand2}\tab 2nd candidate proportion of callbacks, upper bound\cr
}
}
\description{
Computes the callback rates and their confidence intervals.
}
\examples{
data(labour1)
x <- callback(data=labour1,cluster="offer",candid="hist",callback="callback")
stat_prop(x,level=0.99)

}
