% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_external.R
\name{evaluate}
\alias{evaluate}
\title{Evaluate the quality of mean estimations}
\usage{
evaluate(table, publish = FALSE, scheme = c("chile", "eclac"), ...)
}
\arguments{
\item{table}{\code{dataframe} created by \code{crear_insumos_media}}

\item{publish}{\code{boolean} indicating if the evaluation of the complete table
must be added. If it is TRUE, the function adds a new column to the \code{dataframe}}

\item{scheme}{string variable, default scheme is "chile" which refers to the evaluation protocol proposed by INE Chile. the alternative is "eclac" to use the eclac protocol}

\item{...}{the list of cepal parameters. The complete list of parameters is

1. General Parameters

\itemize{
  \item \code{df} degrees of freedom. default: 9
  \item \code{n} sample size. default ine scheme is 60. default cepal scheme: 100
}

2. INE parameters
\itemize{
  \item \code{cv_lower_ine} lower limit for cv. default: 0.15
  \item \code{cv_upper_ine} upper limit for cv. default: 0.3
}

3. CEPAL parameters
\itemize{
  \item \code{cv_cepal} limit for cv. default: 0.2
  \item \code{ess} efective sample size. default: 140
  \item \code{unweighted} unweighted count. default: 50
}}
}
\value{
\code{dataframe} with all the columns included in the input table, plus a new column
containing a label indicating the evaluation of each estimation: reliable, bit reliable or unreliable
}
\description{
\code{evaluate} evauates the quality of mean estimation using the
methodology created by INE Chile, which considers sample size, degrees of freedom and
coeficient of variation.
}
\examples{
dc <- survey::svydesign(ids = ~varunit, strata = ~varstrat, data = epf_personas, weights = ~fe)
evaluate(create_mean("gastot_hd", domains = "zona+sexo", design = dc))
}
