% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/calibraR-main.R
\name{optimES}
\alias{optimES}
\title{Optimization using Evolutionary Strategies}
\usage{
optimES(par, fn, gr = NULL, ..., lower = -Inf, upper = Inf,
  active = NULL, control = list(), hessian = FALSE, method = "default")
}
\arguments{
\item{par}{A numeric vector. The length of the par argument defines the
number of parameters to be estimated (i.e. the dimension of the problem).}

\item{fn}{The function to be minimized.}

\item{gr}{the gradient of \code{fn}. Ignored, added for portability with
other optimization functions.}

\item{lower}{Lower threshold value(s) for parameters. One value or a vector
of the same length as par. If one value is provided, it is used for all
parameters. \code{NA} means \code{-Inf}. By default \code{-Inf} is used (unconstrained).}

\item{upper}{Upper threshold value(s) for parameters. One value or a vector
of the same length as par. If one value is provided, it is used for all
parameters. \code{NA} means \code{Inf}. By default \code{Inf} is used (unconstrained).}

\item{active}{A boolean vector of the same length of \code{par}. If \code{TRUE}, the
parameter is optimized, if \code{FALSE} the parameter is fixed to the value specified
in \code{par}.}

\item{control}{Parameter for the control of the algorithm itself, see details.}

\item{hessian}{Logical. Should a numerically differentiated Hessian matrix be returned?
Currently not implemented.}

\item{method}{The optimization method to be used. Currently, the only implemented
is the 'default' method, corresponding to the AHR-ES (Oliveros & Shin, 2015).}

\item{\dots}{Additional parameters to be passed to \code{fn}.}
}
\description{
This function performs the optimization of a function using
evolutionary strategies, by default the AHR-ES (Oliveros & Shin, 2015).
}
\examples{
optimES(par=rep(1, 5), fn=SphereN)
}
\author{
Ricardo Oliveros-Ramos
}

