#' Profiles of 4174 Spanish students
#'
#' A dataset containing the demographics, online routines, and self-reported online harassment repeat victimization and offending of 4174 Spanish non-university education students.
#'
#' @format A data frame with 4174 rows and 12 variables:
#' \describe{
#'   \item{sex}{`Factor`. The students' self-reported sex.}
#'   \item{age}{`Factor`. The students' self-reported age}
#'   \item{hours}{`Factor`. The students' self-reported number of daily hours spent online.}
#'   \item{snapchat}{`Factor`. Whether students report using the social media Snapchat on a daily basis.}
#'   \item{instagram}{`Factor`. Whether students report using the social media Instagram on a daily basis.}
#'   \item{facebook}{`Factor`. Whether students report using the social media Facebook on a daily basis.}
#'   \item{twitter}{`Factor`. Whether students report using the social media Twitter on a daily basis.}
#'   \item{name}{`Factor`. Whether students report using their real names on social media.}
#'   \item{photos}{`Factor`. Whether students report uploading personal photos to social media.}
#'   \item{privacy}{`Factor`. Whether students report restricting their social media access to contacts only.}
#'   \item{rep_victim}{`Factor`. Whether students report repeatedly suffering online harassment.}
#'   \item{rep_offender}{`Factor`. Whether students report repeatedly committing online harassment.}
#' }
#' @source Moneva, A., Miró-Llinares, F., & Hart, T. C. (2021). Hunter or Prey? Exploring the situational profiles that define repeated online harassment victims and offenders. *Deviant Behavior, 42*(11), 1366-1381. https://doi.org/10.1080/01639625.2020.1746135
"onharassment"
