% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cTMed-mc-phi-sigma.R
\name{MCPhiSigma}
\alias{MCPhiSigma}
\title{Generate Random Drift Matrices
and Process Noise Covariance Matrices
Using the Monte Carlo Method}
\usage{
MCPhiSigma(
  phi,
  sigma,
  vcov_theta,
  R,
  test_phi = TRUE,
  ncores = NULL,
  seed = NULL
)
}
\arguments{
\item{phi}{Numeric matrix.
The drift matrix (\eqn{\boldsymbol{\Phi}}).
\code{phi} should have row and column names
pertaining to the variables in the system.}

\item{sigma}{Numeric matrix.
The process noise covariance matrix (\eqn{\boldsymbol{\Sigma}}).}

\item{vcov_theta}{Numeric matrix.
The sampling variance-covariance matrix of
\eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)} and
\eqn{\mathrm{vech} \left( \boldsymbol{\Sigma} \right)}}

\item{R}{Positive integer.
Number of replications.}

\item{test_phi}{Logical.
If \code{test_phi = TRUE},
the function tests the stability
of the generated drift matrix \eqn{\boldsymbol{\Phi}}.
If the test returns \code{FALSE},
the function generates a new drift matrix \eqn{\boldsymbol{\Phi}}
and runs the test recursively
until the test returns \code{TRUE}.}

\item{ncores}{Positive integer.
Number of cores to use.
If \code{ncores = NULL},
use a single core.
Consider using multiple cores
when number of replications \code{R}
is a large value.}

\item{seed}{Random seed.}
}
\value{
Returns an object
of class \code{ctmedmc} which is a list with the following elements:
\describe{
\item{call}{Function call.}
\item{args}{Function arguments.}
\item{fun}{Function used ("MCPhiSigma").}
\item{output}{A list simulated drift matrices.}
}
}
\description{
This function generates random
drift matrices \eqn{\boldsymbol{\Phi}}
and process noise covariabces matrices \eqn{\boldsymbol{\Sigma}}
using the Monte Carlo method.
}
\details{
\subsection{Monte Carlo Method}{

Let \eqn{\boldsymbol{\theta}} be
a vector that combines
\eqn{\mathrm{vec} \left( \boldsymbol{\Phi} \right)},
that is,
the elements of the \eqn{\boldsymbol{\Phi}} matrix
in vector form sorted column-wise and
\eqn{\mathrm{vech} \left( \boldsymbol{\Sigma} \right)},
that is,
the unique elements of the \eqn{\boldsymbol{\Sigma}} matrix
in vector form sorted column-wise.
Let \eqn{\hat{\boldsymbol{\theta}}} be
a vector that combines
\eqn{\mathrm{vec} \left( \hat{\boldsymbol{\Phi}} \right)} and
\eqn{\mathrm{vech} \left( \hat{\boldsymbol{\Sigma}} \right)}.
Based on the asymptotic properties of maximum likelihood estimators,
we can assume that estimators are normally distributed
around the population parameters.
\deqn{
  	\hat{\boldsymbol{\theta}}
  	\sim
  	\mathcal{N}
  	\left(
  	\boldsymbol{\theta},
  	\mathbb{V} \left( \hat{\boldsymbol{\theta}} \right)
  	\right)
  }
Using this distributional assumption,
a sampling distribution of \eqn{\hat{\boldsymbol{\theta}}}
which we refer to as \eqn{\hat{\boldsymbol{\theta}}^{\ast}}
can be generated by replacing the population parameters
with sample estimates,
that is,
\deqn{
  	\hat{\boldsymbol{\theta}}^{\ast}
  	\sim
  	\mathcal{N}
  	\left(
  	\hat{\boldsymbol{\theta}},
  	\hat{\mathbb{V}} \left( \hat{\boldsymbol{\theta}} \right)
  	\right) .
  }
}
}
\examples{
set.seed(42)
phi <- matrix(
  data = c(
    -0.357, 0.771, -0.450,
    0.0, -0.511, 0.729,
    0, 0, -0.693
  ),
  nrow = 3
)
colnames(phi) <- rownames(phi) <- c("x", "m", "y")
sigma <- matrix(
  data = c(
    0.24455556, 0.02201587, -0.05004762,
    0.02201587, 0.07067800, 0.01539456,
    -0.05004762, 0.01539456, 0.07553061
  ),
  nrow = 3
)
MCPhiSigma(
  phi = phi,
  sigma = sigma,
  vcov_theta = 0.1 * diag(15),
  R = 100L # use a large value for R in actual research
)

}
\seealso{
Other Continuous Time Mediation Functions: 
\code{\link{BootBeta}()},
\code{\link{BootBetaStd}()},
\code{\link{BootIndirectCentral}()},
\code{\link{BootMed}()},
\code{\link{BootMedStd}()},
\code{\link{BootTotalCentral}()},
\code{\link{DeltaBeta}()},
\code{\link{DeltaBetaStd}()},
\code{\link{DeltaIndirectCentral}()},
\code{\link{DeltaMed}()},
\code{\link{DeltaMedStd}()},
\code{\link{DeltaTotalCentral}()},
\code{\link{Direct}()},
\code{\link{DirectStd}()},
\code{\link{ExpCov}()},
\code{\link{ExpMean}()},
\code{\link{Indirect}()},
\code{\link{IndirectCentral}()},
\code{\link{IndirectStd}()},
\code{\link{MCBeta}()},
\code{\link{MCBetaStd}()},
\code{\link{MCIndirectCentral}()},
\code{\link{MCMed}()},
\code{\link{MCMedStd}()},
\code{\link{MCPhi}()},
\code{\link{MCTotalCentral}()},
\code{\link{Med}()},
\code{\link{MedStd}()},
\code{\link{PosteriorBeta}()},
\code{\link{PosteriorIndirectCentral}()},
\code{\link{PosteriorMed}()},
\code{\link{PosteriorTotalCentral}()},
\code{\link{Total}()},
\code{\link{TotalCentral}()},
\code{\link{TotalStd}()},
\code{\link{Trajectory}()}
}
\author{
Ivan Jacob Agaloos Pesigan
}
\concept{Continuous Time Mediation Functions}
\keyword{cTMed}
\keyword{mc}
