% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotRaw}
\alias{plotRaw}
\title{Plot manifest and fitted raw scores}
\usage{
plotRaw(model, group = FALSE, raw = NULL, type = 0)
}
\arguments{
\item{model}{The regression model from the 'cnorm' function}

\item{group}{Should the fit be displayed by group?}

\item{raw}{Vector of the observed raw data}

\item{type}{Type of display: 0 = plot manifest against fitted values, 1 = plot
manifest against difference values}
}
\description{
The function plots the raw data against the fitted scores from
the regression model per group. This helps to inspect the precision
of the modeling process. The scores should not deviate too far from
regression line.
}
\examples{
# Compute model with example dataset and plot results
result <- cnorm(raw = elfe$raw, group = elfe$group)
plotRaw(result)
}
\seealso{
Other plot: 
\code{\link{compare}()},
\code{\link{plot.cnorm}()},
\code{\link{plot.cnormBetaBinomial}()},
\code{\link{plot.cnormBetaBinomial2}()},
\code{\link{plotDensity}()},
\code{\link{plotDerivative}()},
\code{\link{plotNorm}()},
\code{\link{plotNormCurves}()},
\code{\link{plotPercentileSeries}()},
\code{\link{plotPercentiles}()},
\code{\link{plotSubset}()}
}
\concept{plot}
