% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plotNormCurves}
\alias{plotNormCurves}
\title{Plot norm curves}
\usage{
plotNormCurves(
  model,
  normList = c(30, 40, 50, 60, 70),
  minAge = NULL,
  maxAge = NULL,
  step = 0.1,
  minRaw = NULL,
  maxRaw = NULL,
  covariate = NULL
)
}
\arguments{
\item{model}{The model from the bestModel function}

\item{normList}{Vector with norm scores to display}

\item{minAge}{Age to start with checking}

\item{maxAge}{Upper end of the age check}

\item{step}{Stepping parameter for the age check, usually 1 or 0.1; lower
scores indicate higher precision / closer checks}

\item{minRaw}{Lower end of the raw score range, used for clipping implausible results
(default = 0)}

\item{maxRaw}{Upper end of the raw score range, used for clipping implausible results}

\item{covariate}{In case, a covariate has been used, please specify the degree of the covariate /
the specific value here.}
}
\description{
The function plots the norm curves based on the regression model.
Please check the function for inconsistent curves: The different
curves should not intersect. Violations of this assumption are a strong
indication for problems
in modeling the relationship between raw and norm scores. There are
several reasons, why this might occur:
\enumerate{
  \item Vertical extrapolation: Choosing extreme norm scores, e. g. scores
  -3 <= x and x >= 3 In order to model these extreme scores, a large sample
  dataset is necessary.
  \item Horizontal extrapolation: Taylor polynomials converge in a certain
  radius. Using the model scores outside the original dataset may
  lead to inconsistent results.
  \item The data cannot be modeled with Taylor polynomials, or you need
  another power parameter (k) or R2 for the model.
 }
In general, extrapolation (point 1 and 2) can carefully be done to a
certain degree outside the original sample, but it should in general
be handled with caution.
checkConsistency and derivationPlot can be used to further inspect the model.
}
\examples{
# Load example data set, compute model and plot results
normData <- prepareData()
m <- bestModel(data = normData)
plotNormCurves(m, minAge=2, maxAge=5)
}
\seealso{
checkConsistency, derivationPlot, plotPercentiles
}
