% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary-forecast.R
\name{rmase}
\alias{rmase}
\alias{rmase.predbvhar}
\alias{rmase.bvharcv}
\title{Evaluate the Model Based on RMASE (Relative MASE)}
\usage{
rmase(x, pred_bench, y, ...)

\method{rmase}{predbvhar}(x, pred_bench, y, ...)

\method{rmase}{bvharcv}(x, pred_bench, y, ...)
}
\arguments{
\item{x}{Forecasting object to use}

\item{pred_bench}{The same forecasting object from benchmark model}

\item{y}{Test data to be compared. should be the same format with the train data.}

\item{...}{not used}
}
\value{
RMASE vector corresponding to each variable.
}
\description{
This function computes RMASE given prediction result versus evaluation set.
}
\details{
RMASE is the ratio of MAPE of given model and the benchmark one.
Let \eqn{MASE_b} be the MAPE of the benchmark model.
Then

\deqn{RMASE = \frac{mean(MASE)}{mean(MASE_b)}}

where \eqn{MASE} is the MASE of our model.
}
\references{
Hyndman, R. J., & Koehler, A. B. (2006). \emph{Another look at measures of forecast accuracy}. International Journal of Forecasting, 22(4), 679-688.
}
