% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thin_posterior.bvarlist.R
\name{thin_posterior.bvarlist}
\alias{thin_posterior.bvarlist}
\title{Thinning Posterior Draws}
\usage{
\method{thin_posterior}{bvarlist}(x, thin = 10)
}
\arguments{
\item{x}{an object of class \code{"bvarlist"}.}

\item{thin}{an integer specifying the thinning interval between successive values of posterior draws.}
}
\value{
An object of class \code{"bvarlist"}.
}
\description{
Thins the MCMC posterior draws in an object of class \code{"bvarlist"}.
}
\examples{

# Load data
data("e1")
e1 <- diff(log(e1)) * 100

# Generate multiple model matrices
model <- gen_var(e1, p = 1:2, deterministic = 2,
                 iterations = 100, burnin = 10)

# Add prior specifications
model <- add_priors(model)

# Obtain posterior draws
object <- draw_posterior(model)

# Thin
object <- thin_posterior(object)

}
