% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_data_for_fit.R
\name{prep_data_for_fit}
\alias{prep_data_for_fit}
\title{Data Preparation}
\usage{
prep_data_for_fit(data_binned, zstar, binwidth, bins_l, bins_r, poly = 9,
  bins_excl_l = 0, bins_excl_r = 0, rn = NA, extra_fe = NA,
  correct_above_zu = FALSE)
}
\arguments{
\item{data_binned}{dataframe of counts per bin}

\item{zstar}{a numeric value for the the bunching point.}

\item{binwidth}{a numeric value for the width of each bin.}

\item{bins_l}{number of bins to left of zstar to use in analysis.}

\item{bins_r}{number of bins to right of zstar to use in analysis.}

\item{poly}{a numeric value for the order of polynomial for counterfactual fit. Default is 9.}

\item{bins_excl_l}{number of bins to left of zstar to include in bunching region. Default is 0.}

\item{bins_excl_r}{number of bins to right of zstar to include in bunching region. Default is 0.}

\item{rn}{a numeric vector of (up to 2) round numbers to control for. Default includes no controls.}

\item{extra_fe}{a numeric vector of bin values to control for using fixed effects. Default includes no controls.}

\item{correct_above_zu}{if integration constraint correction is implemented, should counterfactual be shifted only above zu (upper bound of exclusion region)? Default is FALSE (i.e. shift from above zstar).}
}
\value{
\code{data_binned} returns a list with the following:
\item{data_binned}{The binned data with the extra columns necessary for model fitting, such as indicators for bunching region, fixed effects, etc.}
\item{model_formula}{The formula used for model fitting.}
}
\description{
Prepare binned data and model for bunching estimation.
}
\examples{
data(bunching_data)
binned_data <- bin_data(z_vector = bunching_data$kink, zstar = 10000,
                        binwidth = 50, bins_l = 20, bins_r = 20)
prepped_data <- prep_data_for_fit(binned_data, zstar = 10000, binwidth = 50,
                                  bins_l = 20, bins_r = 20, poly = 4,
                                  bins_excl_l = 2, bins_excl_r = 3,
                                  rn = c(250,500), extra_fe = 10200)
head(prepped_data$data_binned)
prepped_data$model_formula
}
\seealso{
\code{\link{bunchit}}
}
