% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/buffer_windrose.R
\name{buffer_windrose}
\alias{buffer_windrose}
\title{A wind-rose shaped buffer function}
\usage{
buffer_windrose(point, wind_frequency_df, radius = 100, width_factor = 2)
}
\arguments{
\item{point}{Centre point of the buffer, must equal to true in: \code{sf::st_is(point, "POINT")}}

\item{wind_frequency_df}{A wind frequency table, in the format provided by \code{"openair::windRose(wind_sample)$data"}}

\item{radius}{radius of the buffer (numeric). The radius of the largest sub-wedge of the wind-rose shaped buffer}

\item{width_factor}{Scaling factor of the width of sub-wedges (numeric). Smaller number (<1) emphasize less-dominant wind-directions, (>1) emphasize dominant wind-directions.}
}
\value{
An object of class \code{sfc_POLYGON}
}
\description{
\code{buffer_windrose} creates a wind-rose based buffer shape.
}
\examples{
example_point = sf::st_point(c(1,2))
example_point = sf::st_sfc(example_point)
example_point = sf::st_sf(example_point)

openair::windRose(wind_sample) -> wind_sample_wind_rose
wind_sample_wind_rose$data -> wind_frequency_df

buffer_windrose(example_point, wind_frequency_df, 100, 0.5) -> windrose_shaped_buffer
plot(windrose_shaped_buffer)
}
\keyword{Wind-rose}
\keyword{wind}
