\name{gof-plot}
\alias{gof-plot}
\alias{gofplot}
\alias{plotgof}
\alias{plot-gof}
\alias{plot}
\alias{plot.gof}
\alias{print.gof}
\alias{print.univariate}
\alias{print.boxplot}
\alias{print.roc}
\alias{print.pr}
\alias{print.rocpr}
\alias{print,gof-method}
\alias{print,univariate-method}
\alias{print,boxplot-method}
\alias{print,roc-method}
\alias{print,pr-method}
\alias{print,rocpr-method}
\alias{plot.gof}
\alias{plot.univariate}
\alias{plot.boxplot}
\alias{plot.roc}
\alias{plot.pr}
\alias{plot.rocpr}
\alias{plot,gof-method}
\alias{plot,univariate-method}
\alias{plot,boxplot-method}
\alias{plot,roc-method}
\alias{plot,pr-method}
\alias{plot,rocpr-method}
\docType{methods}
\title{Plot and print methods for gof output.}
\description{
Plot and print methods for goodness-of-fit output for network models.
}
\details{
These plot and print methods serve to display the output generated by the \code{gof} function and its methods. See the help page of \link{gof-methods} for details on how to compute gof.
}
\usage{
\method{plot}{boxplot}(x, relative = TRUE, transform = function(x) x, 
    xlim = NULL, main = x$label, xlab = x$label, ylab = "Frequency", 
    border = "darkgray", boxplot.lwd = 0.8, outline = FALSE, 
    median = TRUE, median.col = "black", median.lty = "solid", 
    median.lwd = 2, mean = TRUE, mean.col = "black", 
    mean.lty = "dashed", mean.lwd = 1, ...)

\method{plot}{gof}(x, mfrow = TRUE, ...)

\method{plot}{pr}(x, add = FALSE, main = x$label, avg = c("none", 
    "horizontal", "vertical", "threshold"), spread.estimate = 
    c("boxplot", "stderror", "stddev"), lwd = 3, rgraph = TRUE, 
    col = "#5886be", random.col = "#5886be44", pr.poly = 0, ...)

\method{plot}{roc}(x, add = FALSE, main = x$label, avg = c("none", 
    "horizontal", "vertical", "threshold"), spread.estimate = 
    c("boxplot", "stderror", "stddev"), lwd = 3, rgraph = TRUE, 
    col = "#bd0017", random.col = "#bd001744", ...)

\method{plot}{rocpr}(x, main = x$label, roc.avg = c("none", 
    "horizontal", "vertical", "threshold"), 
    roc.spread.estimate = c("boxplot", "stderror", "stddev"), 
    roc.lwd = 3, roc.rgraph = TRUE, roc.col = "#bd0017", 
    roc.random.col = "#bd001744", pr.avg = c("none", "horizontal", 
    "vertical", "threshold"), pr.spread.estimate = c("boxplot", 
    "stderror", "stddev"), pr.lwd = 3, pr.rgraph = TRUE, 
    pr.col = "#5886be", pr.random.col = "#5886be44", pr.poly = 0, 
    ...)

\method{plot}{univariate}(x, main = x$label, sim.hist = TRUE, 
    sim.bar = TRUE, sim.density = TRUE, obs.hist = FALSE, 
    obs.bar = TRUE, obs.density = TRUE, sim.adjust = 1, 
    obs.adjust = 1, sim.lwd = 2, obs.lwd = 2, sim.col = "black", 
    obs.col = "red", ...)

\method{print}{boxplot}(x, ...)

\method{print}{gof}(x, ...)

\method{print}{pr}(x, ...)

\method{print}{roc}(x, ...)

\method{print}{rocpr}(x, ...)

\method{print}{univariate}(x, ...)
}
\arguments{
\item{add}{ Add the ROC and/or PR curve to an existing plot? }
\item{avg}{ Averaging pattern for the ROC and PR curve(s) if multiple target time steps were used. Allowed values are \code{"none"} (plot all curves separately), \code{"horizontal"} (horizontal averaging), \code{"vertical"} (vertical averaging), and \code{"threshold"} (threshold (= cutoff) averaging). Note that while threshold averaging is always feasible, vertical and horizontal averaging are not well-defined if the graph cannot be represented as a function x->y and y->x, respectively. More information can be obtained from the help pages of the \pkg{ROCR} package, the functions of which are employed here. }
\item{border}{ Color of the borders of the boxplots. }
\item{boxplot.lwd}{ Line width of boxplot. }
\item{col}{ Color of the ROC or PR curve. }
\item{lwd}{ Line width. }
\item{main}{ Main title of a GOF plot. }
\item{mean}{ Plot the mean curve for the observed network? }
\item{mean.col}{ Color of the mean of the observed network statistic. }
\item{mean.lty}{ Line type of mean line. For example "dashed" or "solid". }
\item{mean.lwd}{ Line width of mean line. }
\item{median}{ Plot the median curve for the observed network? }
\item{median.col}{ Color of the median of the observed network statistic. }
\item{median.lty}{ Line type of median line. For example "dashed" or "solid". }
\item{median.lwd}{ Line width of median line. }
\item{mfrow}{ Should the GOF plots come out separately (\code{mfrow = FALSE}), or should all statistics be aligned in a single diagram (\code{mfrow = TRUE})? Returning the plots separately can be helpful if the output is redirected to a multipage PDF or TIFF file. }
\item{obs.adjust}{ Bandwidth adjustment parameter for the density curve. }
\item{obs.bar}{ Draw a bar for the median of the statistic for the observed networks? }
\item{obs.col}{ Color for the observed network(s). }
\item{obs.density}{ Draw a density curve fot the statistic for the observed networks? }
\item{obs.hist}{ Draw a histogram for the observed networks? }
\item{obs.lwd}{ Line width for the observed network(s). }
\item{outline}{ Print outliers in the boxplots? }
\item{pr.avg}{ Averaging pattern for the PR curve(s) if multiple target time steps were used. Allowed values are \code{"none"} (plot all curves separately), \code{"horizontal"} (horizontal averaging), \code{"vertical"} (vertical averaging), and \code{"threshold"} (threshold (= cutoff) averaging). Note that while threshold averaging is always feasible, vertical and horizontal averaging are not well-defined if the graph cannot be represented as a function x->y and y->x, respectively. More information can be obtained from the help pages of the \pkg{ROCR} package, the functions of which are employed here. }
\item{pr.col}{ Color of the PR curve. }
\item{pr.lwd}{ Line width. }
\item{pr.poly}{ If a value of \code{0} is set, nothing special happens. If a value of \code{1} is set, a straight line is fitted through the PR curve and displayed. Values between \code{2} and \code{9} fit higher-order polynomial curves through the PR curve and display the resulting curve. This argument allows to check whether the imputation of the first precision value in the PR curve yielded a reasonable result (in case the value had to be imputed). }
\item{pr.random.col}{ Color of the PR curve of the random graph prediction. }
\item{pr.rgraph}{ Should an PR curve also be drawn for a random graph? This serves as a baseline against which to compare the actual PR curve. }
\item{pr.spread.estimate}{When multiple target time steps are used and curve averaging is enabled, the variation around the average curve can be visualized as standard error bars (\code{"stderror"}), standard deviation bars (\code{"stddev"}), or by using box plots (\code{"boxplot"}). Note that the function plotCI, which is used internally by the \pkg{ROCR} package to draw error bars, might raise a warning if the spread of the curves at certain positions is 0. More details can be found in the documentation of the \pkg{ROCR} package, the functions of which are employed here. }
\item{random.col}{ Color of the ROC or PR curve of the random graph prediction. }
\item{relative}{ Print relative frequencies (as opposed to absolute frequencies) of a statistic on the y axis? }
\item{rgraph}{ Should an ROC or PR curve also be drawn for a random graph? This serves as a baseline against which to compare the actual ROC or PR curve. }
\item{roc.avg}{ Averaging pattern for the ROC curve(s) if multiple target time steps were used. Allowed values are \code{"none"} (plot all curves separately), \code{"horizontal"} (horizontal averaging), \code{"vertical"} (vertical averaging), and \code{"threshold"} (threshold (= cutoff) averaging). Note that while threshold averaging is always feasible, vertical and horizontal averaging are not well-defined if the graph cannot be represented as a function x->y and y->x, respectively. More information can be obtained from the help pages of the \pkg{ROCR} package, the functions of which are employed here. }
\item{roc.col}{ Color of the ROC curve. }
\item{roc.lwd}{ Line width. }
\item{roc.random.col}{ Color of the ROC curve of the random graph prediction. }
\item{roc.rgraph}{ Should an ROC curve also be drawn for a random graph? This serves as a baseline against which to compare the actual ROC curve. }
\item{roc.spread.estimate}{When multiple target time steps are used and curve averaging is enabled, the variation around the average curve can be visualized as standard error bars (\code{"stderror"}), standard deviation bars (\code{"stddev"}), or by using box plots (\code{"boxplot"}). Note that the function plotCI, which is used internally by the \pkg{ROCR} package to draw error bars, might raise a warning if the spread of the curves at certain positions is 0. More details can be found in the documentation of the \pkg{ROCR} package, the functions of which are employed here. }
\item{sim.adjust}{ Bandwidth adjustment parameter for the density curve. }
\item{sim.bar}{ Draw a bar for the median of the statistic for the simulated networks? }
\item{sim.col}{ Color for the simulated networks. }
\item{sim.density}{ Draw a density curve fot the statistic for the simulated networks? }
\item{sim.hist}{ Draw a histogram for the simulated networks? }
\item{sim.lwd}{ Line width for the simulated networks. }
\item{spread.estimate}{When multiple target time steps are used and curve averaging is enabled, the variation around the average curve can be visualized as standard error bars (\code{"stderror"}), standard deviation bars (\code{"stddev"}), or by using box plots (\code{"boxplot"}). Note that the function plotCI, which is used internally by the \pkg{ROCR} package to draw error bars, might raise a warning if the spread of the curves at certain positions is 0. More details can be found in the documentation of the \pkg{ROCR} package, the functions of which are employed here. }
\item{transform}{ A function which transforms the y values used for the boxplots. For example, if some of the values become very large and make the output illegible, \code{transform = function(x) x^0.1} or a similar transformation of the values can be used. Note that logarithmic transformations often produce infinite values because \code{log(0) = -Inf}, so one should rather use something like \code{transform = function(x) log1p} to avoid infinite values. }
\item{x}{ An object created by one of the \code{gof} methods. }
\item{xlab}{ Label of the x-axis of a GOF plot. }
\item{xlim}{ Horizontal limit of the boxplots. Only the maximum value must be provided, e.g., \code{xlim = 8}. }
\item{ylab}{ Label of the y-axis of a GOF plot. }
\item{...}{ Arbitrary further arguments. }
}
\seealso{
\link{btergm-package} \link{gof} \link{gof-methods} \link{gof-statistics}
}
\author{
Philip Leifeld (\url{http://www.philipleifeld.com})
}
\keyword{methods}
\keyword{gof}
\keyword{plot}
