% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtergm.R
\name{mtergm}
\alias{mtergm}
\title{Estimate a TERGM by MCMC-MLE}
\usage{
mtergm(formula, constraints = ~., returndata = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{formula}{Formula for the TERGM. Model construction works like in the
\pkg{ergm} package with the same model terms etc. (for a list of terms, see
\code{help("\link[ergm]{ergm-terms}")}). The networks to be modeled on the
left-hand side of the equation must be given either as a list of network
objects with more recent networks last (i.e., chronological order) or as a
list of matrices with more recent matrices at the end. \code{dyadcov} and
\code{edgecov} terms accept time-independent covariates (as \code{network}
or \code{matrix} objects) or time-varying covariates (as a list of networks
or matrices with the same length as the list of networks to be modeled).}

\item{constraints}{Constraints of the ERGM. See \code{\link[ergm]{ergm}} for
details.}

\item{returndata}{Return the processed input data instead of estimating and
returning the model? In the \code{btergm} case, this will return a data
frame with the dyads of the dependent variable/network and the change
statistics for all covariates. In the \code{mtergm} case, this will return
a list object with the blockdiagonal network object for the dependent
variable and blockdiagonal matrices for all dyadic covariates and the
offset matrix for the structural zeros.}

\item{verbose}{Print details about data preprocessing and estimation
settings.}

\item{...}{Further arguments to be handed over to the
\code{\link[ergm]{ergm}} function.}
}
\description{
Estimate a TERGM by Markov Chain Monte Carlo Maximum Likelihood Estimation
}
\details{
The \code{mtergm} function computes TERGMs by MCMC MLE (or MPLE with
uncorrected standard errors) via blockdiagonal matrices and structural zeros.
It acts as a wrapper for the \pkg{ergm} package. The \code{btergm} function
is faster than the \code{mtergm} function but is only asymptotically unbiased
the longer the time series. The \code{mtergm} function yields unbiased
estimates and standard errors but may suffer from degeneracy if the model is
not specified in good keeping with the true data-generating process.
}
\examples{
library("network")
set.seed(5)

networks <- list()
for (i in 1:10) {              # create 10 random networks with 10 actors
  mat <- matrix(rbinom(100, 1, .25), nrow = 10, ncol = 10)
  diag(mat) <- 0               # loops are excluded
  nw <- network::network(mat)  # create network object
  networks[[i]] <- nw          # add network to the list
}

covariates <- list()
for (i in 1:10) {              # create 10 matrices as covariate
  mat <- matrix(rnorm(100), nrow = 10, ncol = 10)
  covariates[[i]] <- mat       # add matrix to the list
}

\dontrun{
fit2 <- mtergm(networks ~ edges + istar(2) + edgecov(covariates))
summary(fit2)
}

# For examples with real data, see help("knecht") or help("alliances").

}
\references{
Leifeld, Philip, Skyler J. Cranmer and Bruce A. Desmarais (2017):
  Temporal Exponential Random Graph Models with btergm: Estimation and
  Bootstrap Confidence Intervals. \emph{Journal of Statistical Software}
  83(6): 1-36. \doi{10.18637/jss.v083.i06}.
}
\seealso{
\code{\link{btergm}} \code{\link{tbergm}}
}
\author{
Philip Leifeld, Skyler J. Cranmer, Bruce A. Desmarais
}
