% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/btb_add_inspire.R
\name{btb_add_inspire}
\alias{btb_add_inspire}
\title{Creates Inpire names for a grid}
\usage{
btb_add_inspire(
  pts_centro,
  sEPSG,
  iCellSize,
  names_centro = c("x_centro", "y_centro")
)
}
\arguments{
\item{pts_centro}{(\strong{df object}) : table of centroids.}

\item{sEPSG}{(\strong{integer or character}) : epsg code.}

\item{iCellSize}{(\strong{integer}) : cells size(s) in meters. Can be a vector for irregular grids}

\item{names_centro}{(\strong{character vector}) : vector of names for longitude/latitude variables. Default c("x_centro","y_centro").}
}
\value{
(\strong{df}) pts_centro table with additional \emph{idInspire} variable
}
\description{
Creates Inpire names for a grid defined with :
\itemize{
\item centroids coordinates
\item Squares size(s)
\item Projection system
}

Ajoute les noms des identifiants en norme Inspire des carreaux définis à partir :
\itemize{
\item des coordonnées de leurs centroides
\item de la taille de leur côté en mètres
\item d'un système de projection)
}
}
\examples{
pts_centro <- data.frame(x_centro = c(100, 100, 300, 300, 500), 
y_centro = c(100, 300, 100, 300, 100))
btb_add_inspire(pts_centro, sEPSG = 2154, iCellSize = 200)
}
