% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bssm-package.R
\docType{data}
\name{negbin_model}
\alias{negbin_model}
\title{Estimated Negative Binomial Model of Helske and Vihola (2021)}
\format{
A object of class \code{mcmc_output}.
}
\description{
This model was used in Helske and Vihola (2021), but with larger number of
iterations. Here only 2000 iterations were used in order to reduce the size
of the model object in CRAN.
}
\examples{
# reproducing the model:
data("negbin_series")
# Construct model for bssm
bssm_model <- bsm_ng(negbin_series[, "y"],
  xreg = negbin_series[, "x"],
  beta = normal(0, 0, 10),
  phi = halfnormal(1, 10),
  sd_level = halfnormal(0.1, 1),
  sd_slope = halfnormal(0.01, 0.1),
  a1 = c(0, 0), P1 = diag(c(10, 0.1)^2),
  distribution = "negative binomial")

\donttest{
# In the paper we used 60000 iterations with first 10000 as burnin
fit_bssm <- run_mcmc(bssm_model, iter = 2000, particles = 10, seed = 1)
fit_bssm
}
}
\references{
Helske J, Vihola M (2021). bssm: Bayesian Inference of Non-linear and
Non-Gaussian State Space Models in R. The R Journal (2021) 13:2, 578-589.
https://doi.org/10.32614/RJ-2021-103
}
\keyword{datasets}
