% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_mcmc.R
\name{run_mcmc}
\alias{run_mcmc}
\title{Bayesian Inference of State Space Models}
\usage{
run_mcmc(model, iter, ...)
}
\arguments{
\item{model}{State space model model of \code{bssm} package.}

\item{iter}{Number of MCMC iterations.}

\item{...}{Parameters to specific methods. See 
\code{\link{run_mcmc.gaussian}},
\code{\link{run_mcmc.nongaussian}}, \code{\link{run_mcmc.ssm_nlg}}, 
and \code{\link{run_mcmc.ssm_sde}} for details.}
}
\description{
Adaptive Markov chain Monte Carlo simulation of state space models using
Robust Adaptive Metropolis algorithm by Vihola (2012). 
See specific methods for various model types for details.
}
\references{
Matti Vihola (2012). "Robust adaptive Metropolis algorithm with
coerced acceptance rate". Statistics and Computing, Volume 22, Issue 5,
pages 997--1008.
}
