% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/integration.R
\name{integration}
\alias{integration}
\alias{enable}
\alias{disable}
\title{Enable/Disable Bridge to System Package Manager}
\usage{
enable()

disable()
}
\description{
Functions to enable or disable the integration of \code{\link{install_sys}}
into \code{\link{install.packages}}. When enabled, packages are installed
transparently from system repositories if available, including dependencies,
and from the configured \R repositories if not.
}
\details{
To enable \pkg{bspm} system-wide by default, include the following:

\code{suppressMessages(bspm::enable())}

into the \code{Rprofile.site} file. To enable it just for a particular user,
move that line to the user's \code{~/.Rprofile} instead.

By default, enabling \pkg{bspm} triggers a check of the backend, and a
warning is raised if the system service is required but not available. To
avoid this check, \code{options(bspm.backend.check=FALSE)} can be set.

Enabling \pkg{bspm} sets default installation \code{type} to \code{"both"},
which means 'use binary if available and current, otherwise try source'.
The action if there are source packages which are preferred is controlled by
\code{getOption("install.packages.compile.from.source")}. Set this option to
\code{"never"} to always prefer binaries over source packages, with an
informative message about newer versions available from source.

If binaries are always preferred and no message is required, a special
\emph{fast} mode can be enabled via \code{options(bspm.version.check=FALSE)},
(true by default) which completely skips version checking.
}
\examples{
\dontrun{
# install 'units' and all its dependencies from the system repos
bspm::enable()
install.packages("units")

# install packages again from CRAN
bspm::disable()
install.packages("errors")
}

}
\seealso{
\code{\link{manager}}, \code{\link{bspm-options}}
}
