% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identity_resolve_handle.R
\name{bs_resolve_handle}
\alias{bs_resolve_handle}
\title{Resolve a Handle to Decentralized Identifier (DID)}
\usage{
bs_resolve_handle(
  handle,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{handle}{Character, length 1. Handle, such as \code{'chriskenny.bsky.social'}}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of decentralized identifier
}
\description{
Resolve a Handle to Decentralized Identifier (DID)
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/identity/resolveHandle.json}{identity/resolveHandle.json (2023-11-24)}
}

\section{Function introduced}{

\code{v0.1.0} (2023-11-24)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_resolve_handle('chriskenny.bsky.social')
\dontshow{\}) # examplesIf}
}
\concept{identity}
