% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/record_repost.R
\name{bs_repost}
\alias{bs_repost}
\title{Repost an existing post}
\usage{
bs_repost(
  post,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass),
  clean = TRUE
)
}
\arguments{
\item{post}{Character vector, length 1. Link to a post.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}

\item{clean}{Logical. Should output be cleaned into a \code{tibble}? Default: \code{TRUE}.}
}
\value{
a \link[tibble:tibble]{tibble::tibble} of post information
}
\description{
Repost an existing post
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/repost.json}{feed/post.json (2023-11-25)}
\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/com/atproto/repo/createRecord.json}{repo/createRecord.json (2023-11-25)}
}

\section{Function introduced}{

\code{v0.1.0} (2023-11-25)
}

\examples{
\dontshow{if (has_bluesky_pass() & has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_repost('https://bsky.app/profile/bskyr.bsky.social/post/3kf2577exva2x')
\dontshow{\}) # examplesIf}
}
\concept{record}
