% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simdata.R
\name{simdata}
\alias{simdata}
\title{Simulated data}
\usage{
simdata(
  paths = list(3:4, 4:5),
  blocks = list(1:3, 4:7, 8:10, 11:16, 17:21),
  sigma2 = runif(Nv, 0.1, 0.9),
  exogenous = list(1:2),
  beta = list(c(1, -0.5), c(-1, 0.5)),
  gamma0 = list(c(1.5)),
  gamma = list(c(0.5, -1)),
  tau2 = list(c(0.49)),
  Nv = 21,
  Ne = 30,
  Nna = 0,
  save = FALSE,
  name = "dt"
)
}
\arguments{
\item{paths}{list referring to the inner model paths; a list of integers referring to the scores relationship; the jth first latent variable are explained}

\item{blocks}{list of integers in 1:ncol(data) indicating the manisfest variables corresponding to each block}

\item{sigma2}{outer model error variances}

\item{exogenous, }{minimum color range (might cause blank spots if misspecified)}

\item{beta}{inner paths regression coefficients}

\item{gamma0}{inner exogenous intercept}

\item{gamma}{inner exogenous regression coefficients}

\item{tau2}{inner exogenous error variance}

\item{Nv}{number of endogenous variables in the database (default = 21)}

\item{Ne}{number of sample elements in the database (default = 30)}

\item{Nna}{number of missing observations in each database (default = 0)}

\item{save}{logical (default = FALSE); whether to save in the local filepath}

\item{name}{rdata name used if save = TRUE}
}
\description{
Function to generate artificial data from a structural equation model
}
\examples{

dt <- bsem::simdata()

arrayplot(dt$real$alpha)
arrayplot(dt$real$alpha, colors = 0)
arrayplot(dt$real$alpha, colors = 1)
arrayplot(dt$real$alpha, -4, 4)

}
\seealso{
\code{\link[bsem]{plot.bsem}}, \code{\link[bsem]{sem}}, \code{\link[bsem]{arrayplot}}, \code{\link[bsem]{summary.bsem}}, \code{\link[bsem]{print.bsem}}
}
