% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR-stats_5_advance.R
\name{granger_causality}
\alias{granger_causality}
\title{Granger causality test (multivariate).}
\usage{
granger_causality(
  varmodel,
  var.y = NULL,
  var.x = NULL,
  test = c("F", "Chisq"),
  file = NULL,
  check.dropped = FALSE
)
}
\arguments{
\item{varmodel}{VAR model fitted using the \code{\link[vars:VAR]{vars::VAR()}} function.}

\item{var.y, var.x}{[Optional] Defaults to \code{NULL} (all variables).
If specified, then perform tests for specific variables.
Values can be a single variable (e.g., \code{"X"}),
a vector of variables (e.g., \code{c("X1", "X2")}),
or a string containing regular expression (e.g., \code{"X1|X2"}).}

\item{test}{\emph{F} test and/or Wald \eqn{\chi}^2 test. Defaults to both: \code{c("F", "Chisq")}.}

\item{file}{File name of MS Word (\code{.doc}).}

\item{check.dropped}{Check dropped variables. Defaults to \code{FALSE}.}
}
\value{
A data frame of results.
}
\description{
Granger test of predictive causality (between multivariate time series)
based on vector autoregression (\code{\link[vars:VAR]{VAR}}) model.
Its output resembles the output of the \code{vargranger}
command in Stata (but here using an \emph{F} test).
}
\details{
Granger causality test (based on VAR model) examines whether
the lagged values of a predictor (or predictors)
help to predict an outcome when controlling for
the lagged values of the outcome itself.

Granger causality does not necessarily constitute a true causal effect.
}
\examples{
\dontrun{

  # R package "vars" should be installed
  library(vars)
  data(Canada)
  VARselect(Canada)
  vm = VAR(Canada, p=3)
  model_summary(vm)
  granger_causality(vm)
}

}
\seealso{
\code{\link{ccf_plot}},
\code{\link{granger_test}}
}
