% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR.R
\docType{package}
\name{bruceR-package}
\alias{bruceR-package}
\alias{bruceR}
\title{bruceR: \strong{BR}oadly \strong{U}seful \strong{C}onvenient and \strong{E}fficient \strong{R} functions}
\description{
\strong{BR}oadly
\strong{U}seful
\strong{C}onvenient
and
\strong{E}fficient
\strong{R}
functions that
\strong{BR}ing
\strong{U}sers
\strong{C}oncise
and
\strong{E}legant
\strong{R}
data analyses.

Package homepage: \url{https://psychbruce.github.io/bruceR/}

Install the latest \href{https://github.com/psychbruce/bruceR}{development version}
from GitHub:
\code{devtools::install_github("psychbruce/bruceR")}

Report bugs at \href{https://github.com/psychbruce/bruceR/issues}{GitHub Issues}.
}
\details{
Loading \code{bruceR} by \code{library(bruceR)} will also load these R packages for you:

\strong{[Data]:}
\itemize{
  \item \strong{\code{dplyr}}: Data manipulation and processing.
  \item \strong{\code{tidyr}}: Data cleaning and reshaping.
  \item \strong{\code{stringr}}: Toolbox for string operation (with regular expressions).
  \item \strong{\code{forcats}}: Toolbox for factor manipulation (for categorical variables).
  \item \strong{\code{data.table}}: Advanced \code{data.frame} with higher efficiency.
}

\strong{[Stat]:}
\itemize{
  \item \strong{\code{emmeans}}: Estimates of marginal means and multiple contrasts.
  \item \strong{\code{effectsize}}: Estimates of effect sizes and standardized parameters.
  \item \strong{\code{performance}}: Estimates of regression models performance.
  \item \strong{\code{lmerTest}}: Tests of linear mixed effects models (LMM, also known as HLM and multilevel models).
}

\strong{[Plot]:}
\itemize{
  \item \strong{\code{ggplot2}}: Data visualization.
  \item \strong{\code{ggtext}}: Markdown/HTML rich text format for \code{ggplot2} (geoms and themes).
  \item \strong{\code{cowplot}}: Advanced toolbox for \code{ggplot2} (arrange multiple plots and add labels).
  \item \strong{\code{see}}: Advanced toolbox for \code{ggplot2} (geoms, scales, themes, and color palettes).
}
}
\section{Main Functions in \code{bruceR}}{


\describe{
  \item{\strong{(1) Basic R Programming}}{
      \code{\link{set.wd}} (alias: \code{\link{set_wd}})

      \code{\link{import}},
      \code{\link{export}}

      \code{\link{cc}}

      \code{\link{pkg_depend}},
      \code{\link{pkg_install_suggested}}

      \code{\link{formatF}},
      \code{\link{formatN}}

      \code{\link{print_table}}

      \code{\link{Print}},
      \code{\link{Glue}},
      \code{\link{Run}}

      \code{\link{\%^\%}}

      \code{\link{\%notin\%}}

      \code{\link{\%allin\%}},
      \code{\link{\%anyin\%}},
      \code{\link{\%nonein\%}},
      \code{\link{\%partin\%}}
  }

  \item{\strong{(2) Multivariate Computation}}{
      \code{\link{add}},
      \code{\link{added}}

      \code{\link{.sum}},
      \code{\link{.mean}}

      \code{\link{SUM}},
      \code{\link{MEAN}},
      \code{\link{STD}},
      \code{\link{MODE}},
      \code{\link{COUNT}},
      \code{\link{CONSEC}}

      \code{\link{RECODE}},
      \code{\link{RESCALE}}

      \code{\link{LOOKUP}}
  }

  \item{\strong{(3) Reliability and Factor Analyses}}{
      \code{\link{Alpha}}

      \code{\link{EFA}} / \code{\link{PCA}}

      \code{\link{CFA}}
  }

  \item{\strong{(4) Descriptive Statistics and Correlation Analyses}}{
      \code{\link{Describe}}

      \code{\link{Freq}}

      \code{\link{Corr}}

      \code{\link{cor_diff}}

      \code{\link{cor_multilevel}}
  }

  \item{\strong{(5) T-Test, Multi-Factor ANOVA, Simple-Effect Analysis, and Post-Hoc Multiple Comparison}}{
      \code{\link{TTEST}}

      \code{\link{MANOVA}}

      \code{\link{EMMEANS}}
  }

  \item{\strong{(6) Tidy Report of Regression Models}}{
      \code{\link{model_summary}}

      \code{\link{lavaan_summary}}

      \code{\link{GLM_summary}}

      \code{\link{HLM_summary}}

      \code{\link{HLM_ICC_rWG}}

      \code{\link{regress}}
  }

  \item{\strong{(7) Mediation and Moderation Analyses}}{
      \code{\link{PROCESS}}

      \code{\link{med_summary}}
  }

  \item{\strong{(8) Additional Toolbox for Statistics and Graphics}}{
      \code{\link{grand_mean_center}}

      \code{\link{group_mean_center}}

      \code{\link{ccf_plot}}

      \code{\link{granger_test}}

      \code{\link{granger_causality}}

      \code{\link{theme_bruce}}

      \code{\link{show_colors}}
  }
}
}

\author{
\href{https://psychbruce.github.io}{Han-Wu-Shuang (Bruce) Bao}
}
