% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_generics.R
\name{boot_glance}
\alias{boot_glance}
\title{Bootstrapped dataframe with model summaries from each sample.}
\usage{
boot_glance(data, times = 25, strata = NULL, apparent = FALSE, ..f,
  ...)
}
\arguments{
\item{data}{Dataframe (or tibble) from which variables are to be taken.}

\item{times}{The number of bootstrap samples.}

\item{strata}{A variable that is used to conduct stratified sampling. When not \code{NULL}, each bootstrap sample is created within the stratification variable.}

\item{apparent}{A logical. Should an extra resample be added where the analysis and holdout subset are the entire data set. This is required for some estimators used by the \code{summary} function that require the apparent error rate.}

\item{..f}{A function, or function name as a string.}

\item{...}{Arguments to function.

These dots support \link{tidy-dots} features.}
}
\description{
Bootstrapped dataframe with model summaries from each sample.
}
\section{Methods}{


\Sexpr[stage=render,results=rd]{generics:::methods_rd("glance")}

}

\examples{
set.seed(123)

# example-1: linear model
broomExtra::boot_glance(
  data = mtcars,
  times = 500,
  ..f = stats::lm,
  formula = mpg ~ wt,
  na.action = na.omit
)

# example-2: linear mixed-effects model
library(lme4)

broomExtra::boot_glance(
  data = sleepstudy,
  times = 25,
  ..f = lme4::lmer,
  formula = Reaction ~ Days + (Days | Subject)
)
}
\author{
Indrajeet Patil
}
