% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auc-tidiers.R
\name{tidy.roc}
\alias{tidy.roc}
\alias{auc_tidiers}
\alias{roc_tidiers}
\title{Tidy a(n) roc object}
\usage{
\method{tidy}{roc}(x, ...)
}
\arguments{
\item{x}{An \code{roc} object returned from a call to \code{\link[AUC:roc]{AUC::roc()}}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\examples{

library(AUC)
data(churn)
r <- roc(churn$predictions, churn$labels)

td <- tidy(r)
td

library(ggplot2)

ggplot(td, aes(fpr, tpr)) +
  geom_line()

# compare the ROC curves for two prediction algorithms

library(dplyr)
library(tidyr)

rocs <- churn \%>\%
  pivot_longer(contains("predictions"),
    names_to = "algorithm",
    values_to = "value"
  ) \%>\%
  nest(data = -algorithm) \%>\%
  mutate(tidy_roc = purrr::map(data, ~ tidy(roc(.x$value, .x$labels)))) \%>\%
  unnest(tidy_roc)

ggplot(rocs, aes(fpr, tpr, color = algorithm)) +
  geom_line()
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[AUC:roc]{AUC::roc()}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{cutoff}{The cutoff used for classification. Observations with predicted probabilities above this value were assigned class 1, and observations with predicted probabilities below this value were assigned class 0.}
  \item{fpr}{False positive rate.}
  \item{tpr}{The true positive rate at the given cutoff.}

}
