% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmisc-tidiers.R
\name{tidy.rcorr}
\alias{tidy.rcorr}
\alias{rcorr_tidiers}
\alias{Hmisc_tidiers}
\title{Tidy a(n) rcorr object}
\usage{
\method{tidy}{rcorr}(x, diagonal = FALSE, ...)
}
\arguments{
\item{x}{An \code{rcorr} object returned from \code{\link[Hmisc:rcorr]{Hmisc::rcorr()}}.}

\item{diagonal}{Logical indicating whether or not to include diagonal
elements of the correlation matrix, or the correlation of a column with
itself. For the elements, \code{estimate} is always 1 and \code{p.value} is always
\code{NA}. Defaults to \code{FALSE}.}

\item{...}{Additional arguments. Not used. Needed to match generic
signature only. \strong{Cautionary note:} Misspelled arguments will be
absorbed in \code{...}, where they will be ignored. If the misspelled
argument has a default value, the default value will be used.
For example, if you pass \code{conf.lvel = 0.9}, all computation will
proceed using \code{conf.level = 0.95}. Additionally, if you pass
\code{newdata = my_tibble} to an \code{\link[=augment]{augment()}} method that does not
accept a \code{newdata} argument, it will use the default value for
the \code{data} argument.}
}
\description{
Tidy summarizes information about the components of a model.
A model component might be a single term in a regression, a single
hypothesis, a cluster, or a class. Exactly what tidy considers to be a
model component varies across models but is usually self-evident.
If a model has several distinct types of components, you will need to
specify which components to return.
}
\details{
Suppose the original data has columns A and B. In the correlation
matrix from \code{rcorr} there may be entries for both the \code{cor(A, B)} and
\code{cor(B, A)}. Only one of these pairs will ever be present in the tidy
output.
}
\examples{

library(Hmisc)

mat <- replicate(52, rnorm(100))
# add some NAs
mat[sample(length(mat), 2000)] <- NA
# also column names
colnames(mat) <- c(LETTERS, letters)

rc <- rcorr(mat)

td <- tidy(rc)
td

library(ggplot2)
ggplot(td, aes(p.value)) +
  geom_histogram(binwidth = .1)

ggplot(td, aes(estimate, p.value)) +
  geom_point() +
  scale_y_log10()
}
\seealso{
\code{\link[=tidy]{tidy()}}, \code{\link[Hmisc:rcorr]{Hmisc::rcorr()}}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with columns:
  \item{column1}{Name or index of the first column being described.}
  \item{column2}{Name or index of the second column being described.}
  \item{estimate}{The estimated value of the regression term.}
  \item{p.value}{The two-sided p-value associated with the observed statistic.}
  \item{n}{Number of observations used to compute the correlation}

}
