% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/psych_tidiers.R
\name{kappa_tidiers}
\alias{kappa_tidiers}
\alias{tidy.kappa}
\title{Tidy a kappa object from a Cohen's kappa calculation}
\usage{
\method{tidy}{kappa}(x, ...)
}
\arguments{
\item{x}{An object of class "kappa"}

\item{...}{extra arguments (not used)}
}
\value{
A data.frame with columns
  \item{type}{Either "weighted" or "unweighted"}
  \item{estimate}{The estimated value of kappa with this method}
  \item{conf.low}{Lower bound of confidence interval}
  \item{conf.high}{Upper bound of confidence interval}
}
\description{
Tidy a "kappa" object, from the \code{\link{cohen.kappa}} function
in the psych package. This represents the agreement of two raters
when using nominal scores.
}
\details{
Note that the alpha of the confidence interval is determined
when the \code{cohen.kappa} function is originally run.
}
\examples{
library(psych)

rater1 = 1:9
rater2 = c(1, 3, 1, 6, 1, 5, 5, 6, 7)
ck <- cohen.kappa(cbind(rater1, rater2))

tidy(ck)

# graph the confidence intervals
library(ggplot2)
ggplot(tidy(ck), aes(estimate, type)) +
    geom_point() +
    geom_errorbarh(aes(xmin = conf.low, xmax = conf.high))
}
\seealso{
\code{\link{cohen.kappa}}
}

