% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permtest.R
\name{paired.perm.test}
\alias{paired.perm.test}
\title{Paired permutation t-test}
\usage{
paired.perm.test(d, n.perm = NULL, pval = TRUE)
}
\arguments{
\item{d}{A numeric vector (of differences).}

\item{n.perm}{Number of permutations to perform.  If NULL, all
possible permutations are considered, and an exact p-value is
calculated.}

\item{pval}{If TRUE, return just the p-value.  If FALSE, return the
actual permutation results (with the observed statistic as an
attribute, \code{"tobs"}).}
}
\value{
If \code{pval=TRUE}, the output is a single number: the P-value
  testing for the symmetry about 0 of the distribution of the population
  from which \code{d} was drawn.
  If \code{pval=FALSE}, the output is a vector of the t statistics from
  the permutations.  An attributed \code{"tobs"} contains the t
  statistic with the observed data.
}
\description{
Calculates a p-value for a paired t-test via permutations.
}
\details{
This calls the function \code{\link[stats]{t.test}} to calculate a
  t-statistic comparing the mean of \code{d} to 0.  Permutations
  are perfomed to give an exact or approximate conditional p-value.
}
\examples{
x <- c(43.3, 57.1, 35.0, 50.0, 38.2, 31.2)
y <- c(51.9, 95.1, 90.0, 49.7, 101.5, 74.1)
paired.perm.test(x-y)

}
\seealso{
\code{\link[stats]{t.test}}, \code{\link{perm.test}}
}
\keyword{htest}
