% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratify-keys.R
\name{stratify_keys}
\alias{stratify_keys}
\title{Stratify the keys into groups to facilitate exploration}
\usage{
stratify_keys(.data, n_strata, along = NULL, fun = mean, ...)
}
\arguments{
\item{.data}{data.frame to explore}

\item{n_strata}{number of groups to create}

\item{along}{variable to stratify along. This groups by each \code{key} and then
takes a summary statistic (by default, the mean). It then arranges by the
mean value for each \code{key} and assigns the \code{n_strata} groups.}

\item{fun}{summary function. Default is mean.}

\item{...}{extra arguments}
}
\value{
data.frame with column, \code{.strata} containing \code{n_strata} groups
}
\description{
To look at as much of the raw data as possible, it can be helpful to
stratify the data into groups for plotting. You can \code{stratify} the
\code{keys} using the \code{stratify_keys()} function, which adds the column,
\code{.strata}. This allows the user to create facetted plots showing a more
of the raw data.
}
\examples{
library(ggplot2)
library(brolgar)

heights \%>\%
  sample_frac_keys(size = 0.1) \%>\%
  stratify_keys(10) \%>\%
 ggplot(aes(x = height_cm,
            y = year,
            group = country)) + 
 geom_line() + 
 facet_wrap(~.strata)
 
 # now facet along some feature
library(dplyr)
 heights \%>\%
key_slope(height_cm ~ year) \%>\%
  right_join(heights, ., by = "country") \%>\%
  stratify_keys(n_strata = 12,
                along = .slope_year,
                fun = median) \%>\%
  ggplot(aes(x = year,
             y = height_cm,
             group = country)) + 
  geom_line() + 
  facet_wrap(~.strata)


heights \%>\%
  stratify_keys(n_strata = 12,
                along = height_cm) \%>\%
  ggplot(aes(x = year,
             y = height_cm,
             group = country)) + 
  geom_line() + 
  facet_wrap(~.strata)
}
