% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_multiple.R
\name{brm_multiple}
\alias{brm_multiple}
\title{Run the same \pkg{brms} model on multiple datasets}
\usage{
brm_multiple(formula, data, combine = TRUE, ...)
}
\arguments{
\item{formula}{An object of class 
\code{\link[stats:formula]{formula}},
\code{\link{brmsformula}}, or \code{\link{mvbrmsformula}}
(or one that can be coerced to that classes): 
A symbolic description of the model to be fitted. 
The details of model specification are explained in 
\code{\link{brmsformula}}.}

\item{data}{A list of data.frames each of which will
be used to fit a separate model. Alternatively, a 
\code{mids} object from the \pkg{mice} package.}

\item{combine}{Logical; Indicates if the fitted models
should be combined into a single fitted model object
via \code{\link{combine_models}}. Defaults to \code{TRUE}.}

\item{...}{Further arguments passed to \code{\link{brm}}.}
}
\value{
If \code{combine = TRUE} a \code{brmsfit_multiple} object,
which inherits from class \code{brmsfit} and behaves essentially 
the same. If \code{combine = FALSE} a list of \code{brmsfit} objects.
}
\description{
Run the same \pkg{brms} model on multiple datasets and
then combine the results into one fitted model object. 
This is useful in particular for multiple missing value imputation,
where the same model is fitted on multiple imputed data sets.
}
\details{
The combined model may issue false positive 
convergence warnings, as the MCMC chains corresponding
to different datasets may not necessarily overlap, even 
if each of the original models did converge.
To find out whether each of the original models converged,
investigate \code{fit$rhats}, where \code{fit} 
denotes the output of \code{brm_multiple}.
}
\examples{
\dontrun{
library(mice)
imp <- mice(nhanes2)

# fit the model using mice and lm
fit_imp1 <- with(lm(bmi~age+hyp+chl), data = imp)
summary(pool(fit_imp1))

# fit the model using brms
fit_imp2 <- brm_multiple(bmi~age+hyp+chl, data = imp, chains = 1)
summary(fit_imp2)
plot(fit_imp2, pars = "^b_")
# investigate convergence of the original models
fit_imp2$rhats
}

}
