% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-helpers.R
\name{me}
\alias{me}
\title{Predictors with Measurement Error in \pkg{brms} Models}
\usage{
me(x, sdx = NULL)
}
\arguments{
\item{x}{The variable measured with error.}

\item{sdx}{Known measurement error of \code{x}
treated as standard deviation.}
}
\description{
Predictors with Measurement Error in \pkg{brms} Models
}
\details{
For detailed documentation see \code{help(brmsformula)}. 

This function is almost solely useful when
called in formulas passed to the \pkg{brms} package.
}
\examples{
\dontrun{
# sample some data
N <- 100
dat <- data.frame(y = rnorm(N), x = rnorm(N), sdx = abs(rnorm(N, 1)))
# fit a simple error-in-variables model 
fit <- brm(y ~ me(x, sdx), data = dat, save_mevars = TRUE)
summary(fit)
} 

}
\seealso{
\code{\link{brmsformula}}
}
