% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{predict.brmsfit}
\alias{predict.brmsfit}
\title{Model Predictions of \code{brmsfit} Objects}
\usage{
\method{predict}{brmsfit}(object, newdata = NULL, re_formula = NULL,
  transform = NULL, allow_new_levels = FALSE, summary = TRUE,
  probs = c(0.025, 0.975), ...)
}
\arguments{
\item{object}{An object of class \code{brmsfit}}

\item{newdata}{An optional data.frame containing new data to make predictions for.
If \code{NULL} (default), the data used to fit the model is applied.}

\item{re_formula}{formula containing random effects to be considered in the prediction.
If \code{NULL} (default), include all random effects; if \code{NA}, include no random effects.
Other options will be implemented in the future.}

\item{transform}{A function or a character string naming a function to be applied on the predicted responses
before summary statistics are computed.}

\item{allow_new_levels}{Currenly, \code{FALSE} (no new levels allowed) is the only option. This will change in
future versions of the package.}

\item{summary}{logical. Should summary statistics (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values. Default is \code{TRUE}}

\item{probs}{The percentiles to be computed by the \code{quantile} function.
Only used if \code{summary} is \code{TRUE}.}

\item{...}{Currently ignored}
}
\value{
Predicted values of the response variable. If \code{summary = TRUE} the output depends on the family:
  For catagorical and ordinal families, it is a N x C matrix where N is the number of observations and
  C is the number of categories. For all other families, it is a N x E matrix where E is equal to \code{length(probs) + 2}.
  If \code{summary = FALSE}, the output is as a S x N matrix, where S is the number of samples.
}
\description{
Make predictions based on the fitted model parameters.
Can be performed for the data used to fit the model (posterior predictive checks) or for new data.
}
\details{
Be careful when using \code{newdata} with factors in fixed or random effects:
 The predicted results are only valid if all factor levels present in the initial
 data are also defined and ordered correctly for the factors in \code{newdata}.
 Grouping factors may contain fewer levels than in the inital data without causing problems.
}
\examples{
\dontrun{
## fit a model
fit <- brm(time | cens(censored) ~ age + sex, data = kidney,
           family = "exponential", silent = TRUE)

## posterior predictive checks
pp <- predict(fit)
head(pp)

## predict response for new data (be careful with factors)
newdata <- data.frame(sex = factor(c("male", "female"),
                                   levels = c("male", "female")),
                      age = c(20,50))
predict(fit, newdata = newdata)
}
}

