% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_transform_marginal.R
\name{summary.brms_mmrm_transform_marginal}
\alias{summary.brms_mmrm_transform_marginal}
\title{Summarize marginal transform.}
\usage{
\method{summary}{brms_mmrm_transform_marginal}(object, message = TRUE, ...)
}
\arguments{
\item{object}{The \code{\link[=brm_transform_marginal]{brm_transform_marginal()}} matrix to summarize.}

\item{message}{TRUE to print an informative message about the archetype
and invisibly return a character vector of equations. \code{FALSE}
to forgo verbose messages and non-invisibly return the equations.}

\item{...}{Not used, but required for S3 methods that inherit from
the base generic \code{\link[=summary]{summary()}}.}
}
\value{
Return a character vector with linear equations
that map model parameters to marginal means. If the \code{message}
argument is \code{TRUE} (default) then this character vector is returned
invisibly and a verbose description of the equations is printed.
}
\description{
Summarize a transformation from model parameters to
marginal means.
}
\examples{
set.seed(0L)
data <- brm_data(
  data = brm_simulate_simple()$data,
  outcome = "response",
  group = "group",
  time = "time",
  patient = "patient",
  reference_group = "group_1",
  reference_time = "time_1"
)
formula <- brm_formula(
  data = data,
  baseline = FALSE,
  baseline_time = FALSE
)
transform <- brm_transform_marginal(data = data, formula = formula)
equations <- summary(transform)
print(equations)
summary(transform, message = FALSE)
class(transform)
print(transform)
}
\keyword{internal}
