% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_simulate.R
\name{brm_simulate}
\alias{brm_simulate}
\title{Simulate an MMRM.}
\usage{
brm_simulate(
  n_group = 2L,
  n_patient = 100L,
  n_time = 4L,
  hyper_beta = 1,
  hyper_sigma = 1,
  hyper_correlation = 1
)
}
\arguments{
\item{n_group}{Positive integer of length 1, number of treatment groups.}

\item{n_patient}{Positive integer of length 1, number of patients
per treatment group.}

\item{n_time}{Positive integer of length 1, number of discrete
time points (e.g. scheduled study visits) per patient.}

\item{hyper_beta}{Positive numeric of length 1, hyperparameter.
Prior standard deviation of the fixed effect parameters.}

\item{hyper_sigma}{Positive numeric of length 1, hyperparameter.
Uniform prior upper bound of the time-specific residual
standard deviation parameters.}

\item{hyper_correlation}{Positive numeric of length 1, hyperparameter.
LKJ shape parameter of the correlation matrix among repeated
measures within each patient.}
}
\value{
A list of three objects:
\itemize{
\item \code{data}: A tidy dataset with one row per patient per discrete
time point and columns for the response and covariates.
\item \code{model_matrix}: A matrix with one row per row of \code{data} and columns
that represent levels of the covariates.
\item \code{parameters}: A named list of parameter values sampled from the prior.
}
}
\description{
Simulate a dataset from a basic MMRM.
}
\details{
First, a sample of parameters is drawn from the prior
distribution. Then, a set of data is drawn from the data model
conditional on the sample of parameters.
In this initial implementation, the simulation is simple. The only
covariates are treatment group and discrete time,
there are no dropouts, and the
parameterization is not the same as that of \code{brms}.
}
\examples{
set.seed(0L)
simulation <- brm_simulate()
simulation$data
}
\concept{simulation}
