% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brm_plot_draws.R
\name{brm_plot_draws}
\alias{brm_plot_draws}
\title{Visualize posterior draws of marginals.}
\usage{
brm_plot_draws(draws)
}
\arguments{
\item{draws}{A data frame of draws from an element of
the output list of \code{\link[=brm_marginal_summaries]{brm_marginal_summaries()}}.}
}
\value{
A \code{ggplot} object.
}
\description{
Visualize posterior draws of marginals.
}
\examples{
if (identical(Sys.getenv("BRM_EXAMPLES", unset = ""), "true")) {
set.seed(0L)
data <- brm_data(
  data = brm_simulate()$data,
  outcome = "response",
  role = "response",
  group = "group",
  time = "time",
  patient = "patient"
)
formula <- brm_formula(
  data = data,
  effect_base = FALSE,
  interaction_base = FALSE
)
tmp <- utils::capture.output(
  suppressMessages(
    suppressWarnings(
      model <- brm_model(
        data = data,
        formula = formula,
        chains = 1,
        iter = 100,
        refresh = 0
      )
    )
  )
)
draws <- brm_marginal_draws(
  model = model,
  data = data,
  control = "group 1",
  baseline = "time 1"
)
brm_plot_draws(draws = draws$change)
}
}
\seealso{
Other visualization: 
\code{\link{brm_plot_compare}()}
}
\concept{visualization}
