% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProbScalarRR.R
\name{getProbScalarRR}
\alias{getProbScalarRR}
\title{Calculate risks from log RR and log OP}
\usage{
getProbScalarRR(logrr, logop = NA)
}
\arguments{
\item{logrr}{log of relative risk}

\item{logop}{log of odds product}
}
\value{
a vector \eqn{(P(y=1|x=0),P(y=1|x=1))}
}
\description{
Calculate risks from log RR and log OP
}
\details{
The \eqn{log OP} is defined as \eqn{log OP = log[(P(y=1|x=0)/P(y=0|x=0))*(P(y=1|x=1)/P(y=0|x=1))]}.
}
\examples{
getProbScalarRR(0,0)

set.seed(0)
logrr = rnorm(10,0,1)
logop = rnorm(10,0,1)
probs = mapply(getProbScalarRR, logrr, logop)
rownames(probs) = c("P(y=1|x=0)","P(y=1|x=1)")
probs

}

