% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Individuals-Methods.R
\docType{methods}
\name{Individuals plot}
\alias{Individuals plot}
\alias{plot,Individuals,ANY-method}
\alias{plot,Individuals,numeric-method}
\alias{plot,Individuals,num-method}
\title{Plot method for Individuals-class}
\usage{
\S4method{plot}{Individuals,ANY}(x, y, add = F, ..., plot.legend = TRUE)

\S4method{plot}{Individuals,numeric}(x, y, add = F, ..., plot.legend = TRUE)
}
\arguments{
\item{x}{An Individuals object}

\item{y}{time of the simulation to display individuals}

\item{add}{if True the new plot will overlap an already plot image (default False)}

\item{...}{further graphical parameters (\code{par})}

\item{plot.legend}{plot legend (default TRUE)}
}
\description{
Will plot \link{Individuals} spatial positions.

Will plot individuals positions and state at a time of the simulation.
}
\details{
The states correspond to internal concentration of toxic.
"Red" cross means that the individual is dead because of toxic exposition.
"Green" cross means that the individual is dead by natural death.
"Green" to "Red" points give the gradient of toxic concentration before the threshold.
}
\examples{
data(maize_65)
plot(maize.individuals)
data(maize_65)
# individuals locations
plot(maize.individuals)
# individuals at time 61
plot(maize.individuals,61)
#individuals at time 61 with the landscape
plot(maize.landscape,maize.individuals,time=61)
}
