% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brif.R
\name{brifTree}
\alias{brifTree}
\title{Build a single brif tree of a given depth}
\usage{
brifTree(x, ...)
}
\arguments{
\item{x}{a data frame or a \code{\link[stats]{formula}} object.}

\item{...}{arguments passed on to \code{\link{brifTree.formula}} or \code{\link{brifTree.default}}.}
}
\value{
an object of class \code{brif}. See \code{\link{brif.default}} for details.
}
\description{
This is a wrapper for \code{\link[brif]{brif}} to build a single tree of a given depth. See \code{\link[brif]{brifTree.default}} and \code{\link[brif]{brifTree.formula}} for details.
}
\examples{
# Build a single tree
bt <- brifTree(Species ~., data = iris, depth = 3)

# Print out the decision rules
printRules(bt)

# Get the accuracy on the training set
sum(predict(bt, newdata = iris, type = 'class') == iris[,'Species'])/nrow(iris)

}
